/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "singit_debug.h"

#include "singit/config_xmms.h"
#include "singit_tools.h"

static GtkObjectClass *parent_class = NULL;

static void singit_config_xmms_class_init (SingitConfigXMMSClass *klass);
static void singit_config_xmms_init (SingitConfigXMMS *scx);
static void singit_config_xmms_destroy(GtkObject *object);

static SCGFile singit_config_xmms_open
	(SingitConfigGen *scg, const gchar* filename);
static void singit_config_xmms_close
	(SingitConfigGen *scg, SCGFile file, const gchar* filename);

GtkType singit_config_xmms_get_type (void)
{
	static GtkType singit_config_xmms_type = 0;

	if (!singit_config_xmms_type) {

		static const GtkTypeInfo singit_config_xmms_info =
		{
			(gchar*) "SingitConfigXMMS",
			sizeof (SingitConfigXMMS),
			sizeof (SingitConfigXMMSClass),
			(GtkClassInitFunc) singit_config_xmms_class_init,
			(GtkObjectInitFunc) singit_config_xmms_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		singit_config_xmms_type =
			gtk_type_unique(TYPE_SINGIT_CONFIG_GEN,
				&singit_config_xmms_info);
	}

	return singit_config_xmms_type;
}

static void singit_config_xmms_class_init (SingitConfigXMMSClass *klass)
{
	GtkObjectClass *object_klass = (GtkObjectClass*) klass;
	SingitConfigGenClass *scg_klass = (SingitConfigGenClass*) klass;

	parent_class = gtk_type_class(TYPE_SINGIT_CONFIG_GEN);

	object_klass->destroy = singit_config_xmms_destroy;

	scg_klass->open = singit_config_xmms_open;
	scg_klass->close = singit_config_xmms_close;
}

static void singit_config_xmms_init (SingitConfigXMMS *scx)
{
}

static void singit_config_xmms_destroy (GtkObject *object)
{
}

SingitConfigGen *singit_config_xmms_new(void)
{
	return SINGIT_CONFIG_GEN(gtk_type_new(TYPE_SINGIT_CONFIG_XMMS));
}

static SCGFile singit_config_xmms_open(SingitConfigGen *scg, const gchar* filename)
{
	SCGFile file = NULL;

	g_return_val_if_fail (singit_config_gen_attach(scg), NULL);

#ifdef CODEDEBUG
	DEBUG(8, ("singit_config_xmms.c [singit_config_xmms_open] : "));
#endif

	if (filename == NULL)
		{ goto detach; }

	file = xmms_cfg_open_file((gchar*) filename);
	if (!file && (scg->create_new == TRUE)) {
		if (create_abs_path(g_dirname(filename),
			S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH) == TRUE)
		{
			file = xmms_cfg_new();
			if (xmms_cfg_write_file
				((ConfigFile*) file, (gchar*) filename) == FALSE)
			{
				singit_config_gen_set_error_code(scg, SCGS_FILE_FAIL);
				xmms_cfg_free(file);
				file = NULL;
			}
		}
		else
			singit_config_gen_set_error_code(scg, SCGS_DIR_FAIL);
	}

#ifdef CODEDEBUG
	DEBUG(8, ("Ok\n"));
#endif

detach:
	singit_config_gen_detach(&scg);

	return file;
}

static void singit_config_xmms_close(SingitConfigGen *scg,
	SCGFile file, const gchar* filename)
{
	g_return_if_fail (singit_config_gen_attach(scg));

#ifdef CODEDEBUG
	DEBUG(8, ("singit_config_xmms.c [singit_config_xmms_close] : "));
#endif

	if (scg->config_file == NULL) {
#ifdef CODEDEBUG
		DEBUG(8, ("Failed\n"));
#endif
		singit_config_gen_set_error_code(scg, SCGS_NO_CFG);
		goto detach_config;
	}

	xmms_cfg_write_file(file, (gchar*) filename);
	xmms_cfg_free(scg->config_file);
	scg->config_file = NULL;

detach_config:
	singit_config_gen_detach(&scg);

#ifdef CODEDEBUG
	DEBUG(8, ("Ok\n"));
#endif
}


#include <gdk/gdk.h>

#include "singit/config_xmms.h"

gboolean xmms_cfg_read_color(ConfigFile *cfg, gchar *section, gchar *key, gchar **color_str)
{
	GdkColor color;
	gboolean result = FALSE;
	if (xmms_cfg_read_string(cfg, section, key, color_str))
	{
		result = gdk_color_parse(*color_str, &color);
		if (result == FALSE) {
			g_free(*color_str);
			*color_str = NULL;
		}
	}
	return result;
}

void xmms_cfg_write_del_string(ConfigFile *cfg, gchar *section, gchar* entry, gchar *value)
{
	if (value == NULL) { xmms_cfg_remove_key(cfg, section, entry); }
	else { xmms_cfg_write_string(cfg, section, entry, value); }
}
