
/*
** OIDS.H
**
** Header file for Xoids.
**
** Tim Ebling
** tebling@oce.orst.edu
**
*/

/*
 * standard colour indices
 */
#define	BLACK		0
#define	RED		1
#define	GREEN		2
#define	YELLOW		3
#define	BLUE		4
#define	MAGENTA		5
#define	CYAN		6
#define	WHITE		7


/*
 * How to convert degrees to radians
 */
#ifndef PI
#define	PI	3.14159265358979
#endif

#define D2R	(PI / 180.0)


#define WINDOW_HEIGHT	800
#define WINDOW_WIDTH	960

#define MAPS_PER_360	32
#define OIDS_PER_360	32
#define OID_DIVIDE	2
#define DELTA_ANG	(2 * PI / MAPS_PER_360)

#define MAX_PLAYERS	2
#define P_MAX_SPEED	8
#define N_THRUST_PTS	3
#define HYPER_DELAY	20

#define SLURB_SPEED	4
#define H_MAX_SPEED	12
#define INIT_BIG_OIDS	3
#define MAX_BIG_OIDS	8
#define BIG_OID_ROT	10
#define BO_MAX_SPEED	5

#define MED_OID_ROT	5
#define MO_MAX_SPEED	8

#define SML_OID_ROT	2
#define SO_MAX_SPEED	10

#define NUM_SHARDS	5
#define CARNAGE_SPEED	1.5
#define CARNAGE_LIFE	100
#define DYING_TIME	15
#define DEATH_THRESH	5

#define TIMER_VAL	30
#define NUM_STARS	40
#define LINK_LENGTH	40

#define NORMAL		0
#define DYING		1
#define WARPING		2
#define REVIVING	3
#define EXPLODING	4
#define DEAD		5

#define GUN		0
#define LASER		1

#define KEY_THRUST1	0x0001
#define KEY_LEFT1	0x0002
#define KEY_RIGHT1	0x0004
#define KEY_FIRE1	0x0008
#define KEY_HYPER1	0x0010
#define KEY_THRUST2	0x0020
#define KEY_LEFT2	0x0040
#define KEY_RIGHT2	0x0080
#define KEY_FIRE2	0x0100
#define KEY_HYPER2	0x0200
#define KEY_QUIT	0x0400
#define KEY_PAUSE	0x0800
#define KEY_ESC		0x1000

#define UPARROW 1
#define DOWNARROW 2
#define LEFTARROW 3
#define RIGHTARROW 4
#define ENTER 5


/*
 * max number of characters in a font name
 */
#define	FONTNAMELEN	32

typedef struct vdev {
	char		initialised,
			clipoff,
			inobject,
			inpolygon,
			upset,			/* is up vector set */
			cpVvalid,		/* is the current device position valid */
			inbackbuffer,		/* are we in the backbuffer */
			clipplanes;		/* active clipping planes */
	void		(*pmove)(),		/* Polygon moves */
			(*pdraw)();		/* Polygon draws */
	float		hheight, hwidth;	/* hardware character height, width */
	int		depth,			/* # bit planes on screen */
			maxVx, minVx,
			maxVy, minVy,
			sizeX, sizeY, 		/* size of square on screen */
			sizeSx, sizeSy,		/* side in x, side in y (# pixels) */
			cpVx, cpVy;
} Device;

Device	vdevice;		/* device structure */



struct Shot {
	unsigned int		clock;

	int			x,
				y,
				ox,
				oy;

	int			pts_x[5],
				pts_y[5],
				num_kill_pts,
				kill_pts[2];

	float			x_vec,
				y_vec;

};

struct Wpn {

	int			pts_x[5],
				pts_y[5];

	unsigned int		max_shots,
				shot_speed,
				shot_life,
				inhibit_time,
				size,
				num_kill_pts,
				kill_pts[2];

};
	

typedef struct spr {
	unsigned int		width,
				height,
				wo2,
				ho2,
				num_members,
				num_pixmaps,
				shots,
				shot_color,
				burst_color,
				value,
				score,
				shots_fired,
				engine,
				hits,
				num_death_sprites,
				rotation,
				thrust,
				state,
				state_ctr,
				max_dying,
				max_exploding,
				bounced;

	int			rot_dir,
				curr_map,
				lives;

	float			ox,
				oy,
				x,
				y;
				
	float			x_vec,
				y_vec,
				max_speed,
				point_angle,
				delta_angle,
				mass;

	char			name[40];

	unsigned int		wpn;

	struct Shot		**S;

	char			***pixmap_data;

	Pixmap			*pixmaps,
				*clipmasks,
				*orig_pixmaps,
				*orig_clipmasks;

	struct spr		*death_sprite;
	struct spr		*next;
	struct spr		*next_draw;

	void			(*kill_func)();

} Sprite;


struct explosion {

	unsigned int		radius,
				max_radius,
				color;

	int			x,
				y,
				dir,
				x_vec,
				y_vec;

};

struct linkage {

	float			x,
				y,
				x_vec,
				y_vec,
				ang,
				ang_vec;

	unsigned int		length;

};


/* External variables */


Sprite	*P;
Sprite  *Slrb;
Sprite	*Homer;
Sprite	*Resur;
Sprite  *Big_O;
Sprite 	*Med_O[MAX_BIG_OIDS];
Sprite 	*Sml_O[MAX_BIG_OIDS * OID_DIVIDE];
Sprite  *Shrd[4];
Sprite  *Flame;
Sprite	*Power_Up;
Sprite	*Meta;

int	keyboard_state,
	goal_score;

struct explosion burst[250];

extern struct linkage link;

static struct Wpn Weapon[] = { 0, 0, 0, -2, 2,		/* Gun */
			       0, 2, -2, 0, 0,
			       6, 7, 90, 5, 2, 1, 0, 0,
			       1, 0, -1, 0, 1,		/* Laser */
			       -10, 0, -10, -11, -10,
			       9, 16, 45, 2, 10, 2, 1, 3 };

static int thrust_pts_x[] = {-5, 0, 5};
static int thrust_pts_y[] = {-11, -15, -11};

static int hot_spot_x = 0;
static int hot_spot_y = 12;

static char *mm_items[] = {	"Start One Player Game",
				"Start Two Player Duel",
				"Start Two Player Cooperative",
				"Options",
				"Quit"			};

static char *om_items[] = {	"Game Speed:",
				"Two Player Score Goal:",
				"Return to Main Menu"	};

static char *goal_str[] = {	"10,000 (Quick Fix)",
				"20,000 (A Serious Game)",
				"40,000 (Making Galactic History)",
				"100,000 (Get a Life!)"};

static int goal_array[] = { 10000, 20000, 40000, 100000 };

static int mm_num_items = 5;
static int om_num_items = 3;

float cos_table[MAPS_PER_360];
float sin_table[MAPS_PER_360];

int r_num;	/* Global random number */

int delay;	/* Main loop delay factor */

unsigned int 	timer,		/* Game countdown clock */
		shot_clock;	/* Countdown from shot fired */

XRectangle clip_rect;	/* Clipping rectangle for scoreboard */

XPoint		starfield[NUM_STARS];	/* Coordinates of stars */

unsigned int	num_bursts,	/* Number of bursts */
		num_players,	/* Number of players */
		oids_shot,	/* Number of oids currently destroyed */
		level,		/* Play level */
		warp_levels,	/* Warping to a new level? */
		extra_man_scr,	/* Score to subtract for "bonus ship"? */
		coop,		/* Flag for co-op play */
		game_over,	/* Flag for end of game */
		leave;		/* Flag to leave game loop */

 
/*
** Function prototypes
*/

void X_init_pixmaps();
char **X_rotate_pixmap_data();
char *X_rotate_bitmap();
void X_update();
void X_draw_one_object();
int X_checkkey();
int X_get_menu_keys();
int X_getkey();
void X_backbuf();
void X_frontbuf();
void X_clear();
void X_color();
void X_string();
void X_exit();
void X_spin_pixmap360();
void X_init();
void X_draw_object();
void X_draw_thrust();
void X_draw_shots();
void X_draw_bursts();
void X_copy_object_to_window();
void X_clear_object();
void X_clear_shots();
void X_draw_bursts();
void X_check_keypress();
void X_clear_one_object();
void X_flash_screen();
void X_draw_status_bar();
int X_mapcolor();
void X_swapbuf();
void X_update_status_bar();
void X_copy_status_bar_to_window();
void X_draw_stars();
void X_draw_link();
void X_clear_key_buffer();
void X_point();

void init_all_objects();
Sprite *init_object();
struct Shot **init_shots();
void create_new_shot();
Sprite *update_shots();
void erase_shot();
void update_object();
float random_num();
void rotate_oids();
Sprite *check_collision();
void explode_object();
void revive_player();
int bounce_objects();
void check_input();
void warp_object();
Sprite *shot_collide();
int simple_collision();
float speed();
void update_score();
void kill_shard();
void do_nothing_for_a_while();
void revive_oid();
void destroy_oid();
void update_bursts();
void make_burst();
void main_menu();
void draw_game_over();
void pause_game();
void test_for_aliens();
float distance();
void init_starfield();
void draw_level_warp();
void link_players();
void options_menu();
void put_inside_window();
void kill_power_up();
void destroy_object();
void destroy_homer();
void alien_lock_on();
void draw_homer_trail();
