#!/bin/ksh
# List files not used by the Xprint standalone config

list_files()
{
(
  # extras
  find \
    xc/extras/fontconfig \
    xc/extras/drm \
    xc/extras/fonts \
    -type f

  # libs
  find \
    xc/lib/FS \
    xc/lib/GLU \
    xc/lib/GLw \
    xc/lib/ICE \
    xc/lib/SM \
    xc/lib/XTrap \
    xc/lib/Xaw \
    xc/lib/Xaw6 \
    xc/lib/Xaw7 \
    xc/lib/Xcomposite \
    xc/lib/Xcursor \
    xc/lib/Xfontcache \
    xc/lib/Xft \
    xc/lib/Xft1 \
    xc/lib/Xi \
    xc/lib/Xinerama \
    xc/lib/Xmu \
    xc/lib/Xmuu \
    xc/lib/Xrandr \
    xc/lib/Xrender \
    xc/lib/Xss \
    xc/lib/Xt \
    xc/lib/Xtst \
    xc/lib/Xv \
    xc/lib/XvMC \
    xc/lib/Xxf86dga \
    xc/lib/Xxf86misc \
    xc/lib/Xxf86rush \
    xc/lib/Xxf86vm \
    xc/lib/apple \
    xc/lib/dmx \
    xc/lib/dps \
    xc/lib/dpstk \
    xc/lib/fontconfig \
    xc/lib/oldX \
    xc/lib/psres \
    xc/lib/xkbfile \
    xc/lib/xkbui \
    -type f

  find \
    xc/lib/X11 \
      -type f |
    egrep -v "/Quarks.c|/Xresource.h|/Xresinternal.h|/Xlibint.h|/Xlib.h" |
    egrep -v "/XrmI.h|/Xlcint.h|/Xrm.c"

  # programs
  find \
    xc/programs/appres \
    xc/programs/bdftopcf \
    xc/programs/beforelight \
    xc/programs/bitmap \
    xc/programs/cxpm \
    xc/programs/dpsexec \
    xc/programs/dpsinfo \
    xc/programs/editres \
    xc/programs/fc-cache \
    xc/programs/fc-lang \
    xc/programs/fc-list \
    xc/programs/fonttosfnt \
    xc/programs/fslsfonts \
    xc/programs/fstobdf \
    xc/programs/glxinfo \
    xc/programs/iceauth \
    xc/programs/ico \
    xc/programs/lbxproxy \
    xc/programs/listres \
    xc/programs/luit \
    xc/programs/makepsres \
    xc/programs/mkcfm \
    xc/programs/oclock \
    xc/programs/proxymngr \
    xc/programs/rstart \
    xc/programs/setxkbmap \
    xc/programs/showfont \
    xc/programs/smproxy \
    xc/programs/sxpm \
    xc/programs/texteroids \
    xc/programs/twm \
    xc/programs/viewres \
    xc/programs/x11perf \
    xc/programs/xauth \
    xc/programs/xbiff \
    xc/programs/xcalc \
    xc/programs/xclipboard \
    xc/programs/xclock \
    xc/programs/xcmsdb \
    xc/programs/xconsole \
    xc/programs/xcursorgen \
    xc/programs/xditview \
    xc/programs/xdm \
    xc/programs/xdpyinfo \
    xc/programs/xdriinfo \
    xc/programs/xedit \
    xc/programs/xev \
    xc/programs/xeyes \
    xc/programs/xf86dga \
    xc/programs/xfd \
    xc/programs/xfindproxy \
    xc/programs/xfontsel \
    xc/programs/xfs \
    xc/programs/xfsinfo \
    xc/programs/xfwp \
    xc/programs/xgamma \
    xc/programs/xgc \
    xc/programs/xhost \
    xc/programs/xinit \
    xc/programs/xkbcomp \
    xc/programs/xkbevd \
    xc/programs/xkbprint \
    xc/programs/xkbutils \
    xc/programs/xkill \
    xc/programs/xload \
    xc/programs/xlogo \
    xc/programs/xlsatoms \
    xc/programs/xlsclients \
    xc/programs/xlsfonts \
    xc/programs/xmag \
    xc/programs/xman \
    xc/programs/xmessage \
    xc/programs/xmh \
    xc/programs/xmodmap \
    xc/programs/xmore \
    xc/programs/xprop \
    xc/programs/xrandr \
    xc/programs/xrdb \
    xc/programs/xrefresh \
    xc/programs/xrx \
    xc/programs/xset \
    xc/programs/xsetmode \
    xc/programs/xsetpointer \
    xc/programs/xsetroot \
    xc/programs/xsm \
    xc/programs/xstdcmap \
    xc/programs/xterm \
    xc/programs/xtrap \
    xc/programs/xvidtune \
    xc/programs/xvinfo \
    xc/programs/xwininfo  \
        -type f

  # Xserver
  find \
    xc/programs/Xserver/hw/darwin \
    xc/programs/Xserver/hw/dmx \
    xc/programs/Xserver/hw/kdrive \
    xc/programs/Xserver/hw/sun \
    xc/programs/Xserver/hw/sunLynx \
    xc/programs/Xserver/hw/vfb \
    xc/programs/Xserver/hw/xfree86 \
    xc/programs/Xserver/hw/xnest \
    xc/programs/Xserver/hw/xwin \
        -type f | 
        egrep -v "/xf86_ansic.h|common/compiler.h" |
        egrep -v "/xf86_libc.h|/xf86Version.h|/xf86Date.h"

  # fonts
  find \
    xc/fonts/bdf \
    xc/fonts/scaled -type f

  # doc
  find \
    xc/doc/misc \
    xc/doc/specs \
    xc/doc/man/DMX \
    xc/doc/man/GL \
    xc/doc/man/GLU \
    xc/doc/man/GLw \
    xc/doc/man/X11 \
    xc/doc/man/Xau \
    xc/doc/man/Xext \
    xc/doc/man/Xi \
    xc/doc/man/Xp \
    xc/doc/man/Xt \
    xc/doc/man/Xv \
    xc/doc/man/misc \
    xc/doc/hardcopy/BDF \
    xc/doc/hardcopy/CTEXT \
    xc/doc/hardcopy/FSProtocol \
    xc/doc/hardcopy/ICCCM \
    xc/doc/hardcopy/ICE \
    xc/doc/hardcopy/RX \
    xc/doc/hardcopy/SM \
    xc/doc/hardcopy/X11 \
    xc/doc/hardcopy/XDMCP \
    xc/doc/hardcopy/XIM \
    xc/doc/hardcopy/XKB \
    xc/doc/hardcopy/XLFD \
    xc/doc/hardcopy/XProtocol \
    xc/doc/hardcopy/Xaw \
    xc/doc/hardcopy/Xext \
    xc/doc/hardcopy/Xi \
    xc/doc/hardcopy/Xmu \
    xc/doc/hardcopy/Xserver \
    xc/doc/hardcopy/Xt \
    xc/doc/hardcopy/Xv \
    xc/doc/hardcopy/i18n \
    xc/doc/hardcopy/man \
    xc/doc/hardcopy/rstart \
    xc/doc/hardcopy/saver \
    xc/doc/hardcopy/xfs \
    xc/doc/hardcopy/xterm \
    xc/doc/hardcopy/xtrans -type f

  # misc
  echo "xc/README"
  echo "xc/README.crypto"
  echo "xc/BUILD"
  echo "xc/LABEL"
  echo "xc/RELNOTES"
) | egrep -v "/CVS/|_xp_disabled$" 
}

case "$1" in
    'list')
        list_files
        ;;
    'rename')
        list_files | 
          while read i ; do 
              echo "# $i" ; 
              mv "$i" "${i}_xp_disabled" ;
          done
        ;;
    'delete')
        list_files | 
          while read i ; do 
              echo "# $i" ; 
              rm "$i"
          done
        ;;
    *)
        echo "${0}: Usage: ${0} [list] [rename] [delete]"
        ;;
esac
# EOF.
