/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef HVSC_CONFIG_H
#define HVSC_CONFIG_H

#include <qdir.h>
#include <qstring.h>

class HVSC_Config
{
 public:
    
    QDir hvscRootPath;
    bool showGlobalComments;
    bool showStilEntries;
    bool showBugListEntries;
    bool showForCurrentSong;
    bool showForFile;
    bool autoResize;
    QString maxHeight;

    HVSC_Config()
    {
        hvscRootPath = "/usr/share/hvsc-3.8";
        showGlobalComments = true;
        showStilEntries = true;
        showBugListEntries = true;
        showForCurrentSong = true;
        showForFile = false;
        autoResize = true;
        maxHeight = "200";
    }
};

#endif  /* HVSC_CONFIG_H */
