// $Id: ReferenceStation.hh,v 1.2 2003/02/04 15:53:46 flaterco Exp $
/*  ReferenceStation  Implementation for regular tide station.

    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

class ReferenceStation: public Station {
public:
  ReferenceStation (TideContext *in_tidecontext,
                    ConstantSetWrapper *in_constants);
  virtual ~ReferenceStation();
  int is_reference_station();

  // tm (in-out) is "uncorrected" or "internal" timestamp
  // t_out is "corrected" timestamp (with offsets applied)
  // For reference station or simple offsets, they are identical.
  void predictExactTideEvent (Timestamp &tm, Direction d,
    Timestamp &t_out, EventType &etype_out, Dstr &etype_desc_long,
    Dstr &etype_desc_short, PredictionValue &pv_out);
};
