/*  tideEditor  Simple program to edit the tide constituent database  */


/*****************************************************************************\

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

\*****************************************************************************/



#include "tideEditor.h"
#include <qapplication.h>


int
main (int argc, char **argv)
{
    QApplication a (argc, argv);

    TideEditor tideEditor;

    tideEditor.setCaption ("Tide Constituent Editor");

    tideEditor.resize (MAP_X_SIZE, MAP_Y_SIZE);

    a.setMainWidget (&tideEditor);
    if (QApplication::desktop ()->width () > (MAP_X_SIZE + 50)
        && QApplication::desktop ()->height () > (MAP_Y_SIZE + 66))
    {
        tideEditor.show ();
    }
    else
    {
        tideEditor.showMaximized ();
    }


    tideEditor.redrawMap ();


    return a.exec ();
}
