/* $Id: map.h,v 1.3 2003/07/02 20:05:45 flaterco Exp $ */

/*  Map class definition.  */

/*****************************************************************************\

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

\*****************************************************************************/


#ifndef MAP_H
#define MAP_H

/* RWL the following ifdef removes a templates error when compiling with MSVC (Known bug) */

#ifdef WIN32
#include <math.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <qapplication.h>
#include <qevent.h>
#include <qpainter.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qstatusbar.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include <qrect.h>
#include <qpoint.h>
#include <qcolordialog.h>
#include <qfiledialog.h>
#include <qcursor.h>
#include <qimage.h>
#include <qstrlist.h>
#include <qintdict.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmainwindow.h>
#include <qrangecontrol.h>
#include <qpen.h>
#include <qpoint.h>
#include <qpixmap.h>
#include <qwidget.h>
#include <qstring.h>
#include <qpointarray.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlistbox.h>


#define MAX_ZOOM_LEVEL   5
#define MAP_X_SIZE       1000
#define MAP_Y_SIZE       500
#define MAP_LEFT         0
#define MAP_UP           1
#define MAP_RIGHT        2
#define MAP_DOWN         3
#define BORDER           5


class QMouseEvent;
class QResizeEvent;
class QPaintEvent;


class Map:public QWidget
{
    Q_OBJECT 


  public:

    Map (QWidget * parent = 0, const char *name = 0);

    void setPenColor (const QColor & c)
    {
        pen.setColor (c);
    }

    QColor penColor ()
    {
        return pen.color ();
    }

    void setZoomLevel (int level);
    void setExtents (int zoom, double slat, double nlat, double wlon, 
                     double elon);
    int getExtents (double *slat, double *nlat, double *wlon, double *elon,
                    double *full_slat, double *full_nlat, double *full_wlon,
                    double *full_elon);
    void setRedrawZeroLevel ();
    void moveMap (int direction);
    void moveMap (double center_lat, double center_lon);
    void redrawMap ();
    void clearScreen ();
    void drawLine (int x1, int y1, int x2, int y2);
    void drawCircle (int x, int y, int h, int w, int r, QColor color);
    void drawRectangle (int x, int y, int h, int w);
    int translateCoordinates (double lat, double lon, int *x, int *y);
    void untranslateCoordinates (double *lat, double *lon, int x, int y);


  signals:

    void leftMouseSignal (QMouseEvent *e);
    void midMouseSignal (QMouseEvent * e);
    void rightMouseSignal (QMouseEvent * e);
    void moveMouseSignal (QMouseEvent * e);
    void redrawSignal ();


  protected:

    void mousePressEvent (QMouseEvent * e);
    void mouseReleaseEvent (QMouseEvent * e);
    void mouseMoveEvent (QMouseEvent * e);
    void resizeEvent (QResizeEvent * e);
    void paintEvent (QPaintEvent * e);

    QPen pen;
    QPointArray polyline;

    QPixmap buffer, savemap;


    typedef struct
    {
        double slat;
        double nlat;
        double wlon;
        double elon;
    }
    BOUNDS;

    BOUNDS bounds[MAX_ZOOM_LEVEL + 1];

    double center_longitude, range, move_inc;
    int zoom_level, redraw_zero_level;
    int border;
    int last_x, last_y;
    int draw_width, draw_height;
};

#endif
