/* This is for emacs: -*-Mode: C++;-*- */
/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#if !defined(__INC_UCXX_SCRIPT_CLASS_BUILDER_H)
#define __INC_UCXX_SCRIPT_CLASS_BUILDER_H

#include <string>
#include <map>

#include <yehia/script/base.h>
#include <yehia/script/slot-signature.h>
#include <yehia/script/constructors.h>

namespace Yehia
{

namespace Script
{


class ClassBuilder_
{
  public:
    ClassBuilder_(ObjectFactory& factory, Namespace& parent_ns, 
                  const std::string& name, const Signature& bases);
    ~ClassBuilder_();
    
    operator Class&() { return *this_class_; }

    Object& class_object() { return *classobj_; }
    
    void add_constructor(const Slot& slot, const Signature& sig);
    void add_method(const std::string& name, const Slot& slot, 
                    const Signature& sig);
    void add_class_method(const std::string& name, const Slot& slot,
                          const Signature& sig);
    void add_setter(const std::string& name, const Slot& slot, 
                    const Signature& sig);
    void add_getter(const std::type_info& ti,
                    const std::string& name, const Slot& slot);
  private:
    ObjectFactory& factory_;
    GenFunc *constructor_;
    Namespace& parent_ns_;
    Object *classobj_;
    Class *this_class_;
    std::string name_;
    std::map<std::string, GenFunc *> method_map_;
    std::map<std::string, GenFunc *> getter_map_;
    std::map<std::string, GenFunc *> setter_map_;
    std::map<std::string, GenFunc *> class_method_map_;
};

template <class T>
class ClassBuilder : public ClassBuilder_
{
  public:
    ClassBuilder(ObjectFactory& factory, Namespace& parent_ns, 
                 const std::string& name, 
                 const Signature& bases = Signature())
        : ClassBuilder_(factory, parent_ns, name, bases)
      {
        factory.register_class(typeid(T), class_object());
      }

    const std::type_info& class_typeid() const { return typeid(T); }

    template <class Constructor>
    void constructor(const Constructor&) {
      add_constructor(convert(SigC::slot(&Constructor::instantiate)),
                      slotsig(SigC::slot(&Constructor::instantiate)));
    }
    template <class ASlot> 
    void method(const std::string& name, const ASlot& s) { 
      add_method(name, convert(s), slotsig(s)); 
    }
    
    template <class ASlot>
    void class_method(const std::string& name, const ASlot& s) {
      add_class_method(name, convert(s), slotsig(s));
    }
    
    template <class R> 
    void getter(const std::string& name, const SigC::Slot1<R, const T&>& s) { 
      add_getter(typeid(T), name, convert(s)); 
    }
    template <class R> 
    void getter(const std::string& name, const SigC::Slot1<R, T&>& s) { 
      add_getter(typeid(T), name, convert(s)); 
    }

    template <class R, class P> 
    void setter(const std::string& name, const SigC::Slot2<R, T&, P>& s) { 
      add_setter(name, convert(s), slotsig(s));
    }
};

}

}

// This is at the end, since it include traits.h, which needs ClassBuilder<T>
#include <yehia/script/slot-convert.h>

#endif
