/*____________________________________________________________________________
        
        Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)

        Portions Copyright (C) 1998-1999 EMusic.com

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
        
        $Id: preferences.cpp,v 1.18 2004/02/13 22:24:01 kgk Exp $
____________________________________________________________________________*/

// The debugger can't handle symbols more than 255 characters long.
// STL often creates symbols longer than that.
// When symbols are longer than 255 characters, the warning is disabled.
#ifdef WIN32
#pragma warning(disable:4786) 
#endif

#include <string>
#include <stdlib.h>

#ifdef __QNX__
#include <strings.h>
#endif
using namespace std;
#include "preferences.h"


//  The following lines use the prefs.def to create the
//  set of default preference values.  See prefs.def for
//  details
//
#define ZINF_PREF(T,V) const char* k##T##Pref = #T;
#include "prefs.def"
#undef ZINF_PREF

void Preferences::setDefault(const string&pref, const char *v){
    string dummy;
    if (GetPrefString(pref, dummy) == kError_NoPrefValue)
        SetPrefString(pref, v);
}
void Preferences::setDefault(const string&pref, int v){
    int32_t dummy;
    if (GetPrefInt32(pref, dummy) == kError_NoPrefValue)
        SetPrefInt32(pref, v);
}
void Preferences::setDefault(const string&pref, bool v){
    bool dummy;
    if (GetPrefBoolean(pref, dummy) == kError_NoPrefValue)
        SetPrefBoolean(pref, v);
}

Error
Preferences::
SetDefaults()
{
    return kError_NoErr;

#if 0
    int32_t dummyInt;
    bool  dummyBool;
    string dummyString;

    // set default for input buffer size
    if (GetPrefInt32(kInputBufferSizePref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kInputBufferSizePref, kDefaultInputBufferSize);

    // set default for output buffer size
    if (GetPrefInt32(kOutputBufferSizePref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kOutputBufferSizePref, kDefaultOutputBufferSize);

    // set default for streaming buffer interval
    if (GetPrefInt32(kStreamBufferIntervalPref, &dummyInt)
        == kError_NoPrefValue)
        SetPrefInt32(kStreamBufferIntervalPref, 
                     kDefaultStreamBufferInterval);

    // set default for decoder thread priority
    if (GetPrefInt32(kDecoderThreadPriorityPref, &dummyInt)
        == kError_NoPrefValue)
        SetPrefInt32(kDecoderThreadPriorityPref, 
                     kDefaultDecoderThreadPriority);

    // set defaults for logging
    if (GetPrefBoolean(kUseDebugLogPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kUseDebugLogPref, kDefaultLogging);
    if (GetPrefBoolean(kLogMainPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kLogMainPref, kDefaultLogging);
    if (GetPrefBoolean(kLogDecodePref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kLogDecodePref, kDefaultLogging);
    if (GetPrefBoolean(kLogInputPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kLogInputPref, kDefaultLogging);
    if (GetPrefBoolean(kLogOutputPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kLogOutputPref, kDefaultLogging);
    if (GetPrefBoolean(kLogPerformancePref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kLogPerformancePref, kDefaultLogging);

    if (GetPrefBoolean(kSaveStreamsPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kSaveStreamsPref, kDefaultSaveStreams);

    if (GetPrefString(kSaveStreamsDirPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kSaveStreamsDirPref, string(kDefaultSaveStreamsDir));

    if (GetPrefInt32(kPreBufferPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kPreBufferPref, kDefaultPreBuffer);

    if (GetPrefBoolean(kUseProxyPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kUseProxyPref, kDefaultUseProxy);

    if (GetPrefString(kProxyHostPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kProxyHostPref, string(kDefaultProxyHost));

    if (GetPrefString(kMBServerPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kMBServerPref, string(kDefaultMBServer));

    if (GetPrefBoolean(kUseAlternateNICPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kUseAlternateNICPref, kDefaultUseNIC);

    if (GetPrefString(kAlternateNICAddressPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kAlternateNICAddressPref, string(kDefaultNICAddress));

    if (GetPrefBoolean(kUseTitleStreamingPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kUseTitleStreamingPref, kDefaultUseTitleStreaming);

    if (GetPrefString(kThemePathPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kThemePathPref, string(kDefaultThemePath));

    if (GetPrefString(kMainWindowPosPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kMainWindowPosPref, string(kDefaultMainWindowPos));

    if (GetPrefString(kWindowModePref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kWindowModePref, string(kDefaultWindowMode));

    if (GetPrefString(kThemeDefaultFontPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kThemeDefaultFontPref, string(kDefaultThemeDefaultFont));

    if (GetPrefString(kMusicBrowserUIPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kMusicBrowserUIPref, string(kDefaultMusicBrowserUI));

    if (GetPrefString(kDownloadManagerUIPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kDownloadManagerUIPref, string(kDefaultDownloadManagerUI));

    if (GetPrefString(kToolbarUIPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kToolbarUIPref, string(kDefaultToolbarUI));

    if (GetPrefString(kSecondaryUIPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kSecondaryUIPref, string(kDefaultSecondaryUI));

    if (GetPrefBoolean(kCheckForUpdatesPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kCheckForUpdatesPref, kDefaultCheckForUpdates);

    if (GetPrefInt32(kPlaylistRepeatPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kPlaylistRepeatPref, kDefaultPlaylistRepeat);

    if (GetPrefBoolean(kPlaylistShufflePref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kPlaylistShufflePref, kDefaultPlaylistShuffle);

    if (GetPrefInt32(kTimeDisplayPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kTimeDisplayPref, kDefaultTimeDisplay);

    if (GetPrefInt32(kVolumePref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kVolumePref, kDefaultVolume);

    if (GetPrefString(kUserNamePref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kUserNamePref, string(kDefaultUserName));

    if (GetPrefString(kCDDevicePathPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kCDDevicePathPref, string(kDefaultCDDevicePath));

    if (GetPrefBoolean(kReclaimFiletypesPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kReclaimFiletypesPref, kDefaultReclaimFiletypes);

    if (GetPrefBoolean(kAskToReclaimFiletypesPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kAskToReclaimFiletypesPref, kDefaultAskToReclaimFiletypesPref);

    if (GetPrefString(kUsersPortablePlayersPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kUsersPortablePlayersPref, string(kDefaultUsersPortablePlayers));

    if (GetPrefBoolean(kShowToolbarTextLabelsPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kShowToolbarTextLabelsPref, kDefaultShowToolbarTextLabels);

    if (GetPrefBoolean(kShowToolbarImagesPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kShowToolbarImagesPref, kDefaultShowToolbarImages);

    if (GetPrefBoolean(kSaveCurrentPlaylistOnExitPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kSaveCurrentPlaylistOnExitPref, kDefaultSaveCurrentPlaylistOnExit);

    if (GetPrefBoolean(kViewMusicBrowserPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kViewMusicBrowserPref, kDefaultViewMusicBrowser);

    if (GetPrefBoolean(kWelcomePref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kWelcomePref, kDefaultWelcome);

    if (GetPrefBoolean(kPlayImmediatelyPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kPlayImmediatelyPref, kDefaultPlayImmediately);
	
    if (GetPrefBoolean(kSetLastResumePref, &dummyBool) == kError_NoPrefValue)
	SetPrefBoolean(kSetLastResumePref, kDefaultSetLastResume);

    if (GetPrefBoolean(kSoftMixerPref, &dummyBool) == kError_NoPrefValue)
	SetPrefBoolean(kSoftMixerPref, kDefaultSoftMixer);
	
    if (GetPrefString(kLastDirPref, &dummyString) == kError_NoPrefValue)
	SetPrefString(kLastDirPref, string(kDefaultLastDir));
    
    if (GetPrefInt32(kNumberOfURLsToRememberPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kNumberOfURLsToRememberPref, kDefaultNumberOfURLsToRemember);

    if (GetPrefBoolean(kConvertUnderscoresToSpacesPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kConvertUnderscoresToSpacesPref, kDefaultConvertUnderscoresToSpaces);

    if (GetPrefBoolean(kAllowMultipleInstancesPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kAllowMultipleInstancesPref, kDefaultAllowMultipleInstances);

    if (GetPrefInt32(kAudioCDLengthPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kAudioCDLengthPref, kDefaultAudioCDLength);

    if (GetPrefInt32(kWatchThisDirTimeoutPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kWatchThisDirTimeoutPref, kDefaultWatchThisDirTimeout);

    if (GetPrefBoolean(kWriteID3v1Pref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kWriteID3v1Pref, kDefaultWriteID3v1);

    if (GetPrefBoolean(kWriteID3v2Pref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kWriteID3v2Pref, kDefaultWriteID3v2);

    if (GetPrefBoolean(kWriteVorbisTags, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kWriteVorbisTags, kDefaultVorbisTags);

    if (GetPrefBoolean(kCloseDLMOnCompletePref, &dummyBool) == 
        kError_NoPrefValue)
        SetPrefBoolean(kCloseDLMOnCompletePref, kDefaultCloseDLMOnComplete);
	
    if (GetPrefString(kEqualizerSettingsPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kEqualizerSettingsPref, string(kDefaultEqualizerSettings));

    if (GetPrefInt32(kSavedPlaylistPositionPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kSavedPlaylistPositionPref, kDefaultSavedPlaylistPosition);

    if (GetPrefString(kMusicBrowserPositionPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kMusicBrowserPositionPref, string(kDefaultMusicBrowserPosition));

    if (GetPrefString(kMusicBrowserHeaderWidthsPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kMusicBrowserHeaderWidthsPref, string(kDefaultMusicBrowserHeaderWidths));

    if (GetPrefBoolean(kPerformDBCheckPref, &dummyBool) == 
        kError_NoPrefValue)
        SetPrefBoolean(kPerformDBCheckPref, kDefaultPerformDBCheck);

    if (GetPrefBoolean(kCheckCDAutomaticallyPref, &dummyBool) == 
        kError_NoPrefValue)
        SetPrefBoolean(kCheckCDAutomaticallyPref, kDefaultCheckCDAutomatically);

    if (GetPrefString(kPlaylistHeaderColumnsPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kPlaylistHeaderColumnsPref, string(kDefaultPlaylistHeaderColumns));
/*
    if (GetPrefBoolean(kAdvancedRelatablePref, &dummyBool) == 
        kError_NoPrefValue)
        SetPrefBoolean(kAdvancedRelatablePref, kDefaultAdvancedRelatable);
*/
    if (GetPrefInt32(kMetadataDisplayPref, &dummyInt) == kError_NoPrefValue)
        SetPrefInt32(kMetadataDisplayPref, kDefaultMetadataDisplay);

    if (GetPrefBoolean(kEnableMusicBrainzPref, &dummyBool) == 
        kError_NoPrefValue)
        SetPrefBoolean(kEnableMusicBrainzPref, kDefaultEnableMusicBrainz);

    if (GetPrefBoolean(kEnableBitziPref, &dummyBool) == kError_NoPrefValue)
        SetPrefBoolean(kEnableBitziPref, kDefaultEnableBitzi);

    if (GetPrefString(kLastZinfVersionPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kLastZinfVersionPref, string(kDefaultLastZinfVersion));

    if (GetPrefString(kBrowser, &dummyString) == kError_NoPrefValue) 
      SetPrefString (kBrowser, string (kDefaultBrowser));

    if (GetPrefString(kAssumeTagCharsetPref, &dummyString) == kError_NoPrefValue)
        SetPrefString(kAssumeTagCharset, string(kDefaultAssumeTagCharset));

    return kError_NoErr;
#endif
}

Error
Preferences::
GetPrefBoolean(const string& pref, bool& value)
{
  return GetPrefBoolean(pref.c_str(), &value);
}

Error
Preferences::
SetPrefBoolean(const string& pref, bool value)
{
    return SetPrefString(pref.c_str(), string(value ? "true" : "false"));
}
Error
Preferences::
GetPrefInt32(const string& pref, int32_t& value)
{
  return GetPrefInt32 (pref.c_str(), &value);
}
Error
Preferences::
SetPrefInt32(const string& pref, int32_t value)
{
  return SetPrefInt32 (pref.c_str(), value);
}

Error
Preferences::
GetPrefBoolean(const char* pref, bool* value)
{
    Error error;
    string temp;

    *value = false;
    error = GetPrefString(pref, &temp);
    if (IsntError(error))
    {
        if (0 == strcasecmp(temp.c_str(), "true"))
            *value = true;
        else if (0 != strcasecmp(temp.c_str(), "false"))
        {
            // In the case of a syntax error, pretend the preference doesn't
            // exist, so that it'll be replaced by a default value.
            error = kError_NoPrefValue;
        }
    }
    return error;

}

Error
Preferences::
SetPrefBoolean(const char* pref, bool value)
{
    return SetPrefString(pref, value ? "true" : "false");
}

Error
Preferences::
GetPrefInt32(const char* pref, int32_t* value)
{
    Error error;
    char* endp;
    string temp;

    *value = -1;
    error = GetPrefString(pref, &temp);
    
    if (IsntError(error))
    {
        *value = strtol(temp.c_str(), &endp, 10);
        // In the case of a syntax error, pretend the preference doesn't
        // exist, so that it'll be replaced by a default value.
        if (*endp != '\0')
            error = kError_NoPrefValue;
    }
    return error;
}

Error
Preferences::
SetPrefInt32(const char* pref, int32_t value)
{
    Error error;
    bool isNeg = 0;
    char temp[32];
    char* p = temp + sizeof(temp);

    if (value < 0)
    {
        value = -value;
        isNeg = 1;
    }

    *--p = '\0';

    do
    {
        *--p = '0' + (value % 10);
        value /= 10;
    } while (value > 0);

    if (isNeg)
        *--p = '-';

    error = SetPrefString(pref, string(p));

    return error;
}

#if 0
LibDirFindHandle *
Preferences::
GetFirstLibDir(char *path, uint32_t *len)
{
    Error error;
    string path2;
    error = GetPrefString(kInstallDirPref, path2);
    strncpy(path,path2.c_str(),*len);
    return IsError(error) ? 0 : (LibDirFindHandle *) 1;
}

Error
Preferences::
GetNextLibDir(LibDirFindHandle *hLibDirFind, char *path, uint32_t *len)
{
    path[0] = '\0';
    return kError_NoMoreLibDirs;
}

Error
Preferences::
GetLibDirClose(LibDirFindHandle *hLibDirFind)
{
    return kError_NoErr;
}
#endif

string 
Preferences::
GetLibPath()
{
    string path=""; 
    GetPrefString(kInstallDirPref, path);
    return path;
}

/* arch-tag: 27847f54-41ad-4ca5-b842-bace7af95970
   (do not change this comment) */
