/*____________________________________________________________________________
   
   Zinf - Zinf Is Not FreeA*p (The Free MP3 Player)
   Portions Copyright (C) 1998-1999 EMusic.com

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
   $Id: wavlmc.h,v 1.11 2003/09/16 17:35:14 kgk Exp $

____________________________________________________________________________*/

#ifndef INCLUDED_WAVLMC_H_
#define INCLUDED_WAVLMC_H_

/* system headers */
#include <stdlib.h>
#include <time.h>
#include <string>
#include <vector>
#include <inttypes.h>

/* project headers */
#include "config.h"

#include "pmi.h"
#include "pmo.h"
#include "mutex.h"
#include "event.h"
#include "lmc.h"
#include "thread.h"
#include "mutex.h"
#include "queue.h"
#include "semaphore.h"

#define FRAMES_FLAG     0x0001
#define BYTES_FLAG      0x0002
#define TOC_FLAG        0x0004
#define VBR_SCALE_FLAG  0x0008

#define FRAMES_AND_BYTES (FRAMES_FLAG | BYTES_FLAG)

#ifndef WIN32
#define WAVE_FORMAT_PCM 1
typedef unsigned int DWORD;
typedef unsigned char BYTE;

#if !SMALL_ENDIAN
#define MAKEFOURCC(ch0,ch1,ch2,ch3) (((DWORD)(BYTE)(ch0) << 24) | ((DWORD)(BYTE)(ch1) << 16) | ((DWORD)(BYTE)(ch2) << 8) | ((DWORD)(BYTE)(ch3) << 0 )) 
#else
#define MAKEFOURCC(ch0,ch1,ch2,ch3) ((DWORD)(BYTE)(ch0) | ((DWORD)(BYTE)(ch1) << 8) | ((DWORD)(BYTE)(ch2) << 16) | ((DWORD)(BYTE)(ch3) << 24 ))
#endif

struct WAVEFORMAT
{
   unsigned short     wFormatTag;
   unsigned short     nChannels;
   DWORD              nSamplesPerSec;
   DWORD              nAvgBytesPerSec;
   unsigned short     nBlockAlign;
};
#endif

class     WavLMC:public LogicalMediaConverter
{

   public:
            WavLMC(FAContext *context);
   virtual ~WavLMC();

   virtual uint32_t CalculateSongLength(const char *url);

   virtual Error ChangePosition(int32_t position);

   virtual Error CanDecode();
   virtual void  Clear();
   virtual Error ExtractMediaInfo();

   /** Gets the output buffer of this stream.
     *  Because the output buffer will be prepared for the caller, this function should be called
     *  only once.
     *  @param pBuffer is set to the output buffer. Normally it will be prepared for the caller.
     *  @returns Returns an error if one happened.
     */
   virtual Error GetOutputBuffer(PullBuffer **pBuffer);

   virtual Error InitDecoder();

   virtual std::vector<std::string> *GetExtensions(void);
   
 private:

   static void          DecodeWorkerThreadFunc(void *);
   void                 DecodeWork();
   Error                BeginRead(void *&pBuffer, unsigned int iBytesNeeded);
   Error                EndRead(size_t iBytesUsed);
   Error                GetHeadInfo();
   Error                GetStats(float &fTotalSeconds, int32_t &iTotalFrames);

   Thread              *m_decoderThread;
   const char          *m_szError; // marked for removal...
   FILE                *m_fpFile;
   char                *m_pLocalReadBuffer;

   int                  m_iMaxWriteSize;
   int32_t                m_frameBytes, m_iBufferUpInterval;
   size_t               m_lFileSize;
   int32_t                m_iTotalFrames;


   int32_t                m_frameCounter;
   time_t               m_iBufferUpdate;
   
   // These vars are used for a nasty hack.

   WAVEFORMAT          m_WaveFormat;
   unsigned long       m_ulWaveSize;
   unsigned long       m_ulWaveHeaderSize;
   int                 m_iFramesPerSecond;
};

#endif /* _WAVLMC_H */




/* arch-tag: ff58e606-fe89-4df3-8c40-3242476e1038
   (do not change this comment) */
