/*      Copyright (C) 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#include "ops-counter.h"
#include "util.h"

#include "util/hash.h"
#include "util/ting.h"
#include "util/err.h"
#include "util/types.h"


static   mcxHash*    ctrTable_g        =  NULL;    /* counters          */


/*
 *    The return value of yamGetCtr should never be freed by caller
*/ 

mcxTing* yamCtrGet
(  mcxTing*  key
)  {
      mcxKV*   kv
      =  (mcxKV*) mcxHashSearch(key, ctrTable_g, MCX_DATUM_FIND)

   ;  return kv ? (mcxTing*) kv->val : NULL
;  }


void mod_counter_exit
(  void
)
   {  mcxHashFree(&ctrTable_g, mcxTingFree_v, mcxTingFree_v)
;  }


void mod_counter_init
(  int   n
)
   {  ctrTable_g           =  yamHashNew(n)
;  }


void yamCtrWrite
(  mcxTing* ctr
,  const char* str
)
   {  mcxTingWrite(ctr, str)
;  }


void yamCtrSet
(  mcxTing* ctr
,  int   c
)
   {  char     cstr[20]
   ;  sprintf(cstr, "%d", c)
   ;  mcxTingWrite(ctr, cstr)
;  }


mcxTing* yamCtrMake
(  mcxTing* label
)
   {
      mcxKV* kv =  mcxHashSearch(label, ctrTable_g, MCX_DATUM_INSERT)

   ;  if (kv->key != label)
      yamErr("yamCtrMake PBD", "counter exists (and fix this design pls)")
   ;  else
      kv->val =  mcxTingNew("0")

   ;  return kv->val
;  }


