/*      Copyright (C) 2001, 2002, 2003, 2004 Stijn van Dongen
 *
 * This file is part of Zoem. You can redistribute and/or modify Zoem under the
 * terms of the GNU General Public License;  either version 2 of the License or
 * (at your option) any later  version.  You should have received a copy of the
 * GPL along with Zoem, in the file COPYING.
*/

#ifndef zoem_util_h__
#define zoem_util_h__

#include "segment.h"
#include "util/err.h"

void yamStats
(  void
)  ;

void  yamExit
(  const char  *caller
,  const char  *msg
,  ...
)  ;

void  yamErr
(  const char  *caller
,  const char  *msg
,  ...
)  ;

void yamErrorFile
(  FILE* fp
)  ;

mcxHash* yamHashNew
(  int n
)  ;

mcxstatus yamHashFie
(  const char* id
)  ;



typedef struct
{  mcxLink*    sp
;
}  yamStack    ;

yamStack* ting_stack_new
(  int capacity
)  ;

void ting_stack_init
(  yamStack* stack
,  int capacity
)  ;

void ting_stack_push
(  yamStack*   st
,  char*    str
,  int      len
)  ;

const char* ting_stack_pop
(  yamStack*   st
)  ;

void ting_stack_free
(  yamStack** stackp
)  ;


#endif

