###  Note:
###
###  This code taken from the Python Cookbook
###  http://www.activestate.com/ASPN/Python/Cookbook
###
###  This code is originally part of the MoinMoin project
###  (http://moin.sf.net/) and 
###  used by permission.
###
###  Modified by DaJoker to do DTML syntax hilighting
###
###  Stolen from DaJoker and modified by Chris McDonough for BackTalk

import cgi, string, sys, cStringIO
import keyword, token, tokenize
import dtmlkeyword


#############################################################################
### Python Source Parser (does Hilighting)
#############################################################################

_KEYWORD = token.NT_OFFSET + 1
_TEXT    = token.NT_OFFSET + 2
_RESWORD = token.NT_OFFSET + 3

_styles = {
    token.NUMBER:       'ex_number',
    token.OP:           'ex_op',
    token.STRING:       'ex_string',
    tokenize.COMMENT:   'ex_comment',
    token.NAME:         'ex_name',
    token.ERRORTOKEN:   'ex_errortoken',
    _RESWORD:           'ex_resword',
    _KEYWORD:           'ex_keyword',
    _TEXT:              'ex_text',
}

_colors = {
    token.NUMBER:       '#0080C0',
    token.OP:           '#0000C0',
    token.STRING:       '#004080',
    tokenize.COMMENT:   '#008000',
    token.NAME:         '#000000',
    token.ERRORTOKEN:   '#FF8080',
    _RESWORD:           '#7c0000',
    _KEYWORD:           '#C00000',
    _TEXT:              '#000000',
}

class Parser:
    """ Send colored python source.
    """

    def __init__(self, raw):
        """ Store the source text.
        """
        self.raw = string.strip(string.expandtabs(raw))
        self.out = ''

    def format(self, formatter=None, form=None):
        """ Parse and send the colored source.
        """
        # store line offsets in self.lines
        self.lines = [0, 0]
        pos = 0
        while 1:
            pos = string.find(self.raw, '\n', pos) + 1
            if not pos: break
            self.lines.append(pos)
        self.lines.append(len(self.raw))

        # parse the source and write it
        self.pos = 0
        text = cStringIO.StringIO(self.raw)
        self.out = self.out + '<pre class="simple_example">'
        try:
            tokenize.tokenize(text.readline, self)
        except tokenize.TokenError, ex:
            msg = ex[0]
            line = ex[1][0]
            self.out = self.out + "<h3>ERROR: %s</h3>%s\n" % (
                msg, self.raw[self.lines[line]:])
        self.out = self.out + '</pre>'

    def __call__(self, toktype, toktext, (srow,scol), (erow,ecol), line):
        """ Token handler.
        """
        if 0:
            print "type", toktype, token.tok_name[toktype], "text", toktext,
            print "start", srow,scol, "end", erow,ecol, "<br>"

        # calculate new positions
        oldpos = self.pos
        newpos = self.lines[srow] + scol
        self.pos = newpos + len(toktext)

        # handle newlines
        if toktype in [token.NEWLINE, tokenize.NL]:
            self.out = self.out + '\n'
            return

        # send the original whitespace, if needed
        if newpos > oldpos:
            self.out = self.out + self.raw[oldpos:newpos]

        # skip indenting tokens
        if toktype in [token.INDENT, token.DEDENT]:
            self.pos = newpos
            return

        # map token type to a color group
        if token.LPAR <= toktype and toktype <= token.OP:
            toktype = token.OP
        elif dtmlkeyword.iskeyword(toktext):
            toktype = _KEYWORD
        elif dtmlkeyword.isresword(toktext):
            toktype = _RESWORD
        elif toktype == token.NAME and keyword.iskeyword(toktext):
            toktype = _KEYWORD

        color = _colors.get(toktype, _colors[_TEXT])
        style = _styles.get(toktype, _styles[_TEXT])

        # send text
        self.out = self.out + '<font color="%s"%s>' % (color, style)
        self.out = self.out + cgi.escape(toktext)
        self.out = self.out + '</font>'
