'''DocFinder Constructor.'''

from Globals import HTMLFile
from Products.ExternalMethod.ExternalMethod import manage_addExternalMethod
from OFS.DTMLMethod import addDTMLMethod

def manage_addDocFinder(self,REQUEST=None):
  '''add a 'DocFinder' pair to the current object manager.

  A 'DocFinder' pair consists of the External Method 'analyseDocumentation'
  and the DTML method 'showDocumentation'.

  'analyseDocumentation' will only be installed, if not yet
  available through acquisition, as a single instance is enough
  for a complete subtree.
  Note: The test is not safe (as the acquisition context
  during creation may be different from that during use),
  but there should be no problems in practice.

  'showDocumentation' will be installed unless there
  is already an object of this name in the current
  object manager. This error is fatal.
  '''
  if not hasattr(self,'analyseDocumentation'):
    manage_addExternalMethod(self,
                             'analyseDocumentation',
                             'analyse a Zope object for documentation',
                             'DocFinder.analyse',
                             'analyse',
                             REQUEST)
  addDTMLMethod(self,
                'showDocumentation',
                'show a Zope object\'s documentation',
                HTMLFile('showDocumentation',globals()).read(),
                REQUEST)
  
Doc= manage_addDocFinder.__doc__

manage_addDocFinderForm= HTMLFile('addDocFinderForm',globals(), Doc=Doc)

class DocFinderDummy:
  meta_type= 'Documentation Finder'
