import string
from Products.I18NFolder import install_globals
from Products.I18NFolder import I18NFolder
from Products.I18NFolder.global_symbols import *
from Products.I18NFolder.Installation import Installation

fti_list = (
    I18NFolder.factory_type_information,
    )
types_list = (
    "I18NFolder",
    )
skin_name = "I18NFolder"
i18n_name = "I18NFolder"
perms_list = (I18NFolder_editPermission, I18NFolder_addPermission, )

def install(self):
    # register I18NFolder in use_folder_contents
    props = self.portal_properties.site_properties
    use_folder_tabs = list(props.use_folder_tabs)
    if 'I18NFolder' not in use_folder_tabs:
        use_folder_tabs.append('I18NFolder')
        props.use_folder_tabs=tuple(use_folder_tabs)
    
    # Install I18NFolder
    installation=Installation(self)
    installation.setPermissions(perms_list)
    installation.setupTypesandSkins(fti_list, skin_name, install_globals)
    domain=string.lower(i18n_name)
    poPrefix='%s_' % (string.lower(i18n_name), )
    for ctype in types_list:
        validation = [
              ('%s_editForm' % (ctype), 'validate_id,validate_%s_edit' % ctype, ),
              ]
        installation.addFormValidators(validation)
        lowertype=ctype.lower()
        transitions = [
              ('%s.%s_editForm.success' % (lowertype, ctype ), 'script:%s_edit' % (ctype), ),
              ('%s.%s_editForm.failure' % (lowertype, ctype ), '%s_editForm' % (ctype), ),
              ('%s.%s_edit.success' % (lowertype, ctype ), 'action:view', ),
              ('%s.%s_edit.failure' % (lowertype, ctype ), 'action:edit', ),
              ]
        installation.addNavigationTransitions(transitions)
    installation.installMessageCatalog(self, install_globals, domain, poPrefix)
    
    # Change I18NFolder workflow to folder workflow
    self.portal_workflow.setChainForPortalTypes(('I18NFolder',), 'folder_workflow')
    
    return installation.report()
