/*
   animate.h

   Author:   Susumu Shiohara (shiohara@tpp.epson.co.jp)

          Copyright 1993-1997 by Susumu Shiohara

                   All Rights Reserved

*/
typedef enum {
        SLIDE=0,
        FADE,
        REVERSE,
        MONOTONE,
        FLUSH,
        WIPE,
        WIPE24,
        BLOCK,
		BLOCK24,
        MOSAIC,
        COLORANIM,
        COLORANIM2,
        SHUFFLE,
        PUZZLE,
        SLIT,
        TRANSPARENT,
        MOVE,
        FLOAT24,
		GIFANIM
} ShowMode;

#if !defined (IS_MAIN)
#if defined(__STDC__) || defined(__cplusplus)
# define P_(s) s
#else
# define P_(s) ()
#endif

ActionStatus xslideshow P_((char *));
ActionStatus xfadeshow P_((char *));
ActionStatus xreverseshow P_((char *));
ActionStatus xmonotoneshow P_((char *));
ActionStatus xflushshow P_((char *));
ActionStatus xwipeshow P_((char *));
ActionStatus xwipeshow24 P_((char *));
ActionStatus xblockshow P_((char *));
ActionStatus xblockshow24 P_((char *));
ActionStatus xmosaicshow P_((char *));
ActionStatus xcoloranimateshow P_((char *));
ActionStatus xcoloranimate2show P_((char *));
ActionStatus xshuffleshow P_((char *));
ActionStatus xpuzzleshow P_((char *));
ActionStatus xslitshow P_((char *));
ActionStatus xtransparentshow P_((char *));
ActionStatus xmoveshow P_((char *));
ActionStatus xfloat24show P_((char *));
ActionStatus xgifanimshow P_((char *));
void postxslideshow P_((char *));
void postxfadeshow P_((char *));
void postxreverseshow P_((char *));
void postxmonotoneshow P_((char *));
void postxflushshow P_((char *));
void postxwipeshow P_((char *));
void postxwipeshow24 P_((char *));
void postxblockshow P_((char *));
void postxblockshow24 P_((char *));
void postxmosaicshow P_((char *));
void postxcoloranimateshow P_((char *));
void postxcoloranimate2show P_((char *));
void postxshuffleshow P_((char *));
void postxpuzzleshow P_((char *));
void postxslitshow P_((char *));
void postxtransparentshow P_((char *));
void postxmoveshow P_((char *));
void postxfloat24show P_((char *));
void postxgifanimshow P_((char *));
#undef P_

static ActionStatus (*animateFunc[])() = {
	xslideshow,			/* SLIDE      */
	xfadeshow,			/* FADE       */
	xreverseshow,		/* REVERSE    */
	xmonotoneshow,		/* MONOTONE   */
	xflushshow,			/* FLUSH      */
	xwipeshow,			/* WIPE       */
	xwipeshow24,		/* WIPE24     */
	xblockshow,			/* BLOCK      */
	xblockshow24,		/* BLOCK24    */
	xmosaicshow,		/* MOSAIC     */
	xcoloranimateshow,	/* COLORANIM  */
	xcoloranimate2show,	/* COLORANIM2 */
	xshuffleshow,		/* SHUFFLE    */
	xpuzzleshow,		/* PUZZLE     */
	xslitshow,			/* SLIT       */
	xtransparentshow,	/* TRANSPARENT*/
	xmoveshow,			/* MOVE       */
	xfloat24show,		/* FLOAT24    */
	xgifanimshow,		/* GIFANIM    */
};

static void (*postAnimateFunc[])() = {
	postxslideshow,		/* SLIDE      */
	postxfadeshow,		/* FADE       */
	postxreverseshow,	/* REVERSE    */
	postxmonotoneshow,	/* MONOTONE   */
	postxflushshow,		/* FLUSH      */
	postxwipeshow,		/* WIPE       */
	postxwipeshow24,	/* WIPE24     */
	postxblockshow,		/* BLOCK      */
	postxblockshow24,	/* BLOCK24    */
	postxmosaicshow,	/* MOSAIC     */
	postxcoloranimateshow,	/* COLORANIM  */
	postxcoloranimate2show,	/* COLORANIM2 */
	postxshuffleshow,	/* SHUFFLE    */
	postxpuzzleshow,	/* PUZZLE     */
	postxslitshow,	    /* SLIT       */
	postxtransparentshow,	/* TRANSPARENT*/
	postxmoveshow,		/* MOVE       */
	postxfloat24show,	/* FLOAT24    */
	postxgifanimshow	/* GIFANIM    */
};


#if defined(__STDC__) || defined(__cplusplus)
static ShowMode animate_strtoenum(char *animate)
#else
static ShowMode animate_strtoenum(animate)
char *animate;
#endif
{
        if     (strcmp(animate,"slide")     == 0) return(SLIDE);
        else if(strcmp(animate,"fade")      == 0) return(FADE);
        else if(strcmp(animate,"reverse")   == 0) return(REVERSE);
        else if(strcmp(animate,"monotone")  == 0) return(MONOTONE);
        else if(strcmp(animate,"flush")     == 0) return(FLUSH);
        else if(strcmp(animate,"wipe")      == 0) return(WIPE);
        else if(strcmp(animate,"wipe24")    == 0) return(WIPE24);
        else if(strcmp(animate,"block")     == 0) return(BLOCK);
        else if(strcmp(animate,"block24")   == 0) return(BLOCK24);
        else if(strcmp(animate,"mosaic")    == 0) return(MOSAIC);
        else if(strcmp(animate,"coloranim") == 0) return(COLORANIM);
        else if(strcmp(animate,"coloranim2")== 0) return(COLORANIM2);
        else if(strcmp(animate,"shuffle")   == 0) return(SHUFFLE);
        else if(strcmp(animate,"puzzle")    == 0) return(PUZZLE);
        else if(strcmp(animate,"slit")      == 0) return(SLIT);
        else if(strcmp(animate,"transparent") == 0) return(TRANSPARENT);
        else if(strcmp(animate,"move")      == 0) return(MOVE);
        else if(strcmp(animate,"float24")   == 0) return(FLOAT24);
        else if(strcmp(animate,"gifanim")   == 0) return(GIFANIM);
        else                                      return(SLIDE);
}

#endif
