/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.adt;

import ca.odell.glazedlists.impl.adt.IndexedTree;
import java.util.Comparator;

public final class IndexedTreeNode {
    public static final IndexedTreeNode EMPTY_NODE;
    IndexedTreeNode parent;
    IndexedTreeNode left = null;
    IndexedTreeNode right = null;
    int leftSize = 0;
    int rightSize = 0;
    private int height = 0;
    private Object value;
    private boolean sorted = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    IndexedTreeNode(IndexedTreeNode parent, Object value) {
        this.parent = parent;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    IndexedTreeNode getNodeWithIndex(int index) {
        if (index < this.leftSize) {
            return this.left.getNodeWithIndex(index);
        }
        if (index > this.leftSize) {
            return this.right.getNodeWithIndex(index - (this.leftSize + 1));
        }
        return this;
    }

    private boolean isRightChild() {
        return this.parent != null && this.parent.right == this;
    }

    private boolean isLeftChild() {
        return this.parent != null && this.parent.left == this;
    }

    private int getSortSide(Comparator comparator, Object searchValue) {
        IndexedTreeNode currentFollower = this;
        while (currentFollower != null) {
            if (currentFollower.sorted) {
                return comparator.compare(searchValue, currentFollower.value);
            }
            currentFollower = currentFollower.next();
        }
        return -1;
    }

    public IndexedTreeNode next() {
        IndexedTreeNode result;
        if (this.right != null) {
            result = this.right;
            while (result.left != null) {
                result = result.left;
            }
        } else if (this.parent == null) {
            result = null;
        } else if (this.isLeftChild()) {
            result = this.parent;
        } else if (this.isRightChild()) {
            IndexedTreeNode parentOfRightChild = this.parent;
            while (parentOfRightChild.isRightChild()) {
                parentOfRightChild = parentOfRightChild.parent;
            }
            result = parentOfRightChild.parent;
        } else {
            throw new IllegalStateException();
        }
        return result;
    }

    public IndexedTreeNode previous() {
        IndexedTreeNode result;
        if (this.left != null) {
            result = this.left;
            while (result.right != null) {
                result = result.right;
            }
        } else if (this.parent == null) {
            result = null;
        } else if (this.isRightChild()) {
            result = this.parent;
        } else if (this.isLeftChild()) {
            IndexedTreeNode parentOfLeftChild = this.parent;
            while (parentOfLeftChild.isLeftChild()) {
                parentOfLeftChild = parentOfLeftChild.parent;
            }
            result = parentOfLeftChild.parent;
        } else {
            throw new IllegalStateException();
        }
        return result;
    }

    IndexedTreeNode getShallowestNodeWithValue(Comparator comparator, Object object, boolean approximate) {
        IndexedTreeNode recurseNode;
        int sortSide = this.getSortSide(comparator, object);
        if (sortSide == 0) {
            return this;
        }
        IndexedTreeNode indexedTreeNode = recurseNode = sortSide < 0 ? this.left : this.right;
        if (recurseNode != null) {
            return recurseNode.getShallowestNodeWithValue(comparator, object, approximate);
        }
        return approximate ? this : null;
    }

    int size() {
        return this.leftSize + 1 + this.rightSize;
    }

    int height() {
        return this.height;
    }

    IndexedTreeNode getLargestChildNode() {
        if (this.rightSize > 0) {
            return this.right.getLargestChildNode();
        }
        return this;
    }

    IndexedTreeNode getSmallestChildNode() {
        if (this.leftSize > 0) {
            return this.left.getSmallestChildNode();
        }
        return this;
    }

    public int getIndex() {
        return this.getIndex(null);
    }

    private int getIndex(IndexedTreeNode child) {
        if (child == this.left) {
            if (this.parent != null) {
                return this.parent.getIndex(this);
            }
            return 0;
        }
        if (child == null) {
            if (this.parent != null) {
                return this.parent.getIndex(this) + this.leftSize;
            }
            return this.leftSize;
        }
        if (child == this.right) {
            if (this.parent != null) {
                return this.parent.getIndex(this) + this.leftSize + 1;
            }
            return this.leftSize + 1;
        }
        throw new IndexOutOfBoundsException(this + " cannot get the index of a subtree that does not exist on this node!");
    }

    IndexedTreeNode insert(IndexedTree host, Object value) {
        IndexedTreeNode inserted;
        IndexedTreeNode subtree;
        boolean insertOnLeft = this.getSortSide(host.getComparator(), value) < 0;
        IndexedTreeNode indexedTreeNode = subtree = insertOnLeft ? this.left : this.right;
        if (insertOnLeft) {
            ++this.leftSize;
        } else {
            ++this.rightSize;
        }
        if (subtree == null) {
            inserted = new IndexedTreeNode(this, value);
            if (insertOnLeft) {
                this.left = inserted;
            } else {
                this.right = inserted;
            }
            inserted.ensureAVL(host);
        } else {
            inserted = subtree.insert(host, value);
        }
        return inserted;
    }

    IndexedTreeNode insert(IndexedTree host, int index, Object value) {
        IndexedTreeNode inserted;
        IndexedTreeNode subtree;
        boolean insertOnLeft = index <= this.leftSize;
        IndexedTreeNode indexedTreeNode = subtree = insertOnLeft ? this.left : this.right;
        if (insertOnLeft) {
            ++this.leftSize;
        } else {
            ++this.rightSize;
        }
        if (subtree == null) {
            inserted = new IndexedTreeNode(this, value);
            if (insertOnLeft) {
                this.left = inserted;
            } else {
                this.right = inserted;
            }
            inserted.ensureAVL(host);
        } else {
            int recurseIndex = insertOnLeft ? index : index - this.leftSize - 1;
            inserted = subtree.insert(host, recurseIndex, value);
        }
        return inserted;
    }

    IndexedTreeNode removeNode(IndexedTree host, int index) {
        if (index < this.leftSize) {
            --this.leftSize;
            return this.left.removeNode(host, index);
        }
        if (index > this.leftSize) {
            --this.rightSize;
            return this.right.removeNode(host, index - (this.leftSize + 1));
        }
        if (this.leftSize == 0 && this.rightSize == 0) {
            if (this.parent != null) {
                this.parent.replaceChildNode(this, null);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(null);
            }
        } else if (this.leftSize > 0 && this.rightSize == 0) {
            this.left.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, this.left);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.left);
            }
        } else if (this.leftSize == 0 && this.rightSize > 0) {
            this.right.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, this.right);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.right);
            }
        } else {
            IndexedTreeNode replacement = null;
            if (this.leftSize > this.rightSize) {
                --this.leftSize;
                replacement = this.left.pruneLargestChild(host);
            } else {
                --this.rightSize;
                replacement = this.right.pruneSmallestChild(host);
            }
            replacement.left = this.left;
            replacement.leftSize = this.leftSize;
            if (this.left != null) {
                this.left.parent = replacement;
            }
            replacement.right = this.right;
            replacement.rightSize = this.rightSize;
            if (this.right != null) {
                this.right.parent = replacement;
            }
            replacement.height = this.height;
            replacement.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, replacement);
            } else {
                host.setRootNode(replacement);
            }
        }
        this.clearNodeValues();
        return this;
    }

    IndexedTreeNode pruneSmallestChild(IndexedTree host) {
        if (this.leftSize > 0) {
            --this.leftSize;
            return this.left.pruneSmallestChild(host);
        }
        IndexedTreeNode replacement = null;
        if (this.rightSize != 0) {
            replacement = this.right;
            this.right.parent = this.parent;
        }
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
            this.parent.ensureAVL(host);
        } else {
            host.setRootNode(replacement);
        }
        this.clearNodeValues();
        return this;
    }

    IndexedTreeNode pruneLargestChild(IndexedTree host) {
        if (this.rightSize > 0) {
            --this.rightSize;
            return this.right.pruneLargestChild(host);
        }
        IndexedTreeNode replacement = null;
        if (this.leftSize != 0) {
            replacement = this.left;
            this.left.parent = this.parent;
        }
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
            this.parent.ensureAVL(host);
        } else {
            host.setRootNode(replacement);
        }
        this.clearNodeValues();
        return this;
    }

    public void removeFromTree(IndexedTree host) {
        if (!$assertionsDisabled && this.value == null) {
            throw new AssertionError();
        }
        if (this.leftSize == 0 && this.rightSize == 0) {
            if (this.parent != null) {
                this.parent.notifyChildNodeRemoved(this);
                this.parent.replaceChildNode(this, null);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(null);
            }
        } else if (this.leftSize > 0 && this.rightSize == 0) {
            this.left.parent = this.parent;
            if (this.parent != null) {
                this.parent.notifyChildNodeRemoved(this);
                this.parent.replaceChildNode(this, this.left);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.left);
            }
        } else if (this.leftSize == 0 && this.rightSize > 0) {
            this.right.parent = this.parent;
            if (this.parent != null) {
                this.parent.notifyChildNodeRemoved(this);
                this.parent.replaceChildNode(this, this.right);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(this.right);
            }
        } else {
            IndexedTreeNode middle = null;
            middle = this.leftSize > this.rightSize ? this.left.getLargestChildNode() : this.right.getSmallestChildNode();
            middle.removeFromTree(host);
            if (!($assertionsDisabled || middle.leftSize == 0 && middle.rightSize == 0)) {
                throw new AssertionError();
            }
            middle.left = this.left;
            middle.leftSize = this.leftSize;
            if (this.left != null) {
                this.left.parent = middle;
            }
            middle.right = this.right;
            middle.rightSize = this.rightSize;
            if (this.right != null) {
                this.right.parent = middle;
            }
            middle.height = this.height;
            middle.parent = this.parent;
            if (this.parent != null) {
                this.parent.replaceChildNode(this, middle);
                this.parent.ensureAVL(host);
            } else {
                host.setRootNode(middle);
            }
        }
        this.clearNodeValues();
    }

    private void clearNodeValues() {
        this.parent = null;
        this.left = null;
        this.leftSize = 0;
        this.right = null;
        this.rightSize = 0;
    }

    private void notifyChildNodeRemoved(IndexedTreeNode subtree) {
        if (subtree == this.left) {
            --this.leftSize;
        } else if (subtree == this.right) {
            --this.rightSize;
        } else {
            throw new IllegalArgumentException(this + " cannot remove a subtree that does not exist on this node!");
        }
        if (this.parent != null) {
            this.parent.notifyChildNodeRemoved(this);
        }
    }

    private void replaceChildNode(IndexedTreeNode original, IndexedTreeNode replacement) {
        if (original == this.left) {
            this.left = replacement;
        } else if (original == this.right) {
            this.right = replacement;
        } else {
            throw new IllegalArgumentException(this + " cannot replace a non-existant child");
        }
    }

    void validate(IndexedTree host) {
        if (this.left != null) {
            this.left.validate(host);
        }
        if (this.right != null) {
            this.right.validate(host);
        }
        if (host.getComparator() != null && this.sorted) {
            if (this.leftSize > 0 && this.left.sorted && host.getComparator().compare(this.left.value, this.value) > 0) {
                throw new IllegalStateException("" + this + "left node, \"" + this.left + "\" larger than middle node, \"" + this + "\"");
            }
            if (this.rightSize > 0 && this.right.sorted && host.getComparator().compare(this.value, this.right.value) > 0) {
                throw new IllegalStateException("" + this + " middle node, \"" + this + "\" larger than right node, \"" + this.right + "\"");
            }
        }
        if (this.left == null && this.leftSize != 0 || this.left != null && this.leftSize != this.left.size()) {
            throw new IllegalStateException("Cached leftSize " + this.leftSize + " != reported left.size() " + this.left.size());
        }
        if (this.right == null && this.rightSize != 0 || this.right != null && this.rightSize != this.right.size()) {
            throw new IllegalStateException("Cached rightSize " + this.rightSize + " != reported right.size() " + this.right.size());
        }
    }

    private void ensureAVL(IndexedTree host) {
        int oldHeight = this.height;
        this.recalculateHeight();
        this.avlRotate(host);
        if (this.height != oldHeight && this.parent != null) {
            this.parent.ensureAVL(host);
        }
    }

    private void recalculateHeight() {
        int leftHeight = this.left == null ? 0 : this.left.height;
        int rightHeight = this.right == null ? 0 : this.right.height;
        this.height = 1 + Math.max(leftHeight, rightHeight);
    }

    private void avlRotate(IndexedTree host) {
        int rightHeight;
        int leftHeight = this.left != null ? this.left.height : 0;
        int n = rightHeight = this.right != null ? this.right.height : 0;
        if (leftHeight - rightHeight >= 2) {
            int leftRightHeight;
            int leftLeftHeight = this.left.left != null ? this.left.left.height : 0;
            int n2 = leftRightHeight = this.left.right != null ? this.left.right.height : 0;
            if (leftRightHeight > leftLeftHeight) {
                this.left.rotateRight(host);
            }
            this.rotateLeft(host);
        } else if (rightHeight - leftHeight >= 2) {
            int rightRightHeight;
            int rightLeftHeight = this.right.left != null ? this.right.left.height : 0;
            int n3 = rightRightHeight = this.right.right != null ? this.right.right.height : 0;
            if (rightLeftHeight > rightRightHeight) {
                this.right.rotateLeft(host);
            }
            this.rotateRight(host);
        }
    }

    private void rotateLeft(IndexedTree host) {
        IndexedTreeNode replacement = this.left;
        this.left = replacement.right;
        this.leftSize = replacement.rightSize;
        if (replacement.right != null) {
            replacement.right.parent = this;
        }
        replacement.right = this;
        replacement.rightSize = this.size();
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
        } else {
            host.setRootNode(replacement);
        }
        replacement.parent = this.parent;
        this.parent = replacement;
        this.recalculateHeight();
        replacement.height = 0;
    }

    private void rotateRight(IndexedTree host) {
        IndexedTreeNode replacement = this.right;
        this.right = replacement.left;
        this.rightSize = replacement.leftSize;
        if (replacement.left != null) {
            replacement.left.parent = this;
        }
        replacement.left = this;
        replacement.leftSize = this.size();
        if (this.parent != null) {
            this.parent.replaceChildNode(this, replacement);
        } else {
            host.setRootNode(replacement);
        }
        replacement.parent = this.parent;
        this.parent = replacement;
        this.recalculateHeight();
        replacement.height = 0;
    }

    public String toString() {
        String leftString = this.left == null ? "." : this.left.toString();
        String valueString = this.value instanceof IndexedTreeNode ? "NODE_" + ((IndexedTreeNode)this.value).getIndex() : this.value.toString();
        String rightString = this.right == null ? "." : this.right.toString();
        return "(" + leftString + " " + valueString + " " + rightString + ")";
    }

    static {
        $assertionsDisabled = !IndexedTreeNode.class.desiredAssertionStatus();
        EMPTY_NODE = new IndexedTreeNode(null, "EMPTY_NODE");
    }
}

