/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.io;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.io.ByteCoder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListEventToBytes {
    private static final int CLEAR = -1;

    public static Bufferlo toBytes(ListEvent listEvent, ByteCoder byteCoder) throws IOException {
        ArrayList<ListEventPart> parts = new ArrayList<ListEventPart>();
        while (listEvent.next()) {
            int index = listEvent.getIndex();
            int type = listEvent.getType();
            Object value = null;
            if (type == 2 || type == 1) {
                value = listEvent.getSourceList().get(index);
            }
            parts.add(new ListEventPart(index, type, value));
        }
        return ListEventToBytes.partsToBytes(parts, byteCoder);
    }

    public static Bufferlo toBytes(EventList list, ByteCoder byteCoder) throws IOException {
        ArrayList<ListEventPart> parts = new ArrayList<ListEventPart>();
        parts.add(new ListEventPart(-1, -1, null));
        for (int i = 0; i < list.size(); ++i) {
            parts.add(new ListEventPart(i, 2, list.get(i)));
        }
        return ListEventToBytes.partsToBytes(parts, byteCoder);
    }

    public static void toListEvent(Bufferlo listEvent, EventList target, ByteCoder byteCoder) throws IOException {
        List parts = ListEventToBytes.bytesToParts(listEvent, byteCoder);
        Iterator i = parts.iterator();
        while (i.hasNext()) {
            ListEventPart part = (ListEventPart)i.next();
            if (part.isDelete()) {
                target.remove(part.getIndex());
                continue;
            }
            if (part.isUpdate()) {
                target.set(part.getIndex(), part.getValue());
                continue;
            }
            if (part.isInsert()) {
                target.add(part.getIndex(), part.getValue());
                continue;
            }
            if (!part.isClear()) continue;
            target.clear();
        }
    }

    private static Bufferlo partsToBytes(List parts, ByteCoder delegate) throws IOException {
        Bufferlo partsAsBytes = new Bufferlo();
        DataOutputStream dataOut = new DataOutputStream(partsAsBytes.getOutputStream());
        for (int i = 0; i < parts.size(); ++i) {
            ListEventPart part = (ListEventPart)parts.get(i);
            dataOut.writeInt(i);
            dataOut.writeInt(part.getType());
            if (part.hasIndex()) {
                dataOut.writeInt(part.getIndex());
            }
            if (!part.hasValue()) continue;
            Bufferlo valueBuffer = new Bufferlo();
            delegate.encode(part.getValue(), valueBuffer.getOutputStream());
            dataOut.writeInt(valueBuffer.length());
            dataOut.flush();
            partsAsBytes.append(valueBuffer);
        }
        return partsAsBytes;
    }

    private static List bytesToParts(Bufferlo partsAsBytes, ByteCoder delegate) throws IOException {
        ArrayList<ListEventPart> parts = new ArrayList<ListEventPart>();
        DataInputStream dataIn = new DataInputStream(partsAsBytes.getInputStream());
        while (partsAsBytes.length() > 0) {
            ListEventPart currentPart = new ListEventPart();
            int expectedPartIndex = parts.size();
            int partIndex = dataIn.readInt();
            if (partIndex != expectedPartIndex) {
                throw new IOException("Expected " + expectedPartIndex + " but found " + partIndex);
            }
            currentPart.setType(dataIn.readInt());
            if (currentPart.hasIndex()) {
                currentPart.setIndex(dataIn.readInt());
            }
            if (currentPart.hasValue()) {
                int valueLength = dataIn.readInt();
                Bufferlo valueBuffer = partsAsBytes.consume(valueLength);
                Object value = delegate.decode(valueBuffer.getInputStream());
                currentPart.setValue(value);
            }
            parts.add(currentPart);
        }
        return parts;
    }

    static class ListEventPart {
        private int index = -1;
        private int type = -1;
        private Object value = null;

        public ListEventPart(int index, int type, Object value) {
            this.index = index;
            this.type = type;
            this.value = value;
        }

        public ListEventPart() {
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean isDelete() {
            return this.type == 0;
        }

        public boolean isUpdate() {
            return this.type == 1;
        }

        public boolean isInsert() {
            return this.type == 2;
        }

        public boolean isClear() {
            return this.type == -1;
        }

        public boolean hasIndex() {
            return this.isUpdate() || this.isInsert() || this.isDelete();
        }

        public boolean hasValue() {
            return this.isUpdate() || this.isInsert();
        }
    }
}

