// bool_marshal.h                           -*-c++-*-
//
//  Copyright 2004 Daniel Burrows
//
// More sensible marshalers for boolean return values.

#ifndef BOOL_MARSHAL_H
#define BOOL_MARSHAL_H

/** Computes its return value via a short-circuiting AND.  If no
 *  signals are connected, the return value is "true".
 */
class MarshalAnd
{
  bool rval;
public:
  typedef bool OutType;
  typedef bool InType;

  MarshalAnd()
    :rval(true) {}

  OutType value() {return rval;}

  static OutType default_value() {return true;}

  bool marshal(InType newval)
  {
    if(!newval)
      {
	rval=false;
	return true;
      }
    else
      return false;
  }
};

/** Computes its return value via a short-circuiting OR.  If no
 *  signals are connected, the return value is "false".
 */
class MarshalOr
{
  bool rval;
public:
  typedef bool OutType;
  typedef bool InType;

  MarshalOr()
    :rval(false) {}

  OutType value() {return rval;}

  static OutType default_value() {return false;}

  bool marshal(InType newval)
  {
    if(newval)
      {
	rval=true;
	return true;
      }
    else
      return false;
  }
};

#endif
