/*
 * Detect a Library for hardware detection
 *
 * Copyright (C) 1998-2000 MandrakeSoft
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "discover.h"
#include "utils.h"


struct tape_info *tape_detect(struct bus_lst *bus){
  struct ide_info *ide= (struct ide_info *)NULL;
  struct scsi_info *scsi= (struct scsi_info *)NULL;  
  static struct tape_info *first = (struct tape_info *)NULL;
  struct tape_info *result = (struct tape_info *)NULL;


  if(debug)
    fprintf(stdout, "\nProbing Tapes...\n");

  
  /********************************************************************/
  /**************************** IDE Tapes *****************************/
  /********************************************************************/
 if(debug)
   fprintf(stdout, "\tProbing IDE Tapes...\n");
  for(ide = bus->ide; ide; ide = ide->next){
    if(ide->type == TAPE){
      if(!first){
        first = result = (struct tape_info *)
                                    my_malloc(sizeof(struct tape_info));
      }else{
        result->next = (struct tape_info *)
                                    my_malloc(sizeof(struct tape_info));
        result = result->next;
      }/*endif*/
      result->next = (struct tape_info *)NULL;
      result->vendor = s_unknown;
      result->model = ide->model;
      result->device = ide->device;
      result->bus = IDE;
      if(debug)
	fprintf(stdout, ("\t\tFound %s on %s\n"),
		result->model, result->device);
    }/*endif*/
  }/*next ide*/
  
  
  /********************************************************************/
  /**************************** SCSI Tapes ****************************/
  /********************************************************************/
  if(debug)
    fprintf(stdout, "\tProbing SCSI Tapes...\n");
  for(scsi = bus->scsi; scsi; scsi = scsi->next){
    if(scsi->type == TAPE){
      if(!first){
        first = result = (struct tape_info *) 
                                    my_malloc(sizeof(struct tape_info));
      }else{
        result->next = (struct tape_info *)
                                    my_malloc(sizeof(struct tape_info));
        result = result->next;
      }/*endif*/
      result->next = (struct tape_info *)NULL;
      result->vendor = scsi->vendor;
      result->model = scsi->model;
      result->device = scsi->device;
      result->bus = SCSI;
      if(debug)
	fprintf(stdout, ("\t\tFound %s on %s\n"),
		result->model, result->device);
    }/*endif*/
  }/*next scsi*/
  return first;
}/*endfunc tape_detect*/
