/*
**  Copyright (c) 2008 Sendmail, Inc. and its suppliers.
**      All rights reserved.
**
**  $Id: dkim-db.h,v 1.4 2008/10/16 23:02:37 msk Exp $
*/

#ifndef _DKIM_DB_H_
#define _DKIM_DB_H_

#ifndef lint
static char dkim_db_h_id[] = "@(#)$Id: dkim-db.h,v 1.4 2008/10/16 23:02:37 msk Exp $";
#endif /* !lint */

/* system includes */
#include <pthread.h>

/* libdb includes */
#include <db.h>

/* dkim-filter includes */
#include "dkim-filter.h"

#ifndef DB_NOTFOUND
# define DB_NOTFOUND    1
#endif /* ! DB_NOTFOUND */
#ifndef DB_VERSION_MAJOR
# define DB_VERSION_MAJOR   1
#endif /* ! DB_VERSION_MAJOR */

#define DB_VERSION_CHECK(x,y,z) ((DB_VERSION_MAJOR == (x) && \
				  DB_VERSION_MINOR == (y) && \
				  DB_VERSION_PATCH >= (z)) || \
				 (DB_VERSION_MAJOR == (x) && \
				  DB_VERSION_MINOR > (y)) || \
				 DB_VERSION_MAJOR > (x))

#if DB_VERSION_CHECK(3,0,0)
# define DB_STRERROR(x)		db_strerror(x)
#else /* DB_VERSION_CHECK(3,0,0) */
# define DB_STRERROR(x)		strerror(errno)
#endif /* DB_VERSION_CHECK(3,0,0) */

#if DB_VERSION_MAJOR < 2
# define DKIMF_DBCLOSE(db)	(db)->close((db))
#else /* DB_VERSION_MAJOR < 2 */
# define DKIMF_DBCLOSE(db)	(db)->close((db), 0)
#endif /* DB_VERSION_MAJOR < 2 */

/* PROTOTYPES */
extern int dkimf_db_delete __P((DB *, char *, pthread_mutex_t *));
extern int dkimf_db_get __P((DB *, char *, void *, size_t *, bool *,
                             pthread_mutex_t *));
extern int dkimf_db_open_ro __P((DB **, const char *));
extern int dkimf_db_open_rw __P((DB **, const char *));
extern int dkimf_db_put __P((DB *, char *, void *, size_t,
                             pthread_mutex_t *));

#endif /* _DKIM_DB_H_ */
