/*
                            Configuration Fetching
 */

#ifndef EDV_GET_H
#define EDV_GET_H

#include <glib.h>
#include "edv_context.h"


/*
 *	Gets the complete list of Endeavour 2 configuration parameters.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The total specifies the return value for the number of
 *	configuration parameters.
 *
 *	Returns a dynamically allocated list of configuration
 *	parameters. The calling function must delete the returned
 *	pointer array and each string.
 */
extern gchar **EDVGetConfigurationParameters(
	edv_context_struct *ctx,
	gint *total
);

/*
 *	Gets the boolean value of the configuration parameter.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The parm specifies the configuration parameter.
 */
extern gboolean EDVGetB(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the integer value of the configuration parameter.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The parm specifies the configuration parameter.
 */
extern gint EDVGetI(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the long integer value of the configuration parameter.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The parm specifies the configuration parameter.
 */
extern glong EDVGetL(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the unsigned long integer value of the configuration
 *	parameter.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The parm specifies the configuration parameter.
 */
extern gulong EDVGetUL(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the float value of the configuration parameter.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The parm specifies the configuration parameter.
 */
extern gfloat EDVGetF(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the double value of the configuration parameter.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The parm specifies the configuration parameter.
 */
extern gdouble EDVGetD(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the string value of the configuration parameter.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The parm specifies the configuration parameter.
 *
 *	The returned pointer must not be modified or deleted. Can
 *	return NULL if the parameter does not exist.
 */
extern const gchar *EDVGetS(edv_context_struct *ctx, const gchar *parm);

/*
 *	Gets the version of Endeavour 2 from the configuration.
 *
 *	Returns TRUE on success or FALSE on error.
 */
extern gboolean EDVGetVersion(
	edv_context_struct *ctx,
	gint *major,
	gint *minor,
	gint *release
);


#endif	/* EDV_GET_H */
