/*
 * rsa_crypt_lib.h - header-file for RSA-crypt-library
 *
 * iTALC
 * Copyright (c) 2004-2005 Tobias Doerffel <tobias@doerffel.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */


#ifndef _RSA_CRYPT_LIB_H
#define _RSA_CRYPT_LIB_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#ifdef HAVE_RSA_H

#define RSA_CRYPT_AVAILABLE

#include <openssl/rsa.h>


#ifdef __cplusplus
extern "C"
{
#endif

RSA * createNewRSA( void );
RSA * readPrivateKey( const char * _fname );
RSA * readPublicKey( const char * _fname );
void writePrivateKey( RSA * _priv_key, const char * _fname );
void writePublicKey( RSA * _pub_key, const char * _fname );
RSA * rsaGeneratePrivateKey( unsigned int _bits );
RSA * publicKeyFromPrivateKey( RSA * _src_dsa);
int rsaGenerateChallenge( char ** _cb );
void rsaFreeChallenge( char * _cb );

#define DEFAULT_CHALLENGE_SIZE 64

#ifdef __cplusplus
}
#endif

#endif

#endif
