/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qpixmap.h>
#include <qrect.h>

#include <kdebug.h>
#include <klocale.h>

#include "datastruct/DDataItem.h"
#include "aux.h"
#include "DCanvasItem.h"
#include "DCanvasView.h"
#include "DCanvasTip.h"

	DCanvasTip::DCanvasTip( DCanvasView * parent )
: QToolTip( parent )
{
	m_view = parent;
}

void DCanvasTip::maybeTip( const QPoint &pos )
{
	int id = m_view->locateItem( m_view->viewportToContents( pos ) );

	if (id == DItem::NOITEM)
	{
		//kdWarning()<<"item not found"<<endl;
		return;
	}

	DDataItem *item = m_view->dataItem( id );
	DCanvasItem * citem = m_view->canvasItem( id );

	QRect r = citem->rect();
	QPoint tl = m_view->contentsToViewport( r.topLeft() );
	QPoint br = m_view->contentsToViewport( r.bottomRight() );

	// try do display something informative
	if (item->m_text.length() > 13) // <html></html>
	{
		tip( QRect(tl, br), item->m_text );
	}
	else if (item->m_piccaption.length() > 0)
	{
		tip( QRect(tl, br), item->m_piccaption );
	}
	else
	{
		tip( QRect(tl, br), i18n("(Empty)") );
	}
}

