// Copyright(C) 2007 Stefan Siegl <stesie@brokenpipe.de>
//
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


#include "silcchannelcontactinfowidget.h"
#include "silcchannelcontact.h"
#include "silcaccount.h"

#include <kopeteuiglobal.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <klocale.h>

#include <qlineedit.h>
#include <qcheckbox.h>

SilcChannelContactInfoWidget::SilcChannelContactInfoWidget
(SilcChannelContact *c)
  : SilcChannelContactInfo(), _channel(c)
{
  chname->setText(c->nickName());
  topic->setText(c->topic());

  chkAllowRichText->setChecked(c->allowRichText());

  // initialize channel config check boxes ...
  chkPrivate->setChecked(c->isPrivate());
  chkSecret->setChecked(c->isSecret());
  chkInviteOnly->setChecked(c->isInviteOnly());
  chkSilenceUser->setChecked(c->isSilenceUser());
  chkSilenceOperator->setChecked(c->isSilenceOperator());


  // possibly disable all widgets, to keep user from editing ...
  SilcBuddyContact *me = _channel->account()->myself();
  bool allowFounderChanges = c->isFounder(me);
  bool allowChanges = c->isOp(me) || allowFounderChanges;

  topic->setReadOnly(!allowChanges);
  chkPrivate->setEnabled(allowChanges);
  chkSecret->setEnabled(allowChanges);
  chkInviteOnly->setEnabled(allowChanges);
  chkSilenceUser->setEnabled(allowFounderChanges);
  chkSilenceOperator->setEnabled(allowFounderChanges);


  // connect buttons ...
  QObject::connect((QObject *) buttonOk, SIGNAL(clicked()),
		   this, SLOT(slotOk()));
  QObject::connect((QObject *) buttonApply, SIGNAL(clicked()),
		   this, SLOT(slotApply()));
  QObject::connect((QObject *) buttonCancel, SIGNAL(clicked()),
		   this, SLOT(slotCancel()));

  show();
}

SilcChannelContactInfoWidget::~SilcChannelContactInfoWidget()
{
}

void
SilcChannelContactInfoWidget::slotApply(void)
{
  SilcBuddyContact *me = _channel->account()->myself();

  bool allowFounderChanges = _channel->isFounder(me);
  bool allowChanges = _channel->isOp(me) || allowFounderChanges;

  if(allowChanges) {
    QString newTopic = topic->text();
    _channel->setTopic(newTopic);
  }

  if(allowChanges) {
    _channel->setPrivate(chkPrivate->isChecked());
    _channel->setSecret(chkSecret->isChecked());
    _channel->setInviteOnly(chkInviteOnly->isChecked());
  }

  if(allowFounderChanges) {
    _channel->setSilenceUser(chkSilenceUser->isChecked());
    _channel->setSilenceOperator(chkSilenceOperator->isChecked());
  }

  _channel->setAllowRichText(chkAllowRichText->isChecked());
}

void
SilcChannelContactInfoWidget::slotOk(void)
{
  slotApply();
  delete this;
}

void
SilcChannelContactInfoWidget::slotCancel(void)
{
  delete this;
}


#include "silcchannelcontactinfowidget.moc"

