/***************************************************************************
                          ksubtileview.h  -  description
                             -------------------
    begin                : di feb  4 15:33:11 CET 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KSUBTILEVIEW_H
#define KSUBTILEVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>

#include "ksubtiledlg.h"
#include "ksubtile.h"
#include "ksubtileplayer.h"
#include "ksubtiledoc.h"
#include "csubtitle.h"

class KSubtileDoc;
class KSubtileApp;
class KSubtilePlayer;

/** The KSubtileView class provides the view widget for the KSubtileApp
instance. * The View instance inherits QWidget as a base class and represents
the view object of a KTMainWindow. As KSubtileView is part of the *
docuement-view model, it needs a reference to the document object connected with
it by the KSubtileApp class to manipulate and display * the document structure
provided by the KSubtileDoc class. * * @author Source Framework Automatically
Generated by KDevelop, (c) The KDevelop Team. * @version KDevelop version 0.4
code generation */
class KSubtileView : public KSubtileDlg
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    KSubtileView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KSubtileView();

    /** returns a pointer to the document connected to the view instance. Mind
that this method requires a KSubtileApp instance as a parent     * widget to get
to the window document pointer by calling the KSubtileApp::getDocument() method.
    *     * @see KSubtileApp#getDocument
     */
    KSubtileDoc *getDocument() const;

	KSubtileApp *theApp;

    /** Get the player object
	  * @return A pointer to the player
	*/
    KSubtilePlayer* getPlayer(void);

  private slots:

    /** Tells us if we zoomed out to the maximum or not
	*/
    void slotEditorMaxZoomedOut(bool isMax);
    /** Tells us if we zoomed in to the minimum or not
	*/
	void slotEditorMaxZoomedIn(bool isMax);
	/** We reached the right end of the subtitles(length of subtitles)
	*/
    void slotEditorRightEndReached(bool isReached);
	/** We reached the left end of the subtitles(0:00:00,000)
	*/
    void slotEditorLeftEndReached(bool isReached);
    /** Gives us the new starttime from which the navigator shows subs after zooming in or out
	*/
	void slotEditorZoomStartTimeChanged(long newTime);
    /** Gives us the new endtime from which the navigator shows subs after zooming in or out
	*/
	void slotEditorZoomEndTimeChanged(long newtime);

	/** We selected a sub.  Used in the stretch tab.
	*/
    void slotStretchSubClicked(CSubtitle * sub);
	/** We selected a sub.  Used in the move tab.
	*/
	void slotMoveSubClicked(CSubtitle * sub);
	/** We selected a sub.  Used in the ccp tab.
	*/
    void slotCCPSubClicked(CSubtitle * sub);
	/** We selected a sub.  Used in the editor tab.
	*/
    void slotEditorSubClicked(CSubtitle * sub);


	/** If there are no subs in the navigator then we get a signal and this slot is
	  * executed.  If en/disables the "select from list" button.
	*/
	void slotEditorCheckIfNoSubs(bool areThereNoSubs);


  private:
	  virtual void tw_editor_selected( const QString & );
    virtual void pb_stretch_apply_clicked( void );
    virtual void te_stretch_startTime_valueChanged( const QTime & );
    virtual void sb_stretch_startTime_valueChanged( int );

    virtual void pb_move_apply_clicked( void );
    virtual void te_move_startTime_valueChanged( const QTime & );
    virtual void sb_move_startTime_valueChanged( int );
    virtual void rb_move_select_firstSub_clicked(void);
    virtual void rb_move_select_lastSub_clicked(void);

    virtual void pb_stretch_curpos_startTime_clicked(void);
    virtual void pb_move_curpos_startTime_clicked(void);
    virtual void pb_editor_curpos_startTime_clicked(void);

    virtual void pb_stretch_play_startTime_clicked(void);
    virtual void pb_move_play_startTime_clicked(void);
    virtual void pb_editor_play_startTime_clicked(void);

    virtual void pb_editor_navigator_barZoomIn_clicked(void);
    virtual void pb_editor_navigator_barZoomOut_clicked(void);
    virtual void pb_editor_navigator_barScrollLeft_clicked(void);
    virtual void pb_editor_navigator_barScrollRight_clicked(void);
    virtual void pb_editor_navigator_barScrollLeftFast_clicked(void);
    virtual void pb_editor_navigator_barScrollRightFast_clicked(void);
    virtual void cb_editor_navigator_barZoomCurrent_clicked(void);
    virtual void pb_editor_navigator_selectFromList_clicked(void);

    virtual void pb_ccp_apply_clicked(void);
    virtual void pb_ccp_quickSelect_begin_clicked(void);
    virtual void pb_ccp_quickSelect_end_clicked(void);
    virtual void com_ccp_afterBefore_highlighted(const QString &);
    virtual void com_ccp_afterBefore_activated(const QString &);
    virtual void te_ccp_offset_valueChanged( const QTime & );
    virtual void sb_ccp_offset_valueChanged( int );
    virtual void lv_ccp_subtitlesList_selectionChanged(void);
    virtual void pb_ccp_selectAll_clicked(void);
    virtual void pb_ccp_copy_clicked(void);
    virtual void pb_ccp_cut_clicked(void);
    
    virtual void pb_editor_after_go_clicked(void);
    virtual void pb_editor_before_go_clicked(void);
    virtual void pb_editor_after_addNew_clicked(void);
    virtual void pb_editor_before_addNew_clicked(void);
    virtual void pb_editor_after_deleteAll_clicked(void);
    virtual void pb_editor_before_deleteAll_clicked(void);
    virtual void pb_editor_deleteCurrent_clicked(void);

    virtual void te_editor_startTime_valueChanged( const QTime & );
    virtual void sb_editor_startTime_valueChanged( int );
    virtual void te_editor_length_valueChanged( const QTime & );
    virtual void sb_editor_length_valueChanged( int );

    virtual void le_editor_line1_textChanged( const QString & );
    virtual void le_editor_line2_textChanged( const QString & );

    virtual void pb_editor_apply_clicked(void);

    void initInfo(void);
    void initStretch(void);
    void initMove(void);
    void initCCP(void);
    void initEditor(void);

/*     // enable/disable functions */

    void stretch_enable(bool enable);
    void move_enable(bool enable);
    void ccp_enable(bool enable);
    void editor_enable(bool enable);

/*     // reset functions */

    void stretch_reset(void);
    void move_reset(void);
    void ccp_reset(void);
    void editor_reset(void);

    /** removes all connected signals to the navigator's subClicked function
	*/
    void removeConnectionsToNavigator(void);

	////////////////////STRETCH

    /** Remember the selected subtitle in the stretch tab
	 */

    CSubtitle* sub_stretch_sub;

    /** To prevent the valueChanged functions of the timeedit in the stretch tab to
      * be executed
	 */
    bool b_enable_stretch_valuechanged;

    /** These indicate between which values the starttime of the sub in the
      * stretch tab can be changed
	 */
    long stretch_limitSub_left;
    long stretch_limitSub_right;


	////////////////////MOVE

    /** Select first sub or last sub in move tab
	*/

    void move_setFirstSub(CSubtitle * firstSub);
    void move_setLastSub(CSubtitle * lastSub);

    /** To remember the subs which were selected in the move tab
	 */

    CSubtitle* sub_move_firstSub;
    CSubtitle* sub_move_lastSub;

    /** These indicate between which values the starttime of the first sub in
      * the move tab can be changed
	 */
    long move_limitFirstSub_left;
    long move_limitFirstSub_right;

    /** To prevent the valueChanged functions of the timeedits in the move tab to
     be executed */
    bool b_enable_move_valuechanged;

    ////////////////////CCP

	/** Fill in the offset timeedit and en/disable the appy button if no space is available to do an insert.
	*/
	void ccp_fillInOffset(void);

	/** Fill in the list with subtitles in the cut/copy tab
	*/
	void ccp_fillInList(void);
	
	/** Enable or disable controls in the copy/cut section and apply button and timeedit in the ccp tab
	*/
    void ccp_copyCut_enable(bool enabled);

	/** Enable or disable the apply button on the ccp tab, according to if there are subtitles to be pasted in memory
	*/

	void ccp_enableApply(void);

    /** To remember the sub which is used to calculate the offset from
	*/
    CSubtitle* sub_ccp_sub;

	/** To prevent the valueChanged functions of the timeedit in the ccp tab to
     be executed */
    bool b_enable_ccp_valuechanged;

    /** This indicates the maximum time-offset which the paste-offset in the ccp tab can have
	 */
    long ccp_limitOffset_max;


	/////////////////////EDITOR

    /** To prevent the valueChanged functions of the timeedits in the editor tab to
      * be executed
	*/
    bool b_enable_editor_valuechanged;

	/** set a sub as current sub to edit, fill in fields and show sub in navigator
    */
	void selectSub(CSubtitle* sub);

    /** SelectSub fills these values in so we can check easily if the user is
      * changing the sub within the possible boundaries
	  */
    long editor_limitSub_endPreviousSub;
	long editor_limitSub_startNextSub;

    /** Determines if we are in addNew-mode or not.  Activated when user clicks addnew(of course :-)) and
	  * disactivated when we select another sub or when we apply the sub.
      */
	bool editor_addNew_mode;

	/** Enable or disable buttons (go, add, delete all) according to current sub
	*/
	void editor_enable_buttons(void);

	/** Enables apply button if line1 is filled in
	*/
    void editor_apply_enable(void);

};

#endif // KSUBTILEVIEW_H
