/***************************************************************************
                          subtitlenavigator.cpp  -  description
                             -------------------
    begin                : Tue Feb 25 2003
    copyright            : (C) 2003 by Tom Deblauwe
    email                : tom.deblauwe@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "math.h"
#include "stdlib.h"
#include "subtitlenavigator.h"
#include "qpainter.h"
#include "ksubtile.h"
#include "pref.h"
#include "kconfig.h"

SubtitleNavigator::SubtitleNavigator(QWidget *parent, const char *name ) : QLabel(parent,name)
{
  //draw a border
  setFrameStyle(QFrame::Box + QFrame::Plain);
  setBackgroundMode( NoBackground );
  buffer = QPixmap(width(), height());
  buffer.fill( white );
  subtitles = new CSubtitles();
  zoomStartTime = 0;
  zoomEndTime = 0;
  minVisibleMSecs = 3000;
  highlightSub = 0;
  selectedSubtitleCentered = true;
//  zoomFactor = 1;
//  maxZoomFactor = 32;
//  leftmostVisiblePixel = 0;
//  printf("width %d, height %d", width(), height());
}
SubtitleNavigator::~SubtitleNavigator(){
}

void SubtitleNavigator::drawSubs(CSubtitles * subtitles, bool newSubs, CSubtitle *highlightSub)
{
//  printf("draw subs");

  if(newSubs)
  {
    if(subtitles->getNrOfSubtitles() == 0)
    {
      zoomEndTime = 0;
      zoomStartTime = 0;
    }
    else
    {
      zoomEndTime = subtitles->getTotalOccupiedTime();
      zoomStartTime = 0;
    }
  }

  //we always need to select a sub
  if(highlightSub != 0)
  {
      this->highlightSub = highlightSub;
  }
  else
  {
      this->highlightSub = subtitles->getFirstSubtitle();
  }

  //get total amount of msecs
  long totalmsecs = zoomEndTime - zoomStartTime;

  //ratio so subtitles can be converted to fit in the buffer
  double ratio = (double) width() / (double)totalmsecs;
//  printf("ratio:%f",ratio);

//get brushes from config
	kapp->config()->setGroup("Editor Options");
    QColor subColor = kapp->config()->readColorEntry("Navigator Subtitle Color", &ksubtilePreferences::pref_NavigatorSubtitleColor);
    QColor subHighlightColor = kapp->config()->readColorEntry("Navigator Highlight Subtitle Color", &ksubtilePreferences::pref_NavigatorHighlightSubtitleColor);
    QColor subBackgroundColor = kapp->config()->readColorEntry("Navigator Background Color", &ksubtilePreferences::pref_NavigatorBackgroundColor);

  //clear
  buffer.fill( subBackgroundColor );
  //paint the right piece of largebuffer on the screen, and to buffer
  QPainter painter;
  QPainter bufferpainter;
  painter.begin( this );
  bufferpainter.begin( &buffer );
  painter.fillRect(0,0,width(),height(), QBrush( subBackgroundColor ));
  //paint green
  QBrush brush = QBrush( subColor );
  QPen pen(red, 1);
  bufferpainter.setPen(pen);


    bool displayText = kapp->config()->readBoolEntry("Display Text", ksubtilePreferences::pref_NavigatorDisplayText);

    //set the font and pen to draw the text
    QFont font("courier new"); // Use the global KDE font. Let's hope it's appropriate.
    font.setPointSize( 8 );
    QFontMetrics fm( font );
    bufferpainter.setFont( font );
    painter.setFont( font );
    QPen textPen( black, 1 );
	int charWidth = fm.width( " " );

  //paint total buffer
  QPtrListIterator<CSubtitle> it = subtitles->getIterator();
  CSubtitle* sub;
    while ( (sub = it.current() ) != 0 )
    {
        ++it;
        if(sub->getStartTime() >= zoomStartTime && sub->getEndTime() <= zoomEndTime)
        {
            if(this->highlightSub != 0)
            {
                if(*this->highlightSub == *sub)
                {
                    brush = QBrush( subHighlightColor );
                }
            }
            long left = long(((sub->getStartTime() - zoomStartTime) * ratio) + 0.5);
            long right = long(((sub->getEndTime() - zoomStartTime) * ratio) + 0.5);
            bufferpainter.fillRect(left, 0, right-left, height(), brush);
            painter.fillRect(left, 0, right-left, height(), brush);

	        //draw beginning of text of sub if enough space for it

            if(displayText)
			{
			    bool doText = false;
				QString str = "";
				if(uint(right-left) > sub->getLine1().length() * charWidth + 10)
				{
					//the line fits in
					str = sub->getLine1().stripWhiteSpace();
					doText = true;
				}
				else if(right - left > (charWidth * 4) + 10)
				{
				    //we can fit 10 characters in for sure
				    //calculate how many characters we can fit in
					int chars = (int) ((double) ((right - left) - 10) / (double) charWidth);
					str = sub->getLine1().left(chars - 3).stripWhiteSpace() + "...";
					doText = true;
				}
                if(doText)
				{
				    bufferpainter.setPen(textPen);
			        painter.setPen(textPen);
			        bufferpainter.drawText(left + 5,20, str);
			        painter.drawText(left + 5,20, str);
			        bufferpainter.setPen(pen);
			        painter.setPen(pen);
				}
            }

			brush = QBrush( subColor );
//      bufferpainter.drawRect(left, 0, right-left, height());
        }
        if(sub->getStartTime() < zoomStartTime &&
            sub->getEndTime() > zoomStartTime &&
            sub->getEndTime() <= zoomEndTime)
        {
            if(this->highlightSub != 0)
            {
                if(*this->highlightSub == *sub)
                {
                    brush = QBrush( subHighlightColor );
                }
            }
            long left = 0;
            long right = long(((sub->getEndTime() - zoomStartTime) * ratio) + 0.5);

//      printf("\nright: %ld",right);
            bufferpainter.fillRect(left, 0, right-left, height(), brush);
            painter.fillRect(left, 0, right-left, height(), brush);

            if(displayText)
			{
			    bool doText = false;
				QString str = "";
				if(uint(right-left) > (sub->getLine1().length() + 3) * charWidth + 10)
				{
					//the line fits in
					str = "<- " + sub->getLine1().stripWhiteSpace();
					doText = true;
				}
				else if(right - left > (charWidth * 7) + 10)
				{
				    //we can fit 13 characters in for sure
				    //calculate how many characters we can fit in
					int chars = (int) ((double) ((right - left) - 10) / (double) charWidth);
					str = "<- " + sub->getLine1().left(chars - 6).stripWhiteSpace() + "...";
					doText = true;
				}
                if(doText)
				{
				    bufferpainter.setPen(textPen);
			        painter.setPen(textPen);
			        bufferpainter.drawText(left + 5,20, str);
			        painter.drawText(left + 5,20, str);
			        bufferpainter.setPen(pen);
			        painter.setPen(pen);
				}
            }


	        brush = QBrush( subColor );
        }
        if(sub->getStartTime() >= zoomStartTime &&
            sub->getStartTime() < zoomEndTime &&
            sub->getEndTime() > zoomEndTime)
        {
            if(this->highlightSub != 0)
            {
                if(*this->highlightSub == *sub)
                {
                    brush = QBrush( subHighlightColor );
                }
            }
            long left = long(((sub->getStartTime() - zoomStartTime) * ratio) + 0.5);
            long right = width();
            bufferpainter.fillRect(left, 0, right-left, height(), brush);
            painter.fillRect(left, 0, right-left, height(), brush);

            if(displayText)
			{
			    bool doText = false;
				QString str = "";
				if(uint(right-left) > (sub->getLine1().length() + 3) * charWidth + 10)
				{
					//the line fits in
					str = sub->getLine1().stripWhiteSpace() + " ->";
					doText = true;
				}
				else if(right - left > (charWidth * 7) + 10)
				{
				    //we can fit 13 characters in for sure
				    //calculate how many characters we can fit in
					int chars = (int) ((double) ((right - left) - 10) / (double) charWidth);
					str = sub->getLine1().left(chars - 6).stripWhiteSpace() + "... ->";
					doText = true;
				}
                if(doText)
				{
				    bufferpainter.setPen(textPen);
			        painter.setPen(textPen);
			        bufferpainter.drawText(left + 5,20, str);
			        painter.drawText(left + 5,20, str);
			        bufferpainter.setPen(pen);
			        painter.setPen(pen);
				}
            }


			brush = QBrush( subColor );
        }
        if(sub->getStartTime() < zoomStartTime &&
            sub->getEndTime() > zoomEndTime)

        {
            if(this->highlightSub != 0)
            {
                if(*this->highlightSub == *sub)
                {
                    brush = QBrush( subHighlightColor );
                }
            }
            long left = 0;
            long right = width();
            bufferpainter.fillRect(left, 0, right-left, height(), brush);
            painter.fillRect(left, 0, right-left, height(), brush);

            if(displayText)
			{
			    bool doText = false;
				QString str = "";
				if(uint(right-left) > (sub->getLine1().length() + 6) * charWidth + 10)
				{
					//the line fits in
					str = "<- " + sub->getLine1().stripWhiteSpace() + " ->";
					doText = true;
				}
				else if(right - left > (charWidth * 10) + 10)
				{
				    //we can fit 16 characters in for sure
				    //calculate how many characters we can fit in
					int chars = (int) ((double) ((right - left) - 10) / (double) charWidth);
					str = "<- " + sub->getLine1().left(chars - 9).stripWhiteSpace() + "... ->";
					doText = true;
				}
                if(doText)
				{
				    bufferpainter.setPen(textPen);
			        painter.setPen(textPen);
			        bufferpainter.drawText(left + 5,20, str);
			        painter.drawText(left + 5,20, str);
			        bufferpainter.setPen(pen);
			        painter.setPen(pen);
				}
            }


			brush = QBrush( subColor );
        }

    }
    bufferpainter.end();


//  painter.drawPixmap(0, 0, largebuffer, leftmostVisiblePixel, 0, width(), -1);
//  bufferpainter.drawPixmap(0, 0, largebuffer, leftmostVisiblePixel, 0, width(), -1);
//  painter.setPen(pen);
//  painter.drawRect(width()/2, 0,1, height());

    painter.end();

    this->subtitles = subtitles;

	if(zoomEndTime == subtitles->getTotalOccupiedTime() && zoomStartTime == 0)
	{
		emit maxZoomedOut(true);
	}
	else
	{
		emit maxZoomedOut(false);
	}
	if(totalmsecs == minVisibleMSecs)
	{
		emit maxZoomedIn(true);
	}
	else
	{
		emit maxZoomedIn(false);
	}

	if(subtitles->getNrOfSubtitles() == 0)
	{
		emit maxZoomedOut(true);
		emit maxZoomedIn(true);
	}


	if(zoomStartTime == 0)
	{
		emit leftEndReached(true);
	}
	else
	{
		emit leftEndReached(false);
	}

	if( zoomEndTime == subtitles->getTotalOccupiedTime() )
	{
		emit rightEndReached(true);
	}
	else
	{
		emit rightEndReached(false);
	}

	emit zoomEndTimeChanged(zoomEndTime);
	emit zoomStartTimeChanged(zoomStartTime);

		//this is to notify the "select from list" button

	if(subtitles->getNrOfSubtitles() == 0)
	{
		emit noSubs(true);
	}
	else
	{
		emit noSubs(false);
	}
}

long SubtitleNavigator::getWidthMSecs()
{
  return zoomEndTime - zoomStartTime;
}

CSubtitle* SubtitleNavigator::getSelectedSubtitle()
{
    return highlightSub;
}

//if set to true then we center the selected subtitle(highlightSub) when zooming
//if set to false, then we do not center the selected subtitle when zooming, but zoom in the middle of the screen

void SubtitleNavigator::setSelectedSubtitleCentered(bool centered)
{
    selectedSubtitleCentered = centered;
    if(centered)
    {
        slotShowSub(highlightSub);
    }
}

void SubtitleNavigator::mouseMoveEvent( QMouseEvent*)
{

}

void SubtitleNavigator::mousePressEvent( QMouseEvent* event)
{
  //determine on what time was clicked
  double ratio = (double)(zoomEndTime - zoomStartTime) / (double)width();
  long clickedTime = zoomStartTime + long((event->x() * ratio) + 0.5);

  //if clicked on a subtitle, make that title the highlighted subtitle
  CSubtitle* sub = subtitles->getSubtitle(clickedTime);
  if(sub != 0)
  {
      highlightSub = sub;
      //select new one
	  selectSubtitle(highlightSub);
  }

}

void SubtitleNavigator::selectSubtitle(CSubtitle * sub)
{
    //redraw subs
    drawSubs(subtitles, false, sub);
    //let people know we selected a sub;
    emit subClicked(sub);

}

void SubtitleNavigator::paintEvent( QPaintEvent*)
{
  bitBlt( this, 0, 0, &buffer );
//  printf("paint\n");
}

void SubtitleNavigator::resizeEvent( QResizeEvent* event)
{
  buffer.resize( event->size() );
  buffer.fill( white );
  drawSubs(subtitles, false, highlightSub);
//  printf("resize to width %d", width() );
}

void SubtitleNavigator::slotZoomIn(CSubtitle * zoomSubtitle)
{

  long totalmsecs = zoomEndTime - zoomStartTime;
  if(totalmsecs > minVisibleMSecs)
  {
    long middle = zoomStartTime + long((totalmsecs / 2) + 0.5);
//    printf("\nmiddle:%ld",middle);
    long newStartTime = zoomStartTime + long(((middle - zoomStartTime) / 2) + 0.5);
//    printf("old:%ld",oldStartTime);
//    printf("new:%ld",newStartTime);
    long newEndTime = middle + long(((zoomEndTime - middle) / 2) + 0.5);
    if(newEndTime - newStartTime < minVisibleMSecs)
    {
      newEndTime = newStartTime + minVisibleMSecs;
    }
    if(zoomSubtitle != 0)
    {
      //try to set the subtitle in the middle
      long subStartTime = zoomSubtitle->getStartTime();
      long subEndTime = zoomSubtitle->getEndTime();
      long subMiddle = subStartTime + long(((subEndTime - subStartTime) / 2.0) + 0.5);
      if(subMiddle != middle)
      {
        long difference = subMiddle - middle;
        newStartTime += difference;
        newEndTime += difference;
        if(newStartTime < 0)
        {
          newEndTime += abs(newStartTime);
          newStartTime = 0;
        }
        if(newEndTime > subtitles->getTotalOccupiedTime())
        {
          newStartTime -= newEndTime - subtitles->getTotalOccupiedTime();
          newEndTime = subtitles->getTotalOccupiedTime();
        }
      }
    }
    zoomStartTime = newStartTime;
    zoomEndTime = newEndTime;
//    printf("zoomStartTime: %s", zoomStartTime->toString(QString("hh:mm:ss,zzz")).latin1());
//    printf("zoomEndTime: %s\n", zoomEndTime->toString(QString("hh:mm:ss,zzz")).latin1());

    if(selectedSubtitleCentered)
    {
        slotShowSub(highlightSub);
    }
    else
    {
        drawSubs(subtitles, false, highlightSub);
    }

  }
  else
  {
    emit maxZoomedIn(true);
  }
}

void SubtitleNavigator::slotZoomOut(void)
{

  long totalmsecs = zoomEndTime - zoomStartTime;
  if(zoomEndTime != subtitles->getTotalOccupiedTime() || zoomStartTime != 0)
  {
    long middle = zoomStartTime + long((totalmsecs / 2) + 0.5);
    long newStartTime = zoomStartTime - (middle - zoomStartTime);
    long newEndTime = zoomEndTime + (zoomEndTime - middle);
    if(newStartTime < 0)
    {
      zoomStartTime = 0;
    }
    else
    {
      zoomStartTime = newStartTime;
    }
    if(newEndTime > subtitles->getTotalOccupiedTime())
    {
      zoomEndTime = subtitles->getTotalOccupiedTime();
    }
    else
    {
      zoomEndTime = newEndTime;
    }
      if(selectedSubtitleCentered)
      {
          slotShowSub(highlightSub);
      }
      else
      {
          drawSubs(subtitles, false, highlightSub);
      }

  }
  else
  {
    emit maxZoomedOut(true);
  }
}

void SubtitleNavigator::slotGoLeft(int nrOfMSecs)
{
	long newTimeMSecs = zoomStartTime;

	newTimeMSecs -= nrOfMSecs;

	if(newTimeMSecs < 0)
	{
		zoomEndTime = zoomEndTime - zoomStartTime;
		newTimeMSecs = 0;
    }
    else
    {
        zoomEndTime = zoomEndTime - nrOfMSecs;
    }

    zoomStartTime = newTimeMSecs;

    drawSubs(subtitles, false, highlightSub);
}

void SubtitleNavigator::slotGoRight(int nrOfMSecs)
{
    long newTimeMSecs = zoomEndTime;

    newTimeMSecs += nrOfMSecs;

    if(newTimeMSecs > subtitles->getTotalOccupiedTime())
    {
        zoomStartTime = zoomStartTime + (subtitles->getTotalOccupiedTime() - zoomEndTime);
// 		printf("start:%d\n",zoomStartTime);
	    newTimeMSecs = subtitles->getTotalOccupiedTime();
    }
    else
    {
        zoomStartTime = zoomStartTime + nrOfMSecs;
    }
    zoomEndTime = newTimeMSecs;

    drawSubs(subtitles, false, highlightSub);
}

//centers the view on the subtitle 'sub'

void SubtitleNavigator::slotShowSub(CSubtitle * sub)
{
  if(sub != 0)
  {
    //determine the position in msecs the middle is in
    long endTime = zoomEndTime;
    long startTime = zoomStartTime;
    long totalmsecs = endTime - startTime;
    long middle = startTime + long((totalmsecs / 2) + 0.5);

    //try to set the subtitle in the middle
    long subStartTime = sub->getStartTime();
    long subEndTime = sub->getEndTime();
    long subMiddle = subStartTime + long(((subEndTime - subStartTime) / 2.0) + 0.5);
    if(subMiddle != middle)
    {
      long difference = subMiddle - middle;
      startTime += difference;
      endTime += difference;
      if(startTime < 0)
      {
        endTime += abs(startTime);
        startTime = 0;
      }
      if(endTime > subtitles->getTotalOccupiedTime())
      {
        startTime -= endTime - subtitles->getTotalOccupiedTime();
        endTime = subtitles->getTotalOccupiedTime();
      }
    }
    zoomStartTime = startTime;
    zoomEndTime = endTime;
    drawSubs(subtitles, false, highlightSub);
  }
}
