/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include "preferencesdialogbase.h"
#include <kdialogbase.h>
#include "profilewidget.h"

#include <qptrlist.h>
#include <qtextedit.h>
#include <qcolor.h>

#include "vpnaccountdata.h"

// content
#include "configdebugoptions.h"
#include "configgeneraloptions.h"
#include "configconnectoptions.h"
#include "configlogoptions.h"
#include "configdaemonoptions.h"
#include "confighelperprogramoptions.h"
#include "profilecertpskoptions.h"
#include "profileciscooptions.h"
#include "profilecmdexecafterconnectoptions.h"
#include "profilecmdexecafterdisconnectoptions.h"
#include "profilecmdexecbeforeconnectoptions.h"
#include "profilecmdexecbeforedisconnectoptions.h"
#include "profilegeneraloptions.h"
#include "profilenetworknatoptions.h"
#include "profilenetworkrouteoptions.h"
#include "profilenetworkvirtualipoptions.h"
#include "profileopenvpnoptions.h"
#include "profilepptpoptions.h"
#include "profileracoonoptions.h"
#include "profileuseroptions.h"


/**
@author Christoph Thielecke
*/
class PreferencesDialog : public KDialogBase
{
	Q_OBJECT
public:

	/**
	 *  Constructor
	 * @param parent parent widget
	 * @param app pointer to main application
	 * @param LogOutput textedit for debug messages
	 * @param GlobalConfig pointer to configuration object
	 * @param showOnlyProfiles view mode. true: show as profile manager, false: show as preferences dialog
	 * @return
	 */
	PreferencesDialog( QWidget *parent, QApplication *app,QTextEdit *LogOutput, KVpncConfig *GlobalConfig, bool showOnlyProfiles);

public slots:
	void accept();
	void slotApply();
	void authTypeChanged( int authtype );
	void connectionTypeChanged( int connectiontype );
	void profileChanged( const QString& itemtext );
	void saveSessionClicked();
	void deleteSessionClicked();
	void renameSessionClicked();
	void newSessionClicked();
	void importCertificate();
	void pageChanged(QWidget *);
	void userAuthToggled(bool);
	void useUdpToggled(bool);

protected:
	void setupGui();
	QPtrList<VpnAccountData> *AccountList;
	QTextEdit *LogOutput;
	VpnAccountData *currentProfile;
	KVpncConfig *GlobalConfig;
	QString lastProfileName;
	int KvpncDebugLevel;
	bool canAccept;

public:
	ProfileWidget *MyprofileWidget;
	QApplication *app;

	/* -- option pages -- */
	// Kvpnc
	ConfigGeneralOptions *GeneralOptionsWidget;
	ConfigDebugOptions *DebugOptionsWidget;
	ConfigConnectOptions *ConnectOptionsWidget;
	ConfigLogOptions *LogOptionsWidget;

	// programs
	ConfigDaemonOptions *DaemonOptionsWidget;
	ConfigHelperProgramOptions *HelperProgramOptionsWidget;

	// profile
	ProfileGeneralOptions *ProfileGeneralOptionsWidget;
	ProfileNetworkRouteOptions *ProfileNetworkRouteOptionsWidget;
	ProfileNetworkNatOptions *ProfileNetworkNatOptionsWidget;
	ProfileNetworkVirtualIpOptions *ProfileNetworkVirtualIpOptionsWidget;
	ProfileCertPskOptions *ProfileCertPskOptionsWidget;
	ProfileUserOptions *ProfileUserOptionsWidget;
	ProfileOpenvpnOptions *ProfileOpenvpnOptionsWidget;
	ProfilePptpOptions *ProfilePptpOptionsWidget;
	ProfileRacoonOptions *ProfileRacoonOptionsWidget;
	ProfileCiscoOptions *ProfileCiscoOptionsWidget;
	ProfileCmdExecBeforeConnectOptions *ProfileCmdExecBeforeConnectOptionsWidget;
	ProfileCmdExecBeforeDisconnectOptions *ProfileCmdExecBeforeDisconnectOptionsWidget;
	ProfileCmdExecAfterConnectOptions *ProfileCmdExecAfterConnectOptionsWidget;
	ProfileCmdExecAfterDisconnectOptions *ProfileCmdExecAfterDisconnectOptionsWidget;

	bool profileAddedOrDeleted;
	bool showOnlyProfiles;
	QString NewProfileName;

};

#endif
