#ifndef UTIL_H
#define UTIL_H

#include <sys/cdefs.h>
#include <time.h>

__BEGIN_DECLS

int set_signal_handler(int sig, void (*handler)(int));

void error(const char* format, ...);
void die_if(int cond, const char* format, ...);

char* itoa(int x);

void localtime_str(char* str, size_t str_len, const time_t* t);
void localtime_str_now(char* str, size_t str_len);

void drain_fd(int fd);

// static assert, for compile-time assertion checking
#define static_assert(x) switch (x) case 0: case (x):

__END_DECLS


#ifdef __cplusplus

#include <string>

// Return the string for "path1/path2"
std::string mkfilename(const std::string& path1, const std::string& path2);

#endif

#endif // UTIL_H
