/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 56 "ext/pdo_sqlite/sqlite/src/parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token eOperator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "ext/pdo_sqlite/sqlite/src/parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 248
#define YYACTIONTYPE unsigned short int
#define YYWILDCARD 60
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  int yy46;
  struct LikeOp yy72;
  Expr* yy172;
  ExprList* yy174;
  Select* yy219;
  struct LimitVal yy234;
  TriggerStep* yy243;
  struct TrigEvent yy370;
  SrcList* yy373;
  Expr * yy386;
  struct {int value; int mask;} yy405;
  Token yy410;
  IdList* yy432;
  int yy495;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 581
#define YYNRULE 309
#define YYERRORSYMBOL 139
#define YYERRSYMDT yy495
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   287,   67,  291,   69,  150,  168,  206,  431,   61,   61,
 /*    10 */    61,   61,   66,   63,   63,   63,   63,   64,   64,   65,
 /*    20 */    65,   65,   66,  441,  322,  164,  444,  450,   68,   63,
 /*    30 */    63,   63,   63,   64,   64,   65,   65,   65,   66,   64,
 /*    40 */    64,   65,   65,   65,   66,   60,   58,  295,  454,  455,
 /*    50 */   451,  451,   62,   62,   61,   61,   61,   61,  513,   63,
 /*    60 */    63,   63,   63,   64,   64,   65,   65,   65,   66,  287,
 /*    70 */   318,   67,  431,   69,  150,   79,  160,  114,  224,  314,
 /*    80 */   229,  315,  172,  249,  891,  120,  580,  515,  518,    2,
 /*    90 */   250,  566,  422,   35,  223,  444,  450,  528,   20,   57,
 /*   100 */   384,  381,   63,   63,   63,   63,   64,   64,   65,   65,
 /*   110 */    65,   66,  287,  473,   60,   58,  295,  454,  455,  451,
 /*   120 */   451,   62,   62,   61,   61,   61,   61,  389,   63,   63,
 /*   130 */    63,   63,   64,   64,   65,   65,   65,   66,  444,  450,
 /*   140 */    91,  311,  385,  480,  236,  383,  269,  204,    2,   83,
 /*   150 */   581,  384,  381,  470,  196,  439,  209,   60,   58,  295,
 /*   160 */   454,  455,  451,  451,   62,   62,   61,   61,   61,   61,
 /*   170 */   170,   63,   63,   63,   63,   64,   64,   65,   65,   65,
 /*   180 */    66,  287,  486,  439,  209,  132,  109,  270,  423,  443,
 /*   190 */   402,  281,  390,  391,  441,  517,  164,  318,  507,   67,
 /*   200 */   526,   69,  150,  562,  423,  143,  516,  444,  450,  145,
 /*   210 */   146,  578,  882,  373,  882,  511,  171,  156,  514,  422,
 /*   220 */    40,  337,  426,   19,  287,  140,   60,   58,  295,  454,
 /*   230 */   455,  451,  451,   62,   62,   61,   61,   61,   61,  380,
 /*   240 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   250 */   444,  450,  575,  404,  405,  428,  428,  428,  329,  332,
 /*   260 */   240,  545,   67,  468,   69,  150,  271,  287,  291,   60,
 /*   270 */    58,  295,  454,  455,  451,  451,   62,   62,   61,   61,
 /*   280 */    61,   61,  124,   63,   63,   63,   63,   64,   64,   65,
 /*   290 */    65,   65,   66,  444,  450,  401,  510,  389,  290,  544,
 /*   300 */    65,   65,   65,   66,  507,  389,  542,  405,  443,  294,
 /*   310 */   434,  435,   60,   58,  295,  454,  455,  451,  451,   62,
 /*   320 */    62,   61,   61,   61,   61,  206,   63,   63,   63,   63,
 /*   330 */    64,   64,   65,   65,   65,   66,  519,  514,  366,  287,
 /*   340 */    75,  426,  148,  490,  224,  314,  229,  315,  172,  249,
 /*   350 */   367,  265,  264,    1,  574,  286,  250,  389,  416,  445,
 /*   360 */   446,  206,  390,  391,  177,  444,  450,  340,  343,  344,
 /*   370 */   390,  391,  208,  357,  428,  428,  428,  360,  168,  345,
 /*   380 */   431,  448,  449,   78,   60,   58,  295,  454,  455,  451,
 /*   390 */   451,   62,   62,   61,   61,   61,   61,  476,   63,   63,
 /*   400 */    63,   63,   64,   64,   65,   65,   65,   66,  287,  447,
 /*   410 */   177,  561,  493,  340,  343,  344,   21,  318,  518,  318,
 /*   420 */   431,  318,  390,  391,  318,  345,  475,  400,   20,  563,
 /*   430 */   564,  489,  151,  177,  444,  450,  340,  343,  344,  422,
 /*   440 */    34,  422,   34,  422,   34,  431,  422,   34,  345,  192,
 /*   450 */   237,  147,  527,   60,   58,  295,  454,  455,  451,  451,
 /*   460 */    62,   62,   61,   61,   61,   61,  423,   63,   63,   63,
 /*   470 */    63,   64,   64,   65,   65,   65,   66,  287,  230,  348,
 /*   480 */   408,  512,  298,  423,  334,  431,  318,  206,  318,  296,
 /*   490 */   318,  208,  409,  154,  465,    9,  465,  458,  464,  389,
 /*   500 */   374,  465,  173,  444,  450,  410,  173,  406,  422,   40,
 /*   510 */   422,   48,  422,   48,  321,  434,  435,  407,  324,  475,
 /*   520 */   457,  457,   60,   58,  295,  454,  455,  451,  451,   62,
 /*   530 */    62,   61,   61,   61,   61,  459,   63,   63,   63,   63,
 /*   540 */    64,   64,   65,   65,   65,   66,  287,  318,  499,  238,
 /*   550 */   253,  480,  389,  338,  408,  149,  421,  306,  289,  307,
 /*   560 */   420,  389,  289,  389,  390,  391,  409,  250,  500,  422,
 /*   570 */    27,  155,  444,  450,  431,  422,    3,  208,  539,  410,
 /*   580 */   335,  328,  578,  881,  324,  881,  457,  457,  484,  423,
 /*   590 */   242,   60,   58,  295,  454,  455,  451,  451,   62,   62,
 /*   600 */    61,   61,   61,   61,  255,   63,   63,   63,   63,   64,
 /*   610 */    64,   65,   65,   65,   66,  287,  368,  390,  391,  488,
 /*   620 */    90,  299,  324,  575,  457,  457,  390,  391,  390,  391,
 /*   630 */   318,  525,  494,  318,  392,  393,  394,  518,  524,  431,
 /*   640 */   241,  444,  450,  183,  477,  181,  571,   20,  324,  297,
 /*   650 */   457,  457,  422,   28,  541,  422,   23,  505,  287,  339,
 /*   660 */    60,   58,  295,  454,  455,  451,  451,   62,   62,   61,
 /*   670 */    61,   61,   61,  318,   63,   63,   63,   63,   64,   64,
 /*   680 */    65,   65,   65,   66,  444,  450,  421,  535,  354,  535,
 /*   690 */   420,  259,  300,  505,  816,  422,   32,   74,  505,   76,
 /*   700 */   188,  287,  505,   60,   58,  295,  454,  455,  451,  451,
 /*   710 */    62,   62,   61,   61,   61,   61,  318,   63,   63,   63,
 /*   720 */    63,   64,   64,   65,   65,   65,   66,  444,  450,  174,
 /*   730 */   175,  176,  377,  216,  423,  480,  248,  301,  422,   53,
 /*   740 */   505,  505,  259,  259,  287,  259,   60,   70,  295,  454,
 /*   750 */   455,  451,  451,   62,   62,   61,   61,   61,   61,  365,
 /*   760 */    63,   63,   63,   63,   64,   64,   65,   65,   65,   66,
 /*   770 */   444,  450,  247,  319,  244,  302,  304,  248,  167,  156,
 /*   780 */   361,  248,  379,  260,  552,  259,  554,  287,  259,  219,
 /*   790 */    58,  295,  454,  455,  451,  451,   62,   62,   61,   61,
 /*   800 */    61,   61,  318,   63,   63,   63,   63,   64,   64,   65,
 /*   810 */    65,   65,   66,  444,  450,  484,  432,  484,   22,  248,
 /*   820 */   248,  207,  388,  364,  422,   24,  555,  364,   54,  556,
 /*   830 */   309,  119,  437,  437,  295,  454,  455,  451,  451,   62,
 /*   840 */    62,   61,   61,   61,   61,  318,   63,   63,   63,   63,
 /*   850 */    64,   64,   65,   65,   65,   66,   71,  325,  318,    4,
 /*   860 */   318,  537,  318,  293,  259,  536,  259,  422,   51,  318,
 /*   870 */   161,  320,   71,  325,  318,    4,  355,  356,  305,  293,
 /*   880 */   422,   96,  422,   93,  422,   98,  225,  320,  327,  217,
 /*   890 */   115,  422,   99,  218,  190,  318,  422,  110,  226,  443,
 /*   900 */   318,  259,  318,  417,  327,  272,  427,  372,  318,    5,
 /*   910 */   418,  318,  413,  414,  330,  443,  318,  422,  111,   73,
 /*   920 */    72,  197,  422,   16,  422,   97,  152,   71,  316,  317,
 /*   930 */   422,   33,  426,  422,   94,   73,   72,  487,  422,   52,
 /*   940 */   318,  200,  274,   71,  316,  317,   71,  325,  426,    4,
 /*   950 */   318,  206,  318,  293,  318,  423,  463,  318,   12,  179,
 /*   960 */   423,  320,  422,  112,  615,  428,  428,  428,  429,  430,
 /*   970 */    11,  323,  422,  113,  422,   25,  422,   36,  327,  422,
 /*   980 */    37,  428,  428,  428,  429,  430,   11,  498,  497,  443,
 /*   990 */   158,   18,  318,  423,   81,  220,  221,  222,  101,  182,
 /*  1000 */   482,  318,  169,  318,  491,  318,   12,  318,  440,   73,
 /*  1010 */    72,  202,  466,  276,  422,   26,  474,   71,  316,  317,
 /*  1020 */   277,  318,  426,  422,   38,  422,   39,  422,   41,  422,
 /*  1030 */    42,  318,  199,  423,  544,  503,  252,  124,  124,  198,
 /*  1040 */   318,  479,  201,  422,   43,  318,  483,  452,  318,  246,
 /*  1050 */   347,  318,  124,  422,   29,  428,  428,  428,  429,  430,
 /*  1060 */    11,  495,  422,   30,  496,  576,  318,  422,   44,  501,
 /*  1070 */   422,   45,  318,  422,   46,  520,  318,  533,  534,  318,
 /*  1080 */   540,  318,  124,  502,  185,  371,  273,  264,  422,   47,
 /*  1090 */   254,  288,  256,  257,  422,   31,  206,  258,  422,   10,
 /*  1100 */   352,  422,   49,  422,   50,  577,  548,  549,  169,   88,
 /*  1110 */   559,  263,   88,  359,  362,  573,  363,  285,  266,  267,
 /*  1120 */   376,  268,  551,  560,  275,  375,  278,  279,  231,  570,
 /*  1130 */   227,  142,  398,  326,  469,  436,  438,  472,  494,  159,
 /*  1140 */   504,  547,  506,  558,  387,  395,  342,  396,  397,    8,
 /*  1150 */   312,  313,  292,  416,   81,  403,  333,  232,  411,   80,
 /*  1160 */   228,  331,  419,  415,   56,   77,  210,  412,  239,  166,
 /*  1170 */   467,  211,  470,  471,  121,   82,  102,  336,  349,  282,
 /*  1180 */   508,  424,  521,  522,  529,  523,  351,  180,  233,  509,
 /*  1190 */   234,  184,  235,  283,  531,  425,  353,   85,  186,  117,
 /*  1200 */   358,  128,  369,  370,  308,  567,  568,  243,  543,  481,
 /*  1210 */   245,  212,  485,  189,  386,  569,  572,  129,   95,  214,
 /*  1220 */   215,  399,  550,  116,  130,  205,   55,  616,  131,  617,
 /*  1230 */   162,  163,  433,  134,   59,  213,  442,  557,  137,  100,
 /*  1240 */   138,  139,  453,  456,  460,  153,  165,  461,  261,  462,
 /*  1250 */     6,  122,   13,   12,    7,  532,  478,  123,  157,  492,
 /*  1260 */   103,  341,   89,  251,  104,   84,  105,  346,  226,  178,
 /*  1270 */   350,  141,  530,  125,  303,  169,  262,  187,  106,  126,
 /*  1280 */   538,  284,  546,  127,  191,   14,  194,   92,   17,   86,
 /*  1290 */    87,  193,  195,  133,  108,  553,  135,  565,  136,   15,
 /*  1300 */   107,  203,  378,  280,  144,  382,  558,  118,  579,  558,
 /*  1310 */   558,  310,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    16,  218,   16,  220,  221,   21,  111,   23,   70,   71,
 /*    10 */    72,   73,   84,   75,   76,   77,   78,   79,   80,   81,
 /*    20 */    82,   83,   84,  162,  163,  164,   42,   43,   74,   75,
 /*    30 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   79,
 /*    40 */    80,   81,   82,   83,   84,   61,   62,   63,   64,   65,
 /*    50 */    66,   67,   68,   69,   70,   71,   72,   73,  170,   75,
 /*    60 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   16,
 /*    70 */   148,  218,   88,  220,  221,   22,   90,   91,   92,   93,
 /*    80 */    94,   95,   96,   97,  140,  141,  142,  170,  148,  145,
 /*    90 */   104,  238,  170,  171,  154,   42,   43,  157,  158,   46,
 /*   100 */     1,    2,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   110 */    83,   84,   16,   22,   61,   62,   63,   64,   65,   66,
 /*   120 */    67,   68,   69,   70,   71,   72,   73,   23,   75,   76,
 /*   130 */    77,   78,   79,   80,   81,   82,   83,   84,   42,   43,
 /*   140 */    44,  143,  144,  162,  222,  142,   14,  149,  145,   19,
 /*   150 */     0,    1,    2,   23,  156,   79,   80,   61,   62,   63,
 /*   160 */    64,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   170 */   156,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   180 */    84,   16,  201,   79,   80,   53,   21,   55,  190,   59,
 /*   190 */   169,  159,   88,   89,  162,  163,  164,  148,  177,  218,
 /*   200 */   182,  220,  221,   99,  190,  114,  161,   42,   43,   79,
 /*   210 */    80,   19,   20,  215,   22,  170,  202,  203,   88,  170,
 /*   220 */   171,  207,   92,   19,   16,   21,   61,   62,   63,   64,
 /*   230 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  241,
 /*   240 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   250 */    42,   43,   60,  186,  187,  125,  126,  127,  187,  210,
 /*   260 */   211,   11,  218,  219,  220,  221,  134,   16,   16,   61,
 /*   270 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   280 */    72,   73,   22,   75,   76,   77,   78,   79,   80,   81,
 /*   290 */    82,   83,   84,   42,   43,  168,  169,   23,  151,   49,
 /*   300 */    81,   82,   83,   84,  177,   23,  186,  187,   59,  165,
 /*   310 */   166,  167,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   320 */    69,   70,   71,   72,   73,  111,   75,   76,   77,   78,
 /*   330 */    79,   80,   81,   82,   83,   84,  182,   88,  124,   16,
 /*   340 */   132,   92,   22,   20,   92,   93,   94,   95,   96,   97,
 /*   350 */   100,  101,  102,   19,  244,  245,  104,   23,   98,   42,
 /*   360 */    43,  111,   88,   89,   90,   42,   43,   93,   94,   95,
 /*   370 */    88,   89,  228,  226,  125,  126,  127,  230,   21,  105,
 /*   380 */    23,   64,   65,  132,   61,   62,   63,   64,   65,   66,
 /*   390 */    67,   68,   69,   70,   71,   72,   73,  115,   75,   76,
 /*   400 */    77,   78,   79,   80,   81,   82,   83,   84,   16,   92,
 /*   410 */    90,  148,   20,   93,   94,   95,   19,  148,  148,  148,
 /*   420 */    23,  148,   88,   89,  148,  105,   22,  157,  158,  166,
 /*   430 */   167,   20,  156,   90,   42,   43,   93,   94,   95,  170,
 /*   440 */   171,  170,  171,  170,  171,   88,  170,  171,  105,  156,
 /*   450 */   148,  181,  182,   61,   62,   63,   64,   65,   66,   67,
 /*   460 */    68,   69,   70,   71,   72,   73,  190,   75,   76,   77,
 /*   470 */    78,   79,   80,   81,   82,   83,   84,   16,  191,   16,
 /*   480 */    12,   20,  213,  190,  213,   88,  148,  111,  148,  213,
 /*   490 */   148,  228,   24,   89,  225,   19,  225,   20,  225,   23,
 /*   500 */   124,  225,   43,   42,   43,   37,   43,   39,  170,  171,
 /*   510 */   170,  171,  170,  171,  165,  166,  167,   49,  107,  115,
 /*   520 */   109,  110,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   530 */    69,   70,   71,   72,   73,   20,   75,   76,   77,   78,
 /*   540 */    79,   80,   81,   82,   83,   84,   16,  148,   30,  211,
 /*   550 */    20,  162,   23,  148,   12,  156,  108,  217,   99,  217,
 /*   560 */   112,   23,   99,   23,   88,   89,   24,  104,   50,  170,
 /*   570 */   171,  148,   42,   43,   23,  170,  171,  228,   18,   37,
 /*   580 */   148,   39,   19,   20,  107,   22,  109,  110,  148,  190,
 /*   590 */   201,   61,   62,   63,   64,   65,   66,   67,   68,   69,
 /*   600 */    70,   71,   72,   73,   14,   75,   76,   77,   78,   79,
 /*   610 */    80,   81,   82,   83,   84,   16,   56,   88,   89,   81,
 /*   620 */    21,  103,  107,   60,  109,  110,   88,   89,   88,   89,
 /*   630 */   148,  177,  178,  148,    7,    8,    9,  148,  184,   88,
 /*   640 */   148,   42,   43,   53,  115,   55,  157,  158,  107,  209,
 /*   650 */   109,  110,  170,  171,   94,  170,  171,  148,   16,   81,
 /*   660 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   670 */    71,   72,   73,  148,   75,   76,   77,   78,   79,   80,
 /*   680 */    81,   82,   83,   84,   42,   43,  108,  100,  101,  102,
 /*   690 */   112,  148,  183,  148,  134,  170,  171,  131,  148,  133,
 /*   700 */   156,   16,  148,   61,   62,   63,   64,   65,   66,   67,
 /*   710 */    68,   69,   70,   71,   72,   73,  148,   75,   76,   77,
 /*   720 */    78,   79,   80,   81,   82,   83,   84,   42,   43,  100,
 /*   730 */   101,  102,  189,  183,  190,  162,  227,  183,  170,  171,
 /*   740 */   148,  148,  148,  148,   16,  148,   61,   62,   63,   64,
 /*   750 */    65,   66,   67,   68,   69,   70,   71,   72,   73,  215,
 /*   760 */    75,   76,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   770 */    42,   43,  227,  148,  201,  183,  183,  227,  202,  203,
 /*   780 */   236,  227,  239,  189,  189,  148,  189,   16,  148,  146,
 /*   790 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   800 */    72,   73,  148,   75,   76,   77,   78,   79,   80,   81,
 /*   810 */    82,   83,   84,   42,   43,  148,   20,  148,   22,  227,
 /*   820 */   227,  193,  148,  148,  170,  171,  189,  148,  200,  189,
 /*   830 */   242,  243,  125,  126,   63,   64,   65,   66,   67,   68,
 /*   840 */    69,   70,   71,   72,   73,  148,   75,   76,   77,   78,
 /*   850 */    79,   80,   81,   82,   83,   84,   16,   17,  148,   19,
 /*   860 */   148,   25,  148,   23,  148,   29,  148,  170,  171,  148,
 /*   870 */    19,   31,   16,   17,  148,   19,  209,   41,  209,   23,
 /*   880 */   170,  171,  170,  171,  170,  171,   92,   31,   48,  214,
 /*   890 */   148,  170,  171,  214,   22,  148,  170,  171,  104,   59,
 /*   900 */   148,  148,  148,   27,   48,  189,  148,  189,  148,  192,
 /*   910 */    34,  148,    7,    8,  148,   59,  148,  170,  171,   79,
 /*   920 */    80,  156,  170,  171,  170,  171,  156,   87,   88,   89,
 /*   930 */   170,  171,   92,  170,  171,   79,   80,   81,  170,  171,
 /*   940 */   148,   19,  189,   87,   88,   89,   16,   17,   92,   19,
 /*   950 */   148,  111,  148,   23,  148,  190,   20,  148,   22,  156,
 /*   960 */   190,   31,  170,  171,  113,  125,  126,  127,  128,  129,
 /*   970 */   130,   16,  170,  171,  170,  171,  170,  171,   48,  170,
 /*   980 */   171,  125,  126,  127,  128,  129,  130,   91,   92,   59,
 /*   990 */     5,   69,  148,  190,  122,   10,   11,   12,   13,  156,
 /*  1000 */    20,  148,   22,  148,   20,  148,   22,  148,  162,   79,
 /*  1010 */    80,   26,  148,   28,  170,  171,  204,   87,   88,   89,
 /*  1020 */    35,  148,   92,  170,  171,  170,  171,  170,  171,  170,
 /*  1030 */   171,  148,   47,  190,   49,   20,   20,   22,   22,   54,
 /*  1040 */   148,  148,   57,  170,  171,  148,  148,   92,  148,  148,
 /*  1050 */    20,  148,   22,  170,  171,  125,  126,  127,  128,  129,
 /*  1060 */   130,  148,  170,  171,  179,   20,  148,  170,  171,  179,
 /*  1070 */   170,  171,  148,  170,  171,  148,  148,   51,   52,  148,
 /*  1080 */    20,  148,   22,  179,  232,  100,  101,  102,  170,  171,
 /*  1090 */   148,  106,  148,  148,  170,  171,  111,  148,  170,  171,
 /*  1100 */   233,  170,  171,  170,  171,   60,   20,   20,   22,   22,
 /*  1110 */    20,  148,   22,  148,  148,   20,  148,   22,  148,  148,
 /*  1120 */   135,  148,  148,  148,  148,  148,  148,  148,  194,  148,
 /*  1130 */   173,  192,  150,  224,  173,  229,  229,  173,  178,    6,
 /*  1140 */   173,  195,  173,  195,  147,  147,  174,  147,  147,   22,
 /*  1150 */   155,   99,   40,   98,  122,  172,  119,  195,  172,  120,
 /*  1160 */   172,  117,  172,  174,  121,  131,  223,  180,   97,  113,
 /*  1170 */   153,  212,   23,  161,  153,   99,   19,  116,   15,  175,
 /*  1180 */   161,  190,  172,  172,  153,  172,  153,  152,  196,  180,
 /*  1190 */   197,  153,  198,  175,  153,  199,   38,  131,  152,   61,
 /*  1200 */   153,   19,  153,   15,  153,   33,  153,  205,  185,  206,
 /*  1210 */   205,  212,  206,  185,    1,  153,  138,  188,  160,  212,
 /*  1220 */   212,   20,  195,   32,  188,   44,   19,  113,  188,  113,
 /*  1230 */   113,  113,   20,  185,   19,  176,   20,  195,  216,  176,
 /*  1240 */   216,   19,   92,  108,   11,   19,   22,   20,  234,   20,
 /*  1250 */   118,   19,   22,   22,  118,  235,  115,   20,  113,   20,
 /*  1260 */    19,   44,  237,   20,   19,   19,   19,   44,  104,   96,
 /*  1270 */    16,   21,   17,   99,   36,   22,  134,   99,   19,   45,
 /*  1280 */    45,    5,    1,  103,  123,   19,   14,  237,  231,   69,
 /*  1290 */    69,  114,  116,  114,  240,   17,  103,   20,  123,   19,
 /*  1300 */    14,  136,   58,  137,   19,    3,  247,  243,    4,  247,
 /*  1310 */   247,  246,
};
#define YY_SHIFT_USE_DFLT (-106)
#define YY_SHIFT_MAX 382
static const short yy_shift_ofst[] = {
 /*     0 */    99,  840,  985,  -16,  840,  930,  930,  930,  274, -105,
 /*    10 */    96,  930,  930,  930,  930,  930,  -46,  250,  104,  540,
 /*    20 */   551,   76,   76,   53,  165,  208,  251,  323,  392,  461,
 /*    30 */   530,  599,  642,  685,  642,  642,  642,  642,  642,  642,
 /*    40 */   642,  642,  642,  642,  642,  642,  642,  642,  642,  642,
 /*    50 */   642,  728,  771,  771,  856,  930,  930,  930,  930,  930,
 /*    60 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    70 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    80 */   930,  930,  930,  930,  930,  930,  930,  930,  930,  930,
 /*    90 */   930,  930,  930,  -62,  -62,  -14,   27,   27,  -40,  219,
 /*   100 */   463,  560,  540,  540,  540,  540,  540,  540,  540,  551,
 /*   110 */   -72, -106, -106, -106,  130,  252,  468,  468,  192,  563,
 /*   120 */   150,  357,  540,  357,  540,  540,  540,  540,  540,  540,
 /*   130 */   540,  540,  540,  540,  540,  540,  540,  214,  376, -105,
 /*   140 */  -105, -105, -106, -106, -106,  249,  249,  320,  343,  411,
 /*   150 */   334,  477,  515,  542,  282,  529,  476,  538,  627,  540,
 /*   160 */   540,  578,  540,  540,  397,  540,  540,  404,  540,  540,
 /*   170 */   541,  404,  540,  540,  518,  518,  518,  540,  540,  541,
 /*   180 */   540,  540,  541,  540,  836,  587,  540,  540,  541,  540,
 /*   190 */   540,  540,  541,  540,  540,  540,  541,  541,  540,  540,
 /*   200 */   540,  540,  540,  540,  204,  876,  448,   91,  707,  707,
 /*   210 */   566,  876,  876,  459,  876,  876,  260,  872,  872, 1133,
 /*   220 */  1133, 1133, 1133, 1127, 1052, 1052, 1112, 1052, 1055, 1052,
 /*   230 */  -105, 1032, 1037, 1039, 1044, 1043, 1034, 1056, 1071, 1149,
 /*   240 */  1071, 1056, 1076, 1061, 1076, 1061, 1157, 1071, 1071, 1149,
 /*   250 */  1112, 1052, 1052, 1052, 1157, 1163, 1056, 1056, 1056, 1056,
 /*   260 */  1158, 1066, 1163, 1056, 1138, 1138, 1182, 1032, 1056, 1188,
 /*   270 */  1188, 1188, 1032, 1138, 1182, 1056, 1172, 1172, 1056, 1056,
 /*   280 */  1078, -106, -106, -106, -106, -106, -106,  317,  132,  629,
 /*   290 */   590,  794,  905,  851,  796,  955,  936,  980,  984,  896,
 /*   300 */  1015, 1016, 1030, 1026, 1060, 1086, 1087, 1090,  922, 1095,
 /*   310 */  1045, 1213, 1201, 1191, 1181, 1207, 1114, 1116, 1117, 1118,
 /*   320 */  1215, 1212, 1216, 1150, 1135, 1222, 1233, 1226, 1227, 1224,
 /*   330 */  1229, 1132, 1230, 1136, 1231, 1141, 1232, 1237, 1145, 1239,
 /*   340 */  1217, 1241, 1243, 1245, 1246, 1223, 1247, 1173, 1164, 1254,
 /*   350 */  1255, 1250, 1174, 1238, 1234, 1253, 1235, 1142, 1178, 1259,
 /*   360 */  1276, 1281, 1180, 1220, 1221, 1161, 1266, 1177, 1272, 1176,
 /*   370 */  1278, 1179, 1193, 1175, 1280, 1277, 1286, 1244, 1165, 1166,
 /*   380 */  1285, 1302, 1304,
};
#define YY_REDUCE_USE_DFLT (-218)
#define YY_REDUCE_MAX 286
static const short yy_reduce_ofst[] = {
 /*     0 */   -56,  276,   -2,  -19,  399,  269,   49,  271,  270,   14,
 /*    10 */  -147,  -78,  273,  338,  340,  342,   44,  544,  263,  -60,
 /*    20 */    32,  144,  349, -217, -217, -217, -217, -217, -217, -217,
 /*    30 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    40 */  -217, -217, -217, -217, -217, -217, -217, -217, -217, -217,
 /*    50 */  -217, -217, -217, -217,  405,  482,  485,  525,  568,  654,
 /*    60 */   697,  710,  712,  714,  721,  726,  747,  752,  754,  760,
 /*    70 */   763,  768,  792,  802,  804,  806,  809,  844,  853,  855,
 /*    80 */   857,  859,  873,  883,  892,  897,  900,  903,  918,  924,
 /*    90 */   928,  931,  933, -217, -217,  127, -217, -217, -217, -217,
 /*   100 */   454,  147,  509,  550,  554,  592,  593,  543,  489, -139,
 /*   110 */  -217, -217, -217, -217,   45,   21,   67,  120,  110,  110,
 /*   120 */     3,  389,  440,  573,  545,  594,  667,  675,  669,  595,
 /*   130 */   597,  637,  640,  716,  718,  679,  753,  293,  765,  770,
 /*   140 */   803,  843,  628,  576,  588, -112,  -83,   18,  154,  287,
 /*   150 */   302,  287,  287,   71,  423,  432,  492,  625,  643,  674,
 /*   160 */   742,  717,  625,  758,  846,  766,  864,  812,  893,  898,
 /*   170 */   287,  812,  901,  913,  885,  890,  904,  927,  942,  287,
 /*   180 */   944,  945,  287,  949,  852,  867,  963,  965,  287,  966,
 /*   190 */   968,  970,  287,  971,  973,  974,  287,  287,  975,  976,
 /*   200 */   977,  978,  979,  981,  982,  957,  939,  934,  906,  907,
 /*   210 */   909,  961,  964,  960,  967,  969,  972,  946,  948,  997,
 /*   220 */   998, 1000, 1001,  995,  983,  986,  987,  988,  989,  990,
 /*   230 */   991,  962,  992,  993,  994,  996,  943, 1017,  959, 1012,
 /*   240 */   999, 1021, 1002, 1003, 1005, 1006, 1004, 1007, 1008, 1019,
 /*   250 */  1009, 1010, 1011, 1013, 1018, 1035, 1031, 1033, 1038, 1041,
 /*   260 */  1014, 1020, 1046, 1047, 1023, 1028, 1022, 1027, 1049, 1029,
 /*   270 */  1036, 1040, 1042, 1048, 1024, 1051, 1025, 1050, 1053, 1062,
 /*   280 */  1054, 1058, 1059, 1063, 1057, 1064, 1065,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   587,  813,  890,  702,  890,  813,  890,  813,  890,  706,
 /*    10 */   864,  809,  813,  890,  890,  890,  784,  890,  835,  890,
 /*    20 */   618,  835,  835,  737,  890,  890,  890,  890,  890,  890,
 /*    30 */   890,  890,  738,  890,  812,  808,  804,  806,  805,  739,
 /*    40 */   726,  735,  742,  718,  849,  744,  745,  750,  751,  865,
 /*    50 */   868,  772,  790,  771,  890,  890,  890,  890,  890,  890,
 /*    60 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*    70 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*    80 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*    90 */   890,  890,  890,  774,  795,  611,  773,  783,  775,  776,
 /*   100 */   671,  606,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   110 */   777,  778,  791,  792,  890,  890,  890,  890,  890,  890,
 /*   120 */   587,  702,  890,  702,  890,  890,  890,  890,  890,  890,
 /*   130 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   140 */   890,  890,  696,  706,  883,  890,  890,  662,  890,  890,
 /*   150 */   890,  890,  890,  890,  890,  890,  890,  890,  594,  592,
 /*   160 */   890,  694,  890,  890,  620,  890,  890,  704,  890,  890,
 /*   170 */   709,  710,  890,  890,  890,  890,  890,  890,  890,  608,
 /*   180 */   890,  890,  683,  890,  841,  890,  890,  890,  856,  890,
 /*   190 */   890,  890,  854,  890,  890,  890,  685,  747,  823,  890,
 /*   200 */   890,  869,  871,  890,  890,  729,  694,  703,  890,  890,
 /*   210 */   807,  729,  729,  641,  729,  729,  644,  741,  741,  591,
 /*   220 */   591,  591,  591,  661,  673,  673,  658,  673,  644,  673,
 /*   230 */   890,  741,  732,  734,  722,  736,  890,  711,  730,  890,
 /*   240 */   730,  711,  719,  721,  719,  721,  817,  730,  730,  890,
 /*   250 */   658,  673,  673,  673,  817,  603,  711,  711,  711,  711,
 /*   260 */   845,  848,  603,  711,  675,  675,  752,  741,  711,  682,
 /*   270 */   682,  682,  741,  675,  752,  711,  867,  867,  711,  711,
 /*   280 */   876,  628,  646,  646,  851,  883,  888,  890,  890,  890,
 /*   290 */   890,  890,  890,  759,  890,  890,  890,  890,  890,  890,
 /*   300 */   890,  890,  890,  890,  890,  890,  890,  890,  830,  890,
 /*   310 */   890,  890,  890,  890,  890,  890,  764,  760,  890,  761,
 /*   320 */   890,  890,  890,  890,  688,  890,  890,  890,  890,  890,
 /*   330 */   890,  890,  723,  890,  733,  890,  890,  890,  890,  890,
 /*   340 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   350 */   890,  890,  890,  890,  843,  844,  890,  890,  890,  890,
 /*   360 */   890,  890,  890,  890,  890,  890,  890,  890,  890,  890,
 /*   370 */   890,  890,  890,  890,  890,  890,  890,  875,  890,  890,
 /*   380 */   878,  588,  890,  582,  585,  584,  586,  590,  593,  615,
 /*   390 */   616,  617,  595,  596,  597,  598,  599,  600,  601,  607,
 /*   400 */   609,  627,  629,  636,  674,  677,  678,  679,  859,  860,
 /*   410 */   861,  637,  656,  659,  660,  638,  645,  727,  728,  639,
 /*   420 */   692,  693,  756,  686,  687,  691,  758,  762,  763,  765,
 /*   430 */   766,  614,  621,  622,  625,  626,  831,  833,  832,  834,
 /*   440 */   624,  623,  767,  770,  779,  780,  782,  788,  794,  797,
 /*   450 */   781,  786,  787,  789,  793,  796,  689,  690,  800,  802,
 /*   460 */   803,  857,  858,  798,  810,  811,  712,  801,  785,  724,
 /*   470 */   613,  731,  725,  695,  705,  714,  715,  716,  717,  700,
 /*   480 */   701,  707,  720,  754,  755,  708,  697,  698,  699,  799,
 /*   490 */   757,  768,  769,  640,  647,  648,  649,  652,  653,  654,
 /*   500 */   655,  650,  651,  818,  819,  821,  820,  642,  643,  657,
 /*   510 */   630,  631,  632,  633,  764,  634,  635,  619,  612,  663,
 /*   520 */   666,  667,  668,  669,  670,  672,  664,  665,  610,  602,
 /*   530 */   604,  713,  837,  846,  847,  842,  838,  839,  840,  605,
 /*   540 */   814,  815,  676,  748,  749,  836,  850,  852,  753,  853,
 /*   550 */   855,  880,  680,  681,  684,  822,  862,  740,  743,  746,
 /*   560 */   824,  825,  826,  827,  828,  829,  863,  866,  870,  872,
 /*   570 */   873,  874,  877,  879,  884,  885,  886,  889,  887,  589,
 /*   580 */   583,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*       SEMI => nothing */
   23,  /*    EXPLAIN => ID */
   23,  /*      QUERY => ID */
   23,  /*       PLAN => ID */
   23,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   23,  /*   DEFERRED => ID */
   23,  /*  IMMEDIATE => ID */
   23,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   23,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   23,  /*         IF => ID */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
   23,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   23,  /*      ABORT => ID */
   23,  /*      AFTER => ID */
   23,  /*    ANALYZE => ID */
   23,  /*        ASC => ID */
   23,  /*     ATTACH => ID */
   23,  /*     BEFORE => ID */
   23,  /*    CASCADE => ID */
   23,  /*       CAST => ID */
   23,  /*   CONFLICT => ID */
   23,  /*   DATABASE => ID */
   23,  /*       DESC => ID */
   23,  /*     DETACH => ID */
   23,  /*       EACH => ID */
   23,  /*       FAIL => ID */
   23,  /*        FOR => ID */
   23,  /*     IGNORE => ID */
   23,  /*  INITIALLY => ID */
   23,  /*    INSTEAD => ID */
   23,  /*    LIKE_KW => ID */
   23,  /*      MATCH => ID */
   23,  /*        KEY => ID */
   23,  /*         OF => ID */
   23,  /*     OFFSET => ID */
   23,  /*     PRAGMA => ID */
   23,  /*      RAISE => ID */
   23,  /*    REPLACE => ID */
   23,  /*   RESTRICT => ID */
   23,  /*        ROW => ID */
   23,  /*  STATEMENT => ID */
   23,  /*    TRIGGER => ID */
   23,  /*     VACUUM => ID */
   23,  /*       VIEW => ID */
   23,  /*    VIRTUAL => ID */
   23,  /*    REINDEX => ID */
   23,  /*     RENAME => ID */
   23,  /*   CTIME_KW => ID */
    0,  /*        ANY => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*      ALTER => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "SEMI",          "EXPLAIN",       "QUERY",       
  "PLAN",          "BEGIN",         "TRANSACTION",   "DEFERRED",    
  "IMMEDIATE",     "EXCLUSIVE",     "COMMIT",        "END",         
  "ROLLBACK",      "CREATE",        "TABLE",         "IF",          
  "NOT",           "EXISTS",        "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ANALYZE",       "ASC",         
  "ATTACH",        "BEFORE",        "CASCADE",       "CAST",        
  "CONFLICT",      "DATABASE",      "DESC",          "DETACH",      
  "EACH",          "FAIL",          "FOR",           "IGNORE",      
  "INITIALLY",     "INSTEAD",       "LIKE_KW",       "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TRIGGER",       "VACUUM",        "VIEW",        
  "VIRTUAL",       "REINDEX",       "RENAME",        "CTIME_KW",    
  "ANY",           "OR",            "AND",           "IS",          
  "BETWEEN",       "IN",            "ISNULL",        "NOTNULL",     
  "NE",            "EQ",            "GT",            "LE",          
  "LT",            "GE",            "ESCAPE",        "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "STRING",        "JOIN_KW",       "CONSTRAINT",    "DEFAULT",     
  "NULL",          "PRIMARY",       "UNIQUE",        "CHECK",       
  "REFERENCES",    "COLLATE",       "AUTOINCR",      "ON",          
  "DELETE",        "UPDATE",        "INSERT",        "SET",         
  "DEFERRABLE",    "FOREIGN",       "DROP",          "UNION",       
  "ALL",           "EXCEPT",        "INTERSECT",     "SELECT",      
  "DISTINCT",      "DOT",           "FROM",          "JOIN",        
  "USING",         "ORDER",         "BY",            "GROUP",       
  "HAVING",        "LIMIT",         "WHERE",         "INTO",        
  "VALUES",        "INTEGER",       "FLOAT",         "BLOB",        
  "REGISTER",      "VARIABLE",      "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "ALTER",       
  "TO",            "ADD",           "COLUMNKW",      "error",       
  "input",         "cmdlist",       "ecmd",          "cmdx",        
  "cmd",           "explain",       "transtype",     "trans_opt",   
  "nm",            "create_table",  "create_table_args",  "temp",        
  "ifnotexists",   "dbnm",          "columnlist",    "conslist_opt",
  "select",        "column",        "columnid",      "type",        
  "carglist",      "id",            "ids",           "typetoken",   
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "expr",        
  "onconf",        "sortorder",     "autoinc",       "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "ifexists",      "fullname",      "oneselect",     "multiselect_op",
  "distinct",      "selcollist",    "from",          "where_opt",   
  "groupby_opt",   "having_opt",    "orderby_opt",   "limit_opt",   
  "sclp",          "as",            "seltablist",    "stl_prefix",  
  "joinop",        "on_opt",        "using_opt",     "seltablist_paren",
  "joinop2",       "inscollist",    "sortlist",      "sortitem",    
  "collate",       "exprlist",      "setlist",       "insert_cmd",  
  "inscollist_opt",  "itemlist",      "likeop",        "escape",      
  "between_op",    "in_op",         "case_operand",  "case_exprlist",
  "case_else",     "expritem",      "uniqueflag",    "idxitem",     
  "plus_opt",      "number",        "trigger_decl",  "trigger_cmd_list",
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd",   "database_kw_opt",  "key_opt",       "add_column_fullname",
  "kwcolumn_opt",  "create_vtab",   "vtabarglist",   "vtabarg",     
  "vtabargtoken",  "lp",            "anylist",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE ifnotexists nm dbnm",
 /*  22 */ "ifnotexists ::=",
 /*  23 */ "ifnotexists ::= IF NOT EXISTS",
 /*  24 */ "temp ::= TEMP",
 /*  25 */ "temp ::=",
 /*  26 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  27 */ "create_table_args ::= AS select",
 /*  28 */ "columnlist ::= columnlist COMMA column",
 /*  29 */ "columnlist ::= column",
 /*  30 */ "column ::= columnid type carglist",
 /*  31 */ "columnid ::= nm",
 /*  32 */ "id ::= ID",
 /*  33 */ "ids ::= ID|STRING",
 /*  34 */ "nm ::= ID",
 /*  35 */ "nm ::= STRING",
 /*  36 */ "nm ::= JOIN_KW",
 /*  37 */ "type ::=",
 /*  38 */ "type ::= typetoken",
 /*  39 */ "typetoken ::= typename",
 /*  40 */ "typetoken ::= typename LP signed RP",
 /*  41 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  42 */ "typename ::= ids",
 /*  43 */ "typename ::= typename ids",
 /*  44 */ "signed ::= plus_num",
 /*  45 */ "signed ::= minus_num",
 /*  46 */ "carglist ::= carglist carg",
 /*  47 */ "carglist ::=",
 /*  48 */ "carg ::= CONSTRAINT nm ccons",
 /*  49 */ "carg ::= ccons",
 /*  50 */ "carg ::= DEFAULT term",
 /*  51 */ "carg ::= DEFAULT LP expr RP",
 /*  52 */ "carg ::= DEFAULT PLUS term",
 /*  53 */ "carg ::= DEFAULT MINUS term",
 /*  54 */ "carg ::= DEFAULT id",
 /*  55 */ "ccons ::= NULL onconf",
 /*  56 */ "ccons ::= NOT NULL onconf",
 /*  57 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  58 */ "ccons ::= UNIQUE onconf",
 /*  59 */ "ccons ::= CHECK LP expr RP",
 /*  60 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  61 */ "ccons ::= defer_subclause",
 /*  62 */ "ccons ::= COLLATE id",
 /*  63 */ "autoinc ::=",
 /*  64 */ "autoinc ::= AUTOINCR",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON DELETE refact",
 /*  69 */ "refarg ::= ON UPDATE refact",
 /*  70 */ "refarg ::= ON INSERT refact",
 /*  71 */ "refact ::= SET NULL",
 /*  72 */ "refact ::= SET DEFAULT",
 /*  73 */ "refact ::= CASCADE",
 /*  74 */ "refact ::= RESTRICT",
 /*  75 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "init_deferred_pred_opt ::=",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  80 */ "conslist_opt ::=",
 /*  81 */ "conslist_opt ::= COMMA conslist",
 /*  82 */ "conslist ::= conslist COMMA tcons",
 /*  83 */ "conslist ::= conslist tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tcons ::= CONSTRAINT nm",
 /*  86 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  87 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  88 */ "tcons ::= CHECK LP expr RP onconf",
 /*  89 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  90 */ "defer_subclause_opt ::=",
 /*  91 */ "defer_subclause_opt ::= defer_subclause",
 /*  92 */ "onconf ::=",
 /*  93 */ "onconf ::= ON CONFLICT resolvetype",
 /*  94 */ "orconf ::=",
 /*  95 */ "orconf ::= OR resolvetype",
 /*  96 */ "resolvetype ::= raisetype",
 /*  97 */ "resolvetype ::= IGNORE",
 /*  98 */ "resolvetype ::= REPLACE",
 /*  99 */ "cmd ::= DROP TABLE ifexists fullname",
 /* 100 */ "ifexists ::= IF EXISTS",
 /* 101 */ "ifexists ::=",
 /* 102 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 103 */ "cmd ::= DROP VIEW ifexists fullname",
 /* 104 */ "cmd ::= select",
 /* 105 */ "select ::= oneselect",
 /* 106 */ "select ::= select multiselect_op oneselect",
 /* 107 */ "multiselect_op ::= UNION",
 /* 108 */ "multiselect_op ::= UNION ALL",
 /* 109 */ "multiselect_op ::= EXCEPT|INTERSECT",
 /* 110 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 111 */ "distinct ::= DISTINCT",
 /* 112 */ "distinct ::= ALL",
 /* 113 */ "distinct ::=",
 /* 114 */ "sclp ::= selcollist COMMA",
 /* 115 */ "sclp ::=",
 /* 116 */ "selcollist ::= sclp expr as",
 /* 117 */ "selcollist ::= sclp STAR",
 /* 118 */ "selcollist ::= sclp nm DOT STAR",
 /* 119 */ "as ::= AS nm",
 /* 120 */ "as ::= ids",
 /* 121 */ "as ::=",
 /* 122 */ "from ::=",
 /* 123 */ "from ::= FROM seltablist",
 /* 124 */ "stl_prefix ::= seltablist joinop",
 /* 125 */ "stl_prefix ::=",
 /* 126 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 127 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 128 */ "seltablist_paren ::= select",
 /* 129 */ "seltablist_paren ::= seltablist",
 /* 130 */ "dbnm ::=",
 /* 131 */ "dbnm ::= DOT nm",
 /* 132 */ "fullname ::= nm dbnm",
 /* 133 */ "joinop ::= COMMA|JOIN",
 /* 134 */ "joinop ::= JOIN_KW JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm JOIN",
 /* 136 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 137 */ "on_opt ::= ON expr",
 /* 138 */ "on_opt ::=",
 /* 139 */ "using_opt ::= USING LP inscollist RP",
 /* 140 */ "using_opt ::=",
 /* 141 */ "orderby_opt ::=",
 /* 142 */ "orderby_opt ::= ORDER BY sortlist",
 /* 143 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 144 */ "sortlist ::= sortitem collate sortorder",
 /* 145 */ "sortitem ::= expr",
 /* 146 */ "sortorder ::= ASC",
 /* 147 */ "sortorder ::= DESC",
 /* 148 */ "sortorder ::=",
 /* 149 */ "collate ::=",
 /* 150 */ "collate ::= COLLATE id",
 /* 151 */ "groupby_opt ::=",
 /* 152 */ "groupby_opt ::= GROUP BY exprlist",
 /* 153 */ "having_opt ::=",
 /* 154 */ "having_opt ::= HAVING expr",
 /* 155 */ "limit_opt ::=",
 /* 156 */ "limit_opt ::= LIMIT expr",
 /* 157 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 158 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 159 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 160 */ "where_opt ::=",
 /* 161 */ "where_opt ::= WHERE expr",
 /* 162 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 163 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 164 */ "setlist ::= nm EQ expr",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 166 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 167 */ "insert_cmd ::= INSERT orconf",
 /* 168 */ "insert_cmd ::= REPLACE",
 /* 169 */ "itemlist ::= itemlist COMMA expr",
 /* 170 */ "itemlist ::= expr",
 /* 171 */ "inscollist_opt ::=",
 /* 172 */ "inscollist_opt ::= LP inscollist RP",
 /* 173 */ "inscollist ::= inscollist COMMA nm",
 /* 174 */ "inscollist ::= nm",
 /* 175 */ "expr ::= term",
 /* 176 */ "expr ::= LP expr RP",
 /* 177 */ "term ::= NULL",
 /* 178 */ "expr ::= ID",
 /* 179 */ "expr ::= JOIN_KW",
 /* 180 */ "expr ::= nm DOT nm",
 /* 181 */ "expr ::= nm DOT nm DOT nm",
 /* 182 */ "term ::= INTEGER|FLOAT|BLOB",
 /* 183 */ "term ::= STRING",
 /* 184 */ "expr ::= REGISTER",
 /* 185 */ "expr ::= VARIABLE",
 /* 186 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 187 */ "expr ::= ID LP distinct exprlist RP",
 /* 188 */ "expr ::= ID LP STAR RP",
 /* 189 */ "term ::= CTIME_KW",
 /* 190 */ "expr ::= expr AND expr",
 /* 191 */ "expr ::= expr OR expr",
 /* 192 */ "expr ::= expr LT|GT|GE|LE expr",
 /* 193 */ "expr ::= expr EQ|NE expr",
 /* 194 */ "expr ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 195 */ "expr ::= expr PLUS|MINUS expr",
 /* 196 */ "expr ::= expr STAR|SLASH|REM expr",
 /* 197 */ "expr ::= expr CONCAT expr",
 /* 198 */ "likeop ::= LIKE_KW",
 /* 199 */ "likeop ::= NOT LIKE_KW",
 /* 200 */ "likeop ::= MATCH",
 /* 201 */ "likeop ::= NOT MATCH",
 /* 202 */ "escape ::= ESCAPE expr",
 /* 203 */ "escape ::=",
 /* 204 */ "expr ::= expr likeop expr escape",
 /* 205 */ "expr ::= expr ISNULL|NOTNULL",
 /* 206 */ "expr ::= expr IS NULL",
 /* 207 */ "expr ::= expr NOT NULL",
 /* 208 */ "expr ::= expr IS NOT NULL",
 /* 209 */ "expr ::= NOT|BITNOT expr",
 /* 210 */ "expr ::= MINUS expr",
 /* 211 */ "expr ::= PLUS expr",
 /* 212 */ "between_op ::= BETWEEN",
 /* 213 */ "between_op ::= NOT BETWEEN",
 /* 214 */ "expr ::= expr between_op expr AND expr",
 /* 215 */ "in_op ::= IN",
 /* 216 */ "in_op ::= NOT IN",
 /* 217 */ "expr ::= expr in_op LP exprlist RP",
 /* 218 */ "expr ::= LP select RP",
 /* 219 */ "expr ::= expr in_op LP select RP",
 /* 220 */ "expr ::= expr in_op nm dbnm",
 /* 221 */ "expr ::= EXISTS LP select RP",
 /* 222 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 223 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 224 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 225 */ "case_else ::= ELSE expr",
 /* 226 */ "case_else ::=",
 /* 227 */ "case_operand ::= expr",
 /* 228 */ "case_operand ::=",
 /* 229 */ "exprlist ::= exprlist COMMA expritem",
 /* 230 */ "exprlist ::= expritem",
 /* 231 */ "expritem ::= expr",
 /* 232 */ "expritem ::=",
 /* 233 */ "cmd ::= CREATE uniqueflag INDEX ifnotexists nm dbnm ON nm LP idxlist RP",
 /* 234 */ "uniqueflag ::= UNIQUE",
 /* 235 */ "uniqueflag ::=",
 /* 236 */ "idxlist_opt ::=",
 /* 237 */ "idxlist_opt ::= LP idxlist RP",
 /* 238 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 239 */ "idxlist ::= idxitem collate sortorder",
 /* 240 */ "idxitem ::= nm",
 /* 241 */ "cmd ::= DROP INDEX ifexists fullname",
 /* 242 */ "cmd ::= VACUUM",
 /* 243 */ "cmd ::= VACUUM nm",
 /* 244 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 245 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 246 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 247 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 248 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 249 */ "cmd ::= PRAGMA nm dbnm",
 /* 250 */ "plus_num ::= plus_opt number",
 /* 251 */ "minus_num ::= MINUS number",
 /* 252 */ "number ::= INTEGER|FLOAT",
 /* 253 */ "plus_opt ::= PLUS",
 /* 254 */ "plus_opt ::=",
 /* 255 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 256 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 257 */ "trigger_time ::= BEFORE",
 /* 258 */ "trigger_time ::= AFTER",
 /* 259 */ "trigger_time ::= INSTEAD OF",
 /* 260 */ "trigger_time ::=",
 /* 261 */ "trigger_event ::= DELETE|INSERT",
 /* 262 */ "trigger_event ::= UPDATE",
 /* 263 */ "trigger_event ::= UPDATE OF inscollist",
 /* 264 */ "foreach_clause ::=",
 /* 265 */ "foreach_clause ::= FOR EACH ROW",
 /* 266 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 267 */ "when_clause ::=",
 /* 268 */ "when_clause ::= WHEN expr",
 /* 269 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 270 */ "trigger_cmd_list ::=",
 /* 271 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 272 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 273 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 274 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 275 */ "trigger_cmd ::= select",
 /* 276 */ "expr ::= RAISE LP IGNORE RP",
 /* 277 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 278 */ "raisetype ::= ROLLBACK",
 /* 279 */ "raisetype ::= ABORT",
 /* 280 */ "raisetype ::= FAIL",
 /* 281 */ "cmd ::= DROP TRIGGER fullname",
 /* 282 */ "cmd ::= ATTACH database_kw_opt expr AS expr key_opt",
 /* 283 */ "key_opt ::=",
 /* 284 */ "key_opt ::= KEY expr",
 /* 285 */ "database_kw_opt ::= DATABASE",
 /* 286 */ "database_kw_opt ::=",
 /* 287 */ "cmd ::= DETACH database_kw_opt expr",
 /* 288 */ "cmd ::= REINDEX",
 /* 289 */ "cmd ::= REINDEX nm dbnm",
 /* 290 */ "cmd ::= ANALYZE",
 /* 291 */ "cmd ::= ANALYZE nm dbnm",
 /* 292 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 293 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 294 */ "add_column_fullname ::= fullname",
 /* 295 */ "kwcolumn_opt ::=",
 /* 296 */ "kwcolumn_opt ::= COLUMNKW",
 /* 297 */ "cmd ::= create_vtab",
 /* 298 */ "cmd ::= create_vtab LP vtabarglist RP",
 /* 299 */ "create_vtab ::= CREATE VIRTUAL TABLE nm dbnm USING nm",
 /* 300 */ "vtabarglist ::= vtabarg",
 /* 301 */ "vtabarglist ::= vtabarglist COMMA vtabarg",
 /* 302 */ "vtabarg ::=",
 /* 303 */ "vtabarg ::= vtabarg vtabargtoken",
 /* 304 */ "vtabargtoken ::= ANY",
 /* 305 */ "vtabargtoken ::= lp anylist RP",
 /* 306 */ "lp ::= LP",
 /* 307 */ "anylist ::=",
 /* 308 */ "anylist ::= anylist ANY",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 156:
    case 190:
    case 207:
#line 374 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3SelectDelete((yypminor->yy219));}
#line 1248 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 170:
    case 171:
    case 195:
    case 197:
    case 205:
    case 211:
    case 219:
    case 222:
    case 224:
    case 225:
    case 235:
#line 631 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3ExprDelete((yypminor->yy172));}
#line 1263 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 175:
    case 183:
    case 193:
    case 196:
    case 198:
    case 200:
    case 210:
    case 213:
    case 214:
    case 217:
    case 223:
#line 865 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3ExprListDelete((yypminor->yy174));}
#line 1278 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 189:
    case 194:
    case 202:
    case 203:
#line 502 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3SrcListDelete((yypminor->yy373));}
#line 1286 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 199:
#line 563 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3ExprDelete((yypminor->yy234).pLimit);
  sqlite3ExprDelete((yypminor->yy234).pOffset);
}
#line 1294 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 206:
    case 209:
    case 216:
#line 519 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3IdListDelete((yypminor->yy432));}
#line 1301 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 231:
    case 236:
#line 959 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy243));}
#line 1307 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 233:
#line 943 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3IdListDelete((yypminor->yy370).b);}
#line 1312 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    case 238:
#line 1027 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3ExprDelete((yypminor->yy386));}
#line 1317 "ext/pdo_sqlite/sqlite/src/parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
#line 44 "ext/pdo_sqlite/sqlite/src/parse.y"

  sqlite3ErrorMsg(pParse, "parser stack overflow");
  pParse->parseError = 1;
#line 1486 "ext/pdo_sqlite/sqlite/src/parse.c"
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 140, 1 },
  { 141, 2 },
  { 141, 1 },
  { 143, 1 },
  { 142, 1 },
  { 142, 3 },
  { 145, 0 },
  { 145, 1 },
  { 145, 3 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 147, 2 },
  { 146, 0 },
  { 146, 1 },
  { 146, 1 },
  { 146, 1 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 144, 2 },
  { 149, 6 },
  { 152, 0 },
  { 152, 3 },
  { 151, 1 },
  { 151, 0 },
  { 150, 4 },
  { 150, 2 },
  { 154, 3 },
  { 154, 1 },
  { 157, 3 },
  { 158, 1 },
  { 161, 1 },
  { 162, 1 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 159, 0 },
  { 159, 1 },
  { 163, 1 },
  { 163, 4 },
  { 163, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 160, 2 },
  { 160, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 4 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 4 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 174, 0 },
  { 174, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 155, 0 },
  { 155, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 5 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 172, 0 },
  { 172, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 144, 4 },
  { 188, 2 },
  { 188, 0 },
  { 144, 7 },
  { 144, 4 },
  { 144, 1 },
  { 156, 1 },
  { 156, 3 },
  { 191, 1 },
  { 191, 2 },
  { 191, 1 },
  { 190, 9 },
  { 192, 1 },
  { 192, 1 },
  { 192, 0 },
  { 200, 2 },
  { 200, 0 },
  { 193, 3 },
  { 193, 2 },
  { 193, 4 },
  { 201, 2 },
  { 201, 1 },
  { 201, 0 },
  { 194, 0 },
  { 194, 2 },
  { 203, 2 },
  { 203, 0 },
  { 202, 6 },
  { 202, 7 },
  { 207, 1 },
  { 207, 1 },
  { 153, 0 },
  { 153, 2 },
  { 189, 2 },
  { 204, 1 },
  { 204, 2 },
  { 204, 3 },
  { 204, 4 },
  { 205, 2 },
  { 205, 0 },
  { 206, 4 },
  { 206, 0 },
  { 198, 0 },
  { 198, 3 },
  { 210, 5 },
  { 210, 3 },
  { 211, 1 },
  { 173, 1 },
  { 173, 1 },
  { 173, 0 },
  { 212, 0 },
  { 212, 2 },
  { 196, 0 },
  { 196, 3 },
  { 197, 0 },
  { 197, 2 },
  { 199, 0 },
  { 199, 2 },
  { 199, 4 },
  { 199, 4 },
  { 144, 4 },
  { 195, 0 },
  { 195, 2 },
  { 144, 6 },
  { 214, 5 },
  { 214, 3 },
  { 144, 8 },
  { 144, 5 },
  { 215, 2 },
  { 215, 1 },
  { 217, 3 },
  { 217, 1 },
  { 216, 0 },
  { 216, 3 },
  { 209, 3 },
  { 209, 1 },
  { 171, 1 },
  { 171, 3 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 3 },
  { 171, 5 },
  { 170, 1 },
  { 170, 1 },
  { 171, 1 },
  { 171, 1 },
  { 171, 6 },
  { 171, 5 },
  { 171, 4 },
  { 170, 1 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 171, 3 },
  { 218, 1 },
  { 218, 2 },
  { 218, 1 },
  { 218, 2 },
  { 219, 2 },
  { 219, 0 },
  { 171, 4 },
  { 171, 2 },
  { 171, 3 },
  { 171, 3 },
  { 171, 4 },
  { 171, 2 },
  { 171, 2 },
  { 171, 2 },
  { 220, 1 },
  { 220, 2 },
  { 171, 5 },
  { 221, 1 },
  { 221, 2 },
  { 171, 5 },
  { 171, 3 },
  { 171, 5 },
  { 171, 4 },
  { 171, 4 },
  { 171, 5 },
  { 223, 5 },
  { 223, 4 },
  { 224, 2 },
  { 224, 0 },
  { 222, 1 },
  { 222, 0 },
  { 213, 3 },
  { 213, 1 },
  { 225, 1 },
  { 225, 0 },
  { 144, 11 },
  { 226, 1 },
  { 226, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 227, 1 },
  { 144, 4 },
  { 144, 1 },
  { 144, 2 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 5 },
  { 144, 6 },
  { 144, 3 },
  { 166, 2 },
  { 167, 2 },
  { 229, 1 },
  { 228, 1 },
  { 228, 0 },
  { 144, 5 },
  { 230, 10 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 231, 3 },
  { 231, 0 },
  { 236, 6 },
  { 236, 8 },
  { 236, 5 },
  { 236, 4 },
  { 236, 1 },
  { 171, 4 },
  { 171, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 144, 3 },
  { 144, 6 },
  { 238, 0 },
  { 238, 2 },
  { 237, 1 },
  { 237, 0 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 1 },
  { 144, 3 },
  { 144, 6 },
  { 144, 6 },
  { 239, 1 },
  { 240, 0 },
  { 240, 1 },
  { 144, 1 },
  { 144, 4 },
  { 241, 7 },
  { 242, 1 },
  { 242, 3 },
  { 243, 0 },
  { 243, 2 },
  { 244, 1 },
  { 244, 3 },
  { 245, 1 },
  { 246, 0 },
  { 246, 2 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 100 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1873 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 6:
#line 103 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1878 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 7:
#line 105 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1883 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 8:
#line 106 "ext/pdo_sqlite/sqlite/src/parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1888 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 9:
#line 112 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy46);}
#line 1893 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 13:
#line 117 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = TK_DEFERRED;}
#line 1898 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 107:
      case 109:
#line 118 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = yymsp[0].major;}
#line 1907 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 17:
      case 18:
#line 121 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1913 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 19:
#line 123 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1918 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 21:
#line 128 "ext/pdo_sqlite/sqlite/src/parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,yymsp[-4].minor.yy46,0,0,yymsp[-2].minor.yy46);
}
#line 1925 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 22:
      case 25:
      case 63:
      case 77:
      case 79:
      case 90:
      case 101:
      case 112:
      case 113:
      case 212:
      case 215:
#line 132 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = 0;}
#line 1940 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 23:
      case 24:
      case 64:
      case 78:
      case 100:
      case 111:
      case 213:
      case 216:
#line 133 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = 1;}
#line 1952 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 26:
#line 139 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy0,0);
}
#line 1959 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 27:
#line 142 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy219);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 1967 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 30:
#line 154 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy410.z = yymsp[-2].minor.yy410.z;
  yygotominor.yy410.n = (pParse->sLastToken.z-yymsp[-2].minor.yy410.z) + pParse->sLastToken.n;
}
#line 1975 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 31:
#line 158 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy410);
  yygotominor.yy410 = yymsp[0].minor.yy410;
}
#line 1983 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 32:
      case 33:
      case 34:
      case 35:
      case 36:
      case 252:
#line 168 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy0;}
#line 1993 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 38:
#line 228 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy410);}
#line 1998 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 39:
      case 42:
      case 119:
      case 120:
      case 131:
      case 150:
      case 240:
      case 250:
      case 251:
#line 229 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410 = yymsp[0].minor.yy410;}
#line 2011 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 40:
#line 230 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy410.z = yymsp[-3].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy410.z;
}
#line 2019 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 41:
#line 234 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy410.z = yymsp[-5].minor.yy410.z;
  yygotominor.yy410.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy410.z;
}
#line 2027 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 43:
#line 240 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410.z=yymsp[-1].minor.yy410.z; yygotominor.yy410.n=yymsp[0].minor.yy410.n+(yymsp[0].minor.yy410.z-yymsp[-1].minor.yy410.z);}
#line 2032 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 44:
#line 242 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = atoi((char*)yymsp[0].minor.yy410.z); }
#line 2037 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 45:
#line 243 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = -atoi((char*)yymsp[0].minor.yy410.z); }
#line 2042 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 50:
      case 52:
#line 252 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy172);}
#line 2048 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 51:
#line 253 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy172);}
#line 2053 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 53:
#line 255 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2061 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 54:
#line 259 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy410);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2069 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 56:
#line 268 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy46);}
#line 2074 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 57:
#line 270 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy46,yymsp[0].minor.yy46,yymsp[-2].minor.yy46);}
#line 2079 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 58:
#line 271 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy46,0,0,0,0);}
#line 2084 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 59:
#line 272 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-1].minor.yy172);}
#line 2089 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 60:
#line 274 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy410,yymsp[-1].minor.yy174,yymsp[0].minor.yy46);}
#line 2094 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 61:
#line 275 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy46);}
#line 2099 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 62:
#line 276 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddCollateType(pParse, (char*)yymsp[0].minor.yy410.z, yymsp[0].minor.yy410.n);}
#line 2104 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 65:
#line 289 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = OE_Restrict * 0x010101; }
#line 2109 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 66:
#line 290 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = (yymsp[-1].minor.yy46 & yymsp[0].minor.yy405.mask) | yymsp[0].minor.yy405.value; }
#line 2114 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 67:
#line 292 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy405.value = 0;     yygotominor.yy405.mask = 0x000000; }
#line 2119 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 68:
#line 293 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46;     yygotominor.yy405.mask = 0x0000ff; }
#line 2124 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 69:
#line 294 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<8;  yygotominor.yy405.mask = 0x00ff00; }
#line 2129 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 70:
#line 295 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy405.value = yymsp[0].minor.yy46<<16; yygotominor.yy405.mask = 0xff0000; }
#line 2134 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 71:
#line 297 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = OE_SetNull; }
#line 2139 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 72:
#line 298 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = OE_SetDflt; }
#line 2144 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 73:
#line 299 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = OE_Cascade; }
#line 2149 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 74:
#line 300 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = OE_Restrict; }
#line 2154 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 75:
      case 76:
      case 91:
      case 93:
      case 95:
      case 96:
      case 167:
#line 302 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = yymsp[0].minor.yy46;}
#line 2165 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 80:
#line 312 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410.n = 0; yygotominor.yy410.z = 0;}
#line 2170 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 81:
#line 313 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410 = yymsp[-1].minor.yy0;}
#line 2175 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 86:
#line 319 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy174,yymsp[0].minor.yy46,yymsp[-2].minor.yy46,0);}
#line 2180 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 87:
#line 321 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy174,yymsp[0].minor.yy46,0,0,0,0);}
#line 2185 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 88:
#line 322 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3AddCheckConstraint(pParse,yymsp[-2].minor.yy172);}
#line 2190 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 89:
#line 324 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy174, &yymsp[-3].minor.yy410, yymsp[-2].minor.yy174, yymsp[-1].minor.yy46);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy46);
}
#line 2198 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 92:
      case 94:
#line 338 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = OE_Default;}
#line 2204 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 97:
#line 343 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = OE_Ignore;}
#line 2209 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 98:
      case 168:
#line 344 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = OE_Replace;}
#line 2215 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 99:
#line 348 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 0, yymsp[-1].minor.yy46);
}
#line 2222 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 102:
#line 358 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, yymsp[0].minor.yy219, yymsp[-5].minor.yy46);
}
#line 2229 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 103:
#line 361 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy373, 1, yymsp[-1].minor.yy46);
}
#line 2236 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 104:
#line 368 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy219, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy219);
}
#line 2244 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 105:
      case 128:
#line 378 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy219 = yymsp[0].minor.yy219;}
#line 2250 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 106:
#line 380 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  if( yymsp[0].minor.yy219 ){
    yymsp[0].minor.yy219->op = yymsp[-1].minor.yy46;
    yymsp[0].minor.yy219->pPrior = yymsp[-2].minor.yy219;
  }
  yygotominor.yy219 = yymsp[0].minor.yy219;
}
#line 2261 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 108:
#line 389 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = TK_ALL;}
#line 2266 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 110:
#line 393 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy219 = sqlite3SelectNew(yymsp[-6].minor.yy174,yymsp[-5].minor.yy373,yymsp[-4].minor.yy172,yymsp[-3].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy174,yymsp[-7].minor.yy46,yymsp[0].minor.yy234.pLimit,yymsp[0].minor.yy234.pOffset);
}
#line 2273 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 114:
      case 237:
#line 414 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy174 = yymsp[-1].minor.yy174;}
#line 2279 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 115:
      case 141:
      case 151:
      case 236:
#line 415 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy174 = 0;}
#line 2287 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 116:
#line 416 "ext/pdo_sqlite/sqlite/src/parse.y"
{
   yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[-1].minor.yy172,yymsp[0].minor.yy410.n?&yymsp[0].minor.yy410:0);
}
#line 2294 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 117:
#line 419 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-1].minor.yy174, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2301 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 118:
#line 422 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-3].minor.yy174, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2310 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 121:
#line 434 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410.n = 0;}
#line 2315 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 122:
#line 446 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy373 = sqliteMalloc(sizeof(*yygotominor.yy373));}
#line 2320 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 123:
#line 447 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy373 = yymsp[0].minor.yy373;}
#line 2325 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 124:
#line 452 "ext/pdo_sqlite/sqlite/src/parse.y"
{
   yygotominor.yy373 = yymsp[-1].minor.yy373;
   if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].jointype = yymsp[0].minor.yy46;
}
#line 2333 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 125:
#line 456 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy373 = 0;}
#line 2338 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 126:
#line 457 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy373 = sqlite3SrcListAppend(yymsp[-5].minor.yy373,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410);
  if( yymsp[-2].minor.yy410.n ) sqlite3SrcListAddAlias(yygotominor.yy373,&yymsp[-2].minor.yy410);
  if( yymsp[-1].minor.yy172 ){
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pOn = yymsp[-1].minor.yy172; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy172); }
  }
  if( yymsp[0].minor.yy432 ){
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pUsing = yymsp[0].minor.yy432; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy432); }
  }
}
#line 2354 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 127:
#line 471 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy373 = sqlite3SrcListAppend(yymsp[-6].minor.yy373,0,0);
    if( yygotominor.yy373 && yygotominor.yy373->nSrc>0 ) yygotominor.yy373->a[yygotominor.yy373->nSrc-1].pSelect = yymsp[-4].minor.yy219;
    if( yymsp[-2].minor.yy410.n ) sqlite3SrcListAddAlias(yygotominor.yy373,&yymsp[-2].minor.yy410);
    if( yymsp[-1].minor.yy172 ){
      if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pOn = yymsp[-1].minor.yy172; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy172); }
    }
    if( yymsp[0].minor.yy432 ){
      if( yygotominor.yy373 && yygotominor.yy373->nSrc>1 ){ yygotominor.yy373->a[yygotominor.yy373->nSrc-2].pUsing = yymsp[0].minor.yy432; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy432); }
    }
  }
#line 2371 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 129:
#line 492 "ext/pdo_sqlite/sqlite/src/parse.y"
{
     yygotominor.yy219 = sqlite3SelectNew(0,yymsp[0].minor.yy373,0,0,0,0,0,0,0);
  }
#line 2378 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 130:
#line 498 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410.z=0; yygotominor.yy410.n=0;}
#line 2383 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 132:
#line 503 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy373 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);}
#line 2388 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 133:
#line 507 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = JT_INNER; }
#line 2393 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 134:
#line 508 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2398 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 135:
#line 509 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy410,0); }
#line 2403 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 136:
#line 511 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy410,&yymsp[-1].minor.yy410); }
#line 2408 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 137:
      case 145:
      case 154:
      case 161:
      case 175:
      case 202:
      case 225:
      case 227:
      case 231:
#line 515 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy172 = yymsp[0].minor.yy172;}
#line 2421 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 138:
      case 153:
      case 160:
      case 203:
      case 226:
      case 228:
      case 232:
#line 516 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy172 = 0;}
#line 2432 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 139:
      case 172:
#line 520 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy432 = yymsp[-1].minor.yy432;}
#line 2438 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 140:
      case 171:
#line 521 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy432 = 0;}
#line 2444 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 142:
      case 152:
#line 532 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy174 = yymsp[0].minor.yy174;}
#line 2450 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 143:
#line 533 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2458 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 144:
#line 537 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy172,yymsp[-1].minor.yy410.n>0?&yymsp[-1].minor.yy410:0);
  if( yygotominor.yy174 && yygotominor.yy174->a ) yygotominor.yy174->a[0].sortOrder = yymsp[0].minor.yy46;
}
#line 2466 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 146:
      case 148:
#line 546 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = SQLITE_SO_ASC;}
#line 2472 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 147:
#line 547 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = SQLITE_SO_DESC;}
#line 2477 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 149:
#line 549 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy410.z = 0; yygotominor.yy410.n = 0;}
#line 2482 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 155:
#line 567 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy234.pLimit = 0; yygotominor.yy234.pOffset = 0;}
#line 2487 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 156:
#line 568 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy234.pLimit = yymsp[0].minor.yy172; yygotominor.yy234.pOffset = 0;}
#line 2492 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 157:
#line 570 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy234.pLimit = yymsp[-2].minor.yy172; yygotominor.yy234.pOffset = yymsp[0].minor.yy172;}
#line 2497 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 158:
#line 572 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy234.pOffset = yymsp[-2].minor.yy172; yygotominor.yy234.pLimit = yymsp[0].minor.yy172;}
#line 2502 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 159:
#line 576 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy373,yymsp[0].minor.yy172);}
#line 2507 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 162:
#line 587 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy373,yymsp[-1].minor.yy174,yymsp[0].minor.yy172,yymsp[-4].minor.yy46);}
#line 2512 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 163:
#line 593 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2517 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 164:
#line 594 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,&yymsp[-2].minor.yy410);}
#line 2522 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 165:
#line 600 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy373, yymsp[-1].minor.yy174, 0, yymsp[-4].minor.yy432, yymsp[-7].minor.yy46);}
#line 2527 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 166:
#line 602 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy373, 0, yymsp[0].minor.yy219, yymsp[-1].minor.yy432, yymsp[-4].minor.yy46);}
#line 2532 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 169:
      case 229:
#line 612 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-2].minor.yy174,yymsp[0].minor.yy172,0);}
#line 2538 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 170:
      case 230:
#line 613 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy174 = sqlite3ExprListAppend(0,yymsp[0].minor.yy172,0);}
#line 2544 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 173:
#line 622 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(yymsp[-2].minor.yy432,&yymsp[0].minor.yy410);}
#line 2549 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 174:
#line 623 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy432 = sqlite3IdListAppend(0,&yymsp[0].minor.yy410);}
#line 2554 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 176:
#line 634 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy172 = yymsp[-1].minor.yy172; sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2559 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 177:
      case 182:
      case 183:
#line 635 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2566 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 178:
      case 179:
#line 636 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy172 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2572 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 180:
#line 638 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2581 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 181:
#line 643 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy410);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy410);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy410);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy172 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2592 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 184:
#line 652 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy172 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2597 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 185:
#line 653 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy172 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2606 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 186:
#line 659 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy172, 0, &yymsp[-1].minor.yy410);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2614 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 187:
#line 664 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(yymsp[-1].minor.yy174, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy46 && yygotominor.yy172 ){
    yygotominor.yy172->flags |= EP_Distinct;
  }
}
#line 2625 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 188:
#line 671 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2633 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 189:
#line 675 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy172 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy172 ) yygotominor.yy172->op = TK_CONST_FUNC;  
}
#line 2643 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
#line 681 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, 0);}
#line 2655 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 198:
      case 200:
#line 691 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 0;}
#line 2661 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 199:
      case 201:
#line 692 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy72.eOperator = yymsp[0].minor.yy0; yygotominor.yy72.not = 1;}
#line 2667 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 204:
#line 699 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  ExprList *pList;
  pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy172, 0);
  if( yymsp[0].minor.yy172 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  }
  yygotominor.yy172 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy72.eOperator);
  if( yymsp[-2].minor.yy72.not ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy172->span, &yymsp[-1].minor.yy172->span);
  if( yygotominor.yy172 ) yygotominor.yy172->flags |= EP_InfixFunc;
}
#line 2683 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 205:
#line 712 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[0].major, yymsp[-1].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2691 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 206:
#line 716 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2699 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 207:
#line 720 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2707 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 208:
#line 724 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,&yymsp[0].minor.yy0);
}
#line 2715 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 209:
#line 728 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2723 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 210:
#line 732 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2731 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 211:
#line 736 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy172->span);
}
#line 2739 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 214:
#line 743 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy172, 0);
  yygotominor.yy172 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy172, 0, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
  sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy172->span);
}
#line 2755 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 217:
#line 759 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pList = yymsp[-1].minor.yy174;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy174);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2769 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 218:
#line 769 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2782 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 219:
#line 778 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = yymsp[-1].minor.yy219;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
    if( yymsp[-3].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-4].minor.yy172->span,&yymsp[0].minor.yy0);
  }
#line 2796 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 220:
#line 788 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410);
    yygotominor.yy172 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy172, 0, 0);
    if( yygotominor.yy172 ){
      yygotominor.yy172->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy46 ) yygotominor.yy172 = sqlite3Expr(TK_NOT, yygotominor.yy172, 0, 0);
    sqlite3ExprSpan(yygotominor.yy172,&yymsp[-3].minor.yy172->span,yymsp[0].minor.yy410.z?&yymsp[0].minor.yy410:&yymsp[-1].minor.yy410);
  }
#line 2811 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 221:
#line 799 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    Expr *p = yygotominor.yy172 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy219;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy219);
    }
  }
#line 2824 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 222:
#line 811 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, 0);
  if( yygotominor.yy172 ){
    yygotominor.yy172->pList = yymsp[-2].minor.yy174;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy174);
  }
  sqlite3ExprSpan(yygotominor.yy172, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2837 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 223:
#line 822 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2845 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 224:
#line 826 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy174 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy172, 0);
  yygotominor.yy174 = sqlite3ExprListAppend(yygotominor.yy174, yymsp[0].minor.yy172, 0);
}
#line 2853 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 233:
#line 853 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3CreateIndex(pParse, &yymsp[-6].minor.yy410, &yymsp[-5].minor.yy410, sqlite3SrcListAppend(0,&yymsp[-3].minor.yy410,0), yymsp[-1].minor.yy174, yymsp[-9].minor.yy46,
                      &yymsp[-10].minor.yy0, &yymsp[0].minor.yy0, SQLITE_SO_ASC, yymsp[-7].minor.yy46);
}
#line 2861 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 234:
      case 279:
#line 859 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = OE_Abort;}
#line 2867 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 235:
#line 860 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = OE_None;}
#line 2872 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 238:
#line 870 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(yymsp[-4].minor.yy174, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2885 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 239:
#line 879 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy410.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, (char*)yymsp[-1].minor.yy410.z, yymsp[-1].minor.yy410.n);
  }
  yygotominor.yy174 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy410);
  if( yygotominor.yy174 ) yygotominor.yy174->a[yygotominor.yy174->nExpr-1].sortOrder = yymsp[0].minor.yy46;
}
#line 2898 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 241:
#line 893 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy373, yymsp[-1].minor.yy46);}
#line 2903 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 242:
      case 243:
#line 897 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Vacuum(pParse);}
#line 2909 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 244:
      case 246:
#line 903 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,0);}
#line 2915 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 245:
#line 904 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy0,0);}
#line 2920 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 247:
#line 906 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy410,&yymsp[-2].minor.yy410,&yymsp[0].minor.yy410,1);
}
#line 2927 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 248:
#line 909 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy410,&yymsp[-3].minor.yy410,&yymsp[-1].minor.yy410,0);}
#line 2932 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 249:
#line 910 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy410,&yymsp[0].minor.yy410,0,0);}
#line 2937 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 255:
#line 922 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy410.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy410.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy243, &all);
}
#line 2947 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 256:
#line 931 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy410, &yymsp[-6].minor.yy410, yymsp[-5].minor.yy46, yymsp[-4].minor.yy370.a, yymsp[-4].minor.yy370.b, yymsp[-2].minor.yy373, yymsp[-1].minor.yy46, yymsp[0].minor.yy172, yymsp[-9].minor.yy46);
  yygotominor.yy410 = (yymsp[-6].minor.yy410.n==0?yymsp[-7].minor.yy410:yymsp[-6].minor.yy410);
}
#line 2955 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 257:
      case 260:
#line 937 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = TK_BEFORE; }
#line 2961 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 258:
#line 938 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = TK_AFTER;  }
#line 2966 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 259:
#line 939 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = TK_INSTEAD;}
#line 2971 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 261:
      case 262:
#line 944 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy370.a = yymsp[0].major; yygotominor.yy370.b = 0;}
#line 2977 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 263:
#line 946 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy370.a = TK_UPDATE; yygotominor.yy370.b = yymsp[0].minor.yy432;}
#line 2982 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 264:
      case 265:
#line 949 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = TK_ROW; }
#line 2988 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 266:
#line 951 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy46 = TK_STATEMENT; }
#line 2993 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 267:
#line 955 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy172 = 0; }
#line 2998 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 268:
#line 956 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy172 = yymsp[0].minor.yy172; }
#line 3003 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 269:
#line 960 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  if( yymsp[-2].minor.yy243 ){
    yymsp[-2].minor.yy243->pLast->pNext = yymsp[-1].minor.yy243;
  }else{
    yymsp[-2].minor.yy243 = yymsp[-1].minor.yy243;
  }
  yymsp[-2].minor.yy243->pLast = yymsp[-1].minor.yy243;
  yygotominor.yy243 = yymsp[-2].minor.yy243;
}
#line 3016 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 270:
#line 969 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy243 = 0; }
#line 3021 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 271:
#line 975 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy243 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy410, yymsp[-1].minor.yy174, yymsp[0].minor.yy172, yymsp[-4].minor.yy46); }
#line 3026 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 272:
#line 980 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy410, yymsp[-4].minor.yy432, yymsp[-1].minor.yy174, 0, yymsp[-7].minor.yy46);}
#line 3031 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 273:
#line 983 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy243 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy410, yymsp[-1].minor.yy432, 0, yymsp[0].minor.yy219, yymsp[-4].minor.yy46);}
#line 3036 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 274:
#line 987 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy243 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy410, yymsp[0].minor.yy172);}
#line 3041 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 275:
#line 990 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy243 = sqlite3TriggerSelectStep(yymsp[0].minor.yy219); }
#line 3046 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 276:
#line 993 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  if( yygotominor.yy172 ){
    yygotominor.yy172->iColumn = OE_Ignore;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3057 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 277:
#line 1000 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  yygotominor.yy172 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy410); 
  if( yygotominor.yy172 ) {
    yygotominor.yy172->iColumn = yymsp[-3].minor.yy46;
    sqlite3ExprSpan(yygotominor.yy172, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
  }
}
#line 3068 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 278:
#line 1010 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = OE_Rollback;}
#line 3073 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 280:
#line 1012 "ext/pdo_sqlite/sqlite/src/parse.y"
{yygotominor.yy46 = OE_Fail;}
#line 3078 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 281:
#line 1017 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy373);
}
#line 3085 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 282:
#line 1023 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Attach(pParse, yymsp[-3].minor.yy172, yymsp[-1].minor.yy172, yymsp[0].minor.yy386);
}
#line 3092 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 283:
#line 1028 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy386 = 0; }
#line 3097 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 284:
#line 1029 "ext/pdo_sqlite/sqlite/src/parse.y"
{ yygotominor.yy386 = yymsp[0].minor.yy172; }
#line 3102 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 287:
#line 1035 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3Detach(pParse, yymsp[0].minor.yy172);
}
#line 3109 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 288:
#line 1041 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3114 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 289:
#line 1042 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3119 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 290:
#line 1047 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3124 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 291:
#line 1048 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy410, &yymsp[0].minor.yy410);}
#line 3129 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 292:
#line 1053 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy373,&yymsp[0].minor.yy410);
}
#line 3136 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 293:
#line 1056 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy410);
}
#line 3143 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 294:
#line 1059 "ext/pdo_sqlite/sqlite/src/parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy373);
}
#line 3150 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 297:
#line 1068 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3VtabFinishParse(pParse,0);}
#line 3155 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 298:
#line 1069 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3VtabFinishParse(pParse,&yymsp[0].minor.yy0);}
#line 3160 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 299:
#line 1070 "ext/pdo_sqlite/sqlite/src/parse.y"
{
    sqlite3VtabBeginParse(pParse, &yymsp[-3].minor.yy410, &yymsp[-2].minor.yy410, &yymsp[0].minor.yy410);
}
#line 3167 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 302:
#line 1075 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3VtabArgInit(pParse);}
#line 3172 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
      case 304:
      case 305:
      case 306:
      case 308:
#line 1077 "ext/pdo_sqlite/sqlite/src/parse.y"
{sqlite3VtabArgExtend(pParse,&yymsp[0].minor.yy0);}
#line 3180 "ext/pdo_sqlite/sqlite/src/parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "ext/pdo_sqlite/sqlite/src/parse.y"

  if( !pParse->parseError ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
    pParse->parseError = 1;
  }
#line 3248 "ext/pdo_sqlite/sqlite/src/parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
