#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: IOBinding.py 82 2004-07-11 13:01:44Z henning $

import os
import tkFileDialog
import tkMessageBox
import debug
import broker
import broadcaster

class IOBinding:

    def __init__(self, view):
        self.view = view
        self.top = view.window()
        self.model = view.model
        self.__id_import = self.top.bind("<<import-file>>",
                                            self.importFile)
        self.__id_export = self.top.bind("<<export-file>>",
                                            self.exportFile)

    def close(self):
        # Undo command bindings
        self.top.unbind("<<import-file>>", self.__id_import)
        self.top.unbind("<<export-file>>",self.__id_export)
        # Break cycles
        self.view = None
        self.top = None
        self.model = None

    def importFile(self, event):
        import converters
        data = {'handle':None}
        def onContactNew(data=data):
            data['handle'] = broadcaster.CurrentData()['handle']
        # temporarily hook ourselves in the broadcast channel:    
        broadcaster.Register(onContactNew, source="Contact", title="Added")
        ret = converters.Import(self.top, self.model)
        broadcaster.UnRegister(onContactNew, source="Contact", title="Added")
        if ret:
            # Now broadcast our success with our sniffed handle:
            broadcaster.Broadcast("Contacts", "Imported", data=data);
        return "break"

    def exportFile(self, event):
        import converters
        converters.Export(self.top, self.model)
        return "break"

