/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id$
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "cfgtabpagesettingsqbm.h"
#include "cfgtabpagesettingsqbm.ui.h"
#include "kbanking.h"

#include <qcheckbox.h>
#include <qspinbox.h>



CfgTabPageSettingsQbm::CfgTabPageSettingsQbm(KBanking *ab,
                                             QWidget *parent,
                                             const char *name,
                                             WFlags fl)
:QBCfgTabPage(ab, tr("General"), parent, name, fl)
,_banking(ab) {

  setHelpSubject("CfgTabPageSettingsQbm");
  setDescription(tr("<p>General settings of QBankManager.</p>"));

  _realPage=new CfgTabPageSettingsQbmUi(this);
  addWidget(_realPage);
  _realPage->show();
}


CfgTabPageSettingsQbm::~CfgTabPageSettingsQbm() {
}



bool CfgTabPageSettingsQbm::fromGui() {
  _banking
    ->setOptionAutoAssignPayee(_realPage
                               ->autoAssignPayeeCheck->isChecked());
  _banking
    ->setOptionAutoAskForPayee(_realPage
                               ->autoAskPayeeCheck->isChecked());

  _banking->setFuzzyThreshold(_realPage->normalThresholdSpin->value());
  _banking
    ->setSensitiveFuzzyThreshold(_realPage->sensitiveThresholdSpin->value());

  _banking
    ->setOptionAutoAssignCategory(_realPage
                                  ->autoAssignCategoryCheck->isChecked());
  _banking
    ->setOptionAutoAskForCategory(_realPage
                                  ->autoAskCategoryCheck->isChecked());
  _banking
    ->setUseColoursForCategoryText(_realPage
                                   ->useColoursForCategoryTextCheck
                                   ->isChecked());
  return true;
}



bool CfgTabPageSettingsQbm::toGui() {
  _realPage
    ->autoAssignPayeeCheck
    ->setChecked(_banking->optionAutoAssignPayee());
  _realPage
    ->autoAskPayeeCheck
    ->setChecked(_banking->optionAutoAskForPayee());
  _realPage
    ->normalThresholdSpin
    ->setValue(_banking->getFuzzyThreshold());
  _realPage
    ->sensitiveThresholdSpin
    ->setValue(_banking->getSensitiveFuzzyThreshold());
  _realPage
    ->autoAssignCategoryCheck
    ->setChecked(_banking->optionAutoAssignCategory());
  _realPage
    ->autoAskCategoryCheck
    ->setChecked(_banking->optionAutoAskForCategory());
  _realPage
    ->useColoursForCategoryTextCheck
    ->setChecked(_banking->useColoursForCategoryText());
  return true;
}



bool CfgTabPageSettingsQbm::checkGui() {
  return true;
}







