<?php
/******************************************************************************
 *  SiteBar 3 - The Bookmark Server for Personal and Team Use.                *
 *  Copyright (C) 2003-2006  Ondrej Brablc <http://brablc.com/mailto?o>       *
 *                                                                            *
 *  This program is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  This program is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with this program; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA *
 ******************************************************************************/

/**
* Use for emergency process when Base URL is wrongly configured
* On most servers setting to empty string '' should be fine enough to
* enter SiteBar Settings and fix the problem.
*/
define( 'ABS_BASE_URL', null);

define( 'MIN_VERSION',  '4.1.0');
define( 'CHARSET',      'charset=UTF-8');
define( 'CONTENT_TYPE', 'text/html; '.CHARSET);
define( 'STATIC_VERSION',   '3.3.8' );

if (!function_exists('version_compare') || version_compare(phpversion(), MIN_VERSION, '<'))
{
    die('Please use at least PHP ' . MIN_VERSION . ' or download SiteBar release 3.0.2!');
}

/******************************************************************************/

if (get_magic_quotes_gpc()) // We need this until PHP 6.0?
{
   function stripslashes_deep($value)
   {
       $value = is_array($value)?array_map('stripslashes_deep', $value):stripslashes($value);
       return $value;
   }

   $_POST = array_map('stripslashes_deep', $_POST);
   $_GET = array_map('stripslashes_deep', $_GET);
   $_COOKIE = array_map('stripslashes_deep', $_COOKIE);
}

/******************************************************************************/

function SB_reqVal($name, $mandatory=false, $default='')
{
    $is = SB_reqChk($name);
    if ($mandatory && !$is)
    {
        die('Expected field "'. $name .'" was not filled!');
    }
    return $is?$_REQUEST[$name]:$default;
}

function SB_setVal($name, $value)
{
    $_REQUEST[$name]=$value;
}

function SB_unsetVal($name)
{
    unset($_REQUEST[$name]);
}

function SB_reqChk($name)
{
    return isset($_REQUEST[$name]);
}

function SB_safePath($include)
{
    // We only allow letters, numbers and space for file paths to be included
    if (!preg_match("/^[a-z0-9_ ]+$/i", $include))
    {
        die('Unsafe path for inclusion: How did you get here?');
    }
}

function SB_redirect($url)
{
    header('Location: ' . SB_Page::absBaseUrl() . $url);
    exit;
}

function SB_handleRootCookie($page='index.php')
{
    if (isset($_GET['root']) && $_GET['root'] == 'cookie')
    {
        $_GET['root'] = $_COOKIE['SB3CTXROOT'];
        $params = array();
        foreach ($_GET as $key => $value)
        {
            $params[] = $key . "=" . $value;
        }
        SB_redirect($page . '?' . implode('&',$params));
    }
}

/******************************************************************************/

class SB_HookInterface extends SB_ErrorHandler
{
    function head()
    {
        // We must have it on one line for MS IE
        echo '<div id="logo"><a href="'.SB_Page::relBaseUrl().'integrator.php" '. SB_Page::target().'><img title="SiteBar Integrator" src="'. SB_Skin::imgsrc('logo').'" alt=""></a></div>'."\r";
    }

    function poweredBy($version, &$um)
    {
?>
    <div id='poweredBy'>
<?php
        $link = '<a href="http://sitebar.org/" '.SB_Page::target().'>%s</a>';
        if ($um->isAnonymous())
        {
            echo sprintf($link,'SiteBar ').sprintf($link,SB_T('Bookmark Manager'));
        }
        else
        {
            echo SB_T('Powered by %s ver. %s', array("<strong>".sprintf($link,'SiteBar')."</a></strong>",$version));
        }
?>
    </div>
<?php
    }

    function designedBy()
    {
        $this->error('Please override designedBy for your custom skins!');
    }

    function statistics($statistics)
    {
        echo '<div id="stat">'. SB_A('hook::statistics', $statistics).'</div>';
    }

    function foot($version, $statistics, &$um)
    {

?>
<div id="tail">
    <div class="poweredBy">
<?php
        $this->poweredBy($version, $um);
?>
    </div>
    <div class="designedBy">
<?php
        $this->designedBy();
?>
    </div>
</div>
<?php

        if ($statistics)
        {
            $this->statistics($statistics);
        }
    }

    function getStyle($styleID)
    {
        return '';
    }
}

/******************************************************************************/

class SB_SponsorInterface
{
    var $hook = null;

    function SB_SponsorInterface(&$hook)
    {
        $this->hook =& $hook;
    }

    function integratorVerticalRight()
    {
    }

    function buildAddLink()
    {
        return '';
    }

    function sitebarBottom()
    {
    }
}

/******************************************************************************/

class SB_Skin extends SB_ErrorHandler
{
    var $current = 'Modern';

    function & staticInstance()
    {
        static $skin = null;
        if (!$skin)
        {
            $skin = new SB_Skin();
        }

        return $skin;
    }

    function get()
    {
        $i =& SB_Skin::staticInstance();
        return $i->current;
    }

    function set($skin)
    {
        if ($skin)
        {
            static $i = null;
            if (!$i) $i =& SB_Skin::staticInstance();

            SB_safePath($skin);

            $dirName = './skins/' . $skin;

            if (is_dir($dirName) && is_file($dirName.'/hook.inc.php'))
            {
                $i->current = $skin;
            }
        }
    }

    function img($filename, $prefix='', $id='', $class=null)
    {
        $imgid = '';

        if ($prefix)
        {
            $imgid = ' id="i' . $prefix . $id . '"';
        }

        return '<img'.($class?' class="'.$class.'"':'') . $imgid .
               ' src="'. SB_Skin::imgsrc($filename) .'" alt="">';
    }

    function imgsrc($filename)
    {
        return SB_Skin::webPath() . '/' . $filename . '.png';
    }

    function src($filename='')
    {
        return SB_Skin::webPath() . ($filename?'/':'') . $filename;
    }

    function path()
    {
        return 'skins/'. SB_Skin::get();
    }

    function webPath()
    {
        return SB_Page::relBaseUrl() . 'skins/'. rawurlencode(SB_Skin::get());
    }
}

class SB_Page extends SB_ErrorHandler
{
    function title()
    {
        return 'SiteBar';
    }

    // Backward compatibility
    function baseurl($override=null)
    {
        return SB_Page::absBaseUrlShort($override);
    }

    function absBaseUrlShort($override=null)
    {
        $url = SB_Page::absBaseUrl($override);
        return substr($url,0,strlen($url)-1);
    }

    function absBaseUrl($override=null)
    {
        static $url = null;

        if (ABS_BASE_URL!==null)
        {
            return ABS_BASE_URL;
        }

        if ($override!==null)
        {
            $url = $override;
        }

        if ($url === null)
        {
            $hostvar = isset($_SERVER['HTTP_HOST'])?'HTTP_HOST':'SERVER_NAME';
            $scripturl = isset($_SERVER['SCRIPT_URL'])?$_SERVER['SCRIPT_URL']:$_SERVER['SCRIPT_NAME'];
            $basedir = dirname($_SERVER[$hostvar].$scripturl);
            $https = $_SERVER['SERVER_PORT']!=80
                  && isset($_SERVER['HTTPS'])
                  && strtolower($_SERVER['HTTPS']) == 'on';
            $url = 'http' . ($https?'s':'') . '://' . $basedir;
        }

        if ($url{strlen($url)-1} != '/')
        {
            $url .= '/';
        }

        return $url;
    }

    function relBaseUrl($override=null)
    {
        static $url = null;

        if ($override!==null)
        {
            $url = $override;
        }

        if ($url === null)
        {
            $url = '';
        }

        if (strlen($url)>0 && $url{strlen($url)-1} != '/')
        {
            $url .= '/';
        }

        return $url;
    }

    function isMSIE()
    {
        static $isMSIE = null;

        if ($isMSIE === null)
        {
            $isMSIE = strstr(SB_safeVal($_SERVER,'HTTP_USER_AGENT'), 'MSIE');
        }

        return $isMSIE;
    }

    // Exclude Opera
    function isOPERA()
    {
        static $isOPERA = null;

        if ($isOPERA === null)
        {
            $isOPERA = strstr(SB_safeVal($_SERVER,'HTTP_USER_AGENT'), 'Opera');
        }

        return $isOPERA;
    }

    function isGECKO()
    {
        static $isGECKO= null;

        if ($isGECKO=== null)
        {
            $isGECKO = strstr(SB_safeVal($_SERVER,'HTTP_USER_AGENT'), 'Gecko');
        }

        return $isGECKO;
    }

    function dragDropNode($nid)
    {
        if (SB_Page::isOPERA())
        {
            return '';
        }

        return ' '.
            (SB_Page::isMSIE()?'ondragstart':'onmousedown').
            '="return SB_nodeDrag(event,'. $nid .');"'.
            ' onmouseup="return SB_nodeDrop(event,this.parentNode,'. $nid .');"';
    }

    function dragDropLink($nid, $lid)
    {
        if (SB_Page::isOPERA())
        {
            return '';
        }

        return ' '.
            (SB_Page::isMSIE()?'ondragstart':'onmousedown').
            '="return SB_linkDrag(event,'. $lid .');"'.
            ' onmouseup="return SB_nodeDrop(event,this.parentNode,'. $nid .','. $lid . ');"';
    }

    function toolTip()
    {
        return ' onmouseover="SB_toolTip(this,event);" onmouseout="SB_toolTipHide();" ';
    }

    function targetWindow()
    {
        static $trg = null;

        if ($trg === null)
        {
            $target = (SB_Page::isMSIE()||SB_Page::isOPERA()?'_main':'_content');
            if (isset($_REQUEST['target'])) $target = $_REQUEST['target'];
            $trg = $target;
        }
        return $trg;
    }

    function target()
    {
        static $trg = null;

        if ($trg === null)
        {
            $trg = ' target="'.SB_Page::targetWindow().'"';
        }
        return $trg;
    }

    function head($title, $bodyClass=null, $inscript=null, $onLoad=null, $meta=null)
    {
        // Media="All" is used to hide the styles from Netscape 4.x

        header('Content-Type: ' . CONTENT_TYPE);

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/REC-html401/loose.dtd">

<html>
<head>
    <title>:: <?php echo SB_Page::title()?> :: <?php echo SB_T($title)?></title>
    <meta http-equiv="Content-Type" content="<?php echo CONTENT_TYPE?>">
    <meta name="keywords" content="bookmark manager, online bookmark manager, online bookmarks, favorites manager, online favorites, bookmark organizer, firefox bookmark manager, bookmark server">
    <meta name="description" content="Open Source Freeware Bookmark Server for Personal and Team Use.">
<?php echo $meta?>
    <link rel="shortcut Icon" href="<?php echo SB_Skin::webPath()?>/root_transparent.png">
    <link rel="author" href="http://brablc.com/">
    <link rel="bookmark" href="http://sitebar.org/" title="online bookmark manager">
    <link rel="help" href="http://sitebar.org/userguide.php">
<?php

        $sortModes = array
        (
            'added'   => 'Recently Added',
            'changed' => 'Recently Modified',
            'visited' => 'Recently Visited',
            'hits'    => 'Most Popular',
            'waiting' => 'Waiting for Visit',
        );

        foreach( $sortModes as $mode => $sortLabel)
        {
?>
    <link rel="alternate" type="application/rss+xml"
          title="SiteBar Bookmarks [<?php echo $sortLabel?>]"
          href="<?php echo SB_Page::absBaseUrl()?>index.php?w=rss&amp;sort=<?php echo $mode?>&amp;max=20">
<?php
        }

        SB_Page::headerContent($inscript);
?>
</head>
<body class="cmnBaseFont cmnPageBackground <?php echo $bodyClass?>" <?php echo ($onLoad?' onLoad="'.$onLoad.'"':'')?> onmouseup="SB_cancelDragging();">
<?php
    }

    function headerContent($inscript)
    {
?>
    <link rel="stylesheet" type="text/css" href="<?php echo SB_Skin::webPath() ?>/sitebar.css?version=<?php echo STATIC_VERSION ?>" media="all">
    <script type="text/javascript" src="<?php echo SB_Page::relBaseUrl()?>inc/sitebar.js?version=<?php echo STATIC_VERSION ?>"></script>
    <script type="text/javascript">
        SB_setBaseDir('<?php echo SB_Page::absBaseUrl()?>');
        SB_setSkinDir('<?php echo SB_Skin::path()?>/');
        <?php echo $inscript."\n"?>
    </script>
<?php
    }

    function foot()
    {
?>
</body>
</html>
<?php
    }

    function quoteValue($value)
    {
        // XML entities: &lt; &gt; &amp; &quot;

        if ( preg_match('/[&<>"]/',$value) )
        {
            $entity = array('&amp;','&lt;','&gt;','&quot;');
            $char   = array('&','<','>','"');
            $value = str_replace($entity, $char, $value);
            $value = str_replace($char, $entity, $value);
        }

        return str_replace("\r\n",' ', $value);
    }
}
?>
