##############################################################################
#
# Copyright (c) 2004-2006 TINY SPRL. (http://tiny.be) All Rights Reserved.
#                    Fabien Pinckaers <fp@tiny.Be>
#
# WARNING: This program as such is intended to be used by professional
# programmers who take the whole responsability of assessing all potential
# consequences resulting from its eventual inadequacies and bugs
# End users who are looking for a ready-to-use solution with commercial
# garantees and support are strongly adviced to contract a Free Software
# Service Company
#
# This program is Free Software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
##############################################################################

import wizard
import netsvc
import time

from osv import osv

def _action_sale_create(self, cr, uid, data, context):
	result = []
	so = osv.osv_pools.get('sale.order')
	for partner_id in data['ids']:
		value = so.onchange_partner_id(cr, uid, partner_id, partner_id)['value']
		value.update({
			'partner_id': partner_id
		})
		try:
			result.append(so.create(cr, uid, value))
		except:
			raise wizard.except_wizard('UserError', 'Set default Shop in Sale Order\nbefore using this functionality !')

	view_type = 'form,tree'
	if len(data['ids']) > 1:
		view_type = 'tree,form'
		
	value = {
		'domain': "[('id','in',["+','.join(map(str,result))+"])]",
		'name': 'Create Sale Orders',
		'view_type': 'form',
		'view_mode': view_type,
		'res_model': 'sale.order',
		'view_id': False,
		'type': 'ir.actions.act_window'
	}
	if view_type == 'form,tree':
		value['res_id'] = result[0]
	return value

class wiz_journal(wizard.interface):
	states = {
		'init': {
			'actions': [],
			'result': {'type': 'action', 'action': _action_sale_create, 'state':'end'}
		}
	}
wiz_journal('sale.partner.shortcut')

