#ifndef FLOATOBJ_H
#define FLOATOBJ_H

#include "ornamentedobj.h"

/////////////////////////////////////////////////////////////////////////////
class FloatObj:public OrnamentedObj {
public:
    FloatObj ();
    FloatObj (QCanvas*);
    FloatObj (QCanvas*, LinkableMapObj* parent);
    ~FloatObj ();
    virtual void init ();
    virtual void copy (FloatObj*);
	virtual bool load (const QString&)=0;
	virtual void setZ(const int&);		// set zPlane
	virtual int z();
	virtual void setFloatExport (const bool &);
	virtual bool getFloatExport ();

	virtual void move (double,double);
	virtual void move (QPoint);
	virtual void setDockPos();
	virtual void reposition();
											
	virtual QRect getTotalBBox();			// return BBox including childs			
	virtual QRect getBBoxSizeWithChilds();	// return size of BBox including childs  

	virtual void resetSaveCounter()=0;

	virtual void select();
	virtual void unselect();

protected:
	bool floatExport;
	int zPlane;
};

#endif
