/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 * Copyright (C) 1998 Rasca, Berlin
 * EMail: thron@gmx.de
 *
 * Olivier Fourdan (fourdan@xfce.org)
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <X11/Xlib.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"
#include "modules.h"

#include "dnd.h"

#include "cpy.h"
#include "rcp.h"
#include "icons.h"
#include "entry.h"
#include "misc.h"
#include "monitor.h"
#include "password_dialog.h"
#include "run.h"
#include "refresh.h"
#include "uri.h"
#include "widgets.h"

/*#define DEBUG*/


extern char *src_host;
extern gboolean tar_extraction;
static gboolean dragging = FALSE;
static GtkTreeRowReference *target_ref = NULL;

static int scrolltimer=0;

enum
{
    DND_NONE,
    DND_MOVE,
    DND_COPY,
    DND_LINK
};

enum
{
    TARGET_URI_LIST,
    TARGET_PLAIN,
    TARGET_UTF8,
    TARGET_STRING,
    TARGET_ROOTWIN,
    TARGET_MOZ_URL,
    TARGET_XDS,
    TARGET_RAW,
    TARGETS
};

#define MAXURILEN 4096		/* Longest URI to allow */

static GtkTargetEntry target_table[] = {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"text/x-moz-url", 0, TARGET_MOZ_URL},
    {"text/plain", 0, TARGET_PLAIN},
    {"UTF8_STRING", 0, TARGET_UTF8},
    {"STRING", 0, TARGET_STRING}
};
#define NUM_TARGETS (sizeof(target_table)/sizeof(GtkTargetEntry))
static gboolean drop_cancelled = FALSE;

static GList *selection_list = NULL;
static int selection_len;
static char *dnd_data = NULL;
static int the_mode;
static int drag_type;

#define DRAG_TYPE_UNDEFINED	0
#define DRAG_TYPE_LOCAL		0x01
#define DRAG_TYPE_NET		0x02
#define DRAG_TYPE_INCONSISTENT	0x04

typedef struct selection_list_t
{
    tree_entry_t *en;
    GtkTreeRowReference *reference;
}
selection_list_t;
typedef struct scrolltree_t
{
    GtkTreeView *treeview;
    gint scrolly;
    gint scrollheight;
}
scrolltree_t;

static scrolltree_t scrolltree_v;
static gint title_offset=0;

G_MODULE_EXPORT
void update_status_line (tree_entry_t *en){
    if (en && en->path) {
        gchar *readable_path=g_path_get_basename(en->path);
        if (IS_NETWORK_TYPE(en->type)&&!IS_SAMBA_SERVER(en->subtype)){
		ascii_readable(readable_path);
	}
	print_status_tmp(resolve_icon_small(en),readable_path,NULL);
    	g_free(readable_path);
	/*printf("DBG: item is=%s\n", en->path);*/
    } 	
    else print_status(NULL,"",NULL);
}

static void update_multistatus_line(tree_entry_t *en){
    if (selection_list && g_list_length(selection_list) >= 1){
	if (g_list_length(selection_list) == 1 && en) update_status_line(en);
	else {
	    gchar *g=g_strdup_printf(_("%d item(s) selected"),g_list_length(selection_list));
	    if (g_list_length(selection_list) == 1) print_status ("xfce/info",g,NULL);
	    else print_status ("xfce/warning",g,NULL);
	    g_free(g);
	}
    } else if (en) update_status_line(en);
}

#define SCROLL_OFFSET (title_offset)
static gint scrolltree(gpointer data){
     GdkRectangle visible;
     if (!GTK_IS_TREE_VIEW (scrolltree_v.treeview)) return TRUE;
     
     gtk_tree_view_get_visible_rect(scrolltree_v.treeview,&visible); 
            /*printf("CELL: y=(%d,%d), visible=(%d,%d)\n",
			    scrolltree_v.scrolly - scrolltree_v.scrollheight,
			    scrolltree_v.scrolly + scrolltree_v.scrollheight,
			    visible.y,visible.y+visible.height);*/
     if (scrolltree_v.scrolly - scrolltree_v.scrollheight <= visible.y+SCROLL_OFFSET){   
            /*printf("scroll UP \n");*/
	    gtk_tree_view_scroll_to_point (scrolltree_v.treeview,0,scrolltree_v.scrolly - scrolltree_v.scrollheight-SCROLL_OFFSET);
	    if (scrolltree_v.scrolly >= scrolltree_v.scrollheight) 
		    scrolltree_v.scrolly -= scrolltree_v.scrollheight;
     }
     if (scrolltree_v.scrolly + scrolltree_v.scrollheight >= visible.y+visible.height){ 
	    int y=  visible.y;
	    /*printf("scroll DOWN \n");*/
	    /*gtk_tree_view_scroll_to_point (scrolltree_v.treeview,0,scrolltree_v.scrolly + scrolltree_v.scrollheight);*/
	    gtk_tree_view_scroll_to_point (scrolltree_v.treeview,0,visible.y+scrolltree_v.scrollheight);
            gtk_tree_view_get_visible_rect(scrolltree_v.treeview,&visible); 
	    if (y != visible.y){
		    scrolltree_v.scrolly = visible.y + visible.height - scrolltree_v.scrollheight;
	    }
     }
     return TRUE;
}



G_MODULE_EXPORT
void cancel_drop (gboolean state)
{
    drop_cancelled = state;
}

G_MODULE_EXPORT
void reselect_dnd_list (GtkTreeView *treeview){
    GList *tmp;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    for (tmp=selection_list;tmp;tmp=tmp->next){
	selection_list_t *sl=tmp->data;
        if(sl && gtk_tree_row_reference_valid(sl->reference)){
           GtkTreePath *treepath = gtk_tree_row_reference_get_path(sl->reference);
	   /*printf("DBG: reselecting %s\n",sl->en->path);*/
	   gtk_tree_selection_select_path (selection,treepath);
	   gtk_tree_path_free(treepath);
	}
    }
    /* for status line to be updated before release */
    if (!(tree_details->preferences & ENABLE_GTK_CLICK)){
       /* this is always true here...*/
	if (selection_list && g_list_length(selection_list))
    	    update_multistatus_line(NULL);
    } 
}

G_MODULE_EXPORT
void clear_dnd_selection_list (void)
{
    GList *tmp = selection_list;
    if (dragging) return;
    TRACE("DBG: clearing selection list!\n");
    while(tmp)
    {
	selection_list_t *sl;
	sl = (selection_list_t *) tmp->data;
	if(sl->reference)
	    gtk_tree_row_reference_free(sl->reference);
	g_free(sl);
	sl=NULL;
	tmp = tmp->next;
    }
    if(selection_list)
    {
	g_list_free(selection_list);
	selection_list = NULL;
	selection_len = 0;
    }
    selection_list = NULL;
}

G_MODULE_EXPORT
void clear_path_from_selection_list (GtkTreeView *treeview,GtkTreePath *treepath)
{
    GtkTreePath *path;
    GtkTreeSelection *selection = gtk_tree_view_get_selection(treeview);
    GList *tmp = selection_list;
    if (!treepath || ! treeview) return;
    gtk_tree_selection_unselect_path (selection,treepath);
    for (tmp=selection_list;tmp;tmp=tmp->next)
    {
	selection_list_t *sl;
	sl = (selection_list_t *) tmp->data;
	path=gtk_tree_row_reference_get_path(sl->reference);
	if (!path || gtk_tree_path_compare(path,treepath)==0){
	    selection_list = g_list_remove(selection_list,sl);
	    g_free(sl);
	    if (path) gtk_tree_path_free(path);
	    return;
	}
        gtk_tree_path_free(path);
    }
    return;
}

G_MODULE_EXPORT
void   on_drag_begin (GtkWidget *widget,GdkDragContext *drag_context,gpointer user_data){
    	dragging = TRUE;
	/*printf("DBG: 	on_drag_begin\n");*/
	if (selection_list && g_list_length(selection_list) > 1){
	    gtk_drag_set_icon_stock (drag_context,"gtk-dnd-multiple",-10,-10);
	} else if (selection_list && g_list_length(selection_list) == 1){
	    GdkPixbuf *pixbuf;
	    selection_list_t *sl=(selection_list_t *)selection_list->data;
	    pixbuf=resolve_icon_size(sl->en,BIG);
	    if (pixbuf) {
	      gtk_drag_set_icon_pixbuf (drag_context,pixbuf,-10,-10);
	      g_object_unref(G_OBJECT(pixbuf));
	    }
	} else {
	    gtk_drag_set_icon_stock (drag_context,"gtk-dnd",-10,-10);
	}


	/* this works better with plain motion-event */
	/*reselect_dnd_list((GtkTreeView *)widget);   */
}

static gboolean valid_drop_site(GtkTreeView * treeview, gint x, gint y, tree_entry_t ** en, GtkTreeRowReference ** reference)
{
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    GtkTreeIter iter;
    GtkTreePath *treepath=NULL;


#ifdef DEBUG	
	/*{
	    gint nx,ny;
	   gtk_tree_view_widget_to_tree_coords(treeview,x,y,&nx,&ny);
	   printf("widget x,y=%d,%d  tree x,y=%d,%d\n",x,y,nx,ny);
	}*/
#endif
    if (gtk_tree_view_get_headers_visible(treeview)){
	/* FIXME:    offset to title button assumed at fontheight+8 but should be
	 *           widget vertical ascent, queried from the gtkcontainer child 
	 *           (how do you do that?)
	 *
	 *           use gtk_tree_view_widget_to_tree_coords () ?
	 *           no good.
	 *           */
  	PangoRectangle logical_rect;
  	PangoLayout *layout = gtk_widget_create_pango_layout((GtkWidget *)treeview,"W");
  	pango_layout_get_pixel_extents(layout, NULL, &logical_rect);
  	title_offset= PANGO_ASCENT(logical_rect) + PANGO_DESCENT(logical_rect);
  	g_object_unref(layout);
	title_offset +=8;
    }
    else title_offset=0;
    

    if(!gtk_tree_view_get_path_at_pos(treeview, x, (tree_details->preferences & SHOW_TITLES) ? y - title_offset : y, &treepath, NULL, NULL, NULL))
    {
      nodrop:
	    
	gtk_tree_view_set_drag_dest_row (treeview,NULL,GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);

	if (treepath) gtk_tree_path_free(treepath);
#if 0
	print_status("xfce/error",
#ifdef ENOTSUP
			    strerror(ENOTSUP),
#else 
#ifdef EOPNOTSUPP
			    strerror(EOPNOTSUPP),
#else
			    strerror(EINVAL),
#endif
#endif
			    ": ",_("Drop"), NULL);
#endif
	return FALSE;
    }

    /* scroll? */
    {
     GdkRectangle rect;
     gtk_tree_view_widget_to_tree_coords (treeview,x,y,&(scrolltree_v.scrollheight),&(scrolltree_v.scrolly));
     scrolltree_v.treeview=treeview;
     gtk_tree_view_get_cell_area  (treeview, treepath, NULL,&rect);
     scrolltree_v.scrollheight=rect.height;
    }
 
    
    if(*reference)
	gtk_tree_row_reference_free(*reference);
    *reference = gtk_tree_row_reference_new(treemodel, treepath);
    gtk_tree_model_get_iter(treemodel, &iter, treepath);

    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, en, -1);

    if(!en) goto nodrop;

    if(IS_BOOKMARK_TYPE((*en)->type) && IS_ROOT_TYPE((*en)->type))
	    goto drop_ok;	
    
    if(IS_DIR((*en)->type)||
       IS_NETDIR((*en)->subtype) ||
       IS_XF_NETSHARE((*en)->subtype)
      ) goto drop_ok;
    
    if(IS_XF_RPM_CHILD((*en)->type) || 
       IS_XF_TAR_CHILD((*en)->type) ||
       IS_TRASH_TYPE((*en)->type)
      )	goto nodrop;
   
     
    if(IS_FIND_TYPE((*en)->type) &&
       (IS_ROOT_TYPE((*en)->type)||IS_XF_FND((*en)->type))
      )  goto nodrop;
	
    /* check for parent status */	
    {
	GtkTreeIter parent;
	if(!gtk_tree_model_iter_parent(treemodel, &parent, &iter))
	    goto nodrop;
	gtk_tree_model_get(treemodel, &parent, ENTRY_COLUMN, en, -1);
	if(!(*en)) goto nodrop;
	if(IS_BOOKMARK_TYPE((*en)->type) && IS_ROOT_TYPE((*en)->type))
	    goto drop_ok;
	if(!IS_DIR((*en)->type) && 
	   !IS_NETDIR((*en)->subtype) &&
	   !IS_XF_NETSHARE((*en)->subtype)
	  ) goto nodrop;
    }

drop_ok:
    gtk_tree_view_set_drag_dest_row (treeview,treepath,GTK_TREE_VIEW_DROP_INTO_OR_BEFORE);

    if (treepath) gtk_tree_path_free(treepath);   
#if 0 
    print_status("xfce/info", _("Drop"), ": ", xffm_filename((*en)->path), NULL);
#endif
    return TRUE;
}

G_MODULE_EXPORT
char  *CreateSMBTmpList (GList *in_list,char *target,gboolean samba_server){
    FILE *tmpfile;
    uri *u;
    char *w;
    gchar *fname=NULL;
    int nitems=0;
    struct stat s;
    GList *list;
    
    nitems=0;
    if ((fname=randomTmpName(NULL))==NULL) return NULL;
    if ((tmpfile=fopen(fname,"w"))==NULL) {
	g_free(fname);
	return NULL;
    }
    fprintf(tmpfile,"cd /;cd \"%s\";\n",target);
    for (list=in_list;list;list=list->next){
        u = list->data;
		 nitems++;
		 /*fprintf(tmpfile,"%d:%s:%s\n",u->type,u->url,target);*/ 
		 if (!strchr(u->url,'/')) {
			 fclose(tmpfile);
			 unlink (fname);
			 g_free(fname);
			 return NULL;
		 }
		 w=g_strdup(strrchr(u->url,'/')+1);
		 if (!samba_server) {
		 	/* FIXME: this should work but doesn't, it is 
			 *  a smbclient bug to watch  */
			 ascii_unreadable(w);
		 }
			 
		 if (lstat(u->url,&s)<0){
			 print_diagnostics("xfce/error",
					 strerror(errno),":\n",
					 u->url,"\n",NULL);
			 fclose(tmpfile);
			 g_free(fname);
			 unlink (fname);
			 g_free(w);
			 w=NULL;
			 return NULL;
		 } 
		 if (S_ISREG(s.st_mode)) {
  		   /*fprintf(tmpfile,"put \"%s\" \"%s\\%s\";\n",u->url,selected.dirname+1,w);*/
  		   fprintf(tmpfile,"put \"%s\" \"%s\";\n",u->url,w);
		 }
		 else if (S_ISDIR(s.st_mode)) {
	  	   fprintf(tmpfile,"mkdir \"%s\";\n",w);
	  	   fprintf(tmpfile,"cd \"%s\";\n",w);
	  	   fprintf(tmpfile,"prompt;recurse;\n");
	  	   fprintf(tmpfile,"lcd \"%s\";\n",u->url);
	  	   fprintf(tmpfile,"mput *;\n");
	  	   fprintf(tmpfile,"prompt;recurse;\n");
    		   fprintf(tmpfile,"cd /;cd \"%s\";\n",target);
		 }
		 else { /*CHR, BLK, FIFO, LNK, SOCK */
 			 print_diagnostics("xfce/error",
					  strerror(EBADF),":\n",
					 u->url,"\n",NULL);
	         }
		 fflush(NULL);
		 g_free(w);
		 w=NULL;
    }
    fprintf(tmpfile,"ls;\n");
    fclose (tmpfile);
    /*fprintf(stderr,"dbg:nitems = %d\n",nitems);*/
    if (!nitems) {
       /*fprintf(stderr,"dbg:nitems = %d\n",nitems);*/
	    g_free(fname);
	    unlink(fname);
	    return NULL;
    }
    /*fprintf(stderr,"dbg: same device=%d\n",same_device);*/
    return fname;
}




G_MODULE_EXPORT
void on_drag_data (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * data, guint info, guint time, void *client)
{
    GtkTreeView *treeview = (GtkTreeView *) widget;
    GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
    tree_entry_t *en;
    GtkTreeIter iter;
    int nitems, action;
    uri *u;
    int mode = 0;
    GList *tmp, *list = NULL;
    gchar *tmpfile = NULL;
    Atom atomo;
    gboolean will_expand=FALSE;

    TRACE("DBG: on drag data\n"); 


    if(!set_load_wait())
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    if(!widget || data->length < 0 || data->format != 8)
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }

    if(src_host){
	g_free(src_host);
	src_host=NULL;
    }
    atomo = XInternAtom(GDK_DISPLAY(), "WM_CLIENT_MACHINE", FALSE);
    {
	unsigned char *property_data;
	unsigned long items, remaining;
	int actual_format;
	Atom actual_atom;
	if(XGetWindowProperty(GDK_DISPLAY(), GDK_WINDOW_XID(context->source_window), atomo, 0, 255, FALSE, XA_STRING, &actual_atom, &actual_format, &items, &remaining, &property_data) == Success)
	{
	    src_host = g_strdup(property_data);
	    XFree(property_data);
	    TRACE("dbg: drop from host=%s\n",src_host); 
	}
	else
	{
	    src_host = g_strdup(our_host_name(treeview));
	    TRACE("dbg: failed property get\n"); 
	}

    }



    /*printf("dbg:on_drag_data\n"); */

    action = (context->action <= GDK_ACTION_DEFAULT) ? ((tree_details->preferences & DRAG_DO_COPY) ? GDK_ACTION_COPY : GDK_ACTION_MOVE) : context->action;


    if(!valid_drop_site(treeview, x, y, &en, &target_ref) || !en)
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    if(!gtk_tree_row_reference_valid(target_ref)){
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }
    {
      GtkTreePath *treepath;
      treepath=gtk_tree_row_reference_get_path(target_ref);
      gtk_tree_model_get_iter (treemodel,&iter,treepath);
      gtk_tree_path_free(treepath);
    }
    
    if(!(info == TARGET_STRING) && !(info == TARGET_URI_LIST))
    {
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }


    if(action == GDK_ACTION_MOVE)
	the_mode = mode = TR_MOVE;
    else if(action == GDK_ACTION_COPY)
	the_mode = mode = TR_COPY;
    else if(action == GDK_ACTION_LINK)
	the_mode = mode = TR_LINK;
    else
    {
	print_status("xfce/error",strerror(EINVAL), NULL);
	gtk_drag_finish(context, FALSE, FALSE, time);
	return;
    }

    if (IS_EXPANDED(en->type)) will_expand=TRUE;


    cursor_wait();
    nitems = uri_parse_list((const char *)data->data, &list);
    TRACE("DBG:drag data=%s\n",(const char *) data->data); 
    TRACE ("dbg:nitems=%d\n",nitems); 
    if(!nitems){
	gtk_drag_finish(context, FALSE, FALSE, time);
	goto drag_over;		/* of course */
    }
    u = list->data;
    
    if(u->type == URI_SMB)
    {	/* src_host may be remote or local, but target only local
	  or bookmark */		
      if (IS_DIR(en->type)) {    
#ifdef USE_SMB_BRANCH
	XF_SMBGetFile(treeview, en->path, list);
#endif
      } 
      if (!(IS_BOOKMARK_TYPE(en->type) && IS_ROOT_TYPE(en->type))){
        list = uri_free_list(list);
	gtk_drag_finish(context, FALSE, FALSE, time);
        goto drag_over;
      }
    }
    else
	uri_remove_file_prefix_from_list(list);

    if(IS_BOOKMARK_TYPE(en->type) && (IS_ROOT_TYPE(en->type)))
    {
	for(tmp = list; tmp != NULL; tmp = tmp->next)
	{
	    u = tmp->data;
	    BOOK_add2bookmarks(treeview, u->url);
	    TRACE("DBG: adding %s to bookmarks\n",u->url);
	}
	list = uri_free_list(list);
	gtk_drag_finish(context, FALSE, FALSE, time);
	goto drag_over;
    }

    if(IS_NETDIR(en->subtype) || 
	 IS_XF_NETSHARE(en->subtype)|| 
	 IS_NETFILE(en->subtype) 
      ){
      gchar *target;
        
      if (IS_XF_NETSHARE(en->subtype)){
        target=g_strdup("/"); 	    
      } else {
	char *p;
	p=strstr(en->path+2,"/")+1;
	target=g_strdup(strstr(p,"/"));
        if (IS_NETFILE(en->subtype)) *strrchr(target,'/')=0;
      } 
     TRACE("DBG:target=%s\n",target);
      
      tmpfile=CreateSMBTmpList(list,target,
		      IS_SAMBA_SERVER(en->subtype));
      g_free(target);
      target=NULL;
      if (!tmpfile) {
         TRACE("dbg:null tmpfile\n");
         /*fprintf(stderr,"dbg:null tmpfile\n");*/
         list=uri_free_list (list);
	 gtk_drag_finish(context, FALSE, FALSE, time);
         goto drag_over;
      }
      else TRACE("dbg:tmpfile=%s\n",tmpfile);
#ifdef USE_SMB_BRANCH
      XF_SMBDropFile (treeview,en,&iter,tmpfile);
#endif 
      list = uri_free_list(list);
      gtk_drag_finish(context, TRUE, FALSE, time);
      goto drag_over;
    }



    if(strcmp(src_host, our_host_name(treeview)) != 0)
    {
	int l = 0;
	char **srcs = NULL;

	l=g_list_length(list);
	srcs = (char **)malloc((l+1) * sizeof(char *));
	if(!srcs) assert_not_reached();
	srcs[l] = NULL;
	for(l = 0, tmp = list; tmp != NULL; tmp = tmp->next)
	{
	    u = tmp->data;
	    srcs[l] = u->url;
	    srcs[l + 1] = NULL;
	    l++;
	}
	rsync(srcs, en->path);
	g_free(srcs);
	srcs=NULL;

	list = uri_free_list(list);
    	gtk_drag_finish(context, TRUE, FALSE, time);
	goto drag_over;
    }

    /* above: u = list->data; */
 

    {
	/* nonsense check */
	struct stat st;
	lstat(u->url, &st);
	if(st.st_ino == en->st->st_ino)
	{
	    list = uri_free_list(list);
	    print_status("xfce/error", strerror(EEXIST), NULL);
	    /*fprintf(stderr,"dbg:nonsense 1\n"); */
    	    gtk_drag_finish(context, FALSE, FALSE, time);
	    goto drag_over;
	}
	if(!S_ISDIR(st.st_mode) && strchr(u->url, '/'))
	{
	    char *p;
	    p = g_strdup(u->url);
	    *(strrchr(p, '/')) = 0;
	    if(strcmp(p, en->path) == 0)
	    {
		list = uri_free_list(list);
		g_free(p);
		p=NULL;
		print_status("xfce/error", strerror(EEXIST), NULL);
		/*fprintf(stderr,"dbg:nonsense 2\n"); */
    	        gtk_drag_finish(context, FALSE, FALSE, time);
		goto drag_over;
	    }
	    g_free(p);
	    p=NULL;
	}
    }

    /* tmpfile ==NULL means drop cancelled */


    tmpfile = CreateTmpList(list, en);

    if(!tmpfile)
    {
	char *what;
	if(mode == TR_MOVE) what = _("Nothing moved");
	else if(mode == TR_COPY) what = _("Nothing copied");
	else what = _("Nothing linked");
	TRACE("DBG:null tmpfile\n"); 
	print_status("xfce/info", what, NULL);
	list = uri_free_list(list);
    	gtk_drag_finish(context, FALSE, FALSE, time);
	goto drag_over;
    }
     else TRACE("dbg:dnd, tmpfile=%s\n",tmpfile); 
    /* acording to tmpfile name, do a direct move, here, and break.- */

    IndirectTransfer(mode, tmpfile);

    if(tmpfile) unlink(tmpfile);
    g_free(tmpfile);
    
    list = uri_free_list(list);


    TRACE("dbg:parent:runOver\n"); 

    gtk_drag_finish(context, TRUE, (the_mode & TR_MOVE) ? TRUE : FALSE, time);

  drag_over:
    /*update_dir(treeview, target_ref);*/
    /*tar_extraction=FALSE;*/
    unset_load_wait();
    if (will_expand && (IS_NETDIR(en->subtype) || 
			IS_XF_NETSHARE(en->subtype)||  
			IS_NETFILE(en->subtype)) )
    {
	GtkTreePath *treepath=gtk_tree_row_reference_get_path(target_ref);
    	gtk_tree_view_expand_row(treeview, treepath, FALSE);  
    	gtk_tree_path_free(treepath);
    }


    /*if (!IS_BOOKMARK_TYPE(en->type)) */
    local_monitor(TRUE);
    cursor_reset();
    TRACE("dbg:and done... \n"); 
}

G_MODULE_EXPORT
gboolean is_in_dnd_selection (GtkTreePath * path){
	GList *tmp;
	if (!path) return TRUE;
	for (tmp=selection_list;tmp;tmp=tmp->next){
		selection_list_t *sl=tmp->data;
           	GtkTreePath *treepath = gtk_tree_row_reference_get_path(sl->reference);
		if (!treepath) continue;
		if(gtk_tree_path_compare (path,treepath)==0){
	           gtk_tree_path_free(treepath);
		   return TRUE;
		}
	        gtk_tree_path_free(treepath);
	}
	return FALSE;
}

G_MODULE_EXPORT
void get_dnd_selection (GtkTreeModel * treemodel, GtkTreePath * path, GtkTreeIter * iter, gpointer data)
{
    tree_entry_t *en;

    /*if (drag_type==DRAG_TYPE_INCONSISTENT) return;*/

    gtk_tree_model_get(treemodel, iter, ENTRY_COLUMN, &en, -1);
    if(!IS_PATH(en->type) && !IS_NETTHING(en->subtype) ) return;
    
    if (!IS_LOCAL_TYPE(en->type) && IS_ROOT_TYPE(en->type)) return;
    
    if(IS_PATH(en->type)) drag_type=DRAG_TYPE_LOCAL;
    if(IS_NETTHING(en->subtype)) drag_type=DRAG_TYPE_NET;
    

    if (en && en->path) {
	selection_list_t *sl;
	GList *tmp;
	for (tmp=selection_list;tmp;tmp=tmp->next){
	    sl = (selection_list_t *)tmp->data;
	    if (strcmp(sl->en->path,en->path)==0) return;
	}
	sl = (selection_list_t *) malloc(sizeof(selection_list_t));
	if(!sl) assert_not_reached();
	sl->en = en;
	sl->reference = gtk_tree_row_reference_new(treemodel, path);
	selection_list = g_list_append(selection_list, sl);
	
	
	TRACE("DBG:get_dnd_selection() added to selection list=%s\n",en->path);
    } 
    if (tree_details->preferences & ENABLE_GTK_CLICK) update_multistatus_line(en);
    
    
    return;
}

#ifdef DEBUG
G_MODULE_EXPORT
void the_sl (void)
    {
	selection_list_t *sl;
	GList *tmp;
	printf("****************************\n");
	for (tmp=selection_list;tmp;tmp=tmp->next) {
	    sl = (selection_list_t *)tmp->data;
	    printf("-> %s\n",sl->en->path);
	}
    }
#endif 


/*
 * DND sender: prepare data for the remote
 * event: drag_data_get
 */
G_MODULE_EXPORT
void on_drag_data_get (GtkWidget * widget, GdkDragContext * context, GtkSelectionData * selection_data, guint info, guint time, gpointer data)
{
    char *files;
    GList *tmp;
    
    TRACE("on_drag_data_get");
    
    if(!widget)	{
	TRACE("!widget");
	return;
    }
    
    if(!selection_list) {
	TRACE("!selection_list");
	return;
    }
   
    if(!(drag_type&(DRAG_TYPE_LOCAL|DRAG_TYPE_NET))){
	TRACE("!drag_type");
	return;
    }



    /* prepare data for the receiver */
    switch (info)
    {
	case TARGET_ROOTWIN:	/* not implemented (yet) */
	 return;

	case	TARGET_RAW:
	    TRACE("TARGET_RAW");
	case	TARGET_UTF8:
	    TRACE("TARGET_UTF8");
	case	TARGET_URI_LIST:
	    TRACE("TARGET_URI_LIST");
	 
	default:
	 if(dnd_data){
		 g_free(dnd_data);
		 dnd_data=NULL;
	 }
	 switch (drag_type){
	  default:
		  assert_not_reached();
	  case DRAG_TYPE_LOCAL:	    
	    TRACE("dragtype is local");
	    selection_len = 0;
	    for (tmp = selection_list;tmp;tmp = tmp->next) {
	        selection_list_t *sl;
	        sl = (selection_list_t *) tmp->data;
		if (!gtk_tree_row_reference_valid(sl->reference)) return;
	        selection_len += (strlen(sl->en->path) + 8);
	    }
	    dnd_data = files = g_malloc(selection_len + 1);
	    dnd_data[0] = '\0';
	    for (tmp = selection_list;tmp;tmp = tmp->next)
	    {
		selection_list_t *sl;
		sl = (selection_list_t *) tmp->data;
		if (!gtk_tree_row_reference_valid(sl->reference)) return;
		sprintf(files, "file:%s\r\n", sl->en->path);
		files += (strlen(sl->en->path) + strlen("file:") + 2);
	    }
	    
	    break;
	  case DRAG_TYPE_NET: 
	    selection_len = 0;
	    for (tmp = selection_list;tmp;tmp = tmp->next) {
	        int addlen;
		selection_list_t *sl;
		sl = (selection_list_t *) tmp->data;
		if (!gtk_tree_row_reference_valid(sl->reference)) return;
		addlen=strlen("smb://@://\r\n");
		addlen += (strlen(sl->en->path));
		addlen += ((sl->en->tag)?strlen(sl->en->tag):strlen("GUEST%%"));
		selection_len += addlen;
	    }
	    
    	    dnd_data = files = g_malloc (selection_len + 1);
    	    if (!files) assert_not_reached();
    	    files[0]=0;

	    for (tmp = selection_list;tmp;tmp = tmp->next) {
		selection_list_t *sl;
		char *server,*remote_file;
		sl = (selection_list_t *) tmp->data;
		if (!gtk_tree_row_reference_valid(sl->reference)) return;
		server=g_strdup(sl->en->path+2);
		strtok(server,"/");
		if (IS_XF_NETWS(sl->en->subtype)) {
		  	sprintf (files, "%s://%s@%s:\r\n",
			  IS_SAMBA_SERVER(sl->en->subtype)?"SMB":"smb",
			  (sl->en->tag)?sl->en->tag:"GUEST%%",
			  server);
		} else {
		  	remote_file=server+strlen(server)+1;
		  	sprintf (files, "%s://%s@%s:%s%s",
			  IS_SAMBA_SERVER(sl->en->subtype)?"SMB":"smb",
			  (sl->en->tag)?sl->en->tag:"GUEST%%",
			  server,remote_file,
			  (IS_NETDIR(sl->en->subtype))?"/\r\n":"\r\n");
		}
		g_free(server);
		server=NULL;
	        files = files + strlen(files);
	    }
	    break;
	 }
	 break;
    }
    /*printf("gdkatom=%lu(%s)\n",
       selection_data->target,
       gdk_atom_name(selection_data->target)); */

    gtk_selection_data_set(selection_data, selection_data->target, 
		    8, (const guchar *)dnd_data, selection_len); 
    dragging=FALSE;
    tree_details->comm |= COMM_IGNORE_RELEASE;
    TRACE("DBG drag get done\n");    
    TRACE("dnd ignore second releas=%d... \n",tree_details->comm & COMM_IGNORE_RELEASE); 
}

G_MODULE_EXPORT
gboolean on_drag_motion (GtkWidget * widget, GdkDragContext * dc, gint x, gint y, guint t, gpointer data)
{
    GtkTreeView *treeview = (GtkTreeView *) widget;
    tree_entry_t *en;
    GdkDragAction action;

    /*printf("DBG:  on_drag_motion \n"); */



    /* Insert code to get our default action here. */
    if(tree_details->preferences & DRAG_DO_COPY)
	action = GDK_ACTION_COPY;
    else
	action = GDK_ACTION_MOVE;


    if (!scrolltimer){ 
		scrolltimer = g_timeout_add_full(0, 150, (GtkFunction) scrolltree, (gpointer) treeview, NULL);
		/*printf("DBG: scrolltimer=%d\n",scrolltimer);*/
    }

    if(!valid_drop_site(treeview, x, y, &en, &target_ref) || !en)
    {				/*change icon */
	gdk_drag_status(dc, 0, t);
    }
    else if(dc->actions == GDK_ACTION_MOVE)
	gdk_drag_status(dc, GDK_ACTION_MOVE, t);
    else if(dc->actions == GDK_ACTION_COPY)
	gdk_drag_status(dc, GDK_ACTION_COPY, t);
    else if(dc->actions == GDK_ACTION_LINK)
	gdk_drag_status(dc, GDK_ACTION_LINK, t);
    else if(dc->actions & action)
	gdk_drag_status(dc, action, t);
    else
	gdk_drag_status(dc, 0, t);
    /*fprintf(stderr,"dbg: drag motion done...\n"); */



    return (TRUE);
}

#if 0
void on_drag_data_delete(GtkWidget * widget, GdkDragContext * context, gpointer data)
{
    printf("DBG: on_drag_data_delete!\n\n");


    return;
}
#endif

G_MODULE_EXPORT
void on_drag_end (GtkWidget * widget, GdkDragContext * context, gpointer data)
{
    /*GList *tmp;
    GtkTreeView *treeview = (GtkTreeView *) widget;*/
    TRACE("DBG drag end\n");
    dragging = FALSE;
    /*if (scrolltimer)g_source_remove(scrolltimer);
    scrolltimer=0,scrollx=-1, scrolly=-1;*/
    if(!widget)	return;

    if(dnd_data)
    {
	g_free(dnd_data);
	dnd_data = NULL;
    }

    if(!set_load_wait())
    {
	TRACE("DBG: cannot set tree_details->loading! (on_drag_end())\n");
	return;
    }
    

    
    unset_load_wait();
    TRACE("DBG drag end done\n");
    return;
}

G_MODULE_EXPORT
void  on_drag_leave (GtkWidget *widget, GdkDragContext *drag_context, guint time, gpointer user_data){
	TRACE("on_drag_leave*************\n");
   
   if (scrolltimer)g_source_remove(scrolltimer);
   scrolltimer=0;
   /*print_status(NULL," ",NULL);*/
}

/*XXX: implies loading of library... */
G_MODULE_EXPORT
void setup_drag_signal (GtkTreeView * treeview)
{
/*	GtkTargetEntry 	target_table[] =
	{
		{"text/uri-list", 0, TARGET_URI_LIST},
		{"text/x-moz-url", 0, TARGET_MOZ_URL},
		{"XdndDirectSave0", 0, TARGET_XDS},
		{"application/octet-stream", 0, TARGET_RAW},
	};*/
   
    g_signal_connect(G_OBJECT(treeview), "drag_data_received", G_CALLBACK(on_drag_data), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_data_get", G_CALLBACK(on_drag_data_get), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_motion", G_CALLBACK(on_drag_motion), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_end", G_CALLBACK(on_drag_end), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag_begin", G_CALLBACK(on_drag_begin), NULL);
    g_signal_connect(G_OBJECT(treeview), "drag-leave", G_CALLBACK(on_drag_leave), NULL);
#if 0
    this signal looks bugged in gtk.only works well forsame widget.segv otherwise g_signal_connect(G_OBJECT(treeview), "drag_data_delete", G_CALLBACK(on_drag_data_delete), NULL);
#endif

    /*
     * DO NOT put gtk_drag_source_set here. It is very buggy if you do.
     * Instead set at first mouse click and unset on expand+contract
     * (inherent GtkCTree bug workaround) [This is a gtk1.2 note,
     * this may or may not apply in gtk2.]
     * gtk_drag_source_set (ctree, GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, 
     target_table, NUM_TARGETS, 
     GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);*/
    drag_source_set(treeview);	/*this location might need change */

    /*  this kind of dnd is useful to rearrange the order of the root nodes: */
    /*
       gtk_tree_view_enable_model_drag_source(treeview, 
       GTK_DEST_DEFAULT_DROP|GTK_DEST_DEFAULT_HIGHLIGHT, 
       target_table, 
       NUM_TARGETS, 
       GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK
       ); */


    gtk_drag_dest_set((GtkWidget *) treeview, GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_HIGHLIGHT, target_table, sizeof(target_table) / sizeof(*target_table), GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);

}


G_MODULE_EXPORT
void drag_source_set (GtkTreeView * treeview)
{
    TRACE("DBG drag_source_set\n");
	gtk_drag_source_set((GtkWidget *) treeview, GDK_BUTTON1_MASK | GDK_BUTTON2_MASK, target_table, NUM_TARGETS, GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_LINK);
}

G_MODULE_EXPORT
void drag_source_unset (GtkTreeView * treeview)
{
    TRACE("DBG drag_source_unset\n");
   gtk_drag_source_unset((GtkWidget *) treeview);
}
