#ifndef H_CDW_ERASE_DISC
#define H_CDW_ERASE_DISC

#include "main.h"

enum {
	CDW_ERASE_MODE_FAST = 0,
	CDW_ERASE_MODE_ALL
};

enum {
	CDW_ERASE_DVD_RW_FORMAT_NONE = 0,
	CDW_ERASE_DVD_RW_FORMAT_SEQ,
	CDW_ERASE_DVD_RW_FORMAT_RES
};


typedef struct {
	/* "input" parameters of erasing */
	cdw_id_t erase_mode;  /* Erasing disc: all or fast. */
	cdw_id_t speed_id;
	bool eject;
	cdw_id_t dvd_rw_format_mode; /* Format of DVD-RW: Sequential or Restricted Overwrite. */

	cdw_id_label_t tool;

	/* "output" parameter of erasing (but only for CD-RW): if
	   after attempting to perform erasing of CD-RW value of
	   erase_time is still zero, then erasing failed */
	size_t erase_time;
} cdw_erase_t;

cdw_rv_t cdw_erase_disc(void);


void cdw_erase_init(cdw_erase_t *erase);
void cdw_erase_copy(cdw_erase_t *dest, cdw_erase_t *src);
void cdw_erase_set_defaults(cdw_erase_t *erase);
void cdw_erase_debug_print_options(cdw_erase_t *erase);

#endif /* H_CDW_ERASE_DISC */
