#include "httpbuffer"

static string methods[] = {
    "HEAD", "GET", "POST", "PUT", "DELETE", "TRACE", "OPTIONS", "CONNECT"
};

string Httpbuffer::url() {
    if (firstline().empty())
	return "";

    // The first line must be a method, followed by the URL, followed
    // by optional mush, as in: GET /index.html HTTP/1.1.
    // Match the method first.
    unsigned url_start = 0;
    for (unsigned i = 0; i < sizeof(methods) / sizeof(string) ; i++)
	if (firstline().substr(0, methods[i].size()) == methods[i]) {
	    url_start = methods[i].size();
	    break;
	}
    if (!url_start)
	return "";
    while (firstline()[url_start] == ' ' && url_start < firstline().size())
	url_start++;

    string ret;
    for (unsigned i = url_start;
	 firstline()[i] != ' ' && i < firstline().size();
	 i++)
	ret += firstline()[i];

    debugmsg("URL of request: " + ret + "\n");
    return ret;
}
