/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_misc2.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:11p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:37 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_misc2.h $
 * 
 * Hydra_Software_Devel/1   7/17/09 8:11p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_MISC2_H__
#define BCHP_MISC2_H__

/***************************************************************************
 *MISC2 - Registers for Meta DMA, Direct DRAM Access, Global Controls
 ***************************************************************************/
#define BCHP_MISC2_GLOBAL_CTRL                   0x00502100 /* Global Control Register */
#define BCHP_MISC2_INTERNAL_STATUS               0x00502104 /* Internal Status Register */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL      0x00502108 /* Internal Debug Mux Control */
#define BCHP_MISC2_DEBUG_FIFO_LENGTH             0x0050210c /* Debug FIFO Length */
#define BCHP_MISC2_WRITE_BLOCKOUT_COUNT          0x00502110 /* Write Blockout Count */
#define BCHP_MISC2_META_DATA_BASE_ADDR           0x00502114 /* Meta Data Base DRAM Address */
#define BCHP_MISC2_META_DATA_LENGTH              0x00502118 /* Meta Data Length */
#define BCHP_MISC2_DIRECT_WINDOW_STATUS          0x0050211c /* Direct DRAM Access Window Status */
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL         0x00502120 /* Direct DRAM Access Window Control */

/***************************************************************************
 *GLOBAL_CTRL - Global Control Register
 ***************************************************************************/
/* MISC2 :: GLOBAL_CTRL :: reserved0 [31:07] */
#define BCHP_MISC2_GLOBAL_CTRL_reserved0_MASK                      0xffffff80
#define BCHP_MISC2_GLOBAL_CTRL_reserved0_SHIFT                     7

/* MISC2 :: GLOBAL_CTRL :: BURST_64_BYTES [06:06] */
#define BCHP_MISC2_GLOBAL_CTRL_BURST_64_BYTES_MASK                 0x00000040
#define BCHP_MISC2_GLOBAL_CTRL_BURST_64_BYTES_SHIFT                6

/* MISC2 :: GLOBAL_CTRL :: BOP_DRAIN [05:05] */
#define BCHP_MISC2_GLOBAL_CTRL_BOP_DRAIN_MASK                      0x00000020
#define BCHP_MISC2_GLOBAL_CTRL_BOP_DRAIN_SHIFT                     5

/* MISC2 :: GLOBAL_CTRL :: META_DMA_ENABLE [04:04] */
#define BCHP_MISC2_GLOBAL_CTRL_META_DMA_ENABLE_MASK                0x00000010
#define BCHP_MISC2_GLOBAL_CTRL_META_DMA_ENABLE_SHIFT               4

/* MISC2 :: GLOBAL_CTRL :: BVN_CHECKSUM_10BITS [03:03] */
#define BCHP_MISC2_GLOBAL_CTRL_BVN_CHECKSUM_10BITS_MASK            0x00000008
#define BCHP_MISC2_GLOBAL_CTRL_BVN_CHECKSUM_10BITS_SHIFT           3

/* MISC2 :: GLOBAL_CTRL :: BVN_10B_TO_8B [02:02] */
#define BCHP_MISC2_GLOBAL_CTRL_BVN_10B_TO_8B_MASK                  0x00000004
#define BCHP_MISC2_GLOBAL_CTRL_BVN_10B_TO_8B_SHIFT                 2

/* MISC2 :: GLOBAL_CTRL :: BVN_YUY2_MODE [01:01] */
#define BCHP_MISC2_GLOBAL_CTRL_BVN_YUY2_MODE_MASK                  0x00000002
#define BCHP_MISC2_GLOBAL_CTRL_BVN_YUY2_MODE_SHIFT                 1

/* MISC2 :: GLOBAL_CTRL :: BVN_420_MODE [00:00] */
#define BCHP_MISC2_GLOBAL_CTRL_BVN_420_MODE_MASK                   0x00000001
#define BCHP_MISC2_GLOBAL_CTRL_BVN_420_MODE_SHIFT                  0

/***************************************************************************
 *INTERNAL_STATUS - Internal Status Register
 ***************************************************************************/
/* MISC2 :: INTERNAL_STATUS :: META_DATA_ACTIVE [31:31] */
#define BCHP_MISC2_INTERNAL_STATUS_META_DATA_ACTIVE_MASK           0x80000000
#define BCHP_MISC2_INTERNAL_STATUS_META_DATA_ACTIVE_SHIFT          31

/* MISC2 :: INTERNAL_STATUS :: reserved0 [30:10] */
#define BCHP_MISC2_INTERNAL_STATUS_reserved0_MASK                  0x7ffffc00
#define BCHP_MISC2_INTERNAL_STATUS_reserved0_SHIFT                 10

/* MISC2 :: INTERNAL_STATUS :: BVN_BYTE_COUNT_FIFO_FULL [09:09] */
#define BCHP_MISC2_INTERNAL_STATUS_BVN_BYTE_COUNT_FIFO_FULL_MASK   0x00000200
#define BCHP_MISC2_INTERNAL_STATUS_BVN_BYTE_COUNT_FIFO_FULL_SHIFT  9

/* MISC2 :: INTERNAL_STATUS :: BVN_DATA_FIFO_FULL [08:08] */
#define BCHP_MISC2_INTERNAL_STATUS_BVN_DATA_FIFO_FULL_MASK         0x00000100
#define BCHP_MISC2_INTERNAL_STATUS_BVN_DATA_FIFO_FULL_SHIFT        8

/* MISC2 :: INTERNAL_STATUS :: reserved1 [07:06] */
#define BCHP_MISC2_INTERNAL_STATUS_reserved1_MASK                  0x000000c0
#define BCHP_MISC2_INTERNAL_STATUS_reserved1_SHIFT                 6

/* MISC2 :: INTERNAL_STATUS :: BVN_BYTE_COUNT_FIFO_EMPTY [05:05] */
#define BCHP_MISC2_INTERNAL_STATUS_BVN_BYTE_COUNT_FIFO_EMPTY_MASK  0x00000020
#define BCHP_MISC2_INTERNAL_STATUS_BVN_BYTE_COUNT_FIFO_EMPTY_SHIFT 5

/* MISC2 :: INTERNAL_STATUS :: BVN_DATA_FIFO_EMPTY [04:04] */
#define BCHP_MISC2_INTERNAL_STATUS_BVN_DATA_FIFO_EMPTY_MASK        0x00000010
#define BCHP_MISC2_INTERNAL_STATUS_BVN_DATA_FIFO_EMPTY_SHIFT       4

/* MISC2 :: INTERNAL_STATUS :: reserved2 [03:00] */
#define BCHP_MISC2_INTERNAL_STATUS_reserved2_MASK                  0x0000000f
#define BCHP_MISC2_INTERNAL_STATUS_reserved2_SHIFT                 0

/***************************************************************************
 *INTERNAL_STATUS_MUX_CTRL - Internal Debug Mux Control
 ***************************************************************************/
/* MISC2 :: INTERNAL_STATUS_MUX_CTRL :: reserved0 [31:16] */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_reserved0_MASK         0xffff0000
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_reserved0_SHIFT        16

/* MISC2 :: INTERNAL_STATUS_MUX_CTRL :: CLK_OUT_ALT_SRC [15:15] */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_CLK_OUT_ALT_SRC_MASK   0x00008000
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_CLK_OUT_ALT_SRC_SHIFT  15

/* MISC2 :: INTERNAL_STATUS_MUX_CTRL :: DEBUG_CLK_SEL [14:12] */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_CLK_SEL_MASK     0x00007000
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_CLK_SEL_SHIFT    12

/* MISC2 :: INTERNAL_STATUS_MUX_CTRL :: reserved1 [11:09] */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_reserved1_MASK         0x00000e00
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_reserved1_SHIFT        9

/* MISC2 :: INTERNAL_STATUS_MUX_CTRL :: DEBUG_TOP_CORE_SEL [08:08] */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_TOP_CORE_SEL_MASK 0x00000100
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_TOP_CORE_SEL_SHIFT 8

/* MISC2 :: INTERNAL_STATUS_MUX_CTRL :: DEBUG_CORE_BLK_SEL [07:04] */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_CORE_BLK_SEL_MASK 0x000000f0
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_CORE_BLK_SEL_SHIFT 4

/* MISC2 :: INTERNAL_STATUS_MUX_CTRL :: DEBUG_VECTOR_SEL [03:00] */
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_VECTOR_SEL_MASK  0x0000000f
#define BCHP_MISC2_INTERNAL_STATUS_MUX_CTRL_DEBUG_VECTOR_SEL_SHIFT 0

/***************************************************************************
 *DEBUG_FIFO_LENGTH - Debug FIFO Length
 ***************************************************************************/
/* MISC2 :: DEBUG_FIFO_LENGTH :: reserved0 [31:21] */
#define BCHP_MISC2_DEBUG_FIFO_LENGTH_reserved0_MASK                0xffe00000
#define BCHP_MISC2_DEBUG_FIFO_LENGTH_reserved0_SHIFT               21

/* MISC2 :: DEBUG_FIFO_LENGTH :: FIFO_LENGTH [20:00] */
#define BCHP_MISC2_DEBUG_FIFO_LENGTH_FIFO_LENGTH_MASK              0x001fffff
#define BCHP_MISC2_DEBUG_FIFO_LENGTH_FIFO_LENGTH_SHIFT             0

/***************************************************************************
 *WRITE_BLOCKOUT_COUNT - Write Blockout Count
 ***************************************************************************/
/* MISC2 :: WRITE_BLOCKOUT_COUNT :: reserved0 [31:16] */
#define BCHP_MISC2_WRITE_BLOCKOUT_COUNT_reserved0_MASK             0xffff0000
#define BCHP_MISC2_WRITE_BLOCKOUT_COUNT_reserved0_SHIFT            16

/* MISC2 :: WRITE_BLOCKOUT_COUNT :: BLOCKOUT_COUNT [15:00] */
#define BCHP_MISC2_WRITE_BLOCKOUT_COUNT_BLOCKOUT_COUNT_MASK        0x0000ffff
#define BCHP_MISC2_WRITE_BLOCKOUT_COUNT_BLOCKOUT_COUNT_SHIFT       0

/***************************************************************************
 *META_DATA_BASE_ADDR - Meta Data Base DRAM Address
 ***************************************************************************/
/* MISC2 :: META_DATA_BASE_ADDR :: META_DATA_BASE_ADDR [31:00] */
#define BCHP_MISC2_META_DATA_BASE_ADDR_META_DATA_BASE_ADDR_MASK    0xffffffff
#define BCHP_MISC2_META_DATA_BASE_ADDR_META_DATA_BASE_ADDR_SHIFT   0

/***************************************************************************
 *META_DATA_LENGTH - Meta Data Length
 ***************************************************************************/
/* MISC2 :: META_DATA_LENGTH :: reserved0 [31:24] */
#define BCHP_MISC2_META_DATA_LENGTH_reserved0_MASK                 0xff000000
#define BCHP_MISC2_META_DATA_LENGTH_reserved0_SHIFT                24

/* MISC2 :: META_DATA_LENGTH :: META_DATA_LENGTH [23:00] */
#define BCHP_MISC2_META_DATA_LENGTH_META_DATA_LENGTH_MASK          0x00ffffff
#define BCHP_MISC2_META_DATA_LENGTH_META_DATA_LENGTH_SHIFT         0

/***************************************************************************
 *DIRECT_WINDOW_STATUS - Direct DRAM Access Window Status
 ***************************************************************************/
/* MISC2 :: DIRECT_WINDOW_STATUS :: reserved0 [31:01] */
#define BCHP_MISC2_DIRECT_WINDOW_STATUS_reserved0_MASK             0xfffffffe
#define BCHP_MISC2_DIRECT_WINDOW_STATUS_reserved0_SHIFT            1

/* MISC2 :: DIRECT_WINDOW_STATUS :: DIRECT_BUSY [00:00] */
#define BCHP_MISC2_DIRECT_WINDOW_STATUS_DIRECT_BUSY_MASK           0x00000001
#define BCHP_MISC2_DIRECT_WINDOW_STATUS_DIRECT_BUSY_SHIFT          0

/***************************************************************************
 *DIRECT_WINDOW_CONTROL - Direct DRAM Access Window Control
 ***************************************************************************/
/* MISC2 :: DIRECT_WINDOW_CONTROL :: DIRECT_WINDOW_BASE_ADDR [31:16] */
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_BASE_ADDR_MASK 0xffff0000
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_BASE_ADDR_SHIFT 16

/* MISC2 :: DIRECT_WINDOW_CONTROL :: reserved0 [15:02] */
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_reserved0_MASK            0x0000fffc
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_reserved0_SHIFT           2

/* MISC2 :: DIRECT_WINDOW_CONTROL :: DIRECT_WINDOW_POST_WRITES [01:01] */
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_POST_WRITES_MASK 0x00000002
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_POST_WRITES_SHIFT 1

/* MISC2 :: DIRECT_WINDOW_CONTROL :: DIRECT_WINDOW_ENABLE [00:00] */
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_ENABLE_MASK 0x00000001
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_ENABLE_SHIFT 0

#endif /* #ifndef BCHP_MISC2_H__ */

/* End of File */
