// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package kinesisanalyticsiface provides an interface to enable mocking the Amazon Kinesis Analytics service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package kinesisanalyticsiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/kinesisanalytics"
)

// KinesisAnalyticsAPI provides an interface to enable mocking the
// kinesisanalytics.KinesisAnalytics service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Kinesis Analytics.
//    func myFunc(svc kinesisanalyticsiface.KinesisAnalyticsAPI) bool {
//        // Make svc.AddApplicationInput request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := kinesisanalytics.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockKinesisAnalyticsClient struct {
//        kinesisanalyticsiface.KinesisAnalyticsAPI
//    }
//    func (m *mockKinesisAnalyticsClient) AddApplicationInput(input *kinesisanalytics.AddApplicationInputInput) (*kinesisanalytics.AddApplicationInputOutput, error) {
//        // mock response/functionality
//    }
//
//    TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockKinesisAnalyticsClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type KinesisAnalyticsAPI interface {
	AddApplicationInputRequest(*kinesisanalytics.AddApplicationInputInput) (*request.Request, *kinesisanalytics.AddApplicationInputOutput)

	AddApplicationInput(*kinesisanalytics.AddApplicationInputInput) (*kinesisanalytics.AddApplicationInputOutput, error)

	AddApplicationOutputRequest(*kinesisanalytics.AddApplicationOutputInput) (*request.Request, *kinesisanalytics.AddApplicationOutputOutput)

	AddApplicationOutput(*kinesisanalytics.AddApplicationOutputInput) (*kinesisanalytics.AddApplicationOutputOutput, error)

	AddApplicationReferenceDataSourceRequest(*kinesisanalytics.AddApplicationReferenceDataSourceInput) (*request.Request, *kinesisanalytics.AddApplicationReferenceDataSourceOutput)

	AddApplicationReferenceDataSource(*kinesisanalytics.AddApplicationReferenceDataSourceInput) (*kinesisanalytics.AddApplicationReferenceDataSourceOutput, error)

	CreateApplicationRequest(*kinesisanalytics.CreateApplicationInput) (*request.Request, *kinesisanalytics.CreateApplicationOutput)

	CreateApplication(*kinesisanalytics.CreateApplicationInput) (*kinesisanalytics.CreateApplicationOutput, error)

	DeleteApplicationRequest(*kinesisanalytics.DeleteApplicationInput) (*request.Request, *kinesisanalytics.DeleteApplicationOutput)

	DeleteApplication(*kinesisanalytics.DeleteApplicationInput) (*kinesisanalytics.DeleteApplicationOutput, error)

	DeleteApplicationOutputRequest(*kinesisanalytics.DeleteApplicationOutputInput) (*request.Request, *kinesisanalytics.DeleteApplicationOutputOutput)

	DeleteApplicationOutput(*kinesisanalytics.DeleteApplicationOutputInput) (*kinesisanalytics.DeleteApplicationOutputOutput, error)

	DeleteApplicationReferenceDataSourceRequest(*kinesisanalytics.DeleteApplicationReferenceDataSourceInput) (*request.Request, *kinesisanalytics.DeleteApplicationReferenceDataSourceOutput)

	DeleteApplicationReferenceDataSource(*kinesisanalytics.DeleteApplicationReferenceDataSourceInput) (*kinesisanalytics.DeleteApplicationReferenceDataSourceOutput, error)

	DescribeApplicationRequest(*kinesisanalytics.DescribeApplicationInput) (*request.Request, *kinesisanalytics.DescribeApplicationOutput)

	DescribeApplication(*kinesisanalytics.DescribeApplicationInput) (*kinesisanalytics.DescribeApplicationOutput, error)

	DiscoverInputSchemaRequest(*kinesisanalytics.DiscoverInputSchemaInput) (*request.Request, *kinesisanalytics.DiscoverInputSchemaOutput)

	DiscoverInputSchema(*kinesisanalytics.DiscoverInputSchemaInput) (*kinesisanalytics.DiscoverInputSchemaOutput, error)

	ListApplicationsRequest(*kinesisanalytics.ListApplicationsInput) (*request.Request, *kinesisanalytics.ListApplicationsOutput)

	ListApplications(*kinesisanalytics.ListApplicationsInput) (*kinesisanalytics.ListApplicationsOutput, error)

	StartApplicationRequest(*kinesisanalytics.StartApplicationInput) (*request.Request, *kinesisanalytics.StartApplicationOutput)

	StartApplication(*kinesisanalytics.StartApplicationInput) (*kinesisanalytics.StartApplicationOutput, error)

	StopApplicationRequest(*kinesisanalytics.StopApplicationInput) (*request.Request, *kinesisanalytics.StopApplicationOutput)

	StopApplication(*kinesisanalytics.StopApplicationInput) (*kinesisanalytics.StopApplicationOutput, error)

	UpdateApplicationRequest(*kinesisanalytics.UpdateApplicationInput) (*request.Request, *kinesisanalytics.UpdateApplicationOutput)

	UpdateApplication(*kinesisanalytics.UpdateApplicationInput) (*kinesisanalytics.UpdateApplicationOutput, error)
}

var _ KinesisAnalyticsAPI = (*kinesisanalytics.KinesisAnalytics)(nil)
