// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/genomics/v1/readgroup.proto
// DO NOT EDIT!

package google_genomics_v1 // import "google.golang.org/genproto/googleapis/genomics/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf3 "github.com/golang/protobuf/ptypes/struct"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A read group is all the data that's processed the same way by the sequencer.
type ReadGroup struct {
	// The server-generated read group ID, unique for all read groups.
	// Note: This is different than the @RG ID field in the SAM spec. For that
	// value, see [name][google.genomics.v1.ReadGroup.name].
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// The dataset to which this read group belongs.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// The read group name. This corresponds to the @RG ID field in the SAM spec.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// A free-form text description of this read group.
	Description string `protobuf:"bytes,4,opt,name=description" json:"description,omitempty"`
	// A client-supplied sample identifier for the reads in this read group.
	SampleId string `protobuf:"bytes,5,opt,name=sample_id,json=sampleId" json:"sample_id,omitempty"`
	// The experiment used to generate this read group.
	Experiment *ReadGroup_Experiment `protobuf:"bytes,6,opt,name=experiment" json:"experiment,omitempty"`
	// The predicted insert size of this read group. The insert size is the length
	// the sequenced DNA fragment from end-to-end, not including the adapters.
	PredictedInsertSize int32 `protobuf:"varint,7,opt,name=predicted_insert_size,json=predictedInsertSize" json:"predicted_insert_size,omitempty"`
	// The programs used to generate this read group. Programs are always
	// identical for all read groups within a read group set. For this reason,
	// only the first read group in a returned set will have this field
	// populated.
	Programs []*ReadGroup_Program `protobuf:"bytes,10,rep,name=programs" json:"programs,omitempty"`
	// The reference set the reads in this read group are aligned to.
	ReferenceSetId string `protobuf:"bytes,11,opt,name=reference_set_id,json=referenceSetId" json:"reference_set_id,omitempty"`
	// A map of additional read group information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,12,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ReadGroup) Reset()                    { *m = ReadGroup{} }
func (m *ReadGroup) String() string            { return proto.CompactTextString(m) }
func (*ReadGroup) ProtoMessage()               {}
func (*ReadGroup) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

func (m *ReadGroup) GetExperiment() *ReadGroup_Experiment {
	if m != nil {
		return m.Experiment
	}
	return nil
}

func (m *ReadGroup) GetPrograms() []*ReadGroup_Program {
	if m != nil {
		return m.Programs
	}
	return nil
}

func (m *ReadGroup) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

type ReadGroup_Experiment struct {
	// A client-supplied library identifier; a library is a collection of DNA
	// fragments which have been prepared for sequencing from a sample. This
	// field is important for quality control as error or bias can be introduced
	// during sample preparation.
	LibraryId string `protobuf:"bytes,1,opt,name=library_id,json=libraryId" json:"library_id,omitempty"`
	// The platform unit used as part of this experiment, for example
	// flowcell-barcode.lane for Illumina or slide for SOLiD. Corresponds to the
	// @RG PU field in the SAM spec.
	PlatformUnit string `protobuf:"bytes,2,opt,name=platform_unit,json=platformUnit" json:"platform_unit,omitempty"`
	// The sequencing center used as part of this experiment.
	SequencingCenter string `protobuf:"bytes,3,opt,name=sequencing_center,json=sequencingCenter" json:"sequencing_center,omitempty"`
	// The instrument model used as part of this experiment. This maps to
	// sequencing technology in the SAM spec.
	InstrumentModel string `protobuf:"bytes,4,opt,name=instrument_model,json=instrumentModel" json:"instrument_model,omitempty"`
}

func (m *ReadGroup_Experiment) Reset()                    { *m = ReadGroup_Experiment{} }
func (m *ReadGroup_Experiment) String() string            { return proto.CompactTextString(m) }
func (*ReadGroup_Experiment) ProtoMessage()               {}
func (*ReadGroup_Experiment) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0, 0} }

type ReadGroup_Program struct {
	// The command line used to run this program.
	CommandLine string `protobuf:"bytes,1,opt,name=command_line,json=commandLine" json:"command_line,omitempty"`
	// The user specified locally unique ID of the program. Used along with
	// `prevProgramId` to define an ordering between programs.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// The display name of the program. This is typically the colloquial name of
	// the tool used, for example 'bwa' or 'picard'.
	Name string `protobuf:"bytes,3,opt,name=name" json:"name,omitempty"`
	// The ID of the program run before this one.
	PrevProgramId string `protobuf:"bytes,4,opt,name=prev_program_id,json=prevProgramId" json:"prev_program_id,omitempty"`
	// The version of the program run.
	Version string `protobuf:"bytes,5,opt,name=version" json:"version,omitempty"`
}

func (m *ReadGroup_Program) Reset()                    { *m = ReadGroup_Program{} }
func (m *ReadGroup_Program) String() string            { return proto.CompactTextString(m) }
func (*ReadGroup_Program) ProtoMessage()               {}
func (*ReadGroup_Program) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0, 1} }

func init() {
	proto.RegisterType((*ReadGroup)(nil), "google.genomics.v1.ReadGroup")
	proto.RegisterType((*ReadGroup_Experiment)(nil), "google.genomics.v1.ReadGroup.Experiment")
	proto.RegisterType((*ReadGroup_Program)(nil), "google.genomics.v1.ReadGroup.Program")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/genomics/v1/readgroup.proto", fileDescriptor7)
}

var fileDescriptor7 = []byte{
	// 604 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x53, 0xdd, 0x8a, 0xd3, 0x40,
	0x14, 0x26, 0xdd, 0xdf, 0x9e, 0xee, 0x4f, 0x1d, 0x51, 0x42, 0x45, 0xa8, 0x8a, 0x5a, 0x11, 0x13,
	0xb7, 0x22, 0x88, 0x5e, 0xed, 0xca, 0xa2, 0x81, 0x15, 0x96, 0x2c, 0x7a, 0x1b, 0xa6, 0x99, 0xd3,
	0x38, 0x98, 0xcc, 0xc4, 0x99, 0x49, 0xb1, 0xfb, 0x18, 0x3e, 0x85, 0xcf, 0xe2, 0x13, 0x79, 0x29,
	0x33, 0x99, 0xa6, 0x0b, 0x2e, 0x8b, 0x57, 0x9d, 0x7e, 0xdf, 0x39, 0xdf, 0xf9, 0xf9, 0x4e, 0xe0,
	0xb8, 0x90, 0xb2, 0x28, 0x31, 0x2a, 0x64, 0x49, 0x45, 0x11, 0x49, 0x55, 0xc4, 0x05, 0x8a, 0x5a,
	0x49, 0x23, 0xe3, 0x96, 0xa2, 0x35, 0xd7, 0x16, 0x93, 0x15, 0xcf, 0x75, 0xbc, 0x38, 0x8a, 0x15,
	0x52, 0x56, 0x28, 0xd9, 0xd4, 0x91, 0x0b, 0x23, 0x64, 0x25, 0xe1, 0x63, 0xa2, 0xc5, 0xd1, 0x28,
	0xf9, 0x3f, 0x59, 0x5a, 0xf3, 0x58, 0xa3, 0x5a, 0xf0, 0x1c, 0x73, 0x29, 0xe6, 0xbc, 0x88, 0xa9,
	0x10, 0xd2, 0x50, 0xc3, 0xa5, 0xd0, 0xad, 0xfc, 0xe8, 0x75, 0xc1, 0xcd, 0xd7, 0x66, 0x16, 0xe5,
	0xb2, 0x8a, 0x5b, 0xb9, 0xd8, 0x11, 0xb3, 0x66, 0x1e, 0xd7, 0x66, 0x59, 0xa3, 0x8e, 0xb5, 0x51,
	0x4d, 0x6e, 0xfc, 0x4f, 0x9b, 0xf6, 0xf0, 0xf7, 0x36, 0xf4, 0x53, 0xa4, 0xec, 0x83, 0xed, 0x94,
	0x1c, 0x40, 0x8f, 0xb3, 0x30, 0x18, 0x07, 0x93, 0x7e, 0xda, 0xe3, 0x8c, 0xdc, 0x07, 0x60, 0xd4,
	0x50, 0x8d, 0x26, 0xe3, 0x2c, 0xec, 0x39, 0xbc, 0xef, 0x91, 0x84, 0x11, 0x02, 0x9b, 0x82, 0x56,
	0x18, 0x6e, 0x38, 0xc2, 0xbd, 0xc9, 0x18, 0x06, 0x0c, 0x75, 0xae, 0x78, 0x6d, 0xbb, 0x0b, 0x37,
	0x1d, 0x75, 0x15, 0x22, 0xf7, 0xa0, 0xaf, 0x69, 0x55, 0x97, 0x68, 0x35, 0xb7, 0x1c, 0xbf, 0xdb,
	0x02, 0x09, 0x23, 0x1f, 0x01, 0xf0, 0x47, 0x8d, 0x8a, 0x57, 0x28, 0x4c, 0xb8, 0x3d, 0x0e, 0x26,
	0x83, 0xe9, 0x24, 0xfa, 0x77, 0x75, 0x51, 0xd7, 0x74, 0x74, 0xda, 0xc5, 0xa7, 0x57, 0x72, 0xc9,
	0x14, 0xee, 0xd4, 0x0a, 0x19, 0xcf, 0x0d, 0xb2, 0x8c, 0x0b, 0x8d, 0xca, 0x64, 0x9a, 0x5f, 0x62,
	0xb8, 0x33, 0x0e, 0x26, 0x5b, 0xe9, 0xed, 0x8e, 0x4c, 0x1c, 0x77, 0xc1, 0x2f, 0x91, 0x1c, 0xc3,
	0x6e, 0xad, 0x64, 0xa1, 0x68, 0xa5, 0x43, 0x18, 0x6f, 0x4c, 0x06, 0xd3, 0xc7, 0x37, 0xd7, 0x3e,
	0x6f, 0xa3, 0xd3, 0x2e, 0x8d, 0x4c, 0x60, 0xa8, 0x70, 0x8e, 0x0a, 0x45, 0x8e, 0x99, 0x5f, 0xdc,
	0xc0, 0x0d, 0x79, 0xd0, 0xe1, 0x17, 0x6e, 0x7b, 0xef, 0x60, 0x93, 0x8b, 0xb9, 0x0c, 0xf7, 0x5c,
	0xa1, 0xa7, 0x37, 0x17, 0x4a, 0xc4, 0x5c, 0x9e, 0x0a, 0xa3, 0x96, 0xa9, 0x4b, 0x1a, 0xfd, 0x0a,
	0x00, 0xd6, 0x83, 0x5b, 0xa3, 0x4a, 0x3e, 0x53, 0x54, 0x2d, 0xb3, 0xce, 0xc0, 0xbe, 0x47, 0x12,
	0x46, 0x1e, 0xc1, 0x7e, 0x5d, 0x52, 0x33, 0x97, 0xaa, 0xca, 0x1a, 0xc1, 0x8d, 0xb7, 0x72, 0x6f,
	0x05, 0x7e, 0x16, 0xdc, 0x90, 0xe7, 0x70, 0x4b, 0xe3, 0xf7, 0x06, 0x45, 0xce, 0x45, 0x91, 0xe5,
	0x28, 0x0c, 0x2a, 0x6f, 0xed, 0x70, 0x4d, 0xbc, 0x77, 0x38, 0x79, 0x06, 0x43, 0x2e, 0xec, 0x25,
	0xd9, 0xf2, 0x59, 0x25, 0x19, 0x96, 0xde, 0xeb, 0xc3, 0x35, 0xfe, 0xc9, 0xc2, 0xa3, 0x9f, 0x01,
	0xec, 0xf8, 0x3d, 0x91, 0x07, 0xb0, 0x97, 0xcb, 0xaa, 0xa2, 0x82, 0x65, 0x25, 0x17, 0xe8, 0x3b,
	0x1d, 0x78, 0xec, 0x8c, 0x0b, 0xf4, 0x37, 0xd8, 0xeb, 0x6e, 0xf0, 0xba, 0x23, 0x7b, 0x02, 0x87,
	0xb5, 0xc2, 0x45, 0xe6, 0xb7, 0x6e, 0x67, 0x6e, 0x8b, 0xef, 0x5b, 0xd8, 0x17, 0x4b, 0x18, 0x09,
	0x61, 0x67, 0x81, 0x4a, 0xdb, 0x43, 0x6c, 0x0f, 0x6d, 0xf5, 0x77, 0x74, 0x01, 0xfd, 0x6e, 0xa5,
	0x64, 0x08, 0x1b, 0xdf, 0x70, 0xe9, 0x9b, 0xb1, 0x4f, 0xf2, 0x12, 0xb6, 0x16, 0xb4, 0x6c, 0xd0,
	0xf5, 0x31, 0x98, 0x8e, 0x56, 0xe6, 0xac, 0x3e, 0xa9, 0xe8, 0x8c, 0x6b, 0xf3, 0xc5, 0x46, 0xa4,
	0x6d, 0xe0, 0xdb, 0xde, 0x9b, 0xe0, 0xe4, 0x05, 0xdc, 0xcd, 0x65, 0x75, 0x8d, 0x91, 0x27, 0x07,
	0x9d, 0x93, 0xe7, 0x56, 0xe1, 0x3c, 0xf8, 0x13, 0x04, 0xb3, 0x6d, 0xa7, 0xf6, 0xea, 0x6f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xe4, 0x3f, 0xff, 0x3d, 0x5d, 0x04, 0x00, 0x00,
}
