// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/longrunning/operations.proto
// DO NOT EDIT!

/*
Package google_longrunning is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/longrunning/operations.proto

It has these top-level messages:
	Operation
	GetOperationRequest
	ListOperationsRequest
	ListOperationsResponse
	CancelOperationRequest
	DeleteOperationRequest
*/
package google_longrunning // import "google.golang.org/genproto/googleapis/longrunning"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/any"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_rpc "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// This resource represents a long-running operation that is the result of a
// network API call.
type Operation struct {
	// The server-assigned name, which is only unique within the same service that
	// originally returns it. If you use the default HTTP mapping, the
	// `name` should have the format of `operations/some/unique/name`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Service-specific metadata associated with the operation.  It typically
	// contains progress information and common metadata such as create time.
	// Some services might not provide such metadata.  Any method that returns a
	// long-running operation should document the metadata type, if any.
	Metadata *google_protobuf1.Any `protobuf:"bytes,2,opt,name=metadata" json:"metadata,omitempty"`
	// If the value is `false`, it means the operation is still in progress.
	// If true, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `protobuf:"varint,3,opt,name=done" json:"done,omitempty"`
	// The operation result, which can be either an `error` or a valid `response`.
	// If `done` == `false`, neither `error` nor `response` is set.
	// If `done` == `true`, exactly one of `error` or `response` is set.
	//
	// Types that are valid to be assigned to Result:
	//	*Operation_Error
	//	*Operation_Response
	Result isOperation_Result `protobuf_oneof:"result"`
}

func (m *Operation) Reset()                    { *m = Operation{} }
func (m *Operation) String() string            { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()               {}
func (*Operation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type isOperation_Result interface {
	isOperation_Result()
}

type Operation_Error struct {
	Error *google_rpc.Status `protobuf:"bytes,4,opt,name=error,oneof"`
}
type Operation_Response struct {
	Response *google_protobuf1.Any `protobuf:"bytes,5,opt,name=response,oneof"`
}

func (*Operation_Error) isOperation_Result()    {}
func (*Operation_Response) isOperation_Result() {}

func (m *Operation) GetResult() isOperation_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *Operation) GetMetadata() *google_protobuf1.Any {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Operation) GetError() *google_rpc.Status {
	if x, ok := m.GetResult().(*Operation_Error); ok {
		return x.Error
	}
	return nil
}

func (m *Operation) GetResponse() *google_protobuf1.Any {
	if x, ok := m.GetResult().(*Operation_Response); ok {
		return x.Response
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Operation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Operation_OneofMarshaler, _Operation_OneofUnmarshaler, _Operation_OneofSizer, []interface{}{
		(*Operation_Error)(nil),
		(*Operation_Response)(nil),
	}
}

func _Operation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Operation)
	// result
	switch x := m.Result.(type) {
	case *Operation_Error:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Error); err != nil {
			return err
		}
	case *Operation_Response:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Response); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Operation.Result has unexpected type %T", x)
	}
	return nil
}

func _Operation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Operation)
	switch tag {
	case 4: // result.error
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_rpc.Status)
		err := b.DecodeMessage(msg)
		m.Result = &Operation_Error{msg}
		return true, err
	case 5: // result.response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Any)
		err := b.DecodeMessage(msg)
		m.Result = &Operation_Response{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Operation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Operation)
	// result
	switch x := m.Result.(type) {
	case *Operation_Error:
		s := proto.Size(x.Error)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Operation_Response:
		s := proto.Size(x.Response)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The request message for [Operations.GetOperation][google.longrunning.Operations.GetOperation].
type GetOperationRequest struct {
	// The name of the operation resource.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetOperationRequest) Reset()                    { *m = GetOperationRequest{} }
func (m *GetOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOperationRequest) ProtoMessage()               {}
func (*GetOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// The request message for [Operations.ListOperations][google.longrunning.Operations.ListOperations].
type ListOperationsRequest struct {
	// The name of the operation collection.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	// The standard list filter.
	Filter string `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	// The standard list page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The standard list page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListOperationsRequest) Reset()                    { *m = ListOperationsRequest{} }
func (m *ListOperationsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsRequest) ProtoMessage()               {}
func (*ListOperationsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// The response message for [Operations.ListOperations][google.longrunning.Operations.ListOperations].
type ListOperationsResponse struct {
	// A list of operations that matches the specified filter in the request.
	Operations []*Operation `protobuf:"bytes,1,rep,name=operations" json:"operations,omitempty"`
	// The standard List next-page token.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListOperationsResponse) Reset()                    { *m = ListOperationsResponse{} }
func (m *ListOperationsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListOperationsResponse) ProtoMessage()               {}
func (*ListOperationsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// The request message for [Operations.CancelOperation][google.longrunning.Operations.CancelOperation].
type CancelOperationRequest struct {
	// The name of the operation resource to be cancelled.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *CancelOperationRequest) Reset()                    { *m = CancelOperationRequest{} }
func (m *CancelOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelOperationRequest) ProtoMessage()               {}
func (*CancelOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// The request message for [Operations.DeleteOperation][google.longrunning.Operations.DeleteOperation].
type DeleteOperationRequest struct {
	// The name of the operation resource to be deleted.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteOperationRequest) Reset()                    { *m = DeleteOperationRequest{} }
func (m *DeleteOperationRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteOperationRequest) ProtoMessage()               {}
func (*DeleteOperationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func init() {
	proto.RegisterType((*Operation)(nil), "google.longrunning.Operation")
	proto.RegisterType((*GetOperationRequest)(nil), "google.longrunning.GetOperationRequest")
	proto.RegisterType((*ListOperationsRequest)(nil), "google.longrunning.ListOperationsRequest")
	proto.RegisterType((*ListOperationsResponse)(nil), "google.longrunning.ListOperationsResponse")
	proto.RegisterType((*CancelOperationRequest)(nil), "google.longrunning.CancelOperationRequest")
	proto.RegisterType((*DeleteOperationRequest)(nil), "google.longrunning.DeleteOperationRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Operations service

type OperationsClient interface {
	// Gets the latest state of a long-running operation.  Clients can use this
	// method to poll the operation result at intervals as recommended by the API
	// service.
	GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists operations that match the specified filter in the request. If the
	// server doesn't support this method, it returns `UNIMPLEMENTED`.
	//
	// NOTE: the `name` binding below allows API services to override the binding
	// to use different resource name schemes, such as `users/*/operations`.
	ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error)
	// Starts asynchronous cancellation on a long-running operation.  The server
	// makes a best effort to cancel the operation, but success is not
	// guaranteed.  If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
	// other methods to check whether the cancellation succeeded or whether the
	// operation completed despite cancellation. On successful cancellation,
	// the operation is not deleted; instead, it becomes an operation with
	// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
	// Deletes a long-running operation. This method indicates that the client is
	// no longer interested in the operation result. It does not cancel the
	// operation. If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.
	DeleteOperation(ctx context.Context, in *DeleteOperationRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type operationsClient struct {
	cc *grpc.ClientConn
}

func NewOperationsClient(cc *grpc.ClientConn) OperationsClient {
	return &operationsClient{cc}
}

func (c *operationsClient) GetOperation(ctx context.Context, in *GetOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := grpc.Invoke(ctx, "/google.longrunning.Operations/GetOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationsClient) ListOperations(ctx context.Context, in *ListOperationsRequest, opts ...grpc.CallOption) (*ListOperationsResponse, error) {
	out := new(ListOperationsResponse)
	err := grpc.Invoke(ctx, "/google.longrunning.Operations/ListOperations", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationsClient) CancelOperation(ctx context.Context, in *CancelOperationRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.longrunning.Operations/CancelOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationsClient) DeleteOperation(ctx context.Context, in *DeleteOperationRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.longrunning.Operations/DeleteOperation", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Operations service

type OperationsServer interface {
	// Gets the latest state of a long-running operation.  Clients can use this
	// method to poll the operation result at intervals as recommended by the API
	// service.
	GetOperation(context.Context, *GetOperationRequest) (*Operation, error)
	// Lists operations that match the specified filter in the request. If the
	// server doesn't support this method, it returns `UNIMPLEMENTED`.
	//
	// NOTE: the `name` binding below allows API services to override the binding
	// to use different resource name schemes, such as `users/*/operations`.
	ListOperations(context.Context, *ListOperationsRequest) (*ListOperationsResponse, error)
	// Starts asynchronous cancellation on a long-running operation.  The server
	// makes a best effort to cancel the operation, but success is not
	// guaranteed.  If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.  Clients can use
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
	// other methods to check whether the cancellation succeeded or whether the
	// operation completed despite cancellation. On successful cancellation,
	// the operation is not deleted; instead, it becomes an operation with
	// an [Operation.error][google.longrunning.Operation.error] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelOperation(context.Context, *CancelOperationRequest) (*google_protobuf2.Empty, error)
	// Deletes a long-running operation. This method indicates that the client is
	// no longer interested in the operation result. It does not cancel the
	// operation. If the server doesn't support this method, it returns
	// `google.rpc.Code.UNIMPLEMENTED`.
	DeleteOperation(context.Context, *DeleteOperationRequest) (*google_protobuf2.Empty, error)
}

func RegisterOperationsServer(s *grpc.Server, srv OperationsServer) {
	s.RegisterService(&_Operations_serviceDesc, srv)
}

func _Operations_GetOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).GetOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/GetOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).GetOperation(ctx, req.(*GetOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operations_ListOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).ListOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/ListOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).ListOperations(ctx, req.(*ListOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operations_CancelOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).CancelOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/CancelOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).CancelOperation(ctx, req.(*CancelOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Operations_DeleteOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationsServer).DeleteOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.longrunning.Operations/DeleteOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationsServer).DeleteOperation(ctx, req.(*DeleteOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Operations_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.longrunning.Operations",
	HandlerType: (*OperationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetOperation",
			Handler:    _Operations_GetOperation_Handler,
		},
		{
			MethodName: "ListOperations",
			Handler:    _Operations_ListOperations_Handler,
		},
		{
			MethodName: "CancelOperation",
			Handler:    _Operations_CancelOperation_Handler,
		},
		{
			MethodName: "DeleteOperation",
			Handler:    _Operations_DeleteOperation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/longrunning/operations.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/longrunning/operations.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 600 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x54, 0x41, 0x6f, 0xd3, 0x30,
	0x14, 0x5e, 0xb6, 0x6e, 0x6a, 0xdf, 0x80, 0x4a, 0x86, 0x95, 0xa8, 0x68, 0xa2, 0x8a, 0x10, 0x74,
	0x61, 0x8a, 0xa1, 0xbb, 0x4d, 0xda, 0x81, 0x02, 0x62, 0x48, 0x48, 0x4c, 0x19, 0xf7, 0xc9, 0xcb,
	0xde, 0x42, 0x44, 0x6a, 0x07, 0xdb, 0x19, 0xeb, 0xd0, 0x34, 0xc1, 0x81, 0x13, 0x37, 0x7e, 0x18,
	0x07, 0xfe, 0x02, 0x3f, 0x04, 0xc5, 0x49, 0x9b, 0xd0, 0xa5, 0xd0, 0x43, 0x5b, 0xd7, 0xfe, 0xde,
	0xf7, 0xbe, 0xf7, 0x7d, 0x4e, 0x60, 0x18, 0x0a, 0x11, 0xc6, 0xe8, 0x85, 0x22, 0x66, 0x3c, 0xf4,
	0x84, 0x0c, 0x69, 0x88, 0x3c, 0x91, 0x42, 0x0b, 0x9a, 0x1f, 0xb1, 0x24, 0x52, 0x34, 0x16, 0x3c,
	0x94, 0x29, 0xe7, 0x11, 0x0f, 0xa9, 0x48, 0x50, 0x32, 0x1d, 0x09, 0xae, 0x3c, 0x83, 0x23, 0xa4,
	0xe0, 0xa8, 0x80, 0xba, 0xaf, 0x17, 0xe3, 0x65, 0x49, 0x44, 0x15, 0xca, 0xb3, 0x28, 0xc0, 0x40,
	0xf0, 0xd3, 0x28, 0xa4, 0x8c, 0x73, 0xa1, 0xab, 0xf4, 0x5d, 0x1a, 0x46, 0xfa, 0x7d, 0x7a, 0xec,
	0x05, 0x62, 0x44, 0x73, 0x3a, 0x6a, 0x0e, 0x8e, 0xd3, 0x53, 0x9a, 0xe8, 0x71, 0x82, 0x8a, 0x32,
	0x3e, 0xce, 0x3e, 0x45, 0xc1, 0xce, 0xff, 0x0b, 0x70, 0x94, 0xe8, 0x71, 0xfe, 0x5d, 0x14, 0xed,
	0x2d, 0x26, 0x58, 0x26, 0x01, 0x55, 0x9a, 0xe9, 0x54, 0x15, 0x3f, 0x79, 0xb9, 0xf3, 0xd3, 0x82,
	0xd6, 0xdb, 0x89, 0x31, 0x84, 0x40, 0x83, 0xb3, 0x11, 0xda, 0x56, 0xcf, 0xea, 0xb7, 0x7c, 0xb3,
	0x26, 0x4f, 0xa0, 0x39, 0x42, 0xcd, 0x4e, 0x98, 0x66, 0xf6, 0x72, 0xcf, 0xea, 0xaf, 0x0f, 0xee,
	0x78, 0x45, 0xcf, 0x89, 0x3a, 0xef, 0x19, 0x1f, 0xfb, 0x53, 0x54, 0xc6, 0x72, 0x22, 0x38, 0xda,
	0x2b, 0x3d, 0xab, 0xdf, 0xf4, 0xcd, 0x9a, 0xb8, 0xb0, 0x8a, 0x52, 0x0a, 0x69, 0x37, 0x0c, 0x05,
	0x99, 0x50, 0xc8, 0x24, 0xf0, 0x0e, 0x8d, 0xa0, 0xfd, 0x25, 0x3f, 0x87, 0x90, 0x01, 0x34, 0x25,
	0xaa, 0x44, 0x70, 0x85, 0xf6, 0xea, 0xfc, 0x8e, 0xfb, 0x4b, 0xfe, 0x14, 0x37, 0x6c, 0xc2, 0x9a,
	0x44, 0x95, 0xc6, 0xda, 0xd9, 0x82, 0xdb, 0xaf, 0x50, 0x4f, 0x67, 0xf2, 0xf1, 0x63, 0x8a, 0x4a,
	0xd7, 0x8d, 0xe6, 0x5c, 0xc1, 0xc6, 0x9b, 0x48, 0x95, 0x58, 0x35, 0x0b, 0x6e, 0x54, 0x7c, 0xe8,
	0xc0, 0xda, 0x69, 0x14, 0x6b, 0x94, 0x05, 0x45, 0xf1, 0x8f, 0xdc, 0x83, 0x56, 0xc2, 0x42, 0x3c,
	0x52, 0xd1, 0x05, 0x1a, 0x83, 0x56, 0xfd, 0x66, 0xb6, 0x71, 0x18, 0x5d, 0x20, 0xd9, 0x04, 0x30,
	0x87, 0x5a, 0x7c, 0x40, 0x6e, 0x0c, 0x69, 0xf9, 0x06, 0xfe, 0x2e, 0xdb, 0x70, 0xae, 0xa0, 0x33,
	0x2b, 0x20, 0x9f, 0x87, 0xec, 0x01, 0x94, 0xf7, 0xd5, 0xb6, 0x7a, 0x2b, 0xfd, 0xf5, 0xc1, 0xa6,
	0x77, 0xfd, 0xc2, 0x7a, 0xe5, 0xa0, 0x95, 0x02, 0xf2, 0x10, 0xda, 0x1c, 0xcf, 0xf5, 0x51, 0xa5,
	0xf9, 0xb2, 0x69, 0x7e, 0x33, 0xdb, 0x3e, 0x98, 0x0a, 0xd8, 0x86, 0xce, 0x73, 0xc6, 0x03, 0x8c,
	0x17, 0xf2, 0x6b, 0x1b, 0x3a, 0x2f, 0x30, 0x46, 0x8d, 0x8b, 0xa0, 0x07, 0xdf, 0x1b, 0x00, 0xe5,
	0x64, 0xe4, 0x1c, 0x6e, 0x54, 0x73, 0x21, 0x8f, 0xea, 0xa6, 0xa9, 0x49, 0xae, 0xfb, 0xef, 0xb1,
	0x9d, 0xde, 0xd7, 0x5f, 0xbf, 0x7f, 0x2c, 0x77, 0x89, 0x4d, 0xcf, 0x9e, 0xd2, 0xcf, 0x59, 0xe7,
	0xbd, 0xd2, 0x08, 0xea, 0xba, 0x97, 0xe4, 0x9b, 0x05, 0xb7, 0xfe, 0xb6, 0x99, 0x6c, 0xd5, 0x71,
	0xd6, 0xde, 0x85, 0xae, 0xbb, 0x08, 0x34, 0x4f, 0xcd, 0xd9, 0x34, 0x5a, 0xee, 0x92, 0x8d, 0x3a,
	0x2d, 0x97, 0xe4, 0x8b, 0x05, 0xed, 0x19, 0xbb, 0x49, 0x2d, 0x7d, 0x7d, 0x26, 0xdd, 0xce, 0xb5,
	0xc7, 0xe0, 0x65, 0xf6, 0x26, 0x70, 0x5c, 0xd3, 0xf6, 0x81, 0x73, 0x7f, 0x9e, 0x05, 0xbb, 0x81,
	0x21, 0xdc, 0xb5, 0x5c, 0xf2, 0x09, 0xda, 0x33, 0x19, 0xd6, 0x4b, 0xa8, 0x0f, 0x7a, 0xae, 0x84,
	0x22, 0x05, 0x77, 0x6e, 0x0a, 0xc3, 0xc7, 0xd0, 0x09, 0xc4, 0xa8, 0xa6, 0xd5, 0xb0, 0x5d, 0x3a,
	0x79, 0x90, 0xb1, 0x1e, 0x58, 0xc7, 0x6b, 0x86, 0x7e, 0xe7, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xf2, 0x47, 0xec, 0x3f, 0xe7, 0x05, 0x00, 0x00,
}
