//=============================================================================
//
//   A Simple statistical language/encoding detector
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================
//
// DO NOT EDIT THIS FILE: Edit detector/build_detector.pl instead!
//

#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

#include "detector.h"

namespace {
//
// CORE DEFS
//

typedef struct _DetectorNGram
{
	const unsigned char * szNGram;
	double dScore;
} DetectorNGram;

typedef struct _DetectorDescriptor
{
	const char * szLanguage;
	const char * szEncoding;
	double single_char_data[256];
	DetectorNGram * ngram_hash[256];
} DetectorDescriptor;

static DetectorNGram X[] = { { nullptr, 0 } };

//
// DEFINES THAT SAVE (A LOT OF) SPACE
//

#define S static const unsigned char
#define N static DetectorNGram
#define D static DetectorDescriptor
#define Z 0.000
#define H    \
	{        \
		0, 0 \
	}
#define W -0.100
#define Y -0.250
#define V -0.350
#define d 100
#define e 101
#define f 102
#define g 103
#define h 104
#define i 105
#define j 106
#define k 107
#define l 108
#define m 109
#define n 110
#define o 111
#define p 112
#define q 113
#define r 114
#define s 115
#define t 116
#define u 117
#define v 118
#define w 119
#define x 120
#define y 121
#define z 122
#define a 32, 0

//
// DATA TABLES
//

//
// Lng: afrikaans
// Enc: iso-8859-15
//

S sig[] = { e, a };
S srg[] = { n, a };
S smi[] = { i, e, 0 };
S sxg[] = { t, a };
S smig[] = { i, e, a };
S sgl[] = { 32, h, 0 };
S sgh[] = { 32, d, 0 };
S swg[] = { s, a };
S siv[] = { e, r, 0 };
S sXr[] = { 97, n, 0 };
S svg[] = { r, a };
S sXX[] = { 97, 97, 0 };
S shm[] = { d, i, 0 };
S sgz[] = { 32, v, 0 };
S sgw[] = { 32, s, 0 };
S sir[] = { e, n, 0 };
S s79g[] = { y, a };
S sghm[] = { 32, d, i, 0 };
S sgq[] = { 32, m, 0 };
S ski[] = { g, e, 0 };
S sgr[] = { 32, n, 0 };
S sgi[] = { 32, e, 0 };
S sg_[] = { 32, w, 0 };
S six[] = { e, t, 0 };
S shmi[] = { d, i, e, 0 };
S shmig[] = { d, i, e, a };
S sixg[] = { e, t, a };
S sghmi[] = { 32, d, i, e, 0 };
S sgs[] = { 32, o, 0 };
S smr[] = { i, n, 0 };
S sxi[] = { t, e, 0 };
S sii[] = { e, e, 0 };
S srm[] = { n, i, 0 };
S sog[] = { k, a };
S sXrg[] = { 97, n, a };
S sgX[] = { 32, 97, 0 };
S shi[] = { d, e, 0 };
S sgk[] = { 32, g, 0 };
S shg[] = { d, a };
S sivg[] = { e, r, a };
S skg[] = { g, a };
S sirg[] = { e, n, a };
S srh[] = { n, d, 0 };
S sXv[] = { 97, r, 0 };
S sli[] = { h, e, 0 };
S s_X[] = { w, 97, 0 };
S sip[] = { e, l, 0 };
S sXx[] = { 97, t, 0 };
S srmi[] = { n, i, e, 0 };
S sgm[] = { 32, i, 0 };
S srmig[] = { n, i, e, a };
S sgrm[] = { 32, n, i, 0 };
S ssi[] = { o, e, 0 };
S sss[] = { o, o, 0 };
S sgrmi[] = { 32, n, i, e, 0 };
S sqg[] = { m, a };
S sgli[] = { 32, h, e, 0 };
S sio[] = { e, k, 0 };
S sg_X[] = { 32, w, 97, 0 };
S sgY[] = { 32, 98, 0 };
S sgir[] = { 32, e, n, 0 };
S sgki[] = { 32, g, e, 0 };
S sgo[] = { 32, k, 0 };
S sqi[] = { m, e, 0 };
S ssq[] = { o, m, 0 };
S sqX[] = { m, 97, 0 };
S sgx[] = { 32, t, 0 };
S szX[] = { v, 97, 0 };
S spg[] = { l, a };
S sXXr[] = { 97, 97, n, 0 };
S sXxg[] = { 97, t, a };
S smw[] = { i, s, 0 };
S ssr[] = { o, n, 0 };
S sgl79[] = { 32, h, y, 0 };
S sl79[] = { h, y, 0 };
S sgl79g[] = { 32, h, y, a };
S sl79g[] = { h, y, a };
S ssv[] = { o, r, 0 };
S sgirg[] = { 32, e, n, a };
S siw[] = { e, s, 0 };
S sglix[] = { 32, h, e, t, 0 };
S sXXv[] = { 97, 97, r, 0 };
S sXw[] = { 97, s, 0 };
S smx[] = { i, t, 0 };
S slix[] = { h, e, t, 0 };
S slixg[] = { h, e, t, a };
S szXr[] = { v, 97, n, 0 };
S shX[] = { d, 97, 0 };
S ssqg[] = { o, m, a };
S ssy[] = { o, u, 0 };
S sxig[] = { t, e, a };
S svX[] = { r, 97, 0 };
S spm[] = { l, i, 0 };
S sgqX[] = { 32, m, 97, 0 };
S sYi[] = { 98, e, 0 };
S siog[] = { e, k, a };
S sXp[] = { 97, l, 0 };
S sgzX[] = { 32, v, 97, 0 };
S sgw79g[] = { 32, s, y, a };
S sw79[] = { s, y, 0 };
S sgw79[] = { 32, s, y, 0 };
S sw79g[] = { s, y, a };
S srk[] = { n, g, 0 };
S svh[] = { r, d, 0 };
S sXwg[] = { 97, s, a };
S soi[] = { k, e, 0 };
S sXvg[] = { 97, r, a };
S sgzXr[] = { 32, v, 97, n, 0 };
S smwg[] = { i, s, a };
S s_i[] = { w, e, 0 };
S sXXvg[] = { 97, 97, r, a };
S swx[] = { s, t, 0 };
S smxg[] = { i, t, a };
S sgqi[] = { 32, m, e, 0 };
S swi[] = { s, e, 0 };
S szXrg[] = { v, 97, n, a };
S smrg[] = { i, n, a };
S sXk[] = { 97, g, 0 };
S svs[] = { r, o, 0 };
S sXrh[] = { 97, n, d, 0 };
S sls[] = { h, o, 0 };
S sim[] = { e, i, 0 };
S shiv[] = { d, e, r, 0 };
S sXXrg[] = { 97, 97, n, a };
S sgmr[] = { 32, i, n, 0 };
S svi[] = { r, e, 0 };
S spi[] = { l, e, 0 };
S syg[] = { u, a };
S sos[] = { k, o, 0 };
S srhi[] = { n, d, e, 0 };
S sgYi[] = { 32, 98, e, 0 };
S sg27[] = { 32, 39, 0 };
S ssyg[] = { o, u, a };
S sqXX[] = { m, 97, 97, 0 };
S siq[] = { e, m, 0 };
S srw[] = { n, s, 0 };
S smo[] = { i, k, 0 };
S sqs[] = { m, o, 0 };
S sws[] = { s, o, 0 };
S smk[] = { i, g, 0 };
S sgxi[] = { 32, t, e, 0 };
S svw[] = { r, s, 0 };
S sst[] = { o, p, 0 };
S sg27r[] = { 32, 39, n, 0 };
S sgzm[] = { 32, v, i, 0 };
S sgmw[] = { 32, i, s, 0 };
S sgmwg[] = { 32, i, s, a };
S szs[] = { v, o, 0 };
S szm[] = { v, i, 0 };
S sgxig[] = { 32, t, e, a };
S swm[] = { s, i, 0 };
S sgiog[] = { 32, e, k, a };
S s27rg[] = { 39, n, a };
S sgmrg[] = { 32, i, n, a };
S szi[] = { v, e, 0 };
S s27r[] = { 39, n, 0 };
S sg27rg[] = { 32, 39, n, a };
S sgio[] = { 32, e, k, 0 };
S slX[] = { h, 97, 0 };
S sgqs[] = { 32, m, o, 0 };
S srx[] = { n, t, 0 };
S sghX[] = { 32, d, 97, 0 };
S s_s[] = { w, o, 0 };
S svx[] = { r, t, 0 };
S srs[] = { n, o, 0 };
S sgqXX[] = { 32, m, 97, 97, 0 };
S sgt[] = { 32, p, 0 };
S s_Xx[] = { w, 97, t, 0 };
S sgzs[] = { 32, v, o, 0 };
S sXkg[] = { 97, g, a };
S siiv[] = { e, e, r, 0 };
S sg_Xx[] = { 32, w, 97, t, 0 };
S sgsr[] = { 32, o, n, 0 };
S sgzi[] = { 32, v, e, 0 };
S sgws[] = { 32, s, o, 0 };
S swo[] = { s, k, 0 };
S sglX[] = { 32, h, 97, 0 };
S s_Xwg[] = { w, 97, s, a };
S sipg[] = { e, l, a };
S sqsi[] = { m, o, e, 0 };
S s_Xw[] = { w, 97, s, 0 };
S sXpg[] = { 97, l, a };
S sjg[] = { f, a };
S sziv[] = { v, e, r, 0 };
S sg_Xw[] = { 32, w, 97, s, 0 };
S smrk[] = { i, n, g, 0 };
S sgXXr[] = { 32, 97, 97, n, 0 };
S sri[] = { n, e, 0 };
S sgsq[] = { 32, o, m, 0 };
S s_Xxg[] = { w, 97, t, a };
S stg[] = { p, a };
S sgsqg[] = { 32, o, m, a };
S sYp[] = { 98, l, 0 };
S sgos[] = { 32, k, o, 0 };
S sgXX[] = { 32, 97, 97, 0 };
S shig[] = { d, e, a };
S sgls[] = { 32, h, o, 0 };
S smv[] = { i, r, 0 };
S sstg[] = { o, p, a };
S sqix[] = { m, e, t, 0 };
S soX[] = { k, 97, 0 };
S sssv[] = { o, o, r, 0 };
S ssvh[] = { o, r, d, 0 };
S sxX[] = { t, 97, 0 };
S szmv[] = { v, i, r, 0 };
S sxs[] = { t, o, 0 };
S svhg[] = { r, d, a };
S sgXp[] = { 32, 97, l, 0 };
S sgziv[] = { 32, v, e, r, 0 };
S sih[] = { e, d, 0 };
S sgrs[] = { 32, n, o, 0 };
S szmvg[] = { v, i, r, a };
S sivw[] = { e, r, s, 0 };
S smvg[] = { i, r, a };
S sgqsi[] = { 32, m, o, e, 0 };
S sqXXv[] = { m, 97, 97, r, 0 };
S szv[] = { v, r, 0 };
S si_[] = { e, w, 0 };
S sgzmv[] = { 32, v, i, r, 0 };
S spmo[] = { l, i, k, 0 };
S sym[] = { u, i, 0 };
S sgn[] = { 32, j, 0 };
S sqixg[] = { m, e, t, a };
S sgwi[] = { 32, s, e, 0 };
S srhg[] = { n, d, a };
S sgzv[] = { 32, v, r, 0 };
S sgst[] = { 32, o, p, 0 };
S srki[] = { n, g, e, 0 };
S swxX[] = { s, t, 97, 0 };
S sgqix[] = { 32, m, e, t, 0 };
S sqXr[] = { m, 97, n, 0 };
S svm[] = { r, i, 0 };
S svXX[] = { r, 97, 97, 0 };
S srhiv[] = { n, d, e, r, 0 };
S swmi[] = { s, i, e, 0 };
S sro[] = { n, k, 0 };
S spp[] = { l, l, 0 };
S sgxs[] = { 32, t, o, 0 };
S svwg[] = { r, s, a };
S soig[] = { k, e, a };
S siwg[] = { e, s, a };
S ssvhg[] = { o, r, d, a };
S sgp[] = { 32, l, 0 };
S siivg[] = { e, e, r, a };
S stv[] = { p, r, 0 };
S smkg[] = { i, g, a };
S sXg[] = { 97, a };
S skiw[] = { g, e, s, 0 };
S sgv[] = { 32, r, 0 };
S ssk[] = { o, g, 0 };
S si_i[] = { e, w, e, 0 };
S srX[] = { n, 97, 0 };
S spX[] = { l, 97, 0 };
S sik[] = { e, g, 0 };
S s_svh[] = { w, o, r, d, 0 };
S shmx[] = { d, i, t, 0 };
S sop[] = { k, l, 0 };
S sgri[] = { 32, n, e, 0 };
S svxi[] = { r, t, e, 0 };
S sgwo[] = { 32, s, k, 0 };
S ssig[] = { o, e, a };
S sskg[] = { o, g, a };
S shmr[] = { d, i, n, 0 };
S sgq79[] = { 32, m, y, 0 };
S sq79g[] = { m, y, a };
S s_sv[] = { w, o, r, 0 };
S siy[] = { e, u, 0 };
S sq79[] = { m, y, 0 };
S siir[] = { e, e, n, 0 };
S skX[] = { g, 97, 0 };
S sgtv[] = { 32, p, r, 0 };
S slm[] = { h, i, 0 };
S sxXX[] = { t, 97, 97, 0 };
S sivwg[] = { e, r, s, a };
S sghmx[] = { 32, d, i, t, 0 };
S sgq79g[] = { 32, m, y, a };
S shmxg[] = { d, i, t, a };
S sglm[] = { 32, h, i, 0 };
S sXXx[] = { 97, 97, t, 0 };
S stX[] = { p, 97, 0 };
S sXo[] = { 97, k, 0 };
S skig[] = { g, e, a };
S smh[] = { i, d, 0 };
S ssix[] = { o, e, t, 0 };
S srhX[] = { n, d, 97, 0 };
S sgwx[] = { 32, s, t, 0 };
S srkg[] = { n, g, a };
S syv[] = { u, r, 0 };
S sgkiw[] = { 32, g, e, s, 0 };
S sYv[] = { 98, r, 0 };
S sgss[] = { 32, o, o, 0 };
S sghXx[] = { 32, d, 97, t, 0 };
S spmr[] = { l, i, n, 0 };
S sirh[] = { e, n, d, 0 };
S s_ii[] = { w, e, e, 0 };
S sivh[] = { e, r, d, 0 };
S shXxg[] = { d, 97, t, a };
S sxii[] = { t, e, e, 0 };
S skiv[] = { g, e, r, 0 };
S skXXr[] = { g, 97, 97, n, 0 };
S sXq[] = { 97, m, 0 };
S sgYp[] = { 32, 98, l, 0 };
S sxsi[] = { t, o, e, 0 };
S smiv[] = { i, e, r, 0 };
S shs[] = { d, o, 0 };
S shivg[] = { d, e, r, a };
S sYX[] = { 98, 97, 0 };
S sxsig[] = { t, o, e, a };
S spig[] = { l, e, a };
S ssixg[] = { o, e, t, a };
S shXx[] = { d, 97, t, 0 };
S srwg[] = { n, s, a };
S sg_s[] = { 32, w, o, 0 };
S symx[] = { u, i, t, 0 };
S smog[] = { i, k, a };
S smrh[] = { i, n, d, 0 };
S swxXX[] = { s, t, 97, 97, 0 };
S skXX[] = { g, 97, 97, 0 };
S swxi[] = { s, t, e, 0 };
S sgstg[] = { 32, o, p, a };
S siyv[] = { e, u, r, 0 };
S srsk[] = { n, o, g, 0 };
S sirw[] = { e, n, s, 0 };
S sg_m[] = { 32, w, i, 0 };
S sn79g[] = { j, y, a };
S s_m[] = { w, i, 0 };
S sXrhg[] = { 97, n, d, a };
S sv79[] = { r, y, 0 };
S srmk[] = { n, i, g, 0 };
S sioi[] = { e, k, e, 0 };
S sgn79[] = { 32, j, y, 0 };
S ssw[] = { o, s, 0 };
S sipm[] = { e, l, i, 0 };
S sps[] = { l, o, 0 };
S sirx[] = { e, n, t, 0 };
S s79h[] = { y, d, 0 };
S sgqXr[] = { 32, m, 97, n, 0 };
S smki[] = { i, g, e, 0 };
S sgn79g[] = { 32, j, y, a };
S sirm[] = { e, n, i, 0 };
S slmiv[] = { h, i, e, r, 0 };
S sgXw[] = { 32, 97, s, 0 };
S ssrw[] = { o, n, s, 0 };
S slmi[] = { h, i, e, 0 };
S sXh[] = { 97, d, 0 };
S srog[] = { n, k, a };
S sghi[] = { 32, d, e, 0 };
S sppi[] = { l, l, e, 0 };
S smp[] = { i, l, 0 };
S sn79[] = { j, y, 0 };
S sqiv[] = { m, e, r, 0 };
S sov[] = { k, r, 0 };
S simh[] = { e, i, d, 0 };
S sg_sv[] = { 32, w, o, r, 0 };
S siip[] = { e, e, l, 0 };
S sg_i[] = { 32, w, e, 0 };
S shivw[] = { d, e, r, s, 0 };
S sgrsk[] = { 32, n, o, g, 0 };
S ski_[] = { g, e, w, 0 };
S sgymx[] = { 32, u, i, t, 0 };
S spmog[] = { l, i, k, a };
S srskg[] = { n, o, g, a };
S siqg[] = { e, m, a };
S sosq[] = { k, o, m, 0 };
S sXXo[] = { 97, 97, k, 0 };
S sxm[] = { t, i, 0 };
S sgop[] = { 32, k, l, 0 };
S sivx[] = { e, r, t, 0 };
S sgym[] = { 32, u, i, 0 };
S sgy[] = { 32, u, 0 };
S sglmi[] = { 32, h, i, e, 0 };
S sXj[] = { 97, f, 0 };
S sglXX[] = { 32, h, 97, 97, 0 };
S ssx[] = { o, t, 0 };
S ship[] = { d, e, l, 0 };
S shmw[] = { d, i, s, 0 };
S sqir[] = { m, e, n, 0 };
S ssrg[] = { o, n, a };
S sswg[] = { o, s, a };
S siiq[] = { e, e, m, 0 };
S sopm[] = { k, l, i, 0 };
S siY[] = { e, 98, 0 };
S shXrg[] = { d, 97, n, a };
S shv[] = { d, r, 0 };
S slXr[] = { h, 97, n, 0 };
S sxiq[] = { t, e, m, 0 };
S sqsix[] = { m, o, e, t, 0 };
S sXXxg[] = { 97, 97, t, a };
S sgosr[] = { 32, k, o, n, 0 };
S srmki[] = { n, i, g, e, 0 };
S skiY[] = { g, e, 98, 0 };
S sppig[] = { l, l, e, a };
S syp[] = { u, l, 0 };
S smkig[] = { i, g, e, a };
S sYiw[] = { 98, e, s, 0 };
S svp[] = { r, l, 0 };
S sXvx[] = { 97, r, t, 0 };
S sXrhX[] = { 97, n, d, 97, 0 };
S slsyg[] = { h, o, u, a };
S ssrwg[] = { o, n, s, a };

N l0n0[] = { { siy, .108 }, H };
N l0n1[] = { { sl79g, .756 }, { stX, .108 }, H };
N l0n2[] = { { srmig, 1.371 }, H };
N l0n3[] = { { ssv, .336 }, { sosq, .121 }, H };
N l0n4[] = { { sgss, .212 }, H };
N l0n5[] = { { smr, .645 }, { sxm, .081 }, H };
N l0n6[] = { { srx, .188 }, { sgYp, .212 }, { spmog, .242 }, { shmw, .101 }, H };
N l0n7[] = { { sghm, 1.936 }, { s27r, .188 }, { sri, .161 }, H };
N l0n8[] = { { swo, .161 }, H };
N l0n9[] = { { slX, .188 }, H };
N l0n10[] = { { sYp, .161 }, { soig, .272 }, { sgosr, .202 }, H };
N l0n11[] = { { sghXx, .282 }, H };
N l0n12[] = { { sgp, .181 }, { sirm, .121 }, H };
N l0n13[] = { { swg, 1.714 }, { sXr, 1.116 }, { spm, .296 }, { sgzi, .393 }, H };
N l0n14[] = { { sgki, .907 }, { ssqg, .696 }, H };
N l0n15[] = { { sgst, .302 }, H };
N l0n16[] = { { shivw, .161 }, { ssrwg, .202 }, H };
N l0n17[] = { { sgqsi, .444 }, { shmx, .161 }, H };
N l0n18[] = { { sik, .108 }, H };
N l0n20[] = { { skiv, .141 }, { ssw, .081 }, H };
N l0n21[] = { { shm, 1.008 }, { sog, .928 }, { skXX, .141 }, H };
N l0n22[] = { { sXXv, .484 }, { sgw79g, .807 }, { sglXX, .202 }, H };
N l0n23[] = { { shivg, .282 }, H };
N l0n24[] = { { sxii, .141 }, H };
N l0n25[] = { { sivh, .141 }, H };
N l0n28[] = { { sgwo, .242 }, H };
N l0n29[] = { { sgq, 1.291 }, { sgn79, .181 }, H };
N l0n30[] = { { s_i, .255 }, { sivwg, .323 }, { srsk, .121 }, { sg_i, .181 }, H };
N l0n31[] = { { sgli, .998 }, { skiw, .181 }, { ssrg, .151 }, H };
N l0n32[] = { { symx, .141 }, H };
N l0n33[] = { { sxig, .665 }, { sop, .108 }, { srhX, .141 }, H };
N l0n34[] = { { si_, .148 }, { stv, .121 }, { ssix, .141 }, { sxsig, .282 }, H };
N l0n36[] = { { sym, .134 }, H };
N l0n37[] = { { sqXXv, .296 }, { ssx, .067 }, H };
N l0n38[] = { { ssi, .457 }, H };
N l0n40[] = { { sgrsk, .242 }, { sgym, .181 }, H };
N l0n41[] = { { srk, .269 }, { szmv, .222 }, { spig, .212 }, H };
N l0n42[] = { { sgmwg, .565 }, H };
N l0n43[] = { { sgzXr, .766 }, { s_Xwg, .484 }, H };
N l0n44[] = { { sxg, 2.138 }, { sXXx, .161 }, H };
N l0n45[] = { { sivg, 1.149 }, { svs, .229 }, H };
N l0n46[] = { { ski, .807 }, { sgr, 1.170 }, { sgio, .423 }, H };
N l0n48[] = { { sXX, 1.008 }, H };
N l0n49[] = { { sg27r, .423 }, { shig, .333 }, H };
N l0n50[] = { { smog, .212 }, H };
N l0n52[] = { { spg, .565 }, { sim, .229 }, H };
N l0n54[] = { { sghmi, 1.976 }, { ssy, .296 }, { s_Xxg, .484 }, { siivg, .363 }, { sgtv, .242 }, H };
N l0n57[] = { { sgzm, .423 }, H };
N l0n60[] = { { shg, .786 }, { sq79, .108 }, H };
N l0n61[] = { { swmi, .202 }, H };
N l0n62[] = { { siwg, .272 }, { slmiv, .161 }, H };
N l0n63[] = { { sgs, .988 }, { svX, .296 }, { sn79g, .181 }, H };
N l0n64[] = { { spp, .121 }, H };
N l0n65[] = { { sstg, .333 }, H };
N l0n66[] = { { sgXw, .181 }, H };
N l0n67[] = { { szm, .188 }, H };
N l0n68[] = { { sqixg, .403 }, H };
N l0n69[] = { { sqsix, .134 }, { smkig, .202 }, H };
N l0n72[] = { { sgqX, .665 }, { sgws, .363 }, { ssk, .121 }, H };
N l0n73[] = { { slix, .484 }, { smv, .148 }, H };
N l0n74[] = { { sXXrg, .686 }, { sg_m, .181 }, H };
N l0n75[] = { { srm, .632 }, { syg, .323 }, { sgxig, .565 }, { sXpg, .363 }, { sg_Xw, .484 }, { sglm, .242 }, { s79h, .081 }, { ski_, .121 }, H };
N l0n76[] = { { sws, .202 }, H };
N l0n77[] = { { sli, .471 }, { srhi, .323 }, { sXvx, .101 }, H };
N l0n78[] = { { sg_Xx, .524 }, { sgsqg, .484 }, H };
N l0n79[] = { { sixg, 1.512 }, { sgir, .938 }, { ssvh, .222 }, { sYX, .094 }, H };
N l0n80[] = { { sgt, .262 }, { sgq79, .242 }, H };
N l0n81[] = { { sgX, .847 }, { sXv, .484 }, { smrh, .141 }, H };
N l0n82[] = { { smiv, .141 }, H };
N l0n83[] = { { sqg, .665 }, H };
N l0n84[] = { { sos, .215 }, H };
N l0n85[] = { { srwg, .212 }, H };
N l0n86[] = { { sio, .444 }, { sw79g, .605 }, { srhg, .302 }, H };
N l0n87[] = { { syp, .067 }, H };
N l0n89[] = { { sXrh, .343 }, { sgxs, .272 }, H };
N l0n90[] = { { smw, .363 }, H };
N l0n91[] = { { sig, 3.650 }, { sgl79g, 1.008 }, { smh, .094 }, H };
N l0n94[] = { { sqXr, .202 }, { slsyg, .202 }, H };
N l0n95[] = { { skXXr, .188 }, H };
N l0n98[] = { { sgY, .645 }, { sXw, .323 }, { s_m, .081 }, H };
N l0n99[] = { { sgziv, .444 }, { sghmx, .323 }, { sXh, .081 }, H };
N l0n100[] = { { skiY, .101 }, H };
N l0n101[] = { { smrg, .544 }, H };
N l0n102[] = { { soX, .148 }, H };
N l0n103[] = { { sip, .471 }, { s27rg, .423 }, { sgkiw, .282 }, H };
N l0n106[] = { { svXX, .202 }, H };
N l0n107[] = { { smx, .323 }, { sgqXX, .524 }, { sxs, .148 }, H };
N l0n108[] = { { smi, 1.654 }, { shmi, 1.049 }, H };
N l0n109[] = { { sXrg, 1.391 }, { sro, .121 }, H };
N l0n111[] = { { sgstg, .282 }, H };
N l0n112[] = { { sYv, .094 }, { sxiq, .101 }, H };
N l0n113[] = { { svw, .202 }, { shmxg, .323 }, H };
N l0n114[] = { { srg, 2.501 }, { svh, .269 }, { smrk, .242 }, { sgv, .181 }, H };
N l0n115[] = { { sXx, .471 }, { sps, .081 }, H };
N l0n116[] = { { sgqi, .544 }, { sswg, .151 }, H };
N l0n117[] = { { szXr, .464 }, { s_ii, .141 }, { ship, .101 }, H };
N l0n118[] = { { sXXvg, .766 }, H };
N l0n119[] = { { sg27, .323 }, H };
N l0n120[] = { { siq, .202 }, H };
N l0n121[] = { { si_i, .161 }, H };
N l0n122[] = { { sjg, .242 }, { sirw, .121 }, { sglmi, .242 }, H };
N l0n123[] = { { sglix, .968 }, { sgzs, .393 }, { shs, .094 }, H };
N l0n124[] = { { sgXX, .363 }, { sXrhX, .134 }, H };
N l0n125[] = { { sxX, .148 }, { sgn79g, .242 }, H };
N l0n126[] = { { srskg, .242 }, H };
N l0n127[] = { { sgwx, .212 }, H };
N l0n128[] = { { srki, .202 }, { simh, .121 }, H };
N l0n130[] = { { svx, .175 }, { ssixg, .282 }, H };
N l0n131[] = { { sgw, 1.412 }, { svi, .229 }, H };
N l0n132[] = { { sgh, 1.795 }, { sgymx, .242 }, { sYiw, .101 }, H };
N l0n133[] = { { spX, .108 }, { sgri, .242 }, { sirx, .121 }, { sXj, .067 }, H };
N l0n134[] = { { ssig, .242 }, H };
N l0n135[] = { { sov, .081 }, H };
N l0n137[] = { { sir, .914 }, { szmvg, .444 }, { srkg, .212 }, { shXx, .141 }, H };
N l0n140[] = { { sg_s, .212 }, { sXXxg, .202 }, H };
N l0n141[] = { { shX, .309 }, { sgls, .333 }, H };
N l0n142[] = { { smk, .202 }, { sgiog, .565 }, { skig, .242 }, H };
N l0n143[] = { { sgzmv, .444 }, H };
N l0n145[] = { { sg27rg, .565 }, { slm, .108 }, H };
N l0n146[] = { { sqs, .202 }, { sgqXr, .242 }, H };
N l0n147[] = { { sYi, .282 }, { sgmr, .514 }, H };
N l0n148[] = { { sgx, .585 }, { siip, .121 }, H };
N l0n149[] = { { sgi, 1.089 }, H };
N l0n150[] = { { sXk, .242 }, { ssyg, .484 }, H };
N l0n151[] = { { sppi, .121 }, H };
N l0n153[] = { { skg, .766 }, H };
N l0n156[] = { { sgzv, .302 }, { sq79g, .242 }, H };
N l0n159[] = { { sgop, .181 }, { siiq, .101 }, H };
N l0n161[] = { { sl79, .350 }, { swx, .255 }, H };
N l0n162[] = { { srmi, .706 }, { swi, .242 }, { sqir, .101 }, H };
N l0n163[] = { { srhiv, .269 }, H };
N l0n164[] = { { sqX, .390 }, { sopm, .101 }, H };
N l0n165[] = { { sgy, .121 }, H };
N l0n166[] = { { spmo, .202 }, H };
N l0n167[] = { { shXrg, .202 }, H };
N l0n168[] = { { sskg, .242 }, { sxXX, .161 }, H };
N l0n169[] = { { slixg, .968 }, { szs, .188 }, { smvg, .333 }, H };
N l0n170[] = { { soi, .255 }, { siir, .161 }, H };
N l0n173[] = { { sioi, .121 }, H };
N l0n174[] = { { ssq, .390 }, { s_sv, .161 }, { shv, .067 }, H };
N l0n175[] = { { sgirg, 1.008 }, { sghX, .423 }, { ssvhg, .363 }, H };
N l0n176[] = { { stg, .242 }, { sgq79g, .323 }, { ssrw, .121 }, H };
N l0n177[] = { { sgrm, 1.028 }, { sXvg, .575 }, { srs, .175 }, H };
N l0n182[] = { { sgz, 1.452 }, { siog, .635 }, { sgw79, .605 }, { sssv, .222 }, H };
N l0n183[] = { { sgk, .827 }, { shiv, .343 }, H };
N l0n184[] = { { srmk, .121 }, H };
N l0n185[] = { { sgYi, .484 }, { sXrhg, .242 }, H };
N l0n186[] = { { smwg, .575 }, H };
N l0n187[] = { { szX, .376 }, H };
N l0n189[] = { { syv, .094 }, { siY, .067 }, H };
N l0n190[] = { { sivw, .222 }, H };
N l0n191[] = { { ssr, .350 }, H };
N l0n192[] = { { sgos, .363 }, H };
N l0n193[] = { { sxi, .645 }, H };
N l0n194[] = { { sXwg, .605 }, { sxsi, .141 }, H };
N l0n195[] = { { srX, .108 }, { slXr, .101 }, H };
N l0n198[] = { { sgXXr, .484 }, H };
N l0n199[] = { { s79g, 1.291 }, { sg_, 1.089 }, { sipg, .363 }, { svm, .134 }, { spmr, .141 }, H };
N l0n200[] = { { sgl, 1.896 }, { s_s, .175 }, H };
N l0n201[] = { { spi, .229 }, { sXXo, .121 }, { sivx, .121 }, H };
N l0n202[] = { { sgmw, .423 }, H };
N l0n203[] = { { smxg, .544 }, { s_Xw, .242 }, H };
N l0n204[] = { { smig, 2.964 }, { shmig, 2.017 }, { swxX, .202 }, H };
N l0n205[] = { { siv, 1.143 }, { srog, .181 }, H };
N l0n206[] = { { sqiv, .121 }, H };
N l0n207[] = { { sqXX, .302 }, { shmr, .161 }, H };
N l0n208[] = { { sss, .457 }, { sgqix, .403 }, H };
N l0n209[] = { { shi, .565 }, { svwg, .272 }, H };
N l0n210[] = { { smo, .202 }, { svhg, .333 }, H };
N l0n211[] = { { sXxg, .817 }, H };
N l0n213[] = { { szXrg, .726 }, { sirh, .141 }, H };
N l0n214[] = { { s_Xx, .262 }, { siiv, .262 }, H };
N l0n215[] = { { sv79, .081 }, H };
N l0n216[] = { { siqg, .181 }, H };
N l0n217[] = { { sgm, .706 }, { svxi, .161 }, H };
N l0n218[] = { { s_X, .471 }, { sgwi, .302 }, { s_svh, .215 }, { sXo, .108 }, H };
N l0n219[] = { { sghi, .181 }, H };
N l0n220[] = { { szv, .148 }, H };
N l0n222[] = { { siw, .323 }, H };
N l0n223[] = { { sih, .148 }, { sXg, .181 }, { sn79, .081 }, H };
N l0n224[] = { { sgrmi, 1.331 }, H };
N l0n225[] = { { sgzX, .635 }, { sst, .202 }, H };
N l0n226[] = { { sgqs, .423 }, { sg_sv, .242 }, H };
N l0n227[] = { { smp, .081 }, H };
N l0n228[] = { { sqix, .222 }, H };
N l0n229[] = { { sziv, .242 }, { smki, .121 }, H };
N l0n230[] = { { swm, .188 }, { siyv, .121 }, H };
N l0n231[] = { { srmki, .134 }, H };
N l0n232[] = { { sqi, .390 }, { slmi, .121 }, H };
N l0n233[] = { { sirg, 1.119 }, { sqsi, .242 }, { shXxg, .282 }, H };
N l0n234[] = { { sXXr, .565 }, { sgn, .202 }, { skX, .108 }, { sipm, .121 }, H };
N l0n235[] = { { sXp, .282 }, { sgxi, .454 }, H };
N l0n238[] = { { svg, 1.533 }, { sgsq, .363 }, { smkg, .272 }, H };
N l0n239[] = { { six, .726 }, { swxXX, .188 }, H };
N l0n240[] = { { sii, .632 }, H };
N l0n242[] = { { sg_X, .998 }, H };
N l0n243[] = { { sgmrg, .565 }, { sglX, .363 }, { sgrs, .333 }, H };
N l0n245[] = { { srw, .202 }, { sgXp, .333 }, H };
N l0n246[] = { { srh, .484 }, { sw79, .269 }, { sXkg, .393 }, H };
N l0n247[] = { { sls, .229 }, { sppig, .202 }, H };
N l0n248[] = { { swxi, .141 }, H };
N l0n249[] = { { sgsr, .393 }, H };
N l0n250[] = { { svp, .067 }, H };
N l0n251[] = { { sgo, .605 }, { sgl79, .786 }, H };
N l0n252[] = { { sXq, .094 }, H };
N l0n255[] = { { szi, .188 }, H };

D l0_d = {
	"afrikaans",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.010, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    0.001, 0.180, 0.030, 0.001, 0.106, 0.333, 0.014, 0.068, 0.056, 0.152, 0.007, 0.067, 0.068, 0.071, 0.167, 0.127,
	    0.024, W, 0.123, 0.115, 0.112, 0.032, 0.045, 0.042, W, 0.045, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, 0.001, 0.005, 0.006, V, V, V, 0.001,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l0n0, l0n1, l0n2, l0n3, l0n4, l0n5, l0n6, l0n7, l0n8, l0n9, l0n10, l0n11, l0n12, l0n13, l0n14, l0n15,
	    l0n16, l0n17, l0n18, X, l0n20, l0n21, l0n22, l0n23, l0n24, l0n25, X, X, l0n28, l0n29, l0n30, l0n31,
	    l0n32, l0n33, l0n34, X, l0n36, l0n37, l0n38, X, l0n40, l0n41, l0n42, l0n43, l0n44, l0n45, l0n46, X,
	    l0n48, l0n49, l0n50, X, l0n52, X, l0n54, X, X, l0n57, X, X, l0n60, l0n61, l0n62, l0n63,
	    l0n64, l0n65, l0n66, l0n67, l0n68, l0n69, X, X, l0n72, l0n73, l0n74, l0n75, l0n76, l0n77, l0n78, l0n79,
	    l0n80, l0n81, l0n82, l0n83, l0n84, l0n85, l0n86, l0n87, X, l0n89, l0n90, l0n91, X, X, l0n94, l0n95,
	    X, X, l0n98, l0n99, l0n100, l0n101, l0n102, l0n103, X, X, l0n106, l0n107, l0n108, l0n109, X, l0n111,
	    l0n112, l0n113, l0n114, l0n115, l0n116, l0n117, l0n118, l0n119, l0n120, l0n121, l0n122, l0n123, l0n124, l0n125, l0n126, l0n127,
	    l0n128, X, l0n130, l0n131, l0n132, l0n133, l0n134, l0n135, X, l0n137, X, X, l0n140, l0n141, l0n142, l0n143,
	    X, l0n145, l0n146, l0n147, l0n148, l0n149, l0n150, l0n151, X, l0n153, X, X, l0n156, X, X, l0n159,
	    X, l0n161, l0n162, l0n163, l0n164, l0n165, l0n166, l0n167, l0n168, l0n169, l0n170, X, X, l0n173, l0n174, l0n175,
	    l0n176, l0n177, X, X, X, X, l0n182, l0n183, l0n184, l0n185, l0n186, l0n187, X, l0n189, l0n190, l0n191,
	    l0n192, l0n193, l0n194, l0n195, X, X, l0n198, l0n199, l0n200, l0n201, l0n202, l0n203, l0n204, l0n205, l0n206, l0n207,
	    l0n208, l0n209, l0n210, l0n211, X, l0n213, l0n214, l0n215, l0n216, l0n217, l0n218, l0n219, l0n220, X, l0n222, l0n223,
	    l0n224, l0n225, l0n226, l0n227, l0n228, l0n229, l0n230, l0n231, l0n232, l0n233, l0n234, l0n235, X, X, l0n238, l0n239,
	    l0n240, X, l0n242, l0n243, X, l0n245, l0n246, l0n247, l0n248, l0n249, l0n250, l0n251, l0n252, X, X, l0n255 }
};

//
// Lng: albanian
// Enc: utf8
//

S sc3ab[] = { 195, 171, 0 };
S sc3abg[] = { 195, 171, a };
S sabg[] = { 171, a };
S sxc3[] = { t, 195, 0 };
S sxc3ab[] = { t, 195, 171, 0 };
S sxc3abg[] = { t, 195, 171, a };
S swl[] = { s, h, 0 };
S smg[] = { i, a };
S sabv[] = { 171, r, 0 };
S sc3abv[] = { 195, 171, r, 0 };
S sgxc3[] = { 32, t, 195, 0 };
S sgxc3ab[] = { 32, t, 195, 171, 0 };
S slx[] = { h, t, 0 };
S swlx[] = { s, h, t, 0 };
S sgig[] = { 32, e, a };
S stc3[] = { p, 195, 0 };
S stc3ab[] = { p, 195, 171, 0 };
S stc3abv[] = { p, 195, 171, r, 0 };
S smwl[] = { i, s, h, 0 };
S src3ab[] = { n, 195, 171, 0 };
S src3[] = { n, 195, 0 };
S sng[] = { j, a };
S sgtc3[] = { 32, p, 195, 0 };
S sgtc3ab[] = { 32, p, 195, 171, 0 };
S svc3[] = { r, 195, 0 };
S ssg[] = { o, a };
S smwlx[] = { i, s, h, t, 0 };
S svc3ab[] = { r, 195, 171, 0 };
S slxi[] = { h, t, e, 0 };
S sni[] = { j, e, 0 };
S swlxi[] = { s, h, t, e, 0 };
S src3abg[] = { n, 195, 171, a };
S shl[] = { d, h, 0 };
S snc3[] = { j, 195, 0 };
S snc3ab[] = { j, 195, 171, 0 };
S skn[] = { g, j, 0 };
S sin[] = { e, j, 0 };
S sc3abw[] = { 195, 171, s, 0 };
S sabw[] = { 171, s, 0 };
S srn[] = { n, j, 0 };
S slxig[] = { h, t, e, a };
S sqm[] = { m, i, 0 };
S sing[] = { e, j, a };
S sc3abvg[] = { 195, 171, r, a };
S sabvg[] = { 171, r, a };
S sgrc3ab[] = { 32, n, 195, 171, 0 };
S sgrc3[] = { 32, n, 195, 0 };
S sgwl[] = { 32, s, h, 0 };
S sabr[] = { 171, n, 0 };
S soc3ab[] = { k, 195, 171, 0 };
S soy[] = { k, u, 0 };
S sc3abr[] = { 195, 171, n, 0 };
S soc3[] = { k, 195, 0 };
S srnc3[] = { n, j, 195, 0 };
S srnc3ab[] = { n, j, 195, 171, 0 };
S sgu[] = { 32, q, 0 };
S sqig[] = { m, e, a };
S snc3abg[] = { j, 195, 171, a };
S sgwm[] = { 32, s, i, 0 };
S sxl[] = { t, h, 0 };
S syvg[] = { u, r, a };
S sgtX[] = { 32, p, 97, 0 };
S som[] = { k, i, 0 };
S swig[] = { s, e, a };
S smq[] = { i, m, 0 };
S sts[] = { p, o, 0 };
S sqc3[] = { m, 195, 0 };
S snX[] = { j, 97, 0 };
S sqc3ab[] = { m, 195, 171, 0 };
S sgqig[] = { 32, m, e, a };
S sXn[] = { 97, j, 0 };
S sgrh[] = { 32, n, d, 0 };
S sgj[] = { 32, f, 0 };
S sgrn[] = { 32, n, j, 0 };
S sc3a7[] = { 195, 167, 0 };
S sabwg[] = { 171, s, a };
S sc3abwg[] = { 195, 171, s, a };
S svc3abg[] = { r, 195, 171, a };
S suc3ab[] = { q, 195, 171, 0 };
S suc3[] = { q, 195, 0 };
S sgmg[] = { 32, i, a };
S sc3abx[] = { 195, 171, t, 0 };
S sixc3ab[] = { e, t, 195, 171, 0 };
S sixc3[] = { e, t, 195, 0 };
S sabx[] = { 171, t, 0 };
S sgrnc3[] = { 32, n, j, 195, 0 };
S suc3abg[] = { q, 195, 171, a };
S sgrk[] = { 32, n, g, 0 };
S sgkn[] = { 32, g, j, 0 };
S shli[] = { d, h, e, 0 };
S slig[] = { h, e, a };
S somw[] = { k, i, s, 0 };
S sgom[] = { 32, k, i, 0 };
S syX[] = { u, 97, 0 };
S shlig[] = { d, h, e, a };
S sabrg[] = { 171, n, a };
S sc3abrg[] = { 195, 171, n, a };
S svv[] = { r, r, 0 };
S sxy[] = { t, u, 0 };
S sgoc3[] = { 32, k, 195, 0 };
S swc3[] = { s, 195, 0 };
S sguc3[] = { 32, q, 195, 0 };
S ssl[] = { o, h, 0 };
S sgoc3ab[] = { 32, k, 195, 171, 0 };
S sguc3ab[] = { 32, q, 195, 171, 0 };
S somwl[] = { k, i, s, h, 0 };
S swc3ab[] = { s, 195, 171, 0 };
S slc3[] = { h, 195, 0 };
S snm[] = { j, i, 0 };
S sghl[] = { 32, d, h, 0 };
S srkX[] = { n, g, 97, 0 };
S sgoy[] = { 32, k, u, 0 };
S sqc3abg[] = { m, 195, 171, a };
S sgrkX[] = { 32, n, g, 97, 0 };
S sXxc3[] = { 97, t, 195, 0 };
S srxig[] = { n, t, e, a };
S sgomw[] = { 32, k, i, s, 0 };
S sXxc3ab[] = { 97, t, 195, 171, 0 };
S syr[] = { u, n, 0 };
S slin[] = { h, e, j, 0 };
S srxi[] = { n, t, e, 0 };
S sling[] = { h, e, j, a };
S sns[] = { j, o, 0 };
S sgmwl[] = { 32, i, s, h, 0 };
S svmg[] = { r, i, a };
S soyv[] = { k, u, r, 0 };
S sgqc3ab[] = { 32, m, 195, 171, 0 };
S sghli[] = { 32, d, h, e, 0 };
S sgqc3[] = { 32, m, 195, 0 };
S snsg[] = { j, o, a };
S sxXg[] = { t, 97, a };
S sgts[] = { 32, p, o, 0 };
S sknm[] = { g, j, i, 0 };
S soc3abx[] = { k, 195, 171, t, 0 };
S swlm[] = { s, h, i, 0 };
S spc3ab[] = { l, 195, 171, 0 };
S sYc3[] = { 98, 195, 0 };
S sXm[] = { 97, i, 0 };
S sXt[] = { 97, p, 0 };
S sly[] = { h, u, 0 };
S sYc3ab[] = { 98, 195, 171, 0 };
S syo[] = { u, k, 0 };
S spc3[] = { l, 195, 0 };
S sgqm[] = { 32, m, i, 0 };
S swX[] = { s, 97, 0 };
S srmg[] = { n, i, a };
S slc3ab[] = { h, 195, 171, 0 };
S sgzix[] = { 32, v, e, t, 0 };
S sgwmp[] = { 32, s, i, l, 0 };
S sxc3abv[] = { t, 195, 171, r, 0 };
S sknmx[] = { g, j, i, t, 0 };
S syXvg[] = { u, 97, r, a };
S sgc3[] = { 32, 195, 0 };
S syXv[] = { u, 97, r, 0 };
S srhs[] = { n, d, o, 0 };
S sgxl[] = { 32, t, h, 0 };
S sxlX[] = { t, h, 97, 0 };
S spz[] = { l, v, 0 };
S swmp[] = { s, i, l, 0 };
S sui[] = { q, e, 0 };
S szix[] = { v, e, t, 0 };
S sgZ[] = { 32, 99, 0 };
S ssli[] = { o, h, e, 0 };
S smpz[] = { i, l, v, 0 };
S smqm[] = { i, m, i, 0 };
S sqmv[] = { m, i, r, 0 };
S sqY[] = { m, 98, 0 };
S sgxX[] = { 32, t, 97, 0 };
S snmx[] = { j, i, t, 0 };
S swmpz[] = { s, i, l, v, 0 };
S stsg[] = { p, o, a };
S sgxlX[] = { 32, t, h, 97, 0 };
S syog[] = { u, k, a };
S swc3abg[] = { s, 195, 171, a };
S sc3abvm[] = { 195, 171, r, i, 0 };
S stm[] = { p, i, 0 };
S smxl[] = { i, t, h, 0 };
S sgoX[] = { 32, k, 97, 0 };
S sky[] = { g, u, 0 };
S sgoyv[] = { 32, k, u, r, 0 };
S sgry[] = { 32, n, u, 0 };
S sslin[] = { o, h, e, j, 0 };
S snmxl[] = { j, i, t, h, 0 };
S snig[] = { j, e, a };
S syrh[] = { u, n, d, 0 };
S sgwig[] = { 32, s, e, a };
S sry[] = { n, u, 0 };
S soXg[] = { k, 97, a };
S sgYc3ab[] = { 32, 98, 195, 171, 0 };
S ssrx[] = { o, n, t, 0 };
S skXg[] = { g, 97, a };
S sabvm[] = { 171, r, i, 0 };
S srkXg[] = { n, g, 97, a };
S svXg[] = { r, 97, a };
S sgYc3[] = { 32, 98, 195, 0 };
S szXg[] = { v, 97, a };
S sgwX[] = { 32, s, 97, 0 };
S spzXg[] = { l, v, 97, a };
S sqirh[] = { m, e, n, d, 0 };
S smpzX[] = { i, l, v, 97, 0 };
S sc3abq[] = { 195, 171, m, 0 };
S svmx[] = { r, i, t, 0 };
S sryog[] = { n, u, k, a };
S slg[] = { h, a };
S snx[] = { j, t, 0 };
S sgrhs[] = { 32, n, d, o, 0 };
S sjX[] = { f, 97, 0 };
S sYm[] = { 98, i, 0 };
S srmrg[] = { n, i, n, a };
S spzX[] = { l, v, 97, 0 };
S sg7a[] = { 32, z, 0 };
S svk[] = { r, g, 0 };
S sgryo[] = { 32, n, u, k, 0 };
S sgqmv[] = { 32, m, i, r, 0 };
S sryo[] = { n, u, k, 0 };
S ssrm[] = { o, n, i, 0 };
S slXg[] = { h, 97, a };
S sxix[] = { t, e, t, 0 };
S svq[] = { r, m, 0 };
S sxlXg[] = { t, h, 97, a };
S sabq[] = { 171, m, 0 };
S sxXr[] = { t, 97, n, 0 };
S svin[] = { r, e, j, 0 };
S srmr[] = { n, i, n, 0 };
S slxg[] = { h, t, a };
S ssrxi[] = { o, n, t, e, 0 };
S sghs[] = { 32, d, o, 0 };
S srXg[] = { n, 97, a };
S smn[] = { i, j, 0 };
S sxyv[] = { t, u, r, 0 };
S sgXm[] = { 32, 97, i, 0 };
S stvi[] = { p, r, e, 0 };
S sgtXw[] = { 32, p, 97, s, 0 };
S szc3ab[] = { v, 195, 171, 0 };
S sivc3[] = { e, r, 195, 0 };
S sXmg[] = { 97, i, a };
S sabxc3[] = { 171, t, 195, 0 };
S sgqir[] = { 32, m, e, n, 0 };
S stXv[] = { p, 97, r, 0 };
S shy[] = { d, u, 0 };
S sxmg[] = { t, i, a };
S swlxg[] = { s, h, t, a };
S sgc3a7[] = { 32, 195, 167, 0 };
S sgXmg[] = { 32, 97, i, a };
S sxv[] = { t, r, 0 };
S siwl[] = { e, s, h, 0 };
S ssvg[] = { o, r, a };
S svc3abr[] = { r, 195, 171, n, 0 };
S s7am[] = { z, i, 0 };
S sgwlx[] = { 32, s, h, t, 0 };
S soyvg[] = { k, u, r, a };
S sXrm[] = { 97, n, i, 0 };
S sabxc3ab[] = { 171, t, 195, 171, 0 };
S szc3[] = { v, 195, 0 };
S sxXrm[] = { t, 97, n, i, 0 };
S sgknm[] = { 32, g, j, i, 0 };
S sgXx[] = { 32, 97, t, 0 };
S stXw[] = { p, 97, s, 0 };
S sXu[] = { 97, q, 0 };
S sivc3ab[] = { e, r, 195, 171, 0 };
S sc3abxc3[] = { 195, 171, t, 195, 0 };
S sgxXr[] = { 32, t, 97, n, 0 };
S swlmr[] = { s, h, i, n, 0 };
S sXns[] = { 97, j, o, 0 };
S sgqY[] = { 32, m, 98, 0 };
S sgtvi[] = { 32, p, r, e, 0 };
S sgpi[] = { 32, l, e, 0 };
S svmw[] = { r, i, s, 0 };
S sc3abp[] = { 195, 171, l, 0 };
S slxc3[] = { h, t, 195, 0 };
S syq[] = { u, m, 0 };
S sgtsg[] = { 32, p, o, a };
S sknc3ab[] = { g, j, 195, 171, 0 };
S sXrmg[] = { 97, n, i, a };
S s79v[] = { y, r, 0 };
S slmrg[] = { h, i, n, a };
S sgZm[] = { 32, 99, i, 0 };
S sgYv[] = { 32, 98, r, 0 };
S sxn[] = { t, j, 0 };
S sving[] = { r, e, j, a };
S sgwc3[] = { 32, s, 195, 0 };
S sabp[] = { 171, l, 0 };
S sug[] = { q, a };
S sxlc3[] = { t, h, 195, 0 };
S si7a[] = { e, z, 0 };
S sgXns[] = { 32, 97, j, o, 0 };
S smoy[] = { i, k, u, 0 };
S slxc3ab[] = { h, t, 195, 171, 0 };
S sln[] = { h, j, 0 };
S stvin[] = { p, r, e, j, 0 };
S sZm[] = { 99, i, 0 };

N l1n0[] = { { swlxi, .690 }, { sgc3a7, .181 }, { soyvg, .242 }, H };
N l1n1[] = { { stX, .253 }, H };
N l1n2[] = { { swig, .492 }, { sgoy, .337 }, { sgmwl, .414 }, H };
N l1n3[] = { { slxig, .898 }, { sabr, .397 }, { ssv, .184 }, { snmxl, .207 }, H };
N l1n4[] = { { shl, .334 }, H };
N l1n5[] = { { smr, .391 }, { sxm, .265 }, { sgrnc3, .552 }, { srmr, .138 }, H };
N l1n6[] = { { sgwm, .544 }, { srx, .207 }, { sknm, .190 }, H };
N l1n7[] = { { spc3, .127 }, H };
N l1n9[] = { { slX, .173 }, { sgxXr, .242 }, H };
N l1n11[] = { { svq, .092 }, H };
N l1n12[] = { { sgp, .311 }, { sgxl, .259 }, H };
N l1n13[] = { { swg, .483 }, { sXr, .230 }, { sgzi, .414 }, { spm, .150 }, H };
N l1n16[] = { { sryog, .276 }, H };
N l1n17[] = { { svin, .138 }, H };
N l1n18[] = { { sc3abrg, 1.165 }, { sqmv, .173 }, { sik, .081 }, H };
N l1n21[] = { { sog, .242 }, { shm, .161 }, { sgts, .285 }, { spzX, .138 }, H };
N l1n22[] = { { sxn, .069 }, H };
N l1n23[] = { { somwl, .322 }, { sry, .104 }, H };
N l1n24[] = { { smpzX, .184 }, { sXmg, .181 }, H };
N l1n25[] = { { sc3abvm, .466 }, H };
N l1n26[] = { { svc3ab, .552 }, H };
N l1n27[] = { { szXg, .207 }, H };
N l1n29[] = { { sgq, 1.208 }, { syvg, .544 }, H };
N l1n31[] = { { sxlX, .173 }, H };
N l1n33[] = { { sxig, 1.398 }, H };
N l1n34[] = { { snc3ab, .483 }, { stv, .161 }, H };
N l1n35[] = { { srXg, .181 }, H };
N l1n37[] = { { ssx, .081 }, H };
N l1n38[] = { { sqc3, .207 }, { sgoX, .233 }, H };
N l1n39[] = { { svmg, .311 }, H };
N l1n41[] = { { srk, .230 }, H };
N l1n42[] = { { sYc3ab, .190 }, H };
N l1n43[] = { { sghli, .414 }, H };
N l1n44[] = { { sxg, .846 }, { sqm, .288 }, { sgXns, .207 }, H };
N l1n45[] = { { svs, .104 }, H };
N l1n46[] = { { sgr, 1.588 }, { smwlx, .736 }, { sivc3, .121 }, H };
N l1n47[] = { { sXt, .127 }, { sgxlX, .311 }, { sivc3ab, .161 }, H };
N l1n49[] = { { swlxg, .242 }, H };
N l1n50[] = { { stc3abv, .944 }, H };
N l1n52[] = { { sgXmg, .242 }, H };
N l1n53[] = { { sns, .138 }, { sgry, .233 }, H };
N l1n54[] = { { sgtv, .285 }, H };
N l1n55[] = { { sxXr, .138 }, H };
N l1n57[] = { { sgmg, .440 }, { swc3ab, .242 }, { s79v, .069 }, H };
N l1n58[] = { { sgwig, .311 }, H };
N l1n59[] = { { sling, .449 }, H };
N l1n60[] = { { shg, .190 }, H };
N l1n61[] = { { szc3, .081 }, { sc3abxc3, .362 }, H };
N l1n62[] = { { sc3abvg, 1.864 }, { sky, .104 }, H };
N l1n63[] = { { svX, .276 }, H };
N l1n64[] = { { spp, .207 }, { sXu, .081 }, H };
N l1n65[] = { { soc3ab, .397 }, H };
N l1n66[] = { { ssrm, .138 }, { sgXw, .181 }, H };
N l1n69[] = { { src3, .414 }, { sin, .322 }, { sgkn, .414 }, H };
N l1n70[] = { { syo, .127 }, H };
N l1n71[] = { { sabv, 1.295 }, { snX, .207 }, H };
N l1n72[] = { { sqig, .570 }, { sgYv, .155 }, H };
N l1n73[] = { { sc3abwg, 1.320 }, { smv, .115 }, { sghs, .181 }, H };
N l1n74[] = { { sgwmp, .345 }, { skXg, .233 }, H };
N l1n75[] = { { syg, .449 }, { srm, .253 }, H };
N l1n76[] = { { slx, .621 }, H };
N l1n77[] = { { sli, .518 }, { sgXx, .181 }, H };
N l1n79[] = { { sixg, .285 }, { stsg, .259 }, H };
N l1n80[] = { { sgt, 1.502 }, { sixc3, .276 }, H };
N l1n81[] = { { sgX, .777 }, { sXv, .403 }, { sixc3ab, .368 }, H };
N l1n83[] = { { sqg, .190 }, { sgqY, .155 }, H };
N l1n84[] = { { sos, .150 }, { srkX, .224 }, H };
N l1n85[] = { { sxlc3, .104 }, { si7a, .069 }, H };
N l1n86[] = { { srhg, .285 }, { siwl, .121 }, H };
N l1n87[] = { { syp, .115 }, { sgwlx, .242 }, H };
N l1n88[] = { { sc3abg, 12.467 }, { sxc3ab, 2.054 }, { sabw, .466 }, { swlm, .190 }, { sgoyv, .311 }, H };
N l1n89[] = { { ssl, .161 }, H };
N l1n90[] = { { smw, .564 }, H };
N l1n91[] = { { sig, 3.142 }, { suc3abg, .552 }, { shli, .276 }, { smh, .092 }, H };
N l1n92[] = { { srn, .311 }, { sgoc3, .362 }, H };
N l1n93[] = { { sgoc3ab, .483 }, { srxi, .224 }, { sly, .127 }, H };
N l1n94[] = { { swX, .127 }, H };
N l1n96[] = { { svv, .173 }, { spc3ab, .190 }, H };
N l1n97[] = { { sgu, .380 }, H };
N l1n98[] = { { sgY, .483 }, { sXw, .242 }, { sknmx, .230 }, H };
N l1n99[] = { { sabrg, .583 }, { ssvg, .181 }, { sgpi, .155 }, H };
N l1n100[] = { { sui, .115 }, { svc3abr, .161 }, H };
N l1n101[] = { { smrg, .621 }, { srmrg, .276 }, { sxmg, .181 }, { sgtvi, .207 }, H };
N l1n102[] = { { soX, .184 }, H };
N l1n103[] = { { sip, .081 }, H };
N l1n104[] = { { syq, .069 }, H };
N l1n105[] = { { sabx, .276 }, { sgzix, .345 }, { slXg, .207 }, H };
N l1n107[] = { { smx, .426 }, { sxs, .138 }, H };
N l1n108[] = { { smi, .069 }, H };
N l1n112[] = { { sYv, .104 }, H };
N l1n113[] = { { svw, .104 }, { sving, .207 }, H };
N l1n114[] = { { srg, .811 }, { sgv, .173 }, { sxXrm, .161 }, H };
N l1n115[] = { { sXx, .311 }, { sgZ, .173 }, { sps, .092 }, H };
N l1n116[] = { { sgqi, .751 }, H };
N l1n117[] = { { spzXg, .276 }, { sgtsg, .207 }, H };
N l1n118[] = { { sgryo, .276 }, H };
N l1n119[] = { { smqm, .173 }, H };
N l1n121[] = { { syr, .150 }, { stvi, .121 }, H };
N l1n122[] = { { sgrh, .466 }, { svc3abg, .587 }, H };
N l1n123[] = { { shs, .242 }, { sgtX, .518 }, H };
N l1n125[] = { { sxX, .253 }, H };
N l1n126[] = { { sgom, .388 }, { sgqc3, .311 }, H };
N l1n127[] = { { sqc3ab, .311 }, { sgqc3ab, .414 }, { sxlXg, .276 }, H };
N l1n128[] = { { sgknm, .242 }, H };
N l1n130[] = { { snc3abg, .759 }, { svx, .127 }, { syXv, .173 }, H };
N l1n131[] = { { sgw, 1.450 }, { stc3, .483 }, { skn, .322 }, { svi, .276 }, H };
N l1n132[] = { { sgh, .690 }, H };
N l1n133[] = { { spX, .081 }, H };
N l1n137[] = { { sir, .380 }, { stm, .104 }, H };
N l1n138[] = { { swmp, .173 }, { snx, .092 }, H };
N l1n139[] = { { sni, .345 }, { slc3, .161 }, H };
N l1n142[] = { { sXns, .104 }, H };
N l1n143[] = { { sgrc3, .621 }, H };
N l1n144[] = { { sgrc3ab, .829 }, { sXrm, .121 }, H };
N l1n145[] = { { ssg, .552 }, { slm, .150 }, H };
N l1n148[] = { { sgx, 1.916 }, H };
N l1n149[] = { { sgi, .898 }, { snsg, .311 }, H };
N l1n150[] = { { szc3ab, .121 }, H };
N l1n153[] = { { swc3abg, .311 }, H };
N l1n155[] = { { sgrk, .414 }, H };
N l1n156[] = { { syX, .173 }, { sc3abp, .233 }, H };
N l1n157[] = { { soc3abx, .253 }, H };
N l1n158[] = { { src3ab, .621 }, { sxv, .081 }, H };
N l1n159[] = { { svXg, .233 }, H };
N l1n160[] = { { soyv, .207 }, { sgqm, .285 }, H };
N l1n161[] = { { swx, .081 }, H };
N l1n162[] = { { swi, .242 }, { suc3, .196 }, { sqir, .173 }, { swlmr, .138 }, { sln, .069 }, H };
N l1n163[] = { { slxi, .535 }, H };
N l1n164[] = { { sqX, .081 }, H };
N l1n165[] = { { sing, .621 }, { sgy, .155 }, { svk, .092 }, H };
N l1n166[] = { { sgj, .311 }, { syog, .233 }, H };
N l1n167[] = { { sabvg, .932 }, { sc3abq, .311 }, H };
N l1n170[] = { { soi, .092 }, H };
N l1n171[] = { { srmg, .285 }, { slmrg, .207 }, H };
N l1n172[] = { { slxg, .181 }, H };
N l1n173[] = { { slig, .414 }, { slxc3, .104 }, H };
N l1n174[] = { { sxc3abv, .230 }, { sgwX, .207 }, { shv, .069 }, { slxc3ab, .138 }, H };
N l1n176[] = { { ssli, .173 }, { sryo, .138 }, H };
N l1n177[] = { { sgtc3, .880 }, { sXvg, .259 }, H };
N l1n178[] = { { sgtc3ab, 1.174 }, { sc3abr, .893 }, H };
N l1n180[] = { { sc3a7, .466 }, { srkXg, .311 }, H };
N l1n181[] = { { sqY, .115 }, H };
N l1n182[] = { { sgz, .535 }, H };
N l1n183[] = { { sgk, .397 }, { sxyv, .121 }, { stvin, .138 }, H };
N l1n184[] = { { sxc3abg, 3.383 }, { sabwg, .660 }, { sXm, .127 }, { slg, .138 }, { svmw, .104 }, H };
N l1n186[] = { { soy, .265 }, H };
N l1n187[] = { { shlig, .518 }, { szX, .115 }, { srhs, .173 }, { ssrx, .155 }, H };
N l1n188[] = { { sgrn, .466 }, H };
N l1n189[] = { { syv, .403 }, { srnc3, .380 }, { srxig, .449 }, { sxix, .138 }, H };
N l1n190[] = { { srnc3ab, .506 }, { sgrkX, .449 }, { sgqir, .242 }, H };
N l1n191[] = { { ssr, .253 }, { sgxX, .259 }, { s7am, .081 }, H };
N l1n193[] = { { sxi, .852 }, { svc3, .380 }, { smn, .081 }, H };
N l1n194[] = { { sguc3, .362 }, H };
N l1n195[] = { { sguc3ab, .483 }, { srX, .115 }, { sgYc3, .233 }, { svmx, .138 }, H };
N l1n196[] = { { sgYc3ab, .311 }, H };
N l1n197[] = { { syrh, .155 }, H };
N l1n198[] = { { soXg, .233 }, H };
N l1n199[] = { { svm, .541 }, { sgrhs, .276 }, H };
N l1n200[] = { { sgl, .259 }, H };
N l1n201[] = { { snc3, .322 }, { sXn, .207 }, { spi, .115 }, H };
N l1n202[] = { { sgmw, .311 }, { sabvm, .233 }, { sabxc3, .181 }, H };
N l1n203[] = { { smxg, .440 }, { snmx, .173 }, { sjX, .092 }, { sabxc3ab, .242 }, H };
N l1n205[] = { { siv, .288 }, H };
N l1n206[] = { { sqirh, .184 }, H };
N l1n207[] = { { snm, .150 }, { sug, .104 }, H };
N l1n209[] = { { swlx, .898 }, { sxy, .173 }, { sYc3, .127 }, { shi, .104 }, H };
N l1n210[] = { { smwl, .673 }, { smo, .196 }, H };
N l1n211[] = { { sgc3, .173 }, H };
N l1n212[] = { { sgqig, .621 }, { sXxc3, .224 }, { sgXm, .181 }, { sgtXw, .242 }, H };
N l1n213[] = { { sabg, 5.541 }, { swl, 1.024 }, { sirh, .242 }, { sXxc3ab, .299 }, H };
N l1n215[] = { { smg, 1.346 }, { sgomw, .449 }, { sYm, .092 }, H };
N l1n217[] = { { sgm, .587 }, { smoy, .104 }, H };
N l1n218[] = { { sgwi, .259 }, { sXo, .104 }, H };
N l1n219[] = { { slin, .224 }, H };
N l1n220[] = { { stc3ab, .725 }, H };
N l1n221[] = { { sxXg, .285 }, H };
N l1n222[] = { { sc3abv, 2.913 }, { siw, .242 }, H };
N l1n223[] = { { sXg, 1.433 }, { somw, .259 }, { sqc3abg, .449 }, H };
N l1n224[] = { { swc3, .161 }, H };
N l1n225[] = { { shy, .081 }, { sabp, .104 }, H };
N l1n226[] = { { syXvg, .345 }, H };
N l1n227[] = { { smp, .196 }, { smxl, .155 }, H };
N l1n228[] = { { slc3ab, .190 }, { sgwc3, .155 }, H };
N l1n229[] = { { sknc3ab, .138 }, H };
N l1n230[] = { { swm, .276 }, H };
N l1n231[] = { { stXv, .121 }, H };
N l1n232[] = { { sqi, .472 }, { soc3, .265 }, H };
N l1n233[] = { { sc3abw, 1.049 }, H };
N l1n234[] = { { skX, .161 }, { spz, .115 }, { sgn, .155 }, { ssrxi, .161 }, H };
N l1n235[] = { { sgxi, .285 }, { snig, .233 }, { sXp, .104 }, H };
N l1n236[] = { { swmpz, .230 }, H };
N l1n238[] = { { svg, 1.105 }, { som, .219 }, { sslin, .207 }, H };
N l1n239[] = { { six, .495 }, { sts, .219 }, H };
N l1n240[] = { { sXrmg, .207 }, H };
N l1n242[] = { { sabq, .138 }, { stXw, .121 }, H };
N l1n244[] = { { sxl, .242 }, { smq, .219 }, { sc3abx, .621 }, H };
N l1n245[] = { { sgxc3, 1.605 }, { sgig, 1.269 }, { smpz, .173 }, H };
N l1n246[] = { { sgxc3ab, 2.140 }, { srh, .529 }, { sng, .621 }, { sgqmv, .276 }, { sgZm, .155 }, { sZm, .069 }, H };
N l1n248[] = { { sc3ab, 9.917 }, H };
N l1n250[] = { { sg7a, .138 }, H };
N l1n251[] = { { sgo, 1.208 }, { sgwl, .621 }, { suc3ab, .293 }, { szix, .173 }, H };
N l1n252[] = { { sghl, .337 }, H };
N l1n254[] = { { src3abg, 1.001 }, H };
N l1n255[] = { { sxc3, 1.369 }, { szi, .230 }, H };

D l1_d = {
	"albanian",
	"utf8",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.005, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.123, 0.019, 0.006, 0.053, 0.174, 0.013, 0.031, 0.086, 0.142, 0.073, 0.060, 0.041, 0.058, 0.112, 0.057,
	    0.055, 0.019, 0.128, 0.104, 0.164, 0.060, 0.021, 0.000, 0.002, 0.009, 0.014, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, 0.001, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, 0.012, Y, Y, Y, 0.264, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, 0.416, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l1n0, l1n1, l1n2, l1n3, l1n4, l1n5, l1n6, l1n7, X, l1n9, X, l1n11, l1n12, l1n13, X, X,
	    l1n16, l1n17, l1n18, X, X, l1n21, l1n22, l1n23, l1n24, l1n25, l1n26, l1n27, X, l1n29, X, l1n31,
	    X, l1n33, l1n34, l1n35, X, l1n37, l1n38, l1n39, X, l1n41, l1n42, l1n43, l1n44, l1n45, l1n46, l1n47,
	    X, l1n49, l1n50, X, l1n52, l1n53, l1n54, l1n55, X, l1n57, l1n58, l1n59, l1n60, l1n61, l1n62, l1n63,
	    l1n64, l1n65, l1n66, X, X, l1n69, l1n70, l1n71, l1n72, l1n73, l1n74, l1n75, l1n76, l1n77, X, l1n79,
	    l1n80, l1n81, X, l1n83, l1n84, l1n85, l1n86, l1n87, l1n88, l1n89, l1n90, l1n91, l1n92, l1n93, l1n94, X,
	    l1n96, l1n97, l1n98, l1n99, l1n100, l1n101, l1n102, l1n103, l1n104, l1n105, X, l1n107, l1n108, X, X, X,
	    l1n112, l1n113, l1n114, l1n115, l1n116, l1n117, l1n118, l1n119, X, l1n121, l1n122, l1n123, X, l1n125, l1n126, l1n127,
	    l1n128, X, l1n130, l1n131, l1n132, l1n133, X, X, X, l1n137, l1n138, l1n139, X, X, l1n142, l1n143,
	    l1n144, l1n145, X, X, l1n148, l1n149, l1n150, X, X, l1n153, X, l1n155, l1n156, l1n157, l1n158, l1n159,
	    l1n160, l1n161, l1n162, l1n163, l1n164, l1n165, l1n166, l1n167, X, X, l1n170, l1n171, l1n172, l1n173, l1n174, X,
	    l1n176, l1n177, l1n178, X, l1n180, l1n181, l1n182, l1n183, l1n184, X, l1n186, l1n187, l1n188, l1n189, l1n190, l1n191,
	    X, l1n193, l1n194, l1n195, l1n196, l1n197, l1n198, l1n199, l1n200, l1n201, l1n202, l1n203, X, l1n205, l1n206, l1n207,
	    X, l1n209, l1n210, l1n211, l1n212, l1n213, X, l1n215, X, l1n217, l1n218, l1n219, l1n220, l1n221, l1n222, l1n223,
	    l1n224, l1n225, l1n226, l1n227, l1n228, l1n229, l1n230, l1n231, l1n232, l1n233, l1n234, l1n235, l1n236, X, l1n238, l1n239,
	    l1n240, X, l1n242, X, l1n244, l1n245, l1n246, X, l1n248, X, l1n250, l1n251, l1n252, X, l1n254, l1n255 }
};

//
// Lng: arabic
// Enc: iso-8859-6
//

S sIa7[] = { 216, 167, 0 };
S sgI[] = { 32, 216, 0 };
S sJ84[] = { 217, 132, 0 };
S sIa7J[] = { 216, 167, 217, 0 };
S sa7J[] = { 167, 217, 0 };
S sgJ[] = { 32, 217, 0 };
S sIa7J84[] = { 216, 167, 217, 132, 0 };
S sa7J84[] = { 167, 217, 132, 0 };
S sgIa7[] = { 32, 216, 167, 0 };
S sJ8a[] = { 217, 138, 0 };
S sJ85[] = { 217, 133, 0 };
S sgIa7J[] = { 32, 216, 167, 217, 0 };
S s84I[] = { 132, 216, 0 };
S sJ84I[] = { 217, 132, 216, 0 };
S sJ88[] = { 217, 136, 0 };
S sIaa[] = { 216, 170, 0 };
S sa7I[] = { 167, 216, 0 };
S sIa7I[] = { 216, 167, 216, 0 };
S sa7J84I[] = { 167, 217, 132, 216, 0 };
S sJ86[] = { 217, 134, 0 };
S sa9g[] = { 169, a };
S sIa9g[] = { 216, 169, a };
S sIa9[] = { 216, 169, 0 };
S sIb1[] = { 216, 177, 0 };
S sJ8aI[] = { 217, 138, 216, 0 };
S s8aI[] = { 138, 216, 0 };
S sIb9[] = { 216, 185, 0 };
S s85I[] = { 133, 216, 0 };
S sJ85I[] = { 217, 133, 216, 0 };
S s84J[] = { 132, 217, 0 };
S sJ84J[] = { 217, 132, 217, 0 };
S sIa8[] = { 216, 168, 0 };
S sgc7[] = { 32, 199, 0 };
S sc7U[] = { 199, 228, 0 };
S sJ83[] = { 217, 131, 0 };
S sgc7U[] = { 32, 199, 228, 0 };
S sJ88J[] = { 217, 136, 217, 0 };
S s88J[] = { 136, 217, 0 };
S sgJ88[] = { 32, 217, 136, 0 };
S sa7J84J[] = { 167, 217, 132, 217, 0 };
S sgJ85[] = { 32, 217, 133, 0 };
S s85J[] = { 133, 217, 0 };
S sJ85J[] = { 217, 133, 217, 0 };
S sIa7g[] = { 216, 167, a };
S saaI[] = { 170, 216, 0 };
S sIaf[] = { 216, 175, 0 };
S sIaaI[] = { 216, 170, 216, 0 };
S sa7g[] = { 167, a };
S sJ81[] = { 217, 129, 0 };
S sb9J[] = { 185, 217, 0 };
S sJ84Ia7[] = { 217, 132, 216, 167, 0 };
S s84Ia7[] = { 132, 216, 167, 0 };
S sIb9J[] = { 216, 185, 217, 0 };
S sIa8I[] = { 216, 168, 216, 0 };
S sa8I[] = { 168, 216, 0 };
S s86g[] = { 134, a };
S sIb1J[] = { 216, 177, 217, 0 };
S s86I[] = { 134, 216, 0 };
S sJ86g[] = { 217, 134, a };
S sb1J[] = { 177, 217, 0 };
S sJ86I[] = { 217, 134, 216, 0 };
S sIb3[] = { 216, 179, 0 };
S sJ88I[] = { 217, 136, 216, 0 };
S s88I[] = { 136, 216, 0 };
S sc7g[] = { 199, a };
S sWg[] = { 230, a };
S saaJ[] = { 170, 217, 0 };
S sIaaJ[] = { 216, 170, 217, 0 };
S sIad[] = { 216, 173, 0 };
S s8aIa9[] = { 138, 216, 169, 0 };
S sJ8aIa9[] = { 217, 138, 216, 169, 0 };
S s8aIa9g[] = { 138, 216, 169, a };
S sIb1I[] = { 216, 177, 216, 0 };
S s8ag[] = { 138, a };
S sb1I[] = { 177, 216, 0 };
S sJ8ag[] = { 217, 138, a };
S sJ87[] = { 217, 135, 0 };
S sIa8J[] = { 216, 168, 217, 0 };
S sa8J[] = { 168, 217, 0 };
S sIaag[] = { 216, 170, a };
S sgIa8[] = { 32, 216, 168, 0 };
S s84g[] = { 132, a };
S saag[] = { 170, a };
S sJ84g[] = { 217, 132, a };
S sJ83I[] = { 217, 131, 216, 0 };
S s83I[] = { 131, 216, 0 };
S sIa7J86[] = { 216, 167, 217, 134, 0 };
S sa7Iaa[] = { 167, 216, 170, 0 };
S sIa7Iaa[] = { 216, 167, 216, 170, 0 };
S s85Ia7[] = { 133, 216, 167, 0 };
S s83J[] = { 131, 217, 0 };
S sge8[] = { 32, 232, 0 };
S sJ85Ia7[] = { 217, 133, 216, 167, 0 };
S sJ83J[] = { 217, 131, 217, 0 };
S sa7J86[] = { 167, 217, 134, 0 };
S sJ8aJ[] = { 217, 138, 217, 0 };
S s8aJ[] = { 138, 217, 0 };
S sgJ85I[] = { 32, 217, 133, 216, 0 };
S sIb4[] = { 216, 180, 0 };
S sIb9I[] = { 216, 185, 216, 0 };
S sIb3I[] = { 216, 179, 216, 0 };
S sb9I[] = { 185, 216, 0 };
S sb3I[] = { 179, 216, 0 };
S sa7J85[] = { 167, 217, 133, 0 };
S sIa7J85[] = { 216, 167, 217, 133, 0 };
S s84J85[] = { 132, 217, 133, 0 };
S s88g[] = { 136, a };
S sJ84J85[] = { 217, 132, 217, 133, 0 };
S sgJ85J[] = { 32, 217, 133, 217, 0 };
S sJ88g[] = { 217, 136, a };
S sJ82[] = { 217, 130, 0 };
S sgIa8I[] = { 32, 216, 168, 216, 0 };
S s89g[] = { 137, a };
S sgV[] = { 32, 229, 0 };
S sJ89g[] = { 217, 137, a };
S sJ89[] = { 217, 137, 0 };
S s81J[] = { 129, 217, 0 };
S sJ81J[] = { 217, 129, 217, 0 };
S s87I[] = { 135, 216, 0 };
S sJ87I[] = { 217, 135, 216, 0 };
S sadI[] = { 173, 216, 0 };
S sIafI[] = { 216, 175, 216, 0 };
S sIac[] = { 216, 172, 0 };
S sgJ88g[] = { 32, 217, 136, a };
S sIadI[] = { 216, 173, 216, 0 };
S safI[] = { 175, 216, 0 };
S s8aIb1[] = { 138, 216, 177, 0 };
S seeg[] = { 238, a };
S s84Iaa[] = { 132, 216, 170, 0 };
S s84Ia7I[] = { 132, 216, 167, 216, 0 };
S sIb1g[] = { 216, 177, a };
S sb1g[] = { 177, a };
S sJ8aIb1[] = { 217, 138, 216, 177, 0 };
S sJ84Iaa[] = { 217, 132, 216, 170, 0 };
S sgJ81[] = { 32, 217, 129, 0 };
S sgJ81J[] = { 32, 217, 129, 217, 0 };
S sa7Iaag[] = { 167, 216, 170, a };
S sJ81J8a[] = { 217, 129, 217, 138, 0 };
S sb9g[] = { 185, a };
S sIb9g[] = { 216, 185, a };
S s81J8a[] = { 129, 217, 138, 0 };
S sIb6[] = { 216, 182, 0 };
S s84Ia7J[] = { 132, 216, 167, 217, 0 };
S sIab[] = { 216, 171, 0 };
S sgJ84[] = { 32, 217, 132, 0 };
S sIb9J84[] = { 216, 185, 217, 132, 0 };
S sgJ88J[] = { 32, 217, 136, 217, 0 };
S sJ81I[] = { 217, 129, 216, 0 };
S s81I[] = { 129, 216, 0 };
S sb9J84[] = { 185, 217, 132, 0 };
S s86J[] = { 134, 217, 0 };
S sIb5[] = { 216, 181, 0 };
S sJ86J[] = { 217, 134, 217, 0 };
S sb1J8a[] = { 177, 217, 138, 0 };
S sIa3[] = { 216, 163, 0 };
S seag[] = { 234, a };
S sIb1J8a[] = { 216, 177, 217, 138, 0 };
S s87Ia7[] = { 135, 216, 167, 0 };
S sIa7Ib1[] = { 216, 167, 216, 177, 0 };
S sJ87Ia7[] = { 217, 135, 216, 167, 0 };
S sgIaa[] = { 32, 216, 170, 0 };
S sgJ88I[] = { 32, 217, 136, 216, 0 };
S sa7Ib1[] = { 167, 216, 177, 0 };
S se8cf[] = { 232, 207, 0 };
S sb9J84J[] = { 185, 217, 132, 217, 0 };
S scce8cf[] = { 204, 232, 207, 0 };
S sUe8[] = { 228, 232, 0 };
S s88Ia7[] = { 136, 216, 167, 0 };
S sIb6I[] = { 216, 182, 216, 0 };
S s84J85I[] = { 132, 217, 133, 216, 0 };
S sIafJ[] = { 216, 175, 217, 0 };
S scce8[] = { 204, 232, 0 };
S sb4I[] = { 180, 216, 0 };
S s81J8ag[] = { 129, 217, 138, a };
S sAc7[] = { 208, 199, 0 };
S sgIb9[] = { 32, 216, 185, 0 };
S sJ88Ia7[] = { 217, 136, 216, 167, 0 };
S sadJ[] = { 173, 217, 0 };
S s82I[] = { 130, 216, 0 };
S se8cce8[] = { 232, 204, 232, 0 };
S safJ[] = { 175, 217, 0 };
S se8cc[] = { 232, 204, 0 };
S se8cfg[] = { 232, 207, a };
S sIadJ[] = { 216, 173, 217, 0 };
S se8cce8cf[] = { 232, 204, 232, 207, 0 };
S sb6I[] = { 182, 216, 0 };
S sIb4I[] = { 216, 180, 216, 0 };
S scfg[] = { 207, a };
S sJ82I[] = { 217, 130, 216, 0 };
S sJ88J85[] = { 217, 136, 217, 133, 0 };
S s84J8a[] = { 132, 217, 138, 0 };
S sJ84J8a[] = { 217, 132, 217, 138, 0 };
S sa7J86g[] = { 167, 217, 134, a };
S s85Ib9[] = { 133, 216, 185, 0 };
S sIa7Ib3[] = { 216, 167, 216, 179, 0 };
S sa7J85J[] = { 167, 217, 133, 217, 0 };
S sgc7Ue8[] = { 32, 199, 228, 232, 0 };
S sa7Ib3[] = { 167, 216, 179, 0 };
S sf2g[] = { 242, a };
S s87Ia7g[] = { 135, 216, 167, a };
S sJ85Ib9[] = { 217, 133, 216, 185, 0 };
S s85g[] = { 133, a };
S sc7Ue8[] = { 199, 228, 232, 0 };
S sJU[] = { 217, 228, 0 };
S s88J85[] = { 136, 217, 133, 0 };
S sJ85g[] = { 217, 133, a };
S sJ8aIa7[] = { 217, 138, 216, 167, 0 };
S s8aIa7[] = { 138, 216, 167, 0 };
S sIa7Ib9[] = { 216, 167, 216, 185, 0 };
S s84J89g[] = { 132, 217, 137, a };
S s84J89[] = { 132, 217, 137, 0 };
S sa7Ib9[] = { 167, 216, 185, 0 };
S sIb1Ia7[] = { 216, 177, 216, 167, 0 };
S sb1Ia7[] = { 177, 216, 167, 0 };
S sJ84J89[] = { 217, 132, 217, 137, 0 };
S scce8cfg[] = { 204, 232, 207, a };
S sa8Ia7[] = { 168, 216, 167, 0 };
S sIae[] = { 216, 174, 0 };
S sUc7[] = { 228, 199, 0 };
S sUg[] = { 228, a };
S s85J86[] = { 133, 217, 134, 0 };
S sb1J8aI[] = { 177, 217, 138, 216, 0 };
S sJ86Iaa[] = { 217, 134, 216, 170, 0 };
S sIa8Ia7[] = { 216, 168, 216, 167, 0 };
S s83Ia7[] = { 131, 216, 167, 0 };
S sIb3J[] = { 216, 179, 217, 0 };
S se8c7[] = { 232, 199, 0 };
S sJ88J86[] = { 217, 136, 217, 134, 0 };
S sb3Iaa[] = { 179, 216, 170, 0 };
S sJ83Ia7[] = { 217, 131, 216, 167, 0 };
S s86Ia7[] = { 134, 216, 167, 0 };
S sIaaIb1[] = { 216, 170, 216, 177, 0 };
S sJ85J86[] = { 217, 133, 217, 134, 0 };
S sIaeI[] = { 216, 174, 216, 0 };
S sIb3Iaa[] = { 216, 179, 216, 170, 0 };
S sa7Ib3I[] = { 167, 216, 179, 216, 0 };
S sgIb9J[] = { 32, 216, 185, 217, 0 };
S s86Iaa[] = { 134, 216, 170, 0 };
S sb3J[] = { 179, 217, 0 };
S sJ86Ia7[] = { 217, 134, 216, 167, 0 };
S s88J86[] = { 136, 217, 134, 0 };
S sIb2[] = { 216, 178, 0 };
S saeI[] = { 174, 216, 0 };
S saaIb1[] = { 170, 216, 177, 0 };
S sgIa7I[] = { 32, 216, 167, 216, 0 };
S sa3I[] = { 163, 216, 0 };
S sacI[] = { 172, 216, 0 };
S sIa3I[] = { 216, 163, 216, 0 };
S sb4J[] = { 180, 217, 0 };
S sIb4J[] = { 216, 180, 217, 0 };
S sgJ83[] = { 32, 217, 131, 0 };
S s84IaaJ[] = { 132, 216, 170, 217, 0 };
S se7g[] = { 231, a };
S s85J8a[] = { 133, 217, 138, 0 };
S s84J83[] = { 132, 217, 131, 0 };
S s86IaaI[] = { 134, 216, 170, 216, 0 };
S sUe8cce8[] = { 228, 232, 204, 232, 0 };
S s84Ib9[] = { 132, 216, 185, 0 };
S se9g[] = { 233, a };
S sIafg[] = { 216, 175, a };
S s88J85I[] = { 136, 217, 133, 216, 0 };
S se7c7[] = { 231, 199, 0 };
S sc7W[] = { 199, 230, 0 };
S sIb0[] = { 216, 176, 0 };
S s85Ia7g[] = { 133, 216, 167, a };
S sIba[] = { 216, 186, 0 };
S sUe8cc[] = { 228, 232, 204, 0 };
S safg[] = { 175, a };
S s85J86g[] = { 133, 217, 134, a };
S sgR[] = { 32, 225, 0 };
S sJ84Ib9[] = { 217, 132, 216, 185, 0 };
S sJ84J83[] = { 217, 132, 217, 131, 0 };
S s85Ib9J[] = { 133, 216, 185, 217, 0 };
S sUV[] = { 228, 229, 0 };
S sBg[] = { 209, a };
S sc7Ue8cc[] = { 199, 228, 232, 204, 0 };
S se7c7g[] = { 231, 199, a };
S sJ85J8a[] = { 217, 133, 217, 138, 0 };
S sIb7[] = { 216, 183, 0 };
S sgJ84J[] = { 32, 217, 132, 217, 0 };
S s8aIb1g[] = { 138, 216, 177, a };
S s83Ia7J[] = { 131, 216, 167, 217, 0 };
S sb1Ia7I[] = { 177, 216, 167, 216, 0 };
S s84Ia9[] = { 132, 216, 169, 0 };
S sb9Ia7[] = { 185, 216, 167, 0 };
S sc7UV[] = { 199, 228, 229, 0 };
S sgea[] = { 32, 234, 0 };
S sJ87J[] = { 217, 135, 217, 0 };
S s88Ia7J[] = { 136, 216, 167, 217, 0 };
S sJ81Ia9[] = { 217, 129, 216, 169, 0 };
S s83g[] = { 131, a };
S sb9J8a[] = { 185, 217, 138, 0 };
S scdc7[] = { 205, 199, 0 };
S sIb9J8a[] = { 216, 185, 217, 138, 0 };
S s88J84[] = { 136, 217, 132, 0 };
S sIadJ8a[] = { 216, 173, 217, 138, 0 };
S s84Iad[] = { 132, 216, 173, 0 };
S sa7J86I[] = { 167, 217, 134, 216, 0 };
S s87J[] = { 135, 217, 0 };
S sgc7UV[] = { 32, 199, 228, 229, 0 };
S sgJ8a[] = { 32, 217, 138, 0 };
S s8aIa7I[] = { 138, 216, 167, 216, 0 };
S s81Ia9[] = { 129, 216, 169, 0 };
S sadJ8a[] = { 173, 217, 138, 0 };
S sRea[] = { 225, 234, 0 };
S sacg[] = { 172, a };
S sb5I[] = { 181, 216, 0 };
S sIb9Ia7[] = { 216, 185, 216, 167, 0 };
S sb6Ia7[] = { 182, 216, 167, 0 };
S saaIa7[] = { 170, 216, 167, 0 };
S sgIaaJ[] = { 32, 216, 170, 217, 0 };
S sJ88J84[] = { 217, 136, 217, 132, 0 };
S sJ83g[] = { 217, 131, a };
S sIb5I[] = { 216, 181, 216, 0 };
S sJ84Iad[] = { 217, 132, 216, 173, 0 };
S sIacI[] = { 216, 172, 216, 0 };
S sIaaIa7[] = { 216, 170, 216, 167, 0 };
S se8W[] = { 232, 230, 0 };
S s84Ia9g[] = { 132, 216, 169, a };
S sIb6Ia7[] = { 216, 182, 216, 167, 0 };
S sadJ8aI[] = { 173, 217, 138, 216, 0 };
S sc7ca[] = { 199, 202, 0 };
S sJ84Ia9[] = { 217, 132, 216, 169, 0 };
S s81Ia9g[] = { 129, 216, 169, a };
S s84J88[] = { 132, 217, 136, 0 };
S sb5J[] = { 181, 217, 0 };
S sgc7W[] = { 32, 199, 230, 0 };
S sgIb3[] = { 32, 216, 179, 0 };
S sIb5J[] = { 216, 181, 217, 0 };
S sgc7UJ[] = { 32, 199, 228, 217, 0 };
S sVc7[] = { 229, 199, 0 };
S sa8Ib9[] = { 168, 216, 185, 0 };
S seae7[] = { 234, 231, 0 };
S saaIadI[] = { 170, 216, 173, 216, 0 };
S s83J88[] = { 131, 217, 136, 0 };
S sIadIa7[] = { 216, 173, 216, 167, 0 };
S sIb4J83[] = { 216, 180, 217, 131, 0 };
S sIb1J86[] = { 216, 177, 217, 134, 0 };
S sJ88J81[] = { 217, 136, 217, 129, 0 };
S sb1J86[] = { 177, 217, 134, 0 };
S sUe9[] = { 228, 233, 0 };
S sJ85J84[] = { 217, 133, 217, 132, 0 };
S sIa8Ib9[] = { 216, 168, 216, 185, 0 };
S sVWg[] = { 229, 230, a };
S sacJ[] = { 172, 217, 0 };
S sVW[] = { 229, 230, 0 };
S se8U[] = { 232, 228, 0 };
S sgJ84I[] = { 32, 217, 132, 216, 0 };
S sIaaJ8a[] = { 216, 170, 217, 138, 0 };
S sb1Ia9g[] = { 177, 216, 169, a };
S s85Ia7J[] = { 133, 216, 167, 217, 0 };
S sJ8aIaa[] = { 217, 138, 216, 170, 0 };
S sb1Ia9[] = { 177, 216, 169, 0 };
S sIbaJ[] = { 216, 186, 217, 0 };
S sc8g[] = { 200, a };
S s85Ib3[] = { 133, 216, 179, 0 };
S sf0g[] = { 240, a };
S sa7J85I[] = { 167, 217, 133, 216, 0 };
S sUe9g[] = { 228, 233, a };
S sb4J83[] = { 180, 217, 131, 0 };
S s86J8a[] = { 134, 217, 138, 0 };
S sgca[] = { 32, 202, 0 };
S s8aIaa[] = { 138, 216, 170, 0 };
S s84Ib9I[] = { 132, 216, 185, 216, 0 };
S saaIad[] = { 170, 216, 173, 0 };
S sIacJ[] = { 216, 172, 217, 0 };
S seaW[] = { 234, 230, 0 };
S sJ86J8a[] = { 217, 134, 217, 138, 0 };
S se8Wg[] = { 232, 230, a };
S s85Ia7I[] = { 133, 216, 167, 216, 0 };
S sadIa7[] = { 173, 216, 167, 0 };
S sIa8J8a[] = { 216, 168, 217, 138, 0 };
S s85J84[] = { 133, 217, 132, 0 };
S sIb1Ia9[] = { 216, 177, 216, 169, 0 };
S sJ84J88[] = { 217, 132, 217, 136, 0 };
S s85Ib3I[] = { 133, 216, 179, 216, 0 };
S sUJ[] = { 228, 217, 0 };
S s84J8aI[] = { 132, 217, 138, 216, 0 };
S saaJ8a[] = { 170, 217, 138, 0 };
S sa8J8a[] = { 168, 217, 138, 0 };
S s84Ia7g[] = { 132, 216, 167, a };
S sc7Wg[] = { 199, 230, a };
S sge7[] = { 32, 231, 0 };
S sa7Ib9J[] = { 167, 216, 185, 217, 0 };
S sbaJ[] = { 186, 217, 0 };
S sacIa7[] = { 172, 216, 167, 0 };
S sc7UJ[] = { 199, 228, 217, 0 };
S s88J81[] = { 136, 217, 129, 0 };
S sAc7g[] = { 208, 199, a };
S sadIaf[] = { 173, 216, 175, 0 };
S sIacIa7[] = { 216, 172, 216, 167, 0 };
S s83J88J[] = { 131, 217, 136, 217, 0 };
S sJ83J88[] = { 217, 131, 217, 136, 0 };
S sb9J8aI[] = { 185, 217, 138, 216, 0 };
S sIaaIad[] = { 216, 170, 216, 173, 0 };
S sgIad[] = { 32, 216, 173, 0 };
S sIadIaf[] = { 216, 173, 216, 175, 0 };
S sJ85Ib3[] = { 217, 133, 216, 179, 0 };
S sgU[] = { 32, 228, 0 };

N l2n0[] = { { sgJ85, 1.006 }, { s85Ia7g, .435 }, H };
N l2n1[] = { { scce8cf, .449 }, { sJ85J86, .489 }, { sVW, .163 }, H };
N l2n4[] = { { sUe8, .299 }, { sgU, .109 }, H };
N l2n5[] = { { sb3I, .344 }, { sUJ, .163 }, H };
N l2n6[] = { { s84J83, .217 }, H };
N l2n7[] = { { sb9J84J, .399 }, H };
N l2n8[] = { { s81J, .308 }, H };
N l2n9[] = { { s84Ia7I, .544 }, { se8cce8cf, .598 }, { s8aIb1g, .381 }, H };
N l2n10[] = { { scdc7, .190 }, { sb1Ia9, .163 }, H };
N l2n11[] = { { sJ84, 5.084 }, { sIb3, .843 }, H };
N l2n12[] = { { s84Ia7J, .471 }, H };
N l2n13[] = { { sJ85J8a, .435 }, H };
N l2n14[] = { { s8aI, 1.269 }, H };
N l2n15[] = { { sIafI, .652 }, { sa7Ib9J, .217 }, H };
N l2n17[] = { { sgIaaJ, .254 }, H };
N l2n20[] = { { sc7UV, .285 }, H };
N l2n21[] = { { sgV, .308 }, { sa3I, .145 }, { sUe9, .163 }, H };
N l2n22[] = { { s82I, .199 }, { sb3J, .163 }, H };
N l2n23[] = { { sgc7, .942 }, H };
N l2n25[] = { { se7g, .326 }, H };
N l2n26[] = { { sIafJ, .449 }, H };
N l2n27[] = { { sJ81Ia9, .381 }, { saaIa7, .190 }, H };
N l2n28[] = { { sJ85, 2.990 }, { s84g, .598 }, { sIb4, .517 }, { s84J85, .489 }, { scce8, .299 }, H };
N l2n30[] = { { sIa7J84, 6.579 }, { s83J88, .163 }, { sJ86J8a, .326 }, H };
N l2n31[] = { { s8aJ, .344 }, H };
N l2n32[] = { { sJ81I, .530 }, { s88J85I, .290 }, H };
N l2n33[] = { { sgJ88, 1.115 }, { sIa7J85, 1.033 }, H };
N l2n36[] = { { sIa7J86, 1.087 }, { sb4I, .199 }, { s85Ib3, .163 }, H };
N l2n37[] = { { sJ88J81, .326 }, H };
N l2n38[] = { { sIb1Ia7, .544 }, H };
N l2n39[] = { { sIafg, .489 }, H };
N l2n40[] = { { s85Ia7I, .217 }, H };
N l2n43[] = { { sJ81J, .693 }, { sgIb9, .299 }, { s85Ia7J, .217 }, H };
N l2n44[] = { { sa7Ib1, .326 }, { sacI, .145 }, { sIb1Ia9, .326 }, H };
N l2n45[] = { { sJ86, 2.093 }, { sIb5, .353 }, { s84IaaJ, .290 }, H };
N l2n46[] = { { sJ88J84, .381 }, H };
N l2n48[] = { { se7c7, .217 }, { sf0g, .245 }, { s85J84, .163 }, H };
N l2n49[] = { { sIb1I, .979 }, { scfg, .449 }, { sJ82I, .449 }, { sJ88J85, .544 }, H };
N l2n52[] = { { sJ88J86, .489 }, H };
N l2n53[] = { { s83I, .381 }, { sc7Ue8, .408 }, { sb4J, .145 }, H };
N l2n55[] = { { se8cfg, .673 }, { sJ83Ia7, .489 }, { sgJ8a, .190 }, { sge7, .109 }, H };
N l2n56[] = { { sgI, 3.752 }, H };
N l2n57[] = { { sc7g, 1.183 }, H };
N l2n58[] = { { s81Ia9, .190 }, H };
N l2n59[] = { { s85g, .272 }, { s8aIa7, .272 }, H };
N l2n60[] = { { sIb1J, 1.305 }, { se8U, .163 }, H };
N l2n61[] = { { sc7U, 1.386 }, { s84J88, .163 }, { sacJ, .109 }, H };
N l2n62[] = { { sJ87, .652 }, { sIb6, .381 }, { s87Ia7g, .544 }, H };
N l2n63[] = { { sIa7, 8.074 }, { sa7Iaag, .761 }, H };
N l2n65[] = { { sIa8J8a, .326 }, H };
N l2n66[] = { { sJ83I, .856 }, { sa7Ib3, .272 }, H };
N l2n67[] = { { sIa3I, .326 }, { sb5I, .127 }, H };
N l2n70[] = { { s83J, .362 }, { s85J86, .245 }, { sb9J8aI, .217 }, H };
N l2n71[] = { { s84Ib9, .217 }, H };
N l2n72[] = { { sJ84Ia7, 1.849 }, { sge8, .362 }, { s84J89, .272 }, H };
N l2n73[] = { { sgJ, 2.483 }, { sIb1g, .918 }, H };
N l2n74[] = { { sadJ8a, .190 }, { sgca, .109 }, H };
N l2n75[] = { { sadI, .290 }, H };
N l2n77[] = { { sJ83J, .816 }, H };
N l2n78[] = { { sa7J84, 3.289 }, { sb1J8aI, .326 }, { sJ84Ia9, .381 }, H };
N l2n79[] = { { sJ88, 2.501 }, { se8c7, .245 }, { sIb7, .190 }, H };
N l2n80[] = { { sIa8, 1.577 }, { sIb9J84, .707 }, H };
N l2n81[] = { { s8aIa9, .707 }, { sJ84Iaa, .816 }, { sIb3Iaa, .489 }, { safg, .217 }, H };
N l2n83[] = { { sJ84I, 4.159 }, { sIb3I, .775 }, { s84J8a, .272 }, { sb3Iaa, .245 }, H };
N l2n84[] = { { s84I, 1.849 }, { sb5J, .109 }, H };
N l2n86[] = { { s81J8ag, .598 }, H };
N l2n87[] = { { se9g, .326 }, H };
N l2n88[] = { { sc8g, .245 }, H };
N l2n89[] = { { sa7g, .951 }, { sJ85Ia7, 1.087 }, { sa7J85, .517 }, { sacIa7, .163 }, H };
N l2n90[] = { { s86g, .870 }, { sJ83g, .428 }, { sJ84Iad, .381 }, H };
N l2n92[] = { { sadJ, .199 }, { s8aIaa, .163 }, H };
N l2n93[] = { { saaIad, .163 }, H };
N l2n94[] = { { sJ84J, 2.569 }, { sIb3J, .367 }, { se8W, .190 }, H };
N l2n95[] = { { sgJ81J, .507 }, { sc7W, .217 }, H };
N l2n96[] = { { sJ89, .462 }, H };
N l2n97[] = { { sIa9, 2.012 }, { scce8cfg, .816 }, { sVWg, .367 }, H };
N l2n98[] = { { sb6I, .199 }, { s83Ia7, .245 }, { sIb9J8a, .381 }, H };
N l2n99[] = { { sIaaJ8a, .326 }, H };
N l2n100[] = { { sJ85I, 2.610 }, { sa7J86, .544 }, { sIb4I, .449 }, H };
N l2n101[] = { { sgIa7, 3.154 }, { s84J, 1.142 }, H };
N l2n102[] = { { s85Ib9, .272 }, H };
N l2n103[] = { { sAc7, .299 }, H };
N l2n104[] = { { s86IaaI, .290 }, H };
N l2n106[] = { { sJ86Ia7, .489 }, { saeI, .163 }, { sgea, .127 }, { sb1Ia9g, .326 }, H };
N l2n107[] = { { sJ84g, 1.346 }, { sJU, .272 }, H };
N l2n108[] = { { s88J81, .163 }, H };
N l2n110[] = { { sf2g, .408 }, { sgc7UJ, .217 }, H };
N l2n111[] = { { sJ85J, 1.468 }, { sIb4J, .326 }, { sBg, .326 }, H };
N l2n112[] = { { sgIa8, .598 }, H };
N l2n113[] = { { sJ8a, 3.072 }, { sIb9, 1.821 }, H };
N l2n114[] = { { sIaa, 2.338 }, { s85J8a, .217 }, H };
N l2n115[] = { { s85I, 1.160 }, { sJ86Iaa, .489 }, H };
N l2n117[] = { { sJ86I, 1.305 }, { sIb5I, .285 }, { sUe9g, .367 }, H };
N l2n118[] = { { seag, .489 }, H };
N l2n120[] = { { sadIa7, .163 }, H };
N l2n123[] = { { sJ87Ia7, .652 }, { sIb6Ia7, .381 }, H };
N l2n124[] = { { sb9J84, .353 }, { sJ85g, .612 }, { sb1Ia7I, .254 }, H };
N l2n125[] = { { sgJ84I, .217 }, { sJ85Ib3, .326 }, H };
N l2n126[] = { { sJ84Ib9, .435 }, H };
N l2n128[] = { { sJ86J, .530 }, { sUe8cce8, .435 }, { sgJ84J, .254 }, { sIb5J, .245 }, H };
N l2n129[] = { { s84Ia7, .924 }, { sgJ88g, .580 }, H };
N l2n130[] = { { sIba, .217 }, H };
N l2n131[] = { { sIab, .353 }, { sc7ca, .190 }, H };
N l2n132[] = { { s85J, .652 }, { sa7Ib9, .272 }, H };
N l2n133[] = { { sIa7Iaa, 1.087 }, H };
N l2n134[] = { { sJ87I, .652 }, { sgIaa, .326 }, { sIb6I, .449 }, H };
N l2n135[] = { { sIa7I, 3.507 }, { sb9g, .381 }, H };
N l2n136[] = { { sgJ85I, .689 }, { s88Ia7J, .254 }, H };
N l2n137[] = { { safI, .290 }, { saaIb1, .245 }, H };
N l2n139[] = { { sgJ85J, .652 }, H };
N l2n140[] = { { sJ88Ia7, .598 }, H };
N l2n141[] = { { sJ86g, 1.957 }, { sIa8Ia7, .489 }, { s88J84, .190 }, H };
N l2n143[] = { { sb1g, .408 }, { sJ85Ib9, .544 }, { sb6Ia7, .190 }, H };
N l2n144[] = { { se7c7g, .489 }, { sc7UJ, .245 }, H };
N l2n145[] = { { sa7I, 1.559 }, { sJ87J, .285 }, { s86J8a, .163 }, H };
N l2n146[] = { { sIa7J, 7.177 }, { s86I, .580 }, { sgc7UV, .254 }, H };
N l2n148[] = { { sIac, .435 }, H };
N l2n150[] = { { sIadJ8a, .381 }, H };
N l2n151[] = { { sa9g, 2.012 }, { sJ88I, 1.264 }, { s84Ia9, .190 }, H };
N l2n152[] = { { sIa8I, 1.346 }, { s88g, .489 }, { s88J85, .272 }, H };
N l2n153[] = { { sc7Ue8cc, .435 }, H };
N l2n154[] = { { sIa7Ib1, .652 }, { safJ, .199 }, { s81Ia9g, .381 }, { sb1J86, .163 }, H };
N l2n155[] = { { sgc7Ue8, .362 }, H };
N l2n156[] = { { se8cce8, .449 }, { seaW, .163 }, H };
N l2n159[] = { { sIa7g, 2.141 }, H };
N l2n160[] = { { s85Ia7, .544 }, { sIa7Ib3, .544 }, H };
N l2n162[] = { { sa7J, 3.190 }, { sJ88J, 1.753 }, { s84Iaa, .408 }, H };
N l2n163[] = { { sIa8J, .938 }, { s86J, .236 }, { s88J86, .245 }, { sa8Ib9, .163 }, H };
N l2n164[] = { { s84J85I, .399 }, { se8cc, .299 }, H };
N l2n165[] = { { sIad, .761 }, H };
N l2n166[] = { { s85J86g, .435 }, H };
N l2n167[] = { { sgIad, .163 }, H };
N l2n168[] = { { s84J89g, .544 }, H };
N l2n169[] = { { s8aIb1, .408 }, { sgJ88I, .435 }, { s83J88J, .217 }, H };
N l2n172[] = { { sgJ88J, .471 }, { s85Ib3I, .217 }, H };
N l2n173[] = { { seae7, .163 }, H };
N l2n174[] = { { sJ8aIa7, .544 }, { sIb9Ia7, .381 }, H };
N l2n175[] = { { sJ88g, 1.101 }, { sIaaIa7, .381 }, { sa8J8a, .163 }, H };
N l2n176[] = { { sa8I, .598 }, H };
N l2n177[] = { { s8aIa9g, 1.414 }, { s87I, .290 }, H };
N l2n178[] = { { sIa7Ib9, .544 }, H };
N l2n180[] = { { sJ8aIa9, 1.414 }, H };
N l2n182[] = { { saag, .598 }, { sIae, .245 }, { sgIb9J, .326 }, H };
N l2n183[] = { { s89g, .462 }, { sJ8aIaa, .326 }, H };
N l2n185[] = { { sJ8aI, 2.854 }, { sIb9I, .775 }, H };
N l2n186[] = { { sIaaI, 1.427 }, H };
N l2n188[] = { { sUg, .367 }, H };
N l2n190[] = { { sb9J8a, .190 }, { se8Wg, .367 }, H };
N l2n191[] = { { sb9I, .344 }, { s86Ia7, .245 }, { sc7Wg, .367 }, H };
N l2n192[] = { { sJ89g, 1.040 }, H };
N l2n193[] = { { sIa9g, 4.526 }, { sa8J, .417 }, { sIaaIad, .326 }, H };
N l2n194[] = { { s87J, .127 }, H };
N l2n195[] = { { s84Iad, .190 }, { s8aIa7I, .254 }, { sIa8Ib9, .326 }, H };
N l2n196[] = { { sIb9J, 1.386 }, { sJ8aJ, .775 }, { sa7J86g, .544 }, H };
N l2n197[] = { { sIaaJ, 1.183 }, H };
N l2n198[] = { { sb1J8a, .326 }, H };
N l2n199[] = { { sIaf, .951 }, { sb1I, .435 }, { sAc7g, .367 }, H };
N l2n200[] = { { sUe8cc, .326 }, H };
N l2n201[] = { { sJ81J8a, .761 }, { sRea, .190 }, H };
N l2n202[] = { { sa7Ib3I, .326 }, H };
N l2n204[] = { { sJ8aIb1, .816 }, H };
N l2n205[] = { { sIaaIb1, .489 }, H };
N l2n206[] = { { sIb1J86, .326 }, H };
N l2n207[] = { { s84Ib9I, .217 }, H };
N l2n208[] = { { sb9J, .616 }, { s88I, .562 }, { sadIaf, .163 }, H };
N l2n209[] = { { sJ8ag, 1.468 }, { sIb9g, .856 }, { sgR, .145 }, { sUV, .217 }, { sIacIa7, .326 }, H };
N l2n210[] = { { sIaag, 1.346 }, { sadJ8aI, .254 }, H };
N l2n211[] = { { sgc3, .236 }, { sUc7, .245 }, H };
N l2n212[] = { { sgJ81, .408 }, H };
N l2n213[] = { { sIbaJ, .245 }, H };
N l2n214[] = { { sa7J84I, 2.864 }, { s8ag, .652 }, { sb4J83, .163 }, H };
N l2n215[] = { { se8cf, .326 }, H };
N l2n216[] = { { sJ81, .924 }, { sb1J, .580 }, { sIb0, .217 }, H };
N l2n217[] = { { sa7J84J, 1.341 }, H };
N l2n218[] = { { sIb1J8a, .652 }, H };
N l2n219[] = { { s84J8aI, .217 }, H };
N l2n220[] = { { sIacI, .285 }, H };
N l2n221[] = { { sa8Ia7, .245 }, H };
N l2n222[] = { { s87Ia7, .326 }, H };
N l2n223[] = { { sa7Iaa, .544 }, H };
N l2n224[] = { { s86Iaa, .245 }, H };
N l2n225[] = { { s88J, .779 }, { sa7J85I, .217 }, { s84Ia7g, .326 }, H };
N l2n226[] = { { sIadIa7, .326 }, H };
N l2n227[] = { { sgc7U, 1.223 }, H };
N l2n228[] = { { sa7J85J, .362 }, H };
N l2n229[] = { { saaIadI, .217 }, { sJ83J88, .326 }, H };
N l2n231[] = { { sJ84J83, .435 }, { sIacJ, .245 }, H };
N l2n233[] = { { sIb1, 1.930 }, { sJ82, .489 }, { sgIb3, .163 }, H };
N l2n234[] = { { sgJ83, .217 }, H };
N l2n236[] = { { sb9Ia7, .190 }, { sa7J86I, .254 }, H };
N l2n237[] = { { sJ84J85, .979 }, { sIadI, .652 }, { sgIa7I, .326 }, { s83Ia7J, .254 }, { saaJ8a, .163 }, H };
N l2n238[] = { { saaI, .634 }, H };
N l2n239[] = { { sbaJ, .109 }, H };
N l2n240[] = { { sgIa7J, 3.878 }, H };
N l2n241[] = { { s85Ib9J, .290 }, H };
N l2n242[] = { { seeg, .612 }, { sVc7, .163 }, H };
N l2n244[] = { { sb1Ia7, .272 }, { sacg, .190 }, H };
N l2n245[] = { { sgJ84, .353 }, H };
N l2n246[] = { { s81J8a, .381 }, { sJ84J88, .326 }, H };
N l2n247[] = { { s81I, .236 }, { s84Ia9g, .381 }, H };
N l2n248[] = { { sgIa8I, .616 }, { sIadJ, .449 }, { sIb4J83, .326 }, H };
N l2n249[] = { { sJ84J89, .544 }, { sgc7W, .163 }, H };
N l2n250[] = { { sJ83, 1.305 }, { sWg, 1.183 }, { sIb2, .245 }, { sIadIaf, .326 }, H };
N l2n251[] = { { sIa3, .326 }, { sJ85J84, .326 }, H };
N l2n252[] = { { sJ84J8a, .544 }, H };
N l2n253[] = { { s88Ia7, .299 }, { s83g, .190 }, H };
N l2n254[] = { { sIaeI, .367 }, H };
N l2n255[] = { { saaJ, .526 }, H };

D l2_d = {
	"arabic",
	"iso-8859-6",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.000, 0.000, W, W, W, W, W, W, 0.001, W, W, 0.001, 0.000, 0.000, W,
	    W, W, 0.000, 0.000, W, 0.000, W, 0.000, W, W, W, W, W, W, W, W,
	    0.001, 0.025, 0.013, 0.035, 0.136, 0.080, 0.056, 0.017, 0.067, 0.012, 0.082, 0.001, 0.001, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    0.001, 0.003, Y, 0.009, 0.001, 0.004, 0.004, 0.215, 0.042, 0.054, 0.062, 0.009, 0.015, 0.020, 0.007, 0.025,
	    0.006, 0.051, 0.007, 0.022, 0.014, 0.009, 0.010, 0.005, 0.002, 0.049, 0.006, Y, Y, Y, Y, 0.002,
	    Y, 0.001, V, 0.021, V, 0.003, 0.003, 0.144, 0.029, 0.011, 0.025, 0.004, 0.027, 0.017, 0.009, 0.026,
	    0.017, 0.038, 0.001, 0.011, 0.004, 0.004, 0.010, 0.004, 0.975, 0.816, 0.003, V, V, V, V, V,
	    V, 0.023, 0.012, 0.025, 0.097, 0.049, 0.051, 0.035, 0.078, 0.009, 0.054, 0.001, V, 0.003, 0.027, 0.015,
	    0.009, 0.007, 0.017, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l2n0, l2n1, X, X, l2n4, l2n5, l2n6, l2n7, l2n8, l2n9, l2n10, l2n11, l2n12, l2n13, l2n14, l2n15,
	    X, l2n17, X, X, l2n20, l2n21, l2n22, l2n23, X, l2n25, l2n26, l2n27, l2n28, X, l2n30, l2n31,
	    l2n32, l2n33, X, X, l2n36, l2n37, l2n38, l2n39, l2n40, X, X, l2n43, l2n44, l2n45, l2n46, X,
	    l2n48, l2n49, X, X, l2n52, l2n53, X, l2n55, l2n56, l2n57, l2n58, l2n59, l2n60, l2n61, l2n62, l2n63,
	    X, l2n65, l2n66, l2n67, X, X, l2n70, l2n71, l2n72, l2n73, l2n74, l2n75, X, l2n77, l2n78, l2n79,
	    l2n80, l2n81, X, l2n83, l2n84, X, l2n86, l2n87, l2n88, l2n89, l2n90, X, l2n92, l2n93, l2n94, l2n95,
	    l2n96, l2n97, l2n98, l2n99, l2n100, l2n101, l2n102, l2n103, l2n104, X, l2n106, l2n107, l2n108, X, l2n110, l2n111,
	    l2n112, l2n113, l2n114, l2n115, X, l2n117, l2n118, X, l2n120, X, X, l2n123, l2n124, l2n125, l2n126, X,
	    l2n128, l2n129, l2n130, l2n131, l2n132, l2n133, l2n134, l2n135, l2n136, l2n137, X, l2n139, l2n140, l2n141, X, l2n143,
	    l2n144, l2n145, l2n146, X, l2n148, X, l2n150, l2n151, l2n152, l2n153, l2n154, l2n155, l2n156, X, X, l2n159,
	    l2n160, X, l2n162, l2n163, l2n164, l2n165, l2n166, l2n167, l2n168, l2n169, X, X, l2n172, l2n173, l2n174, l2n175,
	    l2n176, l2n177, l2n178, X, l2n180, X, l2n182, l2n183, X, l2n185, l2n186, X, l2n188, X, l2n190, l2n191,
	    l2n192, l2n193, l2n194, l2n195, l2n196, l2n197, l2n198, l2n199, l2n200, l2n201, l2n202, X, l2n204, l2n205, l2n206, l2n207,
	    l2n208, l2n209, l2n210, l2n211, l2n212, l2n213, l2n214, l2n215, l2n216, l2n217, l2n218, l2n219, l2n220, l2n221, l2n222, l2n223,
	    l2n224, l2n225, l2n226, l2n227, l2n228, l2n229, X, l2n231, X, l2n233, l2n234, X, l2n236, l2n237, l2n238, l2n239,
	    l2n240, l2n241, l2n242, X, l2n244, l2n245, l2n246, l2n247, l2n248, l2n249, l2n250, l2n251, l2n252, l2n253, l2n254, l2n255 }
};

//
// Lng: basque
// Enc: iso-8859-15
//

S sx7a[] = { t, z, 0 };
S s7ai[] = { z, e, 0 };
S sosg[] = { k, o, a };
S s7aX[] = { z, 97, 0 };
S s7ag[] = { z, a };
S sx7ai[] = { t, z, e, 0 };
S sgYX[] = { 32, 98, 97, 0 };
S sixX[] = { e, t, 97, 0 };
S sm7a[] = { i, z, 0 };
S smX[] = { i, 97, 0 };
S sks[] = { g, o, 0 };
S sX7a[] = { 97, z, 0 };
S s7ao[] = { z, k, 0 };
S sivX[] = { e, r, 97, 0 };
S s7air[] = { z, e, n, 0 };
S svvm[] = { r, r, i, 0 };
S sxmo[] = { t, i, k, 0 };
S ssX[] = { o, 97, 0 };
S sixXg[] = { e, t, 97, a };
S skm[] = { g, i, 0 };
S syw[] = { u, s, 0 };
S sXog[] = { 97, k, a };
S s7airg[] = { z, e, n, a };
S si7ag[] = { e, z, a };
S sXy[] = { 97, u, 0 };
S sgix[] = { 32, e, t, 0 };
S sgi7a[] = { 32, e, z, 0 };
S sgixX[] = { 32, e, t, 97, 0 };
S srx7a[] = { n, t, z, 0 };
S smos[] = { i, k, o, 0 };
S swoX[] = { s, k, 97, 0 };
S siX[] = { e, 97, 0 };
S sXxi[] = { 97, t, e, 0 };
S sXY[] = { 97, 98, 0 };
S sXxm[] = { 97, t, i, 0 };
S sxyg[] = { t, u, a };
S siywo[] = { e, u, s, k, 0 };
S sywo[] = { u, s, k, 0 };
S sikm[] = { e, g, i, 0 };
S sgiyw[] = { 32, e, u, s, 0 };
S sxXrg[] = { t, 97, n, a };
S sgiy[] = { 32, e, u, 0 };
S siyw[] = { e, u, s, 0 };
S sx7aX[] = { t, z, 97, 0 };
S sx7air[] = { t, z, e, n, 0 };
S s7ax[] = { z, t, 0 };
S sywoX[] = { u, s, k, 97, 0 };
S smoX[] = { i, k, 97, 0 };
S smx7a[] = { i, t, z, 0 };
S sYiv[] = { 98, e, r, 0 };
S sYXx[] = { 98, 97, t, 0 };
S sgYXx[] = { 32, 98, 97, t, 0 };
S svir[] = { r, e, n, 0 };
S sgiv[] = { 32, e, r, 0 };
S sivi[] = { e, r, e, 0 };
S smY[] = { i, 98, 0 };
S sgik[] = { 32, e, g, 0 };
S sy7a[] = { u, z, 0 };
S sYmp[] = { 98, i, l, 0 };
S sYXm[] = { 98, 97, i, 0 };
S sil[] = { e, h, 0 };
S sXx7a[] = { 97, t, z, 0 };
S sXvX[] = { 97, r, 97, 0 };
S sit[] = { e, p, 0 };
S sXl[] = { 97, h, 0 };
S sqXx[] = { m, 97, t, 0 };
S shXg[] = { d, 97, a };
S sXmx[] = { 97, i, t, 0 };
S sios[] = { e, k, o, 0 };
S soXp[] = { k, 97, l, 0 };
S sXxmo[] = { 97, t, i, k, 0 };
S siosg[] = { e, k, o, a };
S sXmr[] = { 97, i, n, 0 };
S sti[] = { p, e, 0 };
S sXvv[] = { 97, r, r, 0 };
S sivv[] = { e, r, r, 0 };
S ssXg[] = { o, 97, a };
S spXg[] = { l, 97, a };
S sgm7a[] = { 32, i, z, 0 };
S sXks[] = { 97, g, o, 0 };
S svirg[] = { r, e, n, a };
S syi[] = { u, e, 0 };
S sgrX[] = { 32, n, 97, 0 };
S sXvm[] = { 97, r, i, 0 };
S sXqX[] = { 97, m, 97, 0 };
S sXxy[] = { 97, t, u, 0 };
S sXYm[] = { 97, 98, i, 0 };
S sXph[] = { 97, l, d, 0 };
S smXg[] = { i, 97, a };
S syx[] = { u, t, 0 };
S sqXxm[] = { m, 97, t, i, 0 };
S sksg[] = { g, o, a };
S sph[] = { l, d, 0 };
S sgYiv[] = { 32, 98, e, r, 0 };
S srx7ai[] = { n, t, z, e, 0 };
S svmog[] = { r, i, k, a };
S svmo[] = { r, i, k, 0 };
S slXv[] = { h, 97, r, 0 };
S sivXY[] = { e, r, 97, 98, 0 };
S sXos[] = { 97, k, o, 0 };
S sgivX[] = { 32, e, r, 97, 0 };
S sirX[] = { e, n, 97, 0 };
S sghy[] = { 32, d, u, 0 };
S sghXg[] = { 32, d, 97, a };
S sosX[] = { k, o, 97, 0 };
S sXpX[] = { 97, l, 97, 0 };
S sXYmp[] = { 97, 98, i, l, 0 };
S sgikm[] = { 32, e, g, i, 0 };
S s7aos[] = { z, k, o, 0 };
S sosr[] = { k, o, n, 0 };
S svy[] = { r, u, 0 };
S sqy[] = { m, u, 0 };
S svXY[] = { r, 97, 98, 0 };
S sxiv[] = { t, e, r, 0 };
S s7axi[] = { z, t, e, 0 };
S svX7a[] = { r, 97, z, 0 };
S sg7ai[] = { 32, z, e, 0 };
S siXg[] = { e, 97, a };
S svmX[] = { r, i, 97, 0 };
S sivvm[] = { e, r, r, i, 0 };
S svXYm[] = { r, 97, 98, i, 0 };
S swy[] = { s, u, 0 };
S s7aoi[] = { z, k, e, 0 };
S smxX[] = { i, t, 97, 0 };
S si7aX[] = { e, z, 97, 0 };
S sipX[] = { e, l, 97, 0 };
S soXv[] = { k, 97, r, 0 };
S stxy[] = { p, t, u, 0 };
S sx7ait[] = { t, z, e, p, 0 };
S sgX7a[] = { 32, 97, z, 0 };
S ssvv[] = { o, r, r, 0 };
S smxy[] = { i, t, u, 0 };
S sxXx[] = { t, 97, t, 0 };
S s7aXx[] = { z, 97, t, 0 };
S swoXp[] = { s, k, 97, l, 0 };
S sgkvX[] = { 32, g, r, 97, 0 };
S sgih[] = { 32, e, d, 0 };
S sxirg[] = { t, e, n, a };
S s7aXrg[] = { z, 97, n, a };
S srXl[] = { n, 97, h, 0 };
S sX7axi[] = { 97, z, t, e, 0 };
S skvXq[] = { g, r, 97, m, 0 };
S skv[] = { g, r, 0 };
S stx[] = { p, t, 0 };
S sxw[] = { t, s, 0 };
S svXq[] = { r, 97, m, 0 };
S sxir[] = { t, e, n, 0 };
S sms[] = { i, o, 0 };
S ssrx7a[] = { o, n, t, z, 0 };
S sitxy[] = { e, p, t, u, 0 };
S s7aitx[] = { z, e, p, t, 0 };
S stir[] = { p, e, n, 0 };
S sxmoX[] = { t, i, k, 97, 0 };
S sgYm[] = { 32, 98, i, 0 };
S s7ait[] = { z, e, p, 0 };
S sirXg[] = { e, n, 97, a };
S sxmos[] = { t, i, k, o, 0 };
S skvX[] = { g, r, 97, 0 };
S sX7ax[] = { 97, z, t, 0 };
S sgYXm[] = { 32, 98, 97, i, 0 };
S s7aXr[] = { z, 97, n, 0 };
S sm7ao[] = { i, z, k, 0 };
S srhm[] = { n, d, i, 0 };
S sgkv[] = { 32, g, r, 0 };
S sgi7ag[] = { 32, e, z, a };
S sgXg[] = { 32, 97, a };
S sm7aX[] = { i, z, 97, 0 };
S sXx7ai[] = { 97, t, z, e, 0 };
S smwx[] = { i, s, t, 0 };
S svXo[] = { r, 97, k, 0 };
S sosrx[] = { k, o, n, t, 0 };
S siwx[] = { e, s, t, 0 };
S sitx[] = { e, p, t, 0 };
S spx[] = { l, t, 0 };
S sXvvm[] = { 97, r, r, i, 0 };
S sgXh[] = { 32, 97, d, 0 };
S sviw[] = { r, e, s, 0 };
S smhi[] = { i, d, e, 0 };
S sphi[] = { l, d, e, 0 };
S sXqXx[] = { 97, m, 97, t, 0 };
S sXphi[] = { 97, l, d, e, 0 };
S sghmv[] = { 32, d, i, r, 0 };
S s7aosg[] = { z, k, o, a };
S sXlm[] = { 97, h, i, 0 };
S sgXhm[] = { 32, 97, d, i, 0 };
S sXwy[] = { 97, s, u, 0 };
S sxXo[] = { t, 97, k, 0 };
S shmv[] = { d, i, r, 0 };
S sgm7aX[] = { 32, i, z, 97, 0 };
S svXqX[] = { r, 97, m, 97, 0 };
S si7ao[] = { e, z, k, 0 };
S sXpx[] = { 97, l, t, 0 };
S s7ay[] = { z, u, 0 };
S sgkiv[] = { 32, g, e, r, 0 };
S slmg[] = { h, i, a };
S sihs[] = { e, d, o, 0 };
S sso[] = { o, k, 0 };
S soXx[] = { k, 97, t, 0 };
S svig[] = { r, e, a };
S sgihs[] = { 32, e, d, o, 0 };
S smxi[] = { i, t, e, 0 };
S sxio[] = { t, e, k, 0 };
S sm7aXr[] = { i, z, 97, n, 0 };
S smrx[] = { i, n, t, 0 };
S sXhm[] = { 97, d, i, 0 };
S srXlm[] = { n, 97, h, i, 0 };
S sXosg[] = { 97, k, o, a };
S slm7a[] = { h, i, z, 0 };
S smosg[] = { i, k, o, a };
S sgrXl[] = { 32, n, 97, h, 0 };
S silXv[] = { e, h, 97, r, 0 };
S sqyr[] = { m, u, n, 0 };
S sghip[] = { 32, d, e, l, 0 };
S smXo[] = { i, 97, k, 0 };
S ssxX[] = { o, t, 97, 0 };
S svXr[] = { r, 97, n, 0 };
S sXpm[] = { 97, l, i, 0 };
S sX7ag[] = { 97, z, a };
S ssh[] = { o, d, 0 };
S sixXr[] = { e, t, 97, n, 0 };
S slXvg[] = { h, 97, r, a };
S smXog[] = { i, 97, k, a };
S sYXp[] = { 98, 97, l, 0 };
S svvmX[] = { r, r, i, 97, 0 };
S sgyv[] = { 32, u, r, 0 };
S sx7aXx[] = { t, z, 97, t, 0 };
S sqsh[] = { m, o, d, 0 };
S sosXg[] = { k, o, 97, a };
S sYyv[] = { 98, u, r, 0 };
S sxyX[] = { t, u, 97, 0 };
S sox[] = { k, t, 0 };
S sYXxg[] = { 98, 97, t, a };
S smx7aX[] = { i, t, z, 97, 0 };
S sgog[] = { 32, k, a };
S s7aXm[] = { z, 97, i, 0 };
S smvi[] = { i, r, e, 0 };
S slXy[] = { h, 97, u, 0 };
S sXvi[] = { 97, r, e, 0 };
S silX[] = { e, h, 97, 0 };
S sxXw[] = { t, 97, s, 0 };
S sXwyr[] = { 97, s, u, n, 0 };
S shsg[] = { d, o, a };
S sglXy[] = { 32, h, 97, u, 0 };
S swoXv[] = { s, k, 97, r, 0 };
S sm7ag[] = { i, z, a };
S sgqy[] = { 32, m, u, 0 };
S srhy[] = { n, d, u, 0 };

N l3n0[] = { { siy, .191 }, H };
N l3n1[] = { { stX, .137 }, { smrx, .143 }, H };
N l3n2[] = { { sgik, .369 }, H };
N l3n3[] = { { ssv, .328 }, H };
N l3n4[] = { { sX7axi, .219 }, H };
N l3n5[] = { { smr, .601 }, { sxm, .423 }, H };
N l3n6[] = { { srx, .382 }, { sitxy, .219 }, { s7aosg, .287 }, { svvmX, .164 }, H };
N l3n7[] = { { sghm, .369 }, { sri, .150 }, H };
N l3n8[] = { { swo, .314 }, { sXYmp, .246 }, H };
N l3n9[] = { { slX, .328 }, H };
N l3n10[] = { { soXp, .225 }, { soig, .307 }, { sgosr, .369 }, H };
N l3n11[] = { { skv, .109 }, H };
N l3n12[] = { { sgp, .410 }, { siXg, .277 }, H };
N l3n13[] = { { sXr, .765 }, { spm, .260 }, { swg, .184 }, H };
N l3n14[] = { { sgki, .277 }, { sosr, .184 }, H };
N l3n15[] = { { sgYiv, .410 }, { sghXg, .369 }, { sphi, .143 }, H };
N l3n16[] = { { slXy, .123 }, H };
N l3n17[] = { { svXqX, .191 }, { shmx, .123 }, H };
N l3n18[] = { { sik, .273 }, H };
N l3n20[] = { { ssw, .178 }, { skiv, .164 }, { sirXg, .328 }, H };
N l3n21[] = { { sog, .963 }, { shm, .464 }, { ssh, .082 }, H };
N l3n22[] = { { sXpX, .184 }, { sms, .109 }, { sxXo, .143 }, H };
N l3n23[] = { { sgm7a, .307 }, H };
N l3n26[] = { { sixX, .635 }, H };
N l3n27[] = { { sios, .225 }, H };
N l3n29[] = { { sgq, .328 }, H };
N l3n30[] = { { sivXY, .246 }, H };
N l3n31[] = { { sghip, .246 }, H };
N l3n33[] = { { sxig, .307 }, { smXog, .246 }, H };
N l3n34[] = { { stv, .096 }, H };
N l3n35[] = { { srXg, .430 }, { sil, .164 }, H };
N l3n36[] = { { sivi, .246 }, { sgqy, .184 }, H };
N l3n37[] = { { ssx, .164 }, H };
N l3n38[] = { { sx7a, .724 }, H };
N l3n39[] = { { sXqX, .205 }, { svmg, .277 }, H };
N l3n40[] = { { smX, .396 }, H };
N l3n41[] = { { srk, .205 }, { ssrx7a, .219 }, H };
N l3n42[] = { { sXlm, .143 }, H };
N l3n44[] = { { sxg, .430 }, H };
N l3n45[] = { { svs, .109 }, H };
N l3n46[] = { { sgr, .471 }, { ski, .150 }, { sgihs, .287 }, H };
N l3n47[] = { { sXt, .096 }, H };
N l3n49[] = { { sxyg, .430 }, { shig, .215 }, { sm7ag, .184 }, H };
N l3n50[] = { { smog, .615 }, { siywo, .382 }, H };
N l3n51[] = { { swoX, .307 }, { s7aXx, .164 }, { sgi7ag, .328 }, H };
N l3n52[] = { { spg, .164 }, { sim, .082 }, H };
N l3n53[] = { { s7air, .471 }, H };
N l3n54[] = { { skvX, .164 }, { sgtv, .215 }, H };
N l3n55[] = { { s7aX, .519 }, { sxXr, .287 }, { sXxmo, .301 }, { sXvv, .225 }, { sXph, .205 }, H };
N l3n56[] = { { sksg, .307 }, { s7aoi, .184 }, H };
N l3n57[] = { { smY, .164 }, { sX7ag, .184 }, H };
N l3n58[] = { { sXog, .523 }, { sgm7aX, .287 }, H };
N l3n59[] = { { srXl, .164 }, H };
N l3n61[] = { { svir, .266 }, { sgikm, .369 }, H };
N l3n62[] = { { sky, .150 }, H };
N l3n63[] = { { svX, .902 }, { sgs, .369 }, H };
N l3n65[] = { { sXY, .205 }, H };
N l3n66[] = { { ssXg, .307 }, H };
N l3n68[] = { { srx7a, .307 }, { stx, .109 }, H };
N l3n69[] = { { sy7a, .164 }, { sti, .150 }, H };
N l3n70[] = { { syo, .123 }, { sm7aXr, .191 }, H };
N l3n73[] = { { smv, .178 }, H };
N l3n75[] = { { syg, .451 }, { sYXx, .266 }, { srm, .178 }, { stxy, .164 }, { s7ait, .164 }, { sglm, .246 }, H };
N l3n76[] = { { soXv, .164 }, H };
N l3n77[] = { { sli, .150 }, { sXvx, .123 }, H };
N l3n78[] = { { silX, .123 }, H };
N l3n79[] = { { sYX, .560 }, { slXvg, .246 }, H };
N l3n80[] = { { sgt, .389 }, { ssxX, .123 }, H };
N l3n81[] = { { sXv, .779 }, { sgX, 1.106 }, { sx7aX, .287 }, { sg7ai, .277 }, { s7aXrg, .328 }, H };
N l3n82[] = { { sglXy, .246 }, H };
N l3n84[] = { { sos, .915 }, H };
N l3n85[] = { { si7a, .519 }, H };
N l3n86[] = { { sio, .219 }, { smwx, .164 }, H };
N l3n89[] = { { sgrX, .307 }, H };
N l3n90[] = { { smw, .178 }, { sxio, .143 }, H };
N l3n91[] = { { sig, .881 }, { smh, .178 }, { sXks, .205 }, { sgog, .184 }, H };
N l3n93[] = { { sghmv, .287 }, H };
N l3n94[] = { { swX, .123 }, H };
N l3n96[] = { { svv, .464 }, { svmo, .184 }, H };
N l3n98[] = { { sgY, 1.434 }, { sXw, .287 }, { soXx, .143 }, H };
N l3n99[] = { { sXh, .137 }, H };
N l3n100[] = { { sgkiv, .287 }, { sixXr, .164 }, H };
N l3n101[] = { { smrg, .307 }, H };
N l3n102[] = { { soX, .546 }, { sXphi, .191 }, H };
N l3n103[] = { { sywo, .287 }, { sip, .150 }, H };
N l3n105[] = { { sXwy, .143 }, H };
N l3n106[] = { { sm7ao, .164 }, { sosrx, .219 }, H };
N l3n107[] = { { smx, .560 }, H };
N l3n108[] = { { smi, .150 }, H };
N l3n109[] = { { sXrg, 1.414 }, H };
N l3n110[] = { { sXpm, .123 }, { sxXw, .123 }, H };
N l3n114[] = { { srg, 2.459 }, { skm, .246 }, { sXmr, .225 }, { smrk, .184 }, { smxy, .164 }, { sXvvm, .191 }, H };
N l3n115[] = { { sXx, .902 }, { srx7ai, .273 }, H };
N l3n116[] = { { sviw, .143 }, H };
N l3n117[] = { { svXY, .184 }, { ship, .123 }, H };
N l3n118[] = { { srXlm, .191 }, H };
N l3n119[] = { { swoXp, .219 }, H };
N l3n120[] = { { siq, .109 }, H };
N l3n121[] = { { syr, .396 }, { sYiv, .266 }, { sxXx, .164 }, { srhm, .164 }, H };
N l3n122[] = { { sixXg, .738 }, { s7ax, .191 }, { sXxy, .205 }, H };
N l3n123[] = { { s7ai, .615 }, { sgiv, .400 }, { sYmp, .246 }, { siosg, .451 }, { shs, .150 }, { sxir, .164 }, H };
N l3n124[] = { { sXvX, .246 }, H };
N l3n125[] = { { sxX, .929 }, { sx7ai, .635 }, { svX7a, .184 }, { skvXq, .219 }, H };
N l3n127[] = { { sosX, .184 }, H };
N l3n128[] = { { si7aX, .164 }, H };
N l3n130[] = { { svx, .328 }, H };
N l3n131[] = { { svi, .505 }, { sgw, .205 }, { sXqXx, .191 }, H };
N l3n132[] = { { sgh, 1.352 }, { sXy, .232 }, { sYiw, .123 }, H };
N l3n133[] = { { spX, .355 }, H };
N l3n136[] = { { smXg, .307 }, H };
N l3n137[] = { { sir, 1.188 }, { sYyv, .123 }, { swoXv, .164 }, H };
N l3n138[] = { { sywoX, .382 }, H };
N l3n139[] = { { sghy, .277 }, { s7ay, .096 }, { sgyv, .184 }, H };
N l3n140[] = { { sso, .096 }, H };
N l3n141[] = { { shX, .478 }, { sgYX, .953 }, H };
N l3n143[] = { { sgX7a, .246 }, H };
N l3n145[] = { { ssg, 1.373 }, { slm, .260 }, { sgix, .492 }, { sgrXl, .287 }, H };
N l3n146[] = { { sqs, .137 }, { sipX, .164 }, H };
N l3n147[] = { { sYi, .437 }, { svy, .123 }, H };
N l3n148[] = { { sgx, .205 }, H };
N l3n149[] = { { sgi, 1.967 }, { s7airg, .697 }, { sikm, .287 }, H };
N l3n150[] = { { sXk, .246 }, { smxX, .164 }, H };
N l3n151[] = { { smos, .307 }, { sxXrg, .574 }, H };
N l3n156[] = { { sgiy, .430 }, { syX, .164 }, H };
N l3n157[] = { { svirg, .410 }, { sgkv, .246 }, { sgXh, .215 }, H };
N l3n158[] = { { sxmo, .430 }, { sgivX, .369 }, H };
N l3n159[] = { { sXos, .184 }, { svXg, .277 }, H };
N l3n160[] = { { sqXx, .225 }, { smvi, .123 }, H };
N l3n161[] = { { swx, .301 }, H };
N l3n164[] = { { sqX, .287 }, { sihs, .143 }, { silXv, .164 }, H };
N l3n165[] = { { sgy, .246 }, H };
N l3n166[] = { { s7aos, .184 }, H };
N l3n167[] = { { sXl, .164 }, { sxiv, .184 }, { s7aitx, .219 }, { sitx, .164 }, H };
N l3n168[] = { { sXvi, .123 }, H };
N l3n169[] = { { smx7a, .266 }, { sox, .082 }, H };
N l3n170[] = { { soi, .287 }, H };
N l3n171[] = { { sit, .164 }, { sYXxg, .246 }, H };
N l3n172[] = { { siX, .205 }, H };
N l3n173[] = { { sx7aXx, .164 }, H };
N l3n174[] = { { ssq, .082 }, H };
N l3n175[] = { { sghX, .615 }, { sxw, .109 }, H };
N l3n176[] = { { svXYm, .246 }, H };
N l3n177[] = { { srs, .164 }, { sXx7a, .246 }, { sXvg, .246 }, { sgXg, .246 }, H };
N l3n178[] = { { swy, .123 }, { smhi, .143 }, { sqyr, .123 }, H };
N l3n179[] = { { sivv, .225 }, { sXwyr, .164 }, H };
N l3n180[] = { { sosg, 1.260 }, { sgixX, .656 }, { sXmx, .225 }, { sirX, .184 }, H };
N l3n181[] = { { si7ag, .523 }, H };
N l3n183[] = { { sgk, .553 }, H };
N l3n184[] = { { sXm, .519 }, { sph, .137 }, H };
N l3n185[] = { { sgYi, .799 }, H };
N l3n186[] = { { s7aXm, .123 }, H };
N l3n187[] = { { ssrx, .164 }, H };
N l3n189[] = { { syv, .301 }, H };
N l3n191[] = { { ssr, .260 }, { s7am, .178 }, H };
N l3n192[] = { { sgos, .430 }, { svmog, .369 }, { sgkvX, .328 }, H };
N l3n193[] = { { sxi, .806 }, { sxmoX, .219 }, { smXo, .123 }, H };
N l3n194[] = { { smxi, .143 }, H };
N l3n195[] = { { srX, .423 }, H };
N l3n196[] = { { sXYm, .205 }, H };
N l3n197[] = { { syrh, .143 }, H };
N l3n199[] = { { svm, .628 }, { sx7air, .382 }, H };
N l3n200[] = { { sgl, .615 }, { sgYXm, .328 }, { spx, .109 }, H };
N l3n201[] = { { spi, .246 }, { sivx, .246 }, H };
N l3n202[] = { { sXxi, .307 }, H };
N l3n204[] = { { smx7aX, .164 }, H };
N l3n205[] = { { siv, .997 }, { sx7ait, .219 }, H };
N l3n206[] = { { syw, .246 }, H };
N l3n207[] = { { slm7a, .143 }, H };
N l3n209[] = { { shi, .533 }, { sxy, .478 }, { sm7a, .410 }, { s7axi, .184 }, H };
N l3n210[] = { { smo, .710 }, { sYXm, .246 }, H };
N l3n211[] = { { sgi7a, .492 }, { sXxg, .338 }, H };
N l3n212[] = { { sXvm, .205 }, H };
N l3n213[] = { { sX7ax, .164 }, H };
N l3n215[] = { { smg, .820 }, { sYm, .301 }, H };
N l3n216[] = { { sks, .328 }, { svXo, .164 }, { sgXhm, .287 }, H };
N l3n217[] = { { sgm, .574 }, { sX7a, .328 }, { svxi, .123 }, H };
N l3n218[] = { { sXo, .519 }, { siwx, .164 }, H };
N l3n219[] = { { sghi, .676 }, { sqXxm, .273 }, { sxirg, .328 }, { shsg, .184 }, H };
N l3n221[] = { { sxXg, .707 }, H };
N l3n222[] = { { siw, .382 }, { sqsh, .123 }, H };
N l3n223[] = { { sXg, 2.541 }, { syx, .137 }, { sih, .123 }, { sosXg, .246 }, H };
N l3n224[] = { { syi, .137 }, { sXx7ai, .219 }, H };
N l3n225[] = { { s7ao, .314 }, { shy, .246 }, { sgih, .246 }, H };
N l3n226[] = { { ssX, .273 }, { sgqs, .215 }, H };
N l3n227[] = { { svvm, .430 }, { smp, .232 }, { svig, .215 }, H };
N l3n229[] = { { spXg, .307 }, { sgYm, .246 }, H };
N l3n230[] = { { s7ag, .717 }, { swm, .260 }, { sXhm, .143 }, H };
N l3n231[] = { { sXpx, .143 }, { stXv, .123 }, H };
N l3n233[] = { { sirg, 1.752 }, { sgYXx, .533 }, { ssvv, .164 }, H };
N l3n234[] = { { skX, .164 }, { sgn, .143 }, H };
N l3n235[] = { { sXp, .628 }, { sxmos, .219 }, H };
N l3n237[] = { { shXg, .338 }, H };
N l3n238[] = { { svg, .307 }, { som, .191 }, { sivvm, .246 }, { svXq, .164 }, { si7ao, .143 }, H };
N l3n239[] = { { six, .451 }, { slXv, .184 }, H };
N l3n241[] = { { siyw, .287 }, { s7aXr, .164 }, { slmg, .215 }, H };
N l3n242[] = { { svmX, .184 }, H };
N l3n243[] = { { sglX, .338 }, { sYXp, .123 }, H };
N l3n245[] = { { sgiyw, .574 }, H };
N l3n246[] = { { srh, .260 }, { sXxm, .307 }, H };
N l3n247[] = { { smosg, .287 }, H };
N l3n248[] = { { sivX, .471 }, { swxi, .225 }, { sqy, .123 }, H };
N l3n249[] = { { svXr, .123 }, H };
N l3n250[] = { { sg7a, .307 }, H };
N l3n251[] = { { sgo, .553 }, { shmv, .143 }, H };
N l3n252[] = { { sXq, .164 }, { sm7aX, .164 }, { sxyX, .123 }, H };
N l3n253[] = { { smoX, .266 }, { srhy, .123 }, H };
N l3n255[] = { { stir, .164 }, { sXosg, .287 }, H };

D l3_d = {
	"basque",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, 0.001, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.308, 0.060, 0.006, 0.076, 0.237, 0.007, 0.050, 0.034, 0.189, 0.004, 0.111, 0.056, 0.029, 0.143, 0.108,
	    0.027, 0.001, 0.138, 0.062, 0.155, 0.089, 0.005, 0.001, 0.003, 0.001, 0.097, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    0.001, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, 0.001, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, 0.001, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l3n0, l3n1, l3n2, l3n3, l3n4, l3n5, l3n6, l3n7, l3n8, l3n9, l3n10, l3n11, l3n12, l3n13, l3n14, l3n15,
	    l3n16, l3n17, l3n18, X, l3n20, l3n21, l3n22, l3n23, X, X, l3n26, l3n27, X, l3n29, l3n30, l3n31,
	    X, l3n33, l3n34, l3n35, l3n36, l3n37, l3n38, l3n39, l3n40, l3n41, l3n42, X, l3n44, l3n45, l3n46, l3n47,
	    X, l3n49, l3n50, l3n51, l3n52, l3n53, l3n54, l3n55, l3n56, l3n57, l3n58, l3n59, X, l3n61, l3n62, l3n63,
	    X, l3n65, l3n66, X, l3n68, l3n69, l3n70, X, X, l3n73, X, l3n75, l3n76, l3n77, l3n78, l3n79,
	    l3n80, l3n81, l3n82, X, l3n84, l3n85, l3n86, X, X, l3n89, l3n90, l3n91, X, l3n93, l3n94, X,
	    l3n96, X, l3n98, l3n99, l3n100, l3n101, l3n102, l3n103, X, l3n105, l3n106, l3n107, l3n108, l3n109, l3n110, X,
	    X, X, l3n114, l3n115, l3n116, l3n117, l3n118, l3n119, l3n120, l3n121, l3n122, l3n123, l3n124, l3n125, X, l3n127,
	    l3n128, X, l3n130, l3n131, l3n132, l3n133, X, X, l3n136, l3n137, l3n138, l3n139, l3n140, l3n141, X, l3n143,
	    X, l3n145, l3n146, l3n147, l3n148, l3n149, l3n150, l3n151, X, X, X, X, l3n156, l3n157, l3n158, l3n159,
	    l3n160, l3n161, X, X, l3n164, l3n165, l3n166, l3n167, l3n168, l3n169, l3n170, l3n171, l3n172, l3n173, l3n174, l3n175,
	    l3n176, l3n177, l3n178, l3n179, l3n180, l3n181, X, l3n183, l3n184, l3n185, l3n186, l3n187, X, l3n189, X, l3n191,
	    l3n192, l3n193, l3n194, l3n195, l3n196, l3n197, X, l3n199, l3n200, l3n201, l3n202, X, l3n204, l3n205, l3n206, l3n207,
	    X, l3n209, l3n210, l3n211, l3n212, l3n213, X, l3n215, l3n216, l3n217, l3n218, l3n219, X, l3n221, l3n222, l3n223,
	    l3n224, l3n225, l3n226, l3n227, X, l3n229, l3n230, l3n231, X, l3n233, l3n234, l3n235, X, l3n237, l3n238, l3n239,
	    X, l3n241, l3n242, l3n243, X, l3n245, l3n246, l3n247, l3n248, l3n249, l3n250, l3n251, l3n252, l3n253, X, l3n255 }
};

//
// Lng: bulgarian
// Enc: iso-8859-5
//

S sAg[] = { 208, a };
S sIg[] = { 216, a };
S sOg[] = { 222, a };
S sFg[] = { 213, a };
S sNA[] = { 221, 208, 0 };
S sRS[] = { 225, 226, 0 };
S sgN[] = { 32, 221, 0 };
S sNI[] = { 221, 216, 0 };
S sNAg[] = { 221, 208, a };
S sgP[] = { 32, 223, 0 };
S sSF[] = { 226, 213, 0 };
S sSO[] = { 226, 222, 0 };
S sQA[] = { 224, 208, 0 };
S sgNA[] = { 32, 221, 208, 0 };
S sSg[] = { 226, a };
S sSA[] = { 226, 208, 0 };
S sAS[] = { 208, 226, 0 };
S sOS[] = { 222, 226, 0 };
S sIS[] = { 216, 226, 0 };
S sgNAg[] = { 32, 221, 208, a };
S sFN[] = { 213, 221, 0 };
S sgK[] = { 32, 218, 0 };
S sAN[] = { 208, 221, 0 };
S sQF[] = { 224, 213, 0 };
S sPQ[] = { 223, 224, 0 };
S sgC[] = { 32, 210, 0 };
S sSOg[] = { 226, 222, a };
S sgO[] = { 32, 222, 0 };
S sCA[] = { 210, 208, 0 };
S sOR[] = { 222, 225, 0 };
S sISF[] = { 216, 226, 213, 0 };
S sNO[] = { 221, 222, 0 };
S sKO[] = { 218, 222, 0 };
S sQI[] = { 224, 216, 0 };
S sgE[] = { 32, 212, 0 };
S sPO[] = { 223, 222, 0 };
S sefg[] = { 239, a };
S sFS[] = { 213, 226, 0 };
S sgPQ[] = { 32, 223, 224, 0 };
S sKA[] = { 218, 208, 0 };
S sQO[] = { 224, 222, 0 };
S sSI[] = { 226, 216, 0 };
S sSFg[] = { 226, 213, a };
S sgF[] = { 32, 213, 0 };
S sIef[] = { 216, 239, 0 };
S sNF[] = { 221, 213, 0 };
S sAC[] = { 208, 210, 0 };
S sHI[] = { 215, 216, 0 };
S sEA[] = { 212, 208, 0 };
S sISFg[] = { 216, 226, 213, a };
S sRF[] = { 225, 213, 0 };
S sCg[] = { 210, a };
S sSAg[] = { 226, 208, a };
S sAK[] = { 208, 218, 0 };
S sIefg[] = { 216, 239, a };
S sNIg[] = { 221, 216, a };
S sRK[] = { 225, 218, 0 };
S sAQ[] = { 208, 224, 0 };
S sgPO[] = { 32, 223, 222, 0 };
S sIK[] = { 216, 218, 0 };
S sIH[] = { 216, 215, 0 };
S sLI[] = { 219, 216, 0 };
S sFR[] = { 213, 225, 0 };
S sFQ[] = { 213, 224, 0 };
S sgRF[] = { 32, 225, 213, 0 };
S sHA[] = { 215, 208, 0 };
S sCF[] = { 210, 213, 0 };
S sIN[] = { 216, 221, 0 };
S sgQ[] = { 32, 224, 0 };
S sFE[] = { 213, 212, 0 };
S sgB[] = { 32, 209, 0 };
S sgIg[] = { 32, 216, a };
S sgS[] = { 32, 226, 0 };
S sgOS[] = { 32, 222, 226, 0 };
S sRFg[] = { 225, 213, a };
S sgRFg[] = { 32, 225, 213, a };
S sgM[] = { 32, 220, 0 };
S sCO[] = { 210, 222, 0 };
S sORS[] = { 222, 225, 226, 0 };
S sASg[] = { 208, 226, a };
S sEAg[] = { 212, 208, a };
S sgH[] = { 32, 215, 0 };
S sKI[] = { 218, 216, 0 };
S sOD[] = { 222, 211, 0 };
S sSC[] = { 226, 210, 0 };
S sgHA[] = { 32, 215, 208, 0 };
S sgEA[] = { 32, 212, 208, 0 };
S sANI[] = { 208, 221, 216, 0 };
S sFL[] = { 213, 219, 0 };
S sgCg[] = { 32, 210, a };
S sSN[] = { 226, 221, 0 };
S sFH[] = { 213, 215, 0 };
S sNISF[] = { 221, 216, 226, 213, 0 };
S sNIS[] = { 221, 216, 226, 0 };
S sgEAg[] = { 32, 212, 208, a };
S sKg[] = { 218, a };
S sCI[] = { 210, 216, 0 };
S sIR[] = { 216, 225, 0 };
S sNS[] = { 221, 226, 0 };
S sgD[] = { 32, 211, 0 };
S sCAg[] = { 210, 208, a };
S sLF[] = { 219, 213, 0 };
S sRSC[] = { 225, 226, 210, 0 };
S sIKg[] = { 216, 218, a };
S sLN[] = { 219, 221, 0 };
S sNOg[] = { 221, 222, a };
S sNR[] = { 221, 225, 0 };
S sRI[] = { 225, 216, 0 };
S sASA[] = { 208, 226, 208, 0 };
S sDA[] = { 211, 208, 0 };
S sFSO[] = { 213, 226, 222, 0 };
S sAH[] = { 208, 215, 0 };
S sMO[] = { 220, 222, 0 };
S sIQ[] = { 216, 224, 0 };
S sOB[] = { 222, 209, 0 };
S sEO[] = { 212, 222, 0 };
S sgbf[] = { 32, 191, 0 };
S sMI[] = { 220, 216, 0 };
S sIe7[] = { 216, 231, 0 };
S sFHI[] = { 213, 215, 216, 0 };
S sHAg[] = { 215, 208, a };
S sOE[] = { 222, 212, 0 };
S sFRS[] = { 213, 225, 226, 0 };
S sFSOg[] = { 213, 226, 222, a };
S sKOg[] = { 218, 222, a };
S sgNF[] = { 32, 221, 213, 0 };
S sIC[] = { 216, 210, 0 };
S sgQF[] = { 32, 224, 213, 0 };
S sPQF[] = { 223, 224, 213, 0 };
S sLA[] = { 219, 208, 0 };
S sMF[] = { 220, 213, 0 };
S sgKO[] = { 32, 218, 222, 0 };
S sASAg[] = { 208, 226, 208, a };
S sQAN[] = { 224, 208, 221, 0 };
S sRKI[] = { 225, 218, 216, 0 };
S sgA[] = { 32, 208, 0 };
S sBA[] = { 209, 208, 0 };
S sOC[] = { 222, 210, 0 };
S sWI[] = { 230, 216, 0 };
S sNg[] = { 221, a };
S sEI[] = { 212, 216, 0 };
S se7I[] = { 231, 216, 0 };
S sIQA[] = { 216, 224, 208, 0 };
S sRSF[] = { 225, 226, 213, 0 };
S sEF[] = { 212, 213, 0 };
S sPQO[] = { 223, 224, 222, 0 };
S sFNI[] = { 213, 221, 216, 0 };
S sAR[] = { 208, 225, 0 };
S sSFQ[] = { 226, 213, 224, 0 };
S sLg[] = { 219, a };
S sPOR[] = { 223, 222, 225, 0 };
S se7F[] = { 231, 213, 0 };
S sRg[] = { 225, a };
S sAKS[] = { 208, 218, 226, 0 };
S sKS[] = { 218, 226, 0 };
S sgPQF[] = { 32, 223, 224, 213, 0 };
S sIM[] = { 216, 220, 0 };
S sOL[] = { 222, 219, 0 };
S sOQ[] = { 222, 224, 0 };
S sRA[] = { 225, 208, 0 };
S sKAS[] = { 218, 208, 226, 0 };
S sAU[] = { 208, 228, 0 };
S sOP[] = { 222, 223, 0 };
S sgKA[] = { 32, 218, 208, 0 };
S sKea[] = { 218, 234, 0 };
S sAQI[] = { 208, 224, 216, 0 };
S sRSA[] = { 225, 226, 208, 0 };
S sKQ[] = { 218, 224, 0 };
S sRL[] = { 225, 219, 0 };
S sgFg[] = { 32, 213, a };
S sAL[] = { 208, 219, 0 };
S sOSO[] = { 222, 226, 222, 0 };
S sgBA[] = { 32, 209, 208, 0 };
S sANF[] = { 208, 221, 213, 0 };
S sQFH[] = { 224, 213, 215, 0 };
S sKIg[] = { 218, 216, a };
S sCef[] = { 210, 239, 0 };
S sNFg[] = { 221, 213, a };
S sgEO[] = { 32, 212, 222, 0 };
S sINA[] = { 216, 221, 208, 0 };
S sgOSg[] = { 32, 222, 226, a };
S sRSFN[] = { 225, 226, 213, 221, 0 };
S sACef[] = { 208, 210, 239, 0 };
S sIRS[] = { 216, 225, 226, 0 };
S sFQI[] = { 213, 224, 216, 0 };
S sFLN[] = { 213, 219, 221, 0 };
S sBO[] = { 209, 222, 0 };
S sDO[] = { 211, 222, 0 };
S se7N[] = { 231, 221, 0 };
S sNOR[] = { 221, 222, 225, 0 };
S sSFN[] = { 226, 213, 221, 0 };
S sPQI[] = { 223, 224, 216, 0 };
S sgHAg[] = { 32, 215, 208, a };
S sISFL[] = { 216, 226, 213, 219, 0 };
S sFC[] = { 213, 210, 0 };
S sOSg[] = { 222, 226, a };
S sOSOg[] = { 222, 226, 222, a };
S sBI[] = { 209, 216, 0 };
S sLAC[] = { 219, 208, 210, 0 };
S sDQ[] = { 211, 224, 0 };
S sgPQI[] = { 32, 223, 224, 216, 0 };
S sgRS[] = { 32, 225, 226, 0 };
S sSFL[] = { 226, 213, 219, 0 };
S sIF[] = { 216, 213, 0 };
S sgc0[] = { 32, 192, 0 };
S sOJ[] = { 222, 217, 0 };
S sKSF[] = { 218, 226, 213, 0 };
S sNIef[] = { 221, 216, 239, 0 };
S sLNI[] = { 219, 221, 216, 0 };
S sEg[] = { 212, a };
S se7A[] = { 231, 208, 0 };
S sgT[] = { 32, 227, 0 };
S sCAS[] = { 210, 208, 226, 0 };
S sSFLN[] = { 226, 213, 219, 221, 0 };
S sIHI[] = { 216, 215, 216, 0 };
S sBAK[] = { 209, 208, 218, 0 };
S sRC[] = { 225, 210, 0 };
S sSNO[] = { 226, 221, 222, 0 };
S sIFg[] = { 216, 213, a };
S sNIefg[] = { 221, 216, 239, a };
S sAKSF[] = { 208, 218, 226, 213, 0 };
S sgRea[] = { 32, 225, 234, 0 };
S sAP[] = { 208, 223, 0 };
S sgc1[] = { 32, 193, 0 };
S sSFQI[] = { 226, 213, 224, 216, 0 };
S sOH[] = { 222, 215, 0 };
S sDQA[] = { 211, 224, 208, 0 };
S sIL[] = { 216, 219, 0 };
S sRSO[] = { 225, 226, 222, 0 };
S sBAKS[] = { 209, 208, 218, 226, 0 };
S sFNS[] = { 213, 221, 226, 0 };
S sCAN[] = { 210, 208, 221, 0 };
S sKSFQ[] = { 218, 226, 213, 224, 0 };
S sgPQO[] = { 32, 223, 224, 222, 0 };
S se9F[] = { 233, 213, 0 };
S sgRg[] = { 32, 225, a };
S sQAS[] = { 224, 208, 226, 0 };
S sAB[] = { 208, 209, 0 };
S sRSg[] = { 225, 226, a };
S sgFE[] = { 32, 213, 212, 0 };
S sFK[] = { 213, 218, 0 };
S sefS[] = { 239, 226, 0 };
S sMg[] = { 220, a };
S sQAg[] = { 224, 208, a };
S sHIK[] = { 215, 216, 218, 0 };
S sCea[] = { 210, 234, 0 };
S sgKea[] = { 32, 218, 234, 0 };
S sASO[] = { 208, 226, 222, 0 };
S sFSI[] = { 213, 226, 216, 0 };
S sgRA[] = { 32, 225, 208, 0 };
S sCASg[] = { 210, 208, 226, a };
S sIRSF[] = { 216, 225, 226, 213, 0 };
S sgQFH[] = { 32, 224, 213, 215, 0 };
S sgc0A[] = { 32, 192, 208, 0 };
S sTR[] = { 227, 225, 0 };
S sPA[] = { 223, 208, 0 };
S sII[] = { 216, 216, 0 };
S sSQ[] = { 226, 224, 0 };
S sRSI[] = { 225, 226, 216, 0 };
S sc0A[] = { 192, 208, 0 };
S sHIR[] = { 215, 216, 225, 0 };
S sNORS[] = { 221, 222, 225, 226, 0 };
S sAE[] = { 208, 212, 0 };
S sFNSN[] = { 213, 221, 226, 221, 0 };
S sNRK[] = { 221, 225, 218, 0 };
S sCOg[] = { 210, 222, a };
S sPF[] = { 223, 213, 0 };
S sLACef[] = { 219, 208, 210, 239, 0 };
S sLIg[] = { 219, 216, a };
S sUA[] = { 228, 208, 0 };
S sQANI[] = { 224, 208, 221, 216, 0 };
S sQFHI[] = { 224, 213, 215, 216, 0 };
S sgc8[] = { 32, 200, 0 };
S sRKA[] = { 225, 218, 208, 0 };
S sgc8A[] = { 32, 200, 208, 0 };
S sRLA[] = { 225, 219, 208, 0 };
S sHC[] = { 215, 210, 0 };
S sQT[] = { 224, 227, 0 };
S sefCA[] = { 239, 210, 208, 0 };
S sefC[] = { 239, 210, 0 };
S sSCO[] = { 226, 210, 222, 0 };
S sIIg[] = { 216, 216, a };
S sRAg[] = { 225, 208, a };
S sHIRS[] = { 215, 216, 225, 226, 0 };
S sgBAK[] = { 32, 209, 208, 218, 0 };
S sSNI[] = { 226, 221, 216, 0 };
S sCefN[] = { 210, 239, 221, 0 };
S sFNg[] = { 213, 221, a };
S sFM[] = { 213, 220, 0 };
S sgbd[] = { 32, 189, 0 };
S sHN[] = { 215, 221, 0 };
S sGN[] = { 214, 221, 0 };
S sON[] = { 222, 221, 0 };
S sQAB[] = { 224, 208, 209, 0 };
S sc8A[] = { 200, 208, 0 };
S sCANF[] = { 210, 208, 221, 213, 0 };
S sgFH[] = { 32, 213, 215, 0 };
S sgFHI[] = { 32, 213, 215, 216, 0 };
S sHIKg[] = { 215, 216, 218, a };
S sDL[] = { 211, 219, 0 };
S sQFE[] = { 224, 213, 212, 0 };
S sDAQ[] = { 211, 208, 224, 0 };
S sefNRK[] = { 239, 221, 225, 218, 0 };
S sACefN[] = { 208, 210, 239, 221, 0 };
S sCefNR[] = { 210, 239, 221, 225, 0 };
S sefNR[] = { 239, 221, 225, 0 };
S seaL[] = { 234, 219, 0 };
S sNRS[] = { 221, 225, 226, 0 };
S sACA[] = { 208, 210, 208, 0 };
S sSK[] = { 226, 218, 0 };
S sSFNS[] = { 226, 213, 221, 226, 0 };
S sRSCO[] = { 225, 226, 210, 222, 0 };
S sNef[] = { 221, 239, 0 };
S sRSAC[] = { 225, 226, 208, 210, 0 };
S sMA[] = { 220, 208, 0 };
S se9A[] = { 233, 208, 0 };
S sQIK[] = { 224, 216, 218, 0 };
S sNSN[] = { 221, 226, 221, 0 };
S sgb1[] = { 32, 177, 0 };
S sgc8AU[] = { 32, 200, 208, 228, 0 };
S sc8AU[] = { 200, 208, 228, 0 };
S sgIH[] = { 32, 216, 215, 0 };
S sQIKg[] = { 224, 216, 218, a };
S sSAC[] = { 226, 208, 210, 0 };
S sgPOR[] = { 32, 223, 222, 225, 0 };
S sgMO[] = { 32, 220, 222, 0 };
S sFHIR[] = { 213, 215, 216, 225, 0 };
S sKAg[] = { 218, 208, a };
S sRLAC[] = { 225, 219, 208, 210, 0 };
S sefN[] = { 239, 221, 0 };
S sPI[] = { 223, 216, 0 };
S sgc0Ae8[] = { 32, 192, 208, 232, 0 };
S sABO[] = { 208, 209, 222, 0 };
S sgKAS[] = { 32, 218, 208, 226, 0 };
S sAe8K[] = { 208, 232, 218, 0 };
S sHM[] = { 215, 220, 0 };
S sgPOg[] = { 32, 223, 222, a };
S sBOS[] = { 209, 222, 226, 0 };
S sST[] = { 226, 227, 0 };
S sANFg[] = { 208, 221, 213, a };
S sKASA[] = { 218, 208, 226, 208, 0 };
S sc8AUA[] = { 200, 208, 228, 208, 0 };
S sQABO[] = { 224, 208, 209, 222, 0 };
S sgb8[] = { 32, 184, 0 };
S sRO[] = { 225, 222, 0 };
S seaC[] = { 234, 210, 0 };
S sQIg[] = { 224, 216, a };
S sIW[] = { 216, 230, 0 };
S sPORS[] = { 223, 222, 225, 226, 0 };
S sFHIK[] = { 213, 215, 216, 218, 0 };
S sFEI[] = { 213, 212, 216, 0 };
S sOef[] = { 222, 239, 0 };
S sUAQI[] = { 228, 208, 224, 216, 0 };
S sIO[] = { 216, 222, 0 };
S sQOR[] = { 224, 222, 225, 0 };
S sgANS[] = { 32, 208, 221, 226, 0 };
S sICA[] = { 216, 210, 208, 0 };
S sODQ[] = { 222, 211, 224, 0 };
S sUI[] = { 228, 216, 0 };
S sRQ[] = { 225, 224, 0 };
S sDF[] = { 211, 213, 0 };
S sRP[] = { 225, 223, 0 };
S sgRAg[] = { 32, 225, 208, a };
S sAQIK[] = { 208, 224, 216, 218, 0 };
S sgRQ[] = { 32, 225, 224, 0 };
S sABOS[] = { 208, 209, 222, 226, 0 };
S sAUAQ[] = { 208, 228, 208, 224, 0 };
S sc0Ae8K[] = { 192, 208, 232, 218, 0 };
S sb7A[] = { 183, 208, 0 };
S sNOS[] = { 221, 222, 226, 0 };
S sQg[] = { 224, a };
S sRKIg[] = { 225, 218, 216, a };
S sAe8[] = { 208, 232, 0 };
S sANSI[] = { 208, 221, 226, 216, 0 };
S sANS[] = { 208, 221, 226, 0 };
S sgb7A[] = { 32, 183, 208, 0 };
S se8K[] = { 232, 218, 0 };
S sIQAg[] = { 216, 224, 208, a };
S sBQ[] = { 209, 224, 0 };
S sODQA[] = { 222, 211, 224, 208, 0 };
S sAUA[] = { 208, 228, 208, 0 };
S sAe8KO[] = { 208, 232, 218, 222, 0 };
S sAM[] = { 208, 220, 0 };
S sNIFg[] = { 221, 216, 213, a };
S sc0Ae8[] = { 192, 208, 232, 0 };
S sgb7[] = { 32, 183, 0 };
S sgAN[] = { 32, 208, 221, 0 };
S se9Fg[] = { 233, 213, a };
S sNOSO[] = { 221, 222, 226, 222, 0 };
S sJg[] = { 217, a };
S sNIF[] = { 221, 216, 213, 0 };
S se8KO[] = { 232, 218, 222, 0 };
S sIWI[] = { 216, 230, 216, 0 };
S sINAg[] = { 216, 221, 208, a };
S sDOg[] = { 211, 222, a };
S sgQA[] = { 32, 224, 208, 0 };

N l4n1[] = { { sRKI, .547 }, H };
N l4n2[] = { { sOg, 4.334 }, { sIKg, 1.010 }, { sSFN, .421 }, H };
N l4n4[] = { { sEI, .365 }, { sANF, .463 }, H };
N l4n5[] = { { sgF, .542 }, H };
N l4n6[] = { { sgMO, .196 }, H };
N l4n7[] = { { sIef, .814 }, { se9A, .196 }, { sgb7, .112 }, H };
N l4n8[] = { { sIQ, .421 }, { sPQF, .589 }, { sc8A, .196 }, { sc0Ae8, .252 }, H };
N l4n10[] = { { sQFHI, .393 }, { sICA, .252 }, H };
N l4n11[] = { { sSN, .505 }, H };
N l4n12[] = { { sHIR, .337 }, H };
N l4n13[] = { { sBO, .281 }, H };
N l4n14[] = { { sRP, .168 }, H };
N l4n15[] = { { sRA, .337 }, H };
N l4n16[] = { { sAQ, .701 }, { sc0A, .224 }, { sPORS, .337 }, H };
N l4n17[] = { { sefg, 1.431 }, { sAB, .224 }, H };
N l4n18[] = { { sFH, .505 }, { sNRK, .295 }, { sACA, .295 }, H };
N l4n21[] = { { sFSI, .337 }, H };
N l4n23[] = { { sgHA, .533 }, H };
N l4n24[] = { { sgc8A, .196 }, { sDL, .196 }, { sgb8, .112 }, H };
N l4n25[] = { { sIR, .477 }, H };
N l4n26[] = { { sIC, .393 }, H };
N l4n27[] = { { sNI, 2.076 }, { sANSI, .337 }, H };
N l4n28[] = { { sSO, 1.571 }, { se8KO, .252 }, H };
N l4n30[] = { { se7F, .337 }, { sKIg, .694 }, H };
N l4n31[] = { { sBA, .365 }, { sHIKg, .589 }, { sRQ, .168 }, H };
N l4n33[] = { { sAR, .337 }, { sgFE, .224 }, { sgRAg, .224 }, H };
N l4n34[] = { { sAC, .786 }, { sASA, .673 }, H };
N l4n35[] = { { sSFQ, .505 }, { sBAKS, .505 }, H };
N l4n36[] = { { sKO, 1.094 }, H };
N l4n37[] = { { sANI, .800 }, { sINAg, .505 }, H };
N l4n38[] = { { sPF, .196 }, H };
N l4n39[] = { { sgH, .374 }, { sFEI, .252 }, H };
N l4n40[] = { { sLACef, .393 }, { sgc8, .131 }, H };
N l4n41[] = { { sPQI, .421 }, { sOH, .252 }, H };
N l4n42[] = { { sIS, 1.291 }, H };
N l4n44[] = { { sCO, .589 }, { sNOR, .421 }, H };
N l4n46[] = { { sSA, 1.347 }, { sFNS, .379 }, H };
N l4n47[] = { { sKSFQ, .505 }, { sBQ, .168 }, { sgAN, .168 }, H };
N l4n48[] = { { sRLAC, .393 }, H };
N l4n49[] = { { sRSA, .463 }, { sRC, .252 }, { sgRg, .224 }, H };
N l4n50[] = { { sAS, 1.319 }, { sgCg, .505 }, { sLN, .449 }, { sWI, .365 }, H };
N l4n51[] = { { sQT, .196 }, H };
N l4n52[] = { { sSAC, .295 }, H };
N l4n54[] = { { sKA, .898 }, { sQIKg, .589 }, H };
N l4n55[] = { { sge7, .206 }, { sNOS, .252 }, H };
N l4n56[] = { { sgI, .767 }, H };
N l4n57[] = { { sgPO, .701 }, { sHAg, .884 }, H };
N l4n60[] = { { sCANF, .393 }, H };
N l4n61[] = { { sLIg, .442 }, H };
N l4n62[] = { { sCA, 1.122 }, { sSQ, .224 }, H };
N l4n63[] = { { sgBAK, .262 }, H };
N l4n64[] = { { sQg, .252 }, H };
N l4n65[] = { { sRS, 2.272 }, { sABOS, .337 }, H };
N l4n66[] = { { sgFH, .196 }, { sNIF, .252 }, H };
N l4n68[] = { { sgEAg, .673 }, { sOSg, .631 }, { sAE, .224 }, { sNSN, .295 }, { sc8AUA, .337 }, { sAUA, .252 }, H };
N l4n69[] = { { sQF, 1.178 }, { sFK, .224 }, H };
N l4n70[] = { { sKQ, .309 }, H };
N l4n71[] = { { sRSC, .673 }, H };
N l4n72[] = { { sIg, 4.755 }, { sNFg, .694 }, { sgc0Ae8, .224 }, { seaC, .168 }, H };
N l4n73[] = { { sefNR, .295 }, H };
N l4n74[] = { { sgKA, .309 }, H };
N l4n75[] = { { sDO, .281 }, { sOJ, .252 }, H };
N l4n77[] = { { sCef, .309 }, { sIF, .281 }, H };
N l4n78[] = { { sIRSF, .449 }, H };
N l4n79[] = { { sgPQ, .926 }, H };
N l4n80[] = { { sAg, 7.827 }, { sSC, .533 }, { sNISF, 1.010 }, { sQAg, .505 }, H };
N l4n81[] = { { sISF, 1.641 }, { se7I, .365 }, H };
N l4n83[] = { { sSNI, .295 }, H };
N l4n84[] = { { sgOS, .617 }, { sAU, .337 }, { sCASg, .673 }, H };
N l4n85[] = { { sLA, .393 }, H };
N l4n86[] = { { sFL, .505 }, H };
N l4n87[] = { { sFSO, .631 }, H };
N l4n88[] = { { sgRFg, .823 }, { sAQI, .463 }, { sIQAg, .505 }, H };
N l4n89[] = { { sPI, .168 }, H };
N l4n90[] = { { sgK, .804 }, { sFHI, .589 }, H };
N l4n91[] = { { sLAC, .421 }, H };
N l4n92[] = { { se9F, .224 }, { sKASA, .337 }, H };
N l4n93[] = { { sDA, .421 }, { sDQA, .379 }, H };
N l4n95[] = { { sRg, .505 }, H };
N l4n96[] = { { sAKS, .505 }, { sNIef, .379 }, H };
N l4n97[] = { { sHI, .786 }, { sQFE, .295 }, { sRKIg, .505 }, H };
N l4n98[] = { { sMO, .421 }, H };
N l4n100[] = { { sRF, .757 }, { sANFg, .505 }, H };
N l4n101[] = { { sgFg, .309 }, H };
N l4n103[] = { { sIefg, 1.641 }, { sACef, .421 }, { sFM, .196 }, { sJg, .252 }, H };
N l4n104[] = { { sRSF, .547 }, { sKS, .337 }, { sgKea, .224 }, H };
N l4n106[] = { { sEO, .421 }, { sPOR, .505 }, { sNRS, .295 }, H };
N l4n107[] = { { sPQO, .547 }, H };
N l4n108[] = { { sgQFH, .299 }, { sUA, .196 }, H };
N l4n109[] = { { sOL, .337 }, { sDQ, .281 }, { sgbd, .131 }, H };
N l4n110[] = { { sOSO, .463 }, { sTR, .224 }, { sIW, .168 }, H };
N l4n111[] = { { sIH, .673 }, { sQAN, .547 }, { sRAg, .442 }, { sCefNR, .393 }, H };
N l4n113[] = { { sST, .168 }, { sgRQ, .168 }, H };
N l4n114[] = { { sFRS, .589 }, H };
N l4n116[] = { { sMA, .196 }, H };
N l4n117[] = { { sgIH, .196 }, H };
N l4n119[] = { { sAH, .421 }, { sgHAg, .374 }, H };
N l4n120[] = { { sFN, 1.234 }, { sQI, 1.094 }, H };
N l4n122[] = { { sLNI, .379 }, H };
N l4n123[] = { { sNIg, 1.641 }, H };
N l4n124[] = { { sSOg, 2.525 }, { sEA, .786 }, { sgM, .393 }, H };
N l4n125[] = { { sgNA, 1.515 }, { sBAK, .379 }, H };
N l4n126[] = { { sSg, 2.230 }, { sgEO, .281 }, H };
N l4n127[] = { { sIe7, .421 }, H };
N l4n128[] = { { sII, .224 }, H };
N l4n129[] = { { sNO, 1.094 }, H };
N l4n130[] = { { sASAg, 1.094 }, { sQFH, .463 }, H };
N l4n131[] = { { sSF, 1.908 }, { sSFLN, .505 }, H };
N l4n132[] = { { sKOg, .884 }, H };
N l4n133[] = { { sQABO, .337 }, { sODQ, .252 }, H };
N l4n134[] = { { sKg, .715 }, H };
N l4n135[] = { { sgRS, .281 }, H };
N l4n137[] = { { sORS, .842 }, { sRSI, .337 }, { sQOR, .252 }, H };
N l4n140[] = { { sCOg, .442 }, H };
N l4n141[] = { { sgN, 1.421 }, H };
N l4n142[] = { { sCg, 1.136 }, { sSAg, 1.704 }, H };
N l4n143[] = { { sgbf, .281 }, { sKSF, .379 }, { sON, .196 }, H };
N l4n144[] = { { sgc0A, .224 }, { sAe8KO, .337 }, H };
N l4n146[] = { { sASg, 1.262 }, { se8K, .168 }, H };
N l4n147[] = { { sNA, 2.665 }, { sCF, .645 }, { sANS, .252 }, H };
N l4n148[] = { { sUAQI, .337 }, H };
N l4n149[] = { { sSNO, .379 }, H };
N l4n150[] = { { sKAg, .442 }, { sc0Ae8K, .337 }, H };
N l4n151[] = { { sRI, .449 }, { sGN, .196 }, H };
N l4n152[] = { { sgIg, .617 }, { sAe8, .168 }, H };
N l4n153[] = { { sgPOg, .224 }, H };
N l4n155[] = { { sABO, .252 }, H };
N l4n158[] = { { sgO, .748 }, { sCAg, 1.010 }, { sefN, .196 }, H };
N l4n160[] = { { sgc0, .187 }, H };
N l4n161[] = { { sRSg, .505 }, { sgb1, .131 }, H };
N l4n162[] = { { sIK, .673 }, { sNef, .196 }, { sNIFg, .505 }, H };
N l4n165[] = { { sLg, .505 }, { sHM, .168 }, H };
N l4n166[] = { { se7N, .281 }, { sQAS, .337 }, H };
N l4n167[] = { { sBI, .281 }, { sRSAC, .393 }, H };
N l4n168[] = { { sSFNS, .393 }, H };
N l4n169[] = { { sRKA, .295 }, H };
N l4n170[] = { { sAK, .729 }, { sLF, .449 }, H };
N l4n171[] = { { sFQ, .673 }, { sSFQI, .505 }, { sDOg, .379 }, H };
N l4n173[] = { { sIFg, .568 }, H };
N l4n175[] = { { sgP, 1.272 }, H };
N l4n176[] = { { sgA, .243 }, { sgQA, .168 }, H };
N l4n177[] = { { sISFg, 2.357 }, { sOP, .337 }, { sgBA, .309 }, { sgc1, .168 }, H };
N l4n178[] = { { sHIRS, .393 }, { sDF, .168 }, H };
N l4n179[] = { { sIL, .252 }, H };
N l4n180[] = { { sNR, .449 }, { sgNF, .393 }, { sgOSg, .374 }, H };
N l4n182[] = { { sSI, .842 }, { sHN, .196 }, { sIWI, .252 }, H };
N l4n183[] = { { sFSOg, 1.178 }, { sIHI, .379 }, H };
N l4n185[] = { { sRK, .701 }, H };
N l4n186[] = { { sRLA, .295 }, H };
N l4n187[] = { { sAL, .309 }, H };
N l4n188[] = { { sFR, .673 }, { sASO, .337 }, { se9Fg, .379 }, H };
N l4n189[] = { { sFC, .281 }, { sCAN, .379 }, H };
N l4n190[] = { { sKI, .533 }, H };
N l4n191[] = { { sPO, 1.010 }, { sHIK, .337 }, H };
N l4n192[] = { { sgQ, .430 }, { sFNI, .547 }, { sNIefg, .757 }, H };
N l4n193[] = { { sgB, .411 }, { sgRA, .224 }, { sOef, .168 }, H };
N l4n194[] = { { sOQ, .337 }, H };
N l4n195[] = { { sOB, .421 }, { sBOS, .252 }, H };
N l4n196[] = { { sRFg, 1.389 }, { sIM, .337 }, { sMg, .337 }, { sgc8AU, .262 }, H };
N l4n197[] = { { sNS, .477 }, { sINA, .421 }, { sFNSN, .393 }, H };
N l4n198[] = { { sCI, .477 }, H };
N l4n201[] = { { sRea, .393 }, { sMF, .365 }, { se7A, .252 }, H };
N l4n202[] = { { sRL, .309 }, { sgFHI, .262 }, H };
N l4n203[] = { { sRSO, .379 }, H };
N l4n204[] = { { sEg, .379 }, { sCefN, .295 }, { sAM, .168 }, H };
N l4n205[] = { { sFS, .926 }, H };
N l4n206[] = { { sgPQF, .449 }, { sOSOg, .842 }, H };
N l4n207[] = { { sIRS, .421 }, H };
N l4n209[] = { { sgR, 1.534 }, { sNIS, .757 }, { sEF, .365 }, { sPA, .224 }, { sNOSO, .337 }, H };
N l4n210[] = { { sgC, .767 }, { sNORS, .449 }, H };
N l4n211[] = { { sOR, 1.094 }, { sefCA, .295 }, H };
N l4n212[] = { { sOC, .365 }, { sc8AU, .295 }, H };
N l4n213[] = { { sIN, .645 }, { sFLN, .421 }, { sgANS, .224 }, H };
N l4n214[] = { { sQIK, .295 }, H };
N l4n215[] = { { sgPQI, .374 }, { sefNRK, .393 }, H };
N l4n216[] = { { sFNg, .442 }, { sSK, .196 }, { sQIg, .379 }, H };
N l4n217[] = { { sHA, .645 }, H };
N l4n218[] = { { sSCO, .295 }, H };
N l4n220[] = { { sEAg, 1.262 }, { sgPOR, .262 }, H };
N l4n221[] = { { sgNAg, 1.683 }, { sAN, 1.206 }, { sLI, .673 }, H };
N l4n222[] = { { sQO, .898 }, H };
N l4n223[] = { { sFE, .645 }, { sAKSF, .505 }, { sgRea, .252 }, H };
N l4n224[] = { { sIIg, .442 }, H };
N l4n225[] = { { sPQ, 1.150 }, { sNOg, 1.010 }, { seaL, .196 }, { sRSCO, .393 }, H };
N l4n226[] = { { sgS, .411 }, { sISFL, .561 }, H };
N l4n227[] = { { sSFg, 1.894 }, { sgD, .318 }, { sNg, .547 }, { sefC, .196 }, H };
N l4n228[] = { { sOS, 1.291 }, { sgEA, .533 }, { sgKO, .365 }, { sAUAQ, .337 }, H };
N l4n229[] = { { sOD, .533 }, H };
N l4n230[] = { { sIO, .168 }, { sAQIK, .337 }, H };
N l4n231[] = { { sgQF, .393 }, H };
N l4n232[] = { { sNF, .786 }, { sFHIK, .337 }, H };
N l4n233[] = { { sgPQO, .337 }, H };
N l4n235[] = { { sFg, 4.040 }, { sQAB, .295 }, H };
N l4n236[] = { { sKAS, .505 }, { sSFL, .421 }, H };
N l4n240[] = { { sQA, 1.543 }, { sKea, .309 }, { sgKAS, .224 }, H };
N l4n243[] = { { sNAg, 4.356 }, { sFQI, .421 }, { sgT, .168 }, { sefS, .224 }, H };
N l4n244[] = { { sgE, .692 }, { sCAS, .379 }, { sUI, .168 }, H };
N l4n245[] = { { sODQA, .337 }, H };
N l4n246[] = { { sOE, .393 }, { sAe8K, .252 }, H };
N l4n247[] = { { sQANI, .393 }, { sgb7A, .168 }, H };
N l4n248[] = { { sgRF, .673 }, { sIQA, .547 }, { sCea, .224 }, H };
N l4n249[] = { { sb7A, .112 }, H };
N l4n251[] = { { sHC, .196 }, H };
N l4n252[] = { { sMI, .421 }, H };
N l4n253[] = { { sDAQ, .295 }, { sFHIR, .393 }, { sRO, .168 }, H };
N l4n254[] = { { sACefN, .393 }, H };
N l4n255[] = { { sRSFN, .561 }, { sAP, .252 }, H };

D l4_d = {
	"bulgarian",
	"iso-8859-5",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, 0.001, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, 0.001, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    0.005, 0.005, 0.004, 0.001, 0.001, 0.001, Y, 0.005, 0.004, 0.002, 0.001, 0.001, 0.003, 0.006, 0.001, 0.012,
	    0.008, 0.011, 0.003, 0.002, 0.002, V, 0.001, V, 0.008, V, V, V, V, V, V, V,
	    0.525, 0.063, 0.192, 0.067, 0.116, 0.385, 0.024, 0.107, 0.439, 0.017, 0.181, 0.113, 0.079, 0.333, 0.395, 0.125,
	    0.232, 0.259, 0.373, 0.047, 0.027, 0.016, 0.020, 0.058, 0.015, 0.021, 0.059, V, V, V, 0.002, 0.083,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ X, l4n1, l4n2, X, l4n4, l4n5, l4n6, l4n7, l4n8, X, l4n10, l4n11, l4n12, l4n13, l4n14, l4n15,
	    l4n16, l4n17, l4n18, X, X, l4n21, X, l4n23, l4n24, l4n25, l4n26, l4n27, l4n28, X, l4n30, l4n31,
	    X, l4n33, l4n34, l4n35, l4n36, l4n37, l4n38, l4n39, l4n40, l4n41, l4n42, X, l4n44, X, l4n46, l4n47,
	    l4n48, l4n49, l4n50, l4n51, l4n52, X, l4n54, l4n55, l4n56, l4n57, X, X, l4n60, l4n61, l4n62, l4n63,
	    l4n64, l4n65, l4n66, X, l4n68, l4n69, l4n70, l4n71, l4n72, l4n73, l4n74, l4n75, X, l4n77, l4n78, l4n79,
	    l4n80, l4n81, X, l4n83, l4n84, l4n85, l4n86, l4n87, l4n88, l4n89, l4n90, l4n91, l4n92, l4n93, X, l4n95,
	    l4n96, l4n97, l4n98, X, l4n100, l4n101, X, l4n103, l4n104, X, l4n106, l4n107, l4n108, l4n109, l4n110, l4n111,
	    X, l4n113, l4n114, X, l4n116, l4n117, X, l4n119, l4n120, X, l4n122, l4n123, l4n124, l4n125, l4n126, l4n127,
	    l4n128, l4n129, l4n130, l4n131, l4n132, l4n133, l4n134, l4n135, X, l4n137, X, X, l4n140, l4n141, l4n142, l4n143,
	    l4n144, X, l4n146, l4n147, l4n148, l4n149, l4n150, l4n151, l4n152, l4n153, X, l4n155, X, X, l4n158, X,
	    l4n160, l4n161, l4n162, X, X, l4n165, l4n166, l4n167, l4n168, l4n169, l4n170, l4n171, X, l4n173, X, l4n175,
	    l4n176, l4n177, l4n178, l4n179, l4n180, X, l4n182, l4n183, X, l4n185, l4n186, l4n187, l4n188, l4n189, l4n190, l4n191,
	    l4n192, l4n193, l4n194, l4n195, l4n196, l4n197, l4n198, X, X, l4n201, l4n202, l4n203, l4n204, l4n205, l4n206, l4n207,
	    X, l4n209, l4n210, l4n211, l4n212, l4n213, l4n214, l4n215, l4n216, l4n217, l4n218, X, l4n220, l4n221, l4n222, l4n223,
	    l4n224, l4n225, l4n226, l4n227, l4n228, l4n229, l4n230, l4n231, l4n232, l4n233, X, l4n235, l4n236, X, X, X,
	    l4n240, X, X, l4n243, l4n244, l4n245, l4n246, l4n247, l4n248, l4n249, X, l4n251, l4n252, l4n253, l4n254, l4n255 }
};

//
// Lng: bulgarian
// Enc: utf8
//

S sAb0[] = { 208, 176, 0 };
S sAb8[] = { 208, 184, 0 };
S sAbe[] = { 208, 190, 0 };
S sAb5[] = { 208, 181, 0 };
S sB82[] = { 209, 130, 0 };
S sAbd[] = { 208, 189, 0 };
S sB82A[] = { 209, 130, 208, 0 };
S s82A[] = { 130, 208, 0 };
S sbdA[] = { 189, 208, 0 };
S sAbdA[] = { 208, 189, 208, 0 };
S sB81[] = { 209, 129, 0 };
S sB80[] = { 209, 128, 0 };
S sAb0g[] = { 208, 176, a };
S sb0g[] = { 176, a };
S s80A[] = { 128, 208, 0 };
S sB80A[] = { 209, 128, 208, 0 };
S sAb2[] = { 208, 178, 0 };
S sAb0A[] = { 208, 176, 208, 0 };
S sb0A[] = { 176, 208, 0 };
S sAba[] = { 208, 186, 0 };
S sb5A[] = { 181, 208, 0 };
S sAb5A[] = { 208, 181, 208, 0 };
S sAb8A[] = { 208, 184, 208, 0 };
S sb8A[] = { 184, 208, 0 };
S sAb8B[] = { 208, 184, 209, 0 };
S sb8B[] = { 184, 209, 0 };
S sAbeA[] = { 208, 190, 208, 0 };
S sbeA[] = { 190, 208, 0 };
S sAbeB[] = { 208, 190, 209, 0 };
S sbeB[] = { 190, 209, 0 };
S s81A[] = { 129, 208, 0 };
S sB81A[] = { 209, 129, 208, 0 };
S sb0B[] = { 176, 209, 0 };
S sAb0B[] = { 208, 176, 209, 0 };
S sb8g[] = { 184, a };
S sAb8g[] = { 208, 184, a };
S sAb2A[] = { 208, 178, 208, 0 };
S sb2A[] = { 178, 208, 0 };
S sAbf[] = { 208, 191, 0 };
S sAbeg[] = { 208, 190, a };
S s81B[] = { 129, 209, 0 };
S sAb4[] = { 208, 180, 0 };
S sB81B[] = { 209, 129, 209, 0 };
S sbeg[] = { 190, a };
S sAbaA[] = { 208, 186, 208, 0 };
S sbaA[] = { 186, 208, 0 };
S sAbb[] = { 208, 187, 0 };
S sb5B[] = { 181, 209, 0 };
S sAb5B[] = { 208, 181, 209, 0 };
S sb5g[] = { 181, a };
S sAb5g[] = { 208, 181, a };
S sbdAb0[] = { 189, 208, 176, 0 };
S sAb7[] = { 208, 183, 0 };
S sAbdAb0[] = { 208, 189, 208, 176, 0 };
S sAb7A[] = { 208, 183, 208, 0 };
S sbbA[] = { 187, 208, 0 };
S sAbbA[] = { 208, 187, 208, 0 };
S sgB81[] = { 32, 209, 129, 0 };
S s81B82[] = { 129, 209, 130, 0 };
S sB81B82[] = { 209, 129, 209, 130, 0 };
S sAb4A[] = { 208, 180, 208, 0 };
S sb4A[] = { 180, 208, 0 };
S sgAbd[] = { 32, 208, 189, 0 };
S sB8f[] = { 209, 143, 0 };
S sbdAb8[] = { 189, 208, 184, 0 };
S sAbdAb8[] = { 208, 189, 208, 184, 0 };
S sgAbdA[] = { 32, 208, 189, 208, 0 };
S sAbc[] = { 208, 188, 0 };
S sbdAb0g[] = { 189, 208, 176, a };
S sB82Ab5[] = { 209, 130, 208, 181, 0 };
S sgAbf[] = { 32, 208, 191, 0 };
S s82Ab5[] = { 130, 208, 181, 0 };
S sAb3[] = { 208, 179, 0 };
S s81B82A[] = { 129, 209, 130, 208, 0 };
S sbfA[] = { 191, 208, 0 };
S sAbfA[] = { 208, 191, 208, 0 };
S sAb1[] = { 208, 177, 0 };
S sB82Abe[] = { 209, 130, 208, 190, 0 };
S sAbcA[] = { 208, 188, 208, 0 };
S s82Abe[] = { 130, 208, 190, 0 };
S sbcA[] = { 188, 208, 0 };
S s80Ab0[] = { 128, 208, 176, 0 };
S sB80Ab0[] = { 209, 128, 208, 176, 0 };
S sB8a[] = { 209, 138, 0 };
S s82g[] = { 130, a };
S sB82g[] = { 209, 130, a };
S sB87[] = { 209, 135, 0 };
S sAbfB[] = { 208, 191, 209, 0 };
S sbfB[] = { 191, 209, 0 };
S sgB81A[] = { 32, 209, 129, 208, 0 };
S sB82Ab0[] = { 209, 130, 208, 176, 0 };
S s82Ab0[] = { 130, 208, 176, 0 };
S sAb0B82[] = { 208, 176, 209, 130, 0 };
S sb0B82[] = { 176, 209, 130, 0 };
S sbeB82[] = { 190, 209, 130, 0 };
S sAbeB82[] = { 208, 190, 209, 130, 0 };
S sAb8B82[] = { 208, 184, 209, 130, 0 };
S sb8B82[] = { 184, 209, 130, 0 };
S sB87A[] = { 209, 135, 208, 0 };
S s87A[] = { 135, 208, 0 };
S sb8B82A[] = { 184, 209, 130, 208, 0 };
S sAb1A[] = { 208, 177, 208, 0 };
S sb3A[] = { 179, 208, 0 };
S sb1A[] = { 177, 208, 0 };
S sb5Abd[] = { 181, 208, 189, 0 };
S sAb3A[] = { 208, 179, 208, 0 };
S sAb5Abd[] = { 208, 181, 208, 189, 0 };
S sb0Abd[] = { 176, 208, 189, 0 };
S sgAba[] = { 32, 208, 186, 0 };
S sAb0Abd[] = { 208, 176, 208, 189, 0 };
S sB80Ab5[] = { 209, 128, 208, 181, 0 };
S sB83[] = { 209, 131, 0 };
S sAbaB[] = { 208, 186, 209, 0 };
S sbdB[] = { 189, 209, 0 };
S sAbdB[] = { 208, 189, 209, 0 };
S sbaB[] = { 186, 209, 0 };
S s80Ab5[] = { 128, 208, 181, 0 };
S sgAb8[] = { 32, 208, 184, 0 };
S sAbfB80[] = { 208, 191, 209, 128, 0 };
S sbfB80[] = { 191, 209, 128, 0 };
S sgAb2[] = { 32, 208, 178, 0 };
S sAb2Ab0[] = { 208, 178, 208, 176, 0 };
S s82Abeg[] = { 130, 208, 190, a };
S sbfB80A[] = { 191, 209, 128, 208, 0 };
S sb2Ab0[] = { 178, 208, 176, 0 };
S sgAbe[] = { 32, 208, 190, 0 };
S s80Ab8[] = { 128, 208, 184, 0 };
S sbaAbe[] = { 186, 208, 190, 0 };
S sbeB81[] = { 190, 209, 129, 0 };
S sAbaAbe[] = { 208, 186, 208, 190, 0 };
S sbdAbe[] = { 189, 208, 190, 0 };
S sB80Ab8[] = { 209, 128, 208, 184, 0 };
S sAbdAbe[] = { 208, 189, 208, 190, 0 };
S sAbeB81[] = { 208, 190, 209, 129, 0 };
S sgAb4[] = { 32, 208, 180, 0 };
S sbfAbe[] = { 191, 208, 190, 0 };
S sgAbfB[] = { 32, 208, 191, 209, 0 };
S sAbfAbe[] = { 208, 191, 208, 190, 0 };
S sb0AbdA[] = { 176, 208, 189, 208, 0 };
S s8aA[] = { 138, 208, 0 };
S sB8aA[] = { 209, 138, 208, 0 };
S sbdAb8B[] = { 189, 208, 184, 209, 0 };
S s8fg[] = { 143, a };
S sB8fg[] = { 209, 143, a };
S sgAb4A[] = { 32, 208, 180, 208, 0 };
S sAb5B82[] = { 208, 181, 209, 130, 0 };
S sbeB82A[] = { 190, 209, 130, 208, 0 };
S s80Ab0A[] = { 128, 208, 176, 208, 0 };
S sb5B82[] = { 181, 209, 130, 0 };
S sAbaAb0[] = { 208, 186, 208, 176, 0 };
S s80Abe[] = { 128, 208, 190, 0 };
S sAb2B[] = { 208, 178, 209, 0 };
S sgAbfA[] = { 32, 208, 191, 208, 0 };
S sbaAb0[] = { 186, 208, 176, 0 };
S sb2B[] = { 178, 209, 0 };
S sB80Abe[] = { 209, 128, 208, 190, 0 };
S s82Ab5g[] = { 130, 208, 181, a };
S sB82Ab8[] = { 209, 130, 208, 184, 0 };
S sgAbaA[] = { 32, 208, 186, 208, 0 };
S s82Ab8[] = { 130, 208, 184, 0 };
S sgAb5[] = { 32, 208, 181, 0 };
S sAb8B8f[] = { 208, 184, 209, 143, 0 };
S sb8B8f[] = { 184, 209, 143, 0 };
S sgAbeB[] = { 32, 208, 190, 209, 0 };
S sb5B82A[] = { 181, 209, 130, 208, 0 };
S s82B[] = { 130, 209, 0 };
S sb4Ab0[] = { 180, 208, 176, 0 };
S sb7Ab8[] = { 183, 208, 184, 0 };
S sAbdAb5[] = { 208, 189, 208, 181, 0 };
S sbdAb5[] = { 189, 208, 181, 0 };
S sb0Ab2[] = { 176, 208, 178, 0 };
S sAb7Ab8[] = { 208, 183, 208, 184, 0 };
S sAb4Ab0[] = { 208, 180, 208, 176, 0 };
S sAb0Ab2[] = { 208, 176, 208, 178, 0 };
S sB82B[] = { 209, 130, 209, 0 };
S s80Ab5A[] = { 128, 208, 181, 208, 0 };
S s81Ab5[] = { 129, 208, 181, 0 };
S sb2g[] = { 178, a };
S s82Ab0g[] = { 130, 208, 176, a };
S sB81Ab5[] = { 209, 129, 208, 181, 0 };
S sAb2g[] = { 208, 178, a };
S sb0Aba[] = { 176, 208, 186, 0 };
S sAb0Aba[] = { 208, 176, 208, 186, 0 };
S sb8B8fg[] = { 184, 209, 143, a };
S sb0B82A[] = { 176, 209, 130, 208, 0 };
S sbdAb8g[] = { 189, 208, 184, a };
S s81Aba[] = { 129, 208, 186, 0 };
S s82Ab5A[] = { 130, 208, 181, 208, 0 };
S sAb0B80[] = { 208, 176, 209, 128, 0 };
S sb0B80[] = { 176, 209, 128, 0 };
S sb5AbdA[] = { 181, 208, 189, 208, 0 };
S sB81Aba[] = { 209, 129, 208, 186, 0 };
S sgB81B[] = { 32, 209, 129, 209, 0 };
S sb5B80[] = { 181, 209, 128, 0 };
S sAb5B81[] = { 208, 181, 209, 129, 0 };
S sb8Aba[] = { 184, 208, 186, 0 };
S sAb8Aba[] = { 208, 184, 208, 186, 0 };
S sAbbAb8[] = { 208, 187, 208, 184, 0 };
S s81AbaA[] = { 129, 208, 186, 208, 0 };
S sbbAb8[] = { 187, 208, 184, 0 };
S sAb5B80[] = { 208, 181, 209, 128, 0 };
S sB84[] = { 209, 132, 0 };
S sAb8Ab7[] = { 208, 184, 208, 183, 0 };
S sb5B81[] = { 181, 209, 129, 0 };
S sb8Ab7[] = { 184, 208, 183, 0 };
S s80Ab8A[] = { 128, 208, 184, 208, 0 };
S sb5Ab4[] = { 181, 208, 180, 0 };
S sAb7Ab0[] = { 208, 183, 208, 176, 0 };
S sAb5Ab4[] = { 208, 181, 208, 180, 0 };
S sAb2Ab5[] = { 208, 178, 208, 181, 0 };
S sAb8Abd[] = { 208, 184, 208, 189, 0 };
S sb2Ab5[] = { 178, 208, 181, 0 };
S sbaAbeA[] = { 186, 208, 190, 208, 0 };
S sb8Abd[] = { 184, 208, 189, 0 };
S sgB80[] = { 32, 209, 128, 0 };
S sb7Ab0[] = { 183, 208, 176, 0 };
S s80B[] = { 128, 209, 0 };
S sgAb1[] = { 32, 208, 177, 0 };
S sgAb8g[] = { 32, 208, 184, a };
S s81Ab5g[] = { 129, 208, 181, a };
S sbeB81B[] = { 190, 209, 129, 209, 0 };
S sB8fA[] = { 209, 143, 208, 0 };
S sgB82[] = { 32, 209, 130, 0 };
S sb8Ab7A[] = { 184, 208, 183, 208, 0 };
S s8fA[] = { 143, 208, 0 };
S sB80B[] = { 209, 128, 209, 0 };
S sgAbc[] = { 32, 208, 188, 0 };
S sAb2Abe[] = { 208, 178, 208, 190, 0 };
S sb2Abe[] = { 178, 208, 190, 0 };
S sAb6[] = { 208, 182, 0 };
S sb5B80A[] = { 181, 209, 128, 208, 0 };
S sb6A[] = { 182, 208, 0 };
S sAb6A[] = { 208, 182, 208, 0 };
S sgAb7A[] = { 32, 208, 183, 208, 0 };
S sb0B82g[] = { 176, 209, 130, a };
S s83B[] = { 131, 209, 0 };
S sB83A[] = { 209, 131, 208, 0 };
S sB83B[] = { 209, 131, 209, 0 };
S sgAb7[] = { 32, 208, 183, 0 };
S s83A[] = { 131, 208, 0 };
S sgB80A[] = { 32, 209, 128, 208, 0 };
S sb4Ab0g[] = { 180, 208, 176, a };
S s82Ab8A[] = { 130, 208, 184, 208, 0 };
S sb5Ab4A[] = { 181, 208, 180, 208, 0 };
S sbeAb3[] = { 190, 208, 179, 0 };
S s82Ab2[] = { 130, 208, 178, 0 };
S sbaAb8[] = { 186, 208, 184, 0 };
S sB82Ab2[] = { 209, 130, 208, 178, 0 };
S sgAb1A[] = { 32, 208, 177, 208, 0 };
S sAbaAb8[] = { 208, 186, 208, 184, 0 };
S sAbeAb3[] = { 208, 190, 208, 179, 0 };
S sb0B80A[] = { 176, 209, 128, 208, 0 };
S sB89[] = { 209, 137, 0 };
S sgAb8A[] = { 32, 208, 184, 208, 0 };
S sB86[] = { 209, 134, 0 };
S s84A[] = { 132, 208, 0 };
S s82Abd[] = { 130, 208, 189, 0 };
S sB82Abd[] = { 209, 130, 208, 189, 0 };
S sb5Abb[] = { 181, 208, 187, 0 };
S sAb5Ab7[] = { 208, 181, 208, 183, 0 };
S s82AbdA[] = { 130, 208, 189, 208, 0 };
S sB8fB[] = { 209, 143, 209, 0 };
S sgAb2g[] = { 32, 208, 178, a };
S sb0Ab2A[] = { 176, 208, 178, 208, 0 };
S s82Ab2A[] = { 130, 208, 178, 208, 0 };
S s82Ab0A[] = { 130, 208, 176, 208, 0 };
S s8fB[] = { 143, 209, 0 };
S sB8aB[] = { 209, 138, 209, 0 };
S sAb5Abb[] = { 208, 181, 208, 187, 0 };
S sB84A[] = { 209, 132, 208, 0 };
S s8aB[] = { 138, 209, 0 };
S sb5Ab7[] = { 181, 208, 183, 0 };
S sbdB82[] = { 189, 209, 130, 0 };
S sbdAbeB[] = { 189, 208, 190, 209, 0 };
S s89A[] = { 137, 208, 0 };
S sAbag[] = { 208, 186, a };
S sb8B81[] = { 184, 209, 129, 0 };
S s86A[] = { 134, 208, 0 };
S sbfAbeB[] = { 191, 208, 190, 209, 0 };
S sb2Ab8[] = { 178, 208, 184, 0 };
S sB89A[] = { 209, 137, 208, 0 };
S sgAb3[] = { 32, 208, 179, 0 };
S sAb2Ab8[] = { 208, 178, 208, 184, 0 };
S sbag[] = { 186, a };
S sAbdB82[] = { 208, 189, 209, 130, 0 };
S sAb8B81[] = { 208, 184, 209, 129, 0 };
S sB86A[] = { 209, 134, 208, 0 };
S sgAbcA[] = { 32, 208, 188, 208, 0 };
S sbeB81A[] = { 190, 209, 129, 208, 0 };
S sAbbAb5[] = { 208, 187, 208, 181, 0 };
S sB81Ab8[] = { 209, 129, 208, 184, 0 };
S sbdAbeg[] = { 189, 208, 190, a };
S sgAb5A[] = { 32, 208, 181, 208, 0 };
S s80AbeB[] = { 128, 208, 190, 209, 0 };
S sbbAbd[] = { 187, 208, 189, 0 };
S s81Ab8[] = { 129, 208, 184, 0 };
S sb8Abag[] = { 184, 208, 186, a };
S sbdB82A[] = { 189, 209, 130, 208, 0 };
S sA9f[] = { 208, 159, 0 };
S sAbdB81[] = { 208, 189, 209, 129, 0 };
S sb5B81B[] = { 181, 209, 129, 209, 0 };
S sb0AbaB[] = { 176, 208, 186, 209, 0 };
S sb7Ab8B[] = { 183, 208, 184, 209, 0 };
S sAbbAbd[] = { 208, 187, 208, 189, 0 };
S sbdB81[] = { 189, 209, 129, 0 };
S sb2Ab0g[] = { 178, 208, 176, a };
S sbbAb5[] = { 187, 208, 181, 0 };
S sbbAbdA[] = { 187, 208, 189, 208, 0 };
S sAb8B80[] = { 208, 184, 209, 128, 0 };
S sbeAb1[] = { 190, 208, 177, 0 };
S sbaAb0B[] = { 186, 208, 176, 209, 0 };
S sb3Ab0[] = { 179, 208, 176, 0 };
S sAbeAb1[] = { 208, 190, 208, 177, 0 };
S sb0Ab7[] = { 176, 208, 183, 0 };
S s80AbeA[] = { 128, 208, 190, 208, 0 };
S sAb0Ab7[] = { 208, 176, 208, 183, 0 };
S sb5AbbA[] = { 181, 208, 187, 208, 0 };
S sbcAb8[] = { 188, 208, 184, 0 };
S sb8B87[] = { 184, 209, 135, 0 };
S sb8B80[] = { 184, 209, 128, 0 };
S sAb4Abe[] = { 208, 180, 208, 190, 0 };
S sAbcAb8[] = { 208, 188, 208, 184, 0 };
S sb4Abe[] = { 180, 208, 190, 0 };
S sb5Ab7A[] = { 181, 208, 183, 208, 0 };
S sAb3Ab0[] = { 208, 179, 208, 176, 0 };
S sAbcAbe[] = { 208, 188, 208, 190, 0 };
S sb8B80A[] = { 184, 209, 128, 208, 0 };
S sgA9f[] = { 32, 208, 159, 0 };
S sb8B87A[] = { 184, 209, 135, 208, 0 };
S sAb9[] = { 208, 185, 0 };
S sbcAbe[] = { 188, 208, 190, 0 };
S sAb8B87[] = { 208, 184, 209, 135, 0 };
S sbbAb0[] = { 187, 208, 176, 0 };
S sb2Ab5B[] = { 178, 208, 181, 209, 0 };
S sb8AbdA[] = { 184, 208, 189, 208, 0 };
S sb7Ab0g[] = { 183, 208, 176, a };
S s81B8a[] = { 129, 209, 138, 0 };
S sb8Ab2[] = { 184, 208, 178, 0 };
S sAbbAb0[] = { 208, 187, 208, 176, 0 };
S sB81B8a[] = { 209, 129, 209, 138, 0 };
S sbdAb8A[] = { 189, 208, 184, 208, 0 };
S sAbeAb4[] = { 208, 190, 208, 180, 0 };
S sb4B[] = { 180, 209, 0 };
S s80Ab5B[] = { 128, 208, 181, 209, 0 };
S sbaAbeg[] = { 186, 208, 190, a };
S sbdAb0A[] = { 189, 208, 176, 208, 0 };
S s80Ab0B[] = { 128, 208, 176, 209, 0 };
S sB85[] = { 209, 133, 0 };
S sAb4B[] = { 208, 180, 209, 0 };
S sbeAb4[] = { 190, 208, 180, 0 };
S sAb8Ab2[] = { 208, 184, 208, 178, 0 };
S sgAbaB[] = { 32, 208, 186, 209, 0 };
S sgB82A[] = { 32, 209, 130, 208, 0 };
S s87Ab8[] = { 135, 208, 184, 0 };
S sB88[] = { 209, 136, 0 };
S sAb4Ab8[] = { 208, 180, 208, 184, 0 };
S sb8Ab2A[] = { 184, 208, 178, 208, 0 };
S sbeAb2[] = { 190, 208, 178, 0 };
S sgAb0[] = { 32, 208, 176, 0 };
S sAb4Ab5[] = { 208, 180, 208, 181, 0 };
S sb1Ab0[] = { 177, 208, 176, 0 };
S s82Ab5B[] = { 130, 208, 181, 209, 0 };
S s81B82B[] = { 129, 209, 130, 209, 0 };
S sB86Ab8[] = { 209, 134, 208, 184, 0 };
S s86Ab8[] = { 134, 208, 184, 0 };
S sAbcAb5[] = { 208, 188, 208, 181, 0 };
S sAb1Ab0[] = { 208, 177, 208, 176, 0 };
S sbeAb3A[] = { 190, 208, 179, 208, 0 };
S sb0Ab7A[] = { 176, 208, 183, 208, 0 };
S sbfAbeA[] = { 191, 208, 190, 208, 0 };
S sbcAb5[] = { 188, 208, 181, 0 };
S sbdg[] = { 189, a };
S sb2Ab0B[] = { 178, 208, 176, 209, 0 };
S sB87Ab8[] = { 209, 135, 208, 184, 0 };
S sb4Ab8[] = { 180, 208, 184, 0 };
S sAbeAb2[] = { 208, 190, 208, 178, 0 };
S sAbdg[] = { 208, 189, a };
S sb4Ab5[] = { 180, 208, 181, 0 };
S sB88A[] = { 209, 136, 208, 0 };
S s81Ab0[] = { 129, 208, 176, 0 };
S sbeAbb[] = { 190, 208, 187, 0 };
S sb1Ab0A[] = { 177, 208, 176, 208, 0 };
S sgAb2A[] = { 32, 208, 178, 208, 0 };
S sbeAbf[] = { 190, 208, 191, 0 };
S sb0B81[] = { 176, 209, 129, 0 };
S sB87Ab5[] = { 209, 135, 208, 181, 0 };
S sbdAb5A[] = { 189, 208, 181, 208, 0 };
S sAbaB82[] = { 208, 186, 209, 130, 0 };
S sAbeAbf[] = { 208, 190, 208, 191, 0 };
S sbbg[] = { 187, a };
S sb5AbdB[] = { 181, 208, 189, 209, 0 };
S sAbeB80[] = { 208, 190, 209, 128, 0 };
S sbaB82[] = { 186, 209, 130, 0 };
S sB81Ab0[] = { 209, 129, 208, 176, 0 };
S sAb0B84[] = { 208, 176, 209, 132, 0 };
S sAb1B[] = { 208, 177, 209, 0 };
S sAbbg[] = { 208, 187, a };

N l5n0[] = { { sB82Ab5, 1.909 }, H };
N l5n2[] = { { sAb2, 2.400 }, { sbfB, .468 }, { sB83, .590 }, { sAb2Ab0, 1.123 }, H };
N l5n3[] = { { sAb3A, .926 }, { sB84A, .379 }, { sbdg, .182 }, H };
N l5n4[] = { { sbbAbdA, .299 }, H };
N l5n5[] = { { sbbAb0, .197 }, H };
N l5n7[] = { { sAb0Abd, 1.207 }, { sbeAbf, .168 }, H };
N l5n8[] = { { sgAb8A, .337 }, { sb5Ab7A, .281 }, H };
N l5n9[] = { { sAbfAbe, 1.011 }, { sB82Ab8, .842 }, H };
N l5n10[] = { { s86A, .159 }, H };
N l5n11[] = { { sb5g, 1.347 }, { sbdAb8A, .262 }, { sAbaB82, .337 }, H };
N l5n13[] = { { sb3Ab0, .211 }, H };
N l5n14[] = { { sbdAb8B, .636 }, H };
N l5n16[] = { { sAb8B8f, .814 }, H };
N l5n17[] = { { sAb2Ab5, .646 }, { s87Ab8, .182 }, H };
N l5n19[] = { { sAb3, .842 }, { sB84, .337 }, { sAb3Ab0, .421 }, H };
N l5n20[] = { { sAb4A, 1.684 }, H };
N l5n22[] = { { s81B82, 1.137 }, { sb8Aba, .337 }, H };
N l5n23[] = { { s80Ab5, .590 }, H };
N l5n24[] = { { sb8A, 1.376 }, { s82Abeg, 1.123 }, { sB82Abd, .505 }, H };
N l5n25[] = { { sb8B80A, .281 }, H };
N l5n26[] = { { sAb2Ab8, .477 }, H };
N l5n27[] = { { sB82Abe, 1.572 }, { sbfAbe, .505 }, H };
N l5n29[] = { { s82AbdA, .337 }, { sAbdg, .411 }, H };
N l5n30[] = { { s82Ab0, .674 }, { sgAbaA, .561 }, { sb0Aba, .365 }, H };
N l5n31[] = { { sAb4B, .295 }, H };
N l5n32[] = { { sb0A, 1.572 }, H };
N l5n33[] = { { s8fA, .206 }, { sb0B80A, .356 }, { sgAbaB, .243 }, H };
N l5n34[] = { { sbeg, 1.446 }, H };
N l5n36[] = { { sAb4, 1.446 }, { sAb4Ab0, .786 }, { sB85, .197 }, H };
N l5n37[] = { { sAb5A, 3.116 }, { sb2Ab5, .323 }, { sB86A, .358 }, H };
N l5n39[] = { { sb0B82g, .561 }, H };
N l5n41[] = { { sb8B, 1.226 }, { s87A, .430 }, H };
N l5n44[] = { { sb4Ab0, .393 }, { sAb2Abe, .590 }, H };
N l5n46[] = { { sAbeg, 3.253 }, { sB8fg, 1.074 }, { sb8Ab2A, .243 }, H };
N l5n47[] = { { sb8B82A, .842 }, H };
N l5n48[] = { { sAb5B, 2.084 }, H };
N l5n49[] = { { sb0B, 1.067 }, H };
N l5n50[] = { { s8fB, .168 }, H };
N l5n51[] = { { sAb4Ab5, .365 }, H };
N l5n52[] = { { s82Ab2, .267 }, { sgAbcA, .318 }, { sb5AbbA, .281 }, H };
N l5n53[] = { { sAb5, 4.814 }, { sB86, .253 }, H };
N l5n54[] = { { sB87A, .968 }, { s81Ab5, .379 }, { sAb6A, .442 }, { sb0Ab2A, .337 }, H };
N l5n55[] = { { sb0B82A, .487 }, { sb8Abd, .323 }, H };
N l5n56[] = { { s80Ab8, .547 }, H };
N l5n59[] = { { sAbdB81, .449 }, H };
N l5n60[] = { { sbbAb5, .225 }, { sAb4Ab8, .365 }, H };
N l5n61[] = { { sbdAbeg, .449 }, H };
N l5n62[] = { { sbaAb8, .267 }, { sAbdB82, .477 }, H };
N l5n63[] = { { sgAbdA, 1.329 }, { sb1A, .412 }, { sb0Abd, .604 }, { sb1Ab0A, .225 }, H };
N l5n64[] = { { sAb0g, 5.874 }, { sgAb0, .182 }, H };
N l5n65[] = { { sAb5Ab4, .646 }, { sgB80, .323 }, H };
N l5n67[] = { { sbdAb0, 1.333 }, H };
N l5n70[] = { { sB87, .730 }, { sAb6, .295 }, { sb2Ab8, .239 }, H };
N l5n71[] = { { sAb7A, 1.853 }, { sB88A, .253 }, H };
N l5n73[] = { { sAbeB80, .337 }, H };
N l5n74[] = { { sb5AbdA, .468 }, { sAb5Ab7, .505 }, H };
N l5n75[] = { { sgAb1, .309 }, H };
N l5n76[] = { { sgB81, 1.151 }, { sAbeB81, 1.095 }, { sb5B80, .337 }, H };
N l5n77[] = { { sgAbeB, .543 }, { sB86Ab8, .365 }, { sb5AbdB, .225 }, H };
N l5n78[] = { { sb8B8f, .407 }, { sb2Ab0g, .449 }, { sAb4Abe, .421 }, H };
N l5n79[] = { { sAbeB82, 1.291 }, { sbdB81, .225 }, H };
N l5n80[] = { { s80A, 1.675 }, { s80Ab0A, .618 }, { sbdAbeB, .318 }, H };
N l5n81[] = { { sB82g, 1.674 }, H };
N l5n83[] = { { s80Ab0B, .262 }, H };
N l5n84[] = { { sb7Ab8B, .299 }, H };
N l5n85[] = { { s82Ab5, .954 }, { sgAbfA, .599 }, { sB87Ab5, .337 }, H };
N l5n86[] = { { sbaA, .954 }, { sgAb2, .575 }, { sAb5Abb, .505 }, H };
N l5n87[] = { { sAb7, 1.333 }, { sb5B81, .337 }, { sAb7Ab0, .646 }, { sgB82, .309 }, { s81Ab8, .225 }, { sB88, .182 }, H };
N l5n88[] = { { sAb8A, 3.095 }, { sgAbfB, .674 }, { sB89A, .358 }, H };
N l5n89[] = { { sbaAb0B, .281 }, H };
N l5n90[] = { { sAbfB80, 1.151 }, { sbdB82, .239 }, H };
N l5n91[] = { { sAb0B80, .702 }, { sbcAb5, .182 }, H };
N l5n92[] = { { sAb5Abd, 1.235 }, H };
N l5n93[] = { { sbbAb8, .337 }, H };
N l5n94[] = { { sb2A, 1.048 }, { sB87Ab8, .365 }, H };
N l5n97[] = { { sB81B82, 2.274 }, { sAb0B82, 1.319 }, { s80B, .206 }, { sgAb3, .239 }, { sb2Ab0B, .243 }, H };
N l5n98[] = { { sb5B82, .463 }, { sAb2g, .853 }, H };
N l5n99[] = { { sAb8B, 2.758 }, { sb4Ab5, .182 }, H };
N l5n101[] = { { sb8Ab7A, .412 }, H };
N l5n102[] = { { sb8B87A, .281 }, H };
N l5n103[] = { { sbaB, .393 }, { s89A, .159 }, { sAb0B84, .337 }, H };
N l5n104[] = { { sAb8, 5.488 }, { sb8g, 1.586 }, { sB89, .267 }, H };
N l5n105[] = { { sB8aA, .737 }, H };
N l5n108[] = { { sgAb4, .519 }, H };
N l5n109[] = { { s81Aba, .351 }, { sbeAb1, .211 }, { sb0Ab7A, .243 }, H };
N l5n110[] = { { sbeB81, .547 }, { s81B8a, .197 }, { sAb8Ab2, .393 }, H };
N l5n111[] = { { s81A, 1.085 }, { sb2B, .299 }, { sAb7Ab8, .786 }, H };
N l5n112[] = { { sb0g, 2.611 }, H };
N l5n113[] = { { s8fg, .477 }, H };
N l5n116[] = { { sB8aB, .379 }, H };
N l5n117[] = { { sbbA, .786 }, H };
N l5n118[] = { { s82Ab8, .421 }, { sb8Abag, .449 }, H };
N l5n119[] = { { sgAb5, .407 }, { sb5Ab4, .323 }, H };
N l5n120[] = { { sbeAb2, .182 }, H };
N l5n121[] = { { sB8a, .744 }, { sbeB82, .646 }, { sAb9, .211 }, { sB81B8a, .393 }, H };
N l5n122[] = { { sAbaA, 2.148 }, { s80Abe, .449 }, { sbdAb5, .393 }, H };
N l5n124[] = { { sbcAb8, .211 }, H };
N l5n125[] = { { sb3A, .412 }, { sAb8Ab7, .674 }, H };
N l5n126[] = { { s82Ab0g, .758 }, H };
N l5n128[] = { { s81B, .964 }, { sbaAbe, .547 }, H };
N l5n130[] = { { sbfB80, .575 }, H };
N l5n131[] = { { sbeAb3, .267 }, H };
N l5n132[] = { { sb4Ab8, .182 }, H };
N l5n133[] = { { sAbaB, .884 }, { sgA9f, .211 }, H };
N l5n134[] = { { s81B82A, 1.123 }, { s8aA, .328 }, { sAb8Aba, .674 }, H };
N l5n135[] = { { s80Ab5A, .524 }, H };
N l5n136[] = { { sb2Abe, .295 }, H };
N l5n137[] = { { sb7Ab0, .323 }, { s81B82B, .243 }, H };
N l5n138[] = { { sAba, 2.260 }, { sAbaAb0, .898 }, { s80Ab5B, .262 }, H };
N l5n139[] = { { sAbbA, 1.769 }, { sbfAbeA, .243 }, H };
N l5n140[] = { { sb4Ab0g, .561 }, H };
N l5n141[] = { { sgAb7, .281 }, H };
N l5n142[] = { { s82A, 2.349 }, { s82Ab0A, .337 }, { sbfAbeB, .318 }, { sbeAb4, .197 }, H };
N l5n143[] = { { sAb8Abd, .646 }, H };
N l5n145[] = { { sb0AbaB, .299 }, H };
N l5n148[] = { { sbcA, .524 }, { sbbAbd, .225 }, H };
N l5n149[] = { { sAb5g, 3.032 }, H };
N l5n150[] = { { s81Ab5g, .618 }, H };
N l5n151[] = { { s8aB, .168 }, H };
N l5n152[] = { { sgAb8, .575 }, { sb5Ab7, .253 }, { sb2Ab5B, .262 }, H };
N l5n155[] = { { sAbb, 1.418 }, { sbdAb8, 1.039 }, { sAbbAb0, .393 }, H };
N l5n156[] = { { sb4A, .749 }, { sAbcA, 1.179 }, H };
N l5n159[] = { { s82B, .262 }, H };
N l5n162[] = { { sAbaAb8, .533 }, H };
N l5n163[] = { { sbdAb0g, 1.937 }, H };
N l5n164[] = { { s82Ab2A, .337 }, H };
N l5n166[] = { { sbag, .239 }, H };
N l5n167[] = { { sb8AbdA, .262 }, H };
N l5n168[] = { { s80Ab8A, .430 }, H };
N l5n169[] = { { sb8B80, .211 }, H };
N l5n170[] = { { sAbbAb5, .449 }, H };
N l5n172[] = { { sAbc, .983 }, H };
N l5n173[] = { { sAbdA, 5.095 }, { s83A, .187 }, { s82Abd, .253 }, { sb4B, .131 }, H };
N l5n174[] = { { sgAba, .604 }, { sb2g, .379 }, { sb8B8fg, .730 }, H };
N l5n175[] = { { sb0AbdA, .655 }, H };
N l5n176[] = { { sgA, 5.343 }, { sAb5B80, .674 }, H };
N l5n177[] = { { sb0B80, .351 }, { sgB80A, .374 }, H };
N l5n179[] = { { sbdA, 2.265 }, { sAb5B81, .674 }, { sAbbAb8, .674 }, { sbdAb0A, .262 }, H };
N l5n180[] = { { sAbaAbe, 1.095 }, { sb8B81, .239 }, H };
N l5n181[] = { { s82Ab5g, .842 }, H };
N l5n182[] = { { sAb5B82, .926 }, { sgAb2g, .337 }, H };
N l5n184[] = { { s82Abe, .786 }, { sAbdB, .884 }, H };
N l5n187[] = { { sb5A, 1.385 }, { sgAb1A, .356 }, { sAbcAb5, .365 }, H };
N l5n188[] = { { sgB81A, .917 }, { sb5B80A, .393 }, { sb0B81, .168 }, H };
N l5n189[] = { { sAbd, 4.169 }, { sAbdAb0, 2.667 }, H };
N l5n190[] = { { sAbeA, 2.758 }, { sB8fA, .463 }, { s83B, .187 }, { sbcAbe, .211 }, { sb8Ab2, .197 }, H };
N l5n191[] = { { sB80A, 3.769 }, { sb8B82, .646 }, { sgB81B, .468 }, { sA9f, .225 }, H };
N l5n193[] = { { sgB, 1.488 }, H };
N l5n194[] = { { sAbbAbd, .449 }, H };
N l5n196[] = { { sbdB, .393 }, { sgAbc, .295 }, { sb5Abb, .253 }, { sAbcAb8, .421 }, H };
N l5n197[] = { { s82Ab5A, .468 }, { sbbg, .168 }, H };
N l5n198[] = { { sb0Ab2, .393 }, { sb4Abe, .211 }, { sgAb2A, .225 }, H };
N l5n199[] = { { sb0B82, .660 }, { sgB82A, .243 }, H };
N l5n200[] = { { sAb8g, 3.569 }, { s82Ab5B, .243 }, H };
N l5n201[] = { { sAbeB, 2.484 }, { sB8fB, .379 }, H };
N l5n202[] = { { sB80B, .463 }, { sbdB82A, .299 }, { sb5B81B, .299 }, H };
N l5n204[] = { { sb5B, .926 }, { sAbdAb5, .786 }, { s84A, .168 }, H };
N l5n206[] = { { sAbe, 4.941 }, { sB8f, 1.039 }, H };
N l5n207[] = { { sB80, 2.905 }, { sgAbd, 1.067 }, { sAbfA, 1.221 }, { sB80Ab0, 1.544 }, { sb1Ab0, .182 }, H };
N l5n208[] = { { sAb0A, 3.537 }, { sB81A, 2.442 }, H };
N l5n209[] = { { sAbeAb1, .421 }, H };
N l5n210[] = { { sbeA, 1.226 }, { sb5B82A, .543 }, H };
N l5n212[] = { { sAbeAb2, .365 }, H };
N l5n213[] = { { sAbdAb8, 2.077 }, H };
N l5n214[] = { { sAbcAbe, .421 }, H };
N l5n215[] = { { sAbeAb3, .533 }, H };
N l5n218[] = { { sAbfB, 1.053 }, { sb5Abd, .618 }, { sgAbe, .561 }, { sb6A, .197 }, { sAbeAb4, .393 }, H };
N l5n219[] = { { sAb0B, 2.400 }, { sB81B, 2.169 }, { sbeAbb, .168 }, H };
N l5n220[] = { { sgAb4A, .618 }, H };
N l5n221[] = { { sbdAbe, .547 }, { s81AbaA, .449 }, H };
N l5n222[] = { { s82g, .744 }, { sB80Ab5, 1.179 }, { sbeB81A, .299 }, H };
N l5n223[] = { { sAbf, 1.558 }, H };
N l5n224[] = { { sAb0, 6.569 }, { sB81, 3.242 }, { s80Ab0, .772 }, { sbaAbeg, .393 }, { sB81Ab0, .337 }, H };
N l5n225[] = { { sB82A, 5.285 }, { sAb1A, .926 }, { sb7Ab8, .393 }, { sbeB81B, .412 }, H };
N l5n227[] = { { sbeB, 1.104 }, { sAb8B80, .421 }, H };
N l5n229[] = { { sgAbf, .954 }, H };
N l5n230[] = { { sbaAb0, .449 }, { sAb0Ab2, .786 }, { s82Ab8A, .356 }, { sAb8B81, .477 }, H };
N l5n231[] = { { sB80Ab8, 1.095 }, { sAbdAbe, 1.095 }, { sb5Ab4A, .356 }, { sgAb5A, .299 }, H };
N l5n233[] = { { sAb8B82, 1.291 }, { sbeB82A, .618 }, { sb7Ab0g, .393 }, H };
N l5n234[] = { { sAbag, .537 }, { s80AbeA, .281 }, { sbdAb5A, .225 }, H };
N l5n236[] = { { sB82B, .590 }, { sAb1B, .253 }, H };
N l5n237[] = { { s80AbeB, .299 }, H };
N l5n238[] = { { sb2Ab0, .561 }, H };
N l5n239[] = { { sB81Ab5, .758 }, H };
N l5n240[] = { { sbaAbeA, .430 }, H };
N l5n241[] = { { sB82, 4.660 }, { sbfA, .543 }, { sAb1, .786 }, { sB82Ab0, 1.347 }, { sAb1Ab0, .365 }, H };
N l5n242[] = { { sAb2A, 2.358 }, { sbfB80A, .749 }, { sB83A, .421 }, { s86Ab8, .182 }, H };
N l5n243[] = { { sbeAb3A, .243 }, H };
N l5n245[] = { { sb8Ab7, .337 }, { sAb0Ab7, .421 }, H };
N l5n246[] = { { sb8B87, .211 }, H };
N l5n247[] = { { sB82Ab2, .533 }, H };
N l5n248[] = { { sgAb8g, .412 }, { sB81Ab8, .449 }, { sAb8B87, .421 }, H };
N l5n249[] = { { sb7A, .823 }, { sB80Abe, .898 }, H };
N l5n251[] = { { sbdAb8g, .730 }, { sAbeAbf, .337 }, { sAbbg, .379 }, H };
N l5n253[] = { { sAb2B, .674 }, { sgAb7A, .374 }, { sB83B, .421 }, { sb0Ab7, .211 }, { sbaB82, .168 }, H };
N l5n254[] = { { sAb0Aba, .730 }, { sB81Aba, .702 }, H };
N l5n255[] = { { s81Ab0, .168 }, H };

D l5_d = {
	"bulgarian",
	"utf8",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, 0.000, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, 0.001, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    0.077, 0.086, 0.124, 0.016, 0.009, 0.005, 0.007, 0.019, 0.005, 0.007, 0.020, Y, Y, Y, 0.001, 0.028,
	    0.003, 0.003, 0.002, 0.001, 0.001, 0.001, Y, 0.003, 0.002, 0.001, 0.000, 0.000, 0.001, 0.003, 0.001, 0.006,
	    0.004, 0.004, 0.001, 0.001, 0.001, Y, 0.000, Y, 0.003, Y, Y, Y, Y, Y, Y, Y,
	    0.175, 0.021, 0.064, 0.022, 0.039, 0.128, 0.008, 0.036, 0.146, 0.006, 0.060, 0.038, 0.026, 0.111, 0.132, 0.042,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    1.642, 0.607, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l5n0, X, l5n2, l5n3, l5n4, l5n5, X, l5n7, l5n8, l5n9, l5n10, l5n11, X, l5n13, l5n14, X,
	    l5n16, l5n17, X, l5n19, l5n20, X, l5n22, l5n23, l5n24, l5n25, l5n26, l5n27, X, l5n29, l5n30, l5n31,
	    l5n32, l5n33, l5n34, X, l5n36, l5n37, X, l5n39, X, l5n41, X, X, l5n44, X, l5n46, l5n47,
	    l5n48, l5n49, l5n50, l5n51, l5n52, l5n53, l5n54, l5n55, l5n56, X, X, l5n59, l5n60, l5n61, l5n62, l5n63,
	    l5n64, l5n65, X, l5n67, X, X, l5n70, l5n71, X, l5n73, l5n74, l5n75, l5n76, l5n77, l5n78, l5n79,
	    l5n80, l5n81, X, l5n83, l5n84, l5n85, l5n86, l5n87, l5n88, l5n89, l5n90, l5n91, l5n92, l5n93, l5n94, X,
	    X, l5n97, l5n98, l5n99, X, l5n101, l5n102, l5n103, l5n104, l5n105, X, X, l5n108, l5n109, l5n110, l5n111,
	    l5n112, l5n113, X, X, l5n116, l5n117, l5n118, l5n119, l5n120, l5n121, l5n122, X, l5n124, l5n125, l5n126, X,
	    l5n128, X, l5n130, l5n131, l5n132, l5n133, l5n134, l5n135, l5n136, l5n137, l5n138, l5n139, l5n140, l5n141, l5n142, l5n143,
	    X, l5n145, X, X, l5n148, l5n149, l5n150, l5n151, l5n152, X, X, l5n155, l5n156, X, X, l5n159,
	    X, X, l5n162, l5n163, l5n164, X, l5n166, l5n167, l5n168, l5n169, l5n170, X, l5n172, l5n173, l5n174, l5n175,
	    l5n176, l5n177, X, l5n179, l5n180, l5n181, l5n182, X, l5n184, X, X, l5n187, l5n188, l5n189, l5n190, l5n191,
	    X, l5n193, l5n194, X, l5n196, l5n197, l5n198, l5n199, l5n200, l5n201, l5n202, X, l5n204, X, l5n206, l5n207,
	    l5n208, l5n209, l5n210, X, l5n212, l5n213, l5n214, l5n215, X, X, l5n218, l5n219, l5n220, l5n221, l5n222, l5n223,
	    l5n224, l5n225, X, l5n227, X, l5n229, l5n230, l5n231, X, l5n233, l5n234, X, l5n236, l5n237, l5n238, l5n239,
	    l5n240, l5n241, l5n242, l5n243, X, l5n245, l5n246, l5n247, l5n248, l5n249, X, l5n251, X, l5n253, l5n254, l5n255 }
};

//
// Lng: catalan
// Enc: iso-8859-15
//

S sghig[] = { 32, d, e, a };
S sgpX[] = { 32, l, 97, 0 };
S sZs[] = { 99, o, 0 };
S suy[] = { q, u, 0 };
S sgpXg[] = { 32, l, 97, a };
S suyi[] = { q, u, e, 0 };
S sgZs[] = { 32, 99, o, 0 };
S sgip[] = { 32, e, l, 0 };
S sXZ[] = { 97, 99, 0 };
S sZX[] = { 99, 97, 0 };
S smZ[] = { i, 99, 0 };
S sguy[] = { 32, q, u, 0 };
S sgipg[] = { 32, e, l, a };
S sp27[] = { l, 39, 0 };
S sguyi[] = { 32, q, u, e, 0 };
S sgp27[] = { 32, l, 39, 0 };
S syig[] = { u, e, a };
S suyig[] = { q, u, e, a };
S sXZm[] = { 97, 99, i, 0 };
S siZ[] = { e, 99, 0 };
S sgiw[] = { 32, e, s, 0 };
S stiv[] = { p, e, r, 0 };
S spw[] = { l, s, 0 };
S sf3g[] = { 243, a };
S spwg[] = { l, s, a };
S smf3[] = { i, 243, 0 };
S s27X[] = { 39, 97, 0 };
S srxg[] = { n, t, a };
S siwxX[] = { e, s, t, 97, 0 };
S smf3g[] = { i, 243, a };
S ssrX[] = { o, n, 97, 0 };
S sZmf3[] = { 99, i, 243, 0 };
S syiw[] = { u, e, s, 0 };
S smsr[] = { i, o, n, 0 };
S ssp[] = { o, l, 0 };
S sZy[] = { 99, u, 0 };
S sgvi[] = { 32, r, e, 0 };
S sZx[] = { 99, t, 0 };
S sgyr[] = { 32, u, n, 0 };
S sZmf3g[] = { 99, i, 243, a };
S syvX[] = { u, r, 97, 0 };
S sXZmf3[] = { 97, 99, i, 243, 0 };
S sgti[] = { 32, p, e, 0 };
S sZsr[] = { 99, o, n, 0 };
S sgZsq[] = { 32, 99, o, m, 0 };
S sirxg[] = { e, n, t, a };
S shipg[] = { d, e, l, a };
S sZsq[] = { 99, o, m, 0 };
S spiw[] = { l, e, s, 0 };
S shiw[] = { d, e, s, 0 };
S srZ[] = { n, 99, 0 };
S suyiw[] = { q, u, e, s, 0 };
S spXwg[] = { l, 97, s, a };
S sZms[] = { 99, i, o, 0 };
S sxmz[] = { t, i, v, 0 };
S sipp[] = { e, l, l, 0 };
S sjm[] = { f, i, 0 };
S sZv[] = { 99, r, 0 };
S sZmX[] = { 99, i, 97, 0 };
S sg79[] = { 32, y, 0 };
S sgp27X[] = { 32, l, 39, 97, 0 };
S spXw[] = { l, 97, s, 0 };
S syiwx[] = { u, e, s, t, 0 };
S srXp[] = { n, 97, l, 0 };
S sp27X[] = { l, 39, 97, 0 };
S svr[] = { r, n, 0 };
S smz[] = { i, v, 0 };
S sqirx[] = { m, e, n, t, 0 };
S spiwg[] = { l, e, s, a };
S swxXg[] = { s, t, 97, a };
S sXuy[] = { 97, q, u, 0 };
S sZsv[] = { 99, o, r, 0 };
S sgZX[] = { 32, 99, 97, 0 };
S srxX[] = { n, t, 97, 0 };
S sXuyi[] = { 97, q, u, e, 0 };
S sZmsr[] = { 99, i, o, n, 0 };
S sgjm[] = { 32, f, i, 0 };
S sgpXw[] = { 32, l, 97, s, 0 };
S stvs[] = { p, r, o, 0 };
S smsrX[] = { i, o, n, 97, 0 };
S sipwg[] = { e, l, s, a };
S sghiw[] = { 32, d, e, s, 0 };
S sgZsr[] = { 32, 99, o, n, 0 };
S sgXpg[] = { 32, 97, l, a };
S syvXg[] = { u, r, 97, a };
S sXrx[] = { 97, n, t, 0 };
S sgtiv[] = { 32, p, e, r, 0 };
S ssZ[] = { o, 99, 0 };
S sXrX[] = { 97, n, 97, 0 };
S sipw[] = { e, l, s, 0 };
S sqt[] = { m, p, 0 };
S sxyvX[] = { t, u, r, 97, 0 };
S svsr[] = { r, o, n, 0 };
S sgiwg[] = { 32, e, s, a };
S sxXxg[] = { t, 97, t, a };
S sZmXg[] = { 99, i, 97, a };
S sXrXg[] = { 97, n, 97, a };
S svXZ[] = { r, 97, 99, 0 };
S svQ[] = { r, 224, 0 };
S sgyrX[] = { 32, u, n, 97, 0 };
S sppg[] = { l, l, a };
S ssrXp[] = { o, n, 97, l, 0 };
S sg79g[] = { 32, y, a };
S sviZ[] = { r, e, 99, 0 };
S syrX[] = { u, n, 97, 0 };
S sgxv[] = { 32, t, r, 0 };
S sXxmz[] = { 97, t, i, v, 0 };
S sxXv[] = { t, 97, r, 0 };
S srZmX[] = { n, 99, i, 97, 0 };
S svri[] = { r, n, e, 0 };
S sZXx[] = { 99, 97, t, 0 };
S siZx[] = { e, 99, t, 0 };
S sgZy[] = { 32, 99, u, 0 };
S smZm[] = { i, 99, i, 0 };
S sgZsv[] = { 32, 99, o, r, 0 };
S sxXwg[] = { t, 97, s, a };
S srZm[] = { n, 99, i, 0 };
S svQg[] = { r, 224, a };
S sqXv[] = { m, 97, r, 0 };
S stXvX[] = { p, 97, r, 97, 0 };
S syrXg[] = { u, n, 97, a };
S sZsrw[] = { 99, o, n, s, 0 };
S sxXq[] = { t, 97, m, 0 };
S sviX[] = { r, e, 97, 0 };
S sgXu[] = { 32, 97, q, 0 };
S svit[] = { r, e, p, 0 };
S sgXuy[] = { 32, 97, q, u, 0 };
S ssvr[] = { o, r, n, 0 };
S sgi78t[] = { 32, e, x, p, 0 };
S si78[] = { e, x, 0 };
S s78t[] = { x, p, 0 };
S sgjX[] = { 32, f, 97, 0 };
S siwi[] = { e, s, e, 0 };
S siwZ[] = { e, s, 99, 0 };
S sviwg[] = { r, e, s, a };
S sXvQ[] = { 97, r, 224, 0 };
S sZvi[] = { 99, r, e, 0 };
S siz[] = { e, v, 0 };
S srhXg[] = { n, d, 97, a };
S si78t[] = { e, x, p, 0 };
S smxXx[] = { i, t, 97, t, 0 };
S sgqXv[] = { 32, m, 97, r, 0 };
S sgpiw[] = { 32, l, e, s, 0 };
S spmZ[] = { l, i, 99, 0 };
S sgZv[] = { 32, 99, r, 0 };
S syvw[] = { u, r, s, 0 };
S sXvh[] = { 97, r, d, 0 };
S ssvri[] = { o, r, n, e, 0 };
S svZ[] = { r, 99, 0 };
S skyX[] = { g, u, 97, 0 };
S swZ[] = { s, 99, 0 };
S se9wg[] = { 233, s, a };
S sgi78[] = { 32, e, x, 0 };
S smiw[] = { i, e, s, 0 };
S sXvQg[] = { 97, r, 224, a };
S spQ[] = { l, 224, 0 };
S se9w[] = { 233, s, 0 };
S ssY[] = { o, 98, 0 };
S spir[] = { l, e, n, 0 };
S smir[] = { i, e, n, 0 };
S sivm[] = { e, r, i, 0 };
S sxvi[] = { t, r, e, 0 };
S siky[] = { e, g, u, 0 };
S sXhs[] = { 97, d, o, 0 };
S sgtvs[] = { 32, p, r, o, 0 };
S sZi[] = { 99, e, 0 };
S spQg[] = { l, 224, a };
S sny[] = { j, u, 0 };
S sYpm[] = { 98, l, i, 0 };
S sxsv[] = { t, o, r, 0 };
S smZX[] = { i, 99, 97, 0 };
S sxvs[] = { t, r, o, 0 };
S sglXg[] = { 32, h, 97, a };
S sirZ[] = { e, n, 99, 0 };
S swt[] = { s, p, 0 };
S sr79g[] = { n, y, a };
S sZsvr[] = { 99, o, r, n, 0 };
S sppir[] = { l, l, e, n, 0 };
S swxXw[] = { s, t, 97, s, 0 };
S srxXq[] = { n, t, 97, m, 0 };
S sgpp[] = { 32, l, l, 0 };
S sh27X[] = { d, 39, 97, 0 };
S srXx[] = { n, 97, t, 0 };
S sqmvX[] = { m, i, r, 97, 0 };
S sji[] = { f, e, 0 };
S sgh27[] = { 32, d, 39, 0 };
S sZg[] = { 99, a };
S sjmi[] = { f, i, e, 0 };
S sp27iw[] = { l, 39, e, s, 0 };
S syrxX[] = { u, n, t, 97, 0 };

N l6n0[] = { { siy, .134 }, H };
N l6n1[] = { { stX, .284 }, H };
N l6n2[] = { { swig, .188 }, H };
N l6n3[] = { { ssv, .434 }, { si78t, .125 }, H };
N l6n4[] = { { ssZ, .117 }, { syrXg, .301 }, H };
N l6n5[] = { { sxm, .284 }, { smr, .234 }, { sZmsr, .234 }, H };
N l6n6[] = { { srx, .518 }, H };
N l6n7[] = { { sri, .217 }, H };
N l6n9[] = { { sXrx, .175 }, { slX, .117 }, H };
N l6n10[] = { { stXvX, .201 }, { sYp, .084 }, H };
N l6n11[] = { { sZsq, .226 }, { sipp, .201 }, H };
N l6n12[] = { { sgp, 1.729 }, H };
N l6n13[] = { { swg, 2.632 }, { sXr, .652 }, { spm, .267 }, { sgi78t, .251 }, H };
N l6n14[] = { { svQg, .226 }, H };
N l6n15[] = { { sji, .067 }, H };
N l6n17[] = { { siz, .084 }, H };
N l6n18[] = { { sik, .134 }, H };
N l6n20[] = { { ssw, .284 }, H };
N l6n21[] = { { shm, .184 }, { sgts, .338 }, H };
N l6n22[] = { { sms, .217 }, { sZsr, .251 }, H };
N l6n23[] = { { spwg, .451 }, { sxmz, .201 }, H };
N l6n25[] = { { siky, .125 }, H };
N l6n26[] = { { spiwg, .401 }, H };
N l6n27[] = { { szXg, .301 }, H };
N l6n28[] = { { svr, .134 }, H };
N l6n29[] = { { sgq, .802 }, { sZg, .100 }, H };
N l6n31[] = { { sghip, .652 }, { siwZ, .125 }, { ssrg, .150 }, H };
N l6n33[] = { { sZmX, .201 }, { srhX, .175 }, { sxig, .226 }, H };
N l6n34[] = { { stv, .351 }, H };
N l6n35[] = { { srXg, .564 }, H };
N l6n36[] = { { suyiw, .301 }, { sym, .100 }, H };
N l6n37[] = { { ssx, .100 }, { swxXw, .134 }, H };
N l6n38[] = { { smir, .125 }, H };
N l6n40[] = { { smX, .251 }, { sXhs, .125 }, H };
N l6n41[] = { { sgjm, .263 }, H };
N l6n42[] = { { s27X, .201 }, H };
N l6n43[] = { { suyig, .802 }, { stiv, .301 }, H };
N l6n44[] = { { sxg, .978 }, { sqm, .251 }, { swxXg, .351 }, { sxXq, .150 }, { sgXu, .226 }, H };
N l6n45[] = { { svs, .351 }, { sivg, .301 }, { syiwx, .267 }, H };
N l6n46[] = { { sgr, .251 }, { ssrXp, .201 }, { ski, .084 }, H };
N l6n47[] = { { sXt, .084 }, H };
N l6n49[] = { { shig, 1.880 }, { srxX, .175 }, { sgh27, .150 }, H };
N l6n51[] = { { si78, .084 }, H };
N l6n52[] = { { spg, 1.353 }, { sghiw, .351 }, H };
N l6n53[] = { { siwi, .125 }, { sqmvX, .134 }, H };
N l6n54[] = { { sgtv, .526 }, H };
N l6n55[] = { { sgpX, 1.391 }, { s7aX, .084 }, H };
N l6n56[] = { { sgZs, .940 }, { sXrX, .175 }, H };
N l6n57[] = { { sgip, .827 }, { sgmg, .451 }, { sgzm, .188 }, H };
N l6n58[] = { { smf3g, .414 }, { se9wg, .423 }, H };
N l6n59[] = { { sghig, 2.506 }, H };
N l6n62[] = { { siwg, 1.353 }, { sky, .301 }, H };
N l6n63[] = { { svX, .719 }, H };
N l6n64[] = { { spp, .317 }, { syig, .602 }, { sQg, .677 }, { sXu, .117 }, H };
N l6n65[] = { { sXY, .084 }, H };
N l6n66[] = { { sZsv, .175 }, H };
N l6n67[] = { { szm, .184 }, H };
N l6n69[] = { { sti, .267 }, H };
N l6n71[] = { { sXuy, .175 }, H };
N l6n72[] = { { sgqX, .338 }, { syvXg, .351 }, H };
N l6n73[] = { { smv, .201 }, { sg79g, .226 }, H };
N l6n74[] = { { smZ, .301 }, H };
N l6n75[] = { { sXpg, .564 }, { srm, .201 }, { syg, .125 }, H };
N l6n76[] = { { sws, .134 }, H };
N l6n78[] = { { spmZ, .125 }, H };
N l6n79[] = { { sgir, .564 }, { sYX, .117 }, H };
N l6n80[] = { { sgt, 1.178 }, { sivm, .125 }, H };
N l6n81[] = { { sgX, 1.228 }, { sXv, .635 }, { sXvQg, .251 }, { sxsv, .125 }, H };
N l6n82[] = { { sXZ, .368 }, H };
N l6n83[] = { { sjm, .134 }, { sqg, .150 }, { svit, .150 }, { sglXg, .251 }, H };
N l6n84[] = { { spQg, .188 }, H };
N l6n85[] = { { sgXpg, .351 }, { srwg, .188 }, H };
N l6n87[] = { { syp, .117 }, H };
N l6n88[] = { { sipw, .175 }, { sXxmz, .201 }, H };
N l6n89[] = { { sXrh, .175 }, { sgZv, .188 }, { sgxs, .150 }, H };
N l6n90[] = { { smw, .084 }, H };
N l6n91[] = { { sig, 2.156 }, { sp27iw, .134 }, H };
N l6n92[] = { { sZs, .568 }, H };
N l6n93[] = { { smiw, .125 }, { swt, .067 }, H };
N l6n94[] = { { swX, .084 }, H };
N l6n95[] = { { sgyr, .376 }, H };
N l6n96[] = { { svv, .084 }, H };
N l6n97[] = { { sgu, .451 }, { svZ, .084 }, H };
N l6n98[] = { { sXw, .351 }, H };
N l6n99[] = { { sXh, .201 }, { sgpi, .226 }, { sxXv, .150 }, { sxvs, .125 }, H };
N l6n101[] = { { sgtvi, .301 }, H };
N l6n102[] = { { srxg, .451 }, H };
N l6n103[] = { { sip, .769 }, { sZmf3, .276 }, { srXp, .201 }, H };
N l6n104[] = { { sguy, .677 }, { srZm, .150 }, { syq, .067 }, H };
N l6n105[] = { { skyX, .125 }, { slXg, .188 }, H };
N l6n106[] = { { sZXx, .150 }, H };
N l6n107[] = { { smx, .384 }, { sxs, .201 }, H };
N l6n108[] = { { smi, .184 }, H };
N l6n109[] = { { sXrg, .226 }, H };
N l6n110[] = { { sZX, .334 }, { sxXw, .175 }, { sXpm, .125 }, H };
N l6n111[] = { { sZsrw, .201 }, H };
N l6n112[] = { { sYv, .084 }, H };
N l6n113[] = { { svw, .150 }, H };
N l6n114[] = { { srg, .852 }, { sgv, .276 }, { svh, .150 }, H };
N l6n115[] = { { sgZ, 1.303 }, { sXx, .602 }, { sps, .100 }, { svri, .150 }, H };
N l6n116[] = { { suy, .485 }, { sswg, .414 }, { sviw, .226 }, { sgqi, .188 }, H };
N l6n117[] = { { ship, .326 }, { smZX, .125 }, H };
N l6n118[] = { { spXw, .201 }, { sXuyi, .234 }, H };
N l6n120[] = { { siq, .150 }, { srxXq, .134 }, H };
N l6n121[] = { { syr, .334 }, { stvi, .226 }, { sxXx, .175 }, H };
N l6n122[] = { { sgxv, .226 }, { sgZy, .226 }, H };
N l6n123[] = { { shs, .201 }, { sgtX, .301 }, H };
N l6n124[] = { { sXvX, .201 }, { sXrhX, .167 }, H };
N l6n125[] = { { sxX, .769 }, H };
N l6n127[] = { { sgZsq, .451 }, H };
N l6n128[] = { { svXZ, .150 }, { swZ, .084 }, H };
N l6n129[] = { { sZmXg, .301 }, { srhXg, .251 }, H };
N l6n130[] = { { svx, .150 }, { sgZsr, .351 }, { sgyrX, .301 }, H };
N l6n131[] = { { svi, .685 }, { sgw, .777 }, { spir, .125 }, { sgtvs, .251 }, H };
N l6n132[] = { { sgh, 2.281 }, H };
N l6n133[] = { { spX, .735 }, { sirx, .401 }, H };
N l6n134[] = { { sgiw, .489 }, H };
N l6n136[] = { { smXg, .414 }, H };
N l6n137[] = { { sir, .869 }, { stm, .084 }, H };
N l6n138[] = { { sqXv, .150 }, H };
N l6n139[] = { { srZmX, .201 }, { sgXuy, .301 }, H };
N l6n140[] = { { sZsvr, .134 }, H };
N l6n141[] = { { shX, .234 }, { sf3g, .677 }, { smz, .134 }, { sYpm, .125 }, H };
N l6n142[] = { { sgZsv, .301 }, H };
N l6n143[] = { { sZv, .134 }, H };
N l6n144[] = { { sgpXw, .351 }, H };
N l6n145[] = { { ssg, .627 }, H };
N l6n146[] = { { sqs, .084 }, H };
N l6n147[] = { { sgmr, .226 }, H };
N l6n148[] = { { sgx, .576 }, H };
N l6n149[] = { { sgi, 1.604 }, H };
N l6n150[] = { { smxX, .175 }, H };
N l6n151[] = { { sgpXg, 1.404 }, { sguyi, .802 }, { sppi, .150 }, H };
N l6n152[] = { { sXrXg, .301 }, { syrxX, .134 }, H };
N l6n153[] = { { sgipg, .852 }, H };
N l6n155[] = { { sny, .084 }, H };
N l6n156[] = { { syX, .100 }, H };
N l6n157[] = { { ssp, .184 }, { sXvh, .125 }, H };
N l6n158[] = { { sxv, .284 }, { sgZX, .263 }, { sgqXv, .251 }, H };
N l6n159[] = { { svXg, .526 }, H };
N l6n160[] = { { sgqm, .263 }, { sppg, .226 }, H };
N l6n161[] = { { swx, .434 }, H };
N l6n162[] = { { swi, .518 }, { sqir, .276 }, H };
N l6n163[] = { { sqt, .117 }, H };
N l6n164[] = { { sqX, .301 }, { syrX, .150 }, H };
N l6n165[] = { { sgy, .326 }, H };
N l6n166[] = { { sgj, .376 }, H };
N l6n167[] = { { sgti, .376 }, { sxiv, .150 }, H };
N l6n169[] = { { smvg, .226 }, H };
N l6n170[] = { { sjmi, .100 }, H };
N l6n171[] = { { sp27, .267 }, { sit, .150 }, H };
N l6n172[] = { { siX, .134 }, H };
N l6n174[] = { { ssq, .201 }, { sXZmf3, .334 }, { svQ, .100 }, { sviX, .150 }, { syvw, .125 }, { shv, .067 }, H };
N l6n175[] = { { sgirg, .602 }, H };
N l6n176[] = { { ssrw, .226 }, { sgpp, .150 }, H };
N l6n177[] = { { sgXg, .451 }, { srs, .167 }, { sZx, .167 }, { sXvg, .263 }, H };
N l6n178[] = { { sZi, .084 }, { swy, .084 }, H };
N l6n182[] = { { sgz, .326 }, H };
N l6n183[] = { { spw, .201 }, { sgk, .201 }, { sxyv, .150 }, H };
N l6n184[] = { { sipwg, .351 }, H };
N l6n185[] = { { sgp27, .602 }, H };
N l6n186[] = { { spiw, .226 }, H };
N l6n187[] = { { szX, .234 }, { sZms, .201 }, { sr79g, .150 }, H };
N l6n188[] = { { sgpiw, .251 }, H };
N l6n189[] = { { syv, .351 }, { ssvr, .125 }, { sgi78, .188 }, { siY, .067 }, H };
N l6n191[] = { { ssr, .551 }, { sgxX, .263 }, { srXx, .100 }, H };
N l6n193[] = { { sxi, .368 }, H };
N l6n194[] = { { sXwg, .564 }, { sZy, .184 }, { shiw, .226 }, { smxi, .150 }, H };
N l6n195[] = { { srX, .551 }, H };
N l6n196[] = { { sviZ, .150 }, H };
N l6n199[] = { { sipg, 1.015 }, { svm, .251 }, { s79g, .276 }, { sZmf3g, .501 }, H };
N l6n200[] = { { sgl, .175 }, { spx, .100 }, H };
N l6n201[] = { { spi, .334 }, { sgvi, .376 }, { sXn, .067 }, H };
N l6n202[] = { { siZx, .150 }, { sirZ, .125 }, H };
N l6n203[] = { { suyi, .677 }, { sjX, .100 }, H };
N l6n204[] = { { swxX, .351 }, H };
N l6n205[] = { { siv, .635 }, { smZm, .150 }, H };
N l6n206[] = { { siZ, .217 }, { syw, .134 }, { sxXwg, .301 }, { sqiv, .125 }, H };
N l6n208[] = { { smsr, .276 }, H };
N l6n209[] = { { shi, 1.353 }, { syiw, .276 }, { sxy, .134 }, { sgjX, .188 }, { svwg, .188 }, H };
N l6n211[] = { { sXxg, .639 }, H };
N l6n212[] = { { sviwg, .251 }, H };
N l6n213[] = { { sXZm, .351 }, { shipg, .451 }, H };
N l6n214[] = { { spXwg, .401 }, { sp27X, .201 }, H };
N l6n215[] = { { smg, .526 }, H };
N l6n217[] = { { sgm, .526 }, { sxXxg, .301 }, H };
N l6n218[] = { { sgwi, .714 }, { siwx, .476 }, { smf3, .201 }, { sxyvX, .201 }, { se9w, .188 }, H };
N l6n219[] = { { sghi, 2.857 }, { shsg, .188 }, H };
N l6n220[] = { { sgp27X, .401 }, H };
N l6n221[] = { { sxXg, .451 }, H };
N l6n222[] = { { siw, 1.186 }, { sh27X, .100 }, H };
N l6n223[] = { { sXg, 3.233 }, { sih, .100 }, H };
N l6n224[] = { { syi, .535 }, H };
N l6n225[] = { { sppir, .134 }, H };
N l6n227[] = { { smp, .134 }, { svig, .188 }, H };
N l6n229[] = { { spXg, 1.090 }, { sirxg, .451 }, { srZ, .150 }, H };
N l6n230[] = { { swm, .134 }, { sgiwg, .301 }, { sZvi, .125 }, H };
N l6n231[] = { { stXv, .175 }, { stvs, .175 }, { svsr, .150 }, H };
N l6n232[] = { { sqi, .351 }, { syvX, .251 }, H };
N l6n233[] = { { sirg, .639 }, { sg79, .201 }, H };
N l6n234[] = { { ssrX, .276 }, { skX, .084 }, H };
N l6n235[] = { { sXp, .568 }, H };
N l6n236[] = { { ssvri, .167 }, H };
N l6n237[] = { { shXg, .338 }, H };
N l6n238[] = { { svg, .627 }, H };
N l6n239[] = { { sts, .234 }, { six, .117 }, H };
N l6n241[] = { { sXvQ, .125 }, H };
N l6n242[] = { { smxXx, .167 }, H };
N l6n243[] = { { smsrX, .234 }, { sglX, .226 }, { sgrs, .226 }, { ssY, .084 }, H };
N l6n244[] = { { smq, .134 }, { spQ, .084 }, H };
N l6n245[] = { { srw, .267 }, { sgXp, .376 }, { sxvi, .125 }, H };
N l6n246[] = { { sZm, .585 }, { srh, .167 }, { sXxm, .150 }, H };
N l6n248[] = { { sivX, .175 }, { s78t, .084 }, H };
N l6n249[] = { { svXr, .251 }, H };
N l6n252[] = { { sXq, .201 }, H };
N l6n253[] = { { siwxX, .368 }, { sgtiv, .351 }, H };
N l6n254[] = { { sqirx, .267 }, H };
N l6n255[] = { { szi, .100 }, H };

D l6_d = {
	"catalan",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.017, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.256, 0.020, 0.094, 0.090, 0.257, 0.016, 0.022, 0.008, 0.129, 0.006, W, 0.138, 0.058, 0.122, 0.105,
	    0.058, 0.019, 0.142, 0.140, 0.122, 0.084, 0.022, 0.001, 0.007, 0.011, 0.007, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    0.029, 0.008, V, V, V, V, V, 0.003, 0.006, 0.011, V, V, V, 0.009, V, V,
	    V, 0.005, 0.002, 0.027, V, V, V, V, V, V, 0.005, V, V, V, V, V },
	{ l6n0, l6n1, l6n2, l6n3, l6n4, l6n5, l6n6, l6n7, X, l6n9, l6n10, l6n11, l6n12, l6n13, l6n14, l6n15,
	    X, l6n17, l6n18, X, l6n20, l6n21, l6n22, l6n23, X, l6n25, l6n26, l6n27, l6n28, l6n29, X, l6n31,
	    X, l6n33, l6n34, l6n35, l6n36, l6n37, l6n38, X, l6n40, l6n41, l6n42, l6n43, l6n44, l6n45, l6n46, l6n47,
	    X, l6n49, X, l6n51, l6n52, l6n53, l6n54, l6n55, l6n56, l6n57, l6n58, l6n59, X, X, l6n62, l6n63,
	    l6n64, l6n65, l6n66, l6n67, X, l6n69, X, l6n71, l6n72, l6n73, l6n74, l6n75, l6n76, X, l6n78, l6n79,
	    l6n80, l6n81, l6n82, l6n83, l6n84, l6n85, X, l6n87, l6n88, l6n89, l6n90, l6n91, l6n92, l6n93, l6n94, l6n95,
	    l6n96, l6n97, l6n98, l6n99, X, l6n101, l6n102, l6n103, l6n104, l6n105, l6n106, l6n107, l6n108, l6n109, l6n110, l6n111,
	    l6n112, l6n113, l6n114, l6n115, l6n116, l6n117, l6n118, X, l6n120, l6n121, l6n122, l6n123, l6n124, l6n125, X, l6n127,
	    l6n128, l6n129, l6n130, l6n131, l6n132, l6n133, l6n134, X, l6n136, l6n137, l6n138, l6n139, l6n140, l6n141, l6n142, l6n143,
	    l6n144, l6n145, l6n146, l6n147, l6n148, l6n149, l6n150, l6n151, l6n152, l6n153, X, l6n155, l6n156, l6n157, l6n158, l6n159,
	    l6n160, l6n161, l6n162, l6n163, l6n164, l6n165, l6n166, l6n167, X, l6n169, l6n170, l6n171, l6n172, X, l6n174, l6n175,
	    l6n176, l6n177, l6n178, X, X, X, l6n182, l6n183, l6n184, l6n185, l6n186, l6n187, l6n188, l6n189, X, l6n191,
	    X, l6n193, l6n194, l6n195, l6n196, X, X, l6n199, l6n200, l6n201, l6n202, l6n203, l6n204, l6n205, l6n206, X,
	    l6n208, l6n209, X, l6n211, l6n212, l6n213, l6n214, l6n215, X, l6n217, l6n218, l6n219, l6n220, l6n221, l6n222, l6n223,
	    l6n224, l6n225, X, l6n227, X, l6n229, l6n230, l6n231, l6n232, l6n233, l6n234, l6n235, l6n236, l6n237, l6n238, l6n239,
	    X, l6n241, l6n242, l6n243, l6n244, l6n245, l6n246, X, l6n248, l6n249, X, X, l6n252, l6n253, l6n254, l6n255 }
};

//
// Lng: chinese
// Enc: big5
//

S sga4[] = { 32, 164, 0 };
S sga5[] = { 32, 165, 0 };
S sga1[] = { 32, 161, 0 };
S sga6[] = { 32, 166, 0 };
S sa1q[] = { 161, m, 0 };
S sga1qg[] = { 32, 161, m, a };
S sa1qg[] = { 161, m, a };
S sga1q[] = { 32, 161, m, 0 };
S sgaa[] = { 32, 170, 0 };
S sgad[] = { 32, 173, 0 };
S sgac[] = { 32, 172, 0 };
S sga9[] = { 32, 169, 0 };
S sgab[] = { 32, 171, 0 };
S sgb3[] = { 32, 179, 0 };
S sgb6[] = { 32, 182, 0 };
S sga8[] = { 32, 168, 0 };
S s7eg[] = { 126, a };
S sga7[] = { 32, 167, 0 };
S sgae[] = { 32, 174, 0 };
S sgb0[] = { 32, 176, 0 };
S sgb9[] = { 32, 185, 0 };
S sgb4[] = { 32, 180, 0 };
S sgb5[] = { 32, 181, 0 };
S saaba[] = { 170, 186, 0 };
S sfbg[] = { 251, a };
S sgb2[] = { 32, 178, 0 };
S s_g[] = { w, a };
S s40g[] = { 64, a };
S sgbe[] = { 32, 190, 0 };
S sDg[] = { 211, a };
S sb7g[] = { 183, a };
S sgaabag[] = { 32, 170, 186, a };
S sga1Zg[] = { 32, 161, 99, a };
S sa1Zg[] = { 161, 99, a };
S saabag[] = { 170, 186, a };
S sgaaba[] = { 32, 170, 186, 0 };
S sa1Z[] = { 161, 99, 0 };
S sga1Z[] = { 32, 161, 99, 0 };
S sYg[] = { 98, a };
S sa4u[] = { 164, q, 0 };
S sa3g[] = { 163, a };
S sgbb[] = { 32, 187, 0 };
S sa5g[] = { 165, a };
S sgc4[] = { 32, 196, 0 };
S sgb7g[] = { 32, 183, a };
S s78g[] = { x, a };
S sf8g[] = { 248, a };
S sc6g[] = { 198, a };
S sga4u[] = { 32, 164, q, 0 };
S sa440[] = { 164, 64, 0 };
S sb4U[] = { 180, 228, 0 };
S sb3g[] = { 179, a };
S sga1Xg[] = { 32, 161, 97, a };
S sgbc[] = { 32, 188, 0 };
S sadfbg[] = { 173, 251, a };
S sf4g[] = { 244, a };
S sgba[] = { 32, 186, 0 };
S sa1Xg[] = { 161, 97, a };
S sga1X[] = { 32, 161, 97, 0 };
S sgaf[] = { 32, 175, 0 };
S sgb4U[] = { 32, 180, 228, 0 };
S sadfb[] = { 173, 251, 0 };
S sga440[] = { 32, 164, 64, 0 };
S sgb4Ug[] = { 32, 180, 228, a };
S sga440g[] = { 32, 164, 64, a };
S sa440g[] = { 164, 64, a };
S sb9u[] = { 185, q, 0 };
S sb4Ug[] = { 180, 228, a };
S sa1X[] = { 161, 97, 0 };
S sa67eg[] = { 166, 126, a };
S sgadfbg[] = { 32, 173, 251, a };
S sga67e[] = { 32, 166, 126, 0 };
S sga4ug[] = { 32, 164, q, a };
S sa67e[] = { 166, 126, 0 };
S sgadfb[] = { 32, 173, 251, 0 };
S sa4ug[] = { 164, q, a };
S sga67eg[] = { 32, 166, 126, a };
S sgbec7[] = { 32, 190, 199, 0 };
S sc0g[] = { 192, a };
S sbec7[] = { 190, 199, 0 };
S sbec7g[] = { 190, 199, a };
S sceg[] = { 206, a };
S sgbec7g[] = { 32, 190, 199, a };
S szg[] = { v, a };
S sgb9u[] = { 32, 185, q, 0 };
S sadg[] = { 173, a };
S sga9f3g[] = { 32, 169, 243, a };
S sb9ug[] = { 185, q, a };
S sf7g[] = { 247, a };
S sgb9ug[] = { 32, 185, q, a };
S sa6t[] = { 166, p, 0 };
S sa9f3[] = { 169, 243, 0 };
S sa9f3g[] = { 169, 243, a };
S sc9g[] = { 201, a };
S sga9f3[] = { 32, 169, 243, 0 };
S sa6Y[] = { 166, 98, 0 };
S sga4l[] = { 32, 164, h, 0 };
S sga6Y[] = { 32, 166, 98, 0 };
S sa4ng[] = { 164, j, a };
S sf6g[] = { 246, a };
S sa4l[] = { 164, h, 0 };
S sga4lg[] = { 32, 164, h, a };
S sa578[] = { 165, x, 0 };
S sga5g[] = { 32, 165, a };
S sa4g[] = { 164, a };
S sa4n[] = { 164, j, 0 };
S sga4n[] = { 32, 164, j, 0 };
S sa4lg[] = { 164, h, a };
S sga578[] = { 32, 165, x, 0 };
S sa578g[] = { 165, x, a };
S sa4a3[] = { 164, 163, 0 };
S sga4ng[] = { 32, 164, j, a };
S sa6Yg[] = { 166, 98, a };
S sga578g[] = { 32, 165, x, a };
S sga6Yg[] = { 32, 166, 98, a };
S sa4ad[] = { 164, 173, 0 };
S sga4a3g[] = { 32, 164, 163, a };
S sb77e[] = { 183, 126, 0 };
S sga4a3[] = { 32, 164, 163, 0 };
S sa6tg[] = { 166, p, a };
S sa4i[] = { 164, e, 0 };
S sgb3ug[] = { 32, 179, q, a };
S sgc2[] = { 32, 194, 0 };
S sgacs[] = { 32, 172, o, 0 };
S sgb77e[] = { 32, 183, 126, 0 };
S sacs[] = { 172, o, 0 };
S sa5h[] = { 165, d, 0 };
S sb3ug[] = { 179, q, a };
S sgb3u[] = { 32, 179, q, 0 };
S sgb77eg[] = { 32, 183, 126, a };
S sgacsg[] = { 32, 172, o, a };
S sb3u[] = { 179, q, 0 };
S sacsg[] = { 172, o, a };
S s60g[] = { 96, a };
S sccg[] = { 204, a };
S sb77eg[] = { 183, 126, a };
S sa4a3g[] = { 164, 163, a };
S sb8M[] = { 184, 220, 0 };
S sgb8fbg[] = { 32, 184, 251, a };
S sgaaf8[] = { 32, 170, 248, 0 };
S sbef7[] = { 190, 247, 0 };
S sua4[] = { q, 164, 0 };
S sa6Xg[] = { 166, 97, a };
S sgb8Mg[] = { 32, 184, 220, a };
S sga5hg[] = { 32, 165, d, a };
S saey[] = { 174, u, 0 };
S se8g[] = { 232, a };
S sa4e9[] = { 164, 233, 0 };
S sa4c0[] = { 164, 192, 0 };
S sga5h[] = { 32, 165, d, 0 };
S saaf8g[] = { 170, 248, a };
S sf9g[] = { 249, a };
S sa5hg[] = { 165, d, a };
S sgc5[] = { 32, 197, 0 };
S sb8fbg[] = { 184, 251, a };
S sga8c6[] = { 32, 168, 198, 0 };
S sb8fb[] = { 184, 251, 0 };
S sgaaf8g[] = { 32, 170, 248, a };
S sga6t[] = { 32, 166, p, 0 };
S sa8c6g[] = { 168, 198, a };
S sa6X[] = { 166, 97, 0 };
S sa8c6[] = { 168, 198, 0 };
S sb8Mg[] = { 184, 220, a };
S sga8c6g[] = { 32, 168, 198, a };
S sgb8fb[] = { 32, 184, 251, 0 };
S saaf8[] = { 170, 248, 0 };
S sa6b3[] = { 166, 179, 0 };
S sfcg[] = { 252, a };
S sga6tg[] = { 32, 166, p, a };
S sa4_[] = { 164, w, 0 };
S sgb8M[] = { 32, 184, 220, 0 };
S sc1g[] = { 193, a };
S sVg[] = { 229, a };
S sga6_g[] = { 32, 166, w, a };
S sga4bdg[] = { 32, 164, 189, a };
S sadD[] = { 173, 211, 0 };
S sga4a7[] = { 32, 164, 167, 0 };
S sga4a7g[] = { 32, 164, 167, a };
S sf5g[] = { 245, a };
S sa4bdg[] = { 164, 189, a };
S sga4i[] = { 32, 164, e, 0 };
S sacjg[] = { 172, f, a };
S sgaec9g[] = { 32, 174, 201, a };
S sga5ce[] = { 32, 165, 206, 0 };
S sacb0[] = { 172, 176, 0 };
S saec9[] = { 174, 201, 0 };
S sacj[] = { 172, f, 0 };
S sga4bd[] = { 32, 164, 189, 0 };
S sga4bag[] = { 32, 164, 186, a };
S sga5ceg[] = { 32, 165, 206, a };
S sga4_g[] = { 32, 164, w, a };
S sHg[] = { 215, a };
S sgacj[] = { 32, 172, f, 0 };
S sb8t[] = { 184, p, 0 };
S sa4a7[] = { 164, 167, 0 };
S sga4_[] = { 32, 164, w, 0 };
S scag[] = { 202, a };
S sb8tg[] = { 184, p, a };
S sgaec9[] = { 32, 174, 201, 0 };
S sgacjg[] = { 32, 172, f, a };
S sgbef7[] = { 32, 190, 247, 0 };
S secg[] = { 236, a };
S sgbef7g[] = { 32, 190, 247, a };
S saec9g[] = { 174, 201, a };
S sa4a7g[] = { 164, 167, a };
S sedg[] = { 237, a };
S sgb8tg[] = { 32, 184, p, a };
S sgb8t[] = { 32, 184, p, 0 };
S sa4ig[] = { 164, e, a };
S sa4x[] = { 164, t, 0 };
S sga4ig[] = { 32, 164, e, a };
S sga6_[] = { 32, 166, w, 0 };
S sga4ba[] = { 32, 164, 186, 0 };
S sa5l[] = { 165, h, 0 };
S sa6_[] = { 166, w, 0 };
S sa5ceg[] = { 165, 206, a };
S sa5ce[] = { 165, 206, 0 };
S sbef7g[] = { 190, 247, a };
S sa4_g[] = { 164, w, a };
S sa4ba[] = { 164, 186, 0 };
S sa6_g[] = { 166, w, a };
S sa4bag[] = { 164, 186, a };
S sa4bd[] = { 164, 189, 0 };
S sa740[] = { 167, 64, 0 };
S sb5s[] = { 181, o, 0 };
S sb8ea[] = { 184, 234, 0 };
S sb8D[] = { 184, 211, 0 };
S sga1Y[] = { 32, 161, 98, 0 };
S sgb6b1g[] = { 32, 182, 177, a };
S sgb6b1[] = { 32, 182, 177, 0 };
S sgb8D[] = { 32, 184, 211, 0 };
S sgc4b5g[] = { 32, 196, 181, a };
S sga4kg[] = { 32, 164, g, a };
S sga4e9[] = { 32, 164, 233, 0 };
S sga6b3[] = { 32, 166, 179, 0 };
S sgb2c4[] = { 32, 178, 196, 0 };
S sa5bb[] = { 165, 187, 0 };
S sa65e[] = { 166, 94, 0 };
S s5ea1k[] = { 94, 161, g, 0 };
S sgb8Dg[] = { 32, 184, 211, a };
S sga1Yg[] = { 32, 161, 98, a };
S sga4c0g[] = { 32, 164, 192, a };
S sa6ca[] = { 166, 202, 0 };
S sga4k[] = { 32, 164, g, 0 };
S sgb5s[] = { 32, 181, o, 0 };
S sa4adg[] = { 164, 173, a };
S sgc4b5[] = { 32, 196, 181, 0 };
S sa1Y[] = { 161, 98, 0 };
S sa4ua4[] = { 164, q, 164, 0 };
S sga6cag[] = { 32, 166, 202, a };
S sc4b5[] = { 196, 181, 0 };
S sa1Yg[] = { 161, 98, a };
S sga4adg[] = { 32, 164, 173, a };
S sga740[] = { 32, 167, 64, 0 };
S sga4e9g[] = { 32, 164, 233, a };
S sga57e[] = { 32, 165, 126, 0 };
S sa57e[] = { 165, 126, 0 };
S sgadDg[] = { 32, 173, 211, a };
S sc4b5g[] = { 196, 181, a };
S sga57eg[] = { 32, 165, 126, a };
S sb5sg[] = { 181, o, a };
S s5ea1[] = { 94, 161, 0 };
S sebg[] = { 235, a };
S sgb8eag[] = { 32, 184, 234, a };
S sga4ad[] = { 32, 164, 173, 0 };
S sb6b1g[] = { 182, 177, a };
S sa1k[] = { 161, g, 0 };
S sb8Dg[] = { 184, 211, a };
S sa6b3g[] = { 166, 179, a };
S sa57eg[] = { 165, 126, a };
S sga740g[] = { 32, 167, 64, a };
S sa6cag[] = { 166, 202, a };
S sa4c0g[] = { 164, 192, a };
S sb2c4[] = { 178, 196, 0 };
S sga6Xg[] = { 32, 166, 97, a };
S sgadD[] = { 32, 173, 211, 0 };
S sga6b3g[] = { 32, 166, 179, a };
S sa8D[] = { 168, 211, 0 };
S sa65ea1[] = { 166, 94, 161, 0 };
S sa740g[] = { 167, 64, a };
S sa1g[] = { 161, a };
S sb6b1[] = { 182, 177, 0 };
S sa4k[] = { 164, g, 0 };
S sgb5sg[] = { 32, 181, o, a };
S sa4e9g[] = { 164, 233, a };
S sga4c0[] = { 32, 164, 192, 0 };
S sgb8ea[] = { 32, 184, 234, 0 };
S sb8eag[] = { 184, 234, a };
S sga6ca[] = { 32, 166, 202, 0 };
S sa4o[] = { 164, k, 0 };
S sadDg[] = { 173, 211, a };
S sa4kg[] = { 164, g, a };
S sga6X[] = { 32, 166, 97, 0 };
S sa65ea1k[] = { 166, 94, 161, g, 0 };
S sa6M[] = { 166, 220, 0 };
S sga6Mg[] = { 32, 166, 220, a };
S sga4w[] = { 32, 164, s, 0 };
S sa5pg[] = { 165, l, a };
S sa4a4[] = { 164, 164, 0 };
S sga4a4[] = { 32, 164, 164, 0 };
S sa4a9g[] = { 164, 169, a };
S sa4Z[] = { 164, 99, 0 };
S sga4yg[] = { 32, 164, u, a };
S sabi[] = { 171, e, 0 };
S sa6Mg[] = { 166, 220, a };
S sacb0g[] = { 172, 176, a };
S sbcg[] = { 188, a };
S sga4S[] = { 32, 164, 226, 0 };
S sGg[] = { 214, a };
S sachg[] = { 172, d, a };
S sga4e8g[] = { 32, 164, 232, a };
S sgabig[] = { 32, 171, e, a };
S sa5lg[] = { 165, h, a };
S sga4a4g[] = { 32, 164, 164, a };
S sga5Bg[] = { 32, 165, 209, a };
S sa5B[] = { 165, 209, 0 };
S sgabi[] = { 32, 171, e, 0 };
S sb4g[] = { 180, a };
S sa4y[] = { 164, u, 0 };
S sa4Sg[] = { 164, 226, a };
S sa8g[] = { 168, a };
S sa5p[] = { 165, l, 0 };
S sgacb0[] = { 32, 172, 176, 0 };
S sgb0eag[] = { 32, 176, 234, a };
S sgachg[] = { 32, 172, d, a };
S sb0eag[] = { 176, 234, a };
S sa4S[] = { 164, 226, 0 };
S sga4a9g[] = { 32, 164, 169, a };
S sga4e8[] = { 32, 164, 232, 0 };
S sga5B[] = { 32, 165, 209, 0 };
S sgb0aag[] = { 32, 176, 170, a };
S sga4o[] = { 32, 164, k, 0 };
S sb0ea[] = { 176, 234, 0 };
S sgb0aa[] = { 32, 176, 170, 0 };
S sb0aag[] = { 176, 170, a };
S sga4Sg[] = { 32, 164, 226, a };
S sgb0g[] = { 32, 176, a };
S sadbb[] = { 173, 187, 0 };

N l7n0[] = { { sgb4Ug, .654 }, H };
N l7n1[] = { { sa6_, .163 }, { sa1Y, .140 }, H };
N l7n3[] = { { sbdg, .420 }, { sga6_, .245 }, H };
N l7n4[] = { { sgb9u, .385 }, { sga4c0, .210 }, H };
N l7n7[] = { { sgb7, .980 }, H };
N l7n8[] = { { sga8, .934 }, H };
N l7n9[] = { { sf7g, .578 }, { sa5ceg, .368 }, H };
N l7n10[] = { { sgb5sg, .280 }, { sGg, .263 }, H };
N l7n11[] = { { sb5g, .560 }, { sgbec7, .420 }, { sgc4b5g, .280 }, H };
N l7n13[] = { { swg, .257 }, H };
N l7n14[] = { { saaf8, .187 }, { sgacjg, .327 }, H };
N l7n15[] = { { sa4a3g, .473 }, { sga5ceg, .327 }, H };
N l7n17[] = { { sefg, .525 }, { sgacs, .315 }, { sgaec9, .245 }, { sga6X, .210 }, H };
N l7n18[] = { { sa1Z, .560 }, { sceg, .630 }, H };
N l7n19[] = { { sadg, .385 }, { s5ea1, .093 }, { sa4kg, .315 }, H };
N l7n21[] = { { sog, .280 }, H };
N l7n22[] = { { sga6tg, .373 }, { sa6Mg, .263 }, H };
N l7n23[] = { { sga740g, .280 }, H };
N l7n24[] = { { sgb8, 1.190 }, { sb8tg, .368 }, H };
N l7n25[] = { { sga9, 1.074 }, { se7g, .263 }, H };
N l7n26[] = { { sc6g, .840 }, H };
N l7n27[] = { { sa5g, .665 }, { sga4i, .245 }, { sgbef7, .245 }, H };
N l7n28[] = { { sa1qg, 3.151 }, { sa440, .350 }, { sga1Xg, .654 }, { sga6Y, .350 }, { sga4e8g, .233 }, H };
N l7n29[] = { { sZg, .724 }, H };
N l7n30[] = { { sgb2c4, .210 }, H };
N l7n33[] = { { sga5h, .280 }, { sc4b5g, .473 }, H };
N l7n34[] = { { sga4bag, .327 }, { sbeg, .245 }, H };
N l7n35[] = { { sa4_g, .368 }, H };
N l7n36[] = { { sa4lg, .525 }, H };
N l7n37[] = { { sga4a3g, .420 }, H };
N l7n38[] = { { sgadfb, .455 }, { sgb8ea, .210 }, H };
N l7n39[] = { { sga1Yg, .280 }, { sga4e9g, .280 }, { sa5p, .117 }, H };
N l7n40[] = { { sgaaba, .840 }, { sf8g, .840 }, H };
N l7n41[] = { { sgb9, .770 }, { sHg, .368 }, { sgb8D, .210 }, H };
N l7n42[] = { { sgaa, 1.354 }, H };
N l7n43[] = { { sb6b1g, .315 }, { sga4yg, .233 }, H };
N l7n44[] = { { sxg, .373 }, H };
N l7n46[] = { { sb3u, .210 }, H };
N l7n48[] = { { sga4a4g, .233 }, { sga5Bg, .233 }, H };
N l7n49[] = { { scfg, .630 }, { sga4k, .210 }, H };
N l7n50[] = { { sga1Zg, 1.120 }, { sgaaf8g, .373 }, { sb8eag, .315 }, H };
N l7n51[] = { { sacs, .210 }, { sga4ad, .210 }, H };
N l7n52[] = { { spg, .373 }, H };
N l7n53[] = { { sga5g, .350 }, H };
N l7n54[] = { { sa4ba, .163 }, H };
N l7n56[] = { { se8g, .420 }, H };
N l7n57[] = { { sc7g, .945 }, { sbec7, .280 }, H };
N l7n58[] = { { sgba, .327 }, { sb0eag, .263 }, H };
N l7n59[] = { { sgab, .980 }, H };
N l7n60[] = { { shg, .560 }, { sga4l, .350 }, H };
N l7n62[] = { { sa4Sg, .263 }, { sgb0aag, .233 }, H };
N l7n63[] = { { sga57e, .210 }, H };
N l7n64[] = { { sga1q, 2.101 }, H };
N l7n65[] = { { sgb8fbg, .373 }, { sga4_g, .327 }, H };
N l7n67[] = { { sga4bdg, .327 }, { sa65ea1, .210 }, { sa5lg, .263 }, H };
N l7n68[] = { { sb8Mg, .420 }, H };
N l7n70[] = { { sa4ng, .525 }, H };
N l7n71[] = { { sf9g, .420 }, H };
N l7n72[] = { { sb9ug, .578 }, { sgb8tg, .327 }, { sIg, .368 }, H };
N l7n73[] = { { sb7g, .875 }, H };
N l7n74[] = { { sb5s, .140 }, H };
N l7n75[] = { { syg, .560 }, { sgbb, .443 }, { sb8D, .140 }, H };
N l7n76[] = { { sgac, 1.144 }, H };
N l7n80[] = { { saabag, 1.260 }, { sa1Xg, .735 }, { sb4Ug, .735 }, { sga67e, .455 }, { sAg, .473 }, H };
N l7n81[] = { { sga4a7g, .327 }, H };
N l7n82[] = { { sga4n, .350 }, H };
N l7n83[] = { { sqg, 1.587 }, { sa578g, .525 }, { sb8fbg, .420 }, { sa4a7g, .368 }, H };
N l7n85[] = { { sa4e9, .187 }, H };
N l7n86[] = { { sa1k, .140 }, { sadDg, .315 }, H };
N l7n87[] = { { se9g, .315 }, H };
N l7n88[] = { { sc8g, .473 }, { sa65e, .140 }, H };
N l7n89[] = { { sa7g, .455 }, { sa4ad, .210 }, { sa57e, .140 }, H };
N l7n91[] = { { sig, .350 }, { sa8D, .140 }, H };
N l7n92[] = { { sgbc, .327 }, H };
N l7n93[] = { { sgad, 1.237 }, { sa4u, .467 }, { sga578g, .467 }, { sa6b3g, .315 }, { sga4o, .175 }, H };
N l7n94[] = { { sadbb, .117 }, H };
N l7n95[] = { { sRg, .420 }, H };
N l7n96[] = { { sc0g, .630 }, H };
N l7n97[] = { { sa6_g, .368 }, { sa1Yg, .315 }, H };
N l7n98[] = { { s7eg, .934 }, H };
N l7n99[] = { { sga6_g, .327 }, H };
N l7n100[] = { { sgb9ug, .513 }, { sga4c0g, .280 }, H };
N l7n102[] = { { sa5bb, .140 }, H };
N l7n103[] = { { sgb7g, .630 }, { sga4a9g, .233 }, H };
N l7n104[] = { { sb8g, .280 }, H };
N l7n105[] = { { sbef7, .187 }, { sa4bd, .163 }, { sa4ua4, .210 }, H };
N l7n106[] = { { szg, .280 }, { sabi, .117 }, H };
N l7n107[] = { { sgbec7g, .560 }, { saec9, .163 }, H };
N l7n109[] = { { sgbd, .420 }, H };
N l7n110[] = { { sgae, .817 }, { sf2g, .630 }, { saaf8g, .420 }, { sgadD, .210 }, H };
N l7n111[] = { { sBg, .578 }, { sa4Z, .117 }, H };
N l7n112[] = { { sb0g, .455 }, H };
N l7n113[] = { { sgb77e, .315 }, { sgacsg, .420 }, { sgaec9g, .327 }, { sga6Xg, .280 }, H };
N l7n114[] = { { sa1Zg, 1.260 }, { srg, .350 }, H };
N l7n117[] = { { sa4a9g, .263 }, H };
N l7n118[] = { { seag, .683 }, H };
N l7n119[] = { { sc9g, .578 }, H };
N l7n120[] = { { sa67e, .303 }, { sa65ea1k, .280 }, { sa8g, .175 }, H };
N l7n121[] = { { sa740, .140 }, H };
N l7n122[] = { { sjg, .467 }, { sga4S, .175 }, H };
N l7n123[] = { { sgbef7g, .327 }, { sga4ig, .327 }, H };
N l7n124[] = { { sa440g, .735 }, { sga6Yg, .467 }, H };
N l7n126[] = { { sgbe, .607 }, { sSg, .525 }, { sa8c6, .187 }, H };
N l7n127[] = { { sgaf, .327 }, { sc1g, .368 }, H };
N l7n128[] = { { s5ea1k, .140 }, H };
N l7n129[] = { { sga5hg, .373 }, H };
N l7n132[] = { { sga440, .490 }, { sacb0, .163 }, { sa6ca, .140 }, H };
N l7n133[] = { { sfbg, 1.470 }, H };
N l7n134[] = { { sgadfbg, .607 }, { sKg, .473 }, { sgb8eag, .280 }, H };
N l7n135[] = { { sb77e, .210 }, { sb9g, .280 }, { sa5pg, .263 }, H };
N l7n136[] = { { sgaabag, 1.120 }, H };
N l7n137[] = { { s_g, .607 }, { sgb8Dg, .280 }, H };
N l7n138[] = { { sa6t, .257 }, { sga9f3, .385 }, { sga8c6, .280 }, H };
N l7n139[] = { { sa6X, .187 }, H };
N l7n140[] = { { sgb8M, .280 }, H };
N l7n141[] = { { sf3g, .840 }, H };
N l7n142[] = { { sCg, .473 }, { sb3ug, .473 }, H };
N l7n143[] = { { sb1g, .455 }, { sgbf, .187 }, H };
N l7n144[] = { { sgb0, .817 }, { sa4x, .163 }, H };
N l7n145[] = { { sga1, 2.614 }, { ssg, .770 }, { sa4i, .210 }, { sgb6b1, .210 }, { sga4kg, .280 }, H };
N l7n146[] = { { sb2c4, .140 }, { sgabi, .175 }, H };
N l7n147[] = { { sacsg, .473 }, { sua4, .124 }, { sga4adg, .280 }, H };
N l7n148[] = { { sga6ca, .210 }, H };
N l7n149[] = { { sebg, .315 }, H };
N l7n150[] = { { scag, .368 }, { sa4bag, .368 }, H };
N l7n151[] = { { sa9g, .245 }, { sga6b3, .210 }, H };
N l7n153[] = { { skg, .327 }, { sbec7g, .630 }, H };
N l7n154[] = { { sa9f3, .257 }, { sacj, .163 }, H };
N l7n156[] = { { sa6Y, .233 }, { sga4lg, .467 }, { sa4c0, .187 }, H };
N l7n158[] = { { sadfb, .327 }, { sgb3u, .315 }, H };
N l7n159[] = { { sga4u, .560 }, { sa5h, .210 }, { sga57eg, .280 }, { sa1g, .210 }, H };
N l7n160[] = { { sga1qg, 2.801 }, { sgc0, .373 }, { sgb4U, .490 }, H };
N l7n161[] = { { sgb1, .864 }, { sa4y, .117 }, H };
N l7n164[] = { { sfcg, .420 }, H };
N l7n166[] = { { sbag, 1.190 }, H };
N l7n168[] = { { s78g, .397 }, H };
N l7n169[] = { { sa5ce, .163 }, H };
N l7n170[] = { { sgb5s, .210 }, { sb5sg, .315 }, H };
N l7n171[] = { { sgc4b5, .210 }, { sb8Dg, .315 }, H };
N l7n172[] = { { sf4g, .735 }, H };
N l7n173[] = { { sDg, 1.313 }, H };
N l7n174[] = { { sb2g, .385 }, { sgacj, .245 }, H };
N l7n175[] = { { sa4a3, .233 }, { sga5ce, .245 }, H };
N l7n176[] = { { stg, .747 }, { sga67eg, .607 }, H };
N l7n177[] = { { sgc1, .350 }, H };
N l7n178[] = { { sgb2, .630 }, { sga4ng, .467 }, H };
N l7n179[] = { { sa4k, .140 }, H };
N l7n180[] = { { secg, .368 }, H };
N l7n181[] = { { sa4e9g, .315 }, { sga4w, .175 }, H };
N l7n182[] = { { saag, .315 }, { sga6t, .280 }, { sa6M, .117 }, H };
N l7n183[] = { { sga740, .210 }, H };
N l7n184[] = { { slg, .560 }, { sb8t, .163 }, H };
N l7n185[] = { { sa4adg, .315 }, { sa57eg, .315 }, H };
N l7n186[] = { { sga6Mg, .233 }, H };
N l7n188[] = { { sa1q, 1.400 }, { sUg, .840 }, { sga1X, .490 }, { sga4e8, .175 }, H };
N l7n189[] = { { sa4ug, .683 }, H };
N l7n192[] = { { s60g, .210 }, { sa4a4, .117 }, H };
N l7n193[] = { { sc4b5, .210 }, H };
N l7n194[] = { { sgc2, .210 }, { sga4ba, .245 }, H };
N l7n195[] = { { sgb3, .934 }, { sa4_, .187 }, H };
N l7n196[] = { { sga4, 4.808 }, { sMg, .945 }, { sa4l, .233 }, H };
N l7n197[] = { { sbbg, .525 }, { sga4a3, .315 }, H };
N l7n199[] = { { sga1Y, .210 }, { sga4e9, .210 }, H };
N l7n201[] = { { sa4bdg, .368 }, { sbef7g, .368 }, H };
N l7n203[] = { { sf5g, .368 }, { saec9g, .368 }, { sb6b1, .140 }, H };
N l7n204[] = { { sEg, .368 }, H };
N l7n205[] = { { sb3g, .525 }, H };
N l7n206[] = { { sgadDg, .280 }, H };
N l7n207[] = { { sug, 1.097 }, H };
N l7n208[] = { { sga4a4, .175 }, { sga5B, .175 }, H };
N l7n209[] = { { sgb77eg, .420 }, H };
N l7n210[] = { { sga1Z, .840 }, { sgaaf8, .280 }, { sb8ea, .140 }, H };
N l7n211[] = { { sgc3, .280 }, { sedg, .368 }, H };
N l7n212[] = { { sgb4, .747 }, { sccg, .473 }, H };
N l7n213[] = { { sga5, 2.708 }, H };
N l7n215[] = { { smg, .327 }, { saey, .187 }, H };
N l7n216[] = { { sa67eg, .683 }, { sachg, .263 }, H };
N l7n217[] = { { sa740g, .315 }, H };
N l7n218[] = { { sb0ea, .117 }, { sga4Sg, .233 }, H };
N l7n219[] = { { sVg, .368 }, H };
N l7n220[] = { { sa5B, .117 }, { sgacb0, .175 }, H };
N l7n221[] = { { sa3g, .700 }, H };
N l7n222[] = { { sa8c6g, .420 }, { sa4S, .117 }, { sgb0aa, .175 }, H };
N l7n223[] = { { sXg, .747 }, H };
N l7n224[] = { { s40g, .607 }, H };
N l7n225[] = { { sgb8fb, .280 }, { sga4_, .245 }, H };
N l7n227[] = { { sga4bd, .245 }, { sa5l, .163 }, H };
N l7n228[] = { { sgc4, .443 }, { sga440g, .654 }, { sb8M, .187 }, { sa6cag, .315 }, { sacb0g, .263 }, { sbcg, .175 }, H };
N l7n229[] = { { sgb5, .724 }, H };
N l7n230[] = { { sga6, 2.521 }, { sa4n, .233 }, H };
N l7n231[] = { { sb77eg, .473 }, H };
N l7n232[] = { { sb9u, .327 }, { sgb8t, .245 }, H };
N l7n234[] = { { sga9f3g, .513 }, { sf6g, .525 }, { sa6tg, .473 }, { sga8c6g, .373 }, H };
N l7n235[] = { { sFg, .578 }, { sa6Xg, .420 }, H };
N l7n236[] = { { sgb8Mg, .373 }, { sb4g, .175 }, H };
N l7n240[] = { { saaba, .654 }, { sb4U, .350 }, { sa1X, .327 }, { sgb0g, .175 }, H };
N l7n241[] = { { sga4a7, .245 }, { sa4ig, .368 }, { sgb6b1g, .280 }, H };
N l7n242[] = { { sgabig, .233 }, H };
N l7n243[] = { { sa578, .233 }, { sb8fb, .187 }, { sa4a7, .163 }, H };
N l7n244[] = { { sacg, .245 }, { sga6cag, .280 }, H };
N l7n245[] = { { sgc5, .187 }, H };
N l7n246[] = { { sgb6, .934 }, { sng, .397 }, { sadD, .163 }, H };
N l7n247[] = { { sga7, .864 }, { sga6b3g, .280 }, { sa4o, .140 }, H };
N l7n248[] = { { sgachg, .233 }, H };
N l7n250[] = { { sa9f3g, .578 }, { sacjg, .368 }, { sWg, .315 }, { sb0aag, .263 }, H };
N l7n252[] = { { sa4g, .350 }, { sa6Yg, .525 }, { sa4c0g, .315 }, H };
N l7n253[] = { { sga578, .350 }, { sa6b3, .187 }, H };
N l7n254[] = { { sYg, .537 }, { sadfbg, .735 }, { sgb3ug, .420 }, { sgb0eag, .233 }, H };
N l7n255[] = { { sga4ug, .607 }, { sa5hg, .420 }, H };

D l7_d = {
	"chinese",
	"big5",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    0.018, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, W, 0.004, W,
	    0.006, 0.022, 0.016, 0.021, 0.018, 0.012, 0.012, 0.014, 0.016, 0.009, 0.011, 0.008, 0.012, 0.043, 0.011, 0.022,
	    0.023, 0.037, 0.002, 0.009, 0.012, 0.018, 0.008, 0.017, 0.011, 0.003, 0.003, W, W, W, 0.025, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.129, Y, 0.021, 0.224, 0.127, 0.121, 0.050, 0.045, 0.050, 0.071, 0.046, 0.058, 0.064, 0.042, 0.018,
	    0.044, 0.048, 0.036, 0.059, 0.038, 0.043, 0.038, 0.049, 0.058, 0.047, 0.051, 0.036, 0.018, 0.033, 0.035, 0.012,
	    0.035, 0.031, 0.018, 0.024, 0.042, 0.015, 0.024, 0.025, 0.014, 0.015, 0.011, 0.007, 0.013, 0.008, 0.017, 0.017,
	    0.018, 0.015, 0.013, 0.041, 0.010, 0.017, 0.007, 0.010, 0.013, V, 0.014, 0.004, 0.027, 0.007, V, 0.004,
	    0.006, 0.011, 0.017, 0.006, 0.024, 0.010, 0.008, 0.007, 0.011, 0.013, 0.018, 0.010, 0.010, 0.010, 0.004, 0.018,
	    0.004, 0.003, 0.017, 0.025, 0.020, 0.011, 0.014, 0.017, 0.025, 0.013, 0.007, 0.041, 0.014, 0.001, 0.004, V },
	{ l7n0, l7n1, X, l7n3, l7n4, X, X, l7n7, l7n8, l7n9, l7n10, l7n11, X, l7n13, l7n14, l7n15,
	    X, l7n17, l7n18, l7n19, X, l7n21, l7n22, l7n23, l7n24, l7n25, l7n26, l7n27, l7n28, l7n29, l7n30, X,
	    X, l7n33, l7n34, l7n35, l7n36, l7n37, l7n38, l7n39, l7n40, l7n41, l7n42, l7n43, l7n44, X, l7n46, X,
	    l7n48, l7n49, l7n50, l7n51, l7n52, l7n53, l7n54, X, l7n56, l7n57, l7n58, l7n59, l7n60, X, l7n62, l7n63,
	    l7n64, l7n65, X, l7n67, l7n68, X, l7n70, l7n71, l7n72, l7n73, l7n74, l7n75, l7n76, X, X, X,
	    l7n80, l7n81, l7n82, l7n83, X, l7n85, l7n86, l7n87, l7n88, l7n89, X, l7n91, l7n92, l7n93, l7n94, l7n95,
	    l7n96, l7n97, l7n98, l7n99, l7n100, X, l7n102, l7n103, l7n104, l7n105, l7n106, l7n107, X, l7n109, l7n110, l7n111,
	    l7n112, l7n113, l7n114, X, X, l7n117, l7n118, l7n119, l7n120, l7n121, l7n122, l7n123, l7n124, X, l7n126, l7n127,
	    l7n128, l7n129, X, X, l7n132, l7n133, l7n134, l7n135, l7n136, l7n137, l7n138, l7n139, l7n140, l7n141, l7n142, l7n143,
	    l7n144, l7n145, l7n146, l7n147, l7n148, l7n149, l7n150, l7n151, X, l7n153, l7n154, X, l7n156, X, l7n158, l7n159,
	    l7n160, l7n161, X, X, l7n164, X, l7n166, X, l7n168, l7n169, l7n170, l7n171, l7n172, l7n173, l7n174, l7n175,
	    l7n176, l7n177, l7n178, l7n179, l7n180, l7n181, l7n182, l7n183, l7n184, l7n185, l7n186, X, l7n188, l7n189, X, X,
	    l7n192, l7n193, l7n194, l7n195, l7n196, l7n197, X, l7n199, X, l7n201, X, l7n203, l7n204, l7n205, l7n206, l7n207,
	    l7n208, l7n209, l7n210, l7n211, l7n212, l7n213, X, l7n215, l7n216, l7n217, l7n218, l7n219, l7n220, l7n221, l7n222, l7n223,
	    l7n224, l7n225, X, l7n227, l7n228, l7n229, l7n230, l7n231, l7n232, X, l7n234, l7n235, l7n236, X, X, X,
	    l7n240, l7n241, l7n242, l7n243, l7n244, l7n245, l7n246, l7n247, l7n248, X, l7n250, X, l7n252, l7n253, l7n254, l7n255 }
};

//
// Lng: chinese
// Enc: gb2313
//

S sga3[] = { 32, 163, 0 };
S sa3ac[] = { 163, 172, 0 };
S sga3ac[] = { 32, 163, 172, 0 };
S sga3acg[] = { 32, 163, 172, a };
S sa3acg[] = { 163, 172, a };
S sc4g[] = { 196, a };
S sb5c4[] = { 181, 196, 0 };
S sb5c4g[] = { 181, 196, a };
S sgb5c4g[] = { 32, 181, 196, a };
S sgb5c4[] = { 32, 181, 196, 0 };
S sgG[] = { 32, 214, 0 };
S sa2g[] = { 162, a };
S sgce[] = { 32, 206, 0 };
S sga1a3g[] = { 32, 161, 163, a };
S sa1a3[] = { 161, 163, 0 };
S sa1a3g[] = { 161, 163, a };
S sga1a3[] = { 32, 161, 163, 0 };
S scbg[] = { 203, a };
S sgc9[] = { 32, 201, 0 };
S sfag[] = { 250, a };
S sb9fa[] = { 185, 250, 0 };
S sc1cb[] = { 193, 203, 0 };
S sc1cbg[] = { 193, 203, a };
S sgcb[] = { 32, 203, 0 };
S sgcd[] = { 32, 205, 0 };
S sgc1cb[] = { 32, 193, 203, 0 };
S sgc1cbg[] = { 32, 193, 203, a };
S saeg[] = { 174, a };
S sEK[] = { 212, 218, 0 };
S sga1a2g[] = { 32, 161, 162, a };
S sa3b1[] = { 163, 177, 0 };
S sga3b1g[] = { 32, 163, 177, a };
S sga3b0[] = { 32, 163, 176, 0 };
S sa3b1g[] = { 163, 177, a };
S sga3b1[] = { 32, 163, 177, 0 };
S sEKg[] = { 212, 218, a };
S sga3b0g[] = { 32, 163, 176, a };
S sa1a2[] = { 161, 162, 0 };
S sb9fag[] = { 185, 250, a };
S sa1a2g[] = { 161, 162, a };
S sa3b0[] = { 163, 176, 0 };
S sa3b0g[] = { 163, 176, a };
S sga1a2[] = { 32, 161, 162, 0 };
S sa3a4[] = { 163, 164, 0 };
S sc4ea[] = { 196, 234, 0 };
S sga3a4g[] = { 32, 163, 164, a };
S sga3a4[] = { 32, 163, 164, 0 };
S sa3a4g[] = { 163, 164, a };
S scdg[] = { 205, a };
S sgEK[] = { 32, 212, 218, 0 };
S sb9a4[] = { 185, 164, 0 };
S sAA[] = { 208, 208, 0 };
S sgcf[] = { 32, 207, 0 };
S sgEKg[] = { 32, 212, 218, a };
S sgcc[] = { 32, 204, 0 };
S sHf7[] = { 215, 247, 0 };
S sb6g[] = { 182, a };
S sfdg[] = { 253, a };
S sc4eag[] = { 196, 234, a };
S sa3b5g[] = { 163, 181, a };
S sf1g[] = { 241, a };
S sga3b5[] = { 32, 163, 181, 0 };
S sga3b5g[] = { 32, 163, 181, a };
S sa3b5[] = { 163, 181, 0 };
S sbacd[] = { 186, 205, 0 };
S sgc4ea[] = { 32, 196, 234, 0 };
S sGA[] = { 214, 208, 0 };
S sHf7g[] = { 215, 247, a };
S sgc6[] = { 32, 198, 0 };
S sbfg[] = { 191, a };
S sc3g[] = { 195, a };
S sc9cf[] = { 201, 207, 0 };
S sbacdg[] = { 186, 205, a };
S sgbacdg[] = { 32, 186, 205, a };
S sc3f1[] = { 195, 241, 0 };
S sb2bf[] = { 178, 191, 0 };
S sgbacd[] = { 32, 186, 205, 0 };
S sc2g[] = { 194, a };
S sgGA[] = { 32, 214, 208, 0 };
S sFfe[] = { 213, 254, 0 };
S sc8cb[] = { 200, 203, 0 };
S sbda8[] = { 189, 168, 0 };
S sga3b9[] = { 32, 163, 185, 0 };
S sa3b9g[] = { 163, 185, a };
S sb4f3[] = { 180, 243, 0 };
S sgc9cf[] = { 32, 201, 207, 0 };
S sga3b9g[] = { 32, 163, 185, a };
S sa6g[] = { 166, a };
S sa3b9[] = { 163, 185, 0 };
S sAAg[] = { 208, 208, a };
S sb5bdg[] = { 181, 189, a };
S sb3f6g[] = { 179, 246, a };
S sbdf8[] = { 189, 248, 0 };
S sgFS[] = { 32, 213, 226, 0 };
S sb3f6[] = { 179, 246, 0 };
S sb2fa[] = { 178, 250, 0 };
S sbbR[] = { 187, 225, 0 };
S sgFfe[] = { 32, 213, 254, 0 };
S sgbda8[] = { 32, 189, 168, 0 };
S sb5bd[] = { 181, 189, 0 };
S sgb9a4[] = { 32, 185, 164, 0 };
S sbefc[] = { 190, 252, 0 };
S sgb9fa[] = { 32, 185, 250, 0 };
S sc5g[] = { 197, a };
S sb7a2[] = { 183, 162, 0 };
S sa4Hf7[] = { 164, 215, 247, 0 };
S sb8f6g[] = { 184, 246, a };
S sgc8F[] = { 32, 200, 213, 0 };
S sgb0Jg[] = { 32, 176, 217, a };
S sc8F[] = { 200, 213, 0 };
S sgc4eag[] = { 32, 196, 234, a };
S sb8f6[] = { 184, 246, 0 };
S sc0b4[] = { 192, 180, 0 };
S sb6Q[] = { 182, 224, 0 };
S sb7G[] = { 183, 214, 0 };
S sb9a4g[] = { 185, 164, a };
S scab1g[] = { 202, 177, a };
S sgb0J[] = { 32, 176, 217, 0 };
S sc3c7[] = { 195, 199, 0 };
S sa4Hf7g[] = { 164, 215, 247, a };
S sc0ed[] = { 192, 237, 0 };
S sb9a4Hf7[] = { 185, 164, 215, 247, 0 };
S scab1[] = { 202, 177, 0 };
S sb9a4H[] = { 185, 164, 215, 0 };
S sCb5[] = { 210, 181, 0 };
S sa4H[] = { 164, 215, 0 };
S sc3c7g[] = { 195, 199, a };
S sgb9a4H[] = { 32, 185, 164, 215, 0 };
S sb0Jg[] = { 176, 217, a };
S sc9cfg[] = { 201, 207, a };
S sb0J[] = { 176, 217, 0 };
S sgbdf8[] = { 32, 189, 248, 0 };
S sgb6Q[] = { 32, 182, 224, 0 };
S sc3f1g[] = { 195, 241, a };
S sgceC[] = { 32, 206, 210, 0 };
S sga3b4[] = { 32, 163, 180, 0 };
S scdf2[] = { 205, 242, 0 };
S sa3a3[] = { 163, 163, 0 };
S sbeJ[] = { 190, 217, 0 };
S sgb7G[] = { 32, 183, 214, 0 };
S sga3a3g[] = { 32, 163, 163, a };
S sgc8Fg[] = { 32, 200, 213, a };
S sgcbfb[] = { 32, 203, 251, 0 };
S sgcdf2[] = { 32, 205, 242, 0 };
S sa3a3g[] = { 163, 163, a };
S sFb9[] = { 213, 185, 0 };
S sga3b6g[] = { 32, 163, 182, a };
S sgb9b2[] = { 32, 185, 178, 0 };
S sgHf7[] = { 32, 215, 247, 0 };
S sb6Qg[] = { 182, 224, a };
S sa3b4g[] = { 163, 180, a };
S sceC[] = { 206, 210, 0 };
S sc8Fg[] = { 200, 213, a };
S sa3b4[] = { 163, 180, 0 };
S sa3b6g[] = { 163, 182, a };
S sga3a3[] = { 32, 163, 163, 0 };
S sa3b6[] = { 163, 182, 0 };
S sgcdf2g[] = { 32, 205, 242, a };
S sgbeJ[] = { 32, 190, 217, 0 };
S sb5Ig[] = { 181, 216, a };
S sgb6Qg[] = { 32, 182, 224, a };
S sfeg[] = { 254, a };
S sga3b6[] = { 32, 163, 182, 0 };
S sgb5bd[] = { 32, 181, 189, 0 };
S scbfb[] = { 203, 251, 0 };
S sb9b2[] = { 185, 178, 0 };
S sc0b4g[] = { 192, 180, a };
S sgb2bf[] = { 32, 178, 191, 0 };
S sbfaa[] = { 191, 170, 0 };
S scdf2g[] = { 205, 242, a };
S sb2bb[] = { 178, 187, 0 };
S sgb5bdg[] = { 32, 181, 189, a };
S sga3b4g[] = { 32, 163, 180, a };
S sPg[] = { 223, a };
S sgc9cfg[] = { 32, 201, 207, a };
S sCb5g[] = { 210, 181, a };
S sbbfa[] = { 187, 250, 0 };
S sbcb8[] = { 188, 184, 0 };
S sgcab1[] = { 32, 202, 177, 0 };
S sccR[] = { 204, 225, 0 };
S sCbb[] = { 210, 187, 0 };
S sDK[] = { 211, 218, 0 };
S sc5a9[] = { 197, 169, 0 };
S sgbcb8[] = { 32, 188, 184, 0 };
S sf8AA[] = { 248, 208, 208, 0 };
S sCe9[] = { 210, 233, 0 };
S sb2bfg[] = { 178, 191, a };
S sgb3f6[] = { 32, 179, 246, 0 };
S sbcb8g[] = { 188, 184, a };
S sgb3f6g[] = { 32, 179, 246, a };
S sga3b8[] = { 32, 163, 184, 0 };
S sa3b8g[] = { 163, 184, a };
S sDAg[] = { 211, 208, a };
S sb3c9[] = { 179, 201, 0 };
S sFSg[] = { 213, 226, a };
S sgb9fd[] = { 32, 185, 253, 0 };
S sbead[] = { 190, 173, 0 };
S sGf7[] = { 214, 247, 0 };
S sbbb9[] = { 187, 185, 0 };
S sgb7a2[] = { 32, 183, 162, 0 };
S sgFSg[] = { 32, 213, 226, a };
S sga3b8g[] = { 32, 163, 184, a };
S sgc5a9[] = { 32, 197, 169, 0 };
S sc9fa[] = { 201, 250, 0 };
S sAa1[] = { 208, 161, 0 };
S sc1a6g[] = { 193, 166, a };
S sc8eb[] = { 200, 235, 0 };
S sceca[] = { 206, 202, 0 };
S sf8A[] = { 248, 208, 0 };
S sb5c3[] = { 181, 195, 0 };
S sc7f8[] = { 199, 248, 0 };
S sc1aa[] = { 193, 170, 0 };
S sc8ebg[] = { 200, 235, a };
S sgAc2[] = { 32, 208, 194, 0 };
S sbacf[] = { 186, 207, 0 };
S sGceg[] = { 214, 206, a };
S sgbefc[] = { 32, 190, 252, 0 };
S sc8ab[] = { 200, 171, 0 };
S sb7Gg[] = { 183, 214, a };
S sc7f8g[] = { 199, 248, a };
S sgb2fa[] = { 32, 178, 250, 0 };
S sbcca[] = { 188, 202, 0 };
S sb7bd[] = { 183, 189, 0 };
S sccS[] = { 204, 226, 0 };
S sCe9g[] = { 210, 233, a };
S sgb7Gg[] = { 32, 183, 214, a };
S sGce[] = { 214, 206, 0 };
S sc1a6[] = { 193, 166, 0 };
S sgbfaa[] = { 32, 191, 170, 0 };
S sb9fd[] = { 185, 253, 0 };
S scac2[] = { 202, 194, 0 };
S sa3b8[] = { 163, 184, 0 };
S sgbcb8g[] = { 32, 188, 184, a };
S sgb2bb[] = { 32, 178, 187, 0 };
S sgccR[] = { 32, 204, 225, 0 };
S sccSg[] = { 204, 226, a };
S sgcab1g[] = { 32, 202, 177, a };
S sAc2[] = { 208, 194, 0 };
S sgFfeG[] = { 32, 213, 254, 214, 0 };
S sEaa[] = { 212, 170, 0 };
S sb2fag[] = { 178, 250, a };
S sga1b1[] = { 32, 161, 177, 0 };
S sgDAg[] = { 32, 211, 208, a };
S sCbbg[] = { 210, 187, a };
S sa1b1[] = { 161, 177, 0 };
S sgGb0b9[] = { 32, 214, 176, 185, 0 };
S sgEaa[] = { 32, 212, 170, 0 };
S sb0b9a4[] = { 176, 185, 164, 0 };
S sga1b1g[] = { 32, 161, 177, a };
S sa3b2g[] = { 163, 178, a };
S sGAg[] = { 214, 208, a };
S sGb0b9[] = { 214, 176, 185, 0 };
S sgc1bd[] = { 32, 193, 189, 0 };
S scfIg[] = { 207, 216, a };
S sfeG[] = { 254, 214, 0 };
S sfeGce[] = { 254, 214, 206, 0 };
S sb7a8[] = { 183, 168, 0 };
S scecacc[] = { 206, 202, 204, 0 };
S scfI[] = { 207, 216, 0 };
S sCBg[] = { 210, 209, a };
S scab5[] = { 202, 181, 0 };
S sgCbb[] = { 32, 210, 187, 0 };
S sga3b2[] = { 32, 163, 178, 0 };
S sgGae[] = { 32, 214, 174, 0 };
S sc8a5[] = { 200, 165, 0 };
S sBa7g[] = { 209, 167, a };
S sgGAA[] = { 32, 214, 208, 208, 0 };
S se7bb[] = { 231, 187, 0 };
S sbcC[] = { 188, 210, 0 };
S scacc[] = { 202, 204, 0 };
S sb9b2g[] = { 185, 178, a };
S sgc8ab[] = { 32, 200, 171, 0 };
S sDc3[] = { 211, 195, 0 };
S sa3ba[] = { 163, 186, 0 };
S sgbbb9g[] = { 32, 187, 185, a };
S sc1bdg[] = { 193, 189, a };
S sCaa[] = { 210, 170, 0 };
S sb0b8[] = { 176, 184, 0 };
S sfeGceg[] = { 254, 214, 206, a };
S sc3c5[] = { 195, 197, 0 };
S sgb6Eg[] = { 32, 182, 212, a };
S sgCB[] = { 32, 210, 209, 0 };
S sb3a4[] = { 179, 164, 0 };
S sgb8f6g[] = { 32, 184, 246, a };
S sb6Eg[] = { 182, 212, a };
S sgccf5[] = { 32, 204, 245, 0 };
S sb6E[] = { 182, 212, 0 };
S sgb8f6[] = { 32, 184, 246, 0 };
S sfab9[] = { 250, 185, 0 };
S sgb4f3[] = { 32, 180, 243, 0 };
S sbef6[] = { 190, 246, 0 };
S sa3b2[] = { 163, 178, 0 };
S sgHf7g[] = { 32, 215, 247, a };

N l8n0[] = { { sAA, .497 }, H };
N l8n1[] = { { sb9fa, .538 }, { sa3a4g, .839 }, H };
N l8n2[] = { { scacc, .124 }, H };
N l8n3[] = { { sbdg, .745 }, { sb3f6, .166 }, H };
N l8n4[] = { { sgb5bd, .186 }, H };
N l8n5[] = { { sgF, .621 }, H };
N l8n6[] = { { sgc6, .228 }, { sgGA, .311 }, { sga3b9g, .373 }, { sa3b9, .186 }, { sb3c9, .104 }, { sgAc2, .155 }, H };
N l8n7[] = { { sgb7, .518 }, { sDK, .155 }, H };
N l8n8[] = { { sgb9fd, .155 }, H };
N l8n9[] = { { sf7g, .699 }, { sgbacd, .311 }, H };
N l8n10[] = { { sGg, .885 }, { sgb8f6g, .166 }, H };
N l8n11[] = { { sb5g, .870 }, { sbda8, .186 }, H };
N l8n17[] = { { sa3b4g, .280 }, { sefg, .186 }, H };
N l8n18[] = { { sceg, .652 }, { sAc2, .155 }, H };
N l8n20[] = { { sga3a3g, .248 }, { sFb9, .186 }, { sc5a9, .155 }, H };
N l8n21[] = { { sgbdf8, .186 }, H };
N l8n22[] = { { sgG, .787 }, { sc9cf, .311 }, { sccSg, .349 }, H };
N l8n23[] = { { sga3ac, 2.454 }, { sgc7, .228 }, { sgccR, .155 }, { sa3ba, .083 }, H };
N l8n24[] = { { sgb8, .393 }, H };
N l8n25[] = { { se7g, .326 }, { sb0Jg, .326 }, H };
N l8n26[] = { { sGAg, .280 }, H };
N l8n27[] = { { sgFSg, .207 }, { sa5g, .124 }, H };
N l8n30[] = { { sgc9cf, .280 }, { sb6E, .083 }, H };
N l8n31[] = { { sga3a4g, .745 }, H };
N l8n32[] = { { sa4Hf7g, .435 }, { scecacc, .186 }, H };
N l8n33[] = { { sPg, .280 }, H };
N l8n34[] = { { sa3b5g, .559 }, H };
N l8n35[] = { { sbacd, .228 }, { sa4H, .145 }, H };
N l8n36[] = { { sgcbfb, .186 }, { sgHf7g, .166 }, H };
N l8n38[] = { { sEK, .621 }, H };
N l8n39[] = { { sgH, .600 }, H };
N l8n40[] = { { sgc8, .704 }, { sf8g, .466 }, { sb2fa, .166 }, H };
N l8n41[] = { { sa3ac, 1.636 }, { sgb9, 1.015 }, { sHg, .233 }, H };
N l8n42[] = { { sb6g, .404 }, H };
N l8n44[] = { { sga1b1, .124 }, H };
N l8n45[] = { { sFSg, .349 }, { sc8a5, .124 }, H };
N l8n46[] = { { sbcca, .104 }, H };
N l8n48[] = { { sf0g, .186 }, H };
N l8n49[] = { { scfg, .745 }, H };
N l8n50[] = { { saeg, .621 }, { sfeGceg, .373 }, H };
N l8n51[] = { { sa3b6g, .280 }, { sc8ebg, .349 }, { sgDAg, .166 }, H };
N l8n52[] = { { sc0b4, .217 }, { sc3c7g, .489 }, { sb9fd, .104 }, H };
N l8n53[] = { { sgb9a4, .248 }, H };
N l8n55[] = { { scab1, .217 }, H };
N l8n56[] = { { se8g, .326 }, { sgc5a9, .155 }, H };
N l8n57[] = { { sgc9, .621 }, { sc7g, .652 }, { sgb7G, .186 }, { sb9b2, .124 }, { sCbbg, .280 }, H };
N l8n58[] = { { sc1cbg, 1.607 }, { sgba, .373 }, { sa6g, .280 }, H };
N l8n61[] = { { sb2bf, .207 }, H };
N l8n63[] = { { sbbfa, .104 }, H };
N l8n64[] = { { sQg, .419 }, { scbfb, .186 }, { sa1b1, .083 }, H };
N l8n65[] = { { sa1a2, .393 }, { sbfg, .342 }, H };
N l8n66[] = { { sgEaa, .124 }, H };
N l8n67[] = { { sga3b0, .590 }, { sb5I, .166 }, { sgb0Jg, .290 }, { sgcdf2g, .248 }, H };
N l8n68[] = { { sgbcb8, .155 }, { sAE, .155 }, H };
N l8n69[] = { { scdf2g, .419 }, { sbacf, .104 }, { sgcab1g, .207 }, { sgb4f3, .124 }, H };
N l8n70[] = { { sc4ea, .559 }, H };
N l8n71[] = { { sf9g, .233 }, { sCe9g, .349 }, H };
N l8n72[] = { { sIg, .839 }, H };
N l8n73[] = { { sb7g, .311 }, H };
N l8n74[] = { { sgca, .704 }, { sb6Qg, .280 }, H };
N l8n75[] = { { sgbb, .373 }, { sb9a4, .331 }, H };
N l8n76[] = { { sc1bdg, .280 }, H };
N l8n78[] = { { sga3b1, .590 }, H };
N l8n79[] = { { sb5c4g, 2.423 }, { sf1g, .559 }, { sgc8F, .217 }, H };
N l8n80[] = { { sAg, 1.072 }, H };
N l8n81[] = { { sgb5c4, 1.584 }, { safg, .280 }, { sGf7, .155 }, { sb7a8, .083 }, H };
N l8n82[] = { { sa1a3, .642 }, { sgEK, .528 }, { sgc4eag, .290 }, { sgbefc, .155 }, H };
N l8n85[] = { { sgb3f6, .155 }, { sa3b8g, .233 }, H };
N l8n87[] = { { se9g, .652 }, H };
N l8n88[] = { { scac2, .155 }, { sbef6, .083 }, H };
N l8n89[] = { { sa7g, .217 }, { sga3b2, .124 }, H };
N l8n91[] = { { sgcb, .476 }, { sbdf8, .166 }, H };
N l8n92[] = { { sgbc, .538 }, { sbcb8g, .233 }, { sceca, .155 }, H };
N l8n93[] = { { sc8F, .217 }, { sDA, .155 }, H };
N l8n95[] = { { sb7G, .145 }, { sRg, .233 }, H };
N l8n96[] = { { sAAg, .559 }, { sc0g, .373 }, H };
N l8n97[] = { { sb9fag, .885 }, H };
N l8n99[] = { { sb3f6g, .373 }, H };
N l8n100[] = { { sgb5bdg, .248 }, { se7bb, .124 }, H };
N l8n101[] = { { sc1a6, .155 }, H };
N l8n102[] = { { sfag, 1.305 }, { sa3b9g, .419 }, H };
N l8n103[] = { { sJg, .559 }, H };
N l8n104[] = { { sb8g, .466 }, H };
N l8n105[] = { { sgbacdg, .414 }, { scfI, .124 }, H };
N l8n106[] = { { sgc1cb, .621 }, H };
N l8n107[] = { { sbeJ, .124 }, { sbfaa, .124 }, H };
N l8n108[] = { { sgcc, .290 }, H };
N l8n109[] = { { sgbd, .787 }, { sa3b0, .393 }, { sb9a4Hf7, .290 }, H };
N l8n110[] = { { sf2g, .512 }, H };
N l8n111[] = { { sBg, .373 }, { sga3b4, .186 }, H };
N l8n112[] = { { sb0g, .839 }, { sHf7, .404 }, { sgb2fa, .155 }, H };
N l8n113[] = { { sgFfeG, .166 }, H };
N l8n114[] = { { sgb6Eg, .166 }, H };
N l8n115[] = { { sCb5, .217 }, H };
N l8n118[] = { { seag, .745 }, { sc9cfg, .489 }, { sgGAA, .166 }, H };
N l8n119[] = { { sga3acg, 3.272 }, { sc9g, .326 }, H };
N l8n120[] = { { sa8g, .280 }, { sb5bd, .166 }, H };
N l8n122[] = { { sga3b5, .373 }, H };
N l8n123[] = { { scab5, .124 }, H };
N l8n125[] = { { sgcd, .456 }, H };
N l8n126[] = { { sgbe, .538 }, { sa3b1, .393 }, { sSg, .559 }, { sgc9cfg, .248 }, { sb6Eg, .186 }, H };
N l8n127[] = { { sbead, .104 }, H };
N l8n128[] = { { sDc3, .124 }, H };
N l8n129[] = { { sgc8ab, .124 }, H };
N l8n131[] = { { sbacdg, .466 }, H };
N l8n133[] = { { sfbg, .419 }, { sga3b6, .186 }, H };
N l8n134[] = { { sKg, 1.584 }, { sEKg, 1.328 }, H };
N l8n135[] = { { sb9g, .745 }, { sga1a2, .590 }, H };
N l8n136[] = { { sb9a4H, .217 }, { sb2fag, .186 }, { sb0b8, .083 }, H };
N l8n137[] = { { sa3acg, 3.681 }, H };
N l8n140[] = { { sga1b1g, .166 }, H };
N l8n141[] = { { sf3g, .466 }, { sGb0b9, .186 }, H };
N l8n142[] = { { sgce, .683 }, { sCg, .280 }, H };
N l8n143[] = { { sb1g, 1.118 }, { sgbf, .269 }, { sfab9, .124 }, { sa3b2, .083 }, H };
N l8n144[] = { { sgb0, .559 }, { sa3a3, .124 }, { sgGae, .124 }, H };
N l8n145[] = { { sga1, 1.222 }, { sc7f8, .155 }, { sb3a4, .083 }, H };
N l8n146[] = { { sga1a3, .963 }, H };
N l8n147[] = { { sc8ab, .155 }, H };
N l8n148[] = { { sgceC, .186 }, { sc0b4g, .419 }, H };
N l8n149[] = { { sebg, .792 }, H };
N l8n150[] = { { sbbR, .166 }, { sgb6Q, .186 }, { scag, .233 }, H };
N l8n151[] = { { scab1g, .489 }, { sa9g, .186 }, H };
N l8n152[] = { { sGce, .155 }, H };
N l8n153[] = { { sgb7Gg, .207 }, { sb9b2g, .186 }, H };
N l8n155[] = { { sga3b8, .155 }, H };
N l8n157[] = { { sb2bfg, .233 }, H };
N l8n158[] = { { sc3f1, .311 }, { sc2g, .466 }, { sb8f6, .145 }, { sgbbb9g, .166 }, H };
N l8n159[] = { { sgcf, .331 }, { sa1g, .280 }, H };
N l8n160[] = { { sgc0, .331 }, H };
N l8n161[] = { { sa1a2g, .885 }, { sa3a4, .373 }, { sgb1, .373 }, H };
N l8n163[] = { { sga3b0g, .787 }, { sb5Ig, .280 }, H };
N l8n164[] = { { sfcg, .326 }, { sgbcb8g, .207 }, H };
N l8n165[] = { { sgbda8, .248 }, { sccR, .155 }, { sLg, .233 }, { sb0b9a4, .124 }, H };
N l8n166[] = { { sc4eag, .909 }, { sga3b9, .280 }, { sbag, .217 }, H };
N l8n169[] = { { sFfe, .311 }, { sc1aa, .155 }, H };
N l8n170[] = { { sgb8f6, .124 }, H };
N l8n171[] = { { sb9a4g, .326 }, H };
N l8n172[] = { { sf4g, .186 }, H };
N l8n173[] = { { sDg, .466 }, H };
N l8n174[] = { { sga3b1g, .787 }, { sb2g, .342 }, H };
N l8n175[] = { { sgc8Fg, .248 }, { sCBg, .280 }, H };
N l8n176[] = { { sgA, .393 }, H };
N l8n177[] = { { sgb5c4g, 2.112 }, { sgc1, .745 }, { sa3b4, .124 }, H };
N l8n178[] = { { sa1a3g, 1.444 }, { sgb2, .559 }, { sgEKg, .663 }, { sc3c5, .124 }, H };
N l8n179[] = { { sga3, 3.976 }, { sc8cb, .280 }, H };
N l8n180[] = { { secg, .373 }, { sga3a3, .186 }, H };
N l8n181[] = { { scbg, 1.398 }, { sgb3f6g, .207 }, H };
N l8n182[] = { { saag, .652 }, { sb7bd, .104 }, { sccS, .155 }, { sbcC, .083 }, H };
N l8n184[] = { { sCaa, .124 }, H };
N l8n185[] = { { sb0J, .145 }, H };
N l8n186[] = { { sGA, .342 }, { sgb9a4H, .290 }, H };
N l8n187[] = { { sgFS, .248 }, { sgb2bb, .155 }, H };
N l8n188[] = { { sUg, .373 }, H };
N l8n189[] = { { sc3g, .466 }, { sc8Fg, .419 }, { sDAg, .349 }, H };
N l8n190[] = { { sa2g, 1.025 }, { sbefc, .166 }, H };
N l8n191[] = { { sga3a4, .559 }, { sb9I, .124 }, { sb7Gg, .233 }, H };
N l8n192[] = { { sa4Hf7, .217 }, H };
N l8n193[] = { { sgB, .186 }, H };
N l8n194[] = { { sa3b5, .248 }, { sgc2, .145 }, H };
N l8n195[] = { { sgb3, .331 }, { sfdg, .606 }, H };
N l8n196[] = { { sgHf7, .186 }, { sMg, .280 }, H };
N l8n197[] = { { sbbg, .342 }, { sc1a6g, .349 }, H };
N l8n198[] = { { sBa7g, .280 }, H };
N l8n200[] = { { sf8AA, .233 }, H };
N l8n201[] = { { scfIg, .280 }, H };
N l8n202[] = { { sgc1cbg, .828 }, H };
N l8n203[] = { { sf5g, .466 }, H };
N l8n204[] = { { sEg, .606 }, H };
N l8n205[] = { { sa3b0g, .885 }, { sb3g, .280 }, { sFS, .248 }, { sgCB, .124 }, H };
N l8n207[] = { { sgb9b2, .186 }, { sga3b4g, .248 }, H };
N l8n208[] = { { sHf7g, .769 }, { sgc1bd, .124 }, H };
N l8n209[] = { { sgbeJ, .186 }, { sgGb0b9, .166 }, H };
N l8n210[] = { { sgC, .538 }, { sfeGce, .186 }, H };
N l8n211[] = { { sgc3, .311 }, { sa3b6, .124 }, { sCb5g, .419 }, { sedg, .233 }, { sc8eb, .155 }, H };
N l8n212[] = { { sgb4, .311 }, { sc3c7, .217 }, { sccg, .280 }, H };
N l8n213[] = { { sabg, .373 }, H };
N l8n216[] = { { sb5bdg, .373 }, { sf8A, .155 }, H };
N l8n217[] = { { sCbb, .155 }, H };
N l8n218[] = { { sc1cb, .714 }, { sga3b5g, .497 }, H };
N l8n219[] = { { sVg, .280 }, { sgCbb, .124 }, H };
N l8n220[] = { { sc4g, 2.562 }, H };
N l8n221[] = { { sa3g, 1.273 }, { sgbfaa, .155 }, H };
N l8n222[] = { { sa3b1g, .885 }, { sb5c3, .104 }, H };
N l8n225[] = { { sAa1, .155 }, H };
N l8n226[] = { { sfeg, .280 }, H };
N l8n227[] = { { sgD, .435 }, { sgb0J, .217 }, { sgcdf2, .186 }, H };
N l8n228[] = { { sgc4, .393 }, { sbcg, .373 }, { sceC, .186 }, H };
N l8n229[] = { { sgb5, 1.760 }, { scdf2, .186 }, { sga3b6g, .248 }, { sgcab1, .155 }, H };
N l8n231[] = { { sga1a2g, .787 }, { sgb9fa, .248 }, { sgb2bf, .186 }, { sCe9, .155 }, H };
N l8n234[] = { { sf6g, .978 }, { sb6Q, .145 }, H };
N l8n235[] = { { sFg, .512 }, { sb7a2, .145 }, H };
N l8n236[] = { { sb4g, .404 }, H };
N l8n238[] = { { sbbb9, .104 }, H };
N l8n239[] = { { sb5c4, 1.077 }, { sb4f3, .186 }, { sgFfe, .248 }, { sa3b2g, .186 }, H };
N l8n240[] = { { sa3a3g, .280 }, H };
N l8n241[] = { { sc9fa, .155 }, { sc7f8g, .349 }, H };
N l8n242[] = { { sga1a3g, 1.284 }, { sgc4ea, .342 }, { seeg, .280 }, H };
N l8n243[] = { { scdg, .839 }, { sgccf5, .124 }, H };
N l8n244[] = { { sacg, 2.485 }, { sgE, .642 }, H };
N l8n245[] = { { sgc5, .228 }, { sa3b8, .104 }, H };
N l8n246[] = { { sgb6, .456 }, { sgb6Qg, .248 }, { sEaa, .124 }, H };
N l8n248[] = { { sGceg, .349 }, { sfeG, .124 }, H };
N l8n249[] = { { sb2bb, .124 }, H };
N l8n251[] = { { sc5g, .373 }, { sga3b8g, .207 }, H };
N l8n252[] = { { sa4g, .870 }, { sbcb8, .104 }, H };
N l8n253[] = { { sc0ed, .217 }, { sgb7a2, .155 }, H };
N l8n254[] = { { sb8f6g, .326 }, { sc3f1g, .419 }, H };

D l8_d = {
	"chinese",
	"gb2313",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.062, 0.035, 0.196, 0.036, 0.008, 0.008, 0.008, 0.018, 0.015, 0.027, 0.017, 0.071, 0.012, 0.020, 0.012,
	    0.055, 0.055, 0.052, 0.041, 0.034, 0.117, 0.041, 0.045, 0.041, 0.093, 0.031, 0.048, 0.053, 0.065, 0.043, 0.037,
	    0.042, 0.073, 0.041, 0.062, 0.112, 0.032, 0.036, 0.048, 0.073, 0.065, 0.087, 0.087, 0.040, 0.063, 0.080, 0.072,
	    0.096, 0.039, 0.075, 0.062, 0.071, 0.081, 0.102, 0.070, 0.035, 0.025, 0.052, 0.010, 0.015, 0.005, 0.005, 0.011,
	    0.020, 0.021, 0.024, 0.007, 0.016, 0.014, 0.006, 0.016, 0.014, 0.021, 0.030, 0.024, 0.016, 0.021, 0.012, 0.011,
	    0.005, 0.025, 0.019, 0.024, 0.006, 0.016, 0.030, 0.036, 0.026, 0.012, 0.060, 0.021, 0.020, 0.026, 0.020, V },
	{ l8n0, l8n1, l8n2, l8n3, l8n4, l8n5, l8n6, l8n7, l8n8, l8n9, l8n10, l8n11, X, X, X, X,
	    X, l8n17, l8n18, X, l8n20, l8n21, l8n22, l8n23, l8n24, l8n25, l8n26, l8n27, X, X, l8n30, l8n31,
	    l8n32, l8n33, l8n34, l8n35, l8n36, X, l8n38, l8n39, l8n40, l8n41, l8n42, X, l8n44, l8n45, l8n46, X,
	    l8n48, l8n49, l8n50, l8n51, l8n52, l8n53, X, l8n55, l8n56, l8n57, l8n58, X, X, l8n61, X, l8n63,
	    l8n64, l8n65, l8n66, l8n67, l8n68, l8n69, l8n70, l8n71, l8n72, l8n73, l8n74, l8n75, l8n76, X, l8n78, l8n79,
	    l8n80, l8n81, l8n82, X, X, l8n85, X, l8n87, l8n88, l8n89, X, l8n91, l8n92, l8n93, X, l8n95,
	    l8n96, l8n97, X, l8n99, l8n100, l8n101, l8n102, l8n103, l8n104, l8n105, l8n106, l8n107, l8n108, l8n109, l8n110, l8n111,
	    l8n112, l8n113, l8n114, l8n115, X, X, l8n118, l8n119, l8n120, X, l8n122, l8n123, X, l8n125, l8n126, l8n127,
	    l8n128, l8n129, X, l8n131, X, l8n133, l8n134, l8n135, l8n136, l8n137, X, X, l8n140, l8n141, l8n142, l8n143,
	    l8n144, l8n145, l8n146, l8n147, l8n148, l8n149, l8n150, l8n151, l8n152, l8n153, X, l8n155, X, l8n157, l8n158, l8n159,
	    l8n160, l8n161, X, l8n163, l8n164, l8n165, l8n166, X, X, l8n169, l8n170, l8n171, l8n172, l8n173, l8n174, l8n175,
	    l8n176, l8n177, l8n178, l8n179, l8n180, l8n181, l8n182, X, l8n184, l8n185, l8n186, l8n187, l8n188, l8n189, l8n190, l8n191,
	    l8n192, l8n193, l8n194, l8n195, l8n196, l8n197, l8n198, X, l8n200, l8n201, l8n202, l8n203, l8n204, l8n205, X, l8n207,
	    l8n208, l8n209, l8n210, l8n211, l8n212, l8n213, X, X, l8n216, l8n217, l8n218, l8n219, l8n220, l8n221, l8n222, X,
	    X, l8n225, l8n226, l8n227, l8n228, l8n229, X, l8n231, X, X, l8n234, l8n235, l8n236, X, l8n238, l8n239,
	    l8n240, l8n241, l8n242, l8n243, l8n244, l8n245, l8n246, X, l8n248, l8n249, X, l8n251, l8n252, l8n253, l8n254, X }
};

//
// Lng: croatian
// Enc: ascii
//

S sgni[] = { 32, j, e, 0 };
S sgnig[] = { 32, j, e, a };
S smni[] = { i, j, e, 0 };
S ssz[] = { o, v, 0 };
S sZ79[] = { 99, y, 0 };
S s7a79[] = { z, y, 0 };
S sXs[] = { 97, o, 0 };
S spn[] = { l, j, 0 };
S srig[] = { n, e, a };
S sXsg[] = { 97, o, a };
S s79X[] = { y, 97, 0 };
S srsg[] = { n, o, a };
S ssn[] = { o, j, 0 };
S sXz[] = { 97, v, 0 };
S spsg[] = { l, o, a };
S sgyg[] = { 32, u, a };
S swxs[] = { s, t, o, 0 };
S sgZ79[] = { 32, 99, y, 0 };
S sxsg[] = { t, o, a };
S soXo[] = { k, 97, k, 0 };
S spni[] = { l, j, e, 0 };
S s79m[] = { y, i, 0 };
S smnig[] = { i, j, e, a };
S sg7aX[] = { 32, z, 97, 0 };
S snXg[] = { j, 97, a };
S sZn[] = { 99, j, 0 };
S swz[] = { s, v, 0 };
S smqg[] = { i, m, a };
S sqXg[] = { m, 97, a };
S smrw[] = { i, n, s, 0 };
S sgYmp[] = { 32, 98, i, l, 0 };
S skp[] = { g, l, 0 };
S swyg[] = { s, u, a };
S sgwy[] = { 32, s, u, 0 };
S sosn[] = { k, o, j, 0 };
S sgwz[] = { 32, s, v, 0 };
S srwx[] = { n, s, t, 0 };
S sgrXg[] = { 32, n, 97, a };
S swp[] = { s, l, 0 };
S sw79x[] = { s, y, t, 0 };
S smqX[] = { i, m, 97, 0 };
S spmg[] = { l, i, a };
S smrwx[] = { i, n, s, t, 0 };
S sgosn[] = { 32, k, o, j, 0 };
S s79x[] = { y, t, 0 };
S sg_mr[] = { 32, w, i, n, 0 };
S s_mr[] = { w, i, n, 0 };
S shn[] = { d, j, 0 };
S smps[] = { i, l, o, 0 };
S sgtvm[] = { 32, p, r, i, 0 };
S sgks[] = { 32, g, o, 0 };
S s7aXg[] = { z, 97, a };
S smsg[] = { i, o, a };
S srwxs[] = { n, s, t, o, 0 };
S sniw[] = { j, e, s, 0 };
S s_mrw[] = { w, i, n, s, 0 };
S sxsr[] = { t, o, n, 0 };
S stvm[] = { p, r, i, 0 };
S swxsr[] = { s, t, o, n, 0 };
S sgsw[] = { 32, o, s, 0 };
S sgwyg[] = { 32, s, u, a };
S sxr[] = { t, n, 0 };
S sxz[] = { t, v, 0 };
S szmn[] = { v, i, j, 0 };
S sqni[] = { m, j, e, 0 };
S smpsg[] = { i, l, o, a };
S swxm[] = { s, t, i, 0 };
S snir[] = { j, e, n, 0 };
S sg7a79[] = { 32, z, y, 0 };
S soXos[] = { k, 97, k, o, 0 };
S s79i[] = { y, e, 0 };
S szni[] = { v, j, e, 0 };
S sxsrg[] = { t, o, n, a };
S sqn[] = { m, j, 0 };
S szn[] = { v, j, 0 };
S szsg[] = { v, o, a };
S srni[] = { n, j, e, 0 };
S sryg[] = { n, u, a };
S sZ79X[] = { 99, y, 97, 0 };
S spy[] = { l, u, 0 };
S sswx[] = { o, s, t, 0 };
S sqyg[] = { m, u, a };
S sgoXo[] = { 32, k, 97, k, 0 };
S smlg[] = { i, h, a };
S siZn[] = { e, 99, j, 0 };
S s7aq[] = { z, m, 0 };
S sYs[] = { 98, o, 0 };
S sw79xs[] = { s, y, t, o, 0 };
S s79xs[] = { y, t, o, 0 };
S srmn[] = { n, i, j, 0 };
S snyg[] = { j, u, a };
S srsz[] = { n, o, v, 0 };
S sml[] = { i, h, 0 };
S s79xsg[] = { y, t, o, a };
S sYmps[] = { 98, i, l, o, 0 };
S snio[] = { j, e, k, 0 };
S siw79[] = { e, s, y, 0 };
S svmn[] = { r, i, j, 0 };
S sniog[] = { j, e, k, a };
S sXpsg[] = { 97, l, o, a };
S sXzX[] = { 97, v, 97, 0 };
S srmni[] = { n, i, j, e, 0 };
S srio[] = { n, e, k, 0 };
S sXhX[] = { 97, d, 97, 0 };
S s7a79X[] = { z, y, 97, 0 };
S sspn[] = { o, l, j, 0 };
S soXsg[] = { k, 97, o, a };
S snih[] = { j, e, d, 0 };
S szmni[] = { v, i, j, e, 0 };
S sw79X[] = { s, y, 97, 0 };
S spnX[] = { l, j, 97, 0 };
S sXps[] = { 97, l, o, 0 };
S sqmw[] = { m, i, s, 0 };
S sgriw[] = { 32, n, e, s, 0 };
S sghv[] = { 32, d, r, 0 };
S s79r[] = { y, n, 0 };
S ss7a[] = { o, z, 0 };
S srmq[] = { n, i, m, 0 };
S syt[] = { u, p, 0 };
S sgxsg[] = { 32, t, o, a };
S sgpm[] = { 32, l, i, 0 };
S syZ[] = { u, 99, 0 };
S sg7aXg[] = { 32, z, 97, a };
S sy7a79[] = { u, z, y, 0 };
S sgkp[] = { 32, g, l, 0 };
S syh[] = { u, d, 0 };
S sZnX[] = { 99, j, 97, 0 };
S soXs[] = { k, 97, o, 0 };
S szsv[] = { v, o, r, 0 };
S s7a79m[] = { z, y, i, 0 };
S sriw[] = { n, e, s, 0 };
S syk[] = { u, g, 0 };
S sspni[] = { o, l, j, e, 0 };
S snXsg[] = { j, 97, o, a };
S sgrio[] = { 32, n, e, k, 0 };
S sgwxX[] = { 32, s, t, 97, 0 };
S sszs[] = { o, v, o, 0 };
S snXs[] = { j, 97, o, 0 };
S stp[] = { p, l, 0 };
S sYy[] = { 98, u, 0 };
S shr[] = { d, n, 0 };
S szig[] = { v, e, a };
S sniZ[] = { j, e, 99, 0 };
S sgqyg[] = { 32, m, u, a };
S svyk[] = { r, u, g, 0 };
S stmw[] = { p, i, s, 0 };
S sgov[] = { 32, k, r, 0 };
S smqXg[] = { i, m, 97, a };
S smwt[] = { i, s, p, 0 };
S sxo[] = { t, k, 0 };
S sksh[] = { g, o, d, 0 };
S ssvm[] = { o, r, i, 0 };
S sioX[] = { e, k, 97, 0 };
S srmqg[] = { n, i, m, a };
S sxXp[] = { t, 97, l, 0 };
S svXx[] = { r, 97, t, 0 };
S soXoz[] = { k, 97, k, v, 0 };
S sXoz[] = { 97, k, v, 0 };
S sszm[] = { o, v, i, 0 };
S sixm[] = { e, t, i, 0 };
S sZig[] = { 99, e, a };
S snmg[] = { j, i, a };
S sgwp[] = { 32, s, l, 0 };
S shvy[] = { d, r, u, 0 };
S sgwg[] = { 32, s, a };
S snix[] = { j, e, t, 0 };
S sgoXs[] = { 32, k, 97, o, 0 };
S sXrs[] = { 97, n, o, 0 };
S sksz[] = { g, o, v, 0 };
S swxmg[] = { s, t, i, a };
S sgrmn[] = { 32, n, i, j, 0 };
S soz[] = { k, v, 0 };
S siw79x[] = { e, s, y, t, 0 };
S sirs[] = { e, n, o, 0 };
S sgkXg[] = { 32, g, 97, a };
S sghvy[] = { 32, d, r, u, 0 };
S stvmn[] = { p, r, i, j, 0 };
S sXhg[] = { 97, d, a };
S sgkX[] = { 32, g, 97, 0 };
S sqniw[] = { m, j, e, s, 0 };
S sniZn[] = { j, e, 99, j, 0 };
S sXpmg[] = { 97, l, i, a };
S smnX[] = { i, j, 97, 0 };
S ssni[] = { o, j, e, 0 };
S sxzs[] = { t, v, o, 0 };
S srsw[] = { n, o, s, 0 };
S spnig[] = { l, j, e, a };

N l9n0[] = { { szmni, .175 }, { svyk, .112 }, H };
N l9n1[] = { { stX, .150 }, H };
N l9n2[] = { { swig, .477 }, { syk, .087 }, H };
N l9n3[] = { { ssv, .262 }, { s7aq, .100 }, H };
N l9n4[] = { { sqXg, .365 }, { ssZ, .087 }, H };
N l9n5[] = { { sxm, .399 }, { smr, .362 }, { sgyg, .533 }, H };
N l9n6[] = { { sZ79, .362 }, { srx, .112 }, H };
N l9n7[] = { { sri, .661 }, { sZn, .175 }, H };
N l9n8[] = { { swo, .137 }, { smpsg, .337 }, { srmni, .175 }, H };
N l9n9[] = { { szsg, .252 }, H };
N l9n10[] = { { sniZn, .150 }, H };
N l9n12[] = { { sgp, .280 }, { sszs, .131 }, { snXs, .131 }, { sirm, .112 }, H };
N l9n13[] = { { sXr, .449 }, { spm, .386 }, { swg, .150 }, H };
N l9n14[] = { { ssqg, .421 }, H };
N l9n15[] = { { sghXg, .860 }, H };
N l9n16[] = { { sswx, .168 }, { sXpsg, .262 }, H };
N l9n17[] = { { srsg, .617 }, { siz, .137 }, { siw79, .150 }, H };
N l9n18[] = { { swyg, .337 }, { sik, .100 }, { sZig, .168 }, H };
N l9n20[] = { { ssw, .349 }, H };
N l9n21[] = { { sgts, .561 }, { sog, .374 }, { ssh, .212 }, { shm, .175 }, H };
N l9n22[] = { { sms, .150 }, H };
N l9n23[] = { { sry, .237 }, { sgm7a, .280 }, H };
N l9n24[] = { { smni, .598 }, { s79X, .287 }, H };
N l9n25[] = { { swp, .150 }, H };
N l9n27[] = { { szXg, .224 }, H };
N l9n28[] = { { s_mr, .187 }, { svr, .112 }, H };
N l9n29[] = { { sgq, .636 }, { sqmw, .131 }, H };
N l9n30[] = { { sXs, .312 }, { spn, .312 }, H };
N l9n31[] = { { smqX, .206 }, { ssrg, .280 }, H };
N l9n32[] = { { s79xs, .150 }, H };
N l9n33[] = { { sw79X, .131 }, { sxXp, .112 }, H };
N l9n34[] = { { stv, .374 }, H };
N l9n35[] = { { srXg, .617 }, H };
N l9n36[] = { { swxm, .168 }, { sgqy, .252 }, { snio, .150 }, { sksh, .112 }, H };
N l9n37[] = { { sg7aX, .393 }, { sxsr, .187 }, { ssx, .087 }, H };
N l9n38[] = { { sgoX, .561 }, { shn, .125 }, H };
N l9n39[] = { { sxo, .075 }, { sgwp, .168 }, H };
N l9n41[] = { { sgYmp, .449 }, H };
N l9n42[] = { { smwt, .112 }, H };
N l9n43[] = { { sspn, .131 }, { soXs, .131 }, H };
N l9n44[] = { { sqm, .199 }, { sxg, .131 }, H };
N l9n45[] = { { svs, .224 }, { sg7a79, .252 }, H };
N l9n46[] = { { sgr, 1.384 }, H };
N l9n47[] = { { sXt, .087 }, { snmg, .168 }, H };
N l9n48[] = { { sgsw, .280 }, H };
N l9n49[] = { { sZ79X, .168 }, H };
N l9n50[] = { { sZnX, .131 }, H };
N l9n54[] = { { sgtv, .757 }, H };
N l9n55[] = { { s7aX, .249 }, H };
N l9n57[] = { { sgmg, .617 }, H };
N l9n58[] = { { sgwig, .598 }, { sXog, .224 }, H };
N l9n59[] = { { svXx, .112 }, H };
N l9n60[] = { { shg, .187 }, H };
N l9n61[] = { { sqn, .112 }, { sYs, .100 }, H };
N l9n62[] = { { srwxs, .249 }, H };
N l9n63[] = { { sgs, .879 }, { svX, .436 }, { sw79xs, .199 }, H };
N l9n65[] = { { sgni, 1.599 }, H };
N l9n66[] = { { sgkXg, .224 }, H };
N l9n67[] = { { szm, .324 }, H };
N l9n69[] = { { sy7a, .150 }, { snir, .168 }, H };
N l9n71[] = { { snX, .486 }, { ssz, .362 }, H };
N l9n72[] = { { ssk, .287 }, H };
N l9n73[] = { { sghs, .309 }, { smv, .087 }, { spnX, .131 }, H };
N l9n74[] = { { smZ, .175 }, { sg_m, .280 }, { skXg, .196 }, H };
N l9n75[] = { { syg, 1.477 }, { srm, .486 }, H };
N l9n76[] = { { soXos, .224 }, { sws, .112 }, H };
N l9n78[] = { { spmZ, .150 }, { sirs, .112 }, H };
N l9n79[] = { { sYX, .075 }, H };
N l9n80[] = { { sgt, 1.234 }, H };
N l9n81[] = { { sXv, .212 }, { sgX, .299 }, H };
N l9n82[] = { { smrwx, .274 }, { s7a79m, .131 }, H };
N l9n83[] = { { sqg, .617 }, H };
N l9n84[] = { { sos, .636 }, { smqg, .365 }, { szn, .112 }, H };
N l9n85[] = { { si7a, .100 }, { svmn, .150 }, H };
N l9n86[] = { { sio, .312 }, H };
N l9n88[] = { { sqyg, .224 }, H };
N l9n89[] = { { sgrX, .449 }, { sgxs, .224 }, H };
N l9n90[] = { { smw, .374 }, { sxr, .125 }, { sspni, .175 }, { srmqg, .224 }, H };
N l9n91[] = { { sig, 2.898 }, { s79x, .137 }, { smh, .087 }, { sgkp, .196 }, H };
N l9n92[] = { { srn, .212 }, { s79i, .112 }, { siZn, .150 }, H };
N l9n93[] = { { swt, .100 }, H };
N l9n94[] = { { swX, .249 }, H };
N l9n95[] = { { szig, .196 }, H };
N l9n97[] = { { soXoz, .150 }, H };
N l9n98[] = { { sgY, .542 }, { sXw, .125 }, { s_m, .125 }, H };
N l9n99[] = { { sXh, .237 }, H };
N l9n101[] = { { sxmg, .477 }, { sgtvi, .299 }, H };
N l9n102[] = { { soX, .449 }, { swxs, .355 }, H };
N l9n103[] = { { srig, .645 }, { sip, .187 }, { sgoXo, .299 }, H };
N l9n106[] = { { sghv, .196 }, { shr, .087 }, H };
N l9n107[] = { { sxs, .511 }, { smx, .150 }, H };
N l9n108[] = { { snXsg, .262 }, H };
N l9n109[] = { { spmg, .309 }, { siw79x, .150 }, H };
N l9n110[] = { { sXpm, .150 }, H };
N l9n113[] = { { sgtvm, .374 }, H };
N l9n114[] = { { srg, .280 }, { sgv, .224 }, { sixm, .112 }, H };
N l9n115[] = { { sps, .436 }, { sgZ, .430 }, { sXx, .274 }, { sgoXs, .224 }, H };
N l9n117[] = { { spni, .280 }, { s_mrw, .249 }, H };
N l9n118[] = { { smsg, .280 }, H };
N l9n119[] = { { sryg, .252 }, H };
N l9n120[] = { { smnig, .561 }, { siq, .162 }, { sy7a79, .131 }, H };
N l9n121[] = { { stvi, .168 }, H };
N l9n122[] = { { stmw, .112 }, H };
N l9n123[] = { { ssn, .274 }, { shs, .199 }, { sYmp, .262 }, { sgtX, .168 }, H };
N l9n124[] = { { sgks, .280 }, { sniw, .187 }, H };
N l9n125[] = { { sxX, .449 }, H };
N l9n126[] = { { sXsg, .645 }, H };
N l9n127[] = { { sgwx, .477 }, { smqXg, .224 }, H };
N l9n128[] = { { s79xsg, .299 }, H };
N l9n129[] = { { sioX, .112 }, H };
N l9n131[] = { { sgw, 1.851 }, { svi, .287 }, { sgtvs, .224 }, H };
N l9n132[] = { { sgh, 1.141 }, { sniog, .299 }, { sgqyg, .224 }, { swxmg, .224 }, H };
N l9n133[] = { { sgri, .898 }, { spX, .312 }, { sxsrg, .337 }, { sg7aXg, .262 }, H };
N l9n134[] = { { ssvm, .112 }, H };
N l9n135[] = { { sov, .175 }, { snix, .112 }, H };
N l9n137[] = { { sir, .374 }, { stm, .112 }, H };
N l9n138[] = { { sgwy, .337 }, H };
N l9n139[] = { { sni, 1.895 }, { soXsg, .262 }, { ss7a, .087 }, H };
N l9n140[] = { { sso, .199 }, H };
N l9n141[] = { { shX, .586 }, { smz, .087 }, H };
N l9n142[] = { { sXhX, .131 }, H };
N l9n143[] = { { sgpm, .196 }, { szsv, .131 }, H };
N l9n144[] = { { sXrm, .131 }, H };
N l9n145[] = { { ssg, 2.786 }, H };
N l9n146[] = { { sqs, .187 }, H };
N l9n147[] = { { svy, .224 }, H };
N l9n148[] = { { sgx, .542 }, { sg_mr, .374 }, { sqni, .168 }, H };
N l9n149[] = { { sXz, .262 }, { sgwz, .337 }, H };
N l9n151[] = { { s7aXg, .280 }, H };
N l9n153[] = { { skg, .318 }, H };
N l9n155[] = { { sny, .137 }, { syt, .087 }, H };
N l9n157[] = { { ssp, .249 }, H };
N l9n158[] = { { sxv, .137 }, H };
N l9n159[] = { { sXos, .280 }, { sml, .100 }, H };
N l9n160[] = { { s79m, .187 }, { srio, .131 }, H };
N l9n161[] = { { swx, .735 }, { sgnig, 1.982 }, H };
N l9n162[] = { { swi, .262 }, { sgwxX, .262 }, { srsw, .112 }, H };
N l9n163[] = { { sYy, .087 }, H };
N l9n164[] = { { sqX, .299 }, H };
N l9n165[] = { { sgy, .654 }, { skp, .150 }, { stvm, .187 }, H };
N l9n166[] = { { sgZ79, .477 }, H };
N l9n167[] = { { snXg, .393 }, { sxzs, .112 }, H };
N l9n168[] = { { sskg, .393 }, { smps, .187 }, H };
N l9n169[] = { { szs, .362 }, H };
N l9n171[] = { { srmg, .280 }, { szni, .168 }, H };
N l9n174[] = { { ssq, .324 }, { sgwX, .309 }, { shv, .125 }, H };
N l9n175[] = { { sghX, .813 }, H };
N l9n176[] = { { swxsr, .249 }, { sXps, .131 }, H };
N l9n177[] = { { srs, .573 }, { sgrm, .421 }, { sgXg, .196 }, H };
N l9n178[] = { { swy, .175 }, { sZi, .112 }, H };
N l9n179[] = { { srni, .168 }, H };
N l9n180[] = { { sosg, .673 }, H };
N l9n181[] = { { shvy, .112 }, H };
N l9n182[] = { { sgz, .355 }, { siog, .224 }, H };
N l9n183[] = { { sgk, .524 }, H };
N l9n184[] = { { slg, .187 }, H };
N l9n185[] = { { sgrXg, .449 }, { sgxsg, .262 }, H };
N l9n186[] = { { soy, .112 }, H };
N l9n187[] = { { szX, .324 }, H };
N l9n188[] = { { stp, .087 }, H };
N l9n189[] = { { syv, .112 }, H };
N l9n190[] = { { syZ, .087 }, H };
N l9n191[] = { { ssr, .312 }, H };
N l9n192[] = { { sgos, .449 }, { sXzX, .131 }, H };
N l9n193[] = { { smn, .486 }, { sxi, .224 }, H };
N l9n195[] = { { srX, .461 }, { swz, .162 }, { srsz, .150 }, { sXhg, .168 }, H };
N l9n198[] = { { sgrio, .262 }, { soXg, .168 }, H };
N l9n199[] = { { svm, .312 }, { sg_, .187 }, { s79g, .131 }, H };
N l9n200[] = { { sYmps, .199 }, H };
N l9n201[] = { { spi, .262 }, { sXn, .150 }, { sghvy, .224 }, H };
N l9n202[] = { { sszm, .112 }, H };
N l9n203[] = { { sxsg, .449 }, { soz, .075 }, H };
N l9n204[] = { { swxX, .262 }, { sniZ, .112 }, H };
N l9n205[] = { { siv, .112 }, H };
N l9n206[] = { { siZ, .112 }, { sXpmg, .224 }, H };
N l9n207[] = { { s7a79, .337 }, { snm, .112 }, { syh, .087 }, { shmr, .112 }, H };
N l9n209[] = { { sm7a, .224 }, { szmn, .168 }, { sxy, .112 }, { shi, .087 }, H };
N l9n210[] = { { smo, .087 }, { sXrs, .112 }, { ssni, .112 }, H };
N l9n211[] = { { spsg, .561 }, H };
N l9n213[] = { { spnig, .224 }, H };
N l9n215[] = { { smg, 1.702 }, { sYm, .324 }, { snih, .131 }, H };
N l9n216[] = { { sks, .262 }, H };
N l9n217[] = { { sgm, .860 }, { spy, .112 }, { srmn, .150 }, { sX7a, .087 }, H };
N l9n218[] = { { sXo, .436 }, { sgwi, .505 }, { siwx, .168 }, H };
N l9n220[] = { { szv, .075 }, H };
N l9n221[] = { { sxXg, .252 }, H };
N l9n222[] = { { siw, .299 }, { sgriw, .262 }, H };
N l9n223[] = { { sXg, 2.805 }, { sih, .199 }, { syx, .100 }, H };
N l9n225[] = { { shy, .087 }, { sst, .087 }, { sgov, .168 }, H };
N l9n226[] = { { sosn, .224 }, { sxz, .112 }, { sgqs, .252 }, { sgkX, .168 }, H };
N l9n227[] = { { smp, .262 }, { sgwg, .168 }, { stvmn, .150 }, H };
N l9n229[] = { { sgYm, .505 }, { spXg, .280 }, H };
N l9n230[] = { { swm, .100 }, H };
N l9n231[] = { { stvs, .131 }, H };
N l9n232[] = { { sqi, .150 }, H };
N l9n234[] = { { sgn, 1.122 }, { skX, .137 }, { sgwyg, .374 }, { sksz, .112 }, H };
N l9n235[] = { { snig, 2.328 }, { sXp, .349 }, { sgxi, .252 }, H };
N l9n236[] = { { sXoz, .112 }, { smnX, .112 }, H };
N l9n237[] = { { shXg, .898 }, { sqniw, .150 }, H };
N l9n238[] = { { svg, .168 }, { som, .087 }, H };
N l9n239[] = { { sts, .362 }, { six, .249 }, { sgrmn, .224 }, H };
N l9n241[] = { { srwx, .224 }, H };
N l9n242[] = { { sw79x, .206 }, H };
N l9n243[] = { { ssY, .187 }, H };
N l9n244[] = { { smq, .337 }, H };
N l9n245[] = { { srw, .187 }, { s79r, .087 }, H };
N l9n246[] = { { sw79, .424 }, { smrw, .243 }, { sng, .187 }, { sZm, .112 }, H };
N l9n248[] = { { sqy, .137 }, { sriw, .131 }, H };
N l9n249[] = { { svXr, .206 }, H };
N l9n250[] = { { sg7a, .542 }, { s7a79X, .131 }, { srmq, .131 }, H };
N l9n251[] = { { sgo, .823 }, { snyg, .224 }, H };
N l9n252[] = { { sXq, .199 }, H };
N l9n254[] = { { sgosn, .411 }, H };
N l9n255[] = { { szi, .237 }, { soXo, .280 }, { sXosg, .449 }, { smlg, .224 }, H };

D l9_d = {
	"croatian",
	"ascii",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.208, 0.032, 0.033, 0.070, 0.181, 0.002, 0.036, 0.008, 0.167, 0.114, 0.075, 0.078, 0.068, 0.129, 0.212,
	    0.052, W, 0.080, 0.115, 0.093, 0.087, 0.066, 0.005, W, 0.045, 0.042, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l9n0, l9n1, l9n2, l9n3, l9n4, l9n5, l9n6, l9n7, l9n8, l9n9, l9n10, X, l9n12, l9n13, l9n14, l9n15,
	    l9n16, l9n17, l9n18, X, l9n20, l9n21, l9n22, l9n23, l9n24, l9n25, X, l9n27, l9n28, l9n29, l9n30, l9n31,
	    l9n32, l9n33, l9n34, l9n35, l9n36, l9n37, l9n38, l9n39, X, l9n41, l9n42, l9n43, l9n44, l9n45, l9n46, l9n47,
	    l9n48, l9n49, l9n50, X, X, X, l9n54, l9n55, X, l9n57, l9n58, l9n59, l9n60, l9n61, l9n62, l9n63,
	    X, l9n65, l9n66, l9n67, X, l9n69, X, l9n71, l9n72, l9n73, l9n74, l9n75, l9n76, X, l9n78, l9n79,
	    l9n80, l9n81, l9n82, l9n83, l9n84, l9n85, l9n86, X, l9n88, l9n89, l9n90, l9n91, l9n92, l9n93, l9n94, l9n95,
	    X, l9n97, l9n98, l9n99, X, l9n101, l9n102, l9n103, X, X, l9n106, l9n107, l9n108, l9n109, l9n110, X,
	    X, l9n113, l9n114, l9n115, X, l9n117, l9n118, l9n119, l9n120, l9n121, l9n122, l9n123, l9n124, l9n125, l9n126, l9n127,
	    l9n128, l9n129, X, l9n131, l9n132, l9n133, l9n134, l9n135, X, l9n137, l9n138, l9n139, l9n140, l9n141, l9n142, l9n143,
	    l9n144, l9n145, l9n146, l9n147, l9n148, l9n149, X, l9n151, X, l9n153, X, l9n155, X, l9n157, l9n158, l9n159,
	    l9n160, l9n161, l9n162, l9n163, l9n164, l9n165, l9n166, l9n167, l9n168, l9n169, X, l9n171, X, X, l9n174, l9n175,
	    l9n176, l9n177, l9n178, l9n179, l9n180, l9n181, l9n182, l9n183, l9n184, l9n185, l9n186, l9n187, l9n188, l9n189, l9n190, l9n191,
	    l9n192, l9n193, X, l9n195, X, X, l9n198, l9n199, l9n200, l9n201, l9n202, l9n203, l9n204, l9n205, l9n206, l9n207,
	    X, l9n209, l9n210, l9n211, X, l9n213, X, l9n215, l9n216, l9n217, l9n218, X, l9n220, l9n221, l9n222, l9n223,
	    X, l9n225, l9n226, l9n227, X, l9n229, l9n230, l9n231, l9n232, X, l9n234, l9n235, l9n236, l9n237, l9n238, l9n239,
	    X, l9n241, l9n242, l9n243, l9n244, l9n245, l9n246, X, l9n248, l9n249, l9n250, l9n251, l9n252, X, l9n254, l9n255 }
};

//
// Lng: czech
// Enc: iso-8859-2
//

S sred[] = { n, 237, 0 };
S sZl[] = { 99, h, 0 };
S sf8i[] = { 248, e, 0 };
S stf8[] = { p, 248, 0 };
S soe9[] = { k, 233, 0 };
S sgtf8[] = { 32, p, 248, 0 };
S slsg[] = { h, o, a };
S sredg[] = { n, 237, a };
S srec[] = { n, 236, 0 };
S swoe9[] = { s, k, 233, 0 };
S sgzg[] = { 32, v, a };
S sbei[] = { 190, e, 0 };
S sY79[] = { 98, y, 0 };
S sZlg[] = { 99, h, a };
S soe9g[] = { k, 233, a };
S sz79[] = { v, y, 0 };
S spR[] = { l, 225, 0 };
S szfd[] = { v, 253, 0 };
S se9ls[] = { 233, h, o, 0 };
S se9lsg[] = { 233, h, o, a };
S se9l[] = { 233, h, 0 };
S srR[] = { n, 225, 0 };
S sf8m[] = { 248, i, 0 };
S svR[] = { r, 225, 0 };
S sqec[] = { m, 236, 0 };
S stf8i[] = { p, 248, e, 0 };
S stvX[] = { p, r, 97, 0 };
S szec[] = { v, 236, 0 };
S sedq[] = { 237, m, 0 };
S sre9[] = { n, 233, 0 };
S sze9[] = { v, 233, 0 };
S sgtf8i[] = { 32, p, 248, e, 0 };
S sRx[] = { 225, t, 0 };
S sbeig[] = { 190, e, a };
S secx[] = { 236, t, 0 };
S so79[] = { k, y, 0 };
S stsh[] = { p, o, d, 0 };
S sRr[] = { 225, n, 0 };
S sre9g[] = { n, 233, a };
S swoe9g[] = { s, k, 233, a };
S sgvs[] = { 32, r, o, 0 };
S sgY79[] = { 32, 98, y, 0 };
S srecg[] = { n, 236, a };
S soyg[] = { k, u, a };
S s7aR[] = { z, 225, 0 };
S stf8m[] = { p, 248, i, 0 };
S sgz79[] = { 32, v, y, 0 };
S svXz[] = { r, 97, v, 0 };
S sedZ[] = { 237, 99, 0 };
S slp[] = { h, l, 0 };
S se8r[] = { 232, n, 0 };
S sgtf8m[] = { 32, p, 248, i, 0 };
S shec[] = { d, 236, 0 };
S sh79[] = { d, y, 0 };
S sf8ih[] = { 248, e, d, 0 };
S srswx[] = { n, o, s, t, 0 };
S sofd[] = { k, 253, 0 };
S s79p[] = { y, l, 0 };
S sgbei[] = { 32, 190, e, 0 };
S sgbeig[] = { 32, 190, e, a };
S sRz[] = { 225, v, 0 };
S stvXz[] = { p, r, 97, v, 0 };
S slsh[] = { h, o, d, 0 };
S smpg[] = { i, l, a };
S sedqg[] = { 237, m, a };
S sr79[] = { n, y, 0 };
S soe9l[] = { k, 233, h, 0 };
S s7ar[] = { z, n, 0 };
S sned[] = { j, 237, 0 };
S sfdZlg[] = { 253, 99, h, a };
S so79g[] = { k, y, a };
S sfdZl[] = { 253, 99, h, 0 };
S szR[] = { v, 225, 0 };
S soe9ls[] = { k, 233, h, o, 0 };
S sfdZ[] = { 253, 99, 0 };
S sze9g[] = { v, 233, a };
S swoe9l[] = { s, k, 233, h, 0 };
S szr[] = { v, n, 0 };
S ssze9[] = { o, v, 233, 0 };
S sb9ed[] = { 185, 237, 0 };
S sh79g[] = { d, y, a };
S sgzfd[] = { 32, v, 253, 0 };
S s7at[] = { z, p, 0 };
S szed[] = { v, 237, 0 };
S szXx[] = { v, 97, t, 0 };
S sRp[] = { 225, l, 0 };
S stf8ih[] = { p, 248, e, d, 0 };
S sZls[] = { 99, h, o, 0 };
S sgtsh[] = { 32, p, o, d, 0 };
S soh[] = { k, d, 0 };
S sgsY[] = { 32, o, 98, 0 };
S shp[] = { d, l, 0 };
S sxR[] = { t, 225, 0 };
S swts[] = { s, p, o, 0 };
S sR7a[] = { 225, z, 0 };
S stsp[] = { p, o, l, 0 };
S sY79p[] = { 98, y, l, 0 };
S slv[] = { h, r, 0 };
S sZo[] = { 99, k, 0 };
S se8i[] = { 232, e, 0 };
S shyg[] = { d, u, a };
S sx79[] = { t, y, 0 };
S sgsh[] = { 32, o, d, 0 };
S sRw[] = { 225, s, 0 };
S s7aig[] = { z, e, a };
S swsz[] = { s, o, v, 0 };
S svs7a[] = { r, o, z, 0 };
S soR[] = { k, 225, 0 };
S secp[] = { 236, l, 0 };
S sg7aR[] = { 32, z, 225, 0 };
S swsy[] = { s, o, u, 0 };
S sgrR[] = { 32, n, 225, 0 };
S sszec[] = { o, v, 236, 0 };
S sgoh[] = { 32, k, d, 0 };
S sshy[] = { o, d, u, 0 };
S swxg[] = { s, t, a };
S sgsg[] = { 32, o, a };
S sg7ag[] = { 32, z, a };
S ssvy[] = { o, r, u, 0 };
S s7aXl[] = { z, 97, h, 0 };
S szb9[] = { v, 185, 0 };
S sY79g[] = { 98, y, a };
S sszX[] = { o, v, 97, 0 };
S szecx[] = { v, 236, t, 0 };
S snr[] = { j, n, 0 };
S svXh[] = { r, 97, d, 0 };
S siwo[] = { e, s, k, 0 };
S sedls[] = { 237, h, o, 0 };
S sgY79p[] = { 32, 98, y, l, 0 };
S srfd[] = { n, 253, 0 };
S sgxXo[] = { 32, t, 97, k, 0 };
S sgZi[] = { 32, 99, e, 0 };
S srwo[] = { n, s, k, 0 };
S szred[] = { v, n, 237, 0 };
S sRq[] = { 225, m, 0 };
S sinr[] = { e, j, n, 0 };
S sxip[] = { t, e, l, 0 };
S sredq[] = { n, 237, m, 0 };
S sfdq[] = { 253, m, 0 };
S se8m[] = { 232, i, 0 };
S sRred[] = { 225, n, 237, 0 };
S sgrec[] = { 32, n, 236, 0 };
S sZed[] = { 99, 237, 0 };
S sgZl[] = { 32, 99, h, 0 };
S sedl[] = { 237, h, 0 };
S sswxg[] = { o, s, t, a };
S sx79g[] = { t, y, a };
S syn[] = { u, j, 0 };
S sg7aXl[] = { 32, z, 97, h, 0 };
S shf9[] = { d, 249, 0 };
S swps[] = { s, l, o, 0 };
S slvX[] = { h, r, 97, 0 };
S sgri7a[] = { 32, n, e, z, 0 };
S swq[] = { s, m, 0 };
S secw[] = { 236, s, 0 };
S ssbe[] = { o, 190, 0 };
S slR[] = { h, 225, 0 };
S sYyh[] = { 98, u, d, 0 };
S sszfd[] = { o, v, 253, 0 };
S ssze9g[] = { o, v, 233, a };
S sxred[] = { t, n, 237, 0 };
S sXe8[] = { 97, 232, 0 };
S sgwsy[] = { 32, s, o, u, 0 };
S spsz[] = { l, o, v, 0 };
S sxsq[] = { t, o, m, 0 };
S syY[] = { u, 98, 0 };
S sredqg[] = { n, 237, m, a };
S sYec[] = { 98, 236, 0 };
S shw[] = { d, s, 0 };
S swxv[] = { s, t, r, 0 };
S sc8i[] = { 200, e, 0 };
S sswp[] = { o, s, l, 0 };
S sedlsg[] = { 237, h, o, a };

N l10n0[] = { { sgxXo, .220 }, H };
N l10n1[] = { { sf8m, .385 }, { stX, .098 }, { swxg, .165 }, H };
N l10n2[] = { { swig, .330 }, H };
N l10n3[] = { { ssv, .220 }, H };
N l10n4[] = { { ssZ, .061 }, H };
N l10n5[] = { { sxm, .208 }, { smr, .171 }, { spR, .171 }, H };
N l10n6[] = { { srx, .122 }, H };
N l10n7[] = { { sri, .392 }, { szed, .086 }, H };
N l10n8[] = { { swo, .416 }, { stf8, .294 }, H };
N l10n9[] = { { sf8ih, .372 }, H };
N l10n10[] = { { ssvy, .110 }, { sgosr, .184 }, H };
N l10n11[] = { { swoe9, .330 }, H };
N l10n12[] = { { sgp, .239 }, H };
N l10n13[] = { { sXr, .245 }, { spm, .245 }, { swg, .294 }, { sgzi, .248 }, H };
N l10n14[] = { { sfdZlg, .661 }, { sosr, .128 }, H };
N l10n15[] = { { sred, .428 }, { ssbe, .061 }, H };
N l10n16[] = { { sswx, .220 }, H };
N l10n17[] = { { siz, .086 }, { se8m, .165 }, H };
N l10n18[] = { { sZig, .220 }, H };
N l10n20[] = { { ssw, .294 }, { s7ar, .098 }, H };
N l10n21[] = { { ssh, .441 }, { sgts, .743 }, { sog, .294 }, { shm, .110 }, { sRz, .220 }, { sx79, .086 }, H };
N l10n22[] = { { sgzg, .496 }, { sxXo, .110 }, H };
N l10n23[] = { { szfd, .171 }, { sbeig, .454 }, H };
N l10n24[] = { { sZo, .086 }, H };
N l10n25[] = { { swp, .184 }, H };
N l10n26[] = { { soyg, .275 }, { sxsq, .092 }, H };
N l10n27[] = { { szXg, .165 }, H };
N l10n28[] = { { svr, .110 }, { sshy, .110 }, H };
N l10n29[] = { { sgq, .441 }, { sZg, .092 }, H };
N l10n30[] = { { sredqg, .184 }, H };
N l10n31[] = { { se9l, .385 }, { srfd, .073 }, H };
N l10n33[] = { { sop, .086 }, H };
N l10n34[] = { { stv, .502 }, { sbeg, .275 }, { swts, .128 }, H };
N l10n35[] = { { srXg, .688 }, { sze9g, .220 }, H };
N l10n36[] = { { sb9ed, .128 }, { swxm, .110 }, { snr, .073 }, H };
N l10n37[] = { { sg7aX, .496 }, { ssx, .147 }, { sh79, .110 }, H };
N l10n38[] = { { sszfd, .092 }, H };
N l10n39[] = { { sgtf8i, .441 }, { sxo, .073 }, { sXe8, .061 }, { sgwp, .138 }, H };
N l10n40[] = { { sgc8, .128 }, H };
N l10n41[] = { { spig, .138 }, H };
N l10n42[] = { { slv, .086 }, { swq, .061 }, H };
N l10n43[] = { { sre9g, .275 }, H };
N l10n44[] = { { sxg, .477 }, { sqm, .110 }, H };
N l10n45[] = { { svs, .477 }, H };
N l10n46[] = { { sgr, 1.230 }, H };
N l10n49[] = { { sxyg, .193 }, H };
N l10n51[] = { { sgtf8m, .330 }, { soe9ls, .196 }, H };
N l10n52[] = { { spg, .477 }, H };
N l10n53[] = { { sgbeig, .294 }, { syn, .073 }, H };
N l10n54[] = { { ssy, .355 }, { sgtv, .743 }, { sfdZ, .220 }, { s7at, .086 }, H };
N l10n55[] = { { s7aX, .245 }, { sgvs, .275 }, { secw, .138 }, H };
N l10n58[] = { { sgwig, .441 }, { sXog, .165 }, H };
N l10n59[] = { { stsh, .202 }, { szR, .098 }, H };
N l10n60[] = { { shg, .165 }, H };
N l10n61[] = { { sYs, .147 }, H };
N l10n63[] = { { svX, .489 }, { sgs, .532 }, H };
N l10n65[] = { { sgni, .496 }, { sgtsh, .257 }, { shyg, .193 }, H };
N l10n67[] = { { srR, .171 }, { szm, .098 }, { slsh, .147 }, { smpg, .220 }, { swoe9l, .196 }, H };
N l10n68[] = { { se9lsg, 1.156 }, H };
N l10n69[] = { { sin, .220 }, { sZlg, .413 }, { snir, .092 }, H };
N l10n70[] = { { sedZ, .248 }, H };
N l10n71[] = { { ssz, .514 }, { sf9g, .372 }, { snX, .098 }, { sgoh, .165 }, { sY79g, .165 }, H };
N l10n72[] = { { sgws, .330 }, { secx, .303 }, { sge8, .184 }, { shp, .086 }, H };
N l10n73[] = { { sghs, .303 }, H };
N l10n74[] = { { smZ, .159 }, { ssze9, .128 }, H };
N l10n75[] = { { syg, 1.138 }, { srm, .171 }, { sXpg, .165 }, H };
N l10n76[] = { { sws, .232 }, H };
N l10n77[] = { { stvX, .239 }, H };
N l10n80[] = { { sgt, 1.725 }, { sedqg, .496 }, H };
N l10n81[] = { { sgX, .679 }, { sXv, .110 }, { svXz, .165 }, { sg7ai, .165 }, H };
N l10n82[] = { { sXZ, .110 }, { sgrec, .165 }, H };
N l10n83[] = { { sqg, .697 }, { sz79, .184 }, { swsy, .128 }, H };
N l10n84[] = { { sos, .281 }, H };
N l10n85[] = { { si7a, .184 }, { slvX, .092 }, H };
N l10n86[] = { { sio, .061 }, H };
N l10n87[] = { { se9g, 1.569 }, { slsg, .578 }, H };
N l10n89[] = { { sgrX, .716 }, { sgxs, .441 }, { sR7a, .193 }, H };
N l10n90[] = { { sxr, .159 }, { smw, .110 }, { sg7ag, .165 }, H };
N l10n91[] = { { sig, 1.248 }, { sr79, .098 }, H };
N l10n92[] = { { sZs, .098 }, H };
N l10n93[] = { { swt, .086 }, { sg7aXl, .220 }, H };
N l10n94[] = { { srecg, .275 }, { so79g, .220 }, { swsz, .128 }, { swX, .073 }, H };
N l10n95[] = { { stf8i, .239 }, { sRg, .454 }, H };
N l10n96[] = { { sedls, .248 }, H };
N l10n98[] = { { sgY, .532 }, { sXw, .159 }, H };
N l10n99[] = { { sXh, .257 }, H };
N l10n101[] = { { sxip, .110 }, H };
N l10n102[] = { { soX, .196 }, { se8r, .248 }, H };
N l10n103[] = { { sip, .159 }, H };
N l10n104[] = { { syq, .073 }, H };
N l10n106[] = { { szg, .367 }, { shr, .184 }, H };
N l10n107[] = { { sxs, .379 }, { smx, .184 }, { swoe9g, .367 }, { sRp, .193 }, { svs7a, .128 }, { sszec, .110 }, H };
N l10n110[] = { { soe9, .281 }, H };
N l10n111[] = { { sredg, .523 }, H };
N l10n112[] = { { sswxg, .220 }, H };
N l10n114[] = { { sgv, .404 }, { srg, .165 }, { sszX, .110 }, H };
N l10n115[] = { { sps, .355 }, { sXx, .294 }, { sgZ, .312 }, H };
N l10n117[] = { { sgsY, .193 }, { sx79g, .165 }, H };
N l10n119[] = { { siwo, .110 }, H };
N l10n120[] = { { siq, .147 }, H };
N l10n122[] = { { sirw, .092 }, H };
N l10n123[] = { { shs, .269 }, { s7ai, .232 }, H };
N l10n124[] = { { sRq, .165 }, H };
N l10n125[] = { { sxX, .306 }, H };
N l10n126[] = { { sgbe, .165 }, H };
N l10n127[] = { { sgwx, .303 }, H };
N l10n128[] = { { svXZ, .092 }, H };
N l10n130[] = { { svx, .061 }, H };
N l10n131[] = { { sgw, 1.450 }, { sgtvs, .514 }, { svi, .122 }, H };
N l10n132[] = { { sgh, .661 }, H };
N l10n133[] = { { spX, .294 }, { sgri, .633 }, { sh79g, .193 }, { sirx, .110 }, { spsz, .092 }, H };
N l10n135[] = { { sov, .086 }, { swxv, .092 }, H };
N l10n137[] = { { sir, .355 }, { slR, .061 }, { sxred, .092 }, H };
N l10n138[] = { { sYec, .061 }, H };
N l10n139[] = { { sni, .318 }, { ss7a, .184 }, { stf8m, .184 }, { stf8ih, .171 }, { sY79p, .128 }, { s7ay, .086 }, { sgsh, .193 }, { svXh, .110 }, H };
N l10n140[] = { { sso, .098 }, H };
N l10n141[] = { { shX, .171 }, { sRr, .275 }, { sgls, .275 }, H };
N l10n142[] = { { srwo, .110 }, H };
N l10n145[] = { { ssg, 1.487 }, H };
N l10n146[] = { { sqs, .110 }, H };
N l10n147[] = { { svy, .122 }, { sned, .098 }, { stsp, .128 }, { szb9, .073 }, { sYi, .061 }, H };
N l10n148[] = { { sgx, .514 }, H };
N l10n149[] = { { sXz, .281 }, { sgwz, .358 }, { sgY79, .275 }, { sgzfd, .193 }, H };
N l10n150[] = { { ssyg, .385 }, H };
N l10n152[] = { { szr, .086 }, H };
N l10n153[] = { { soh, .086 }, H };
N l10n155[] = { { sedl, .165 }, H };
N l10n157[] = { { ssp, .147 }, H };
N l10n158[] = { { sxv, .135 }, H };
N l10n159[] = { { sgsg, .165 }, H };
N l10n161[] = { { swx, .624 }, { sgnig, .257 }, H };
N l10n162[] = { { swi, .196 }, { srsw, .165 }, H };
N l10n163[] = { { sYy, .098 }, H };
N l10n165[] = { { sgy, .165 }, { sg7aR, .193 }, { shf9, .061 }, H };
N l10n167[] = { { sXl, .110 }, { sgwsy, .184 }, H };
N l10n169[] = { { szs, .232 }, H };
N l10n170[] = { { sZls, .128 }, { ssze9g, .184 }, H };
N l10n171[] = { { sit, .110 }, H };
N l10n173[] = { { syY, .061 }, H };
N l10n174[] = { { ssq, .135 }, { sfdZl, .330 }, H };
N l10n175[] = { { stvXz, .196 }, { s7aXl, .110 }, { sxw, .061 }, H };
N l10n177[] = { { sgXg, .661 }, { srs, .220 }, H };
N l10n178[] = { { sZi, .232 }, H };
N l10n180[] = { { secg, .867 }, H };
N l10n182[] = { { sgz, 1.230 }, H };
N l10n183[] = { { sbei, .294 }, { s7aR, .122 }, { szXx, .128 }, H };
N l10n184[] = { { slg, .275 }, { sswp, .092 }, H };
N l10n185[] = { { sgrXg, .551 }, { sgxsg, .330 }, H };
N l10n186[] = { { soy, .147 }, { sZed, .073 }, H };
N l10n187[] = { { szX, .306 }, { sr79g, .220 }, H };
N l10n188[] = { { sRred, .248 }, H };
N l10n189[] = { { sf8i, .661 }, { siY, .073 }, H };
N l10n190[] = { { sredq, .110 }, H };
N l10n191[] = { { svR, .159 }, { ssr, .122 }, { s7am, .073 }, { sgxX, .165 }, { shw, .061 }, H };
N l10n192[] = { { sgos, .275 }, { secp, .193 }, { sXzX, .110 }, { sedlsg, .413 }, H };
N l10n193[] = { { sxi, .306 }, H };
N l10n194[] = { { sofd, .098 }, H };
N l10n195[] = { { srX, .563 }, { swz, .159 }, { sze9, .147 }, { sfdg, .496 }, H };
N l10n196[] = { { slp, .110 }, H };
N l10n198[] = { { soXg, .165 }, H };
N l10n199[] = { { s79g, .918 }, { svm, .073 }, { szred, .110 }, H };
N l10n200[] = { { sgl, .257 }, { shec, .110 }, H };
N l10n201[] = { { spi, .294 }, H };
N l10n202[] = { { sXxi, .128 }, { sgZi, .165 }, H };
N l10n203[] = { { sxsg, .468 }, { sre9, .147 }, { smxg, .165 }, H };
N l10n204[] = { { swxX, .165 }, H };
N l10n205[] = { { siv, .147 }, { se8i, .193 }, H };
N l10n206[] = { { soe9g, .413 }, { siZ, .110 }, H };
N l10n207[] = { { snm, .122 }, { syh, .086 }, H };
N l10n209[] = { { sxy, .171 }, { shi, .110 }, H };
N l10n210[] = { { smo, .122 }, H };
N l10n211[] = { { sedg, 1.858 }, { spsg, .385 }, { s79p, .098 }, H };
N l10n213[] = { { sgbei, .220 }, H };
N l10n215[] = { { smg, .624 }, H };
N l10n216[] = { { siqg, .248 }, H };
N l10n217[] = { { spy, .122 }, { sX7a, .098 }, { sgrR, .193 }, { sgY79p, .220 }, H };
N l10n218[] = { { sXo, .257 }, { sgwi, .385 }, { siwx, .128 }, H };
N l10n219[] = { { s7aig, .193 }, H };
N l10n220[] = { { szv, .073 }, H };
N l10n222[] = { { siw, .232 }, { swps, .092 }, H };
N l10n223[] = { { sXg, 1.597 }, { sih, .257 }, { sqec, .159 }, { syx, .110 }, H };
N l10n224[] = { { sfdq, .165 }, H };
N l10n225[] = { { shy, .098 }, { sst, .098 }, H };
N l10n226[] = { { sxz, .098 }, { sRw, .193 }, H };
N l10n227[] = { { smp, .196 }, { sgwg, .165 }, H };
N l10n228[] = { { se9ls, .578 }, H };
N l10n229[] = { { sZl, .416 }, { spXg, .330 }, H };
N l10n230[] = { { soe9l, .147 }, { soR, .086 }, { swm, .073 }, { s7ag, .110 }, H };
N l10n231[] = { { stvs, .294 }, { sY79, .184 }, H };
N l10n232[] = { { sqi, .086 }, H };
N l10n233[] = { { sgz79, .275 }, H };
N l10n234[] = { { sgn, .606 }, H };
N l10n235[] = { { sXp, .281 }, { snig, .303 }, { sgZl, .165 }, H };
N l10n237[] = { { sc8i, .138 }, H };
N l10n238[] = { { svg, .110 }, H };
N l10n239[] = { { sts, .477 }, { six, .171 }, { sYyh, .092 }, H };
N l10n240[] = { { sedq, .330 }, H };
N l10n242[] = { { szecx, .110 }, H };
N l10n243[] = { { ssY, .220 }, { sRx, .303 }, { sgri7a, .184 }, H };
N l10n245[] = { { srw, .086 }, H };
N l10n246[] = { { szec, .159 }, { sZm, .073 }, H };
N l10n247[] = { { sls, .538 }, H };
N l10n248[] = { { sgtf8, .606 }, { sqy, .135 }, H };
N l10n249[] = { { svXr, .092 }, H };
N l10n250[] = { { sg7a, .918 }, H };
N l10n251[] = { { sgo, .532 }, H };
N l10n252[] = { { sXq, .098 }, H };
N l10n253[] = { { sxR, .086 }, H };
N l10n254[] = { { srec, .220 }, { so79, .135 }, { srswx, .196 }, H };
N l10n255[] = { { szi, .196 }, { sinr, .110 }, H };

D l10_d = {
	"czech",
	"iso-8859-2",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, 0.000,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.147, 0.035, 0.047, 0.072, 0.136, 0.005, 0.006, 0.048, 0.073, 0.036, 0.072, 0.088, 0.055, 0.122, 0.172,
	    0.071, W, 0.080, 0.102, 0.105, 0.067, 0.096, 0.001, W, 0.042, 0.053, W, W, W, 0.001, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.001, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, 0.001, Y, Y, Y, Y, Y, 0.019, Y, 0.001, Y, Y, 0.025, Y,
	    Y, V, V, V, V, V, V, V, 0.008, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, 0.001, V, V, 0.001, V, V,
	    V, 0.109, V, V, V, V, V, V, 0.042, 0.062, 0.001, V, 0.072, 0.101, V, V,
	    V, V, 0.006, 0.004, V, V, V, V, 0.057, 0.023, 0.002, V, V, 0.039, V, V },
	{ l10n0, l10n1, l10n2, l10n3, l10n4, l10n5, l10n6, l10n7, l10n8, l10n9, l10n10, l10n11, l10n12, l10n13, l10n14, l10n15,
	    l10n16, l10n17, l10n18, X, l10n20, l10n21, l10n22, l10n23, l10n24, l10n25, l10n26, l10n27, l10n28, l10n29, l10n30, l10n31,
	    X, l10n33, l10n34, l10n35, l10n36, l10n37, l10n38, l10n39, l10n40, l10n41, l10n42, l10n43, l10n44, l10n45, l10n46, X,
	    X, l10n49, X, l10n51, l10n52, l10n53, l10n54, l10n55, X, X, l10n58, l10n59, l10n60, l10n61, X, l10n63,
	    X, l10n65, X, l10n67, l10n68, l10n69, l10n70, l10n71, l10n72, l10n73, l10n74, l10n75, l10n76, l10n77, X, X,
	    l10n80, l10n81, l10n82, l10n83, l10n84, l10n85, l10n86, l10n87, X, l10n89, l10n90, l10n91, l10n92, l10n93, l10n94, l10n95,
	    l10n96, X, l10n98, l10n99, X, l10n101, l10n102, l10n103, l10n104, X, l10n106, l10n107, X, X, l10n110, l10n111,
	    l10n112, X, l10n114, l10n115, X, l10n117, X, l10n119, l10n120, X, l10n122, l10n123, l10n124, l10n125, l10n126, l10n127,
	    l10n128, X, l10n130, l10n131, l10n132, l10n133, X, l10n135, X, l10n137, l10n138, l10n139, l10n140, l10n141, l10n142, X,
	    X, l10n145, l10n146, l10n147, l10n148, l10n149, l10n150, X, l10n152, l10n153, X, l10n155, X, l10n157, l10n158, l10n159,
	    X, l10n161, l10n162, l10n163, X, l10n165, X, l10n167, X, l10n169, l10n170, l10n171, X, l10n173, l10n174, l10n175,
	    X, l10n177, l10n178, X, l10n180, X, l10n182, l10n183, l10n184, l10n185, l10n186, l10n187, l10n188, l10n189, l10n190, l10n191,
	    l10n192, l10n193, l10n194, l10n195, l10n196, X, l10n198, l10n199, l10n200, l10n201, l10n202, l10n203, l10n204, l10n205, l10n206, l10n207,
	    X, l10n209, l10n210, l10n211, X, l10n213, X, l10n215, l10n216, l10n217, l10n218, l10n219, l10n220, X, l10n222, l10n223,
	    l10n224, l10n225, l10n226, l10n227, l10n228, l10n229, l10n230, l10n231, l10n232, l10n233, l10n234, l10n235, X, l10n237, l10n238, l10n239,
	    l10n240, X, l10n242, l10n243, X, l10n245, l10n246, l10n247, l10n248, l10n249, l10n250, l10n251, l10n252, l10n253, l10n254, l10n255 }
};

//
// Lng: danish
// Enc: iso-8859-15
//

S sjs[] = { f, o, 0 };
S sjsv[] = { f, o, r, 0 };
S sgsk[] = { 32, o, g, 0 };
S sgskg[] = { 32, o, g, a };
S sgjs[] = { 32, f, o, 0 };
S sgjsv[] = { 32, f, o, r, 0 };
S sgXjg[] = { 32, 97, f, a };
S sXjg[] = { 97, f, a };
S sgXj[] = { 32, 97, f, 0 };
S shix[] = { d, e, t, 0 };
S shir[] = { d, e, n, 0 };
S sghix[] = { 32, d, e, t, 0 };
S sipwi[] = { e, l, s, e, 0 };
S shixg[] = { d, e, t, a };
S spwi[] = { l, s, e, 0 };
S sgivg[] = { 32, e, r, a };
S swiv[] = { s, e, r, 0 };
S sxmp[] = { t, i, l, 0 };
S svo[] = { r, k, 0 };
S swoi[] = { s, k, e, 0 };
S smrkg[] = { i, n, g, a };
S sgXxg[] = { 32, 97, t, a };
S sf8v[] = { 248, r, 0 };
S svmr[] = { r, i, n, 0 };
S sghiv[] = { 32, d, e, r, 0 };
S swivg[] = { s, e, r, a };
S svmwx[] = { r, i, s, t, 0 };
S sooi[] = { k, k, e, 0 };
S ssph[] = { o, l, d, 0 };
S skx[] = { g, t, 0 };
S soo[] = { k, k, 0 };
S sgxm[] = { 32, t, i, 0 };
S shirg[] = { d, e, n, a };
S sjv[] = { f, r, 0 };
S skir[] = { g, e, n, 0 };
S sghir[] = { 32, d, e, n, 0 };
S sXvo[] = { 97, r, k, 0 };
S sjsvg[] = { f, o, r, a };
S sgxmp[] = { 32, t, i, l, 0 };
S svmrk[] = { r, i, n, g, 0 };
S swoig[] = { s, k, e, a };
S swir[] = { s, e, n, 0 };
S sgXv[] = { 32, 97, r, 0 };
S spiv[] = { l, e, r, 0 };
S siri[] = { e, n, e, 0 };
S spwig[] = { l, s, e, a };
S spmk[] = { l, i, g, 0 };
S sxmpg[] = { t, i, l, a };
S sWv[] = { 230, r, 0 };
S sxx[] = { t, t, 0 };
S smooi[] = { i, k, k, e, 0 };
S sXki[] = { 97, g, e, 0 };
S sgyrh[] = { 32, u, n, d, 0 };
S sgjv[] = { 32, f, r, 0 };
S sZlvm[] = { 99, h, r, i, 0 };
S slvm[] = { h, r, i, 0 };
S srr[] = { n, n, 0 };
S sjx[] = { f, t, 0 };
S sivig[] = { e, r, e, a };
S slsp[] = { h, o, l, 0 };
S skip[] = { g, e, l, 0 };
S skw[] = { g, s, 0 };
S sZlv[] = { 99, h, r, 0 };
S sXpi[] = { 97, l, e, 0 };
S syrhi[] = { u, n, d, e, 0 };
S smoo[] = { i, k, k, 0 };
S sirwg[] = { e, n, s, a };
S smwxm[] = { i, s, t, i, 0 };
S sgixg[] = { 32, e, t, a };
S sirhi[] = { e, n, d, e, 0 };
S ssvw[] = { o, r, s, 0 };
S skirg[] = { g, e, n, a };
S svY[] = { r, 98, 0 };
S swZl[] = { s, 99, h, 0 };
S shXr[] = { d, 97, n, 0 };
S sihg[] = { e, d, a };
S srZi[] = { n, 99, e, 0 };
S ssxi[] = { o, t, e, 0 };
S sgmo[] = { 32, i, k, 0 };
S skivg[] = { g, e, r, a };
S swov[] = { s, k, r, 0 };
S sgmoo[] = { 32, i, k, k, 0 };
S sXpp[] = { 97, l, l, 0 };
S sWp[] = { 230, l, 0 };
S slvmw[] = { h, r, i, s, 0 };
S sgZlv[] = { 32, 99, h, r, 0 };
S slsph[] = { h, o, l, d, 0 };
S srri[] = { n, n, e, 0 };
S sooig[] = { k, k, e, a };
S svix[] = { r, e, t, 0 };
S swirg[] = { s, e, n, a };
S sYir[] = { 98, e, n, 0 };
S sippi[] = { e, l, l, e, 0 };
S sosrk[] = { k, o, n, g, 0 };
S sszi[] = { o, v, e, 0 };
S sriv[] = { n, e, r, 0 };
S srmrk[] = { n, i, n, g, 0 };
S sgyh[] = { 32, u, d, 0 };
S smXrg[] = { i, 97, n, a };
S siqX[] = { e, m, 97, 0 };
S szW[] = { v, 230, 0 };
S sWr[] = { 230, n, 0 };
S sgszi[] = { 32, o, v, e, 0 };
S spmki[] = { l, i, g, e, 0 };
S swxmX[] = { s, t, i, 97, 0 };
S spmrk[] = { l, i, n, g, 0 };
S srhig[] = { n, d, e, a };
S ssziv[] = { o, v, e, r, 0 };
S ssrki[] = { o, n, g, e, 0 };
S szXvg[] = { v, 97, r, a };
S svwx[] = { r, s, t, 0 };
S sxxi[] = { t, t, e, 0 };
S sgzXv[] = { 32, v, 97, r, 0 };
S swiw[] = { s, e, s, 0 };
S sgnX[] = { 32, j, 97, 0 };
S szXv[] = { v, 97, r, 0 };
S sqq[] = { m, m, 0 };
S sxivg[] = { t, e, r, a };
S sjsvw[] = { f, o, r, s, 0 };
S srkir[] = { n, g, e, n, 0 };
S smXr[] = { i, 97, n, 0 };
S sghXr[] = { 32, d, 97, n, 0 };
S ssphg[] = { o, l, d, a };
S sgsz[] = { 32, o, v, 0 };
S smwo[] = { i, s, k, 0 };
S soiv[] = { k, e, r, 0 };
S svog[] = { r, k, a };
S sxmXr[] = { t, i, 97, n, 0 };
S sxmX[] = { t, i, 97, 0 };
S sphg[] = { l, d, a };
S sXppi[] = { 97, l, l, e, 0 };
S ssrk[] = { o, n, g, 0 };
S sizi[] = { e, v, e, 0 };
S sqXvo[] = { m, 97, r, k, 0 };
S szip[] = { v, e, l, 0 };
S skipw[] = { g, e, l, s, 0 };
S sjf8[] = { f, 248, 0 };
S sviz[] = { r, e, v, 0 };
S spwiv[] = { l, s, e, r, 0 };
S swf8[] = { s, 248, 0 };
S sivr[] = { e, r, n, 0 };
S swsq[] = { s, o, m, 0 };
S svsk[] = { r, o, g, 0 };
S svrig[] = { r, n, e, a };
S sgirh[] = { 32, e, n, d, 0 };
S skr[] = { g, n, 0 };
S smrki[] = { i, n, g, e, 0 };
S sXkx[] = { 97, g, t, 0 };

N l11n1[] = { { szXvg, .238 }, { swxg, .149 }, H };
N l11n2[] = { { swig, .298 }, H };
N l11n3[] = { { ssv, .543 }, H };
N l11n4[] = { { sirhi, .185 }, H };
N l11n5[] = { { smr, .635 }, { sxm, .463 }, { srmr, .119 }, H };
N l11n6[] = { { srx, .159 }, { sZlvm, .212 }, { sgwm, .238 }, { sWp, .208 }, { slvmw, .185 }, H };
N l11n7[] = { { sri, .437 }, { sghm, .208 }, { sxivg, .238 }, H };
N l11n8[] = { { swo, .410 }, H };
N l11n9[] = { { slX, .199 }, { sxmpg, .357 }, H };
N l11n10[] = { { soig, .506 }, { sgosr, .278 }, { sYp, .093 }, H };
N l11n11[] = { { skv, .093 }, { sipp, .119 }, H };
N l11n12[] = { { sgskg, 1.033 }, { sgp, .238 }, H };
N l11n13[] = { { sXr, .556 }, { swg, .675 }, { spm, .344 }, H };
N l11n14[] = { { spwi, .338 }, { sosr, .218 }, { sjx, .106 }, { ssqg, .208 }, H };
N l11n15[] = { { sphi, .159 }, { sgst, .149 }, H };
N l11n16[] = { { soo, .146 }, H };
N l11n17[] = { { siz, .212 }, H };
N l11n18[] = { { sik, .185 }, H };
N l11n19[] = { { sgXjg, .834 }, H };
N l11n20[] = { { svmwx, .318 }, { skiv, .199 }, H };
N l11n21[] = { { sog, .318 }, { shm, .132 }, { sgnX, .179 }, H };
N l11n22[] = { { sms, .079 }, H };
N l11n23[] = { { shivg, .874 }, { sgxm, .298 }, { sxxi, .119 }, H };
N l11n24[] = { { sphg, .179 }, H };
N l11n28[] = { { sgwo, .238 }, { skw, .106 }, { svr, .093 }, H };
N l11n29[] = { { sgq, .496 }, H };
N l11n33[] = { { sxig, .298 }, { sxXp, .119 }, H };
N l11n34[] = { { stv, .119 }, H };
N l11n36[] = { { sivi, .357 }, { swxm, .278 }, H };
N l11n37[] = { { sghir, .397 }, { ssx, .106 }, H };
N l11n40[] = { { smX, .106 }, { sWr, .179 }, H };
N l11n41[] = { { srk, .556 }, { spig, .238 }, H };
N l11n42[] = { { slv, .132 }, H };
N l11n43[] = { { skipw, .132 }, H };
N l11n44[] = { { sxg, 1.847 }, { sqm, .106 }, { ssrk, .119 }, H };
N l11n45[] = { { sivg, 2.353 }, { shixg, .675 }, { svs, .146 }, { skx, .146 }, H };
N l11n46[] = { { ski, .675 }, { sgr, .139 }, H };
N l11n48[] = { { sxmX, .119 }, H };
N l11n49[] = { { shig, .923 }, { sghiv, .477 }, H };
N l11n52[] = { { spg, .238 }, H };
N l11n54[] = { { sgtv, .208 }, { sghmi, .199 }, H };
N l11n55[] = { { sghix, .675 }, { sgXv, .298 }, { sgzXv, .238 }, H };
N l11n57[] = { { sgmg, .566 }, { sgzm, .208 }, H };
N l11n58[] = { { sippi, .159 }, { srmrk, .159 }, H };
N l11n59[] = { { sghig, .516 }, H };
N l11n60[] = { { shg, .496 }, { srZi, .139 }, H };
N l11n61[] = { { svir, .218 }, H };
N l11n62[] = { { siwg, .328 }, H };
N l11n63[] = { { sgs, .874 }, { svX, .212 }, { sihg, .208 }, H };
N l11n64[] = { { spp, .265 }, H };
N l11n65[] = { { sgZlv, .278 }, H };
N l11n66[] = { { sXpi, .159 }, { smXrg, .238 }, H };
N l11n67[] = { { szm, .146 }, { smpg, .298 }, { sosrk, .159 }, H };
N l11n69[] = { { smkig, .278 }, { sti, .079 }, H };
N l11n71[] = { { shXr, .139 }, { ssz, .093 }, { snX, .079 }, { swxmX, .159 }, H };
N l11n72[] = { { ssk, .490 }, { sgqX, .298 }, { skirg, .278 }, { sgYv, .208 }, { sgws, .179 }, H };
N l11n73[] = { { ssphg, .238 }, { svog, .179 }, { smv, .066 }, H };
N l11n75[] = { { srm, .132 }, H };
N l11n76[] = { { sws, .119 }, H };
N l11n77[] = { { srhi, .397 }, { sgXx, .357 }, { sli, .106 }, { sYir, .119 }, H };
N l11n79[] = { { sixg, 1.400 }, { sgir, .536 }, H };
N l11n80[] = { { sgt, .397 }, { sivm, .218 }, { svY, .093 }, H };
N l11n81[] = { { sgX, 1.251 }, { sXv, .556 }, { smrh, .139 }, { sgsz, .179 }, H };
N l11n83[] = { { sqg, .298 }, { sjm, .066 }, H };
N l11n84[] = { { sos, .278 }, H };
N l11n85[] = { { srwg, .238 }, H };
N l11n86[] = { { smwx, .278 }, { sio, .119 }, { srhg, .238 }, H };
N l11n88[] = { { sipw, .377 }, H };
N l11n90[] = { { smw, .371 }, H };
N l11n91[] = { { sig, 2.800 }, { smh, .225 }, { sgxmp, .397 }, { ssrki, .159 }, H };
N l11n92[] = { { swir, .199 }, H };
N l11n94[] = { { swX, .106 }, H };
N l11n95[] = { { swoi, .258 }, { sgyr, .268 }, H };
N l11n98[] = { { sgY, .516 }, H };
N l11n99[] = { { ssvg, .357 }, H };
N l11n100[] = { { spwiv, .132 }, H };
N l11n101[] = { { sxip, .139 }, { smrg, .208 }, { swf8, .066 }, H };
N l11n102[] = { { soX, .106 }, { swxs, .159 }, H };
N l11n103[] = { { sip, .622 }, { sooi, .218 }, { srig, .328 }, H };
N l11n104[] = { { sizi, .119 }, { syq, .066 }, H };
N l11n106[] = { { szg, .159 }, H };
N l11n107[] = { { sgjs, .745 }, { sxs, .159 }, { smoo, .159 }, H };
N l11n108[] = { { smi, .159 }, { sWv, .268 }, { shmi, .099 }, H };
N l11n109[] = { { sXrg, .387 }, { svwx, .119 }, H };
N l11n110[] = { { spwig, .357 }, H };
N l11n112[] = { { sYv, .159 }, { sqq, .079 }, H };
N l11n113[] = { { svw, .278 }, H };
N l11n114[] = { { srg, 1.469 }, { smrk, .477 }, { svh, .119 }, { sgv, .139 }, { sgmo, .208 }, H };
N l11n115[] = { { sXx, .304 }, { sgZ, .199 }, H };
N l11n116[] = { { sgqi, .208 }, { skivg, .278 }, H };
N l11n117[] = { { ship, .159 }, H };
N l11n120[] = { { siq, .199 }, H };
N l11n121[] = { { syr, .304 }, { sYiv, .119 }, H };
N l11n122[] = { { sjg, .457 }, { sirw, .218 }, { spmk, .179 }, { sxmXr, .159 }, H };
N l11n123[] = { { sgiv, .477 }, { sxir, .119 }, { sgirh, .199 }, H };
N l11n124[] = { { ssxi, .139 }, H };
N l11n125[] = { { sxX, .199 }, H };
N l11n127[] = { { sgwx, .298 }, { svix, .139 }, H };
N l11n128[] = { { srki, .377 }, { swZ, .106 }, { sgszi, .238 }, H };
N l11n129[] = { { svmr, .238 }, H };
N l11n130[] = { { svx, .212 }, H };
N l11n131[] = { { svi, .821 }, { sgw, 1.033 }, H };
N l11n132[] = { { sgh, 1.589 }, { sivig, .318 }, H };
N l11n133[] = { { sXj, .331 }, { spX, .159 }, { sirx, .159 }, H };
N l11n135[] = { { sipwi, .450 }, { sov, .146 }, { sivr, .099 }, H };
N l11n136[] = { { swiv, .298 }, H };
N l11n137[] = { { sir, 1.390 }, { srkg, .417 }, H };
N l11n138[] = { { sqXv, .139 }, H };
N l11n139[] = { { shir, .357 }, { sgyrh, .318 }, H };
N l11n140[] = { { sgjv, .238 }, H };
N l11n141[] = { { shX, .159 }, { smz, .079 }, H };
N l11n142[] = { { smk, .225 }, { skig, .477 }, H };
N l11n143[] = { { sXpp, .139 }, H };
N l11n144[] = { { szW, .079 }, { soiv, .119 }, H };
N l11n145[] = { { sgix, .238 }, { smwxm, .212 }, H };
N l11n146[] = { { sXkx, .099 }, H };
N l11n147[] = { { sYi, .357 }, { sgmr, .208 }, { swiw, .119 }, { svy, .079 }, H };
N l11n148[] = { { sgx, .635 }, H };
N l11n149[] = { { sgi, 1.052 }, { sXz, .106 }, { sviz, .099 }, H };
N l11n150[] = { { sXk, .238 }, H };
N l11n151[] = { { sppi, .298 }, H };
N l11n153[] = { { skg, .973 }, H };
N l11n154[] = { { sf8v, .357 }, { smooi, .212 }, { svsk, .099 }, H };
N l11n155[] = { { slsp, .159 }, H };
N l11n157[] = { { ssp, .225 }, H };
N l11n158[] = { { sxv, .146 }, { sszi, .119 }, H };
N l11n159[] = { { sjsv, .556 }, H };
N l11n160[] = { { srr, .106 }, H };
N l11n161[] = { { swx, .649 }, { szXv, .119 }, { smrki, .132 }, H };
N l11n162[] = { { swi, .635 }, { sqir, .119 }, H };
N l11n163[] = { { srhiv, .238 }, { siqX, .119 }, { szip, .099 }, H };
N l11n164[] = { { sqX, .331 }, H };
N l11n165[] = { { sgy, .318 }, H };
N l11n166[] = { { sgj, .973 }, H };
N l11n167[] = { { sxiv, .258 }, H };
N l11n168[] = { { sskg, .923 }, H };
N l11n169[] = { { sxmp, .298 }, { sox, .093 }, { spmki, .159 }, { szs, .066 }, H };
N l11n170[] = { { soi, .410 }, H };
N l11n172[] = { { sgsk, .804 }, H };
N l11n173[] = { { sgXxg, .477 }, { slvm, .159 }, { srhig, .238 }, H };
N l11n174[] = { { ssq, .212 }, H };
N l11n175[] = { { spiv, .199 }, { sgirg, .318 }, { sghX, .238 }, { sxw, .093 }, H };
N l11n177[] = { { sXvg, .238 }, { srs, .066 }, H };
N l11n178[] = { { sZi, .146 }, { smhi, .179 }, H };
N l11n179[] = { { sgXj, .625 }, { sgmoo, .278 }, H };
N l11n182[] = { { sgz, .496 }, { svmrk, .265 }, { sgw79, .149 }, H };
N l11n183[] = { { shiv, .635 }, { spw, .278 }, { sgk, .179 }, H };
N l11n184[] = { { sph, .291 }, { svmw, .278 }, H };
N l11n185[] = { { sjs, .424 }, { sgYi, .208 }, H };
N l11n187[] = { { szX, .119 }, H };
N l11n188[] = { { swirg, .238 }, H };
N l11n189[] = { { siY, .119 }, H };
N l11n190[] = { { sivw, .218 }, { sXppi, .159 }, H };
N l11n191[] = { { ssr, .238 }, { swoig, .397 }, { shw, .093 }, H };
N l11n192[] = { { sgos, .506 }, { sxx, .106 }, H };
N l11n193[] = { { sxi, .715 }, { sgjsv, .913 }, H };
N l11n195[] = { { srX, .066 }, H };
N l11n197[] = { { syrh, .258 }, H };
N l11n199[] = { { svm, .530 }, { sg_, .199 }, { spmr, .159 }, { slsph, .185 }, { sooig, .278 }, { skr, .066 }, H };
N l11n200[] = { { sgl, .298 }, H };
N l11n201[] = { { spi, .582 }, { sgvi, .149 }, H };
N l11n202[] = { { srkir, .159 }, H };
N l11n203[] = { { sZlv, .159 }, { sqXvo, .159 }, { sjX, .066 }, H };
N l11n204[] = { { smig, .179 }, { shmig, .199 }, H };
N l11n205[] = { { siv, 1.827 }, { shix, .377 }, H };
N l11n206[] = { { syw, .093 }, H };
N l11n207[] = { { syh, .093 }, H };
N l11n209[] = { { shi, 1.575 }, H };
N l11n210[] = { { smo, .212 }, { smrkg, .516 }, { skip, .159 }, { sjf8, .066 }, H };
N l11n211[] = { { sXxg, .357 }, { svrig, .199 }, H };
N l11n212[] = { { sXvm, .099 }, H };
N l11n213[] = { { sirh, .218 }, H };
N l11n215[] = { { smg, .457 }, { sYm, .079 }, H };
N l11n217[] = { { sgm, .715 }, H };
N l11n218[] = { { sirwg, .318 }, { siwx, .119 }, H };
N l11n219[] = { { sghi, 1.817 }, { sgivg, .596 }, { sVg, .268 }, H };
N l11n222[] = { { siw, .357 }, H };
N l11n223[] = { { sih, .185 }, H };
N l11n224[] = { { siri, .179 }, H };
N l11n225[] = { { sst, .172 }, { sgzX, .208 }, H };
N l11n226[] = { { smXr, .119 }, H };
N l11n227[] = { { smp, .291 }, { svig, .625 }, H };
N l11n229[] = { { sXjg, .625 }, { sZl, .252 }, { smki, .218 }, { srZ, .106 }, { sziv, .139 }, H };
N l11n230[] = { { swm, .146 }, H };
N l11n232[] = { { sqi, .238 }, { swivg, .477 }, { skir, .199 }, H };
N l11n233[] = { { sirg, 1.400 }, { svo, .172 }, { ssph, .218 }, H };
N l11n234[] = { { sgn, .199 }, { sXvo, .199 }, { sipm, .099 }, H };
N l11n235[] = { { sXp, .318 }, { shirg, .397 }, { sgZl, .208 }, { sgxi, .208 }, H };
N l11n236[] = { { sjv, .132 }, H };
N l11n237[] = { { sXki, .159 }, { sriv, .119 }, H };
N l11n238[] = { { svg, 2.125 }, { som, .119 }, { swov, .139 }, H };
N l11n239[] = { { six, .755 }, H };
N l11n241[] = { { sgixg, .318 }, { sgyh, .179 }, H };
N l11n243[] = { { smwo, .119 }, H };
N l11n244[] = { { syrhi, .212 }, { ssvw, .139 }, { ssziv, .159 }, H };
N l11n245[] = { { srw, .278 }, H };
N l11n246[] = { { srh, .503 }, { sw79, .079 }, H };
N l11n247[] = { { sls, .132 }, { srri, .139 }, H };
N l11n248[] = { { swxi, .199 }, { swZl, .139 }, { sqy, .079 }, { sjsvw, .159 }, H };
N l11n249[] = { { sghXr, .238 }, H };
N l11n251[] = { { sgo, .755 }, { swsq, .099 }, H };
N l11n252[] = { { sXq, .185 }, { spmrk, .159 }, H };
N l11n255[] = { { szi, .304 }, { sjsvg, .397 }, H };

D l11_d = {
	"danish",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.001, W, W, W, W, W, W, W, 0.001,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.116, 0.038, 0.019, 0.108, 0.330, 0.055, 0.083, 0.032, 0.120, 0.012, 0.073, 0.102, 0.053, 0.154, 0.097,
	    0.023, W, 0.181, 0.124, 0.138, 0.033, 0.037, 0.008, 0.003, 0.011, 0.002, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, 0.002, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.002, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.002, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, 0.004, 0.017, 0.042, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, 0.001, V, 0.041, V, V, V, 0.001, V, V, V },
	{ X, l11n1, l11n2, l11n3, l11n4, l11n5, l11n6, l11n7, l11n8, l11n9, l11n10, l11n11, l11n12, l11n13, l11n14, l11n15,
	    l11n16, l11n17, l11n18, l11n19, l11n20, l11n21, l11n22, l11n23, l11n24, X, X, X, l11n28, l11n29, X, X,
	    X, l11n33, l11n34, X, l11n36, l11n37, X, X, l11n40, l11n41, l11n42, l11n43, l11n44, l11n45, l11n46, X,
	    l11n48, l11n49, X, X, l11n52, X, l11n54, l11n55, X, l11n57, l11n58, l11n59, l11n60, l11n61, l11n62, l11n63,
	    l11n64, l11n65, l11n66, l11n67, X, l11n69, X, l11n71, l11n72, l11n73, X, l11n75, l11n76, l11n77, X, l11n79,
	    l11n80, l11n81, X, l11n83, l11n84, l11n85, l11n86, X, l11n88, X, l11n90, l11n91, l11n92, X, l11n94, l11n95,
	    X, X, l11n98, l11n99, l11n100, l11n101, l11n102, l11n103, l11n104, X, l11n106, l11n107, l11n108, l11n109, l11n110, X,
	    l11n112, l11n113, l11n114, l11n115, l11n116, l11n117, X, X, l11n120, l11n121, l11n122, l11n123, l11n124, l11n125, X, l11n127,
	    l11n128, l11n129, l11n130, l11n131, l11n132, l11n133, X, l11n135, l11n136, l11n137, l11n138, l11n139, l11n140, l11n141, l11n142, l11n143,
	    l11n144, l11n145, l11n146, l11n147, l11n148, l11n149, l11n150, l11n151, X, l11n153, l11n154, l11n155, X, l11n157, l11n158, l11n159,
	    l11n160, l11n161, l11n162, l11n163, l11n164, l11n165, l11n166, l11n167, l11n168, l11n169, l11n170, X, l11n172, l11n173, l11n174, l11n175,
	    X, l11n177, l11n178, l11n179, X, X, l11n182, l11n183, l11n184, l11n185, X, l11n187, l11n188, l11n189, l11n190, l11n191,
	    l11n192, l11n193, X, l11n195, X, l11n197, X, l11n199, l11n200, l11n201, l11n202, l11n203, l11n204, l11n205, l11n206, l11n207,
	    X, l11n209, l11n210, l11n211, l11n212, l11n213, X, l11n215, X, l11n217, l11n218, l11n219, X, X, l11n222, l11n223,
	    l11n224, l11n225, l11n226, l11n227, X, l11n229, l11n230, X, l11n232, l11n233, l11n234, l11n235, l11n236, l11n237, l11n238, l11n239,
	    X, l11n241, X, l11n243, l11n244, l11n245, l11n246, l11n247, l11n248, l11n249, X, l11n251, l11n252, X, X, l11n255 }
};

//
// Lng: dutch
// Enc: iso-8859-15
//

S swxy[] = { s, t, u, 0 };
S sg7am[] = { 32, z, i, 0 };
S swxyh[] = { s, t, u, d, 0 };
S sgwxy[] = { 32, s, t, u, 0 };
S sxyh[] = { t, u, d, 0 };
S syhi[] = { u, d, e, 0 };
S sgii[] = { 32, e, e, 0 };
S syhir[] = { u, d, e, n, 0 };
S siirg[] = { e, e, n, a };
S sgiir[] = { 32, e, e, n, 0 };
S s7amn[] = { z, i, j, 0 };
S smnr[] = { i, j, n, 0 };
S sg7amn[] = { 32, z, i, j, 0 };
S sxyhi[] = { t, u, d, e, 0 };
S snrg[] = { j, n, a };
S smnrg[] = { i, j, n, a };
S s7amnr[] = { z, i, j, n, 0 };
S szss[] = { v, o, o, 0 };
S sirxi[] = { e, n, t, e, 0 };
S spmn[] = { l, i, j, 0 };
S smno[] = { i, j, k, 0 };
S szssv[] = { v, o, o, r, 0 };
S sgzss[] = { 32, v, o, o, 0 };
S sno[] = { j, k, 0 };
S shirx[] = { d, e, n, t, 0 };
S s7as[] = { z, o, 0 };
S spmno[] = { l, i, j, k, 0 };
S svhi[] = { r, d, e, 0 };
S sssvg[] = { o, o, r, a };
S s2727[] = { 39, 39, 0 };
S smix[] = { i, e, t, 0 };
S smZl[] = { i, 99, h, 0 };
S s27g[] = { 39, a };
S sg7as[] = { 32, z, o, 0 };
S srmix[] = { n, i, e, t, 0 };
S srxir[] = { n, t, e, n, 0 };
S smixg[] = { i, e, t, a };
S siki[] = { e, g, e, 0 };
S sipi[] = { e, l, e, 0 };
S sipmn[] = { e, l, i, j, 0 };
S sizir[] = { e, v, e, n, 0 };
S smnh[] = { i, j, d, 0 };
S ssrh[] = { o, n, d, 0 };
S skvs[] = { g, r, o, 0 };
S spirg[] = { l, e, n, a };
S szir[] = { v, e, n, 0 };
S sg7aig[] = { 32, z, e, a };
S siivh[] = { e, e, r, d, 0 };
S soir[] = { k, e, n, 0 };
S sg2727[] = { 32, 39, 39, 0 };
S smng[] = { i, j, a };
S sihi[] = { e, d, e, 0 };
S sxmn[] = { t, i, j, 0 };
S snh[] = { j, d, 0 };
S svhir[] = { r, d, e, n, 0 };
S shXX[] = { d, 97, 97, 0 };
S syhmi[] = { u, d, i, e, 0 };
S ssyh[] = { o, u, d, 0 };
S smri[] = { i, n, e, 0 };
S smzi[] = { i, v, e, 0 };
S ssyhi[] = { o, u, d, e, 0 };
S sXrr[] = { 97, n, n, 0 };
S sxmnh[] = { t, i, j, d, 0 };
S sivhg[] = { e, r, d, a };
S sgly[] = { 32, h, u, 0 };
S sivo[] = { e, r, k, 0 };
S sxyhm[] = { t, u, d, i, 0 };
S syhm[] = { u, d, i, 0 };
S sZlx[] = { 99, h, t, 0 };
S sij[] = { e, f, 0 };
S sww[] = { s, s, 0 };
S sgsso[] = { 32, o, o, k, 0 };
S szirg[] = { v, e, n, a };
S sxsx[] = { t, o, t, 0 };
S szsp[] = { v, o, l, 0 };
S sxmi[] = { t, i, e, 0 };
S ssso[] = { o, o, k, 0 };
S skipm[] = { g, e, l, i, 0 };
S sgxsx[] = { 32, t, o, t, 0 };
S sg7amZ[] = { 32, z, i, 99, 0 };
S sgliY[] = { 32, h, e, 98, 0 };
S sqmr[] = { m, i, n, 0 };
S sjxg[] = { f, t, a };
S szivw[] = { v, e, r, s, 0 };
S s7amZl[] = { z, i, 99, h, 0 };
S smziv[] = { i, v, e, r, 0 };
S sgkvs[] = { 32, g, r, o, 0 };
S s7amZ[] = { z, i, 99, 0 };
S sXrxg[] = { 97, n, t, a };
S ssxg[] = { o, t, a };
S ssog[] = { o, k, a };
S soxg[] = { k, t, a };
S srmw[] = { n, i, s, 0 };

N l12n0[] = { { siy, .194 }, { s7amZ, .109 }, H };
N l12n1[] = { { stX, .182 }, { sij, .085 }, H };
N l12n2[] = { { swig, .218 }, { siivh, .194 }, H };
N l12n3[] = { { ssv, .387 }, H };
N l12n5[] = { { smr, .847 }, { sxm, .266 }, { srmr, .145 }, H };
N l12n6[] = { { srx, .375 }, H };
N l12n7[] = { { sri, .218 }, { sghm, .272 }, H };
N l12n9[] = { { sXrx, .127 }, { slX, .073 }, { soxg, .163 }, H };
N l12n10[] = { { siirg, .617 }, H };
N l12n11[] = { { sghXx, .545 }, { skv, .121 }, { ssrh, .145 }, H };
N l12n12[] = { { sgp, .290 }, H };
N l12n13[] = { { sXr, .980 }, { swg, .781 }, { spm, .278 }, { sgzi, .545 }, { smnh, .145 }, { skipm, .145 }, H };
N l12n14[] = { { sgki, .681 }, { sjx, .085 }, H };
N l12n15[] = { { sgst, .354 }, H };
N l12n17[] = { { siz, .109 }, H };
N l12n18[] = { { sik, .206 }, H };
N l12n19[] = { { svhir, .169 }, H };
N l12n21[] = { { shm, .327 }, { sog, .418 }, H };
N l12n22[] = { { sXXv, .436 }, { sssvg, .399 }, H };
N l12n23[] = { { shivg, .327 }, H };
N l12n25[] = { { sivh, .236 }, { szirg, .218 }, H };
N l12n29[] = { { sgq, .672 }, { sxyh, .399 }, H };
N l12n30[] = { { s_i, .242 }, { sg_i, .245 }, H };
N l12n31[] = { { sgli, .953 }, { skiw, .127 }, H };
N l12n32[] = { { symx, .163 }, H };
N l12n33[] = { { sxig, .436 }, { smng, .218 }, H };
N l12n34[] = { { ssix, .127 }, H };
N l12n36[] = { { sym, .218 }, { snr, .194 }, { sivi, .163 }, { sg2727, .218 }, H };
N l12n37[] = { { ssx, .157 }, { s7as, .133 }, H };
N l12n38[] = { { syhi, .399 }, { ssi, .242 }, H };
N l12n40[] = { { sipmn, .218 }, H };
N l12n41[] = { { srk, .424 }, H };
N l12n43[] = { { sgzXr, 1.017 }, H };
N l12n44[] = { { sxg, 2.397 }, { sqm, .109 }, H };
N l12n45[] = { { sivg, 1.008 }, { svs, .218 }, H };
N l12n46[] = { { ski, .896 }, { sgr, .309 }, H };
N l12n48[] = { { sXX, .617 }, H };
N l12n49[] = { { shig, 1.389 }, H };
N l12n52[] = { { spg, .309 }, { sim, .157 }, H };
N l12n54[] = { { sgiir, .617 }, { ssy, .121 }, { sghmi, .290 }, { sihi, .145 }, H };
N l12n56[] = { { s7amZl, .145 }, H };
N l12n58[] = { { srmrk, .194 }, { smziv, .145 }, H };
N l12n59[] = { { sghig, 1.452 }, H };
N l12n60[] = { { shg, .545 }, { srmw, .109 }, H };
N l12n61[] = { { svir, .145 }, H };
N l12n62[] = { { szivw, .145 }, H };
N l12n63[] = { { sgs, .726 }, { svX, .242 }, H };
N l12n64[] = { { spp, .145 }, H };
N l12n65[] = { { sgni, .300 }, { sstg, .300 }, H };
N l12n68[] = { { sqixg, .290 }, H };
N l12n69[] = { { sZlg, .218 }, { sti, .097 }, { sgsso, .218 }, { sqsix, .145 }, { sgliY, .218 }, H };
N l12n71[] = { { snX, .073 }, H };
N l12n72[] = { { skirg, .654 }, { ssk, .097 }, { sgqX, .218 }, H };
N l12n73[] = { { slix, .454 }, { sghs, .218 }, H };
N l12n74[] = { { smZ, .145 }, { sXXrg, .436 }, H };
N l12n75[] = { { srm, .399 }, { sgxig, .254 }, H };
N l12n76[] = { { sxyhi, .363 }, { slx, .085 }, H };
N l12n77[] = { { sli, .496 }, { s7amn, .290 }, { srhi, .290 }, { szsp, .109 }, H };
N l12n79[] = { { sixg, 1.362 }, { sgir, .517 }, { sYX, .109 }, { ssvh, .127 }, H };
N l12n80[] = { { sgt, .236 }, { s2727, .133 }, { sivm, .127 }, H };
N l12n81[] = { { sgX, .672 }, { sXv, .436 }, { sg7ai, .381 }, { smrh, .109 }, H };
N l12n82[] = { { syhm, .127 }, H };
N l12n83[] = { { sqg, .182 }, H };
N l12n84[] = { { sos, .085 }, H };
N l12n85[] = { { svmn, .145 }, { si7a, .085 }, H };
N l12n86[] = { { sio, .182 }, { srhg, .218 }, H };
N l12n88[] = { { sxyhm, .169 }, H };
N l12n89[] = { { sgxs, .218 }, { sXrh, .127 }, H };
N l12n90[] = { { smw, .266 }, { smno, .218 }, H };
N l12n91[] = { { sig, 2.487 }, { smh, .085 }, H };
N l12n92[] = { { smri, .127 }, { sxmi, .109 }, H };
N l12n93[] = { { srxi, .290 }, { sly, .109 }, { swt, .073 }, H };
N l12n98[] = { { sgY, .726 }, { sXw, .109 }, { s_m, .097 }, H };
N l12n99[] = { { sgziv, .654 }, { ssvg, .300 }, { sXh, .133 }, { sgpi, .245 }, H };
N l12n100[] = { { soir, .145 }, H };
N l12n101[] = { { smrg, .381 }, { sxip, .127 }, H };
N l12n102[] = { { srxg, .272 }, { soX, .085 }, { sivo, .127 }, H };
N l12n103[] = { { sip, .520 }, { sxsx, .109 }, H };
N l12n104[] = { { smix, .182 }, { sizi, .145 }, H };
N l12n105[] = { { siki, .163 }, { ssso, .109 }, { sXrxg, .218 }, H };
N l12n107[] = { { smx, .254 }, { sxs, .133 }, H };
N l12n108[] = { { smi, .605 }, { shmi, .272 }, H };
N l12n109[] = { { sXrg, 1.280 }, H };
N l12n110[] = { { szss, .218 }, { sjxg, .163 }, H };
N l12n111[] = { { sgstg, .290 }, H };
N l12n112[] = { { syhir, .436 }, H };
N l12n113[] = { { svw, .194 }, H };
N l12n114[] = { { srg, 3.994 }, { smrk, .490 }, { svh, .278 }, { sgv, .145 }, H };
N l12n115[] = { { sXx, .448 }, { sps, .073 }, H };
N l12n116[] = { { sgqi, .300 }, H };
N l12n117[] = { { szXr, .545 }, H };
N l12n118[] = { { sXXvg, .508 }, H };
N l12n119[] = { { sg27, .236 }, H };
N l12n120[] = { { siq, .121 }, H };
N l12n121[] = { { syr, .169 }, { sYiv, .127 }, { sivhg, .254 }, H };
N l12n122[] = { { snh, .097 }, { sjg, .127 }, { sirw, .109 }, H };
N l12n123[] = { { s7ai, .327 }, { sglix, .908 }, { sgzs, .572 }, { sxir, .327 }, { smnr, .290 }, { shs, .109 }, { sgiv, .218 }, { sgtX, .191 }, H };
N l12n124[] = { { sgXX, .245 }, H };
N l12n125[] = { { sg7am, .681 }, { sxX, .145 }, H };
N l12n127[] = { { sgwx, .708 }, H };
N l12n128[] = { { srki, .290 }, { swZ, .157 }, { simh, .109 }, H };
N l12n129[] = { { syhmi, .169 }, { svmr, .127 }, H };
N l12n130[] = { { svx, .145 }, { ssyh, .127 }, H };
N l12n131[] = { { sgw, .672 }, { svi, .351 }, { spir, .182 }, H };
N l12n132[] = { { sgh, 1.688 }, { snrg, .381 }, { sgymx, .218 }, H };
N l12n133[] = { { sirx, .290 }, { spX, .157 }, { ssxg, .163 }, H };
N l12n135[] = { { sov, .109 }, H };
N l12n137[] = { { sir, 2.191 }, { shXx, .327 }, { srkg, .408 }, H };
N l12n139[] = { { shir, .635 }, { sni, .182 }, H };
N l12n140[] = { { sso, .085 }, H };
N l12n141[] = { { shX, .363 }, { smz, .085 }, { sgYX, .163 }, H };
N l12n142[] = { { smk, .109 }, H };
N l12n144[] = { { soiv, .145 }, { sww, .085 }, H };
N l12n146[] = { { sqs, .157 }, H };
N l12n147[] = { { sYi, .436 }, { sgmr, .681 }, { sxmn, .145 }, H };
N l12n148[] = { { sgx, .490 }, H };
N l12n149[] = { { sgi, .980 }, H };
N l12n150[] = { { sXk, .133 }, H };
N l12n151[] = { { s7amnr, .339 }, { sppi, .145 }, H };
N l12n153[] = { { skg, .563 }, H };
N l12n155[] = { { spmn, .218 }, H };
N l12n157[] = { { ssp, .133 }, H };
N l12n158[] = { { sxv, .109 }, H };
N l12n160[] = { { srr, .109 }, { sgqm, .163 }, H };
N l12n161[] = { { swx, .654 }, { smrki, .290 }, { sgnig, .399 }, H };
N l12n162[] = { { swi, .218 }, { srmi, .236 }, { sqir, .127 }, H };
N l12n163[] = { { srhiv, .242 }, H };
N l12n164[] = { { sqX, .169 }, H };
N l12n165[] = { { sgy, .218 }, H };
N l12n166[] = { { sg7amZ, .218 }, H };
N l12n167[] = { { sxiv, .200 }, { srxir, .218 }, H };
N l12n168[] = { { swxy, .472 }, H };
N l12n169[] = { { szs, .315 }, { slixg, .871 }, { sox, .085 }, H };
N l12n170[] = { { soi, .278 }, { siir, .327 }, H };
N l12n171[] = { { sit, .121 }, H };
N l12n173[] = { { sioi, .182 }, H };
N l12n174[] = { { ssq, .145 }, H };
N l12n175[] = { { sghX, .654 }, { sgirg, .690 }, { sxw, .097 }, H };
N l12n176[] = { { stg, .272 }, H };
N l12n177[] = { { sXvg, .381 }, { sgrm, .272 }, { srs, .097 }, { sg7aig, .290 }, { ssyhi, .169 }, H };
N l12n178[] = { { sizir, .194 }, H };
N l12n180[] = { { sirxi, .290 }, H };
N l12n181[] = { { sgxsx, .218 }, H };
N l12n182[] = { { sgz, 1.398 }, { sssv, .327 }, H };
N l12n183[] = { { sgk, .635 }, { shiv, .309 }, H };
N l12n184[] = { { slg, .145 }, { shXX, .127 }, { sph, .085 }, H };
N l12n185[] = { { sgYi, .681 }, { szir, .145 }, H };
N l12n186[] = { { smwg, .245 }, H };
N l12n187[] = { { szX, .399 }, { sg7amn, .581 }, H };
N l12n189[] = { { siY, .109 }, { syv, .109 }, H };
N l12n190[] = { { sivw, .200 }, { sipi, .163 }, H };
N l12n191[] = { { s7am, .303 }, { ssr, .290 }, { sg7as, .245 }, { sxmnh, .169 }, { shw, .073 }, H };
N l12n193[] = { { sxi, .775 }, { smn, .678 }, H };
N l12n194[] = { { smZl, .182 }, H };
N l12n195[] = { { srX, .109 }, H };
N l12n196[] = { { szssv, .290 }, H };
N l12n198[] = { { sgXXr, .254 }, H };
N l12n199[] = { { svm, .327 }, { sg_, .472 }, { sipg, .272 }, { sXrr, .127 }, H };
N l12n200[] = { { sgl, .926 }, { sgzss, .436 }, { smixg, .327 }, { s_s, .073 }, H };
N l12n201[] = { { spi, .436 }, { svhi, .200 }, H };
N l12n202[] = { { srkir, .218 }, { sgmw, .163 }, H };
N l12n203[] = { { smxg, .218 }, H };
N l12n204[] = { { smig, .436 }, { shmig, .363 }, H };
N l12n205[] = { { siv, 1.416 }, H };
N l12n206[] = { { syw, .097 }, H };
N l12n207[] = { { syh, .351 }, { sgly, .191 }, H };
N l12n208[] = { { sss, .387 }, { skvs, .145 }, { sgqix, .290 }, H };
N l12n209[] = { { shi, 1.477 }, { sxy, .339 }, H };
N l12n210[] = { { skip, .254 }, { smrkg, .399 }, { smo, .097 }, { svhg, .191 }, H };
N l12n211[] = { { sXxg, .681 }, H };
N l12n212[] = { { swxyh, .533 }, H };
N l12n213[] = { { szXrg, 1.053 }, { sirh, .145 }, H };
N l12n214[] = { { siiv, .309 }, H };
N l12n215[] = { { sYm, .097 }, H };
N l12n217[] = { { sgm, .690 }, { s27g, .182 }, H };
N l12n218[] = { { s_X, .145 }, { siwx, .182 }, H };
N l12n219[] = { { sghi, 1.307 }, { sxirg, .545 }, { smnrg, .508 }, { s7aig, .354 }, H };
N l12n220[] = { { spmno, .266 }, H };
N l12n222[] = { { siw, .278 }, { sgwxy, .799 }, H };
N l12n223[] = { { sih, .242 }, H };
N l12n224[] = { { sgrmi, .363 }, H };
N l12n225[] = { { sgzX, .844 }, { sst, .254 }, { sZlx, .127 }, { sgov, .163 }, H };
N l12n226[] = { { sgqs, .300 }, H };
N l12n227[] = { { spirg, .290 }, H };
N l12n228[] = { { sqix, .145 }, { smzi, .127 }, H };
N l12n229[] = { { sziv, .527 }, { sZl, .290 }, H };
N l12n230[] = { { swm, .085 }, { sqmr, .109 }, H };
N l12n231[] = { { shirx, .266 }, H };
N l12n232[] = { { skir, .436 }, { sqi, .242 }, H };
N l12n233[] = { { sirg, 3.704 }, { shXxg, .654 }, { svo, .109 }, H };
N l12n234[] = { { sgn, .309 }, { sXXr, .254 }, { sipm, .163 }, { skX, .085 }, { sgkvs, .218 }, H };
N l12n235[] = { { sXp, .303 }, { shirg, .763 }, { snig, .354 }, { sgxi, .327 }, H };
N l12n236[] = { { sgii, .517 }, { ssog, .163 }, H };
N l12n238[] = { { svg, 1.216 }, H };
N l12n239[] = { { six, .811 }, H };
N l12n240[] = { { sii, .581 }, H };
N l12n241[] = { { sno, .145 }, H };
N l12n242[] = { { sg_X, .191 }, H };
N l12n243[] = { { sgmrg, .472 }, H };
N l12n245[] = { { srw, .169 }, { sgXp, .354 }, { sxvi, .109 }, H };
N l12n246[] = { { srh, .363 }, { sng, .145 }, { smrw, .127 }, H };
N l12n247[] = { { sls, .157 }, { srri, .127 }, H };
N l12n248[] = { { swxi, .254 }, { swZl, .200 }, H };
N l12n249[] = { { sgsr, .163 }, H };
N l12n250[] = { { sg7a, .908 }, H };
N l12n251[] = { { sgo, .527 }, H };
N l12n254[] = { { srmix, .218 }, H };
N l12n255[] = { { szi, .484 }, H };

D l12_d = {
	"dutch",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.015, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.142, 0.034, 0.018, 0.117, 0.372, 0.011, 0.067, 0.045, 0.137, 0.038, 0.046, 0.066, 0.037, 0.206, 0.104,
	    0.029, W, 0.124, 0.081, 0.146, 0.050, 0.053, 0.024, 0.002, 0.000, 0.031, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    0.001, V, V, V, V, V, V, V, V, 0.002, V, 0.001, V, V, V, 0.002,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l12n0, l12n1, l12n2, l12n3, X, l12n5, l12n6, l12n7, X, l12n9, l12n10, l12n11, l12n12, l12n13, l12n14, l12n15,
	    X, l12n17, l12n18, l12n19, X, l12n21, l12n22, l12n23, X, l12n25, X, X, X, l12n29, l12n30, l12n31,
	    l12n32, l12n33, l12n34, X, l12n36, l12n37, l12n38, X, l12n40, l12n41, X, l12n43, l12n44, l12n45, l12n46, X,
	    l12n48, l12n49, X, X, l12n52, X, l12n54, X, l12n56, X, l12n58, l12n59, l12n60, l12n61, l12n62, l12n63,
	    l12n64, l12n65, X, X, l12n68, l12n69, X, l12n71, l12n72, l12n73, l12n74, l12n75, l12n76, l12n77, X, l12n79,
	    l12n80, l12n81, l12n82, l12n83, l12n84, l12n85, l12n86, X, l12n88, l12n89, l12n90, l12n91, l12n92, l12n93, X, X,
	    X, X, l12n98, l12n99, l12n100, l12n101, l12n102, l12n103, l12n104, l12n105, X, l12n107, l12n108, l12n109, l12n110, l12n111,
	    l12n112, l12n113, l12n114, l12n115, l12n116, l12n117, l12n118, l12n119, l12n120, l12n121, l12n122, l12n123, l12n124, l12n125, X, l12n127,
	    l12n128, l12n129, l12n130, l12n131, l12n132, l12n133, X, l12n135, X, l12n137, X, l12n139, l12n140, l12n141, l12n142, X,
	    l12n144, X, l12n146, l12n147, l12n148, l12n149, l12n150, l12n151, X, l12n153, X, l12n155, X, l12n157, l12n158, X,
	    l12n160, l12n161, l12n162, l12n163, l12n164, l12n165, l12n166, l12n167, l12n168, l12n169, l12n170, l12n171, X, l12n173, l12n174, l12n175,
	    l12n176, l12n177, l12n178, X, l12n180, l12n181, l12n182, l12n183, l12n184, l12n185, l12n186, l12n187, X, l12n189, l12n190, l12n191,
	    X, l12n193, l12n194, l12n195, l12n196, X, l12n198, l12n199, l12n200, l12n201, l12n202, l12n203, l12n204, l12n205, l12n206, l12n207,
	    l12n208, l12n209, l12n210, l12n211, l12n212, l12n213, l12n214, l12n215, X, l12n217, l12n218, l12n219, l12n220, X, l12n222, l12n223,
	    l12n224, l12n225, l12n226, l12n227, l12n228, l12n229, l12n230, l12n231, l12n232, l12n233, l12n234, l12n235, l12n236, X, l12n238, l12n239,
	    l12n240, l12n241, l12n242, l12n243, X, l12n245, l12n246, l12n247, l12n248, l12n249, l12n250, l12n251, X, X, l12n254, l12n255 }
};

//
// Lng: english
// Enc: iso-8859-15
//

S sxli[] = { t, h, e, 0 };
S sgxli[] = { 32, t, h, e, 0 };
S sxlig[] = { t, h, e, a };
S ssjg[] = { o, f, a };
S ssj[] = { o, f, 0 };
S sgsj[] = { 32, o, f, 0 };
S sgsjg[] = { 32, o, f, a };
S sgXr[] = { 32, 97, n, 0 };
S sgXrh[] = { 32, 97, n, d, 0 };
S smsrg[] = { i, o, n, a };
S sxms[] = { t, i, o, 0 };
S sxmsr[] = { t, i, o, n, 0 };
S sxwg[] = { t, s, a };
S s_l[] = { w, h, 0 };
S sg_l[] = { 32, w, h, 0 };
S slXx[] = { h, 97, t, 0 };
S stXvx[] = { p, 97, r, t, 0 };
S srj[] = { n, f, 0 };
S sgmx[] = { 32, i, t, 0 };
S siww[] = { e, s, s, 0 };
S sgY79g[] = { 32, 98, y, a };
S sliv[] = { h, e, r, 0 };
S sxlm[] = { t, h, i, 0 };
S smiwg[] = { i, e, s, a };
S sgXwg[] = { 32, 97, s, a };
S sXxms[] = { 97, t, i, o, 0 };
S sYig[] = { 98, e, a };
S sgmxg[] = { 32, i, t, a };
S slXxg[] = { h, 97, t, a };
S slivg[] = { h, e, r, a };
S swmsr[] = { s, i, o, n, 0 };
S sjp[] = { f, l, 0 };
S siXw[] = { e, 97, s, 0 };
S svrq[] = { r, n, m, 0 };
S sgYig[] = { 32, 98, e, a };
S srxwg[] = { n, t, s, a };
S srqir[] = { n, m, e, n, 0 };
S sxlXx[] = { t, h, 97, t, 0 };
S sglXz[] = { 32, h, 97, v, 0 };
S srqi[] = { n, m, e, 0 };
S sivrq[] = { e, r, n, m, 0 };
S sgksz[] = { 32, g, o, v, 0 };
S szivr[] = { v, e, r, n, 0 };
S slXz[] = { h, 97, v, 0 };
S svrqi[] = { r, n, m, e, 0 };
S slmZ[] = { h, i, 99, 0 };
S srq[] = { n, m, 0 };
S srxw[] = { n, t, s, 0 };
S swms[] = { s, i, o, 0 };
S sZxm[] = { 99, t, i, 0 };
S skszi[] = { g, o, v, e, 0 };
S smx79g[] = { i, t, y, a };
S sgmrx[] = { 32, i, n, t, 0 };
S sxih[] = { t, e, d, 0 };
S smpp[] = { i, l, l, 0 };
S sgtXv[] = { 32, p, 97, r, 0 };
S sxmiw[] = { t, i, e, s, 0 };
S syir[] = { u, e, n, 0 };
S sXzi[] = { 97, v, e, 0 };
S swihg[] = { s, e, d, a };
S srjp[] = { n, f, l, 0 };
S smx79[] = { i, t, y, 0 };
S s_lm[] = { w, h, i, 0 };
S slXzi[] = { h, 97, v, e, 0 };
S sgyrm[] = { 32, u, n, i, 0 };
S sZxms[] = { 99, t, i, o, 0 };
S sp79g[] = { l, y, a };
S sXzig[] = { 97, v, e, a };
S swih[] = { s, e, d, 0 };
S sp79[] = { l, y, 0 };
S sg_lm[] = { 32, w, h, i, 0 };
S sxihg[] = { t, e, d, a };
S syrm[] = { u, n, i, 0 };
S smZx[] = { i, 99, t, 0 };
S smsrw[] = { i, o, n, s, 0 };
S smrj[] = { i, n, f, 0 };
S sqYi[] = { m, 98, e, 0 };
S sxlmw[] = { t, h, i, s, 0 };
S s_iv[] = { w, e, r, 0 };
S slimv[] = { h, e, i, r, 0 };
S sxlim[] = { t, h, e, i, 0 };
S syxm[] = { u, t, i, 0 };
S sxliv[] = { t, h, e, r, 0 };
S sZmi[] = { 99, i, e, 0 };
S sg_mp[] = { 32, w, i, l, 0 };
S swwi[] = { s, s, e, 0 };
S slmw[] = { h, i, s, 0 };
S srZig[] = { n, 99, e, a };
S slim[] = { h, e, i, 0 };
S slmwg[] = { h, i, s, a };
S smrZ[] = { i, n, 99, 0 };
S smZlg[] = { i, 99, h, a };
S slmZl[] = { h, i, 99, h, 0 };
S srms[] = { n, i, o, 0 };
S sgxlm[] = { 32, t, h, i, 0 };
S syrms[] = { u, n, i, o, 0 };
S sviXw[] = { r, e, 97, s, 0 };
S sgsrg[] = { 32, o, n, a };
S simvg[] = { e, i, r, a };
S s_mp[] = { w, i, l, 0 };
S s_mpp[] = { w, i, l, l, 0 };
S sqYiv[] = { m, 98, e, r, 0 };
S sgrXx[] = { 32, n, 97, t, 0 };
S skvi[] = { g, r, e, 0 };
S ssyw[] = { o, u, s, 0 };
S smrjp[] = { i, n, f, l, 0 };
S srmsr[] = { n, i, o, n, 0 };
S simv[] = { e, i, r, 0 };
S sgmrj[] = { 32, i, n, f, 0 };
S sXYp[] = { 97, 98, l, 0 };
S svii[] = { r, e, e, 0 };
S sqiq[] = { m, e, m, 0 };
S sgsv[] = { 32, o, r, 0 };
S smppg[] = { i, l, l, a };
S s_lmZ[] = { w, h, i, 99, 0 };
S swwm[] = { s, s, i, 0 };
S syvi[] = { u, r, e, 0 };

N l13n1[] = { { sgsjg, 1.767 }, { stX, .223 }, { swxg, .287 }, { smrx, .143 }, H };
N l13n2[] = { { swig, .322 }, H };
N l13n3[] = { { ssv, .366 }, H };
N l13n4[] = { { s_iv, .119 }, H };
N l13n5[] = { { smr, .923 }, { sxm, .653 }, { slXx, .239 }, H };
N l13n6[] = { { srx, .541 }, { s_mp, .119 }, H };
N l13n7[] = { { sri, .191 }, { sghm, .179 }, { sviXw, .159 }, H };
N l13n9[] = { { slX, .382 }, H };
N l13n10[] = { { sYp, .127 }, { slmZl, .159 }, H };
N l13n11[] = { { sgXr, 1.039 }, { skv, .096 }, { sZsq, .119 }, H };
N l13n12[] = { { sgxl, 3.152 }, { sgp, .191 }, { sqYi, .119 }, H };
N l13n13[] = { { swg, 2.244 }, { sXr, .716 }, { spm, .207 }, { sxih, .143 }, H };
N l13n15[] = { { sxwg, .501 }, { sji, .111 }, H };
N l13n16[] = { { ssrwg, .382 }, { srms, .119 }, H };
N l13n17[] = { { siz, .080 }, H };
N l13n18[] = { { sZig, .287 }, { sik, .080 }, H };
N l13n19[] = { { swwm, .119 }, H };
N l13n20[] = { { sxmsr, .573 }, { ssw, .111 }, { syvi, .119 }, H };
N l13n21[] = { { sx79, .287 }, { shm, .191 }, H };
N l13n22[] = { { sms, .557 }, { sZsr, .191 }, H };
N l13n24[] = { { srj, .159 }, H };
N l13n25[] = { { sgYig, .334 }, { skszi, .223 }, H };
N l13n26[] = { { simv, .119 }, H };
N l13n27[] = { { slXz, .167 }, H };
N l13n28[] = { { svr, .127 }, H };
N l13n29[] = { { sgq, .573 }, { sp79, .096 }, H };
N l13n30[] = { { s_i, .191 }, { sg_i, .322 }, { sivwg, .239 }, H };
N l13n31[] = { { ssrg, 1.074 }, { sxlX, .191 }, { sgli, .179 }, H };
N l13n34[] = { { stv, .255 }, { smZlg, .239 }, H };
N l13n36[] = { { sivi, .239 }, { swxm, .119 }, H };
N l13n37[] = { { ssx, .111 }, { sgsv, .179 }, H };
N l13n38[] = { { slimv, .159 }, H };
N l13n39[] = { { ssyw, .119 }, H };
N l13n40[] = { { smX, .096 }, H };
N l13n41[] = { { srk, .271 }, { spig, .287 }, { smsrw, .191 }, H };
N l13n42[] = { { sgmwg, .287 }, H };
N l13n43[] = { { stiv, .167 }, H };
N l13n44[] = { { sxg, 1.242 }, { sqm, .080 }, H };
N l13n45[] = { { sivg, .788 }, { svs, .239 }, H };
N l13n46[] = { { sgr, .287 }, { ski, .080 }, H };
N l13n47[] = { { sgxlX, .382 }, { szivr, .223 }, H };
N l13n48[] = { { smsrg, 1.146 }, { srqir, .223 }, H };
N l13n51[] = { { sliv, .215 }, { si78, .096 }, H };
N l13n52[] = { { spg, .358 }, { sim, .127 }, { sZxm, .167 }, H };
N l13n53[] = { { sgmxg, .382 }, H };
N l13n54[] = { { ssy, .255 }, { sgtv, .394 }, H };
N l13n55[] = { { ssj, .589 }, { sgXrh, 1.289 }, H };
N l13n56[] = { { sgZs, .537 }, H };
N l13n59[] = { { sgxli, 3.486 }, H };
N l13n60[] = { { shg, 1.504 }, { srZi, .143 }, H };
N l13n62[] = { { siwg, .752 }, H };
N l13n63[] = { { sgs, 1.337 }, { sihg, .931 }, { svX, .255 }, { sg_l, .394 }, H };
N l13n64[] = { { spp, .159 }, H };
N l13n65[] = { { sXY, .143 }, H };
N l13n66[] = { { sgXw, .322 }, H };
N l13n67[] = { { stXvx, .318 }, { sXxms, .255 }, { szm, .096 }, H };
N l13n69[] = { { sti, .255 }, { sZlg, .251 }, H };
N l13n70[] = { { smZx, .143 }, { smrZ, .119 }, H };
N l13n71[] = { { ssz, .159 }, { sY79g, .322 }, { sgxlm, .239 }, H };
N l13n72[] = { { sgqX, .322 }, { sqig, .215 }, H };
N l13n73[] = { { smv, .127 }, { syrms, .159 }, H };
N l13n74[] = { { smZ, .350 }, { sg_m, .322 }, { slXzi, .191 }, { s_mpp, .159 }, H };
N l13n75[] = { { sxli, 1.886 }, { srm, .143 }, { sXpg, .251 }, H };
N l13n76[] = { { sws, .111 }, { sXzig, .287 }, H };
N l13n77[] = { { sli, 1.433 }, { sXvx, .263 }, { sgXx, .287 }, { srhi, .119 }, { sZmi, .119 }, H };
N l13n78[] = { { swihg, .287 }, { spmZ, .119 }, H };
N l13n80[] = { { sgt, .740 }, H };
N l13n81[] = { { sgX, 2.053 }, { sXv, .414 }, { s_l, .175 }, H };
N l13n82[] = { { sXZ, .207 }, H };
N l13n85[] = { { srwg, .537 }, { sglXz, .334 }, H };
N l13n86[] = { { srhg, 1.003 }, H };
N l13n87[] = { { srxwg, .334 }, H };
N l13n89[] = { { sXrh, .669 }, { sgxs, .752 }, { sgrX, .179 }, { sgsrg, .239 }, H };
N l13n90[] = { { smw, .366 }, { srmsr, .159 }, H };
N l13n91[] = { { sig, 3.438 }, H };
N l13n92[] = { { sZs, .255 }, { sxmi, .143 }, H };
N l13n93[] = { { smiw, .215 }, { swt, .096 }, H };
N l13n94[] = { { swX, .080 }, H };
N l13n95[] = { { szig, .466 }, { sgyr, .322 }, H };
N l13n97[] = { { svZ, .080 }, H };
N l13n98[] = { { sgY, .549 }, { sXw, .271 }, { s_m, .143 }, { syxm, .119 }, { sqYiv, .159 }, { skvi, .119 }, H };
N l13n99[] = { { sXh, .191 }, { sgpi, .251 }, { ssvg, .215 }, H };
N l13n101[] = { { smrg, .645 }, { slXxg, .382 }, H };
N l13n102[] = { { srxg, .430 }, H };
N l13n103[] = { { sip, .080 }, { smrj, .119 }, H };
N l13n104[] = { { smix, .119 }, { sizi, .119 }, H };
N l13n107[] = { { smx, .446 }, { sxs, .366 }, { sgjs, .251 }, H };
N l13n108[] = { { smi, .318 }, H };
N l13n109[] = { { sxihg, .287 }, H };
N l13n113[] = { { svw, .159 }, H };
N l13n114[] = { { srg, 1.385 }, { sgv, .358 }, { smrk, .287 }, { skm, .080 }, H };
N l13n115[] = { { sXx, .557 }, { sgZ, .525 }, H };
N l13n116[] = { { sviw, .263 }, { sgqi, .251 }, { suy, .080 }, H };
N l13n117[] = { { sx79g, .466 }, H };
N l13n119[] = { { sxlm, .215 }, H };
N l13n120[] = { { siq, .207 }, H };
N l13n121[] = { { syr, .207 }, { sYiv, .143 }, H };
N l13n122[] = { { sjg, .907 }, { sirw, .167 }, { sg_lm, .287 }, { simvg, .239 }, H };
N l13n123[] = { { sgtX, .322 }, { sxlXx, .223 }, H };
N l13n124[] = { { sgks, .287 }, H };
N l13n125[] = { { sxX, .191 }, { sp79g, .215 }, H };
N l13n129[] = { { sZxms, .191 }, H };
N l13n130[] = { { svx, .223 }, { sgZsr, .382 }, { slmw, .119 }, H };
N l13n131[] = { { svi, .860 }, { sgw, .573 }, { sgtvs, .382 }, H };
N l13n132[] = { { sgh, .501 }, H };
N l13n133[] = { { sirx, .549 }, H };
N l13n134[] = { { sjp, .111 }, { sxlim, .159 }, H };
N l13n135[] = { { sivr, .191 }, { smpp, .143 }, { swxv, .143 }, H };
N l13n137[] = { { sir, .875 }, { srkg, .466 }, H };
N l13n138[] = { { sgwy, .215 }, H };
N l13n141[] = { { smz, .127 }, H };
N l13n142[] = { { sg_mp, .239 }, { smk, .080 }, H };
N l13n143[] = { { sZv, .111 }, { srq, .111 }, H };
N l13n144[] = { { sww, .239 }, H };
N l13n145[] = { { ssg, .549 }, { slm, .271 }, H };
N l13n146[] = { { sqs, .111 }, H };
N l13n147[] = { { sgmr, 1.253 }, { sYi, .318 }, { slivg, .382 }, H };
N l13n148[] = { { sgx, 2.770 }, H };
N l13n149[] = { { sgi, .406 }, { sgY79, .322 }, { sXz, .127 }, H };
N l13n150[] = { { sXk, .080 }, H };
N l13n151[] = { { ssjg, 1.325 }, { sqiq, .119 }, H };
N l13n153[] = { { skg, .310 }, H };
N l13n154[] = { { syir, .143 }, { sgyrm, .287 }, H };
N l13n156[] = { { srZig, .239 }, H };
N l13n157[] = { { siXw, .167 }, H };
N l13n158[] = { { sxv, .159 }, { sszi, .215 }, { smx79, .143 }, H };
N l13n159[] = { { sjsv, .167 }, H };
N l13n160[] = { { sppg, .287 }, H };
N l13n161[] = { { sgsj, 1.325 }, { swx, .414 }, { sxliv, .159 }, H };
N l13n162[] = { { swi, .446 }, { sqir, .430 }, { sgXwg, .382 }, H };
N l13n163[] = { { sqt, .111 }, H };
N l13n164[] = { { sqX, .191 }, H };
N l13n165[] = { { sgy, .215 }, H };
N l13n166[] = { { sgj, .454 }, H };
N l13n167[] = { { sxiv, .119 }, H };
N l13n169[] = { { smvg, .179 }, H };
N l13n171[] = { { sxlig, 3.008 }, { swms, .167 }, { sit, .096 }, { smrjp, .159 }, H };
N l13n172[] = { { siX, .350 }, H };
N l13n173[] = { { slig, 2.328 }, { syY, .096 }, H };
N l13n174[] = { { sviX, .167 }, { ssq, .096 }, H };
N l13n175[] = { { sxw, .239 }, H };
N l13n176[] = { { ssrw, .263 }, H };
N l13n177[] = { { sZx, .271 }, { sgXg, .501 }, H };
N l13n178[] = { { sZi, .271 }, { swy, .143 }, H };
N l13n181[] = { { sxmiw, .191 }, { sgrXx, .239 }, { sqY, .080 }, H };
N l13n182[] = { { sgz, .191 }, H };
N l13n183[] = { { sgk, .310 }, { shiv, .215 }, { spw, .080 }, H };
N l13n184[] = { { slg, .191 }, H };
N l13n185[] = { { sXrhg, 1.289 }, { sgxsg, .955 }, { sgYi, .394 }, { sjs, .143 }, H };
N l13n186[] = { { smwg, .394 }, H };
N l13n187[] = { { szX, .096 }, H };
N l13n188[] = { { srjp, .143 }, H };
N l13n189[] = { { smiwg, .430 }, { syv, .111 }, { sgi78, .179 }, H };
N l13n190[] = { { sivw, .167 }, { syZ, .080 }, H };
N l13n191[] = { { ssr, .875 }, { srXx, .119 }, H };
N l13n193[] = { { sxi, .318 }, { sgjsv, .239 }, H };
N l13n194[] = { { sXwg, .287 }, { smZl, .119 }, H };
N l13n195[] = { { srX, .159 }, H };
N l13n197[] = { { sgmrj, .239 }, H };
N l13n199[] = { { s79g, 1.027 }, { sg_, .836 }, { svm, .239 }, H };
N l13n200[] = { { sgl, .406 }, H };
N l13n201[] = { { spi, .334 }, { sgvi, .466 }, H };
N l13n202[] = { { sxms, .454 }, { sgmw, .215 }, { sirZ, .143 }, { siZx, .143 }, H };
N l13n203[] = { { sxsg, .752 }, { smxg, .358 }, { svrq, .167 }, H };
N l13n205[] = { { siv, 1.035 }, H };
N l13n206[] = { { siZ, .287 }, { syw, .175 }, { sivrq, .223 }, H };
N l13n207[] = { { siww, .239 }, H };
N l13n208[] = { { smsr, .740 }, { sxlmw, .159 }, { slim, .119 }, H };
N l13n209[] = { { shi, .493 }, { svwg, .251 }, { sgtXv, .287 }, { sxy, .096 }, H };
N l13n210[] = { { smrkg, .525 }, { slmZ, .167 }, H };
N l13n211[] = { { sXxg, .466 }, H };
N l13n212[] = { { s_lm, .143 }, H };
N l13n213[] = { { sgmx, .358 }, { sirh, .119 }, H };
N l13n215[] = { { sv79, .080 }, H };
N l13n216[] = { { sks, .159 }, H };
N l13n217[] = { { sgm, 1.289 }, { spy, .080 }, H };
N l13n218[] = { { siwx, .143 }, { svii, .119 }, H };
N l13n219[] = { { sghi, .573 }, H };
N l13n222[] = { { siw, .700 }, { sgksz, .334 }, H };
N l13n223[] = { { sih, .509 }, { sXg, .406 }, { syx, .096 }, H };
N l13n224[] = { { syi, .143 }, H };
N l13n225[] = { { sst, .127 }, H };
N l13n226[] = { { slmwg, .239 }, { sgqs, .179 }, H };
N l13n227[] = { { svig, .501 }, { smp, .207 }, H };
N l13n228[] = { { smzi, .167 }, H };
N l13n229[] = { { srZ, .239 }, { sziv, .310 }, { sZl, .191 }, { sirxg, .573 }, { sXYp, .119 }, H };
N l13n230[] = { { swm, .175 }, { srqi, .167 }, { sZvi, .143 }, H };
N l13n231[] = { { stXv, .239 }, { sY79, .143 }, { stvs, .191 }, { swwi, .119 }, { smppg, .239 }, H };
N l13n232[] = { { sqi, .525 }, H };
N l13n233[] = { { sirg, .251 }, H };
N l13n234[] = { { sksz, .167 }, H };
N l13n235[] = { { sXp, .302 }, H };
N l13n236[] = { { sXzi, .143 }, { sjv, .080 }, H };
N l13n238[] = { { svg, .883 }, { swih, .143 }, H };
N l13n239[] = { { six, .143 }, { sgmrx, .287 }, H };
N l13n240[] = { { sii, .127 }, H };
N l13n243[] = { { sgmrg, .621 }, { sglX, .358 }, { sYig, .287 }, H };
N l13n244[] = { { sxl, 1.560 }, { ssziv, .255 }, { smq, .080 }, H };
N l13n245[] = { { srw, .430 }, { sgY79g, .430 }, { swmsr, .223 }, H };
N l13n246[] = { { srh, .637 }, { sZm, .318 }, { sXxm, .239 }, H };
N l13n247[] = { { srxw, .167 }, { sls, .096 }, H };
N l13n248[] = { { sivX, .167 }, H };
N l13n249[] = { { sgsr, .251 }, H };
N l13n250[] = { { svrqi, .223 }, H };
N l13n252[] = { { sXq, .127 }, { syrm, .143 }, H };
N l13n253[] = { { s_lmZ, .159 }, H };
N l13n254[] = { { sqirx, .414 }, { smx79g, .287 }, H };
N l13n255[] = { { szi, .525 }, H };

D l13_d = {
	"english",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.149, 0.031, 0.067, 0.076, 0.294, 0.052, 0.031, 0.094, 0.152, 0.004, 0.004, 0.057, 0.052, 0.159, 0.137,
	    0.043, 0.003, 0.124, 0.133, 0.194, 0.050, 0.029, 0.027, 0.004, 0.034, 0.001, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ X, l13n1, l13n2, l13n3, l13n4, l13n5, l13n6, l13n7, X, l13n9, l13n10, l13n11, l13n12, l13n13, X, l13n15,
	    l13n16, l13n17, l13n18, l13n19, l13n20, l13n21, l13n22, X, l13n24, l13n25, l13n26, l13n27, l13n28, l13n29, l13n30, l13n31,
	    X, X, l13n34, X, l13n36, l13n37, l13n38, l13n39, l13n40, l13n41, l13n42, l13n43, l13n44, l13n45, l13n46, l13n47,
	    l13n48, X, X, l13n51, l13n52, l13n53, l13n54, l13n55, l13n56, X, X, l13n59, l13n60, X, l13n62, l13n63,
	    l13n64, l13n65, l13n66, l13n67, X, l13n69, l13n70, l13n71, l13n72, l13n73, l13n74, l13n75, l13n76, l13n77, l13n78, X,
	    l13n80, l13n81, l13n82, X, X, l13n85, l13n86, l13n87, X, l13n89, l13n90, l13n91, l13n92, l13n93, l13n94, l13n95,
	    X, l13n97, l13n98, l13n99, X, l13n101, l13n102, l13n103, l13n104, X, X, l13n107, l13n108, l13n109, X, X,
	    X, l13n113, l13n114, l13n115, l13n116, l13n117, X, l13n119, l13n120, l13n121, l13n122, l13n123, l13n124, l13n125, X, X,
	    X, l13n129, l13n130, l13n131, l13n132, l13n133, l13n134, l13n135, X, l13n137, l13n138, X, X, l13n141, l13n142, l13n143,
	    l13n144, l13n145, l13n146, l13n147, l13n148, l13n149, l13n150, l13n151, X, l13n153, l13n154, X, l13n156, l13n157, l13n158, l13n159,
	    l13n160, l13n161, l13n162, l13n163, l13n164, l13n165, l13n166, l13n167, X, l13n169, X, l13n171, l13n172, l13n173, l13n174, l13n175,
	    l13n176, l13n177, l13n178, X, X, l13n181, l13n182, l13n183, l13n184, l13n185, l13n186, l13n187, l13n188, l13n189, l13n190, l13n191,
	    X, l13n193, l13n194, l13n195, X, l13n197, X, l13n199, l13n200, l13n201, l13n202, l13n203, X, l13n205, l13n206, l13n207,
	    l13n208, l13n209, l13n210, l13n211, l13n212, l13n213, X, l13n215, l13n216, l13n217, l13n218, l13n219, X, X, l13n222, l13n223,
	    l13n224, l13n225, l13n226, l13n227, l13n228, l13n229, l13n230, l13n231, l13n232, l13n233, l13n234, l13n235, l13n236, X, l13n238, l13n239,
	    l13n240, X, X, l13n243, l13n244, l13n245, l13n246, l13n247, l13n248, l13n249, l13n250, X, l13n252, l13n253, l13n254, l13n255 }
};

//
// Lng: finnish
// Enc: iso-8859-15
//

S sxU[] = { t, 228, 0 };
S ssm[] = { o, i, 0 };
S sow[] = { k, s, 0 };
S syy[] = { u, u, 0 };
S smm[] = { i, i, 0 };
S sys[] = { u, o, 0 };
S sxUg[] = { t, 228, a };
S swwX[] = { s, s, 97, 0 };
S szU[] = { v, 228, 0 };
S ssmq[] = { o, i, m, 0 };
S sxsm[] = { t, o, i, 0 };
S sxxX[] = { t, t, 97, 0 };
S sUU[] = { 228, 228, 0 };
S spU[] = { l, 228, 0 };
S swXg[] = { s, 97, a };
S sppm[] = { l, l, i, 0 };
S swwXg[] = { s, s, 97, a };
S sowm[] = { k, s, i, 0 };
S smwi[] = { i, s, e, 0 };
S sXmw[] = { 97, i, s, 0 };
S sgsp[] = { 32, o, l, 0 };
S ssmqm[] = { o, i, m, i, 0 };
S sixx[] = { e, t, t, 0 };
S sxsmq[] = { t, o, i, m, 0 };
S smxx[] = { i, t, t, 0 };
S sXXg[] = { 97, 97, a };
S sppX[] = { l, l, 97, 0 };
S swmg[] = { s, i, a };
S swU[] = { s, 228, 0 };
S sgxsm[] = { 32, t, o, i, 0 };
S stU[] = { p, 228, 0 };
S sowi[] = { k, s, e, 0 };
S smmr[] = { i, i, n, 0 };
S sgoi[] = { 32, k, e, 0 };
S sgnXg[] = { 32, j, 97, a };
S srom[] = { n, k, i, 0 };
S sxyw[] = { t, u, s, 0 };
S sgxy[] = { 32, t, u, 0 };
S sppXg[] = { l, l, 97, a };
S srrX[] = { n, n, 97, 0 };
S sUm[] = { 228, i, 0 };
S spmw[] = { l, i, s, 0 };
S sowmg[] = { k, s, i, a };
S sxxU[] = { t, t, 228, 0 };
S sywx[] = { u, s, t, 0 };
S sUp[] = { 228, l, 0 };
S sspi[] = { o, l, e, 0 };
S sUr[] = { 228, n, 0 };
S sXwx[] = { 97, s, t, 0 };
S ssmx[] = { o, i, t, 0 };
S snU[] = { j, 228, 0 };
S s7979[] = { y, y, 0 };
S s79l[] = { y, h, 0 };
S slXp[] = { h, 97, l, 0 };
S sUx[] = { 228, t, 0 };
S sgns[] = { 32, j, o, 0 };
S sspm[] = { o, l, i, 0 };
S sUz[] = { 228, v, 0 };
S swxU[] = { s, t, 228, 0 };
S sXppm[] = { 97, l, l, i, 0 };
S soXy[] = { k, 97, u, 0 };
S syyx[] = { u, u, t, 0 };
S szsm[] = { v, o, i, 0 };
S slh[] = { h, d, 0 };
S smow[] = { i, k, s, 0 };
S smmrg[] = { i, i, n, a };
S syow[] = { u, k, s, 0 };
S slip[] = { h, e, l, 0 };
S syz[] = { u, v, 0 };
S smpX[] = { i, l, 97, 0 };
S sXro[] = { 97, n, k, 0 };
S szXm[] = { v, 97, i, 0 };
S soXyt[] = { k, 97, u, p, 0 };
S sxUz[] = { t, 228, v, 0 };
S smowm[] = { i, k, s, i, 0 };
S somr[] = { k, i, n, 0 };
S sglXp[] = { 32, h, 97, l, 0 };
S sUv[] = { 228, r, 0 };
S sypy[] = { u, l, u, 0 };
S sgtU[] = { 32, p, 228, 0 };
S svn[] = { r, j, 0 };
S sxxXX[] = { t, t, 97, 97, 0 };
S soXr[] = { k, 97, n, 0 };
S swwU[] = { s, s, 228, 0 };
S smwm[] = { i, s, i, 0 };
S spXm[] = { l, 97, i, 0 };
S soU[] = { k, 228, 0 };
S srir[] = { n, e, n, 0 };
S swUg[] = { s, 228, a };
S swwUg[] = { s, s, 228, a };
S soiwo[] = { k, e, s, k, 0 };
S soiw[] = { k, e, s, 0 };
S srirg[] = { n, e, n, a };
S swmX[] = { s, i, 97, 0 };
S sXyt[] = { 97, u, p, 0 };
S sgoiw[] = { 32, k, e, s, 0 };
S smwxi[] = { i, s, t, e, 0 };
S sgspi[] = { 32, o, l, e, 0 };
S sgwys[] = { 32, s, u, o, 0 };
S stt[] = { p, p, 0 };
S smqmr[] = { i, m, i, n, 0 };
S srU[] = { n, 228, 0 };
S smrr[] = { i, n, n, 0 };
S sppU[] = { l, l, 228, 0 };
S swys[] = { s, u, o, 0 };
S swoy[] = { s, k, u, 0 };
S swyy[] = { s, u, u, 0 };
S ssqm[] = { o, m, i, 0 };
S sippX[] = { e, l, l, 97, 0 };
S smww[] = { i, s, s, 0 };
S sqU[] = { m, 228, 0 };
S sty[] = { p, u, 0 };
S swmx[] = { s, i, t, 0 };
S spUg[] = { l, 228, a };
S sXoX[] = { 97, k, 97, 0 };
S szXp[] = { v, 97, l, 0 };
S smrir[] = { i, n, e, n, 0 };
S sUw[] = { 228, s, 0 };
S spXmw[] = { l, 97, i, s, 0 };
S somrg[] = { k, i, n, a };
S sUzU[] = { 228, v, 228, 0 };
S sxXz[] = { t, 97, v, 0 };
S sg79l[] = { 32, y, h, 0 };
S syowi[] = { u, k, s, e, 0 };
S sxXXr[] = { t, 97, 97, n, 0 };
S swxUg[] = { s, t, 228, a };
S sgzXm[] = { 32, v, 97, i, 0 };
S szXxg[] = { v, 97, t, a };
S sspp[] = { o, l, l, 0 };
S spq[] = { l, m, 0 };
S sgoXr[] = { 32, k, 97, n, 0 };
S sglip[] = { 32, h, e, l, 0 };
S s79xx[] = { y, t, t, 0 };
S siwoy[] = { e, s, k, u, 0 };
S sqXvm[] = { m, 97, r, i, 0 };
S syzX[] = { u, v, 97, 0 };
S smxw[] = { i, t, s, 0 };
S siwm[] = { e, s, i, 0 };
S sqqig[] = { m, m, e, a };
S sXnX[] = { 97, j, 97, 0 };
S smmx[] = { i, i, t, 0 };
S sppUg[] = { l, l, 228, a };
S sXmwi[] = { 97, i, s, e, 0 };
S sppmw[] = { l, l, i, s, 0 };
S smxU[] = { i, t, 228, 0 };
S smxwi[] = { i, t, s, e, 0 };
S soyw[] = { k, u, s, 0 };
S syrr[] = { u, n, n, 0 };
S syxxX[] = { u, t, t, 97, 0 };
S srmwx[] = { n, i, s, t, 0 };
S sowir[] = { k, s, e, n, 0 };
S sgzXp[] = { 32, v, 97, l, 0 };
S syrg[] = { u, n, a };
S sgiwm[] = { 32, e, s, i, 0 };
S srXrg[] = { n, 97, n, a };
S smwxX[] = { i, s, t, 97, 0 };
S swoyw[] = { s, k, u, s, 0 };
S sgixx[] = { 32, e, t, t, 0 };
S swmXg[] = { s, i, 97, a };
S sxXXg[] = { t, 97, 97, a };
S syxx[] = { u, t, t, 0 };
S sqyy[] = { m, u, u, 0 };
S somp[] = { k, i, l, 0 };

N l14n0[] = { { stt, .085 }, { siy, .085 }, H };
N l14n1[] = { { stX, .182 }, { syz, .097 }, { smrx, .146 }, H };
N l14n2[] = { { sgoy, .273 }, { swig, .164 }, H };
N l14n5[] = { { smr, .923 }, { sxm, .340 }, { sXoX, .128 }, H };
N l14n6[] = { { srx, .206 }, { sgwm, .219 }, H };
N l14n7[] = { { sri, .255 }, H };
N l14n8[] = { { swo, .219 }, { spXm, .146 }, { somrg, .255 }, { sxXXg, .219 }, H };
N l14n9[] = { { slX, .255 }, H };
N l14n10[] = { { siirg, .219 }, H };
N l14n11[] = { { sipp, .273 }, H };
N l14n12[] = { { sgp, .364 }, { sppU, .128 }, H };
N l14n13[] = { { sXr, .947 }, { spm, .631 }, { swg, .200 }, H };
N l14n14[] = { { smpX, .146 }, { sxxXX, .194 }, H };
N l14n15[] = { { swoy, .128 }, H };
N l14n16[] = { { soo, .158 }, { sswx, .146 }, H };
N l14n17[] = { { swU, .158 }, { swmX, .146 }, { siz, .085 }, H };
N l14n18[] = { { sgspi, .291 }, H };
N l14n20[] = { { ssw, .255 }, H };
N l14n21[] = { { sx79, .219 }, { sgnX, .410 }, H };
N l14n22[] = { { sms, .109 }, H };
N l14n23[] = { { szXxg, .255 }, { sgxm, .164 }, { sxxi, .109 }, H };
N l14n24[] = { { sxii, .109 }, H };
N l14n25[] = { { ssmq, .328 }, { soU, .097 }, H };
N l14n27[] = { { swwXg, .583 }, { sowm, .291 }, H };
N l14n28[] = { { sgtU, .219 }, { sgzXm, .255 }, { sppmw, .146 }, H };
N l14n29[] = { { sgq, .528 }, { sqmw, .200 }, H };
N l14n31[] = { { ssrg, .519 }, { sgli, .164 }, { smqX, .109 }, H };
N l14n32[] = { { sspm, .182 }, { soXr, .146 }, H };
N l14n33[] = { { srirg, .291 }, H };
N l14n35[] = { { sil, .109 }, { srXg, .164 }, H };
N l14n36[] = { { swxm, .164 }, { sym, .085 }, { sgqy, .191 }, H };
N l14n37[] = { { ssx, .146 }, { sgzXp, .219 }, H };
N l14n38[] = { { sgoX, .492 }, { smir, .146 }, H };
N l14n39[] = { { sXqX, .200 }, { svmg, .191 }, { sqqig, .219 }, H };
N l14n40[] = { { smX, .219 }, H };
N l14n41[] = { { spig, .328 }, H };
N l14n44[] = { { sqm, .595 }, { sxg, .710 }, { swxXg, .583 }, { szsm, .164 }, { syzX, .109 }, { sxXq, .109 }, H };
N l14n46[] = { { sgr, .255 }, { sUv, .219 }, { sippX, .170 }, H };
N l14n48[] = { { sXX, .668 }, { sxU, .534 }, H };
N l14n49[] = { { srxX, .164 }, { ssqm, .128 }, H };
N l14n51[] = { { syrr, .109 }, H };
N l14n52[] = { { sim, .255 }, H };
N l14n53[] = { { sxsmq, .364 }, { sns, .158 }, H };
N l14n54[] = { { ssy, .097 }, H };
N l14n55[] = { { syow, .164 }, { sglXp, .291 }, { smxU, .109 }, H };
N l14n56[] = { { spU, .206 }, H };
N l14n57[] = { { sowir, .146 }, H };
N l14n60[] = { { slh, .109 }, { srmw, .109 }, H };
N l14n62[] = { { szXm, .146 }, { sUzU, .287 }, H };
N l14n63[] = { { sgs, .765 }, { svX, .109 }, { sUw, .191 }, H };
N l14n64[] = { { spp, .607 }, H };
N l14n65[] = { { sspp, .128 }, H };
N l14n66[] = { { sxUz, .146 }, H };
N l14n67[] = { { szm, .206 }, H };
N l14n69[] = { { sti, .097 }, H };
N l14n70[] = { { swmg, .355 }, { syo, .158 }, H };
N l14n71[] = { { snX, .352 }, H };
N l14n72[] = { { sgqX, .301 }, { sgws, .164 }, { sqig, .164 }, H };
N l14n73[] = { { smv, .073 }, H };
N l14n74[] = { { sXXrg, .765 }, H };
N l14n75[] = { { srm, .194 }, { syg, .182 }, { smww, .128 }, H };
N l14n76[] = { { slx, .146 }, { sws, .097 }, H };
N l14n77[] = { { sli, .182 }, H };
N l14n79[] = { { sixg, .246 }, H };
N l14n80[] = { { sgt, .601 }, { sivm, .200 }, { sUx, .273 }, H };
N l14n81[] = { { sgX, .346 }, { sXv, .219 }, { spq, .085 }, H };
N l14n82[] = { { sgoi, .328 }, H };
N l14n84[] = { { sos, .328 }, { ssmqm, .364 }, { sXyt, .146 }, H };
N l14n85[] = { { sty, .085 }, H };
N l14n86[] = { { smwx, .474 }, H };
N l14n87[] = { { syp, .194 }, { sqU, .085 }, { s79xx, .109 }, H };
N l14n89[] = { { sgxs, .465 }, { sgsrg, .437 }, H };
N l14n90[] = { { smw, .826 }, H };
N l14n91[] = { { sig, .565 }, { s79x, .194 }, { sr79, .073 }, H };
N l14n92[] = { { swir, .219 }, { smri, .146 }, { swwU, .146 }, { smxw, .109 }, H };
N l14n93[] = { { sly, .109 }, H };
N l14n94[] = { { swX, .352 }, { sXwx, .182 }, { sypy, .146 }, H };
N l14n95[] = { { szXp, .128 }, H };
N l14n97[] = { { spXmw, .170 }, { sg79l, .191 }, { siwm, .109 }, H };
N l14n98[] = { { sXw, .279 }, H };
N l14n99[] = { { sglip, .219 }, H };
N l14n101[] = { { smrg, .792 }, { sxmg, .191 }, { sxip, .128 }, H };
N l14n102[] = { { soX, .583 }, { ssmx, .182 }, { syowi, .170 }, H };
N l14n103[] = { { sip, .522 }, { smxx, .255 }, { sywo, .109 }, H };
N l14n104[] = { { swoyw, .146 }, H };
N l14n106[] = { { ssm, .510 }, { smmr, .219 }, H };
N l14n107[] = { { smx, .729 }, { sxs, .449 }, { sppX, .255 }, H };
N l14n108[] = { { smi, .206 }, { sppUg, .219 }, H };
N l14n109[] = { { sXrg, 1.230 }, { sro, .243 }, { swxU, .164 }, { soXy, .164 }, { spmg, .191 }, H };
N l14n110[] = { { szU, .219 }, H };
N l14n112[] = { { sqq, .121 }, { sgoXr, .255 }, H };
N l14n113[] = { { swUg, .219 }, { swmXg, .219 }, H };
N l14n114[] = { { srg, 2.896 }, { sUz, .273 }, { sXmr, .128 }, { sgv, .128 }, H };
N l14n115[] = { { sXx, .340 }, { sps, .085 }, H };
N l14n117[] = { { sgnXg, .437 }, { szXr, .182 }, H };
N l14n118[] = { { srU, .085 }, H };
N l14n119[] = { { smqm, .291 }, { siwo, .146 }, { swys, .128 }, H };
N l14n120[] = { { siq, .158 }, H };
N l14n121[] = { { syr, .255 }, { smwxX, .146 }, H };
N l14n123[] = { { sxir, .200 }, { sowmg, .401 }, { ssn, .109 }, H };
N l14n125[] = { { sxX, .972 }, H };
N l14n131[] = { { sgw, .656 }, H };
N l14n132[] = { { sXy, .158 }, H };
N l14n133[] = { { spX, .376 }, { smwxi, .194 }, H };
N l14n134[] = { { sgiw, .164 }, H };
N l14n135[] = { { smpp, .128 }, H };
N l14n136[] = { { smXg, .219 }, H };
N l14n137[] = { { sir, .838 }, { stm, .146 }, H };
N l14n138[] = { { sys, .267 }, { sgwy, .246 }, H };
N l14n139[] = { { sni, .158 }, { smxwi, .146 }, H };
N l14n140[] = { { sso, .158 }, { sxxU, .200 }, H };
N l14n141[] = { { smz, .146 }, H };
N l14n143[] = { { sXpp, .255 }, { s79l, .121 }, { sxXz, .128 }, H };
N l14n144[] = { { sww, .340 }, { sxUg, .601 }, { sXXg, .383 }, H };
N l14n145[] = { { sgix, .246 }, { ssg, .109 }, H };
N l14n146[] = { { somp, .109 }, H };
N l14n147[] = { { swiw, .146 }, H };
N l14n148[] = { { sgx, .929 }, { sgxsm, .474 }, H };
N l14n149[] = { { sgi, .638 }, { sUm, .301 }, { sXz, .134 }, H };
N l14n150[] = { { smxX, .128 }, H };
N l14n151[] = { { sppi, .200 }, H };
N l14n152[] = { { sow, .364 }, { spUg, .191 }, { srmwx, .146 }, H };
N l14n155[] = { { sgxy, .301 }, { syt, .134 }, { soiw, .146 }, H };
N l14n156[] = { { syX, .073 }, H };
N l14n157[] = { { ssp, .389 }, H };
N l14n160[] = { { srr, .316 }, { sgqm, .191 }, H };
N l14n161[] = { { swx, .923 }, H };
N l14n162[] = { { swi, .571 }, H };
N l14n164[] = { { sqX, .474 }, H };
N l14n165[] = { { sgy, .128 }, H };
N l14n166[] = { { sXro, .146 }, { smrir, .170 }, H };
N l14n167[] = { { snXg, .465 }, { sXl, .121 }, H };
N l14n168[] = { { sxXX, .273 }, { somr, .146 }, { swxy, .146 }, H };
N l14n169[] = { { sXmw, .273 }, { szs, .158 }, { sxmp, .128 }, H };
N l14n170[] = { { soi, .340 }, { siir, .128 }, H };
N l14n171[] = { { sgoiw, .291 }, { soyw, .109 }, H };
N l14n172[] = { { smmx, .109 }, H };
N l14n173[] = { { slXp, .182 }, H };
N l14n174[] = { { ssq, .194 }, H };
N l14n175[] = { { sxw, .146 }, { sgns, .273 }, H };
N l14n176[] = { { smm, .291 }, { s7979, .121 }, H };
N l14n177[] = { { smwi, .273 }, { srs, .097 }, H };
N l14n178[] = { { swy, .194 }, H };
N l14n180[] = { { stU, .158 }, H };
N l14n182[] = { { sgz, .747 }, H };
N l14n183[] = { { szXx, .128 }, H };
N l14n184[] = { { sXm, .510 }, H };
N l14n185[] = { { swyy, .128 }, H };
N l14n186[] = { { soy, .364 }, H };
N l14n187[] = { { szX, .619 }, { swwX, .364 }, H };
N l14n188[] = { { sUg, 2.090 }, { swwUg, .291 }, { swirg, .255 }, H };
N l14n189[] = { { soXyt, .194 }, { syv, .097 }, { sxix, .128 }, H };
N l14n190[] = { { swXg, .465 }, H };
N l14n191[] = { { ssr, .389 }, { sgxX, .246 }, { smrr, .128 }, H };
N l14n192[] = { { sxx, .631 }, { sUU, .465 }, { sgos, .410 }, { sXzX, .128 }, H };
N l14n193[] = { { sxi, .546 }, { srir, .146 }, { smqmr, .170 }, { sgiwm, .219 }, H };
N l14n194[] = { { sxyw, .200 }, { smxi, .182 }, H };
N l14n195[] = { { srX, .304 }, { sppm, .291 }, { smow, .164 }, H };
N l14n197[] = { { sqXvm, .146 }, H };
N l14n199[] = { { svm, .352 }, { spmr, .182 }, { s79g, .146 }, H };
N l14n200[] = { { sgl, .528 }, { spx, .158 }, { sUp, .301 }, H };
N l14n201[] = { { spi, .352 }, { sXn, .121 }, H };
N l14n202[] = { { sywx, .200 }, { sXppm, .219 }, { smmrg, .328 }, H };
N l14n203[] = { { sppXg, .401 }, { srrX, .200 }, H };
N l14n204[] = { { swxX, .455 }, H };
N l14n205[] = { { siv, .231 }, { swxUg, .255 }, H };
N l14n206[] = { { syw, .376 }, H };
N l14n207[] = { { sqXX, .146 }, { siww, .146 }, H };
N l14n208[] = { { sss, .073 }, H };
N l14n209[] = { { sxy, .522 }, { shi, .194 }, H };
N l14n210[] = { { smo, .364 }, H };
N l14n211[] = { { sXxg, .355 }, H };
N l14n212[] = { { sXvm, .146 }, H };
N l14n214[] = { { siwoy, .146 }, H };
N l14n215[] = { { smg, .965 }, { sgwys, .255 }, H };
N l14n216[] = { { svn, .097 }, { sXmwi, .146 }, H };
N l14n217[] = { { spy, .316 }, { sgm, .164 }, { syrg, .164 }, H };
N l14n218[] = { { sXo, .219 }, { siwx, .255 }, { sgwi, .191 }, H };
N l14n219[] = { { sxirg, .291 }, { syxx, .109 }, H };
N l14n220[] = { { soiwo, .194 }, H };
N l14n221[] = { { sxXg, .792 }, { smwm, .146 }, { srXrg, .219 }, H };
N l14n222[] = { { siw, .474 }, H };
N l14n223[] = { { sXg, 2.113 }, { syx, .255 }, H };
N l14n225[] = { { sgzX, .683 }, { sst, .097 }, H };
N l14n226[] = { { swmx, .128 }, H };
N l14n227[] = { { smp, .401 }, { sgsp, .410 }, H };
N l14n229[] = { { spXg, .301 }, H };
N l14n230[] = { { swm, .668 }, { sqmr, .273 }, H };
N l14n232[] = { { sqi, .219 }, H };
N l14n233[] = { { sirg, 1.366 }, { sg79, .255 }, { svo, .097 }, H };
N l14n234[] = { { sgn, .546 }, { sXXr, .474 }, { sUr, .301 }, H };
N l14n235[] = { { sXp, .401 }, { sxxX, .328 }, { sixx, .273 }, { shirg, .219 }, H };
N l14n236[] = { { syyx, .164 }, H };
N l14n237[] = { { sgixx, .219 }, H };
N l14n238[] = { { som, .401 }, { sxsm, .328 }, H };
N l14n239[] = { { six, .437 }, { sowi, .237 }, { sts, .097 }, H };
N l14n240[] = { { syy, .328 }, { sii, .182 }, { srom, .219 }, H };
N l14n241[] = { { slip, .164 }, H };
N l14n242[] = { { sxXXr, .170 }, H };
N l14n243[] = { { sglX, .410 }, H };
N l14n244[] = { { smq, .364 }, { sspi, .200 }, { sXnX, .109 }, H };
N l14n245[] = { { srw, .085 }, H };
N l14n246[] = { { sw79, .073 }, H };
N l14n247[] = { { srri, .182 }, { sppig, .291 }, { sls, .085 }, H };
N l14n248[] = { { swxi, .273 }, { sqy, .134 }, H };
N l14n249[] = { { sgsr, .410 }, H };
N l14n250[] = { { snU, .121 }, H };
N l14n251[] = { { sgo, 1.184 }, H };
N l14n252[] = { { sXq, .206 }, H };
N l14n254[] = { { spmw, .200 }, { smowm, .194 }, { syxxX, .146 }, H };
N l14n255[] = { { sqyy, .109 }, H };

D l14_d = {
	"finnish",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.235, 0.000, 0.001, 0.017, 0.157, 0.000, 0.004, 0.041, 0.223, 0.033, 0.109, 0.122, 0.069, 0.163, 0.108,
	    0.036, 0.000, 0.039, 0.153, 0.199, 0.105, 0.052, 0.001, W, 0.040, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, 0.001, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, 0.178, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, 0.019, V, V, V, V, V, V, V, V, V },
	{ l14n0, l14n1, l14n2, X, X, l14n5, l14n6, l14n7, l14n8, l14n9, l14n10, l14n11, l14n12, l14n13, l14n14, l14n15,
	    l14n16, l14n17, l14n18, X, l14n20, l14n21, l14n22, l14n23, l14n24, l14n25, X, l14n27, l14n28, l14n29, X, l14n31,
	    l14n32, l14n33, X, l14n35, l14n36, l14n37, l14n38, l14n39, l14n40, l14n41, X, X, l14n44, X, l14n46, X,
	    l14n48, l14n49, X, l14n51, l14n52, l14n53, l14n54, l14n55, l14n56, l14n57, X, X, l14n60, X, l14n62, l14n63,
	    l14n64, l14n65, l14n66, l14n67, X, l14n69, l14n70, l14n71, l14n72, l14n73, l14n74, l14n75, l14n76, l14n77, X, l14n79,
	    l14n80, l14n81, l14n82, X, l14n84, l14n85, l14n86, l14n87, X, l14n89, l14n90, l14n91, l14n92, l14n93, l14n94, l14n95,
	    X, l14n97, l14n98, l14n99, X, l14n101, l14n102, l14n103, l14n104, X, l14n106, l14n107, l14n108, l14n109, l14n110, X,
	    l14n112, l14n113, l14n114, l14n115, X, l14n117, l14n118, l14n119, l14n120, l14n121, X, l14n123, X, l14n125, X, X,
	    X, X, X, l14n131, l14n132, l14n133, l14n134, l14n135, l14n136, l14n137, l14n138, l14n139, l14n140, l14n141, X, l14n143,
	    l14n144, l14n145, l14n146, l14n147, l14n148, l14n149, l14n150, l14n151, l14n152, X, X, l14n155, l14n156, l14n157, X, X,
	    l14n160, l14n161, l14n162, X, l14n164, l14n165, l14n166, l14n167, l14n168, l14n169, l14n170, l14n171, l14n172, l14n173, l14n174, l14n175,
	    l14n176, l14n177, l14n178, X, l14n180, X, l14n182, l14n183, l14n184, l14n185, l14n186, l14n187, l14n188, l14n189, l14n190, l14n191,
	    l14n192, l14n193, l14n194, l14n195, X, l14n197, X, l14n199, l14n200, l14n201, l14n202, l14n203, l14n204, l14n205, l14n206, l14n207,
	    l14n208, l14n209, l14n210, l14n211, l14n212, X, l14n214, l14n215, l14n216, l14n217, l14n218, l14n219, l14n220, l14n221, l14n222, l14n223,
	    X, l14n225, l14n226, l14n227, X, l14n229, l14n230, X, l14n232, l14n233, l14n234, l14n235, l14n236, l14n237, l14n238, l14n239,
	    l14n240, l14n241, l14n242, l14n243, l14n244, l14n245, l14n246, l14n247, l14n248, l14n249, l14n250, l14n251, l14n252, X, l14n254, l14n255 }
};

//
// Lng: french
// Enc: iso-8859-15
//

S sgpig[] = { 32, l, e, a };
S she9[] = { d, 233, 0 };
S sxe9[] = { t, 233, 0 };
S sghe9[] = { 32, d, 233, 0 };
S sve9[] = { r, 233, 0 };
S sgQg[] = { 32, 224, a };
S se9v[] = { 233, r, 0 };
S sxe9g[] = { t, 233, a };
S sh27[] = { d, 39, 0 };
S ssyv[] = { o, u, r, 0 };
S se8wg[] = { 232, s, a };
S se8w[] = { 232, s, 0 };
S sZli[] = { 99, h, e, 0 };
S shiwg[] = { d, e, s, a };
S se9x[] = { 233, t, 0 };
S sXmxg[] = { 97, i, t, a };
S sgXz[] = { 32, 97, v, 0 };
S sXyg[] = { 97, u, a };
S sZiw[] = { 99, e, s, 0 };
S sy78[] = { u, x, 0 };
S se9i[] = { 233, e, 0 };
S smu[] = { i, q, 0 };
S sXrw[] = { 97, n, s, 0 };
S symg[] = { u, i, a };
S swe9[] = { s, 233, 0 };
S smuy[] = { i, q, u, 0 };
S se9Z[] = { 233, 99, 0 };
S smuyi[] = { i, q, u, e, 0 };
S sve8w[] = { r, 232, s, 0 };
S sguym[] = { 32, q, u, i, 0 };
S sXrZ[] = { 97, n, 99, 0 };
S suym[] = { q, u, i, 0 };
S sve8[] = { r, 232, 0 };
S sZiwg[] = { 99, e, s, a };
S sgmp[] = { 32, i, l, 0 };
S suymg[] = { q, u, i, a };
S sXrwg[] = { 97, n, s, a };
S sve8wg[] = { r, 232, s, a };
S sgXy[] = { 32, 97, u, 0 };
S smj[] = { i, f, 0 };
S siqir[] = { e, m, e, n, 0 };
S srhv[] = { n, d, r, 0 };
S se9k[] = { 233, g, 0 };
S siqi[] = { e, m, e, 0 };
S sy78g[] = { u, x, a };
S sXtt[] = { 97, p, p, 0 };
S sgXyg[] = { 32, 97, u, a };
S siwxg[] = { e, s, t, a };
S ssyt[] = { o, u, p, 0 };
S se9ig[] = { 233, e, a };
S sjj[] = { f, f, 0 };
S spe9[] = { l, 233, 0 };
S smxe9[] = { i, t, 233, 0 };
S sqe9[] = { m, 233, 0 };
S sgmpg[] = { 32, i, l, a };
S sqXm[] = { m, 97, i, 0 };
S ssrxg[] = { o, n, t, a };
S sxsy[] = { t, o, u, 0 };
S smvig[] = { i, r, e, a };
S sgxsy[] = { 32, t, o, u, 0 };
S ssvx[] = { o, r, t, 0 };
S sZlig[] = { 99, h, e, a };
S sve9w[] = { r, 233, s, 0 };
S symw[] = { u, i, s, 0 };
S svXm[] = { r, 97, i, 0 };
S smxe9g[] = { i, t, 233, a };
S sZsy[] = { 99, o, u, 0 };
S sgiwx[] = { 32, e, s, t, 0 };
S sgyrg[] = { 32, u, n, a };
S se9p[] = { 233, l, 0 };
S sgqXm[] = { 32, m, 97, i, 0 };
S ssqt[] = { o, m, p, 0 };
S sYpi[] = { 98, l, e, 0 };
S sgXt[] = { 32, 97, p, 0 };
S shXrw[] = { d, 97, n, s, 0 };
S svivg[] = { r, e, r, a };
S se8vig[] = { 232, r, e, a };
S sXmvi[] = { 97, i, r, e, 0 };
S s27i[] = { 39, e, 0 };
S suy27[] = { q, u, 39, 0 };
S srz[] = { n, v, 0 };
S se8v[] = { 232, r, 0 };
S sZsqt[] = { 99, o, m, p, 0 };
S sgh27X[] = { 32, d, 39, 97, 0 };
S sXmwg[] = { 97, i, s, a };
S smivg[] = { i, e, r, a };
S sXmv[] = { 97, i, r, 0 };
S sghyg[] = { 32, d, u, a };
S sxvig[] = { t, r, e, a };
S sy27[] = { u, 39, 0 };
S sviv[] = { r, e, r, 0 };
S s27m[] = { 39, i, 0 };
S stsr[] = { p, o, n, 0 };
S stsw[] = { p, o, s, 0 };
S srZl[] = { n, 99, h, 0 };
S sXww[] = { 97, s, s, 0 };

N l15n0[] = { { siy, .273 }, { stt, .124 }, { smvig, .260 }, H };
N l15n1[] = { { stX, .285 }, { swxg, .223 }, H };
N l15n2[] = { { swig, .446 }, H };
N l15n3[] = { { ssv, .273 }, { sZiwg, .334 }, H };
N l15n5[] = { { sxm, .421 }, { smr, .372 }, H };
N l15n6[] = { { srx, .657 }, { ssyt, .149 }, H };
N l15n7[] = { { sri, .248 }, { sghm, .362 }, H };
N l15n9[] = { { sXrx, .149 }, { slX, .099 }, { sXmwg, .223 }, H };
N l15n10[] = { { sYp, .149 }, H };
N l15n11[] = { { sZsq, .167 }, { skv, .099 }, { sgXr, .195 }, { sipp, .130 }, H };
N l15n12[] = { { sgp, 1.858 }, H };
N l15n13[] = { { swg, 3.382 }, { sXr, .595 }, { spm, .198 }, H };
N l15n14[] = { { se9k, .223 }, H };
N l15n15[] = { { sxwg, .502 }, H };
N l15n16[] = { { ssrwg, .483 }, H };
N l15n18[] = { { sZig, .251 }, H };
N l15n20[] = { { sxmsr, .520 }, { sXmxg, .409 }, { ssw, .087 }, H };
N l15n21[] = { { shm, .322 }, { sgts, .223 }, { symw, .130 }, H };
N l15n22[] = { { sms, .434 }, { sZsr, .260 }, H };
N l15n24[] = { { srj, .074 }, H };
N l15n25[] = { { siqir, .198 }, H };
N l15n26[] = { { spiwg, 1.152 }, H };
N l15n27[] = { { se8wg, .753 }, { ssrxg, .297 }, H };
N l15n28[] = { { ssyv, .223 }, H };
N l15n29[] = { { sgq, .706 }, { syvg, .334 }, { sZg, .149 }, H };
N l15n31[] = { { ssrg, .753 }, H };
N l15n32[] = { { sgQg, .418 }, { sjj, .099 }, H };
N l15n33[] = { { sxig, .362 }, { sgXt, .167 }, { suy27, .111 }, H };
N l15n34[] = { { stv, .334 }, { shiwg, .409 }, H };
N l15n35[] = { { sy78, .124 }, H };
N l15n36[] = { { sym, .297 }, H };
N l15n38[] = { { smir, .186 }, H };
N l15n39[] = { { sve8w, .167 }, { sqXm, .149 }, H };
N l15n40[] = { { srz, .074 }, H };
N l15n41[] = { { spig, 1.003 }, { smsrw, .248 }, { srk, .074 }, H };
N l15n42[] = { { s27X, .173 }, H };
N l15n43[] = { { suyig, .409 }, H };
N l15n44[] = { { sxg, 1.580 }, { sqm, .173 }, H };
N l15n45[] = { { svs, .273 }, { sivg, .530 }, H };
N l15n46[] = { { sgr, .334 }, { ski, .149 }, H };
N l15n47[] = { { sXt, .186 }, H };
N l15n48[] = { { smsrg, .818 }, H };
N l15n49[] = { { shig, 1.505 }, { sgh27, .362 }, H };
N l15n52[] = { { spg, .204 }, { sghiw, .409 }, H };
N l15n54[] = { { ssy, .471 }, { sgtv, .418 }, { sve8, .111 }, H };
N l15n55[] = { { sgpX, .697 }, H };
N l15n56[] = { { sgZs, .697 }, { smu, .124 }, { sve9w, .130 }, H };
N l15n58[] = { { siwxg, .297 }, { se9wg, .439 }, { sippi, .149 }, H };
N l15n59[] = { { sghig, 1.933 }, H };
N l15n60[] = { { sZli, .204 }, { srZi, .111 }, H };
N l15n62[] = { { siwg, 2.174 }, { sky, .074 }, H };
N l15n63[] = { { svX, .434 }, { sgs, .204 }, { smuy, .186 }, H };
N l15n64[] = { { sQg, .627 }, { syig, .362 }, { spp, .111 }, H };
N l15n65[] = { { shyg, .195 }, H };
N l15n67[] = { { szm, .149 }, { smpg, .279 }, { sXxms, .223 }, H };
N l15n69[] = { { sti, .173 }, H };
N l15n71[] = { { sve9, .211 }, { snX, .074 }, { shXr, .111 }, H };
N l15n72[] = { { sgws, .334 }, { sqig, .307 }, { sgqX, .307 }, H };
N l15n73[] = { { smv, .285 }, { sghs, .223 }, H };
N l15n74[] = { { smZ, .124 }, H };
N l15n75[] = { { syg, .502 }, { srm, .149 }, { smww, .111 }, H };
N l15n76[] = { { sws, .161 }, { se9ig, .502 }, H };
N l15n77[] = { { sli, .173 }, H };
N l15n78[] = { { sXrZ, .167 }, H };
N l15n79[] = { { sixg, .557 }, { sgir, .502 }, { sYX, .074 }, H };
N l15n80[] = { { sgt, 1.115 }, H };
N l15n81[] = { { sgX, .966 }, { sXv, .334 }, H };
N l15n82[] = { { smiv, .149 }, H };
N l15n83[] = { { sjm, .149 }, { sXww, .111 }, H };
N l15n84[] = { { sgh27X, .223 }, H };
N l15n85[] = { { srwg, .697 }, { sty, .099 }, { sxvig, .223 }, H };
N l15n86[] = { { smwx, .111 }, H };
N l15n87[] = { { se9g, 1.171 }, { suymg, .334 }, H };
N l15n88[] = { { sgXy, .251 }, H };
N l15n89[] = { { sgxs, .223 }, { sXrh, .111 }, H };
N l15n90[] = { { smw, .471 }, H };
N l15n91[] = { { sig, 4.200 }, { smh, .111 }, { sZsqt, .149 }, H };
N l15n92[] = { { sZs, .421 }, H };
N l15n93[] = { { srxi, .167 }, { sghmv, .223 }, { srZl, .111 }, H };
N l15n94[] = { { swX, .211 }, { sXrwg, .334 }, H };
N l15n95[] = { { sgyr, .279 }, H };
N l15n97[] = { { sgu, .465 }, { svZ, .087 }, { sYpi, .130 }, { se8vig, .502 }, H };
N l15n98[] = { { sXw, .173 }, { sgY, .186 }, H };
N l15n99[] = { { sgpi, 1.422 }, { sgXz, .307 }, { sZsy, .130 }, { se9p, .195 }, H };
N l15n102[] = { { srxg, .780 }, { swe9, .124 }, H };
N l15n103[] = { { sip, .223 }, { srig, .334 }, H };
N l15n104[] = { { sguy, .697 }, { syq, .087 }, H };
N l15n105[] = { { sviv, .111 }, H };
N l15n106[] = { { ssm, .173 }, H };
N l15n107[] = { { smx, .471 }, { sxs, .111 }, { sgjs, .195 }, H };
N l15n108[] = { { smi, .372 }, H };
N l15n110[] = { { smuyi, .223 }, { smxe9, .149 }, { sZX, .099 }, { s27i, .074 }, H };
N l15n113[] = { { svw, .136 }, H };
N l15n114[] = { { srg, 1.059 }, { sgv, .483 }, { sxsy, .130 }, H };
N l15n115[] = { { sgZ, 1.041 }, { sXx, .273 }, { sps, .074 }, H };
N l15n116[] = { { suy, .496 }, { sviw, .204 }, H };
N l15n120[] = { { siq, .173 }, H };
N l15n121[] = { { syr, .235 }, { srhm, .149 }, H };
N l15n122[] = { { sgxv, .251 }, { sjg, .111 }, H };
N l15n123[] = { { sgtX, .557 }, { shs, .099 }, H };
N l15n124[] = { { sXvX, .111 }, H };
N l15n125[] = { { sxX, .149 }, { sgmp, .251 }, { smj, .099 }, H };
N l15n126[] = { { ssqt, .130 }, H };
N l15n127[] = { { sgZsq, .223 }, H };
N l15n130[] = { { svx, .173 }, { sgZsr, .483 }, H };
N l15n131[] = { { svi, .842 }, { sgw, .892 }, { sgtvs, .334 }, { sy78g, .223 }, { sgqXm, .260 }, H };
N l15n132[] = { { sgh, 2.583 }, { sXy, .285 }, { symg, .279 }, H };
N l15n133[] = { { spX, .434 }, { sirx, .483 }, { sxe9, .223 }, H };
N l15n134[] = { { sgiw, .223 }, H };
N l15n135[] = { { sghe9, .474 }, { sve8wg, .334 }, H };
N l15n136[] = { { swiv, .149 }, H };
N l15n137[] = { { sir, .842 }, { stm, .074 }, H };
N l15n138[] = { { sgwy, .307 }, H };
N l15n139[] = { { sghy, .195 }, H };
N l15n140[] = { { sgjv, .167 }, H };
N l15n141[] = { { shX, .124 }, { spe9, .099 }, H };
N l15n142[] = { { smk, .099 }, H };
N l15n144[] = { { sww, .235 }, H };
N l15n145[] = { { sgix, .446 }, { slm, .074 }, H };
N l15n146[] = { { sqs, .149 }, H };
N l15n147[] = { { sgmr, .251 }, H };
N l15n148[] = { { sgx, .502 }, H };
N l15n149[] = { { sgi, .929 }, { she9, .260 }, { sXz, .149 }, H };
N l15n151[] = { { sgpXg, .855 }, { sppi, .130 }, { sguyi, .223 }, H };
N l15n155[] = { { syt, .124 }, H };
N l15n156[] = { { sZlig, .260 }, H };
N l15n158[] = { { sxv, .310 }, { sXmv, .111 }, H };
N l15n159[] = { { sjsv, .130 }, H };
N l15n160[] = { { smvi, .242 }, { srr, .099 }, { sgqm, .195 }, { shXrw, .149 }, H };
N l15n161[] = { { swx, .260 }, H };
N l15n162[] = { { swi, .409 }, { sqir, .167 }, H };
N l15n163[] = { { sqt, .161 }, { sZiw, .186 }, { sguym, .334 }, H };
N l15n164[] = { { sqX, .211 }, H };
N l15n165[] = { { sgy, .186 }, H };
N l15n166[] = { { sgj, .539 }, H };
N l15n167[] = { { sxiv, .111 }, H };
N l15n168[] = { { s78g, .204 }, H };
N l15n169[] = { { sXmw, .204 }, { smvg, .195 }, { szs, .074 }, { stsr, .111 }, H };
N l15n170[] = { { se8v, .167 }, H };
N l15n171[] = { { sp27, .173 }, { swms, .130 }, H };
N l15n172[] = { { sqe9, .099 }, H };
N l15n173[] = { { slig, .223 }, H };
N l15n174[] = { { ssq, .186 }, { shv, .111 }, { syvw, .111 }, H };
N l15n175[] = { { sxw, .235 }, { sgirg, .334 }, { sghX, .195 }, H };
N l15n176[] = { { ssrw, .372 }, H };
N l15n177[] = { { srs, .099 }, { sZx, .099 }, { sXvg, .195 }, { sgXg, .195 }, H };
N l15n178[] = { { sZi, .310 }, { swy, .149 }, { smivg, .223 }, { s27m, .074 }, H };
N l15n179[] = { { sh27, .161 }, H };
N l15n180[] = { { sXmx, .260 }, H };
N l15n182[] = { { sgz, .149 }, H };
N l15n183[] = { { sgk, .279 }, H };
N l15n184[] = { { sXm, .496 }, { sgXyg, .297 }, { sgxsy, .260 }, H };
N l15n185[] = { { sgp27, .390 }, { sjs, .111 }, { szir, .111 }, H };
N l15n186[] = { { spiw, .576 }, { smwg, .362 }, H };
N l15n187[] = { { ssrx, .260 }, { se8w, .334 }, { szX, .087 }, H };
N l15n188[] = { { sgpiw, .855 }, { stp, .124 }, H };
N l15n189[] = { { syv, .359 }, H };
N l15n191[] = { { ssr, .979 }, { sgyrg, .260 }, H };
N l15n192[] = { { sgQ, .279 }, { sXzX, .111 }, H };
N l15n193[] = { { sxi, .434 }, H };
N l15n194[] = { { shiw, .204 }, { sXwg, .195 }, { svXm, .130 }, { sy27, .074 }, H };
N l15n195[] = { { sgpig, .966 }, { srX, .099 }, H };
N l15n196[] = { { sviZ, .149 }, H };
N l15n199[] = { { svm, .186 }, H };
N l15n200[] = { { sgl, .223 }, H };
N l15n201[] = { { spi, .966 }, { se9v, .390 }, { sgvi, .362 }, { svivg, .223 }, H };
N l15n202[] = { { sxms, .390 }, { sgZi, .362 }, { se9Z, .279 }, { siZx, .130 }, { sirZ, .111 }, H };
N l15n203[] = { { suyi, .353 }, { smxg, .502 }, { sre9, .136 }, { sjX, .074 }, H };
N l15n205[] = { { siv, .545 }, { sXmvi, .149 }, H };
N l15n206[] = { { siZ, .173 }, { syw, .124 }, { smxe9g, .260 }, H };
N l15n207[] = { { siqi, .149 }, H };
N l15n208[] = { { smsr, .595 }, H };
N l15n209[] = { { shi, .966 }, { sgtXv, .520 }, { svwg, .251 }, { sgjX, .167 }, H };
N l15n212[] = { { sgtXw, .223 }, H };
N l15n213[] = { { sirh, .130 }, H };
N l15n215[] = { { smg, .334 }, H };
N l15n217[] = { { sgm, .334 }, { syrg, .307 }, H };
N l15n218[] = { { sgwi, .418 }, { se9w, .362 }, { siwx, .223 }, H };
N l15n219[] = { { sghi, 2.007 }, H };
N l15n220[] = { { srhv, .149 }, H };
N l15n221[] = { { sgmpg, .297 }, H };
N l15n222[] = { { siw, 1.239 }, { sh27X, .111 }, H };
N l15n223[] = { { sXg, .780 }, { syx, .186 }, H };
N l15n224[] = { { syi, .273 }, { stsw, .111 }, H };
N l15n225[] = { { shy, .124 }, H };
N l15n226[] = { { sgqs, .307 }, { sgiwx, .260 }, H };
N l15n227[] = { { svig, .780 }, { smp, .223 }, H };
N l15n228[] = { { sXyg, .307 }, H };
N l15n229[] = { { spXg, .641 }, { sZl, .260 }, { srZ, .260 }, { sirxg, .557 }, { sxe9g, .362 }, H };
N l15n230[] = { { swm, .248 }, { siyv, .130 }, H };
N l15n231[] = { { stXv, .260 }, { stvs, .186 }, { swwi, .111 }, H };
N l15n232[] = { { sqi, .310 }, H };
N l15n233[] = { { sirg, .390 }, H };
N l15n234[] = { { sgn, .242 }, H };
N l15n235[] = { { se9x, .307 }, { sgZl, .251 }, { sXp, .111 }, { sghyg, .223 }, H };
N l15n236[] = { { se9i, .279 }, { sjv, .087 }, H };
N l15n238[] = { { svg, .966 }, H };
N l15n239[] = { { six, .322 }, { sts, .285 }, H };
N l15n241[] = { { sgixg, .595 }, H };
N l15n242[] = { { stXw, .130 }, H };
N l15n244[] = { { smq, .087 }, H };
N l15n245[] = { { srw, .434 }, { sxvi, .167 }, { swmsr, .173 }, H };
N l15n246[] = { { srh, .273 }, { sZm, .186 }, { sXxm, .186 }, H };
N l15n247[] = { { suym, .167 }, { sls, .074 }, H };
N l15n248[] = { { sivX, .111 }, H };
N l15n249[] = { { sghXr, .223 }, H };
N l15n251[] = { { shmv, .111 }, H };
N l15n252[] = { { sXq, .074 }, H };
N l15n254[] = { { sXrw, .186 }, { sqirx, .198 }, H };
N l15n255[] = { { szi, .235 }, { sXtt, .149 }, { ssvx, .130 }, H };

D l15_d = {
	"french",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.019, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.140, 0.014, 0.068, 0.091, 0.277, 0.032, 0.026, 0.021, 0.150, 0.007, 0.003, 0.099, 0.052, 0.140, 0.107,
	    0.064, 0.020, 0.141, 0.167, 0.127, 0.103, 0.024, 0.001, 0.008, 0.006, 0.002, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, 0.001, V, V, V, V, V, V, V, V, V, V, V, V,
	    0.017, V, 0.001, V, V, V, V, 0.002, 0.027, 0.142, 0.009, V, V, V, V, V,
	    V, V, V, V, 0.002, V, V, V, V, 0.003, V, V, V, V, V, V },
	{ l15n0, l15n1, l15n2, l15n3, X, l15n5, l15n6, l15n7, X, l15n9, l15n10, l15n11, l15n12, l15n13, l15n14, l15n15,
	    l15n16, X, l15n18, X, l15n20, l15n21, l15n22, X, l15n24, l15n25, l15n26, l15n27, l15n28, l15n29, X, l15n31,
	    l15n32, l15n33, l15n34, l15n35, l15n36, X, l15n38, l15n39, l15n40, l15n41, l15n42, l15n43, l15n44, l15n45, l15n46, l15n47,
	    l15n48, l15n49, X, X, l15n52, X, l15n54, l15n55, l15n56, X, l15n58, l15n59, l15n60, X, l15n62, l15n63,
	    l15n64, l15n65, X, l15n67, X, l15n69, X, l15n71, l15n72, l15n73, l15n74, l15n75, l15n76, l15n77, l15n78, l15n79,
	    l15n80, l15n81, l15n82, l15n83, l15n84, l15n85, l15n86, l15n87, l15n88, l15n89, l15n90, l15n91, l15n92, l15n93, l15n94, l15n95,
	    X, l15n97, l15n98, l15n99, X, X, l15n102, l15n103, l15n104, l15n105, l15n106, l15n107, l15n108, X, l15n110, X,
	    X, l15n113, l15n114, l15n115, l15n116, X, X, X, l15n120, l15n121, l15n122, l15n123, l15n124, l15n125, l15n126, l15n127,
	    X, X, l15n130, l15n131, l15n132, l15n133, l15n134, l15n135, l15n136, l15n137, l15n138, l15n139, l15n140, l15n141, l15n142, X,
	    l15n144, l15n145, l15n146, l15n147, l15n148, l15n149, X, l15n151, X, X, X, l15n155, l15n156, X, l15n158, l15n159,
	    l15n160, l15n161, l15n162, l15n163, l15n164, l15n165, l15n166, l15n167, l15n168, l15n169, l15n170, l15n171, l15n172, l15n173, l15n174, l15n175,
	    l15n176, l15n177, l15n178, l15n179, l15n180, X, l15n182, l15n183, l15n184, l15n185, l15n186, l15n187, l15n188, l15n189, X, l15n191,
	    l15n192, l15n193, l15n194, l15n195, l15n196, X, X, l15n199, l15n200, l15n201, l15n202, l15n203, X, l15n205, l15n206, l15n207,
	    l15n208, l15n209, X, X, l15n212, l15n213, X, l15n215, X, l15n217, l15n218, l15n219, l15n220, l15n221, l15n222, l15n223,
	    l15n224, l15n225, l15n226, l15n227, l15n228, l15n229, l15n230, l15n231, l15n232, l15n233, l15n234, l15n235, l15n236, X, l15n238, l15n239,
	    X, l15n241, l15n242, X, l15n244, l15n245, l15n246, l15n247, l15n248, l15n249, X, l15n251, l15n252, X, l15n254, l15n255 }
};

//
// Lng: georgian
// Enc: unknown
//

S scac8[] = { 202, 200, 0 };
S sc3c0[] = { 195, 192, 0 };
S sc8B[] = { 200, 209, 0 };
S sc0cc[] = { 192, 204, 0 };
S sc4c1[] = { 196, 193, 0 };
S sBc0[] = { 209, 192, 0 };
S scbc0[] = { 203, 192, 0 };
S scac8g[] = { 202, 200, a };
S sc2c0[] = { 194, 192, 0 };
S sAc8[] = { 208, 200, 0 };
S sc8Bg[] = { 200, 209, a };
S sDca[] = { 211, 202, 0 };
S sc4ca[] = { 196, 202, 0 };
S sc0c5[] = { 192, 197, 0 };
S sgc3c0[] = { 32, 195, 192, 0 };
S sc3c0g[] = { 195, 192, a };
S sc5c0[] = { 197, 192, 0 };
S sc4A[] = { 196, 208, 0 };
S sc0cb[] = { 192, 203, 0 };
S sc5c4[] = { 197, 196, 0 };
S sccc8[] = { 204, 200, 0 };
S sAc0[] = { 208, 192, 0 };
S sc8ca[] = { 200, 202, 0 };
S sc0ca[] = { 192, 202, 0 };
S sc5c8[] = { 197, 200, 0 };
S sc0c3[] = { 192, 195, 0 };
S sc1c0[] = { 193, 192, 0 };
S sAcd[] = { 208, 205, 0 };
S sgc2c0[] = { 32, 194, 192, 0 };
S sc4cc[] = { 196, 204, 0 };
S sc1c8[] = { 193, 200, 0 };
S sc0B[] = { 192, 209, 0 };
S sc8c7[] = { 200, 199, 0 };
S sc4B[] = { 196, 209, 0 };
S scdc1[] = { 205, 193, 0 };
S sc7c0[] = { 199, 192, 0 };
S sc3c4[] = { 195, 196, 0 };
S sIc8[] = { 216, 200, 0 };
S sgBc0[] = { 32, 209, 192, 0 };
S scacd[] = { 202, 205, 0 };
S sgcbc0[] = { 32, 203, 192, 0 };
S scbcd[] = { 203, 205, 0 };
S sDcac8[] = { 211, 202, 200, 0 };
S sc8c0[] = { 200, 192, 0 };
S scbc4[] = { 203, 196, 0 };
S sc4cac8[] = { 196, 202, 200, 0 };
S sOc4[] = { 222, 196, 0 };
S sc8cc[] = { 200, 204, 0 };
S sc4c1c8[] = { 196, 193, 200, 0 };
S sc8cac8[] = { 200, 202, 200, 0 };
S scdA[] = { 205, 208, 0 };
S sccc4[] = { 204, 196, 0 };
S sc8Bc0[] = { 200, 209, 192, 0 };
S sIc8g[] = { 216, 200, a };
S sIc4[] = { 216, 196, 0 };
S sAc4[] = { 208, 196, 0 };
S sc1c0g[] = { 193, 192, a };
S sc0ccg[] = { 192, 204, a };
S sDcac8g[] = { 211, 202, 200, a };
S scbc8[] = { 203, 200, 0 };
S sAc8g[] = { 208, 200, a };
S sOc0[] = { 222, 192, 0 };
S sc0ccc8[] = { 192, 204, 200, 0 };
S sgIc4[] = { 32, 216, 196, 0 };
S sgc3c0g[] = { 32, 195, 192, a };
S sc4Bg[] = { 196, 209, a };
S sc4c1c0[] = { 196, 193, 192, 0 };
S sccc3[] = { 204, 195, 0 };
S sccc8g[] = { 204, 200, a };
S sc4cb[] = { 196, 203, 0 };
S sc8c0g[] = { 200, 192, a };
S scac8B[] = { 202, 200, 209, 0 };
S scac4[] = { 202, 196, 0 };
S sc0c2[] = { 192, 194, 0 };
S sccc0[] = { 204, 192, 0 };
S sc7c8[] = { 199, 200, 0 };
S scdB[] = { 205, 209, 0 };
S sc7c5[] = { 199, 197, 0 };
S sc0c3g[] = { 192, 195, a };
S sOc5[] = { 222, 197, 0 };
S scac0[] = { 202, 192, 0 };
S sgcbc4[] = { 32, 203, 196, 0 };
S sc6c4[] = { 198, 196, 0 };
S scbD[] = { 203, 211, 0 };
S sc8cac8g[] = { 200, 202, 200, a };
S sgAcd[] = { 32, 208, 205, 0 };
S sc4Ac7[] = { 196, 208, 199, 0 };
S sc0cac8[] = { 192, 202, 200, 0 };
S sc0Ac7[] = { 192, 208, 199, 0 };
S sc7c8g[] = { 199, 200, a };
S sc2c8[] = { 194, 200, 0 };
S sc5c4ca[] = { 197, 196, 202, 0 };
S sBc0g[] = { 209, 192, a };
S scdcb[] = { 205, 203, 0 };
S sBc4[] = { 209, 196, 0 };
S sc0O[] = { 192, 222, 0 };
S sFc0[] = { 213, 192, 0 };
S scdc1c0[] = { 205, 193, 192, 0 };
S sCc0[] = { 210, 192, 0 };
S sc5c8B[] = { 197, 200, 209, 0 };
S sc0Bg[] = { 192, 209, a };
S sc9c0[] = { 201, 192, 0 };
S sc0Ag[] = { 192, 208, a };
S sc4c1c0g[] = { 196, 193, 192, a };
S sc4c3[] = { 196, 195, 0 };
S sEc4[] = { 212, 196, 0 };
S sc3c8[] = { 195, 200, 0 };
S sBc8[] = { 209, 200, 0 };
S sgc4A[] = { 32, 196, 208, 0 };
S sc2c0cc[] = { 194, 192, 204, 0 };
S sc4c5[] = { 196, 197, 0 };
S sAc4c1[] = { 208, 196, 193, 0 };
S sc0c0[] = { 192, 192, 0 };
S sc0I[] = { 192, 216, 0 };
S sc8c3[] = { 200, 195, 0 };
S sc4cac8g[] = { 196, 202, 200, a };
S sc8c7g[] = { 200, 199, a };
S sgc0Ag[] = { 32, 192, 208, a };
S sc4ccg[] = { 196, 204, a };
S sgc4Ac7[] = { 32, 196, 208, 199, 0 };
S sc0Ac0[] = { 192, 208, 192, 0 };
S sc7D[] = { 199, 211, 0 };
S sc5ca[] = { 197, 202, 0 };
S sgcbcd[] = { 32, 203, 205, 0 };
S sc1c4[] = { 193, 196, 0 };
S sc2cd[] = { 194, 205, 0 };
S sgc8B[] = { 32, 200, 209, 0 };
S scbc0A[] = { 203, 192, 208, 0 };
S sIc0[] = { 216, 192, 0 };
S sEc8[] = { 212, 200, 0 };
S sc5c0ca[] = { 197, 192, 202, 0 };
S sc0F[] = { 192, 213, 0 };
S sc0c8[] = { 192, 200, 0 };
S sc0ccc8g[] = { 192, 204, 200, a };
S sccc4c1[] = { 204, 196, 193, 0 };
S scaB[] = { 202, 209, 0 };
S sgc0cb[] = { 32, 192, 203, 0 };
S sgc4B[] = { 32, 196, 209, 0 };
S scdca[] = { 205, 202, 0 };
S scaBg[] = { 202, 209, a };
S sc4ccc8[] = { 196, 204, 200, 0 };
S sgOc0[] = { 32, 222, 192, 0 };
S sc8Bc0g[] = { 200, 209, 192, a };
S sc0c6[] = { 192, 198, 0 };
S sc4E[] = { 196, 212, 0 };
S sc8c2[] = { 200, 194, 0 };
S sDAc8[] = { 211, 208, 200, 0 };
S sc7F[] = { 199, 213, 0 };
S sAc0g[] = { 208, 192, a };
S sgc0Ac0[] = { 32, 192, 208, 192, 0 };
S sgBO[] = { 32, 209, 222, 0 };
S sc1D[] = { 193, 211, 0 };
S sc4c7[] = { 196, 199, 0 };
S sc7c0g[] = { 199, 192, a };
S sc5c3[] = { 197, 195, 0 };
S sc9c8[] = { 201, 200, 0 };
S sc0Ac8[] = { 192, 208, 200, 0 };
S sc0c3c0[] = { 192, 195, 192, 0 };
S sc2c0ccg[] = { 194, 192, 204, a };
S sCc8[] = { 210, 200, 0 };
S sc0C[] = { 192, 210, 0 };
S sc0K[] = { 192, 218, 0 };
S sc0c2c0[] = { 192, 194, 192, 0 };
S sc4Ec4[] = { 196, 212, 196, 0 };
S sc2c0cb[] = { 194, 192, 203, 0 };
S sCc4[] = { 210, 196, 0 };
S sgc2c0cb[] = { 32, 194, 192, 203, 0 };
S sc5c0g[] = { 197, 192, a };
S sAc3[] = { 208, 195, 0 };
S sc0cbcd[] = { 192, 203, 205, 0 };
S sc8K[] = { 200, 218, 0 };
S sHc5[] = { 215, 197, 0 };
S sc1c8B[] = { 193, 200, 209, 0 };
S sccc3c0[] = { 204, 195, 192, 0 };
S sc0G[] = { 192, 214, 0 };
S sccc3c0g[] = { 204, 195, 192, a };
S sc0cbc8[] = { 192, 203, 200, 0 };
S sgIc0[] = { 32, 216, 192, 0 };
S sc0c5c0[] = { 192, 197, 192, 0 };
S scbDca[] = { 203, 211, 202, 0 };
S sc4c1Dca[] = { 196, 193, 211, 202, 0 };
S sOc0ca[] = { 222, 192, 202, 0 };
S sc0E[] = { 192, 212, 0 };
S sc7c0c5[] = { 199, 192, 197, 0 };
S sFc0A[] = { 213, 192, 208, 0 };
S sc4c1D[] = { 196, 193, 211, 0 };
S sc0c5c8[] = { 192, 197, 200, 0 };
S scbc4Ec4[] = { 203, 196, 212, 196, 0 };
S scac8c0[] = { 202, 200, 192, 0 };
S sc2A[] = { 194, 208, 0 };
S scbc4E[] = { 203, 196, 212, 0 };
S sBOc5[] = { 209, 222, 197, 0 };
S sc6c4g[] = { 198, 196, a };
S sc5B[] = { 197, 209, 0 };
S scac8Bg[] = { 202, 200, 209, a };
S scacdg[] = { 202, 205, a };
S sc3A[] = { 195, 208, 0 };
S scccd[] = { 204, 205, 0 };
S sCcd[] = { 210, 205, 0 };
S sFc0Ac7[] = { 213, 192, 208, 199, 0 };
S sc1Dca[] = { 193, 211, 202, 0 };
S sBc0O[] = { 209, 192, 222, 0 };
S sgc7c5[] = { 32, 199, 197, 0 };
S sc8D[] = { 200, 211, 0 };
S sc3c2[] = { 195, 194, 0 };
S sc0c1[] = { 192, 193, 0 };
S sc8c5[] = { 200, 197, 0 };
S sAc7c8[] = { 208, 199, 200, 0 };
S sc0cbc0[] = { 192, 203, 192, 0 };
S sc4c1c8B[] = { 196, 193, 200, 209, 0 };
S scdcc[] = { 205, 204, 0 };
S sgcbc4E[] = { 32, 203, 196, 212, 0 };
S sBC[] = { 209, 210, 0 };
S sc5c8c7[] = { 197, 200, 199, 0 };
S scbc0cc[] = { 203, 192, 204, 0 };
S sc0Ic8[] = { 192, 216, 200, 0 };
S sc5c4cac8[] = { 197, 196, 202, 200, 0 };
S scdBg[] = { 205, 209, a };
S scbc0g[] = { 203, 192, a };
S sDcc[] = { 211, 204, 0 };
S sc8c9[] = { 200, 201, 0 };
S sc5c8Bg[] = { 197, 200, 209, a };
S sHcd[] = { 215, 205, 0 };
S sMc4[] = { 220, 196, 0 };
S sAc7c8g[] = { 208, 199, 200, a };
S scac8c0g[] = { 202, 200, 192, a };
S sgc4Bg[] = { 32, 196, 209, a };
S sOc4ca[] = { 222, 196, 202, 0 };
S sgBc0O[] = { 32, 209, 192, 222, 0 };
S scbc8ca[] = { 203, 200, 202, 0 };
S scdcacd[] = { 205, 202, 205, 0 };
S sc2c0cbcd[] = { 194, 192, 203, 205, 0 };
S sAc8B[] = { 208, 200, 209, 0 };
S sc2c8g[] = { 194, 200, a };
S scdc3[] = { 205, 195, 0 };
S scdc1c0g[] = { 205, 193, 192, a };
S sc8ccc3[] = { 200, 204, 195, 0 };
S scec8[] = { 206, 200, 0 };
S sc2c0c3[] = { 194, 192, 195, 0 };
S sc4Ac7c8[] = { 196, 208, 199, 200, 0 };
S sc4c1c8g[] = { 196, 193, 200, a };
S scdc2[] = { 205, 194, 0 };
S sc1c8g[] = { 193, 200, a };
S sOcd[] = { 222, 205, 0 };
S sJc4[] = { 217, 196, 0 };
S sc0c5B[] = { 192, 197, 209, 0 };
S scdc1c8[] = { 205, 193, 200, 0 };
S sFA[] = { 213, 208, 0 };
S sc7c5c0ca[] = { 199, 197, 192, 202, 0 };
S sc0c5c8B[] = { 192, 197, 200, 209, 0 };
S sCc8g[] = { 210, 200, a };
S scac4c1[] = { 202, 196, 193, 0 };
S scbc3[] = { 203, 195, 0 };
S sc1Dcac8[] = { 193, 211, 202, 200, 0 };
S sc0cac8g[] = { 192, 202, 200, a };
S sc1c8c7[] = { 193, 200, 199, 0 };
S sgFc0[] = { 32, 213, 192, 0 };
S sc4ccc8g[] = { 196, 204, 200, a };
S sc0Oc4[] = { 192, 222, 196, 0 };
S sMc8[] = { 220, 200, 0 };
S sc0Bc0[] = { 192, 209, 192, 0 };
S sKOc4[] = { 218, 222, 196, 0 };
S sc1c8Bg[] = { 193, 200, 209, a };
S sc7Dca[] = { 199, 211, 202, 0 };
S sc5c0cc[] = { 197, 192, 204, 0 };
S sc0caO[] = { 192, 202, 222, 0 };
S sAc0c5[] = { 208, 192, 197, 0 };
S sIc0cbc8[] = { 216, 192, 203, 200, 0 };
S sc0cbc8ca[] = { 192, 203, 200, 202, 0 };
S sAc7D[] = { 208, 199, 211, 0 };
S sc8C[] = { 200, 210, 0 };
S sc6c8[] = { 198, 200, 0 };
S sDcag[] = { 211, 202, a };
S scdc4[] = { 205, 196, 0 };
S sccc8ca[] = { 204, 200, 202, 0 };
S sc1A[] = { 193, 208, 0 };
S sAcdcb[] = { 208, 205, 203, 0 };
S sGc5[] = { 214, 197, 0 };
S sAcdc1[] = { 208, 205, 193, 0 };
S sgcbc6[] = { 32, 203, 198, 0 };
S sOc8[] = { 222, 200, 0 };
S scdc5[] = { 205, 197, 0 };
S sAc0c3[] = { 208, 192, 195, 0 };
S sgc9c0[] = { 32, 201, 192, 0 };
S sFc5[] = { 213, 197, 0 };
S sc2c4[] = { 194, 196, 0 };
S sEca[] = { 212, 202, 0 };
S sc4D[] = { 196, 211, 0 };
S sgAcdcb[] = { 32, 208, 205, 203, 0 };
S sgc7c5c0[] = { 32, 199, 197, 192, 0 };
S sBOc5c0[] = { 209, 222, 197, 192, 0 };
S sgc8Bg[] = { 32, 200, 209, a };
S sc0Ac7D[] = { 192, 208, 199, 211, 0 };
S sc0Ic8g[] = { 192, 216, 200, a };
S scdcbg[] = { 205, 203, a };
S scbc6[] = { 203, 198, 0 };
S scbc7[] = { 203, 199, 0 };
S sDAc8g[] = { 211, 208, 200, a };
S sIc0cb[] = { 216, 192, 203, 0 };
S sc5c4c1[] = { 197, 196, 193, 0 };
S sAcb[] = { 208, 203, 0 };
S sc3Acd[] = { 195, 208, 205, 0 };
S sc2c0c3c0[] = { 194, 192, 195, 192, 0 };
S sc5c0A[] = { 197, 192, 208, 0 };
S sc5c3c4[] = { 197, 195, 196, 0 };
S sAc7Dca[] = { 208, 199, 211, 202, 0 };
S scacdc1[] = { 202, 205, 193, 0 };
S scac8Bc0[] = { 202, 200, 209, 192, 0 };
S sc5c4cc[] = { 197, 196, 204, 0 };
S sc0c2c0cc[] = { 192, 194, 192, 204, 0 };
S scaO[] = { 202, 222, 0 };
S sc5Bg[] = { 197, 209, a };
S sgIc0cb[] = { 32, 216, 192, 203, 0 };
S sc8c7c0[] = { 200, 199, 192, 0 };
S sc7c5c0[] = { 199, 197, 192, 0 };
S sAc3c0[] = { 208, 195, 192, 0 };
S sgAc8[] = { 32, 208, 200, 0 };
S sOc5c0[] = { 222, 197, 192, 0 };
S sc4cac8B[] = { 196, 202, 200, 209, 0 };
S sgBOc5[] = { 32, 209, 222, 197, 0 };
S sc1c0B[] = { 193, 192, 209, 0 };
S sc4Ac4[] = { 196, 208, 196, 0 };
S sc3c2c0[] = { 195, 194, 192, 0 };
S sc7c4[] = { 199, 196, 0 };
S sHc5c0[] = { 215, 197, 192, 0 };
S sc8c2c8[] = { 200, 194, 200, 0 };
S sCc0cc[] = { 210, 192, 204, 0 };
S sgCc0[] = { 32, 210, 192, 0 };
S sCD[] = { 210, 211, 0 };
S sc3cd[] = { 195, 205, 0 };
S sc0Ac0g[] = { 192, 208, 192, a };
S sAc8ca[] = { 208, 200, 202, 0 };
S sc0c5Bg[] = { 192, 197, 209, a };
S sc3c0B[] = { 195, 192, 209, 0 };
S sgOc0ca[] = { 32, 222, 192, 202, 0 };
S sc8FA[] = { 200, 213, 208, 0 };
S sAcdB[] = { 208, 205, 209, 0 };
S sOc0caO[] = { 222, 192, 202, 222, 0 };
S sOc5c8[] = { 222, 197, 200, 0 };
S sccC[] = { 204, 210, 0 };
S sOcdcacd[] = { 222, 205, 202, 205, 0 };
S sc8c3c4[] = { 200, 195, 196, 0 };
S sc4caB[] = { 196, 202, 209, 0 };
S sccc4c1c8[] = { 204, 196, 193, 200, 0 };
S sgc7Dg[] = { 32, 199, 211, a };
S sccc8cac8[] = { 204, 200, 202, 200, 0 };
S sgc2c0c3[] = { 32, 194, 192, 195, 0 };
S sgcbc0c2[] = { 32, 203, 192, 194, 0 };
S sgAc0[] = { 32, 208, 192, 0 };
S sc4C[] = { 196, 210, 0 };
S sDAc0[] = { 211, 208, 192, 0 };

N l16n0[] = { { sc0c0, .313 }, H };
N l16n1[] = { { sgBc0, .683 }, { scbc4Ec4, .456 }, H };
N l16n2[] = { { sgc2c0, .854 }, { sc2c0cc, .512 }, { sc1c8Bg, .512 }, { sccc8cac8, .285 }, H };
N l16n3[] = { { sccc4c1, .427 }, H };
N l16n5[] = { { sgF, .133 }, H };
N l16n6[] = { { sgc6, .133 }, H };
N l16n7[] = { { sc1c8g, .448 }, H };
N l16n8[] = { { sc8A, .370 }, H };
N l16n11[] = { { sCcd, .228 }, H };
N l16n12[] = { { scdcacd, .299 }, H };
N l16n13[] = { { sBO, .399 }, H };
N l16n15[] = { { sBc0, 1.651 }, H };
N l16n16[] = { { sc0A, 2.022 }, { sc1Dca, .342 }, H };
N l16n17[] = { { sc0c1, .199 }, H };
N l16n18[] = { { sAc2, .199 }, { sgCc0, .142 }, H };
N l16n19[] = { { sgc3c0, 1.139 }, { scacd, .683 }, H };
N l16n20[] = { { scdBg, .448 }, H };
N l16n22[] = { { sCc8g, .384 }, { sEca, .171 }, { sc0Ac7D, .342 }, H };
N l16n23[] = { { sgc7, .475 }, { sc9c0, .342 }, H };
N l16n24[] = { { sAcdc1, .256 }, H };
N l16n25[] = { { sc8B, 2.249 }, { sc4Ac7, .598 }, { scac8Bg, .683 }, { scbc0cc, .299 }, { sDcc, .199 }, H };
N l16n26[] = { { sc8c2, .285 }, { sc1c0B, .214 }, H };
N l16n27[] = { { sc2cd, .313 }, H };
N l16n28[] = { { sc7D, .313 }, { sc5Bg, .384 }, H };
N l16n29[] = { { sc7c4, .142 }, H };
N l16n30[] = { { scac8g, 3.331 }, { sc5c8B, .512 }, { sc4cac8g, .940 }, { sHc5, .256 }, H };
N l16n31[] = { { sc1c0, .911 }, H };
N l16n33[] = { { sc0B, .826 }, { sc4caB, .214 }, H };
N l16n34[] = { { sc0c2, .456 }, H };
N l16n35[] = { { sc5c8, .968 }, { sgc8B, .313 }, { sAc3, .256 }, H };
N l16n36[] = { { sKO, .342 }, H };
N l16n37[] = { { sc4c1c8, .897 }, { sc8ccc3, .299 }, H };
N l16n38[] = { { sc4ca, 1.167 }, { sc2c8g, .448 }, { sAc8ca, .214 }, H };
N l16n40[] = { { sgc8, .683 }, H };
N l16n41[] = { { sgc4Ac7, .418 }, H };
N l16n42[] = { { sgcbcd, .313 }, { sc8C, .171 }, { sOc8, .171 }, { sc5c4c1, .256 }, H };
N l16n43[] = { { sc8c3, .313 }, H };
N l16n44[] = { { sIc4, .541 }, { sc0ccg, 1.217 }, H };
N l16n45[] = { { sc4c1c0g, 1.025 }, H };
N l16n46[] = { { sc7c5, .427 }, { sCc0, .342 }, H };
N l16n47[] = { { sc1A, .171 }, H };
N l16n48[] = { { sc0Ic8, .299 }, H };
N l16n49[] = { { sc4cac8B, .342 }, H };
N l16n50[] = { { scbcd, .683 }, { sc0C, .256 }, H };
N l16n51[] = { { sc0c3, .911 }, H };
N l16n52[] = { { sAc4, .541 }, { sc1c8c7, .256 }, { sc0caO, .256 }, { scaO, .171 }, H };
N l16n54[] = { { scac0, .427 }, H };
N l16n55[] = { { sc4cb, .484 }, { sOc5c0, .256 }, H };
N l16n56[] = { { sgI, .626 }, H };
N l16n57[] = { { sc7g, .811 }, { sgc9, .304 }, { sc7c0g, .577 }, H };
N l16n58[] = { { sc8cac8, .897 }, { scec8, .199 }, { sc5c3c4, .256 }, { sc3cd, .142 }, H };
N l16n59[] = { { sc8D, .199 }, H };
N l16n60[] = { { sc4Ec4, .384 }, { scdc1c8, .256 }, { sc3Acd, .256 }, { sgOc0ca, .190 }, H };
N l16n61[] = { { scdca, .285 }, H };
N l16n62[] = { { sc2c0, 1.452 }, { sc7F, .285 }, H };
N l16n63[] = { { sgc4Bg, .266 }, H };
N l16n64[] = { { sc4ccc8g, .512 }, H };
N l16n65[] = { { sBC, .199 }, H };
N l16n66[] = { { sc0cac8, .555 }, { sc6c8, .171 }, H };
N l16n67[] = { { sgcbc4E, .266 }, H };
N l16n68[] = { { scdc1c0g, .598 }, H };
N l16n69[] = { { sc5ca, .313 }, { scbc0A, .470 }, { sgFc0, .171 }, H };
N l16n70[] = { { scbDca, .342 }, H };
N l16n71[] = { { sccc3c0g, .769 }, H };
N l16n72[] = { { sc4cc, .826 }, { sgAc8, .171 }, H };
N l16n73[] = { { sc5c0ca, .427 }, { sgJ, .133 }, H };
N l16n75[] = { { sgBO, .256 }, { sJc4, .171 }, { sgc2c0c3, .190 }, H };
N l16n77[] = { { sc8c5, .199 }, { sc8FA, .214 }, H };
N l16n78[] = { { scdcb, .370 }, { sc2A, .228 }, H };
N l16n80[] = { { sAg, .726 }, { sc0Ac0, .470 }, { sAc0g, .641 }, { sOc0ca, .342 }, { sc7c0c5, .342 }, { sc0c5B, .256 }, H };
N l16n81[] = { { scccd, .228 }, { sAc0c3, .256 }, H };
N l16n83[] = { { sBc4, .370 }, { sc0cbc8, .342 }, H };
N l16n84[] = { { sc0E, .228 }, H };
N l16n85[] = { { scbc0, 1.509 }, { sc0c5, 1.139 }, { sDAc8g, .512 }, H };
N l16n87[] = { { scaB, .285 }, { sDcag, .384 }, H };
N l16n88[] = { { sc8g, 6.620 }, { sc8c0g, 1.089 }, { sc3c0B, .214 }, H };
N l16n89[] = { { sc8Bc0, .854 }, { sgc0cb, .285 }, H };
N l16n90[] = { { sgK, .266 }, H };
N l16n91[] = { { sgcb, 1.519 }, { sccc4c1c8, .285 }, H };
N l16n92[] = { { sccc8g, 1.089 }, H };
N l16n93[] = { { sc3c0, 2.278 }, { sDA, .569 }, { sc8F, .285 }, H };
N l16n94[] = { { sc6c4g, .512 }, { scac8c0g, .598 }, { sc2c0cbcd, .399 }, { scacdc1, .256 }, { sHc5c0, .214 }, H };
N l16n95[] = { { scdcc, .199 }, { sAc7c8g, .598 }, { sc5c0cc, .256 }, H };
N l16n96[] = { { sc0g, 6.107 }, { sc0c5c8B, .342 }, H };
N l16n97[] = { { sc7c8, .456 }, { sc0Bc0, .256 }, H };
N l16n98[] = { { sc1D, .256 }, { sc2c0ccg, .769 }, { sc0c2c0, .384 }, H };
N l16n99[] = { { sc1c4, .313 }, { sgc2c0cb, .342 }, { sAc3c0, .256 }, H };
N l16n100[] = { { sc0ccc8, .769 }, H };
N l16n101[] = { { sc0F, .285 }, H };
N l16n102[] = { { sc0c6, .285 }, H };
N l16n103[] = { { sAc7, .769 }, { sAc0c5, .256 }, H };
N l16n104[] = { { sc1Dcac8, .342 }, H };
N l16n106[] = { { sc0Oc4, .256 }, H };
N l16n108[] = { { sgcc, .209 }, H };
N l16n109[] = { { sc3A, .228 }, H };
N l16n110[] = { { sc7c5c0, .256 }, H };
N l16n111[] = { { sBg, 4.869 }, { sc8c7, .826 }, { sBc0g, .833 }, H };
N l16n112[] = { { sIc8, .712 }, { sc0Ag, .769 }, H };
N l16n113[] = { { sc4Ac7c8, .399 }, { sCD, .142 }, H };
N l16n114[] = { { sCc4, .256 }, H };
N l16n115[] = { { sgc3c0g, .683 }, { sc0c3c0, .384 }, { scacdg, .512 }, { sAc8B, .299 }, H };
N l16n116[] = { { sccc0, .456 }, H };
N l16n118[] = { { sc0G, .256 }, H };
N l16n120[] = { { sAc8, 1.395 }, { sgIc0, .228 }, { sAc7D, .256 }, H };
N l16n121[] = { { sc8Bg, 2.691 }, { sgc9c0, .171 }, H };
N l16n122[] = { { scac4, .456 }, H };
N l16n123[] = { { sFc0A, .342 }, H };
N l16n124[] = { { sgM, .285 }, H };
N l16n126[] = { { sc5c8Bg, .598 }, H };
N l16n127[] = { { sc1c0g, 1.217 }, { sgAcd, .399 }, { sAc4c1, .470 }, { sc3c2, .199 }, { sOcd, .199 }, H };
N l16n129[] = { { sc0Bg, .769 }, H };
N l16n130[] = { { sc2c4, .171 }, H };
N l16n131[] = { { sgc8Bg, .228 }, H };
N l16n132[] = { { sBOc5, .342 }, H };
N l16n133[] = { { sc4c1c8g, .598 }, H };
N l16n134[] = { { sKg, .641 }, { sAcdcb, .256 }, H };
N l16n136[] = { { sc0c8, .285 }, { scbc3, .171 }, { sgc7Dg, .190 }, H };
N l16n138[] = { { sc0cbcd, .384 }, H };
N l16n139[] = { { sFc0, .342 }, { scbc8ca, .299 }, { sc5c0A, .256 }, H };
N l16n140[] = { { sc4A, 1.082 }, H };
N l16n141[] = { { sc4c1, 1.680 }, { sc5c4ca, .555 }, H };
N l16n142[] = { { sgc7c5, .228 }, { sgce, .114 }, H };
N l16n143[] = { { sDcac8, 1.025 }, { sOc5c8, .214 }, H };
N l16n144[] = { { sgc0A, .655 }, { sKOc4, .256 }, { sc0Ic8g, .512 }, H };
N l16n145[] = { { sc8c9, .199 }, H };
N l16n147[] = { { sc0c3g, .961 }, H };
N l16n148[] = { { sOc4ca, .299 }, { sOcdcacd, .285 }, H };
N l16n149[] = { { sc0c5c0, .342 }, H };
N l16n150[] = { { scag, .555 }, H };
N l16n151[] = { { sBc8, .342 }, { sc8c3c4, .214 }, H };
N l16n152[] = { { scbD, .399 }, { sc0I, .313 }, { sc4c1c8B, .399 }, H };
N l16n153[] = { { scbc4, .626 }, { sBc0O, .342 }, H };
N l16n154[] = { { sc8cac8g, 1.196 }, { sgBOc5, .228 }, H };
N l16n155[] = { { sc5c0, 1.110 }, { sgcbc0, .683 }, { sgBc0O, .266 }, { sFA, .171 }, H };
N l16n157[] = { { sc4B, .740 }, { sc0Ac7, .555 }, { sDAc0, .214 }, H };
N l16n158[] = { { sgO, .418 }, { sc4c1D, .342 }, H };
N l16n159[] = { { sc9c8, .256 }, { sc2c0c3, .299 }, H };
N l16n160[] = { { sgc0, 1.063 }, H };
N l16n161[] = { { sc3c4, .712 }, { sIc0cb, .256 }, H };
N l16n162[] = { { sc8ca, .997 }, { sOc0, .512 }, { sc1c8B, .384 }, { sc0cac8g, .512 }, H };
N l16n163[] = { { scdA, .598 }, { sc5c4cc, .256 }, H };
N l16n164[] = { { scdc1, .740 }, { sgIc4, .512 }, H };
N l16n166[] = { { sHcd, .199 }, { sccC, .142 }, H };
N l16n167[] = { { sc1c8, .826 }, { sccc3, .484 }, H };
N l16n168[] = { { sc4ccg, .705 }, { sc0Ac8, .384 }, { sMc4, .199 }, H };
N l16n170[] = { { sc0ca, .997 }, { sAK, .228 }, { sccc8ca, .256 }, H };
N l16n171[] = { { sAcb, .171 }, H };
N l16n173[] = { { sDg, .427 }, H };
N l16n174[] = { { scdcbg, .384 }, { sc4C, .142 }, H };
N l16n175[] = { { sc4c3, .342 }, { sc8c7c0, .256 }, H };
N l16n176[] = { { sgA, .569 }, { sEc4, .342 }, { sc5c8c7, .299 }, { sc0Ac0g, .427 }, { sc0c5Bg, .427 }, H };
N l16n177[] = { { sgc1, .361 }, { sc0cbc8ca, .342 }, H };
N l16n178[] = { { sc8K, .256 }, { sc8c2c8, .214 }, H };
N l16n179[] = { { sc8cb, .142 }, H };
N l16n180[] = { { scdB, .456 }, H };
N l16n181[] = { { scbg, .555 }, { scbc4E, .342 }, { scbc0g, .448 }, { scdc2, .199 }, H };
N l16n182[] = { { sCc8, .256 }, H };
N l16n183[] = { { scaBg, .641 }, H };
N l16n184[] = { { sccc4, .598 }, H };
N l16n185[] = { { scac8B, .726 }, { sc8Bc0g, .854 }, H };
N l16n186[] = { { sc0K, .256 }, H };
N l16n187[] = { { sc0cb, 1.082 }, { scbc6, .171 }, H };
N l16n188[] = { { sc5B, .228 }, H };
N l16n189[] = { { sc3c0g, 2.498 }, { sc3g, .897 }, H };
N l16n190[] = { { scac8, 2.676 }, { sc4cac8, .940 }, H };
N l16n191[] = { { sc4D, .171 }, { sc3c2c0, .214 }, H };
N l16n193[] = { { sgB, .892 }, { sc7c8g, .833 }, H };
N l16n194[] = { { sgc2, .911 }, H };
N l16n195[] = { { sOB, .142 }, H };
N l16n196[] = { { sc8cc, .598 }, { sc0ccc8g, .854 }, { sBOc5c0, .342 }, H };
N l16n197[] = { { scac4c1, .256 }, H };
N l16n198[] = { { sc2c8, .370 }, { scdc3, .199 }, { sc0c2c0cc, .342 }, H };
N l16n199[] = { { sgcbc4, .399 }, H };
N l16n200[] = { { sAcdB, .214 }, H };
N l16n202[] = { { sc7Dca, .256 }, H };
N l16n204[] = { { sc0cc, 1.708 }, { sc7c5c0ca, .342 }, { scbc7, .171 }, H };
N l16n205[] = { { sAcd, .911 }, { sc4c1c0, .726 }, H };
N l16n206[] = { { sc5c3, .256 }, { sgc7c5c0, .228 }, H };
N l16n207[] = { { sc8c7g, .705 }, H };
N l16n208[] = { { sIc8g, 1.281 }, { sc4E, .285 }, { sgc0Ac0, .342 }, { sFc0Ac7, .456 }, H };
N l16n209[] = { { sc4c5, .313 }, H };
N l16n210[] = { { sgC, .152 }, H };
N l16n211[] = { { sgc3, .968 }, H };
N l16n212[] = { { sccg, 1.409 }, { sgc4A, .342 }, H };
N l16n214[] = { { sAc7Dca, .342 }, H };
N l16n215[] = { { scdc4, .171 }, H };
N l16n216[] = { { sAc8g, 1.153 }, H };
N l16n217[] = { { sc7c0, .740 }, { sgIc0cb, .228 }, H };
N l16n220[] = { { sc4g, 1.068 }, H };
N l16n221[] = { { scbc8, .541 }, { sgcbc6, .171 }, H };
N l16n222[] = { { sgOc0, .285 }, H };
N l16n223[] = { { sc5c4, 1.082 }, { sgc4B, .285 }, { sc2c0c3c0, .342 }, H };
N l16n224[] = { { sc4ccc8, .427 }, { sFc5, .171 }, { sgAcdcb, .228 }, H };
N l16n225[] = { { sgcbc0c2, .190 }, H };
N l16n227[] = { { sgD, .304 }, H };
N l16n228[] = { { sgc4, .531 }, { scdc1c0, .512 }, H };
N l16n229[] = { { sc3c8, .342 }, { sc5c4cac8, .399 }, H };
N l16n230[] = { { sOc4, .626 }, H };
N l16n231[] = { { sccc3c0, .384 }, H };
N l16n232[] = { { sIc0, .313 }, { scdc5, .171 }, H };
N l16n234[] = { { sOc0caO, .285 }, H };
N l16n236[] = { { sMc8, .171 }, H };
N l16n237[] = { { sc0c5c8, .342 }, H };
N l16n239[] = { { sDcac8g, 1.623 }, H };
N l16n240[] = { { sAc0, 1.025 }, { sgc0Ag, .418 }, { sgAc0, .142 }, H };
N l16n242[] = { { sCc0cc, .214 }, H };
N l16n243[] = { { scdg, 1.025 }, { sc4c7, .256 }, H };
N l16n244[] = { { sEc8, .285 }, { sgE, .171 }, H };
N l16n245[] = { { sDAc8, .427 }, { sgc5, .133 }, H };
N l16n247[] = { { sDca, 1.167 }, { sOc5, .427 }, { sc2c0cb, .384 }, H };
N l16n248[] = { { sc8c0, .655 }, { sc4Ac4, .214 }, H };
N l16n249[] = { { sIc0cbc8, .342 }, { scac8Bc0, .342 }, H };
N l16n251[] = { { sc5c0g, .577 }, { sc0cbc0, .299 }, H };
N l16n252[] = { { sccc8, 1.053 }, { sc4c1Dca, .456 }, H };
N l16n253[] = { { sc4Bg, 1.153 }, H };
N l16n254[] = { { sc6c4, .399 }, { sc0O, .370 }, { scac8c0, .342 }, H };
N l16n255[] = { { sAc7c8, .299 }, { sGc5, .171 }, H };

D l16_d = {
	"georgian",
	"unknown",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, 0.003, W, W, W, W, W, W,
	    W, W, W, W, W, W, 0.001, W, W, W, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    0.456, 0.131, 0.123, 0.195, 0.370, 0.179, 0.040, 0.134, 0.523, 0.046, 0.230, 0.221, 0.181, 0.199, 0.015, 0.002,
	    0.279, 0.279, 0.060, 0.131, 0.040, 0.051, 0.023, 0.026, 0.080, 0.017, 0.058, 0.021, 0.034, 0.006, 0.103, 0.009,
	    0.005, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l16n0, l16n1, l16n2, l16n3, X, l16n5, l16n6, l16n7, l16n8, X, X, l16n11, l16n12, l16n13, X, l16n15,
	    l16n16, l16n17, l16n18, l16n19, l16n20, X, l16n22, l16n23, l16n24, l16n25, l16n26, l16n27, l16n28, l16n29, l16n30, l16n31,
	    X, l16n33, l16n34, l16n35, l16n36, l16n37, l16n38, X, l16n40, l16n41, l16n42, l16n43, l16n44, l16n45, l16n46, l16n47,
	    l16n48, l16n49, l16n50, l16n51, l16n52, X, l16n54, l16n55, l16n56, l16n57, l16n58, l16n59, l16n60, l16n61, l16n62, l16n63,
	    l16n64, l16n65, l16n66, l16n67, l16n68, l16n69, l16n70, l16n71, l16n72, l16n73, X, l16n75, X, l16n77, l16n78, X,
	    l16n80, l16n81, X, l16n83, l16n84, l16n85, X, l16n87, l16n88, l16n89, l16n90, l16n91, l16n92, l16n93, l16n94, l16n95,
	    l16n96, l16n97, l16n98, l16n99, l16n100, l16n101, l16n102, l16n103, l16n104, X, l16n106, X, l16n108, l16n109, l16n110, l16n111,
	    l16n112, l16n113, l16n114, l16n115, l16n116, X, l16n118, X, l16n120, l16n121, l16n122, l16n123, l16n124, X, l16n126, l16n127,
	    X, l16n129, l16n130, l16n131, l16n132, l16n133, l16n134, X, l16n136, X, l16n138, l16n139, l16n140, l16n141, l16n142, l16n143,
	    l16n144, l16n145, X, l16n147, l16n148, l16n149, l16n150, l16n151, l16n152, l16n153, l16n154, l16n155, X, l16n157, l16n158, l16n159,
	    l16n160, l16n161, l16n162, l16n163, l16n164, X, l16n166, l16n167, l16n168, X, l16n170, l16n171, X, l16n173, l16n174, l16n175,
	    l16n176, l16n177, l16n178, l16n179, l16n180, l16n181, l16n182, l16n183, l16n184, l16n185, l16n186, l16n187, l16n188, l16n189, l16n190, l16n191,
	    X, l16n193, l16n194, l16n195, l16n196, l16n197, l16n198, l16n199, l16n200, X, l16n202, X, l16n204, l16n205, l16n206, l16n207,
	    l16n208, l16n209, l16n210, l16n211, l16n212, X, l16n214, l16n215, l16n216, l16n217, X, X, l16n220, l16n221, l16n222, l16n223,
	    l16n224, l16n225, X, l16n227, l16n228, l16n229, l16n230, l16n231, l16n232, X, l16n234, X, l16n236, l16n237, X, l16n239,
	    l16n240, X, l16n242, l16n243, l16n244, l16n245, X, l16n247, l16n248, l16n249, X, l16n251, l16n252, l16n253, l16n254, l16n255 }
};

//
// Lng: german
// Enc: iso-8859-15
//

S simr[] = { e, i, n, 0 };
S syrk[] = { u, n, g, 0 };
S sgimr[] = { 32, e, i, n, 0 };
S sgim[] = { 32, e, i, 0 };
S simri[] = { e, i, n, e, 0 };
S syrhg[] = { u, n, d, a };
S simx[] = { e, i, t, 0 };
S sXZl[] = { 97, 99, h, 0 };
S sgwZl[] = { 32, s, 99, h, 0 };
S sgwZ[] = { 32, s, 99, 0 };
S sfcv[] = { 252, r, 0 };
S sg7ay[] = { 32, z, u, 0 };
S sjfc[] = { f, 252, 0 };
S sfcvg[] = { 252, r, a };
S sXyj[] = { 97, u, f, 0 };
S sgjfc[] = { 32, f, 252, 0 };
S sjfcv[] = { f, 252, r, 0 };
S spmZl[] = { l, i, 99, h, 0 };
S sjfcvg[] = { f, 252, r, a };
S sgjfcv[] = { 32, f, 252, r, 0 };
S syj[] = { u, f, 0 };
S smwZ[] = { i, s, 99, 0 };
S sYim[] = { 98, e, i, 0 };
S syrkg[] = { u, n, g, a };
S smwZl[] = { i, s, 99, h, 0 };
S sXpw[] = { 97, l, s, 0 };
S swmr[] = { s, i, n, 0 };
S sZlxg[] = { 99, h, t, a };
S simrg[] = { e, i, n, a };
S syrkw[] = { u, n, g, s, 0 };
S syqg[] = { u, m, a };
S sghXw[] = { 32, d, 97, s, 0 };
S shXw[] = { d, 97, s, 0 };
S slir[] = { h, e, n, 0 };
S srkw[] = { n, g, s, 0 };
S sXpwg[] = { 97, l, s, a };
S slvi[] = { h, r, e, 0 };
S svZl[] = { r, 99, h, 0 };
S syxi[] = { u, t, e, 0 };
S simxg[] = { e, i, t, a };
S sXyw[] = { 97, u, s, 0 };
S svim[] = { r, e, i, 0 };
S slirg[] = { h, e, n, a };
S sZlir[] = { 99, h, e, n, 0 };
S soim[] = { k, e, i, 0 };
S syxig[] = { u, t, e, a };
S sgXyj[] = { 32, 97, u, f, 0 };
S shXwg[] = { d, 97, s, a };
S swmZl[] = { s, i, 99, h, 0 };
S spiy[] = { l, e, u, 0 };
S svyr[] = { r, u, n, 0 };
S swmZ[] = { s, i, 99, 0 };
S syvZ[] = { u, r, 99, 0 };
S sxmk[] = { t, i, g, 0 };
S sxvX[] = { t, r, 97, 0 };
S sqqi[] = { m, m, e, 0 };
S syvZl[] = { u, r, 99, h, 0 };
S sgzsr[] = { 32, v, o, n, 0 };
S szsr[] = { v, o, n, 0 };
S szsrg[] = { v, o, n, a };
S sqirg[] = { m, e, n, a };
S syZl[] = { u, 99, h, 0 };
S smZlx[] = { i, 99, h, t, 0 };
S sglXx[] = { 32, h, 97, t, 0 };
S svfc[] = { r, 252, 0 };
S syrki[] = { u, n, g, e, 0 };
S sghyv[] = { 32, d, u, r, 0 };
S sgmq[] = { 32, i, m, 0 };
S shyv[] = { d, u, r, 0 };
S sgmqg[] = { 32, i, m, a };
S sgml[] = { 32, i, h, 0 };
S s7ayg[] = { z, u, a };
S sgYim[] = { 32, 98, e, i, 0 };
S shyvZ[] = { d, u, r, 99, 0 };
S svxg[] = { r, t, a };
S sgXpw[] = { 32, 97, l, s, 0 };
S siyxi[] = { e, u, t, e, 0 };
S sgpiy[] = { 32, l, e, u, 0 };
S siyx[] = { e, u, t, 0 };
S soimx[] = { k, e, i, t, 0 };
S sgivw[] = { 32, e, r, s, 0 };
S sywg[] = { u, s, a };
S sipx[] = { e, l, t, 0 };
S sXyZl[] = { 97, u, 99, h, 0 };
S sgwt[] = { 32, s, p, 0 };
S sgwmZ[] = { 32, s, i, 99, 0 };
S smrhg[] = { i, n, d, a };
S spxi[] = { l, t, e, 0 };
S sZl_[] = { 99, h, w, 0 };
S shsv[] = { d, o, r, 0 };
S swim[] = { s, e, i, 0 };
S sXyjg[] = { 97, u, f, a };
S swmrh[] = { s, i, n, d, 0 };
S swZl_[] = { s, 99, h, w, 0 };
S sXP[] = { 97, 223, 0 };
S sivwx[] = { e, r, s, t, 0 };
S sXyZ[] = { 97, u, 99, 0 };
S srxiv[] = { n, t, e, r, 0 };
S sgXyw[] = { 32, 97, u, s, 0 };
S smZli[] = { i, 99, h, e, 0 };
S sl_[] = { h, w, 0 };
S smqq[] = { i, m, m, 0 };
S s_im[] = { w, e, i, 0 };
S spiyx[] = { l, e, u, t, 0 };
S srkig[] = { n, g, e, a };
S sqqir[] = { m, m, e, n, 0 };
S swZli[] = { s, 99, h, e, 0 };
S sg7ayg[] = { 32, z, u, a };
S syjg[] = { u, f, a };
S simg[] = { e, i, a };
S srivg[] = { n, e, r, a };

N l17n0[] = { { siy, .181 }, H };
N l17n1[] = { { sg7ay, .354 }, H };
N l17n2[] = { { sqirg, .254 }, { sZl_, .109 }, H };
N l17n3[] = { { ssv, .314 }, H };
N l17n4[] = { { s_iv, .109 }, H };
N l17n5[] = { { smr, .967 }, { sxm, .363 }, { slXx, .127 }, H };
N l17n6[] = { { srx, .314 }, { sgwm, .408 }, { svim, .145 }, H };
N l17n7[] = { { sri, .459 }, { sghm, .789 }, { slir, .163 }, { sxivg, .290 }, H };
N l17n8[] = { { sghXw, .326 }, { swo, .073 }, H };
N l17n9[] = { { slX, .181 }, H };
N l17n11[] = { { skv, .085 }, { sgXr, .163 }, { sipp, .109 }, H };
N l17n12[] = { { sgp, .272 }, H };
N l17n13[] = { { swg, .907 }, { sXr, .326 }, { spm, .266 }, { sgzi, .299 }, H };
N l17n14[] = { { sgki, .408 }, { sjx, .097 }, H };
N l17n15[] = { { sji, .181 }, H };
N l17n17[] = { { sqqir, .145 }, H };
N l17n21[] = { { shm, .459 }, { sog, .200 }, { ssh, .085 }, { syrki, .169 }, H };
N l17n22[] = { { sfcv, .354 }, { sjfc, .145 }, { sYim, .181 }, { sms, .085 }, H };
N l17n23[] = { { shivg, 1.233 }, { spwg, .272 }, { sxxi, .127 }, H };
N l17n24[] = { { sgim, .653 }, { sZo, .133 }, H };
N l17n26[] = { { srkw, .163 }, { sivwx, .145 }, H };
N l17n28[] = { { svr, .145 }, { skw, .121 }, H };
N l17n29[] = { { simri, .411 }, { sgq, .272 }, H };
N l17n30[] = { { s_i, .218 }, { sg_i, .245 }, { smZlx, .169 }, H };
N l17n31[] = { { ssrg, .408 }, { skiw, .127 }, { spxi, .109 }, H };
N l17n33[] = { { sxig, .735 }, { srirg, .290 }, { sPg, .286 }, H };
N l17n34[] = { { smZlg, .326 }, { shiwg, .218 }, H };
N l17n35[] = { { sil, .157 }, H };
N l17n36[] = { { sivi, .163 }, { swxm, .145 }, H };
N l17n37[] = { { syrhg, .617 }, { swim, .109 }, H };
N l17n39[] = { { swmZ, .145 }, { swZli, .145 }, H };
N l17n41[] = { { srk, .520 }, { spig, .245 }, H };
N l17n42[] = { { slv, .242 }, H };
N l17n43[] = { { siyxi, .169 }, H };
N l17n44[] = { { sxg, 1.161 }, { sqm, .109 }, { spiyx, .145 }, H };
N l17n45[] = { { sivg, 1.877 }, { soim, .145 }, H };
N l17n46[] = { { ski, .641 }, { sgr, .345 }, { sywg, .190 }, H };
N l17n47[] = { { sgwmZ, .218 }, H };
N l17n48[] = { { simx, .308 }, H };
N l17n49[] = { { sghiv, .979 }, { shig, .190 }, H };
N l17n52[] = { { sim, .895 }, { spg, .236 }, H };
N l17n54[] = { { sghmi, .979 }, { syxi, .145 }, { syvZl, .169 }, { syZl, .127 }, H };
N l17n55[] = { { ssj, .073 }, H };
N l17n56[] = { { spU, .073 }, H };
N l17n60[] = { { shg, .653 }, { sZli, .417 }, { sXpwg, .326 }, H };
N l17n61[] = { { svir, .200 }, H };
N l17n62[] = { { siwg, .354 }, H };
N l17n63[] = { { svX, .266 }, { sgs, .218 }, { syrkw, .218 }, H };
N l17n64[] = { { spp, .230 }, H };
N l17n65[] = { { sXY, .181 }, { sZlxg, .326 }, H };
N l17n69[] = { { sZlg, .816 }, H };
N l17n70[] = { { syrkg, .363 }, { sXyjg, .218 }, H };
N l17n72[] = { { skirg, .326 }, { sgws, .190 }, H };
N l17n73[] = { { smv, .097 }, H };
N l17n74[] = { { smZ, .351 }, { sg_m, .245 }, H };
N l17n75[] = { { srm, .133 }, { syg, .163 }, H };
N l17n76[] = { { slx, .254 }, { sws, .133 }, H };
N l17n77[] = { { sli, .447 }, { srhi, .236 }, { svyr, .145 }, { sYir, .109 }, { srivg, .218 }, H };
N l17n78[] = { { spmZ, .218 }, { simrg, .326 }, { sgXpw, .254 }, H };
N l17n79[] = { { sYX, .109 }, { sglXx, .254 }, { sgir, .190 }, H };
N l17n80[] = { { sgt, .145 }, H };
N l17n81[] = { { sgX, .943 }, { sXv, .218 }, { smrh, .163 }, { sgml, .190 }, { syjg, .163 }, H };
N l17n82[] = { { sXZ, .169 }, H };
N l17n83[] = { { sqg, .707 }, { sgwt, .163 }, H };
N l17n84[] = { { sos, .145 }, { smqg, .245 }, H };
N l17n85[] = { { srwg, .163 }, H };
N l17n86[] = { { srhg, .735 }, H };
N l17n88[] = { { sgXy, .544 }, H };
N l17n89[] = { { sXrh, .127 }, { sgrX, .163 }, H };
N l17n90[] = { { smw, .302 }, H };
N l17n91[] = { { sig, 2.394 }, H };
N l17n92[] = { { smri, .326 }, { sjfcvg, .399 }, H };
N l17n93[] = { { srxi, .200 }, { swt, .121 }, { sly, .085 }, { swZl_, .145 }, H };
N l17n94[] = { { swX, .109 }, H };
N l17n95[] = { { sgyr, .680 }, { swmZl, .193 }, H };
N l17n97[] = { { svZ, .121 }, { shsv, .109 }, { sg7ayg, .218 }, H };
N l17n98[] = { { sgY, .508 }, { sgimr, .871 }, { s_m, .157 }, { sXw, .145 }, H };
N l17n99[] = { { sgziv, .399 }, { sgpi, .245 }, { sXh, .097 }, { szsr, .127 }, { sipx, .109 }, { ssvg, .163 }, H };
N l17n101[] = { { smrg, .707 }, H };
N l17n102[] = { { sivo, .145 }, { soX, .085 }, H };
N l17n103[] = { { sip, .302 }, { srig, .245 }, { slirg, .290 }, H };
N l17n104[] = { { syq, .133 }, H };
N l17n107[] = { { smx, .399 }, { sxs, .085 }, H };
N l17n108[] = { { smi, .653 }, { shmi, .490 }, H };
N l17n109[] = { { svwx, .109 }, H };
N l17n112[] = { { sqq, .169 }, { sYv, .085 }, H };
N l17n113[] = { { svw, .169 }, H };
N l17n114[] = { { srg, 2.648 }, { sgv, .236 }, { svh, .121 }, { sxmk, .145 }, { smrk, .127 }, H };
N l17n115[] = { { sXx, .266 }, H };
N l17n117[] = { { sXyw, .145 }, H };
N l17n118[] = { { sfcvg, .673 }, H };
N l17n120[] = { { siq, .254 }, H };
N l17n121[] = { { syr, .786 }, { sYiv, .145 }, H };
N l17n122[] = { { sgjfc, .299 }, { sjg, .145 }, { sirw, .127 }, H };
N l17n123[] = { { sxir, .381 }, { sgiv, .571 }, { s7ai, .157 }, { sgzs, .326 }, { shs, .097 }, H };
N l17n125[] = { { sxX, .133 }, H };
N l17n126[] = { { shXw, .163 }, H };
N l17n127[] = { { sgwx, .272 }, { sl_, .073 }, H };
N l17n128[] = { { swZ, .459 }, { srki, .290 }, H };
N l17n129[] = { { slvi, .163 }, H };
N l17n130[] = { { svx, .266 }, H };
N l17n131[] = { { sgw, 1.288 }, { svi, .472 }, { spir, .127 }, H };
N l17n132[] = { { sgh, 1.904 }, { sXy, .423 }, H };
N l17n133[] = { { spX, .157 }, { sirx, .236 }, H };
N l17n134[] = { { spmZl, .266 }, { sZlir, .193 }, H };
N l17n136[] = { { sgmq, .190 }, H };
N l17n137[] = { { sir, 1.693 }, { srkg, .354 }, { soimx, .169 }, H };
N l17n138[] = { { sgXyj, .290 }, { svfc, .085 }, H };
N l17n139[] = { { s7ay, .193 }, { shir, .290 }, { sgyrh, .544 }, { sghy, .190 }, H };
N l17n140[] = { { sgjv, .163 }, H };
N l17n141[] = { { shX, .230 }, H };
N l17n142[] = { { smk, .181 }, { skig, .326 }, { sXP, .073 }, H };
N l17n143[] = { { szsv, .127 }, H };
N l17n144[] = { { simxg, .290 }, H };
N l17n145[] = { { ssg, .254 }, { slm, .121 }, H };
N l17n147[] = { { sYi, .435 }, { sgmr, .599 }, { svy, .157 }, H };
N l17n148[] = { { sgx, .272 }, { simg, .163 }, H };
N l17n149[] = { { sgi, 1.215 }, H };
N l17n150[] = { { syxig, .290 }, { sXk, .085 }, H };
N l17n151[] = { { sppi, .218 }, H };
N l17n153[] = { { skg, .326 }, H };
N l17n155[] = { { smwZ, .181 }, H };
N l17n156[] = { { sZlig, .399 }, H };
N l17n157[] = { { svirg, .326 }, { ssp, .097 }, H };
N l17n158[] = { { sxv, .145 }, H };
N l17n159[] = { { sml, .085 }, H };
N l17n160[] = { { srr, .133 }, { swmr, .181 }, { sgqm, .163 }, H };
N l17n161[] = { { swx, .556 }, { s_im, .109 }, H };
N l17n162[] = { { swi, .266 }, { sqir, .236 }, H };
N l17n163[] = { { srhiv, .218 }, { smqq, .109 }, H };
N l17n164[] = { { sqX, .121 }, H };
N l17n165[] = { { sgy, .544 }, H };
N l17n166[] = { { sgj, .508 }, H };
N l17n167[] = { { sxiv, .308 }, { sXl, .073 }, H };
N l17n169[] = { { szs, .181 }, H };
N l17n170[] = { { soi, .242 }, H };
N l17n172[] = { { slxg, .408 }, H };
N l17n173[] = { { slig, .354 }, H };
N l17n174[] = { { ssq, .109 }, { shv, .085 }, H };
N l17n175[] = { { sghX, .463 }, { sxw, .121 }, H };
N l17n177[] = { { srs, .133 }, { smrhg, .218 }, { sgXyw, .218 }, H };
N l17n179[] = { { srxiv, .145 }, H };
N l17n182[] = { { sgz, .472 }, H };
N l17n183[] = { { shiv, .762 }, { sgk, .472 }, { spw, .157 }, H };
N l17n184[] = { { slg, .599 }, H };
N l17n185[] = { { sgYi, .463 }, H };
N l17n189[] = { { syv, .230 }, { siY, .073 }, H };
N l17n190[] = { { sivw, .218 }, { syZ, .097 }, H };
N l17n191[] = { { ssr, .278 }, H };
N l17n192[] = { { sxx, .133 }, { sgos, .245 }, H };
N l17n193[] = { { sxi, .955 }, { srir, .163 }, H };
N l17n194[] = { { smZl, .453 }, { sXwg, .218 }, { shiw, .127 }, { sgpiy, .254 }, H };
N l17n195[] = { { srX, .145 }, { szsrg, .254 }, H };
N l17n196[] = { { sgwZ, .381 }, { slp, .133 }, H };
N l17n197[] = { { syrh, .417 }, { sgzsr, .254 }, { sXyZ, .109 }, H };
N l17n199[] = { { sg_, .599 }, { svm, .206 }, { sqqi, .145 }, { shyv, .127 }, H };
N l17n200[] = { { sgl, .453 }, { syqg, .245 }, { spx, .109 }, { s_s, .097 }, H };
N l17n201[] = { { spi, .423 }, { sgvi, .218 }, { sxvX, .145 }, { sivx, .127 }, { svhi, .127 }, H };
N l17n202[] = { { sXZl, .254 }, { srkir, .145 }, H };
N l17n203[] = { { smxg, .326 }, H };
N l17n204[] = { { smig, .952 }, { shmig, .907 }, { swmrh, .145 }, H };
N l17n205[] = { { siv, 1.705 }, H };
N l17n206[] = { { syw, .181 }, { siZ, .073 }, H };
N l17n208[] = { { sgjfcv, .399 }, { spiy, .145 }, H };
N l17n209[] = { { shi, .943 }, H };
N l17n210[] = { { smo, .109 }, H };
N l17n211[] = { { smwZl, .242 }, H };
N l17n212[] = { { sgivw, .254 }, H };
N l17n213[] = { { sirh, .127 }, H };
N l17n215[] = { { sYm, .085 }, { smg, .109 }, H };
N l17n216[] = { { siqg, .354 }, H };
N l17n217[] = { { sgm, .726 }, { svxi, .200 }, { svZl, .163 }, H };
N l17n218[] = { { sgwi, .272 }, { s_X, .073 }, { siwx, .109 }, H };
N l17n219[] = { { sghi, 1.143 }, { sxirg, .617 }, { sgivg, .254 }, H };
N l17n220[] = { { sXpw, .181 }, H };
N l17n222[] = { { siw, .411 }, { shXwg, .290 }, H };
N l17n223[] = { { syx, .121 }, H };
N l17n224[] = { { srkig, .218 }, { syi, .073 }, H };
N l17n225[] = { { sZlx, .272 }, { shy, .097 }, { sghyv, .254 }, H };
N l17n226[] = { { svxg, .190 }, H };
N l17n227[] = { { smp, .109 }, H };
N l17n229[] = { { sZl, 1.354 }, { sziv, .236 }, H };
N l17n230[] = { { syrk, .472 }, { swm, .314 }, { sXyj, .200 }, H };
N l17n232[] = { { sqi, .266 }, { skir, .308 }, { sgmqg, .254 }, H };
N l17n233[] = { { sirg, 2.503 }, { svo, .133 }, H };
N l17n234[] = { { sgn, .145 }, H };
N l17n235[] = { { sXp, .302 }, { shirg, .472 }, { s7ayg, .190 }, H };
N l17n236[] = { { sjv, .073 }, H };
N l17n237[] = { { sriv, .145 }, H };
N l17n238[] = { { svg, 1.741 }, { simr, .580 }, H };
N l17n239[] = { { six, .169 }, H };
N l17n240[] = { { shyvZ, .169 }, H };
N l17n241[] = { { syj, .133 }, { smZli, .145 }, H };
N l17n243[] = { { sgmrg, .544 }, { sglX, .299 }, H };
N l17n244[] = { { smq, .218 }, { sxl, .097 }, { sgYim, .254 }, H };
N l17n245[] = { { srw, .206 }, { sgXp, .245 }, H };
N l17n246[] = { { srh, .593 }, H };
N l17n247[] = { { sls, .085 }, H };
N l17n248[] = { { swZl, .689 }, { swxi, .218 }, { sqy, .073 }, H };
N l17n250[] = { { sg7a, .363 }, H };
N l17n251[] = { { sgo, .490 }, H };
N l17n252[] = { { sgwZl, .508 }, { sXq, .145 }, { sjfcv, .200 }, { siyx, .127 }, H };
N l17n253[] = { { sXyZl, .145 }, H };
N l17n254[] = { { syvZ, .145 }, H };
N l17n255[] = { { szi, .181 }, { ssvx, .109 }, H };

D l17_d = {
	"german",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.000, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, 0.000, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.104, 0.038, 0.062, 0.098, 0.318, 0.035, 0.056, 0.095, 0.156, 0.004, 0.040, 0.072, 0.053, 0.190, 0.060,
	    0.015, W, 0.154, 0.120, 0.128, 0.083, 0.020, 0.026, 0.003, 0.003, 0.020, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, 0.002, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, 0.001, V, V, V, V, V, 0.003, V, V, 0.014,
	    V, V, V, V, 0.030, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, 0.014, V, V, V, V, V, 0.032, V, V, V },
	{ l17n0, l17n1, l17n2, l17n3, l17n4, l17n5, l17n6, l17n7, l17n8, l17n9, X, l17n11, l17n12, l17n13, l17n14, l17n15,
	    X, l17n17, X, X, X, l17n21, l17n22, l17n23, l17n24, X, l17n26, X, l17n28, l17n29, l17n30, l17n31,
	    X, l17n33, l17n34, l17n35, l17n36, l17n37, X, l17n39, X, l17n41, l17n42, l17n43, l17n44, l17n45, l17n46, l17n47,
	    l17n48, l17n49, X, X, l17n52, X, l17n54, l17n55, l17n56, X, X, X, l17n60, l17n61, l17n62, l17n63,
	    l17n64, l17n65, X, X, X, l17n69, l17n70, X, l17n72, l17n73, l17n74, l17n75, l17n76, l17n77, l17n78, l17n79,
	    l17n80, l17n81, l17n82, l17n83, l17n84, l17n85, l17n86, X, l17n88, l17n89, l17n90, l17n91, l17n92, l17n93, l17n94, l17n95,
	    X, l17n97, l17n98, l17n99, X, l17n101, l17n102, l17n103, l17n104, X, X, l17n107, l17n108, l17n109, X, X,
	    l17n112, l17n113, l17n114, l17n115, X, l17n117, l17n118, X, l17n120, l17n121, l17n122, l17n123, X, l17n125, l17n126, l17n127,
	    l17n128, l17n129, l17n130, l17n131, l17n132, l17n133, l17n134, X, l17n136, l17n137, l17n138, l17n139, l17n140, l17n141, l17n142, l17n143,
	    l17n144, l17n145, X, l17n147, l17n148, l17n149, l17n150, l17n151, X, l17n153, X, l17n155, l17n156, l17n157, l17n158, l17n159,
	    l17n160, l17n161, l17n162, l17n163, l17n164, l17n165, l17n166, l17n167, X, l17n169, l17n170, X, l17n172, l17n173, l17n174, l17n175,
	    X, l17n177, X, l17n179, X, X, l17n182, l17n183, l17n184, l17n185, X, X, X, l17n189, l17n190, l17n191,
	    l17n192, l17n193, l17n194, l17n195, l17n196, l17n197, X, l17n199, l17n200, l17n201, l17n202, l17n203, l17n204, l17n205, l17n206, X,
	    l17n208, l17n209, l17n210, l17n211, l17n212, l17n213, X, l17n215, l17n216, l17n217, l17n218, l17n219, l17n220, X, l17n222, l17n223,
	    l17n224, l17n225, l17n226, l17n227, X, l17n229, l17n230, X, l17n232, l17n233, l17n234, l17n235, l17n236, l17n237, l17n238, l17n239,
	    l17n240, l17n241, X, l17n243, l17n244, l17n245, l17n246, l17n247, l17n248, X, l17n250, l17n251, l17n252, l17n253, l17n254, l17n255 }
};

//
// Lng: greek
// Enc: iso-8859-7
//

S sgf4[] = { 32, 244, 0 };
S seff5[] = { 239, 245, 0 };
S sf4ef[] = { 244, 239, 0 };
S seff5g[] = { 239, 245, a };
S sgf0[] = { 32, 240, 0 };
S sgf3[] = { 32, 243, 0 };
S sgf4ef[] = { 32, 244, 239, 0 };
S sgec[] = { 32, 236, 0 };
S seaR[] = { 234, 225, 0 };
S sedR[] = { 237, 225, 0 };
S sRed[] = { 225, 237, 0 };
S sf4e7[] = { 244, 231, 0 };
S sgeaR[] = { 32, 234, 225, 0 };
S sf4eff5[] = { 244, 239, 245, 0 };
S sf4R[] = { 244, 225, 0 };
S sf3f4[] = { 243, 244, 0 };
S sf0ef[] = { 240, 239, 0 };
S sgf4eff5[] = { 32, 244, 239, 245, 0 };
S sVe9[] = { 229, 233, 0 };
S sRe9[] = { 225, 233, 0 };
S sRe9g[] = { 225, 233, a };
S sf4e9[] = { 244, 233, 0 };
S secV[] = { 236, 229, 0 };
S sVP[] = { 229, 223, 0 };
S se9ef[] = { 233, 239, 0 };
S sedRg[] = { 237, 225, a };
S sf4eff5g[] = { 244, 239, 245, a };
S sRf0[] = { 225, 240, 0 };
S sRedg[] = { 225, 237, a };
S sf4efg[] = { 244, 239, a };
S sNed[] = { 221, 237, 0 };
S sgf3f4[] = { 32, 243, 244, 0 };
S sgf4e7[] = { 32, 244, 231, 0 };
S sf0V[] = { 240, 229, 0 };
S se7ed[] = { 231, 237, 0 };
S sefed[] = { 239, 237, 0 };
S se7edg[] = { 231, 237, a };
S sgef[] = { 32, 239, 0 };
S sf3V[] = { 243, 229, 0 };
S sf1R[] = { 241, 225, 0 };
S sedf4[] = { 237, 244, 0 };
S se9R[] = { 233, 225, 0 };
S sRf2g[] = { 225, 242, a };
S sgRf0[] = { 32, 225, 240, 0 };
S secf0[] = { 236, 240, 0 };
S sgVP[] = { 32, 229, 223, 0 };
S sRf2[] = { 225, 242, 0 };
S seaM[] = { 234, 220, 0 };
S secef[] = { 236, 239, 0 };
S seaRe9[] = { 234, 225, 233, 0 };
S seaRe9g[] = { 234, 225, 233, a };
S sgeaRe9[] = { 32, 234, 225, 233, 0 };
S sReb[] = { 225, 235, 0 };
S sf0e9[] = { 240, 233, 0 };
S se9ea[] = { 233, 234, 0 };
S sf4V[] = { 244, 229, 0 };
S sPed[] = { 223, 237, 0 };
S sf0fc[] = { 240, 252, 0 };
S sged[] = { 32, 237, 0 };
S sf4e7ed[] = { 244, 231, 237, 0 };
S secR[] = { 236, 225, 0 };
S sf4e7edg[] = { 244, 231, 237, a };
S sedV[] = { 237, 229, 0 };
S sgf4efg[] = { 32, 244, 239, a };
S sVe9g[] = { 229, 233, a };
S se9Rg[] = { 233, 225, a };
S sVf1[] = { 229, 241, 0 };
S sf4M[] = { 244, 220, 0 };
S sf0eff5[] = { 240, 239, 245, 0 };
S sRf4[] = { 225, 244, 0 };
S sebef[] = { 235, 239, 0 };
S sgefg[] = { 32, 239, a };
S sebe9[] = { 235, 233, 0 };
S sgf0ef[] = { 32, 240, 239, 0 };
S sf0eff5g[] = { 240, 239, 245, a };
S sVed[] = { 229, 237, 0 };
S secVg[] = { 236, 229, a };
S sf0P[] = { 240, 223, 0 };
S se7f3[] = { 231, 243, 0 };
S secN[] = { 236, 221, 0 };
S sVf4[] = { 229, 244, 0 };
S sMec[] = { 220, 236, 0 };
S sf3R[] = { 243, 225, 0 };
S sf3Vg[] = { 243, 229, a };
S sf4Rg[] = { 244, 225, a };
S sgf0eff5[] = { 32, 240, 239, 245, 0 };
S sf1e9[] = { 241, 233, 0 };
S seffd[] = { 239, 253, 0 };
S sf0fcg[] = { 240, 252, a };
S sgRf0fc[] = { 32, 225, 240, 252, 0 };
S sedef[] = { 237, 239, 0 };
S sgecV[] = { 32, 236, 229, 0 };
S sf0M[] = { 240, 220, 0 };
S sVedg[] = { 229, 237, a };
S sRf0fc[] = { 225, 240, 252, 0 };
S sRf1[] = { 225, 241, 0 };
S sNedR[] = { 221, 237, 225, 0 };
S sRf0fcg[] = { 225, 240, 252, a };
S sefedg[] = { 239, 237, a };
S seaef[] = { 234, 239, 0 };
S sMed[] = { 220, 237, 0 };
S sgedRg[] = { 32, 237, 225, a };
S sebR[] = { 235, 225, 0 };
S sgedR[] = { 32, 237, 225, 0 };
S se9efg[] = { 233, 239, a };
S sf5f4[] = { 245, 244, 0 };
S se9M[] = { 233, 220, 0 };
S sNf1[] = { 221, 241, 0 };
S sf5ed[] = { 245, 237, 0 };
S sPf0[] = { 223, 240, 0 };
S sRf5[] = { 225, 245, 0 };
S sgeb[] = { 32, 235, 0 };
S sf5f2g[] = { 245, 242, a };
S sf5f2[] = { 245, 242, 0 };
S seceff5[] = { 236, 239, 245, 0 };
S sf1Rg[] = { 241, 225, a };
S seff5f2g[] = { 239, 245, 242, a };
S seff5f2[] = { 239, 245, 242, 0 };
S sede7[] = { 237, 231, 0 };
S sf0e9ef[] = { 240, 233, 239, 0 };
S sgecef[] = { 32, 236, 239, 0 };
S sebV[] = { 235, 229, 0 };
S sgUV[] = { 32, 228, 229, 0 };
S sf1fc[] = { 241, 252, 0 };
S sgf4e7ed[] = { 32, 244, 231, 237, 0 };
S seff2g[] = { 239, 242, a };
S sf4fc[] = { 244, 252, 0 };
S seff2[] = { 239, 242, 0 };
S sefe9[] = { 239, 233, 0 };
S seae9[] = { 234, 233, 0 };
S sRf5f4[] = { 225, 245, 244, 0 };
S sgRf5f4[] = { 32, 225, 245, 244, 0 };
S sf0Vg[] = { 240, 229, a };
S sf3f4ef[] = { 243, 244, 239, 0 };
S seeV[] = { 238, 229, 0 };
S sgRf5[] = { 32, 225, 245, 0 };
S sRf3[] = { 225, 243, 0 };
S sgeaM[] = { 32, 234, 220, 0 };
S sgece9[] = { 32, 236, 233, 0 };
S sgf0M[] = { 32, 240, 220, 0 };
S sVPf0[] = { 229, 223, 240, 0 };
S sf1V[] = { 241, 229, 0 };
S sMecf0[] = { 220, 236, 240, 0 };
S sgf3f4ef[] = { 32, 243, 244, 239, 0 };
S sUVed[] = { 228, 229, 237, 0 };
S sMeb[] = { 220, 235, 0 };
S sVf2g[] = { 229, 242, a };
S sgf7[] = { 32, 247, 0 };
S sPf0Vg[] = { 223, 240, 229, a };
S sf4f5[] = { 244, 245, 0 };
S sgUVed[] = { 32, 228, 229, 237, 0 };
S secNed[] = { 236, 221, 237, 0 };
S sgVPf0[] = { 32, 229, 223, 240, 0 };
S sPR[] = { 223, 225, 0 };
S sVPf0V[] = { 229, 223, 240, 229, 0 };
S sgccf0[] = { 32, 204, 240, 0 };
S sf4e7g[] = { 244, 231, a };
S sgcaM[] = { 32, 202, 220, 0 };
S sPf0V[] = { 223, 240, 229, 0 };
S sVf2[] = { 229, 242, 0 };
S scaM[] = { 202, 220, 0 };
S sece9[] = { 236, 233, 0 };
S sccf0[] = { 204, 240, 0 };
S sUVedg[] = { 228, 229, 237, a };
S sf1ef[] = { 241, 239, 0 };
S sgee[] = { 32, 238, 0 };
S sf4f1[] = { 244, 241, 0 };
S sf4Vg[] = { 244, 229, a };
S sf0f1[] = { 240, 241, 0 };
S scaMecf0[] = { 202, 220, 236, 240, 0 };
S sgfc[] = { 32, 252, 0 };
S sgf3f4e7[] = { 32, 243, 244, 231, 0 };
S sgcaMec[] = { 32, 202, 220, 236, 0 };
S se9f2g[] = { 233, 242, a };
S sMf4[] = { 220, 244, 0 };
S sgc7g[] = { 32, 199, a };
S sedf4f5[] = { 237, 244, 245, 0 };
S sf3f4efg[] = { 243, 244, 239, a };
S sf3e7[] = { 243, 231, 0 };
S sNedRg[] = { 221, 237, 225, a };
S secf0e9[] = { 236, 240, 233, 0 };
S seaMg[] = { 234, 220, a };
S se9f2[] = { 233, 242, 0 };
S sedf4f5g[] = { 237, 244, 245, a };
S seaRed[] = { 234, 225, 237, 0 };
S sf4Mg[] = { 244, 220, a };
S sf4e9g[] = { 244, 233, a };
S se9f3[] = { 233, 243, 0 };
S sf4f5g[] = { 244, 245, a };
S seaf1[] = { 234, 241, 0 };
S sf4Red[] = { 244, 225, 237, 0 };
S sf4eff5f2[] = { 244, 239, 245, 242, 0 };
S scaMec[] = { 202, 220, 236, 0 };
S sf4Redg[] = { 244, 225, 237, a };
S sebeb[] = { 235, 235, 0 };
S sf3f4e7[] = { 243, 244, 231, 0 };
S sfcec[] = { 252, 236, 0 };
S sefeb[] = { 239, 235, 0 };
S seceff5g[] = { 236, 239, 245, a };
S seaRf4[] = { 234, 225, 244, 0 };
S sgccf0P[] = { 32, 204, 240, 223, 0 };
S sccf0P[] = { 204, 240, 223, 0 };
S sf0Ped[] = { 240, 223, 237, 0 };
S sgf4R[] = { 32, 244, 225, 0 };
S sfcf2g[] = { 252, 242, a };
S se7f4[] = { 231, 244, 0 };
S sf5ec[] = { 245, 236, 0 };
S se9Mg[] = { 233, 220, a };
S sgf6[] = { 32, 246, 0 };
S sMecf0e9[] = { 220, 236, 240, 233, 0 };
S sccf0Ped[] = { 204, 240, 223, 237, 0 };
S seeVg[] = { 238, 229, a };
S sgf1[] = { 32, 241, 0 };
S sPedf4f5[] = { 223, 237, 244, 245, 0 };
S sebM[] = { 235, 220, 0 };
S sf0Pedf4[] = { 240, 223, 237, 244, 0 };
S sf1M[] = { 241, 220, 0 };
S sgeaRf4[] = { 32, 234, 225, 244, 0 };
S sfcf2[] = { 252, 242, 0 };
S seaV[] = { 234, 229, 0 };
S sf4e9ea[] = { 244, 233, 234, 0 };
S sPedf4[] = { 223, 237, 244, 0 };
S sedf9[] = { 237, 249, 0 };
S sf3Redg[] = { 243, 225, 237, a };
S sf3Red[] = { 243, 225, 237, 0 };
S se9eb[] = { 233, 235, 0 };
S sgf4Rg[] = { 32, 244, 225, a };
S sgeceff5[] = { 32, 236, 239, 245, 0 };
S sf0e9efed[] = { 240, 233, 239, 237, 0 };
S secRg[] = { 236, 225, a };
S sVT[] = { 229, 227, 0 };
S se9ed[] = { 233, 237, 0 };
S se9efed[] = { 233, 239, 237, 0 };
S sNeb[] = { 221, 235, 0 };
S sede7g[] = { 237, 231, a };
S seff1[] = { 239, 241, 0 };
S sf0Med[] = { 240, 220, 237, 0 };
S sTe9[] = { 227, 233, 0 };
S sf3f9[] = { 243, 249, 0 };
S se9eaM[] = { 233, 234, 220, 0 };
S sgRed[] = { 32, 225, 237, 0 };
S sSR[] = { 226, 225, 0 };
S secf0e9ef[] = { 236, 240, 233, 239, 0 };
S sgf4e7g[] = { 32, 244, 231, a };
S sf5f0[] = { 245, 240, 0 };
S sgeae9[] = { 32, 234, 233, 0 };
S sgecR[] = { 32, 236, 225, 0 };
S se9eaMg[] = { 233, 234, 220, a };
S se9efedg[] = { 233, 239, 237, a };
S sf3e7g[] = { 243, 231, a };
S sf3ef[] = { 243, 239, 0 };
S se7f2[] = { 231, 242, 0 };
S sf0Vf1[] = { 240, 229, 241, 0 };
S sgTe9[] = { 32, 227, 233, 0 };
S sUef[] = { 228, 239, 0 };
S sgNedR[] = { 32, 221, 237, 225, 0 };
S sgf5[] = { 32, 245, 0 };
S sf5f4fc[] = { 245, 244, 252, 0 };
S sVeb[] = { 229, 235, 0 };
S sfceb[] = { 252, 235, 0 };
S se7f3Vg[] = { 231, 243, 229, a };
S secM[] = { 236, 220, 0 };
S sVe9f2[] = { 229, 233, 242, 0 };
S sedN[] = { 237, 221, 0 };
S sf4e7f2g[] = { 244, 231, 242, a };
S sf1f9[] = { 241, 249, 0 };
S sOf4[] = { 222, 244, 0 };
S sf3f4e7ed[] = { 243, 244, 231, 237, 0 };
S sf3f5[] = { 243, 245, 0 };
S sPedR[] = { 223, 237, 225, 0 };
S sRf6[] = { 225, 246, 0 };
S sgecVg[] = { 32, 236, 229, a };
S sPRg[] = { 223, 225, a };
S sf7V[] = { 247, 229, 0 };
S sf3f4V[] = { 243, 244, 229, 0 };
S sgNed[] = { 32, 221, 237, 0 };
S sgf3R[] = { 32, 243, 225, 0 };
S sf9f2[] = { 249, 242, 0 };
S sgf4e7f2[] = { 32, 244, 231, 242, 0 };
S se7f3V[] = { 231, 243, 229, 0 };
S se7f2g[] = { 231, 242, a };
S sgW[] = { 32, 230, 0 };
S sf9f2g[] = { 249, 242, a };
S sebRg[] = { 235, 225, a };
S sNf7[] = { 221, 247, 0 };
S sgeag[] = { 32, 234, a };
S sVPed[] = { 229, 223, 237, 0 };
S sfced[] = { 252, 237, 0 };
S sgf0e9[] = { 32, 240, 233, 0 };
S sTV[] = { 227, 229, 0 };
S sTf5[] = { 227, 245, 0 };
S sgf0Med[] = { 32, 240, 220, 237, 0 };
S sVe9f2g[] = { 229, 233, 242, a };
S sf4e7f2[] = { 244, 231, 242, 0 };
S sfdf1[] = { 253, 241, 0 };
S seff5ed[] = { 239, 245, 237, 0 };
S sVPedR[] = { 229, 223, 237, 225, 0 };
S sf7R[] = { 247, 225, 0 };
S sMU[] = { 220, 228, 0 };
S sgeae9g[] = { 32, 234, 233, a };
S sTe9R[] = { 227, 233, 225, 0 };
S sVf6[] = { 229, 246, 0 };
S sRec[] = { 225, 236, 0 };
S sf4efed[] = { 244, 239, 237, 0 };
S sf3f0[] = { 243, 240, 0 };
S sVf0[] = { 229, 240, 0 };
S sf4N[] = { 244, 221, 0 };
S se9ec[] = { 233, 236, 0 };
S sgece9R[] = { 32, 236, 233, 225, 0 };
S sf7e9[] = { 247, 233, 0 };
S seae9g[] = { 234, 233, a };
S sfcecef[] = { 252, 236, 239, 0 };
S sf4e9eaM[] = { 244, 233, 234, 220, 0 };
S sf9ec[] = { 249, 236, 0 };
S seff5ecV[] = { 239, 245, 236, 229, 0 };
S se8R[] = { 232, 225, 0 };
S sTef[] = { 227, 239, 0 };
S sVf1R[] = { 229, 241, 225, 0 };
S sebe7[] = { 235, 231, 0 };
S sVf3[] = { 229, 243, 0 };
S sfdf3[] = { 253, 243, 0 };
S sgf3f5[] = { 32, 243, 245, 0 };
S sedf9g[] = { 237, 249, a };
S sece9R[] = { 236, 233, 225, 0 };
S sf4f3[] = { 244, 243, 0 };
S sf6f9[] = { 246, 249, 0 };
S sf0e9efg[] = { 240, 233, 239, a };
S sVfd[] = { 229, 253, 0 };
S sgebef[] = { 32, 235, 239, 0 };
S sNf3[] = { 221, 243, 0 };
S sgf0e9ef[] = { 32, 240, 233, 239, 0 };
S sf1P[] = { 241, 223, 0 };
S seeR[] = { 238, 225, 0 };
S sMedf9g[] = { 220, 237, 249, a };
S secf0ef[] = { 236, 240, 239, 0 };
S sebO[] = { 235, 222, 0 };
S sgReb[] = { 32, 225, 235, 0 };
S sf7Ve9g[] = { 247, 229, 233, a };
S se8V[] = { 232, 229, 0 };
S sUP[] = { 228, 223, 0 };
S sgf4f1[] = { 32, 244, 241, 0 };
S sefe9g[] = { 239, 233, a };
S sf6V[] = { 246, 229, 0 };
S sRebeb[] = { 225, 235, 235, 0 };
S sVf4R[] = { 229, 244, 225, 0 };
S sgf8[] = { 32, 248, 0 };
S sedVg[] = { 237, 229, a };
S sPf4[] = { 223, 244, 0 };
S sVf5[] = { 229, 245, 0 };
S se7ec[] = { 231, 236, 0 };
S sece7[] = { 236, 231, 0 };
S sf3ea[] = { 243, 234, 0 };
S sRT[] = { 225, 227, 0 };
S sgTe9R[] = { 32, 227, 233, 225, 0 };
S secVf4[] = { 236, 229, 244, 0 };
S sPea[] = { 223, 234, 0 };
S sf4fcg[] = { 244, 252, a };
S sf9ed[] = { 249, 237, 0 };

N l18n0[] = { { sRf5f4, .491 }, { sUVed, .446 }, { sccf0Ped, .476 }, { sgRed, .208 }, { sVf5, .149 }, H };
N l18n1[] = { { sgf4e7, .743 }, H };
N l18n2[] = { { sOg, .714 }, { sf3Vg, 1.004 }, H };
N l18n3[] = { { sgf3, 1.130 }, { sRf0fc, .625 }, { seff2, .327 }, H };
N l18n4[] = { { sgU, .595 }, { sedRg, 1.874 }, H };
N l18n5[] = { { sf4e9, .922 }, H };
N l18n6[] = { { scaMecf0, .535 }, H };
N l18n7[] = { { seeV, .327 }, H };
N l18n9[] = { { seff5ecV, .297 }, { se8R, .149 }, H };
N l18n10[] = { { sede7, .357 }, H };
N l18n11[] = { { se7f2, .178 }, { sgf0Med, .238 }, H };
N l18n12[] = { { sf4Redg, .803 }, H };
N l18n13[] = { { sece9, .297 }, H };
N l18n14[] = { { sefedg, .937 }, { sf1ef, .297 }, { sf0Ped, .357 }, H };
N l18n16[] = { { sebeb, .268 }, H };
N l18n17[] = { { sefg, 3.479 }, { sf0f1, .268 }, { sebM, .238 }, { sVf6, .149 }, H };
N l18n18[] = { { sf4e7ed, .803 }, { scaM, .297 }, H };
N l18n19[] = { { sf4e9ea, .357 }, H };
N l18n20[] = { { sgf4, 2.220 }, H };
N l18n21[] = { { sgeaR, 1.219 }, { sgV, .813 }, { sgf0ef, .476 }, { sgRf0fc, .555 }, { sUe9, .268 }, H };
N l18n22[] = { { se9ef, .833 }, { se7edg, 1.539 }, { sOf4, .178 }, H };
N l18n23[] = { { sgc7, .178 }, H };
N l18n24[] = { { sRe9g, 2.208 }, { sgb8, .099 }, H };
N l18n25[] = { { se7g, 1.829 }, { sPedf4f5, .476 }, H };
N l18n28[] = { { se7f3, .446 }, H };
N l18n29[] = { { sf5f2g, .803 }, H };
N l18n30[] = { { sf7V, .178 }, H };
N l18n31[] = { { sgefg, .476 }, { sgf4Rg, .278 }, { sfceb, .178 }, H };
N l18n32[] = { { sf1R, .654 }, H };
N l18n33[] = { { sgRf0, .625 }, { sPg, .580 }, { sf4Vg, .602 }, H };
N l18n36[] = { { sf3e7g, .468 }, H };
N l18n37[] = { { sgf5, .119 }, H };
N l18n38[] = { { sgW, .119 }, H };
N l18n40[] = { { se9R, .654 }, { sf4M, .506 }, { sPf0Vg, .892 }, H };
N l18n41[] = { { secVg, 1.071 }, H };
N l18n42[] = { { sNf7, .178 }, H };
N l18n43[] = { { sNedR, .625 }, H };
N l18n44[] = { { sf0fcg, .937 }, H };
N l18n45[] = { { sVf2g, .669 }, { se7f4, .238 }, H };
N l18n46[] = { { sf0e9efg, .446 }, H };
N l18n47[] = { { sRf0, .803 }, { seae9g, .335 }, H };
N l18n48[] = { { sfcec, .268 }, { secM, .178 }, H };
N l18n49[] = { { sf4f5g, .602 }, H };
N l18n50[] = { { sgece9R, .198 }, H };
N l18n51[] = { { se9Mg, .535 }, { sebO, .149 }, H };
N l18n52[] = { { sVe9, 1.041 }, { sgRf5f4, .436 }, { sgf3f4e7, .357 }, H };
N l18n53[] = { { seaef, .387 }, { se9eaM, .312 }, { sPf4, .149 }, H };
N l18n54[] = { { seff5, 2.825 }, { scaMec, .401 }, { sgf6, .159 }, H };
N l18n55[] = { { sgecR, .208 }, { sge7, .119 }, H };
N l18n56[] = { { sgf4eff5, 1.427 }, H };
N l18n57[] = { { sc7g, .401 }, { sccf0P, .357 }, { sf9f2, .178 }, { sf4N, .149 }, H };
N l18n58[] = { { sPedf4, .357 }, H };
N l18n60[] = { { sedf9, .208 }, H };
N l18n63[] = { { sMeb, .297 }, H };
N l18n64[] = { { sRf1, .416 }, H };
N l18n65[] = { { secN, .446 }, { sfced, .178 }, H };
N l18n67[] = { { sf4e7g, .669 }, H };
N l18n68[] = { { sgf0M, .297 }, H };
N l18n69[] = { { sf0V, .714 }, { se9efed, .312 }, { secVf4, .223 }, H };
N l18n70[] = { { sf3f4efg, .803 }, H };
N l18n71[] = { { seaR, 1.487 }, { sf9g, .848 }, { sgf7, .198 }, H };
N l18n72[] = { { sgedR, .387 }, { sf4fc, .327 }, { sedVg, .335 }, H };
N l18n73[] = { { se9f2, .268 }, { sf4e7f2, .268 }, H };
N l18n74[] = { { seaRe9, .892 }, { sgca, .337 }, H };
N l18n76[] = { { sgf3f4ef, .397 }, { sf3ef, .178 }, H };
N l18n77[] = { { se8V, .149 }, H };
N l18n79[] = { { sSR, .208 }, H };
N l18n80[] = { { sMec, .446 }, H };
N l18n81[] = { { sRf2, .625 }, H };
N l18n82[] = { { sf4eff5g, 2.498 }, { seaMg, .602 }, { sPRg, .401 }, { sRT, .149 }, H };
N l18n83[] = { { se7f3Vg, .535 }, { sf6f9, .149 }, H };
N l18n84[] = { { sebef, .476 }, { secf0e9ef, .416 }, H };
N l18n85[] = { { sf3f4e7ed, .357 }, H };
N l18n86[] = { { sVeb, .178 }, H };
N l18n87[] = { { se9g, 3.747 }, { seaf1, .268 }, { sf5ec, .238 }, H };
N l18n88[] = { { sgRf5, .327 }, { sgf8, .099 }, H };
N l18n89[] = { { sgf4ef, 1.665 }, { sgccf0P, .317 }, H };
N l18n90[] = { { se9f3, .268 }, { seceff5g, .714 }, H };
N l18n91[] = { { sMecf0e9, .476 }, { sgcb, .099 }, H };
N l18n92[] = { { sRedg, 1.807 }, { sVPedR, .357 }, { sTef, .149 }, H };
N l18n93[] = { { sf3f0, .149 }, H };
N l18n94[] = { { sf3R, .446 }, { sNeb, .208 }, H };
N l18n95[] = { { sRg, 4.951 }, { sgNedR, .238 }, H };
N l18n96[] = { { sUVedg, .892 }, { sedN, .178 }, H };
N l18n97[] = { { sMed, .387 }, { sgf4e7g, .278 }, H };
N l18n98[] = { { sRf3, .327 }, { sf7e9, .149 }, H };
N l18n99[] = { { sgecV, .416 }, { sRf0fcg, 1.249 }, { seff2g, .736 }, H };
N l18n100[] = { { sf1V, .297 }, H };
N l18n101[] = { { sf4e9g, .602 }, { seff5ed, .268 }, H };
N l18n102[] = { { sebR, .387 }, H };
N l18n103[] = { { seeVg, .535 }, { sVf1R, .223 }, H };
N l18n104[] = { { sf5ed, .357 }, H };
N l18n105[] = { { sPedR, .268 }, H };
N l18n106[] = { { sgea, 1.566 }, { sefe9, .327 }, { sede7g, .468 }, H };
N l18n107[] = { { sf4ef, 2.201 }, { se7f2g, .401 }, { sUP, .149 }, H };
N l18n108[] = { { sgcc, .377 }, H };
N l18n109[] = { { sgeae9, .208 }, H };
N l18n110[] = { { sf2g, 4.327 }, { sedf4f5, .401 }, { sTR, .208 }, H };
N l18n111[] = { { sgf4f1, .149 }, H };
N l18n112[] = { { secNed, .446 }, H };
N l18n114[] = { { sf4e7edg, 1.606 }, H };
N l18n115[] = { { secef, .595 }, { sRf4, .476 }, H };
N l18n116[] = { { sMedf9g, .446 }, H };
N l18n117[] = { { sfcecef, .223 }, H };
N l18n118[] = { { sf0eff5, .758 }, { se9efg, .870 }, { seaRed, .401 }, { seag, .312 }, H };
N l18n119[] = { { sgc7g, .268 }, H };
N l18n120[] = { { sVed, .476 }, { sf3f4V, .268 }, H };
N l18n122[] = { { sgVPf0, .397 }, H };
N l18n123[] = { { sgeb, .238 }, { sUef, .178 }, H };
N l18n124[] = { { sgM, .119 }, H };
N l18n125[] = { { sf4R, 1.130 }, { sgcd, .099 }, H };
N l18n127[] = { { sgf3f4, .743 }, H };
N l18n128[] = { { sNed, .773 }, { sf1Rg, .803 }, H };
N l18n129[] = { { sf7Ve9g, .446 }, H };
N l18n130[] = { { sgcaMec, .357 }, H };
N l18n132[] = { { secf0, .625 }, { sRf5, .357 }, H };
N l18n133[] = { { secR, .535 }, H };
N l18n135[] = { { secf0e9, .401 }, H };
N l18n136[] = { { se9Rg, 1.137 }, { sf4Mg, .602 }, { sVfd, .149 }, H };
N l18n137[] = { { sf0e9, .565 }, { sVPf0V, .595 }, H };
N l18n138[] = { { sVP, .862 }, { sgf3f5, .149 }, H };
N l18n139[] = { { sNedRg, .803 }, { seaV, .238 }, { sPea, .149 }, H };
N l18n140[] = { { sgec, 1.071 }, { sefeb, .238 }, H };
N l18n141[] = { { sgN, .674 }, { sf4f1, .268 }, { sf3Red, .312 }, H };
N l18n142[] = { { sf3f4e7, .401 }, H };
N l18n143[] = { { sgece9, .297 }, H };
N l18n146[] = { { sedef, .416 }, H };
N l18n148[] = { { sVe9g, 1.137 }, H };
N l18n149[] = { { sf0e9efed, .416 }, { se9eaMg, .625 }, { sRf6, .178 }, H };
N l18n150[] = { { seff5g, 3.948 }, { sfcf2, .238 }, H };
N l18n153[] = { { sf9f2g, .401 }, { sgTe9R, .198 }, H };
N l18n154[] = { { sVe9f2, .268 }, { sf4efed, .223 }, { sVf4R, .223 }, H };
N l18n155[] = { { sf5f0, .208 }, H };
N l18n156[] = { { seff5f2, .535 }, { sgfc, .178 }, { sedf9g, .335 }, H };
N l18n157[] = { { sged, .357 }, H };
N l18n158[] = { { sgO, .119 }, H };
N l18n159[] = { { sgcf, .139 }, H };
N l18n160[] = { { sMecf0, .446 }, { sf0Vf1, .268 }, { sgf0e9ef, .198 }, H };
N l18n161[] = { { sf3f4, 1.130 }, { sTe9R, .223 }, H };
N l18n162[] = { { sf3V, .654 }, { sgUVed, .397 }, H };
N l18n164[] = { { sedR, 1.427 }, { sfcg, 1.071 }, { sccf0, .297 }, { sfdf1, .178 }, H };
N l18n165[] = { { sf0Vg, .736 }, { se9efedg, .625 }, { se7ec, .149 }, H };
N l18n167[] = { { sf4e9eaM, .297 }, H };
N l18n168[] = { { sf1e9, .446 }, { sgedRg, .515 }, { sf4fcg, .335 }, H };
N l18n169[] = { { se9f2g, .602 }, { sf4e7f2g, .535 }, H };
N l18n170[] = { { sgVP, .625 }, { seaRe9g, 1.784 }, { sebV, .327 }, H };
N l18n171[] = { { sVf0, .149 }, H };
N l18n172[] = { { sf0M, .416 }, { sf4Red, .401 }, H };
N l18n174[] = { { sefed, .714 }, { sgee, .198 }, { sgf3R, .178 }, H };
N l18n175[] = { { sf4f3, .149 }, H };
N l18n176[] = { { sgeceff5, .278 }, H };
N l18n177[] = { { sRf2g, 1.405 }, { sgc1, .198 }, H };
N l18n178[] = { { sf3f5, .178 }, { sTV, .178 }, H };
N l18n179[] = { { sf5f4fc, .268 }, H };
N l18n182[] = { { se7ed, .714 }, H };
N l18n184[] = { { sRe9, 1.041 }, { sf1f9, .178 }, { sece9R, .223 }, H };
N l18n185[] = { { sgf4efg, .674 }, { sVPed, .268 }, H };
N l18n188[] = { { sVf1, .506 }, { sgccf0, .297 }, { sgNed, .178 }, H };
N l18n189[] = { { sf5f2, .357 }, H };
N l18n190[] = { { sPed, .565 }, { seffd, .446 }, { sgcaM, .297 }, H };
N l18n191[] = { { sgef, .456 }, { sgf4R, .238 }, H };
N l18n192[] = { { sgebef, .149 }, H };
N l18n193[] = { { se9ea, .565 }, { sf4V, .565 }, H };
N l18n194[] = { { sTf5, .178 }, H };
N l18n195[] = { { seaRf4, .357 }, { sfdg, .357 }, { sgecVg, .238 }, { seeR, .149 }, H };
N l18n196[] = { { sMg, 1.606 }, { sNf1, .357 }, { sf3e7, .268 }, H };
N l18n198[] = { { sebRg, .401 }, { sfdf3, .149 }, H };
N l18n200[] = { { sgf4e7ed, .436 }, { sPf0V, .446 }, { sf4eff5f2, .535 }, { sMU, .149 }, H };
N l18n201[] = { { secV, .862 }, { sRea, .238 }, { secf0ef, .223 }, H };
N l18n202[] = { { sgeag, .178 }, { sefe9g, .335 }, H };
N l18n203[] = { { sf5g, 3.256 }, { sf4efg, 1.740 }, { sf1M, .238 }, H };
N l18n204[] = { { sf0fc, .535 }, { sebe7, .149 }, H };
N l18n205[] = { { sVf2, .297 }, { sgeae9g, .198 }, H };
N l18n206[] = { { sf0e9ef, .535 }, { sedf4f5g, .803 }, { sVT, .208 }, H };
N l18n207[] = { { seae9, .327 }, H };
N l18n208[] = { { sgf0, 1.130 }, { sgeaRe9, .793 }, H };
N l18n209[] = { { sgR, 1.170 }, { sUV, .416 }, { sgecef, .357 }, { sf4f5, .297 }, H };
N l18n210[] = { { se9eb, .208 }, H };
N l18n211[] = { { sedg, 4.015 }, { se9M, .387 }, { sgf0e9, .178 }, { sf9ec, .149 }, H };
N l18n214[] = { { sf0eff5g, 1.427 }, H };
N l18n215[] = { { sgf4e7f2, .238 }, H };
N l18n216[] = { { sVedg, .937 }, { sMf4, .268 }, H };
N l18n218[] = { { sReb, .595 }, { sVPf0, .446 }, { sf7R, .178 }, H };
N l18n219[] = { { sVg, 3.390 }, { sgUV, .327 }, { sf0Med, .312 }, H };
N l18n221[] = { { sf4Rg, 1.004 }, H };
N l18n222[] = { { sgeaM, .327 }, { sVf3, .149 }, H };
N l18n223[] = { { sf0P, .446 }, { sf5f4, .387 }, H };
N l18n225[] = { { sgf1, .159 }, H };
N l18n226[] = { { sgS, .218 }, { sfeg, .268 }, H };
N l18n227[] = { { sf4e7, 1.279 }, { sNg, .446 }, { se9ec, .149 }, H };
N l18n228[] = { { sf9ed, .149 }, H };
N l18n229[] = { { secRg, .468 }, H };
N l18n230[] = { { sf3f4ef, .491 }, { sNf3, .149 }, H };
N l18n231[] = { { sedf4, .654 }, H };
N l18n232[] = { { sedV, .535 }, H };
N l18n234[] = { { sf0Pedf4, .476 }, { sgReb, .149 }, H };
N l18n235[] = { { sf1fc, .327 }, { sRec, .149 }, { sece7, .149 }, H };
N l18n237[] = { { sf3Redg, .625 }, H };
N l18n238[] = { { sebe9, .476 }, H };
N l18n239[] = { { sf0ef, 1.071 }, { sVf4, .446 }, H };
N l18n241[] = { { sPf0, .357 }, { sgeaRf4, .317 }, H };
N l18n242[] = { { sf4eff5, 1.695 }, { seaM, .595 }, { sPR, .297 }, { seff1, .208 }, H };
N l18n243[] = { { sgT, .436 }, { se7f3V, .268 }, { sRebeb, .223 }, H };
N l18n244[] = { { sgf0eff5, .595 }, { sgE, .178 }, { se9ed, .208 }, H };
N l18n245[] = { { sgc5, .139 }, H };
N l18n246[] = { { sfcf2g, .535 }, { sTe9, .208 }, { sf3f9, .208 }, { sgTe9, .178 }, H };
N l18n247[] = { { sf3ea, .149 }, H };
N l18n250[] = { { seceff5, .535 }, { sVe9f2g, .535 }, H };
N l18n252[] = { { sRed, 1.368 }, { seff5f2g, 1.071 }, H };
N l18n254[] = { { sf1P, .149 }, H };
N l18n255[] = { { sf6V, .149 }, H };

D l18_d = {
	"greek",
	"iso-8859-7",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.003, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, 0.001, Y, 0.004, 0.001, 0.001, Y, 0.001, Y, Y, Y,
	    Y, 0.013, V, 0.004, 0.005, 0.011, 0.001, 0.011, 0.002, 0.006, 0.021, 0.006, 0.023, 0.006, 0.001, 0.011,
	    0.005, 0.005, V, 0.006, 0.012, V, 0.002, 0.001, V, 0.002, V, V, 0.140, 0.107, 0.049, 0.098,
	    V, 0.422, 0.037, 0.067, 0.067, 0.296, 0.026, 0.130, 0.036, 0.275, 0.171, 0.132, 0.159, 0.284, 0.026, 0.334,
	    0.197, 0.152, 0.115, 0.162, 0.343, 0.187, 0.038, 0.044, 0.006, 0.059, 0.001, 0.001, 0.089, 0.045, 0.033, V },
	{ l18n0, l18n1, l18n2, l18n3, l18n4, l18n5, l18n6, l18n7, X, l18n9, l18n10, l18n11, l18n12, l18n13, l18n14, X,
	    l18n16, l18n17, l18n18, l18n19, l18n20, l18n21, l18n22, l18n23, l18n24, l18n25, X, X, l18n28, l18n29, l18n30, l18n31,
	    l18n32, l18n33, X, X, l18n36, l18n37, l18n38, X, l18n40, l18n41, l18n42, l18n43, l18n44, l18n45, l18n46, l18n47,
	    l18n48, l18n49, l18n50, l18n51, l18n52, l18n53, l18n54, l18n55, l18n56, l18n57, l18n58, X, l18n60, X, X, l18n63,
	    l18n64, l18n65, X, l18n67, l18n68, l18n69, l18n70, l18n71, l18n72, l18n73, l18n74, X, l18n76, l18n77, X, l18n79,
	    l18n80, l18n81, l18n82, l18n83, l18n84, l18n85, l18n86, l18n87, l18n88, l18n89, l18n90, l18n91, l18n92, l18n93, l18n94, l18n95,
	    l18n96, l18n97, l18n98, l18n99, l18n100, l18n101, l18n102, l18n103, l18n104, l18n105, l18n106, l18n107, l18n108, l18n109, l18n110, l18n111,
	    l18n112, X, l18n114, l18n115, l18n116, l18n117, l18n118, l18n119, l18n120, X, l18n122, l18n123, l18n124, l18n125, X, l18n127,
	    l18n128, l18n129, l18n130, X, l18n132, l18n133, X, l18n135, l18n136, l18n137, l18n138, l18n139, l18n140, l18n141, l18n142, l18n143,
	    X, X, l18n146, X, l18n148, l18n149, l18n150, X, X, l18n153, l18n154, l18n155, l18n156, l18n157, l18n158, l18n159,
	    l18n160, l18n161, l18n162, X, l18n164, l18n165, X, l18n167, l18n168, l18n169, l18n170, l18n171, l18n172, X, l18n174, l18n175,
	    l18n176, l18n177, l18n178, l18n179, X, X, l18n182, X, l18n184, l18n185, X, X, l18n188, l18n189, l18n190, l18n191,
	    l18n192, l18n193, l18n194, l18n195, l18n196, X, l18n198, X, l18n200, l18n201, l18n202, l18n203, l18n204, l18n205, l18n206, l18n207,
	    l18n208, l18n209, l18n210, l18n211, X, X, l18n214, l18n215, l18n216, X, l18n218, l18n219, X, l18n221, l18n222, l18n223,
	    X, l18n225, l18n226, l18n227, l18n228, l18n229, l18n230, l18n231, l18n232, X, l18n234, l18n235, X, l18n237, l18n238, l18n239,
	    X, l18n241, l18n242, l18n243, l18n244, l18n245, l18n246, l18n247, X, X, l18n250, X, l18n252, X, l18n254, l18n255 }
};

//
// Lng: greek
// Enc: utf8
//

S sceb1[] = { 206, 177, 0 };
S scf84[] = { 207, 132, 0 };
S scebf[] = { 206, 191, 0 };
S sceb5[] = { 206, 181, 0 };
S scebd[] = { 206, 189, 0 };
S scf84ce[] = { 207, 132, 206, 0 };
S s84ce[] = { 132, 206, 0 };
S sceb9[] = { 206, 185, 0 };
S scf80[] = { 207, 128, 0 };
S scf85[] = { 207, 133, 0 };
S sceba[] = { 206, 186, 0 };
S sbfcf[] = { 191, 207, 0 };
S scebfcf[] = { 206, 191, 207, 0 };
S scf83[] = { 207, 131, 0 };
S sb1ce[] = { 177, 206, 0 };
S sceb1ce[] = { 206, 177, 206, 0 };
S scebc[] = { 206, 188, 0 };
S s80ce[] = { 128, 206, 0 };
S scf80ce[] = { 207, 128, 206, 0 };
S scf81[] = { 207, 129, 0 };
S sceac[] = { 206, 172, 0 };
S sbace[] = { 186, 206, 0 };
S scebace[] = { 206, 186, 206, 0 };
S sb9ce[] = { 185, 206, 0 };
S sceb9ce[] = { 206, 185, 206, 0 };
S sbdce[] = { 189, 206, 0 };
S scebdce[] = { 206, 189, 206, 0 };
S sgcf84[] = { 32, 207, 132, 0 };
S sceb1g[] = { 206, 177, a };
S scebb[] = { 206, 187, 0 };
S sb1cf[] = { 177, 207, 0 };
S sceb1cf[] = { 206, 177, 207, 0 };
S sceb7[] = { 206, 183, 0 };
S scebcce[] = { 206, 188, 206, 0 };
S sbcce[] = { 188, 206, 0 };
S sceb5ce[] = { 206, 181, 206, 0 };
S sb5ce[] = { 181, 206, 0 };
S scf82[] = { 207, 130, 0 };
S scf82g[] = { 207, 130, a };
S sgcf84ce[] = { 32, 207, 132, 206, 0 };
S sbfcf85[] = { 191, 207, 133, 0 };
S scebfcf85[] = { 206, 191, 207, 133, 0 };
S scf81ce[] = { 207, 129, 206, 0 };
S s81ce[] = { 129, 206, 0 };
S scebdg[] = { 206, 189, a };
S scead[] = { 206, 173, 0 };
S scebbce[] = { 206, 187, 206, 0 };
S sbbce[] = { 187, 206, 0 };
S sceb9g[] = { 206, 185, a };
S sceaf[] = { 206, 175, 0 };
S sgceba[] = { 32, 206, 186, 0 };
S scebfg[] = { 206, 191, a };
S sceb5g[] = { 206, 181, a };
S scf8c[] = { 207, 140, 0 };
S scf83ce[] = { 207, 131, 206, 0 };
S s83ce[] = { 131, 206, 0 };
S scf84cebf[] = { 207, 132, 206, 191, 0 };
S s84cebf[] = { 132, 206, 191, 0 };
S scf85g[] = { 207, 133, a };
S sb5cf[] = { 181, 207, 0 };
S sceb5cf[] = { 206, 181, 207, 0 };
S sgcebace[] = { 32, 206, 186, 206, 0 };
S scf83cf[] = { 207, 131, 207, 0 };
S sceacce[] = { 206, 172, 206, 0 };
S s83cf[] = { 131, 207, 0 };
S sbfce[] = { 191, 206, 0 };
S scebfce[] = { 206, 191, 206, 0 };
S sacce[] = { 172, 206, 0 };
S sbfcf85g[] = { 191, 207, 133, a };
S sgceb1[] = { 32, 206, 177, 0 };
S sgcf80[] = { 32, 207, 128, 0 };
S sgcf83[] = { 32, 207, 131, 0 };
S sceb4[] = { 206, 180, 0 };
S sceb3[] = { 206, 179, 0 };
S sgcebc[] = { 32, 206, 188, 0 };
S scebaceb1[] = { 206, 186, 206, 177, 0 };
S scf89[] = { 207, 137, 0 };
S sbaceb1[] = { 186, 206, 177, 0 };
S sceadce[] = { 206, 173, 206, 0 };
S sadce[] = { 173, 206, 0 };
S sbdceb1[] = { 189, 206, 177, 0 };
S scebdceb1[] = { 206, 189, 206, 177, 0 };
S scf84cf[] = { 207, 132, 207, 0 };
S sgcebcce[] = { 32, 206, 188, 206, 0 };
S s84cf[] = { 132, 207, 0 };
S sceb1cebd[] = { 206, 177, 206, 189, 0 };
S sgcf80ce[] = { 32, 207, 128, 206, 0 };
S sb1cebd[] = { 177, 206, 189, 0 };
S safce[] = { 175, 206, 0 };
S sceafce[] = { 206, 175, 206, 0 };
S sceb3ce[] = { 206, 179, 206, 0 };
S scf84ceb7[] = { 207, 132, 206, 183, 0 };
S s84ceb7[] = { 132, 206, 183, 0 };
S sb3ce[] = { 179, 206, 0 };
S sceb4ce[] = { 206, 180, 206, 0 };
S s85ce[] = { 133, 206, 0 };
S scf85cf[] = { 207, 133, 207, 0 };
S scf85ce[] = { 207, 133, 206, 0 };
S sb4ce[] = { 180, 206, 0 };
S s85cf[] = { 133, 207, 0 };
S sgceb5[] = { 32, 206, 181, 0 };
S sceb7g[] = { 206, 183, a };
S sceae[] = { 206, 174, 0 };
S s84cebfcf[] = { 132, 206, 191, 207, 0 };
S sgceb1cf[] = { 32, 206, 177, 207, 0 };
S s84ceb1[] = { 132, 206, 177, 0 };
S scf8d[] = { 207, 141, 0 };
S scf83cf84[] = { 207, 131, 207, 132, 0 };
S s83cf84[] = { 131, 207, 132, 0 };
S sgcf83cf[] = { 32, 207, 131, 207, 0 };
S scf84ceb1[] = { 207, 132, 206, 177, 0 };
S scf87[] = { 207, 135, 0 };
S s80cebf[] = { 128, 206, 191, 0 };
S sceacg[] = { 206, 172, a };
S scf80cebf[] = { 207, 128, 206, 191, 0 };
S sbaceb1ce[] = { 186, 206, 177, 206, 0 };
S sb7ce[] = { 183, 206, 0 };
S sceb7ce[] = { 206, 183, 206, 0 };
S scebdcf[] = { 206, 189, 207, 0 };
S s83cf84ce[] = { 131, 207, 132, 206, 0 };
S sceb5ceb9[] = { 206, 181, 206, 185, 0 };
S sb5ceb9[] = { 181, 206, 185, 0 };
S sbdcf[] = { 189, 207, 0 };
S sb1ceb9[] = { 177, 206, 185, 0 };
S sceb1ceb9[] = { 206, 177, 206, 185, 0 };
S scf80cf[] = { 207, 128, 207, 0 };
S sgcead[] = { 32, 206, 173, 0 };
S s80cf[] = { 128, 207, 0 };
S sceb7cf[] = { 206, 183, 207, 0 };
S sb7cf[] = { 183, 207, 0 };
S scf81cf[] = { 207, 129, 207, 0 };
S sb1ceb9g[] = { 177, 206, 185, a };
S s81cf[] = { 129, 207, 0 };
S scf86[] = { 207, 134, 0 };
S s84ceb9[] = { 132, 206, 185, 0 };
S sadcf[] = { 173, 207, 0 };
S scf84ceb9[] = { 207, 132, 206, 185, 0 };
S sb9cf[] = { 185, 207, 0 };
S sceb9cf[] = { 206, 185, 207, 0 };
S sceb2[] = { 206, 178, 0 };
S sgceb5ce[] = { 32, 206, 181, 206, 0 };
S sceadcf[] = { 206, 173, 207, 0 };
S sgceb4[] = { 32, 206, 180, 0 };
S sceb8[] = { 206, 184, 0 };
S sceb5ceaf[] = { 206, 181, 206, 175, 0 };
S sbcceb5[] = { 188, 206, 181, 0 };
S sb5ceaf[] = { 181, 206, 175, 0 };
S scebcceb5[] = { 206, 188, 206, 181, 0 };
S sb9cebf[] = { 185, 206, 191, 0 };
S sceb9cebf[] = { 206, 185, 206, 191, 0 };
S sbdceb1g[] = { 189, 206, 177, a };
S scf8e[] = { 207, 142, 0 };
S s87ce[] = { 135, 206, 0 };
S sb1cf80[] = { 177, 207, 128, 0 };
S s8cce[] = { 140, 206, 0 };
S scf87ce[] = { 207, 135, 206, 0 };
S sceb1cf80[] = { 206, 177, 207, 128, 0 };
S scf8cce[] = { 207, 140, 206, 0 };
S sb1cebdg[] = { 177, 206, 189, a };
S s80cebfcf[] = { 128, 206, 191, 207, 0 };
S sbccf[] = { 188, 207, 0 };
S s84cebfg[] = { 132, 206, 191, a };
S sceadcebd[] = { 206, 173, 206, 189, 0 };
S sadcebd[] = { 173, 206, 189, 0 };
S scebccf[] = { 206, 188, 207, 0 };
S safcf[] = { 175, 207, 0 };
S s8ccf[] = { 140, 207, 0 };
S sb2ce[] = { 178, 206, 0 };
S sceafcf[] = { 206, 175, 207, 0 };
S sceb2ce[] = { 206, 178, 206, 0 };
S sadcebdce[] = { 173, 206, 189, 206, 0 };
S scf8ccf[] = { 207, 140, 207, 0 };
S s8cg[] = { 140, a };
S scf8cg[] = { 207, 140, a };
S scebfcebd[] = { 206, 191, 206, 189, 0 };
S s80ceb5[] = { 128, 206, 181, 0 };
S sceb7cebd[] = { 206, 183, 206, 189, 0 };
S scf80ceb5[] = { 207, 128, 206, 181, 0 };
S sbfcebd[] = { 191, 206, 189, 0 };
S sb7cebd[] = { 183, 206, 189, 0 };
S sb7cebdg[] = { 183, 206, 189, a };
S sgcebf[] = { 32, 206, 191, 0 };
S scf81ceb1[] = { 207, 129, 206, 177, 0 };
S sceb8ce[] = { 206, 184, 206, 0 };
S sgceb3[] = { 32, 206, 179, 0 };
S sb8ce[] = { 184, 206, 0 };
S sceb9ceb1[] = { 206, 185, 206, 177, 0 };
S scebe[] = { 206, 190, 0 };
S scebdcf84[] = { 206, 189, 207, 132, 0 };
S sb9ceb1[] = { 185, 206, 177, 0 };
S s81ceb1[] = { 129, 206, 177, 0 };
S sceb6[] = { 206, 182, 0 };
S sgceb4ce[] = { 32, 206, 180, 206, 0 };
S sbdcf84[] = { 189, 207, 132, 0 };
S scf83ceb5[] = { 207, 131, 206, 181, 0 };
S s83ceb5[] = { 131, 206, 181, 0 };
S saccf[] = { 172, 207, 0 };
S sb1cf82[] = { 177, 207, 130, 0 };
S sceb1cf82[] = { 206, 177, 207, 130, 0 };
S sceaccf[] = { 206, 172, 207, 0 };
S scebece[] = { 206, 190, 206, 0 };
S sbccf80[] = { 188, 207, 128, 0 };
S s89cf[] = { 137, 207, 0 };
S sb1cf82g[] = { 177, 207, 130, a };
S scebccf80[] = { 206, 188, 207, 128, 0 };
S sbece[] = { 190, 206, 0 };
S scebaceac[] = { 206, 186, 206, 172, 0 };
S sb1cebb[] = { 177, 206, 187, 0 };
S scebacf[] = { 206, 186, 207, 0 };
S sceb1cebb[] = { 206, 177, 206, 187, 0 };
S s84ceb7ce[] = { 132, 206, 183, 206, 0 };
S scebccebf[] = { 206, 188, 206, 191, 0 };
S sbccebf[] = { 188, 206, 191, 0 };
S sbaceac[] = { 186, 206, 172, 0 };
S scf89cf[] = { 207, 137, 207, 0 };
S sgceadce[] = { 32, 206, 173, 206, 0 };
S scf86ce[] = { 207, 134, 206, 0 };
S scf80ceb9[] = { 207, 128, 206, 185, 0 };
S sb9ceba[] = { 185, 206, 186, 0 };
S s86ce[] = { 134, 206, 0 };
S safcebd[] = { 175, 206, 189, 0 };
S s8dcf[] = { 141, 207, 0 };
S scf89g[] = { 207, 137, a };
S sgce9c[] = { 32, 206, 156, 0 };
S sbfcf85ce[] = { 191, 207, 133, 206, 0 };
S scf8dcf[] = { 207, 141, 207, 0 };
S s80ceb9[] = { 128, 206, 185, 0 };
S sce9c[] = { 206, 156, 0 };
S sbccf80ce[] = { 188, 207, 128, 206, 0 };
S sceb9ceba[] = { 206, 185, 206, 186, 0 };
S sgceb1ce[] = { 32, 206, 177, 206, 0 };
S scf84ceb5[] = { 207, 132, 206, 181, 0 };
S sgcf83ce[] = { 32, 207, 131, 206, 0 };
S s84ceb5[] = { 132, 206, 181, 0 };
S sceafcebd[] = { 206, 175, 206, 189, 0 };
S scebdceb5[] = { 206, 189, 206, 181, 0 };
S s80cf8c[] = { 128, 207, 140, 0 };
S sceb6ce[] = { 206, 182, 206, 0 };
S scebcceb1[] = { 206, 188, 206, 177, 0 };
S sce9a[] = { 206, 154, 0 };
S sbdceb5[] = { 189, 206, 181, 0 };
S sgcebd[] = { 32, 206, 189, 0 };
S scf80cf8c[] = { 207, 128, 207, 140, 0 };
S sbcceb1[] = { 188, 206, 177, 0 };
S sb6ce[] = { 182, 206, 0 };
S sbfcf85cf[] = { 191, 207, 133, 207, 0 };
S sb9ceb1g[] = { 185, 206, 177, a };
S s84ceac[] = { 132, 206, 172, 0 };
S sceb5cf81[] = { 206, 181, 207, 129, 0 };
S scf84ceac[] = { 207, 132, 206, 172, 0 };
S s9ace[] = { 154, 206, 0 };
S sgce9a[] = { 32, 206, 154, 0 };
S sb5cf81[] = { 181, 207, 129, 0 };
S sce9ace[] = { 206, 154, 206, 0 };
S scebbcf[] = { 206, 187, 207, 0 };
S sb5ceb9g[] = { 181, 206, 185, a };
S sbbcf[] = { 187, 207, 0 };
S sb1cebbce[] = { 177, 206, 187, 206, 0 };
S scebbcebf[] = { 206, 187, 206, 191, 0 };
S sceaeg[] = { 206, 174, a };
S scebbceb9[] = { 206, 187, 206, 185, 0 };
S sgcf84cf[] = { 32, 207, 132, 207, 0 };
S sgcebdce[] = { 32, 206, 189, 206, 0 };
S sbbcebf[] = { 187, 206, 191, 0 };
S sbbceb9[] = { 187, 206, 185, 0 };
S sgcebfg[] = { 32, 206, 191, a };
S sb1cf84[] = { 177, 207, 132, 0 };
S sbcceb5g[] = { 188, 206, 181, a };
S s84ceb9ce[] = { 132, 206, 185, 206, 0 };
S s84ceb1ce[] = { 132, 206, 177, 206, 0 };
S sgce9ace[] = { 32, 206, 154, 206, 0 };
S sb5cebd[] = { 181, 206, 189, 0 };
S sceb5cebd[] = { 206, 181, 206, 189, 0 };
S sb1cf84ce[] = { 177, 207, 132, 206, 0 };
S sceb1cf84[] = { 206, 177, 207, 132, 0 };
S scf83ceb1[] = { 207, 131, 206, 177, 0 };
S sb5ceafcf[] = { 181, 206, 175, 207, 0 };
S s80ceaf[] = { 128, 206, 175, 0 };
S s81ceb9[] = { 129, 206, 185, 0 };
S scf81ceb9[] = { 207, 129, 206, 185, 0 };
S s83ceb1[] = { 131, 206, 177, 0 };
S sb5cf84[] = { 181, 207, 132, 0 };
S sbfcf8d[] = { 191, 207, 141, 0 };
S s83ceb5g[] = { 131, 206, 181, a };
S s84ceb1g[] = { 132, 206, 177, a };
S sbccead[] = { 188, 206, 173, 0 };
S sceb7cf83[] = { 206, 183, 207, 131, 0 };
S saccebc[] = { 172, 206, 188, 0 };
S sb7cf83[] = { 183, 207, 131, 0 };
S scebccead[] = { 206, 188, 206, 173, 0 };
S scf80ceaf[] = { 207, 128, 206, 175, 0 };
S scebfcf8d[] = { 206, 191, 207, 141, 0 };
S sceaccebc[] = { 206, 172, 206, 188, 0 };
S sceb5cf84[] = { 206, 181, 207, 132, 0 };
S sb1cf80cf[] = { 177, 207, 128, 207, 0 };
S sceb4ceb5[] = { 206, 180, 206, 181, 0 };
S saece[] = { 174, 206, 0 };
S s86cf[] = { 134, 207, 0 };
S scebdcebf[] = { 206, 189, 206, 191, 0 };
S sb1cf81[] = { 177, 207, 129, 0 };
S sceb1cf81[] = { 206, 177, 207, 129, 0 };
S sbdcebf[] = { 189, 206, 191, 0 };
S s80ceb9ce[] = { 128, 206, 185, 206, 0 };
S sceb4cf[] = { 206, 180, 207, 0 };
S scf80ceac[] = { 207, 128, 206, 172, 0 };
S sbfcebdg[] = { 191, 206, 189, a };
S sceaece[] = { 206, 174, 206, 0 };
S s80cf8cg[] = { 128, 207, 140, a };
S sb1cebdce[] = { 177, 206, 189, 206, 0 };
S s80ceac[] = { 128, 206, 172, 0 };
S sb4ceb5[] = { 180, 206, 181, 0 };
S sb4cf[] = { 180, 207, 0 };
S sb5cebdg[] = { 181, 206, 189, a };
S sb7cf83ce[] = { 183, 207, 131, 206, 0 };
S scebbceb1[] = { 206, 187, 206, 177, 0 };
S scf86cf[] = { 207, 134, 207, 0 };
S saccebd[] = { 172, 206, 189, 0 };
S sbacebf[] = { 186, 206, 191, 0 };
S s8ecf[] = { 142, 207, 0 };
S scebacebf[] = { 206, 186, 206, 191, 0 };
S sbbceb1[] = { 187, 206, 177, 0 };
S sceb3cf[] = { 206, 179, 207, 0 };
S s84ceb7cf[] = { 132, 206, 183, 207, 0 };
S s85cf84[] = { 133, 207, 132, 0 };
S sb9cebfg[] = { 185, 206, 191, a };
S sceaccebd[] = { 206, 172, 206, 189, 0 };
S scf8ecf[] = { 207, 142, 207, 0 };
S sb3cf[] = { 179, 207, 0 };
S sceb9ceac[] = { 206, 185, 206, 172, 0 };
S sb9cebace[] = { 185, 206, 186, 206, 0 };
S sgceb3ce[] = { 32, 206, 179, 206, 0 };
S scf85cf84[] = { 207, 133, 207, 132, 0 };
S sbccebfcf[] = { 188, 206, 191, 207, 0 };
S sb9ceac[] = { 185, 206, 172, 0 };
S sceafg[] = { 206, 175, a };
S sceb1cf85[] = { 206, 177, 207, 133, 0 };
S safcf80ce[] = { 175, 207, 128, 206, 0 };
S s85cf82[] = { 133, 207, 130, 0 };
S s85cf82g[] = { 133, 207, 130, a };
S sceafcf80[] = { 206, 175, 207, 128, 0 };
S sgce9ccf[] = { 32, 206, 156, 207, 0 };
S sbdceb7[] = { 189, 206, 183, 0 };
S scebdceb7[] = { 206, 189, 206, 183, 0 };
S s85cebd[] = { 133, 206, 189, 0 };
S sb1cf85[] = { 177, 207, 133, 0 };
S s9ccf[] = { 156, 207, 0 };
S scf85cf82[] = { 207, 133, 207, 130, 0 };
S sb5ceb9ce[] = { 181, 206, 185, 206, 0 };
S scf85cebd[] = { 207, 133, 206, 189, 0 };
S sceadcf81[] = { 206, 173, 207, 129, 0 };
S safcf80[] = { 175, 207, 128, 0 };
S s81ceb1g[] = { 129, 206, 177, a };
S sb5cf81ce[] = { 181, 207, 129, 206, 0 };
S sce9ccf[] = { 206, 156, 207, 0 };
S sgcebb[] = { 32, 206, 187, 0 };
S sb4ceb5ce[] = { 180, 206, 181, 206, 0 };
S sadcf81[] = { 173, 207, 129, 0 };
S sbdcf84ce[] = { 189, 207, 132, 206, 0 };
S scf81cf8c[] = { 207, 129, 207, 140, 0 };
S sbfceb9[] = { 191, 206, 185, 0 };
S sb1cf85cf[] = { 177, 207, 133, 207, 0 };
S sceaecf[] = { 206, 174, 207, 0 };
S sbdcf84cf[] = { 189, 207, 132, 207, 0 };
S sgcebbce[] = { 32, 206, 187, 206, 0 };
S scebaceb9[] = { 206, 186, 206, 185, 0 };
S scebeceb5[] = { 206, 190, 206, 181, 0 };
S sbfcf82g[] = { 191, 207, 130, a };
S safcebdce[] = { 175, 206, 189, 206, 0 };
S s89ce[] = { 137, 206, 0 };
S s8dce[] = { 141, 206, 0 };
S sbeceb5[] = { 190, 206, 181, 0 };
S s81cf8c[] = { 129, 207, 140, 0 };
S sbbceb5[] = { 187, 206, 181, 0 };
S sceb1cf83[] = { 206, 177, 207, 131, 0 };
S sgceadcf[] = { 32, 206, 173, 207, 0 };
S sgcf80cf[] = { 32, 207, 128, 207, 0 };
S scebfceb9[] = { 206, 191, 206, 185, 0 };
S sbaceb9[] = { 186, 206, 185, 0 };
S sb1cf83[] = { 177, 207, 131, 0 };
S sgceb2[] = { 32, 206, 178, 0 };
S sce91[] = { 206, 145, 0 };
S s84cf8c[] = { 132, 207, 140, 0 };
S scebbceb5[] = { 206, 187, 206, 181, 0 };
S sbfcf82[] = { 191, 207, 130, 0 };
S sadcf81ce[] = { 173, 207, 129, 206, 0 };

N l19n1[] = { { scebfg, 2.611 }, { sbfcf85ce, .377 }, { sgcebbce, .218 }, H };
N l19n3[] = { { sbdg, 1.339 }, { sbccf80, .312 }, H };
N l19n4[] = { { sceb8ce, .491 }, { sbfcf85cf, .337 }, H };
N l19n6[] = { { sce9ace, .379 }, H };
N l19n7[] = { { s87ce, .268 }, { s84ceb9ce, .317 }, H };
N l19n8[] = { { scf87, .551 }, { sceb6, .327 }, { sceb5cebd, .476 }, H };
N l19n11[] = { { sb5g, 1.131 }, H };
N l19n12[] = { { sgcebcce, .932 }, H };
N l19n13[] = { { sbcceb1, .268 }, H };
N l19n14[] = { { s84ceac, .253 }, H };
N l19n15[] = { { scf89cf, .446 }, H };
N l19n16[] = { { sb1ceb9, .521 }, { sb9ceb1g, .506 }, H };
N l19n19[] = { { sceb1g, 3.716 }, { scf82g, 3.247 }, { sb9ceba, .283 }, H };
N l19n20[] = { { s8cg, .357 }, { sbccebfcf, .258 }, H };
N l19n21[] = { { sb9ce, 1.141 }, { sceb9ce, 2.567 }, { scebfcf85, 2.827 }, H };
N l19n23[] = { { sgcebdce, .317 }, H };
N l19n24[] = { { sceb1cf80, .803 }, { sb5cebdg, .417 }, H };
N l19n25[] = { { sceb7, 1.622 }, { sceb9ceac, .387 }, H };
N l19n26[] = { { scf80cf8c, .536 }, { sbbceb5, .164 }, H };
N l19n27[] = { { sb1cf80cf, .298 }, { sceb1cf81, .417 }, H };
N l19n29[] = { { sb1ce, 1.329 }, H };
N l19n30[] = { { sb5ceaf, .431 }, { sceb1cf82, .625 }, H };
N l19n31[] = { { sgcf80, .848 }, H };
N l19n32[] = { { sceb9cf, .692 }, H };
N l19n33[] = { { s80ceb9, .283 }, { sceb1cf83, .327 }, H };
N l19n35[] = { { sgcebfg, .317 }, H };
N l19n36[] = { { sb1cf82g, .625 }, { sceb1cf84, .476 }, H };
N l19n38[] = { { scebace, 2.611 }, { sb9cf, .307 }, { sb1cebb, .298 }, { s83ceb1, .223 }, H };
N l19n39[] = { { sceb1cf85, .357 }, { sbaceb9, .164 }, H };
N l19n40[] = { { sceb9ceb1, .655 }, H };
N l19n41[] = { { sgceb1, .878 }, H };
N l19n42[] = { { scf89, .744 }, { sceb8, .446 }, { sadcebdce, .476 }, { sceb7cebd, .714 }, { scebaceac, .595 }, H };
N l19n43[] = { { scf81cf8c, .327 }, H };
N l19n44[] = { { sbdceb1, .714 }, { sce9a, .268 }, { sgce9a, .253 }, H };
N l19n45[] = { { scebfcf8d, .446 }, H };
N l19n46[] = { { s80ce, 1.280 }, { sb1cf, 1.091 }, H };
N l19n49[] = { { scebacf, .446 }, H };
N l19n50[] = { { saeg, .238 }, H };
N l19n51[] = { { sce9ccf, .268 }, H };
N l19n52[] = { { sbace, 1.161 }, { sgceb2, .164 }, H };
N l19n53[] = { { scf83cf84, 1.131 }, { sb5cf81, .253 }, H };
N l19n55[] = { { scebbce, 1.986 }, { scf8cce, .603 }, H };
N l19n56[] = { { sceacce, 1.361 }, H };
N l19n57[] = { { scebaceb1, 1.488 }, { sbaceb1ce, .714 }, { sbcceb5, .431 }, H };
N l19n59[] = { { sceb9, 3.437 }, { s85g, 1.086 }, H };
N l19n60[] = { { sb1cebd, .684 }, { sb2ce, .248 }, H };
N l19n61[] = { { sadcf81, .179 }, H };
N l19n63[] = { { s80cf, .337 }, { s84cebfg, .774 }, { sgceb3, .327 }, H };
N l19n64[] = { { sgcf83, .848 }, { s81ceb9, .223 }, H };
N l19n65[] = { { sbfg, 1.161 }, { sb4ceb5, .208 }, H };
N l19n66[] = { { scf8ccf, .536 }, { sgce9c, .283 }, { scebbcf, .379 }, H };
N l19n67[] = { { sceaccf, .469 }, { sceb9ceba, .565 }, { s80cf8c, .268 }, H };
N l19n68[] = { { sb1cf84ce, .317 }, H };
N l19n69[] = { { s84ceb1, .565 }, { sbacf, .198 }, { s89ce, .109 }, H };
N l19n70[] = { { scf85g, 2.444 }, { sbbceb9, .238 }, H };
N l19n72[] = { { scebcce, 2.410 }, { s83cf84, .565 }, { s81ceb1g, .357 }, H };
N l19n73[] = { { sceadce, 1.094 }, { sb7g, .610 }, H };
N l19n74[] = { { sgceb4, .446 }, { sb9cebf, .417 }, { scebbceb1, .387 }, H };
N l19n75[] = { { sgcf84, 1.666 }, H };
N l19n76[] = { { sceba, 2.143 }, { s84cebfcf, .794 }, H };
N l19n77[] = { { s81ce, .913 }, H };
N l19n78[] = { { sbdcf84, .327 }, { sce9c, .283 }, { sbfcebdg, .417 }, H };
N l19n79[] = { { scebccead, .446 }, H };
N l19n81[] = { { safg, .193 }, { scf85cf82, .357 }, { scebaceb9, .327 }, H };
N l19n82[] = { { sceb9cebf, .833 }, { s83ceb5, .327 }, { sb1cf85cf, .218 }, H };
N l19n83[] = { { sbbce, .883 }, { scebccf, .580 }, { scf8dcf, .424 }, H };
N l19n84[] = { { sceadcf, .692 }, { s9ace, .169 }, H };
N l19n85[] = { { sgceb5, .610 }, H };
N l19n86[] = { { sb7cebdg, .684 }, { s89cf, .208 }, { sb5cf84, .223 }, { scebbceb5, .327 }, H };
N l19n87[] = { { sceb5g, 2.544 }, { scf85cf84, .387 }, H };
N l19n88[] = { { sbdceb5, .268 }, H };
N l19n89[] = { { scebdce, 2.522 }, H };
N l19n90[] = { { sceaece, .312 }, H };
N l19n91[] = { { sb3ce, .427 }, { scebcceb1, .536 }, H };
N l19n93[] = { { scebb, 1.652 }, { scf8c, 1.116 }, H };
N l19n94[] = { { sceac, 1.756 }, { s81cf, .327 }, H };
N l19n95[] = { { sceb5cf81, .506 }, H };
N l19n98[] = { { scebbceb9, .476 }, { s81cf8c, .164 }, H };
N l19n99[] = { { s80cebf, .536 }, { scebacebf, .387 }, H };
N l19n100[] = { { scebdcf, .781 }, { sbbcf, .169 }, { scf8ecf, .290 }, H };
N l19n101[] = { { sceaecf, .246 }, H };
N l19n103[] = { { scebcceb5, .863 }, { sgceadce, .397 }, H };
N l19n104[] = { { sceb5cf84, .446 }, { safcebdce, .218 }, H };
N l19n105[] = { { sbacebf, .193 }, H };
N l19n106[] = { { scebece, .469 }, { sgceadcf, .218 }, H };
N l19n107[] = { { scf80ce, 2.879 }, { sceafce, .982 }, H };
N l19n108[] = { { scebdceb1, 1.428 }, { sceaccebc, .446 }, { sb3cf, .129 }, H };
N l19n109[] = { { sbccf80ce, .377 }, H };
N l19n110[] = { { scebc, 1.994 }, { scf8d, .565 }, { sbdceb7, .179 }, H };
N l19n111[] = { { scead, 1.339 }, { scf80ceac, .417 }, { sceaccebd, .387 }, H };
N l19n112[] = { { sb1ceb9g, .982 }, { s85cf82, .179 }, { safcf80, .179 }, H };
N l19n113[] = { { s84ceb5, .283 }, H };
N l19n114[] = { { sbcce, 1.071 }, H };
N l19n116[] = { { scebbcebf, .476 }, H };
N l19n118[] = { { scf80cf, .759 }, { sceafcf, .558 }, { sbfcf82, .164 }, H };
N l19n119[] = { { sbeceb5, .164 }, H };
N l19n120[] = { { scebdceb5, .536 }, { scf80ceaf, .446 }, H };
N l19n121[] = { { sceb7g, 1.373 }, { sb9ceac, .193 }, H };
N l19n122[] = { { sb4ce, .417 }, H };
N l19n123[] = { { scebfce, 1.361 }, H };
N l19n124[] = { { scf81ce, 2.053 }, H };
N l19n125[] = { { sb9cebace, .258 }, H };
N l19n126[] = { { scebdceb7, .357 }, H };
N l19n127[] = { { scebd, 3.556 }, { scf8e, .417 }, H };
N l19n128[] = { { sceae, .610 }, { sceadcebd, .774 }, H };
N l19n130[] = { { sacce, .605 }, H };
N l19n131[] = { { sbccf, .258 }, H };
N l19n133[] = { { scebccebf, .595 }, H };
N l19n134[] = { { scebfcf, 3.169 }, { s85cf84, .193 }, H };
N l19n135[] = { { sb9g, 1.250 }, { s84ceb7, .640 }, { scf81cf, .737 }, { sceb7cf83, .446 }, H };
N l19n136[] = { { sbbcebf, .238 }, H };
N l19n137[] = { { sgcf80ce, .913 }, { sb7cf83, .223 }, { scebeceb5, .327 }, H };
N l19n138[] = { { scf80ceb5, .714 }, { scf89g, .636 }, H };
N l19n139[] = { { s83ce, .744 }, { sb5ceafcf, .298 }, { s80ceb9ce, .278 }, { sb4cf, .139 }, H };
N l19n140[] = { { sgceba, 1.175 }, { sb5ceb9, .521 }, { sbdceb1g, .833 }, { sgcf80cf, .218 }, H };
N l19n141[] = { { sceb1ce, 2.991 }, H };
N l19n142[] = { { sgce, 5.436 }, H };
N l19n143[] = { { sb1g, 1.652 }, { scf81ceb1, .655 }, H };
N l19n144[] = { { scebe, .327 }, { sb1cebbce, .317 }, H };
N l19n145[] = { { scf80, 2.470 }, { sbdce, 1.121 }, { sceaf, 1.220 }, H };
N l19n146[] = { { s80ceac, .208 }, H };
N l19n147[] = { { saccf, .208 }, { sgceb1ce, .377 }, { sce91, .164 }, H };
N l19n150[] = { { sgceb1cf, .774 }, { scf80ceb9, .565 }, { sgce9ace, .317 }, { saccebc, .223 }, { scebdcebf, .417 }, H };
N l19n151[] = { { sbfcf85, 1.414 }, { sgcebb, .179 }, H };
N l19n152[] = { { sceb1cf, 2.455 }, { sbaceac, .298 }, H };
N l19n153[] = { { sb5ce, 1.022 }, { sbcceb5g, .476 }, H };
N l19n155[] = { { sceb9g, 2.812 }, H };
N l19n156[] = { { s83cf, .605 }, { sb1cebdg, .803 }, H };
N l19n157[] = { { s84ceb9, .461 }, H };
N l19n158[] = { { scf83ce, 1.674 }, { sceb2ce, .558 }, H };
N l19n159[] = { { sgcf, 2.758 }, { sb5cf81ce, .238 }, H };
N l19n161[] = { { scebf, 4.181 }, { sadce, .486 }, { saccebd, .193 }, H };
N l19n162[] = { { scf81, 1.905 }, { sgcebc, .803 }, { sbdcf, .347 }, { s8cce, .268 }, { sceafcebd, .565 }, H };
N l19n163[] = { { s80cf8cg, .417 }, { s9ccf, .119 }, H };
N l19n165[] = { { s84ceb1g, .446 }, H };
N l19n166[] = { { sb1cebdce, .278 }, { scebfceb9, .327 }, H };
N l19n167[] = { { sbccebf, .298 }, { scf81ceb9, .446 }, { sadcf81ce, .218 }, H };
N l19n168[] = { { scf80cebf, 1.071 }, H };
N l19n169[] = { { scf83cf, 1.361 }, { sgceb3ce, .258 }, H };
N l19n170[] = { { s84ce, 2.361 }, { sb5cf, .694 }, { sgcf83ce, .377 }, { sb9cebfg, .387 }, H };
N l19n171[] = { { sb4ceb5ce, .238 }, H };
N l19n173[] = { { sgcf83cf, .754 }, { sgcebd, .268 }, H };
N l19n174[] = { { sb1cf80, .402 }, H };
N l19n175[] = { { scf84ce, 5.312 }, { sceb3ce, .960 }, { s84ceb1ce, .317 }, { sgce9ccf, .238 }, H };
N l19n176[] = { { sb9ceb1, .327 }, { sbece, .208 }, H };
N l19n177[] = { { scf83ceb1, .446 }, H };
N l19n178[] = { { s83cf84ce, .694 }, { sadcf, .307 }, { scebfcebd, .714 }, { s83ceb5g, .446 }, H };
N l19n179[] = { { sceb1, 5.282 }, { scf82, 1.443 }, { s8ccf, .248 }, { scf84ceac, .506 }, { s80ceaf, .223 }, H };
N l19n180[] = { { sgceb4ce, .436 }, H };
N l19n181[] = { { sgcf84ce, 1.905 }, H };
N l19n183[] = { { s89g, .283 }, H };
N l19n184[] = { { sceb1ceb9, 1.042 }, { sb6ce, .179 }, { sgcf84cf, .317 }, { sb5cebd, .238 }, { sbdcf84ce, .218 }, H };
N l19n185[] = { { sb1cf81, .208 }, H };
N l19n186[] = { { scf84cf, 1.049 }, { sceb3cf, .290 }, H };
N l19n187[] = { { s84cf, .466 }, { sbdcf84cf, .218 }, H };
N l19n189[] = { { scf8cg, .803 }, { scf83ceb5, .655 }, H };
N l19n190[] = { { sceacg, 1.205 }, { sceb1cebb, .595 }, H };
N l19n191[] = { { sgceb5ce, .615 }, { s84cf8c, .164 }, H };
N l19n192[] = { { sceb4ce, .937 }, { scf85ce, .937 }, { sadcebd, .387 }, { saece, .139 }, H };
N l19n193[] = { { s8dce, .109 }, H };
N l19n194[] = { { scf84ceb1, 1.131 }, { sbfceb9, .164 }, H };
N l19n195[] = { { sgcebf, .342 }, H };
N l19n196[] = { { scf83, 2.024 }, { sceb1cebd, 1.369 }, { sceb2, .461 }, { sb1cf82, .312 }, H };
N l19n198[] = { { sbdcebf, .208 }, H };
N l19n201[] = { { s85ce, .417 }, H };
N l19n203[] = { { scf85cf, .937 }, { sceb4cf, .312 }, H };
N l19n206[] = { { scf84ceb5, .565 }, H };
N l19n207[] = { { sbfce, .605 }, { sbaceb1, .744 }, { sb1cf83, .164 }, H };
N l19n208[] = { { s80cebfcf, .536 }, { s85cf82g, .357 }, H };
N l19n209[] = { { sceb5ce, 2.299 }, { scf86ce, .424 }, H };
N l19n210[] = { { s8dcf, .188 }, H };
N l19n211[] = { { scebccf80, .625 }, H };
N l19n212[] = { { scf84ceb7, 1.280 }, H };
N l19n213[] = { { scf84, 4.285 }, { sceb3, .833 }, H };
N l19n214[] = { { sbfcf82g, .327 }, H };
N l19n215[] = { { sb7ce, .347 }, { sceadcf81, .357 }, H };
N l19n218[] = { { s85cf, .417 }, { scf84ceb9, .922 }, { sb1cf84, .238 }, { safcf80ce, .238 }, H };
N l19n220[] = { { sceb5cf, 1.562 }, { scf86cf, .290 }, H };
N l19n222[] = { { s82g, 1.443 }, { sceb5ceaf, .863 }, H };
N l19n223[] = { { scebdg, 3.013 }, { s84cebf, 1.101 }, { safce, .436 }, { sceb4ceb5, .417 }, H };
N l19n224[] = { { sbfcf, 1.409 }, { sceaeg, .536 }, H };
N l19n225[] = { { sbccead, .223 }, H };
N l19n226[] = { { scf87ce, .603 }, { sceb6ce, .402 }, H };
N l19n229[] = { { sb1cf85, .179 }, H };
N l19n230[] = { { scf85, 2.336 }, { sceb4, .833 }, H };
N l19n232[] = { { sb7cf, .327 }, { s81ceb1, .327 }, { s86ce, .188 }, { s85cebd, .179 }, H };
N l19n236[] = { { scf84cebf, 2.202 }, { sb5ceb9g, .506 }, H };
N l19n238[] = { { sbfcebd, .357 }, { sbbceb1, .193 }, H };
N l19n239[] = { { sbfcf8d, .223 }, H };
N l19n240[] = { { safcf, .248 }, { scebdcf84, .655 }, H };
N l19n241[] = { { s84ceb7ce, .397 }, { s8ecf, .129 }, { sceafg, .435 }, H };
N l19n243[] = { { sceb7ce, .781 }, { sb7cf83ce, .278 }, H };
N l19n244[] = { { sacg, .536 }, { s84ceb7cf, .258 }, H };
N l19n245[] = { { s80ceb5, .357 }, H };
N l19n246[] = { { sgcebace, 1.349 }, { sb7cebd, .357 }, { sb8ce, .218 }, { sceafcf80, .357 }, { sb5ceb9ce, .238 }, H };
N l19n247[] = { { sceb5, 3.705 }, { sbfcf85g, 1.756 }, { scf86, .476 }, { scf85cebd, .357 }, H };
N l19n249[] = { { s86cf, .139 }, H };
N l19n252[] = { { sceb5ceb9, 1.042 }, H };
N l19n253[] = { { sgcead, .506 }, H };
N l19n254[] = { { sceb7cf, .737 }, { safcebd, .283 }, H };

D l19_d = {
	"greek",
	"utf8",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.001, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    0.066, 0.051, 0.038, 0.054, 0.114, 0.062, 0.013, 0.015, 0.004, 0.020, 0.001, 0.000, 0.030, 0.015, 0.011, Y,
	    Y, 0.004, Y, 0.001, 0.002, 0.004, 0.000, 0.004, 0.001, 0.002, 0.007, 0.002, 0.008, 0.002, 0.000, 0.004,
	    0.002, 0.002, Y, 0.002, 0.004, Y, 0.001, 0.000, Y, 0.001, Y, Y, 0.047, 0.036, 0.016, 0.033,
	    Y, 0.141, 0.012, 0.022, 0.022, 0.099, 0.009, 0.043, 0.012, 0.092, 0.057, 0.044, 0.053, 0.095, 0.009, 0.111,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, 1.511, 0.737,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ X, l19n1, X, l19n3, l19n4, X, l19n6, l19n7, l19n8, X, X, l19n11, l19n12, l19n13, l19n14, l19n15,
	    l19n16, X, X, l19n19, l19n20, l19n21, X, l19n23, l19n24, l19n25, l19n26, l19n27, X, l19n29, l19n30, l19n31,
	    l19n32, l19n33, X, l19n35, l19n36, X, l19n38, l19n39, l19n40, l19n41, l19n42, l19n43, l19n44, l19n45, l19n46, X,
	    X, l19n49, l19n50, l19n51, l19n52, l19n53, X, l19n55, l19n56, l19n57, X, l19n59, l19n60, l19n61, X, l19n63,
	    l19n64, l19n65, l19n66, l19n67, l19n68, l19n69, l19n70, X, l19n72, l19n73, l19n74, l19n75, l19n76, l19n77, l19n78, l19n79,
	    X, l19n81, l19n82, l19n83, l19n84, l19n85, l19n86, l19n87, l19n88, l19n89, l19n90, l19n91, X, l19n93, l19n94, l19n95,
	    X, X, l19n98, l19n99, l19n100, l19n101, X, l19n103, l19n104, l19n105, l19n106, l19n107, l19n108, l19n109, l19n110, l19n111,
	    l19n112, l19n113, l19n114, X, l19n116, X, l19n118, l19n119, l19n120, l19n121, l19n122, l19n123, l19n124, l19n125, l19n126, l19n127,
	    l19n128, X, l19n130, l19n131, X, l19n133, l19n134, l19n135, l19n136, l19n137, l19n138, l19n139, l19n140, l19n141, l19n142, l19n143,
	    l19n144, l19n145, l19n146, l19n147, X, X, l19n150, l19n151, l19n152, l19n153, X, l19n155, l19n156, l19n157, l19n158, l19n159,
	    X, l19n161, l19n162, l19n163, X, l19n165, l19n166, l19n167, l19n168, l19n169, l19n170, l19n171, X, l19n173, l19n174, l19n175,
	    l19n176, l19n177, l19n178, l19n179, l19n180, l19n181, X, l19n183, l19n184, l19n185, l19n186, l19n187, X, l19n189, l19n190, l19n191,
	    l19n192, l19n193, l19n194, l19n195, l19n196, X, l19n198, X, X, l19n201, X, l19n203, X, X, l19n206, l19n207,
	    l19n208, l19n209, l19n210, l19n211, l19n212, l19n213, l19n214, l19n215, X, X, l19n218, X, l19n220, X, l19n222, l19n223,
	    l19n224, l19n225, l19n226, X, X, l19n229, l19n230, X, l19n232, X, X, X, l19n236, X, l19n238, l19n239,
	    l19n240, l19n241, X, l19n243, l19n244, l19n245, l19n246, l19n247, X, l19n249, X, X, l19n252, l19n253, l19n254, X }
};

//
// Lng: hebrew
// Enc: iso-8859-8
//

S sgfa[] = { 32, 250, 0 };
S sfaV[] = { 250, 229, 0 };
S sede9[] = { 237, 233, 0 };
S sgede9[] = { 32, 237, 233, 0 };
S sgfaV[] = { 32, 250, 229, 0 };
S sge9[] = { 32, 233, 0 };
S se9f0[] = { 233, 240, 0 };
S secf9[] = { 236, 249, 0 };
S sVf8[] = { 229, 248, 0 };
S se9T[] = { 233, 227, 0 };
S sf8V[] = { 248, 229, 0 };
S sUec[] = { 228, 236, 0 };
S sVf9[] = { 229, 249, 0 };
S se9f8[] = { 233, 248, 0 };
S sQf8[] = { 224, 248, 0 };
S sVR[] = { 229, 225, 0 };
S sf8f9[] = { 248, 249, 0 };
S sf9e9[] = { 249, 233, 0 };
S sfae9[] = { 250, 233, 0 };
S sfaQ[] = { 250, 224, 0 };
S seeUg[] = { 238, 228, a };
S seeU[] = { 238, 228, 0 };
S secf9g[] = { 236, 249, a };
S se9e9[] = { 233, 233, 0 };
S se9U[] = { 233, 228, 0 };
S sf8U[] = { 248, 228, 0 };
S sgfae9[] = { 32, 250, 233, 0 };
S se9ee[] = { 233, 238, 0 };
S sgecf9[] = { 32, 236, 249, 0 };
S sgfaQ[] = { 32, 250, 224, 0 };
S sVee[] = { 229, 238, 0 };
S sgecf9g[] = { 32, 236, 249, a };
S sUf0[] = { 228, 240, 0 };
S sgefe9[] = { 32, 239, 233, 0 };
S secf2[] = { 236, 242, 0 };
S sf8e9[] = { 248, 233, 0 };
S se9f9[] = { 233, 249, 0 };
S sVU[] = { 229, 228, 0 };
S sVe7[] = { 229, 231, 0 };
S sge9f0[] = { 32, 233, 240, 0 };
S sfae9f0[] = { 250, 233, 240, 0 };
S se9e8[] = { 233, 232, 0 };
S sfaQg[] = { 250, 224, a };
S sf8Q[] = { 248, 224, 0 };
S sgfae9f0[] = { 32, 250, 233, 240, 0 };
S sf4U[] = { 244, 228, 0 };
S sgUf0[] = { 32, 228, 240, 0 };
S sgecf2[] = { 32, 236, 242, 0 };
S sf8e7[] = { 248, 231, 0 };
S se9f4[] = { 233, 244, 0 };
S sfaVf0[] = { 250, 229, 240, 0 };
S sgecf2g[] = { 32, 236, 242, a };
S sQU[] = { 224, 228, 0 };
S secf2g[] = { 236, 242, a };
S sQUg[] = { 224, 228, a };
S sf8fa[] = { 248, 250, 0 };
S secQ[] = { 236, 224, 0 };
S sf8Ug[] = { 248, 228, a };
S sVfa[] = { 229, 250, 0 };
S sgf9[] = { 32, 249, 0 };
S sf9Q[] = { 249, 224, 0 };
S sgf8V[] = { 32, 248, 229, 0 };
S se9f1[] = { 233, 241, 0 };
S sgUf8[] = { 32, 228, 248, 0 };
S sf4Ug[] = { 244, 228, a };
S sf2U[] = { 242, 228, 0 };
S sgVf0[] = { 32, 229, 240, 0 };
S sUecg[] = { 228, 236, a };
S sgedf2[] = { 32, 237, 242, 0 };
S sTee[] = { 227, 238, 0 };
S sgUe9[] = { 32, 228, 233, 0 };
S se9f0V[] = { 233, 240, 229, 0 };
S sVf7[] = { 229, 247, 0 };
S sf9f8[] = { 249, 248, 0 };
S sedf2[] = { 237, 242, 0 };
S se9f6[] = { 233, 246, 0 };
S sf9V[] = { 249, 229, 0 };
S sf9ee[] = { 249, 238, 0 };
S sUf8[] = { 228, 248, 0 };
S sgUec[] = { 32, 228, 236, 0 };
S sfaVf8[] = { 250, 229, 248, 0 };
S seceb[] = { 236, 235, 0 };
S sgefV[] = { 32, 239, 229, 0 };
S sgfaVf0[] = { 32, 250, 229, 240, 0 };
S sfaU[] = { 250, 228, 0 };
S se9S[] = { 233, 226, 0 };
S sRV[] = { 225, 229, 0 };
S sVQ[] = { 229, 224, 0 };
S sgedf2g[] = { 32, 237, 242, a };
S sQR[] = { 224, 225, 0 };
S sefV[] = { 239, 229, 0 };
S se7Q[] = { 231, 224, 0 };
S se9Q[] = { 233, 224, 0 };
S sf9e9g[] = { 249, 233, a };
S sgfaQg[] = { 32, 250, 224, a };
S sQV[] = { 224, 229, 0 };
S sfaee[] = { 250, 238, 0 };
S sgfaVf8[] = { 32, 250, 229, 248, 0 };
S sedf2g[] = { 237, 242, a };
S sVV[] = { 229, 229, 0 };
S sf2R[] = { 242, 225, 0 };
S sgf2[] = { 32, 242, 0 };
S sTf2[] = { 227, 242, 0 };
S sf9Qf8[] = { 249, 224, 248, 0 };
S se9ebg[] = { 233, 235, a };
S sede9f8[] = { 237, 233, 248, 0 };
S secQf8[] = { 236, 224, 248, 0 };
S sgede9T[] = { 32, 237, 233, 227, 0 };
S se8f1[] = { 232, 241, 0 };
S sfaVf9[] = { 250, 229, 249, 0 };
S sVS[] = { 229, 226, 0 };
S sf2Ug[] = { 242, 228, a };
S sgede9f8[] = { 32, 237, 233, 248, 0 };
S sf1ec[] = { 241, 236, 0 };
S sRf8[] = { 225, 248, 0 };
S sfaVe9[] = { 250, 229, 233, 0 };
S sUR[] = { 228, 225, 0 };
S sf2V[] = { 242, 229, 0 };
S sf0R[] = { 240, 225, 0 };
S sf2f4[] = { 242, 244, 0 };
S sf8f7[] = { 248, 247, 0 };
S secf4[] = { 236, 244, 0 };
S sUf9[] = { 228, 249, 0 };
S sf7U[] = { 247, 228, 0 };
S sgfaVf9[] = { 32, 250, 229, 249, 0 };
S se9f0e9[] = { 233, 240, 233, 0 };
S sf8e7Q[] = { 248, 231, 224, 0 };
S sede9T[] = { 237, 233, 227, 0 };
S se9e8f1[] = { 233, 232, 241, 0 };
S sge9eb[] = { 32, 233, 235, 0 };
S sUee[] = { 228, 238, 0 };
S sQf8f9e9[] = { 224, 248, 249, 233, 0 };
S sfaf9[] = { 250, 249, 0 };
S sge9ebg[] = { 32, 233, 235, a };
S sgede9ec[] = { 32, 237, 233, 236, 0 };
S se9e8f1ec[] = { 233, 232, 241, 236, 0 };
S seeec[] = { 238, 236, 0 };
S sgefe9e9[] = { 32, 239, 233, 233, 0 };
S sQec[] = { 224, 236, 0 };
S se8f1ec[] = { 232, 241, 236, 0 };
S sf8f9e9[] = { 248, 249, 233, 0 };
S sede9ec[] = { 237, 233, 236, 0 };
S sf8e8[] = { 248, 232, 0 };
S sfaf8[] = { 250, 248, 0 };
S sefe9e9[] = { 239, 233, 233, 0 };
S sf1U[] = { 241, 228, 0 };
S secQf8f9[] = { 236, 224, 248, 249, 0 };
S sf8T[] = { 248, 227, 0 };
S sf8ec[] = { 248, 236, 0 };
S sQf8f9[] = { 224, 248, 249, 0 };
S sQecg[] = { 224, 236, a };
S sf6Ug[] = { 246, 228, a };
S se9e7[] = { 233, 231, 0 };
S se7ee[] = { 231, 238, 0 };
S sgecQ[] = { 32, 236, 224, 0 };
S sQRg[] = { 224, 225, a };
S sgfaf8[] = { 32, 250, 248, 0 };
S se9f7[] = { 233, 247, 0 };
S sfaUg[] = { 250, 228, a };
S se9V[] = { 233, 229, 0 };
S se9Te9[] = { 233, 227, 233, 0 };
S sf6U[] = { 246, 228, 0 };
S sQf9[] = { 224, 249, 0 };
S sf0f9[] = { 240, 249, 0 };
S sede9f0[] = { 237, 233, 240, 0 };
S sRU[] = { 225, 228, 0 };
S sf7Ug[] = { 247, 228, a };
S sf2ee[] = { 242, 238, 0 };
S se9f1V[] = { 233, 241, 229, 0 };
S sf0e9Tee[] = { 240, 233, 227, 238, 0 };
S sVf0e9[] = { 229, 240, 233, 0 };
S sSe9[] = { 226, 233, 0 };
S sf1ecf4[] = { 241, 236, 244, 0 };
S sf2e9[] = { 242, 233, 0 };
S sf8f9g[] = { 248, 249, a };
S sedSg[] = { 237, 226, a };
S sgRe9[] = { 32, 225, 233, 0 };
S sf1Q[] = { 241, 224, 0 };
S sVf0g[] = { 229, 240, a };
S sgedSg[] = { 32, 237, 226, a };
S sf1Ug[] = { 241, 228, a };
S se9Tee[] = { 233, 227, 238, 0 };
S se9Ug[] = { 233, 228, a };
S sf8Qg[] = { 248, 224, a };
S sgecQf8[] = { 32, 236, 224, 248, 0 };
S se9fa[] = { 233, 250, 0 };
S sf8faV[] = { 248, 250, 229, 0 };
S sSU[] = { 226, 228, 0 };
S se7eeg[] = { 231, 238, a };
S sfaVf9f8[] = { 250, 229, 249, 248, 0 };
S se7V[] = { 231, 229, 0 };
S sfaf0[] = { 250, 240, 0 };
S sf9ecg[] = { 249, 236, a };
S sQe9[] = { 224, 233, 0 };
S sgf9Q[] = { 32, 249, 224, 0 };
S sgede9f0[] = { 32, 237, 233, 240, 0 };
S seee9[] = { 238, 233, 0 };
S sgedS[] = { 32, 237, 226, 0 };
S sQee[] = { 224, 238, 0 };
S sgTV[] = { 32, 227, 229, 0 };
S sSf4[] = { 226, 244, 0 };
S sf0e9T[] = { 240, 233, 227, 0 };
S sgUR[] = { 32, 228, 225, 0 };
S sVf9f8[] = { 229, 249, 248, 0 };
S se7e9[] = { 231, 233, 0 };
S sgfaVe9[] = { 32, 250, 229, 233, 0 };
S sRUg[] = { 225, 228, a };
S sgVfa[] = { 32, 229, 250, 0 };
S se8f1ecf4[] = { 232, 241, 236, 244, 0 };
S sebU[] = { 235, 228, 0 };
S sebUg[] = { 235, 228, a };
S sTf2g[] = { 227, 242, a };
S seeee[] = { 238, 238, 0 };
S sf6f2[] = { 246, 242, 0 };
S sf0ee[] = { 240, 238, 0 };
S seeRg[] = { 238, 225, a };
S sedS[] = { 237, 226, 0 };
S sVRg[] = { 229, 225, a };
S se9e9f6[] = { 233, 233, 246, 0 };
S seaeb[] = { 234, 235, 0 };
S sfaec[] = { 250, 236, 0 };
S sQf8g[] = { 224, 248, a };
S sTg[] = { 227, a };
S sVUg[] = { 229, 228, a };
S se8f9[] = { 232, 249, 0 };
S seee7[] = { 238, 231, 0 };
S sge9f0V[] = { 32, 233, 240, 229, 0 };
S sefe9R[] = { 239, 233, 225, 0 };
S sede9ee[] = { 237, 233, 238, 0 };
S sTf8[] = { 227, 248, 0 };
S sfaVR[] = { 250, 229, 225, 0 };
S se7fa[] = { 231, 250, 0 };
S sf9f8Ug[] = { 249, 248, 228, a };
S se9f9g[] = { 233, 249, a };
S sVeeg[] = { 229, 238, a };
S sWeeg[] = { 230, 238, a };
S sVf9f8U[] = { 229, 249, 248, 228, 0 };
S secf4Ug[] = { 236, 244, 228, a };
S sf7ec[] = { 247, 236, 0 };
S se9f0e9e8[] = { 233, 240, 233, 232, 0 };
S sgeceb[] = { 32, 236, 235, 0 };
S sf4Q[] = { 244, 224, 0 };
S se8f7[] = { 232, 247, 0 };
S sUUg[] = { 228, 228, a };
S sVfag[] = { 229, 250, a };
S sf8ee[] = { 248, 238, 0 };
S sTeeU[] = { 227, 238, 228, 0 };
S sf9f4Q[] = { 249, 244, 224, 0 };
S sf2Rg[] = { 242, 225, a };
S secec[] = { 236, 236, 0 };
S sf9fa[] = { 249, 250, 0 };
S sRVf9[] = { 225, 229, 249, 0 };
S secf9ee[] = { 236, 249, 238, 0 };
S sUf0e9[] = { 228, 240, 233, 0 };
S se9f0Ve9[] = { 233, 240, 229, 233, 0 };
S sVf7e9[] = { 229, 247, 233, 0 };
S se9f0f9[] = { 233, 240, 249, 0 };
S sf0e9e8f1[] = { 240, 233, 232, 241, 0 };
S seef2[] = { 238, 242, 0 };
S sf8f6[] = { 248, 246, 0 };
S sgede9e9[] = { 32, 237, 233, 233, 0 };
S sgede9ee[] = { 32, 237, 233, 238, 0 };
S se9f0R[] = { 233, 240, 225, 0 };
S sVe8[] = { 229, 232, 0 };
S sgUf0e9[] = { 32, 228, 240, 233, 0 };
S sgfaVR[] = { 32, 250, 229, 225, 0 };
S sgefe9R[] = { 32, 239, 233, 225, 0 };
S sf0e7[] = { 240, 231, 0 };
S sf8f9f4Q[] = { 248, 249, 244, 224, 0 };
S sVf8e9[] = { 229, 248, 233, 0 };
S seefa[] = { 238, 250, 0 };
S sTeeUg[] = { 227, 238, 228, a };
S sgf8e7[] = { 32, 248, 231, 0 };
S sf0e9e8[] = { 240, 233, 232, 0 };
S se9f4g[] = { 233, 244, a };
S sgeaeb[] = { 32, 234, 235, 0 };
S se9TeeU[] = { 233, 227, 238, 228, 0 };
S sf4ec[] = { 244, 236, 0 };
S sgTf2[] = { 32, 227, 242, 0 };
S sf4f8[] = { 244, 248, 0 };
S sf9eeee[] = { 249, 238, 238, 0 };
S se7Ug[] = { 231, 228, a };
S sgf8fa[] = { 32, 248, 250, 0 };
S sgf9Qf8[] = { 32, 249, 224, 248, 0 };
S sf8f9e9g[] = { 248, 249, 233, a };
S sece8[] = { 236, 232, 0 };
S sQVg[] = { 224, 229, a };
S sf4ee[] = { 244, 238, 0 };
S sf1ecf4U[] = { 241, 236, 244, 228, 0 };
S sVf9e9[] = { 229, 249, 233, 0 };
S sf9e9S[] = { 249, 233, 226, 0 };
S sf0Rg[] = { 240, 225, a };
S se7U[] = { 231, 228, 0 };
S sede9f2[] = { 237, 233, 242, 0 };
S secf9eeee[] = { 236, 249, 238, 238, 0 };
S sf1ee[] = { 241, 238, 0 };
S sf9Qf8g[] = { 249, 224, 248, a };
S sWee[] = { 230, 238, 0 };
S sede9e9[] = { 237, 233, 233, 0 };
S sf0fa[] = { 240, 250, 0 };
S sgedV[] = { 32, 237, 229, 0 };
S sUQ[] = { 228, 224, 0 };
S sgf8faV[] = { 32, 248, 250, 229, 0 };
S sge9T[] = { 32, 233, 227, 0 };
S secf4U[] = { 236, 244, 228, 0 };
S sfae9f0e9[] = { 250, 233, 240, 233, 0 };
S sVf8g[] = { 229, 248, a };
S sf0Ve9[] = { 240, 229, 233, 0 };
S sRecg[] = { 225, 236, a };
S sf9f4[] = { 249, 244, 0 };
S sf8f9f4[] = { 248, 249, 244, 0 };
S sgede9f2[] = { 32, 237, 233, 242, 0 };
S sgfaf9[] = { 32, 250, 249, 0 };
S sf8ecg[] = { 248, 236, a };
S sf9f8U[] = { 249, 248, 228, 0 };
S sf0faf0g[] = { 240, 250, 240, a };
S sf0faf0[] = { 240, 250, 240, 0 };
S sRf8g[] = { 225, 248, a };
S sfaf0g[] = { 250, 240, a };
S sf0Vf8[] = { 240, 229, 248, 0 };
S sVf9Qf8[] = { 229, 249, 224, 248, 0 };
S sUe9U[] = { 228, 233, 228, 0 };
S sVe7U[] = { 229, 231, 228, 0 };

N l20n0[] = { { sf9e9g, .809 }, H };
N l20n1[] = { { sf0R, .315 }, { sVW, .270 }, H };
N l20n3[] = { { sgedf2, .404 }, { sgf3, .210 }, { sf1ecf4U, .360 }, H };
N l20n4[] = { { sgU, 2.037 }, { sf4f8, .180 }, H };
N l20n5[] = { { se9ee, .674 }, H };
N l20n6[] = { { secf2g, 1.011 }, { sQf8f9e9, .539 }, H };
N l20n7[] = { { sf9Q, .449 }, { sgUe9, .404 }, { seeV, .360 }, { secQf8f9, .539 }, H };
N l20n8[] = { { sWeeg, .404 }, H };
N l20n9[] = { { se8R, .225 }, { sgf9Q, .225 }, { sf7g, .270 }, H };
N l20n11[] = { { sVf0g, .506 }, H };
N l20n12[] = { { sgfaVe9, .300 }, { sVRg, .404 }, H };
N l20n13[] = { { sece9, .315 }, { sf7U, .315 }, { sf8f9f4, .270 }, H };
N l20n15[] = { { sfae9f0, .742 }, { se9f1V, .337 }, { sf1Q, .225 }, { sgUf0e9, .240 }, { sf9Qf8g, .539 }, H };
N l20n16[] = { { sf4Ug, .910 }, H };
N l20n17[] = { { sQR, .360 }, { sVf6, .225 }, H };
N l20n18[] = { { sVe7, .539 }, H };
N l20n20[] = { { sUf8, .404 }, { sfaee, .360 }, { sf0e9Tee, .449 }, { sgecQf8, .300 }, { sf8ecg, .404 }, H };
N l20n21[] = { { sgV, 1.019 }, { sUe9, .629 }, { sedSg, .506 }, { sefe9R, .270 }, H };
N l20n22[] = { { sfaVf9f8, .449 }, { sgf8fa, .180 }, H };
N l20n23[] = { { se9Q, .360 }, { sTeeU, .270 }, { sRf8g, .303 }, H };
N l20n25[] = { { se7g, .607 }, { se8f1, .315 }, { se8f1ecf4, .449 }, H };
N l20n26[] = { { sgfaQ, .629 }, { sge9T, .180 }, H };
N l20n27[] = { { sf8T, .270 }, H };
N l20n28[] = { { secQf8, .472 }, { sf2ee, .225 }, H };
N l20n29[] = { { secf9, 1.079 }, { se7U, .180 }, H };
N l20n30[] = { { sf7V, .270 }, H };
N l20n32[] = { { se9f9g, .404 }, { sUUg, .404 }, H };
N l20n33[] = { { sgfaVf0, .479 }, { secf9eeee, .360 }, H };
N l20n34[] = { { sVf7, .404 }, { sgfaf8, .270 }, H };
N l20n35[] = { { sfaVf8, .607 }, { seeRg, .506 }, { sVe8, .180 }, H };
N l20n37[] = { { sedf2g, .809 }, { sUf9, .315 }, { sgf5, .120 }, { sVf7e9, .270 }, H };
N l20n38[] = { { sfaQ, .764 }, { sefV, .360 }, { sfaVR, .270 }, H };
N l20n39[] = { { se9f0, 1.528 }, { se7eeg, .506 }, { sRVf9, .270 }, H };
N l20n40[] = { { sf8g, 1.416 }, { se9R, .854 }, { sgUec, .404 }, H };
N l20n41[] = { { seee7, .180 }, H };
N l20n42[] = { { se9f0e9, .472 }, H };
N l20n44[] = { { sede9, 2.292 }, { sf8U, .674 }, { sQecg, .607 }, { sgecQ, .270 }, H };
N l20n45[] = { { sVf2g, .607 }, { sgfaf9, .180 }, H };
N l20n46[] = { { sfaVf9, .472 }, { se7V, .225 }, H };
N l20n47[] = { { sgf8V, .449 }, { seceb, .360 }, { sf9eeee, .270 }, { sede9e9, .270 }, H };
N l20n48[] = { { sf0g, 1.146 }, { se9TeeU, .360 }, H };
N l20n50[] = { { se9ebg, .708 }, H };
N l20n51[] = { { sVf8, 1.034 }, { sf9ecg, .506 }, H };
N l20n52[] = { { sVe9, 1.034 }, H };
N l20n54[] = { { sfaf0, .225 }, { sVf8e9, .270 }, H };
N l20n55[] = { { sge7, .210 }, H };
N l20n56[] = { { se9f1, .449 }, { sf4ec, .180 }, H };
N l20n57[] = { { se9S, .360 }, { sgfaVf8, .479 }, H };
N l20n60[] = { { sgfaVf9, .419 }, H };
N l20n61[] = { { sf8V, .854 }, { se8f1ec, .404 }, H };
N l20n63[] = { { sgecf9, .674 }, { sf2R, .360 }, { sVUg, .404 }, H };
N l20n64[] = { { sQg, 2.427 }, { secec, .180 }, H };
N l20n65[] = { { sRS, .180 }, H };
N l20n66[] = { { se9e9f6, .270 }, H };
N l20n68[] = { { sVf9, .809 }, { sQU, .449 }, H };
N l20n69[] = { { sf0V, .764 }, { sgf8e7, .180 }, H };
N l20n71[] = { { sf9g, 2.359 }, { sgf7, .210 }, { sVf9e9, .270 }, H };
N l20n72[] = { { sUec, .854 }, { sf8Qg, .506 }, { sf0Ve9, .270 }, H };
N l20n73[] = { { se9f2, .629 }, { sgede9T, .419 }, H };
N l20n74[] = { { se9T, .989 }, { sf0e9T, .337 }, H };
N l20n75[] = { { sTee, .404 }, { sQf8f9, .404 }, { seee9, .225 }, { sRecg, .404 }, H };
N l20n77[] = { { sgfae9f0, .659 }, { se9Te9, .404 }, H };
N l20n78[] = { { sf6Ug, .607 }, H };
N l20n79[] = { { sf1g, .270 }, H };
N l20n80[] = { { sede9ec, .404 }, H };
N l20n81[] = { { sgfaV, 2.022 }, H };
N l20n82[] = { { sgecf2g, .599 }, H };
N l20n83[] = { { sf1U, .270 }, { sgedS, .225 }, H };
N l20n84[] = { { sgUf0, .494 }, { sf0e9e8f1, .360 }, H };
N l20n85[] = { { sVfa, .449 }, { sQV, .360 }, H };
N l20n86[] = { { seeUg, 1.719 }, { sVeb, .404 }, { sf9e9S, .270 }, H };
N l20n87[] = { { se9g, 1.483 }, { sf1ecf4, .337 }, { secf9ee, .270 }, H };
N l20n88[] = { { sgf8, 1.348 }, { sge9f0V, .240 }, H };
N l20n89[] = { { sge9, 1.109 }, { sgTf2, .180 }, H };
N l20n90[] = { { sf4ee, .180 }, { sf0faf0g, .404 }, H };
N l20n91[] = { { se9U, .719 }, { sgede9e9, .240 }, { sf9f4, .180 }, H };
N l20n92[] = { { sf9V, .404 }, H };
N l20n94[] = { { sf8f6, .180 }, H };
N l20n95[] = { { sRg, 4.112 }, { sf8e7, .449 }, H };
N l20n97[] = { { sf0Rg, .404 }, H };
N l20n98[] = { { sf7e9, .404 }, H };
N l20n99[] = { { sgedf2g, .479 }, { sRU, .225 }, { sgecV, .225 }, H };
N l20n100[] = { { sf1V, .360 }, { sgede9ec, .360 }, H };
N l20n101[] = { { sgVf0, .404 }, { sgefe9R, .240 }, H };
N l20n102[] = { { sfag, 1.011 }, { sede9ee, .270 }, H };
N l20n103[] = { { sf0e7, .180 }, H };
N l20n105[] = { { sgf9, .300 }, H };
N l20n106[] = { { sefe9, .629 }, { sgea, .270 }, { sfaU, .360 }, { sUee, .270 }, { sgede9ee, .240 }, H };
N l20n107[] = { { se9f4, .449 }, { sf9f8U, .270 }, H };
N l20n108[] = { { se9V, .270 }, { sf4Q, .180 }, { seefa, .180 }, H };
N l20n109[] = { { sefe9e9, .404 }, { sf7Ug, .506 }, H };
N l20n110[] = { { sf2g, 2.427 }, { sTR, .404 }, H };
N l20n111[] = { { sf8f7, .315 }, H };
N l20n112[] = { { sf8e8, .270 }, { sgede9f0, .300 }, H };
N l20n113[] = { { sQRg, .607 }, H };
N l20n114[] = { { sf2U, .404 }, { sge9eb, .270 }, { se7e9, .225 }, H };
N l20n116[] = { { secQ, .449 }, { sRV, .360 }, { sgedV, .180 }, H };
N l20n118[] = { { sgede9f2, .240 }, H };
N l20n119[] = { { sTeeUg, .539 }, H };
N l20n121[] = { { sf8faV, .337 }, H };
N l20n122[] = { { sgfa, 2.846 }, { sgfaQg, .479 }, H };
N l20n123[] = { { sfaV, 2.472 }, H };
N l20n124[] = { { sede9f0, .337 }, { sUQ, .180 }, H };
N l20n125[] = { { secf9g, 1.618 }, { sgfae9, .674 }, { sgefe9e9, .360 }, { se7Ug, .404 }, H };
N l20n126[] = { { sSg, .539 }, { sfaVe9, .472 }, { seeec, .270 }, H };
N l20n127[] = { { se8f7, .180 }, H };
N l20n129[] = { { sf8e9, .584 }, { sf0e9e8, .270 }, H };
N l20n130[] = { { sf2f4, .315 }, { sSU, .225 }, H };
N l20n131[] = { { sf2V, .315 }, { sgeaeb, .180 }, H };
N l20n132[] = { { se9Tee, .337 }, H };
N l20n134[] = { { sfaQg, 1.112 }, H };
N l20n136[] = { { se9Rg, 1.011 }, { sgede9f8, .419 }, H };
N l20n137[] = { { sf0e9, .809 }, { sVee, .629 }, H };
N l20n140[] = { { sgec, 1.558 }, { sUf0, .629 }, { sf8Ug, 1.011 }, H };
N l20n141[] = { { se9f6, .404 }, { sUR, .315 }, H };
N l20n142[] = { { se9e7, .270 }, H };
N l20n143[] = { { sTf2, .315 }, { sUf0e9, .270 }, H };
N l20n145[] = { { sf8f9, .764 }, H };
N l20n146[] = { { sSf4, .225 }, { sede9f2, .270 }, H };
N l20n147[] = { { se7fa, .180 }, { sVf8g, .404 }, H };
N l20n148[] = { { sVe9g, .809 }, { sf8f9e9, .404 }, { secf4U, .270 }, H };
N l20n149[] = { { sebg, 1.888 }, { sf7ec, .180 }, H };
N l20n150[] = { { sgefV, .360 }, { sfaf0g, .303 }, H };
N l20n152[] = { { sQf8, .809 }, { sVf9f8U, .360 }, H };
N l20n153[] = { { sf0f9, .270 }, { sQe9, .225 }, { sebU, .225 }, H };
N l20n155[] = { { sVQ, .360 }, H };
N l20n157[] = { { sged, 2.337 }, { sTg, .270 }, H };
N l20n158[] = { { se9f7, .270 }, H };
N l20n159[] = { { sgecf9g, .839 }, { se9e8, .494 }, { sf9f8, .404 }, { sf2Rg, .404 }, H };
N l20n160[] = { { sgede9, 2.292 }, { sf9e9, .764 }, { seeee, .225 }, H };
N l20n161[] = { { se8f9, .180 }, H };
N l20n162[] = { { sf8fa, .449 }, H };
N l20n164[] = { { sQUg, 1.011 }, H };
N l20n165[] = { { sgeceb, .180 }, H };
N l20n166[] = { { secf2, .584 }, H };
N l20n168[] = { { sUecg, .910 }, { sf1e9, .180 }, { sWee, .180 }, H };
N l20n169[] = { { sge9f0, .494 }, { sQf9, .270 }, H };
N l20n170[] = { { sebV, .270 }, { sf0fa, .180 }, H };
N l20n171[] = { { sVf0, 1.168 }, H };
N l20n172[] = { { sVR, .764 }, { sf4g, .809 }, { sgUf8, .404 }, H };
N l20n173[] = { { sf8f9f4Q, .360 }, H };
N l20n174[] = { { sVf0e9, .337 }, H };
N l20n175[] = { { se9f8, .809 }, { sf9Qf8, .472 }, { sgUR, .225 }, H };
N l20n176[] = { { se9e9, .719 }, { sf4U, .494 }, H };
N l20n178[] = { { sTV, .449 }, H };
N l20n179[] = { { sgedSg, .300 }, { sf1Ug, .506 }, H };
N l20n180[] = { { secg, 3.303 }, { sf8ec, .270 }, H };
N l20n181[] = { { sedS, .225 }, { sVfag, .404 }, { sQVg, .404 }, H };
N l20n183[] = { { sRf8, .315 }, H };
N l20n184[] = { { sRe9, .404 }, H };
N l20n185[] = { { se9f0Ve9, .360 }, H };
N l20n187[] = { { se9Ug, .506 }, H };
N l20n188[] = { { sUg, 7.955 }, { sVf1, .225 }, H };
N l20n189[] = { { sVS, .315 }, H };
N l20n190[] = { { se9e8f1ec, .539 }, { sfaf8, .270 }, H };
N l20n191[] = { { sgef, .869 }, { sfae9, .764 }, H };
N l20n192[] = { { se9f9, .584 }, { sgQ, .240 }, { sUU, .180 }, H };
N l20n193[] = { { sf9fa, .180 }, H };
N l20n194[] = { { sgefe9, .629 }, H };
N l20n195[] = { { seeR, .225 }, { sRUg, .506 }, H };
N l20n197[] = { { sedf2, .404 }, { sgf8faV, .240 }, H };
N l20n199[] = { { se7ee, .270 }, { sf2e9, .225 }, H };
N l20n200[] = { { secf4, .315 }, H };
N l20n201[] = { { secV, .629 }, H };
N l20n202[] = { { sfaUg, .607 }, { sgTV, .225 }, { sfae9f0e9, .360 }, H };
N l20n203[] = { { sfaVf0, .674 }, { sf9f8Ug, .539 }, { se9f4g, .404 }, H };
N l20n204[] = { { sQec, .270 }, { sVf9Qf8, .270 }, H };
N l20n205[] = { { sVf2, .584 }, H };
N l20n206[] = { { sVT, .315 }, H };
N l20n207[] = { { sfaf9, .270 }, H };
N l20n209[] = { { sgR, .389 }, { se9fa, .225 }, H };
N l20n210[] = { { se9eb, .539 }, { sf2Ug, .708 }, { sge9ebg, .360 }, { se9f0R, .270 }, H };
N l20n211[] = { { sf9ec, .225 }, { sgVfa, .225 }, H };
N l20n212[] = { { sede9f8, .472 }, { sgRe9, .225 }, H };
N l20n214[] = { { sf8ee, .180 }, H };
N l20n215[] = { { sSe9, .225 }, H };
N l20n217[] = { { se7Q, .360 }, H };
N l20n218[] = { { se9f0f9, .270 }, H };
N l20n219[] = { { sVg, .809 }, { sf1ec, .315 }, H };
N l20n220[] = { { sf6f2, .225 }, H };
N l20n222[] = { { sf0ee, .225 }, { sVe7U, .202 }, H };
N l20n223[] = { { sVU, .584 }, H };
N l20n225[] = { { sgf1, .120 }, { sUe9U, .202 }, H };
N l20n226[] = { { se9f0e9e8, .360 }, H };
N l20n227[] = { { se9ec, .629 }, H };
N l20n228[] = { { seef2, .180 }, H };
N l20n232[] = { { sf8Q, .494 }, { sedV, .180 }, H };
N l20n233[] = { { sVeeg, .404 }, H };
N l20n234[] = { { sf6g, .404 }, H };
N l20n235[] = { { sRec, .180 }, H };
N l20n236[] = { { sVf9f8, .337 }, H };
N l20n237[] = { { sede9T, .472 }, { sf0Vf8, .202 }, H };
N l20n238[] = { { sf6U, .270 }, { sQee, .225 }, H };
N l20n239[] = { { sVf4, .360 }, { sTf2g, .506 }, H };
N l20n240[] = { { sVV, .360 }, H };
N l20n241[] = { { sf8f9g, .506 }, { seaeb, .180 }, { sgf9Qf8, .240 }, H };
N l20n242[] = { { seeg, 3.034 }, { sgecf2, .494 }, { sgf2, .240 }, { sfaec, .180 }, H };
N l20n243[] = { { sgT, .809 }, H };
N l20n244[] = { { secf4Ug, .539 }, { sgfaVR, .240 }, { sf8f9e9g, .539 }, H };
N l20n245[] = { { sf9ee, .404 }, { sTf8, .180 }, H };
N l20n246[] = { { seeU, .764 }, { sTe9, .494 }, { sgTe9, .180 }, H };
N l20n248[] = { { sQf8g, .404 }, H };
N l20n249[] = { { sebUg, .506 }, H };
N l20n250[] = { { se9e8f1, .404 }, { sWg, .404 }, { sf0faf0, .202 }, H };
N l20n251[] = { { sf9f4Q, .270 }, H };
N l20n252[] = { { sece8, .180 }, H };
N l20n253[] = { { sf1ee, .180 }, H };
N l20n254[] = { { se9f0V, .607 }, H };
N l20n255[] = { { sf8e7Q, .472 }, { sf6V, .225 }, H };

D l20_d = {
	"hebrew",
	"iso-8859-8",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.002, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    0.201, 0.218, 0.070, 0.142, 0.406, 0.467, 0.034, 0.102, 0.063, 0.532, 0.016, 0.097, 0.279, 0.140, 0.212, 0.052,
	    0.174, 0.086, 0.160, 0.013, 0.092, 0.007, 0.054, 0.084, 0.300, 0.216, 0.275, V, V, V, V, V },
	{ l20n0, l20n1, X, l20n3, l20n4, l20n5, l20n6, l20n7, l20n8, l20n9, X, l20n11, l20n12, l20n13, X, l20n15,
	    l20n16, l20n17, l20n18, X, l20n20, l20n21, l20n22, l20n23, X, l20n25, l20n26, l20n27, l20n28, l20n29, l20n30, X,
	    l20n32, l20n33, l20n34, l20n35, X, l20n37, l20n38, l20n39, l20n40, l20n41, l20n42, X, l20n44, l20n45, l20n46, l20n47,
	    l20n48, X, l20n50, l20n51, l20n52, X, l20n54, l20n55, l20n56, l20n57, X, X, l20n60, l20n61, X, l20n63,
	    l20n64, l20n65, l20n66, X, l20n68, l20n69, X, l20n71, l20n72, l20n73, l20n74, l20n75, X, l20n77, l20n78, l20n79,
	    l20n80, l20n81, l20n82, l20n83, l20n84, l20n85, l20n86, l20n87, l20n88, l20n89, l20n90, l20n91, l20n92, X, l20n94, l20n95,
	    X, l20n97, l20n98, l20n99, l20n100, l20n101, l20n102, l20n103, X, l20n105, l20n106, l20n107, l20n108, l20n109, l20n110, l20n111,
	    l20n112, l20n113, l20n114, X, l20n116, X, l20n118, l20n119, X, l20n121, l20n122, l20n123, l20n124, l20n125, l20n126, l20n127,
	    X, l20n129, l20n130, l20n131, l20n132, X, l20n134, X, l20n136, l20n137, X, X, l20n140, l20n141, l20n142, l20n143,
	    X, l20n145, l20n146, l20n147, l20n148, l20n149, l20n150, X, l20n152, l20n153, X, l20n155, X, l20n157, l20n158, l20n159,
	    l20n160, l20n161, l20n162, X, l20n164, l20n165, l20n166, X, l20n168, l20n169, l20n170, l20n171, l20n172, l20n173, l20n174, l20n175,
	    l20n176, X, l20n178, l20n179, l20n180, l20n181, X, l20n183, l20n184, l20n185, X, l20n187, l20n188, l20n189, l20n190, l20n191,
	    l20n192, l20n193, l20n194, l20n195, X, l20n197, X, l20n199, l20n200, l20n201, l20n202, l20n203, l20n204, l20n205, l20n206, l20n207,
	    X, l20n209, l20n210, l20n211, l20n212, X, l20n214, l20n215, X, l20n217, l20n218, l20n219, l20n220, X, l20n222, l20n223,
	    X, l20n225, l20n226, l20n227, l20n228, X, X, X, l20n232, l20n233, l20n234, l20n235, l20n236, l20n237, l20n238, l20n239,
	    l20n240, l20n241, l20n242, l20n243, l20n244, l20n245, l20n246, X, l20n248, l20n249, l20n250, l20n251, l20n252, l20n253, l20n254, l20n255 }
};

//
// Lng: hungarian
// Enc: iso-8859-2
//

S sw7a[] = { s, z, 0 };
S sk79[] = { g, y, 0 };
S sgw7a[] = { 32, s, z, 0 };
S sRv[] = { 225, r, 0 };
S sk79g[] = { g, y, a };
S sgX7ag[] = { 32, 97, z, a };
S sik79[] = { e, g, y, 0 };
S se9r[] = { 233, n, 0 };
S sxxg[] = { t, t, a };
S sedx[] = { 237, t, 0 };
S sXk79[] = { 97, g, y, 0 };
S se9t[] = { 233, p, 0 };
S sgik79[] = { 32, e, g, y, 0 };
S sw7ai[] = { s, z, e, 0 };
S sof6[] = { k, 246, 0 };
S sge9w[] = { 32, 233, s, 0 };
S sge9wg[] = { 32, 233, s, a };
S sZw[] = { 99, s, 0 };
S sYY[] = { 98, 98, 0 };
S s7aiv[] = { z, e, r, 0 };
S sw7aR[] = { s, z, 225, 0 };
S sRwg[] = { 225, s, a };
S sosv[] = { k, o, r, 0 };
S sqik[] = { m, e, g, 0 };
S sf3p[] = { 243, l, 0 };
S sqR[] = { m, 225, 0 };
S sgqik[] = { 32, m, e, g, 0 };
S s7ae9[] = { z, 233, 0 };
S sf3pg[] = { 243, l, a };
S sik79g[] = { e, g, y, a };
S sRk[] = { 225, g, 0 };
S sw7aiv[] = { s, z, e, r, 0 };
S swed[] = { s, 237, 0 };
S sYXr[] = { 98, 97, n, 0 };
S swe9k[] = { s, 233, g, 0 };
S spf3[] = { l, 243, 0 };
S sxf6[] = { t, 246, 0 };
S sf6z[] = { 246, v, 0 };
S swedx[] = { s, 237, t, 0 };
S spix[] = { l, e, t, 0 };
S sRvg[] = { 225, r, a };
S se9o[] = { 233, k, 0 };
S sYXrg[] = { 98, 97, n, a };
S se9r79[] = { 233, n, y, 0 };
S sRpp[] = { 225, l, l, 0 };
S szXk79[] = { v, 97, g, y, 0 };
S se9xg[] = { 233, t, a };
S sf6p[] = { 246, l, 0 };
S sglsk[] = { 32, h, o, g, 0 };
S sgxf6[] = { 32, t, 246, 0 };
S sgof6[] = { 32, k, 246, 0 };
S sge9v[] = { 32, 233, r, 0 };
S sgqR[] = { 32, m, 225, 0 };
S sgre9[] = { 32, n, 233, 0 };
S sRo[] = { 225, k, 0 };
S srXo[] = { n, 97, k, 0 };
S soixg[] = { k, e, t, a };
S sze9r[] = { v, 233, n, 0 };
S szXk[] = { v, 97, g, 0 };
S sk79i[] = { g, y, e, 0 };
S sf6v[] = { 246, r, 0 };
S sgzXk[] = { 32, v, 97, g, 0 };
S sxe9w[] = { t, 233, s, 0 };
S sRY[] = { 225, 98, 0 };
S soix[] = { k, e, t, 0 };
S slsk[] = { h, o, g, 0 };
S sw7aX[] = { s, z, 97, 0 };
S sf6x[] = { 246, t, 0 };
S se9z[] = { 233, v, 0 };
S sf3o[] = { 243, k, 0 };
S soRv[] = { k, 225, r, 0 };
S sixxg[] = { e, t, t, a };
S srXog[] = { n, 97, k, a };
S sw7ae9[] = { s, z, 233, 0 };
S sYm7a[] = { 98, i, z, 0 };
S sgk79[] = { 32, g, y, 0 };
S sxswed[] = { t, o, s, 237, 0 };
S soY[] = { k, 98, 0 };
S sf6r[] = { 246, n, 0 };
S sv7a[] = { r, z, 0 };
S sXk79g[] = { 97, g, y, a };
S snR[] = { j, 225, 0 };
S sgw7ai[] = { 32, s, z, e, 0 };
S sgw7ae9[] = { 32, s, z, 233, 0 };
S s7aix[] = { z, e, t, 0 };
S sswedx[] = { o, s, 237, t, 0 };
S sgqmr[] = { 32, m, i, n, 0 };
S sgyx[] = { 32, u, t, 0 };
S sm7ax[] = { i, z, t, 0 };
S syhX[] = { u, d, 97, 0 };
S stw[] = { p, s, 0 };
S sm7axs[] = { i, z, t, o, 0 };
S sgYyh[] = { 32, 98, u, d, 0 };
S sxf3[] = { t, 243, 0 };
S somg[] = { k, i, a };
S sswed[] = { o, s, 237, 0 };
S se9kg[] = { 233, g, a };
S s7af5[] = { z, 245, 0 };
S s79io[] = { y, e, k, 0 };
S s7axs[] = { z, t, o, 0 };
S slsk79[] = { h, o, g, y, 0 };
S sgqe9[] = { 32, m, 233, 0 };
S sr79i[] = { n, y, e, 0 };
S sYm7ax[] = { 98, i, z, t, 0 };
S ssk79[] = { o, g, y, 0 };
S sge9z[] = { 32, 233, v, 0 };
S sYyhX[] = { 98, u, d, 97, 0 };
S ssk79g[] = { o, g, y, a };
S sgYy[] = { 32, 98, u, 0 };
S swso[] = { s, o, k, 0 };
S svz[] = { r, v, 0 };
S s7axsw[] = { z, t, o, s, 0 };
S siw7a[] = { e, s, z, 0 };
S s7aw[] = { z, s, 0 };
S sxsw[] = { t, o, s, 0 };
S sgoip[] = { 32, k, e, l, 0 };
S sxRr[] = { t, 225, n, 0 };
S spf5[] = { l, 245, 0 };
S srf6z[] = { n, 246, v, 0 };
S sgqXk[] = { 32, m, 97, g, 0 };
S sYirg[] = { 98, e, n, a };
S sxe9o[] = { t, 233, k, 0 };
S swedxR[] = { s, 237, t, 225, 0 };
S spr[] = { l, n, 0 };
S s79s[] = { y, o, 0 };
S sk79X[] = { g, y, 97, 0 };
S sxixx[] = { t, e, t, t, 0 };
S sYYg[] = { 98, 98, a };
S sre9t[] = { n, 233, p, 0 };
S sedxRw[] = { 237, t, 225, s, 0 };
S se9tw[] = { 233, p, s, 0 };
S srf6ze9[] = { n, 246, v, 233, 0 };
S sglR[] = { 32, h, 225, 0 };
S shf3[] = { d, 243, 0 };
S sRrg[] = { 225, n, a };
S sxRw[] = { t, 225, s, 0 };
S sgji[] = { 32, f, e, 0 };
S sriog[] = { n, e, k, a };
S sedxR[] = { 237, t, 225, 0 };
S sw7aXo[] = { s, z, 97, k, 0 };
S sr79io[] = { n, y, e, k, 0 };
S srf6[] = { n, 246, 0 };
S se9Y[] = { 233, 98, 0 };
S sqXk[] = { m, 97, g, 0 };
S sgZw[] = { 32, 99, s, 0 };
S sedxe9[] = { 237, t, 233, 0 };
S se9w7a[] = { 233, s, z, 0 };
S sRvs[] = { 225, r, o, 0 };
S spik[] = { l, e, g, 0 };
S sikg[] = { e, g, a };
S sRn[] = { 225, j, 0 };
S sf6ze9r[] = { 246, v, 233, n, 0 };
S sze9r79[] = { v, 233, n, y, 0 };
S se9r79i[] = { 233, n, y, e, 0 };
S sRog[] = { 225, k, a };
S sk79s[] = { g, y, o, 0 };
S soip[] = { k, e, l, 0 };
S srXt[] = { n, 97, p, 0 };
S sf6ze9[] = { 246, v, 233, 0 };
S s7aXo[] = { z, 97, k, 0 };

N l21n0[] = { { sriog, .217 }, H };
N l21n1[] = { { stX, .087 }, H };
N l21n2[] = { { sgik, .489 }, H };
N l21n3[] = { { ssv, .333 }, H };
N l21n5[] = { { smr, .145 }, { spR, .130 }, H };
N l21n6[] = { { srx, .130 }, { soixg, .304 }, { s79s, .072 }, H };
N l21n7[] = { { sw7a, .883 }, { sri, .304 }, H };
N l21n8[] = { { swo, .072 }, H };
N l21n9[] = { { slX, .174 }, { sYXr, .174 }, H };
N l21n10[] = { { sw7ae9, .152 }, H };
N l21n11[] = { { s7af5, .087 }, { sipp, .130 }, H };
N l21n12[] = { { sgp, .282 }, H };
N l21n13[] = { { swg, .999 }, { sXr, .275 }, { spm, .130 }, { se9z, .228 }, H };
N l21n14[] = { { se9k, .521 }, H };
N l21n15[] = { { sRpp, .391 }, { sji, .101 }, H };
N l21n17[] = { { sqXk, .109 }, H };
N l21n18[] = { { sik, .550 }, { sYyhX, .174 }, { sedxR, .244 }, H };
N l21n20[] = { { ssw, .232 }, H };
N l21n21[] = { { sog, 1.520 }, { sYm7a, .130 }, { shm, .087 }, H };
N l21n22[] = { { sRk, .293 }, { sgzXk, .304 }, { sXpX, .109 }, H };
N l21n24[] = { { s79X, .101 }, { sf6r, .195 }, { sXmg, .195 }, { se9w7a, .244 }, H };
N l21n25[] = { { sxixx, .145 }, H };
N l21n26[] = { { sm7axs, .174 }, H };
N l21n28[] = { { siw7a, .130 }, H };
N l21n29[] = { { sgq, 1.238 }, { sp79, .087 }, H };
N l21n30[] = { { sxe9o, .109 }, { spn, .072 }, H };
N l21n31[] = { { ssrg, .163 }, H };
N l21n32[] = { { sxxg, .554 }, { sgqe9, .195 }, H };
N l21n33[] = { { sxig, .195 }, { sxXp, .109 }, H };
N l21n35[] = { { sxswed, .174 }, { sil, .087 }, H };
N l21n36[] = { { sqR, .145 }, { sivi, .130 }, H };
N l21n37[] = { { ssx, .101 }, H };
N l21n38[] = { { sgxf6, .228 }, H };
N l21n40[] = { { szXk, .152 }, H };
N l21n41[] = { { sXk79g, .261 }, H };
N l21n42[] = { { sgmwg, .347 }, H };
N l21n44[] = { { sxg, 1.824 }, { sqm, .246 }, H };
N l21n45[] = { { svs, .174 }, H };
N l21n46[] = { { sgr, .543 }, { ski, .174 }, H };
N l21n47[] = { { sXt, .145 }, { sxf3, .087 }, H };
N l21n49[] = { { sRvg, .586 }, { sgre9, .228 }, H };
N l21n50[] = { { smog, .293 }, { sw7aX, .152 }, H };
N l21n51[] = { { stw, .087 }, H };
N l21n52[] = { { spg, .630 }, H };
N l21n54[] = { { spik, .109 }, H };
N l21n55[] = { { s7aX, .188 }, { spf3, .116 }, H };
N l21n57[] = { { sX7ag, .651 }, { sgip, .261 }, H };
N l21n58[] = { { sXog, .586 }, { se9wg, .953 }, { sosv, .217 }, { sippi, .145 }, H };
N l21n59[] = { { szR, .101 }, H };
N l21n61[] = { { sYs, .072 }, { svir, .109 }, H };
N l21n63[] = { { svX, .217 }, { s7ae9, .130 }, { sge9v, .228 }, { s7axs, .130 }, { shf3, .072 }, H };
N l21n64[] = { { spp, .275 }, H };
N l21n66[] = { { sRwg, .733 }, H };
N l21n67[] = { { sswed, .130 }, { srR, .072 }, H };
N l21n69[] = { { sik79, .391 }, { sti, .130 }, H };
N l21n71[] = { { sk79s, .109 }, H };
N l21n72[] = { { ssk, .145 }, { sgqX, .293 }, H };
N l21n73[] = { { swedxR, .145 }, { sRn, .163 }, H };
N l21n74[] = { { sge9w, .391 }, H };
N l21n75[] = { { sof6, .188 }, { se9xg, .513 }, { sixxg, .304 }, { sXpg, .195 }, H };
N l21n76[] = { { sws, .130 }, H };
N l21n77[] = { { sYir, .130 }, { sli, .087 }, H };
N l21n78[] = { { somg, .195 }, { soip, .109 }, H };
N l21n79[] = { { sixg, .554 }, { sYX, .159 }, H };
N l21n80[] = { { sgt, .152 }, H };
N l21n81[] = { { sgX, 2.019 }, { sXv, .174 }, H };
N l21n82[] = { { sgoi, .326 }, { se9o, .261 }, H };
N l21n83[] = { { sqg, .174 }, H };
N l21n84[] = { { sos, .289 }, H };
N l21n85[] = { { si7a, .174 }, { sqik, .217 }, H };
N l21n86[] = { { sio, .434 }, H };
N l21n87[] = { { syp, .130 }, H };
N l21n89[] = { { sge9, .630 }, { sgrX, .228 }, { spf5, .072 }, H };
N l21n90[] = { { smw, .261 }, { sRo, .228 }, H };
N l21n91[] = { { sig, .890 }, { sr79, .289 }, { smh, .087 }, H };
N l21n92[] = { { s79i, .217 }, { srXo, .152 }, { sf6v, .228 }, { sxsw, .130 }, H };
N l21n94[] = { { sw7ai, .304 }, { swX, .174 }, H };
N l21n95[] = { { szXp, .109 }, H };
N l21n96[] = { { sYY, .159 }, H };
N l21n97[] = { { s7aiv, .217 }, H };
N l21n98[] = { { sgY, .478 }, { sXw, .130 }, { sxf6, .116 }, { spr, .072 }, H };
N l21n99[] = { { sgpi, .261 }, { sXh, .116 }, { se9p, .163 }, H };
N l21n100[] = { { slsk, .152 }, { sgZw, .163 }, H };
N l21n102[] = { { swe9, .188 }, { soX, .130 }, { srxg, .195 }, H };
N l21n103[] = { { sip, .492 }, { sedx, .521 }, { srig, .195 }, H };
N l21n105[] = { { sYXrg, .347 }, { sgYy, .195 }, { s7aw, .087 }, H };
N l21n106[] = { { sedxe9, .244 }, H };
N l21n107[] = { { sRp, .423 }, { sxs, .188 }, { smx, .174 }, { sge9z, .195 }, { sedxRw, .326 }, H };
N l21n109[] = { { sro, .232 }, { sgik79, .608 }, { sXrg, .326 }, { spmg, .195 }, H };
N l21n110[] = { { soe9, .087 }, { se9kg, .440 }, H };
N l21n113[] = { { svw, .145 }, { sYm7ax, .174 }, H };
N l21n114[] = { { srg, .803 }, { sgv, .195 }, { svh, .101 }, { sikg, .163 }, H };
N l21n115[] = { { sXx, .275 }, { sgZ, .109 }, { sglR, .163 }, { sw7aXo, .145 }, H };
N l21n116[] = { { sgqi, .456 }, H };
N l21n117[] = { { srf6ze9, .145 }, H };
N l21n118[] = { { sxe9w, .152 }, H };
N l21n119[] = { { soY, .087 }, { s7aix, .130 }, H };
N l21n120[] = { { siq, .203 }, H };
N l21n122[] = { { s7ax, .289 }, H };
N l21n123[] = { { s7ai, .333 }, { shs, .116 }, { ssk79, .130 }, H };
N l21n124[] = { { sgw7ae9, .261 }, H };
N l21n125[] = { { sxX, .376 }, { sze9r, .152 }, { sgqXk, .217 }, H };
N l21n126[] = { { sgom, .489 }, { sf6x, .228 }, H };
N l21n130[] = { { sk79, .782 }, { svx, .203 }, H };
N l21n131[] = { { sgw, .868 }, { svi, .362 }, { spir, .109 }, H };
N l21n132[] = { { sgh, .217 }, H };
N l21n133[] = { { sxe9, .333 }, { se9r, .586 }, { spX, .217 }, { sgri, .195 }, H };
N l21n134[] = { { sgiw, .261 }, H };
N l21n135[] = { { sov, .116 }, H };
N l21n136[] = { { sf3o, .228 }, H };
N l21n137[] = { { sir, .565 }, { slR, .101 }, H };
N l21n139[] = { { ss7a, .145 }, H };
N l21n140[] = { { sso, .188 }, H };
N l21n141[] = { { sRr, .391 }, { shX, .159 }, { sgls, .358 }, { sgof6, .228 }, { sf3g, .342 }, { spe9, .072 }, H };
N l21n143[] = { { sgX7a, .717 }, H };
N l21n144[] = { { sww, .116 }, H };
N l21n146[] = { { sqs, .145 }, H };
N l21n147[] = { { sYi, .217 }, { szXk79, .203 }, { srXt, .109 }, H };
N l21n148[] = { { sgx, .608 }, H };
N l21n149[] = { { sgi, .955 }, { sgYyh, .261 }, H };
N l21n150[] = { { sXk, .304 }, { sgoip, .217 }, { sRvs, .244 }, H };
N l21n151[] = { { sppi, .174 }, H };
N l21n152[] = { { s7axsw, .174 }, { se9tw, .244 }, H };
N l21n153[] = { { skg, .369 }, { sf3p, .326 }, H };
N l21n155[] = { { sre9t, .109 }, H };
N l21n157[] = { { ssp, .246 }, H };
N l21n159[] = { { sswedx, .174 }, H };
N l21n160[] = { { sZw, .159 }, { sgqm, .358 }, { srr, .116 }, { sf6z, .261 }, { s79m, .087 }, { srio, .109 }, H };
N l21n161[] = { { swx, .130 }, { sgyx, .195 }, H };
N l21n162[] = { { swi, .203 }, H };
N l21n163[] = { { sYy, .101 }, { sf6ze9, .244 }, H };
N l21n164[] = { { sqX, .203 }, { svz, .087 }, H };
N l21n165[] = { { sik79g, .391 }, { sgy, .152 }, H };
N l21n166[] = { { sgj, .434 }, { swedx, .174 }, { soix, .152 }, H };
N l21n167[] = { { se9t, .456 }, H };
N l21n168[] = { { srf6, .072 }, H };
N l21n169[] = { { sgqik, .434 }, H };
N l21n170[] = { { soi, .391 }, { sge9wg, .521 }, { swed, .116 }, H };
N l21n172[] = { { sqe9, .145 }, H };
N l21n173[] = { { sYirg, .217 }, { sk79X, .109 }, { sioi, .109 }, H };
N l21n174[] = { { ssq, .087 }, H };
N l21n177[] = { { sgXg, 1.856 }, H };
N l21n178[] = { { sw7aR, .217 }, { sr79i, .130 }, H };
N l21n180[] = { { sw7aiv, .261 }, H };
N l21n182[] = { { sgz, .565 }, { siog, .554 }, H };
N l21n183[] = { { s7aR, .203 }, { sgk, .195 }, { sxRr, .109 }, H };
N l21n184[] = { { sXm, .130 }, { se9r79, .391 }, { sph, .072 }, H };
N l21n185[] = { { sgYi, .228 }, { se9Y, .163 }, H };
N l21n186[] = { { smwg, .293 }, { srf6z, .109 }, { sRog, .366 }, H };
N l21n187[] = { { szX, .275 }, { sr79g, .163 }, H };
N l21n188[] = { { srXog, .304 }, H };
N l21n189[] = { { sxix, .152 }, H };
N l21n190[] = { { sipi, .174 }, H };
N l21n191[] = { { ssr, .217 }, { s7am, .116 }, { svR, .101 }, H };
N l21n192[] = { { sxx, .362 }, { sYYg, .163 }, H };
N l21n193[] = { { sxi, .434 }, { sgw7a, .977 }, { sRY, .228 }, H };
N l21n194[] = { { sglsk, .304 }, H };
N l21n195[] = { { srX, .275 }, { sze9, .130 }, H };
N l21n197[] = { { spix, .174 }, H };
N l21n199[] = { { s79g, .608 }, { svm, .101 }, { snR, .087 }, { sipg, .163 }, H };
N l21n200[] = { { sgl, .717 }, { spx, .130 }, { sgqR, .228 }, H };
N l21n201[] = { { spi, .492 }, { se9v, .619 }, { sXk79, .326 }, { sgvi, .195 }, H };
N l21n202[] = { { sgmw, .391 }, H };
N l21n203[] = { { sf5g, .489 }, { sre9, .130 }, { smxg, .163 }, { sjX, .072 }, H };
N l21n204[] = { { soRv, .152 }, H };
N l21n205[] = { { siv, .391 }, { srog, .228 }, { sm7ax, .130 }, H };
N l21n207[] = { { syh, .101 }, { slsk79, .174 }, H };
N l21n208[] = { { s7aXo, .109 }, H };
N l21n209[] = { { sRv, .879 }, { sm7a, .145 }, { shi, .145 }, { sgR, .152 }, H };
N l21n210[] = { { smo, .188 }, H };
N l21n211[] = { { swe9k, .174 }, { sXxg, .195 }, H };
N l21n215[] = { { smg, .847 }, { sYm, .116 }, H };
N l21n216[] = { { siqg, .163 }, H };
N l21n217[] = { { sX7a, .391 }, { sgm, .565 }, { sk79i, .152 }, H };
N l21n218[] = { { sXo, .434 }, { se9w, .879 }, { siwx, .109 }, H };
N l21n219[] = { { ssk79g, .261 }, H };
N l21n221[] = { { sxXg, .163 }, H };
N l21n222[] = { { siw, .376 }, H };
N l21n223[] = { { sXg, 1.954 }, { syx, .130 }, { sih, .072 }, H };
N l21n225[] = { { sgzX, .423 }, H };
N l21n226[] = { { sk79g, .717 }, { sRw, .554 }, { sgqs, .228 }, H };
N l21n227[] = { { svig, .293 }, { smp, .116 }, H };
N l21n229[] = { { swso, .130 }, H };
N l21n230[] = { { s7ag, .586 }, { soR, .116 }, { sqmr, .152 }, H };
N l21n231[] = { { se9r79i, .326 }, H };
N l21n232[] = { { sqi, .304 }, { sv7a, .087 }, { sze9r79, .145 }, H };
N l21n233[] = { { sirg, .456 }, H };
N l21n234[] = { { sgn, .195 }, { sgk79, .195 }, { sgqmr, .261 }, { skX, .087 }, H };
N l21n235[] = { { sXp, .420 }, { se9x, .358 }, { sixx, .239 }, { sgxi, .228 }, H };
N l21n236[] = { { ssog, .163 }, H };
N l21n237[] = { { sRrg, .366 }, { sf6ze9r, .326 }, H };
N l21n238[] = { { som, .289 }, { svg, .369 }, { sxRw, .109 }, H };
N l21n239[] = { { six, .680 }, { sgX7ag, .825 }, { sYyh, .130 }, { sts, .087 }, H };
N l21n240[] = { { sgw7ai, .261 }, H };
N l21n243[] = { { sglX, .326 }, { sRx, .228 }, { sr79io, .145 }, H };
N l21n244[] = { { ssvw, .109 }, H };
N l21n245[] = { { s79io, .130 }, { sgXp, .163 }, H };
N l21n246[] = { { srh, .159 }, { sf6p, .228 }, H };
N l21n247[] = { { sls, .217 }, H };
N l21n249[] = { { sf3pg, .660 }, H };
N l21n250[] = { { syhX, .130 }, H };
N l21n251[] = { { sgo, .977 }, H };
N l21n252[] = { { sXq, .101 }, H };
N l21n253[] = { { sxR, .261 }, { sgji, .163 }, H };
N l21n254[] = { { sYg, .152 }, H };
N l21n255[] = { { szi, .275 }, H };

D l21_d = {
	"hungarian",
	"iso-8859-2",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, 0.001, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.174, 0.045, 0.009, 0.042, 0.196, 0.017, 0.073, 0.029, 0.084, 0.019, 0.121, 0.111, 0.059, 0.104, 0.074,
	    0.025, W, 0.091, 0.122, 0.152, 0.024, 0.042, W, W, 0.046, 0.085, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.001, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, 0.001, V, 0.003, V, V, V, V, 0.001, V, V, V, V, V,
	    V, 0.149, V, V, V, V, V, V, V, 0.177, V, V, V, 0.031, V, V,
	    V, V, V, 0.053, 0.013, 0.034, 0.063, V, V, V, 0.017, 0.009, 0.021, V, V, V },
	{ l21n0, l21n1, l21n2, l21n3, X, l21n5, l21n6, l21n7, l21n8, l21n9, l21n10, l21n11, l21n12, l21n13, l21n14, l21n15,
	    X, l21n17, l21n18, X, l21n20, l21n21, l21n22, X, l21n24, l21n25, l21n26, X, l21n28, l21n29, l21n30, l21n31,
	    l21n32, l21n33, X, l21n35, l21n36, l21n37, l21n38, X, l21n40, l21n41, l21n42, X, l21n44, l21n45, l21n46, l21n47,
	    X, l21n49, l21n50, l21n51, l21n52, X, l21n54, l21n55, X, l21n57, l21n58, l21n59, X, l21n61, X, l21n63,
	    l21n64, X, l21n66, l21n67, X, l21n69, X, l21n71, l21n72, l21n73, l21n74, l21n75, l21n76, l21n77, l21n78, l21n79,
	    l21n80, l21n81, l21n82, l21n83, l21n84, l21n85, l21n86, l21n87, X, l21n89, l21n90, l21n91, l21n92, X, l21n94, l21n95,
	    l21n96, l21n97, l21n98, l21n99, l21n100, X, l21n102, l21n103, X, l21n105, l21n106, l21n107, X, l21n109, l21n110, X,
	    X, l21n113, l21n114, l21n115, l21n116, l21n117, l21n118, l21n119, l21n120, X, l21n122, l21n123, l21n124, l21n125, l21n126, X,
	    X, X, l21n130, l21n131, l21n132, l21n133, l21n134, l21n135, l21n136, l21n137, X, l21n139, l21n140, l21n141, X, l21n143,
	    l21n144, X, l21n146, l21n147, l21n148, l21n149, l21n150, l21n151, l21n152, l21n153, X, l21n155, X, l21n157, X, l21n159,
	    l21n160, l21n161, l21n162, l21n163, l21n164, l21n165, l21n166, l21n167, l21n168, l21n169, l21n170, X, l21n172, l21n173, l21n174, X,
	    X, l21n177, l21n178, X, l21n180, X, l21n182, l21n183, l21n184, l21n185, l21n186, l21n187, l21n188, l21n189, l21n190, l21n191,
	    l21n192, l21n193, l21n194, l21n195, X, l21n197, X, l21n199, l21n200, l21n201, l21n202, l21n203, l21n204, l21n205, X, l21n207,
	    l21n208, l21n209, l21n210, l21n211, X, X, X, l21n215, l21n216, l21n217, l21n218, l21n219, X, l21n221, l21n222, l21n223,
	    X, l21n225, l21n226, l21n227, X, l21n229, l21n230, l21n231, l21n232, l21n233, l21n234, l21n235, l21n236, l21n237, l21n238, l21n239,
	    l21n240, X, X, l21n243, l21n244, l21n245, l21n246, l21n247, X, l21n249, l21n250, l21n251, l21n252, l21n253, l21n254, l21n255 }
};

//
// Lng: icelandic
// Enc: iso-8859-1
//

S sXf0[] = { 97, 240, 0 };
S sXf0g[] = { 97, 240, a };
S sgedg[] = { 32, 237, a };
S smf0[] = { i, 240, 0 };
S sgXf0[] = { 32, 97, 240, 0 };
S sgfe[] = { 32, 254, 0 };
S sgXf0g[] = { 32, 97, 240, a };
S sf0y[] = { 240, u, 0 };
S sf0m[] = { 240, i, 0 };
S smf0g[] = { i, 240, a };
S svf0[] = { r, 240, 0 };
S sf0X[] = { 240, 97, 0 };
S srrg[] = { n, n, a };
S sryq[] = { n, u, m, 0 };
S sryqg[] = { n, u, m, a };
S swiq[] = { s, e, m, 0 };
S spf6[] = { l, 246, 0 };
S sgwiq[] = { 32, s, e, m, 0 };
S swiqg[] = { s, e, m, a };
S sf0mg[] = { 240, i, a };
S sYW[] = { 98, 230, 0 };
S srXv[] = { n, 97, r, 0 };
S sfei[] = { 254, e, 0 };
S svj[] = { r, f, 0 };
S sf0yv[] = { 240, u, r, 0 };
S sgfei[] = { 32, 254, e, 0 };
S snf3[] = { j, 243, 0 };
S sWo[] = { 230, k, 0 };
S sf6k[] = { 246, g, 0 };
S syf0[] = { u, 240, 0 };
S sioo[] = { e, k, k, 0 };
S srXvg[] = { n, 97, r, a };
S si79[] = { e, y, 0 };
S sedo[] = { 237, k, 0 };
S sj79v[] = { f, y, r, 0 };
S s79vmv[] = { y, r, i, r, 0 };
S smry[] = { i, n, u, 0 };
S swpy[] = { s, l, u, 0 };
S s79vm[] = { y, r, i, 0 };
S sj79vm[] = { f, y, r, i, 0 };
S sj79[] = { f, y, 0 };
S svmv[] = { r, i, r, 0 };
S sivf0[] = { e, r, 240, 0 };
S sjn[] = { f, j, 0 };
S son[] = { k, j, 0 };
S svf0y[] = { r, 240, u, 0 };
S sgyq[] = { 32, u, m, 0 };
S sgfeX[] = { 32, 254, 97, 0 };
S sf0w[] = { 240, s, 0 };
S sjy[] = { f, u, 0 };
S sXvj[] = { 97, r, f, 0 };
S sioom[] = { e, k, k, i, 0 };
S soom[] = { k, k, i, 0 };
S sfeX[] = { 254, 97, 0 };
S soomg[] = { k, k, i, a };
S sgioo[] = { 32, e, k, k, 0 };
S sgj79v[] = { 32, f, y, r, 0 };
S spf6k[] = { l, 246, g, 0 };
S sgyqg[] = { 32, u, m, a };
S sjW[] = { f, 230, 0 };
S srrm[] = { n, n, i, 0 };
S sf0yvg[] = { 240, u, r, a };
S sgj79[] = { 32, f, y, 0 };
S svyg[] = { r, u, a };
S spyg[] = { l, u, a };
S sgYW[] = { 32, 98, 230, 0 };
S sgyt[] = { 32, u, p, 0 };
S sf0Xg[] = { 240, 97, a };
S skXv[] = { g, 97, r, 0 };
S sgytt[] = { 32, u, p, p, 0 };
S sfax[] = { 250, t, 0 };
S sgwe9[] = { 32, s, 233, 0 };
S syf0y[] = { u, 240, u, 0 };
S sf3r[] = { 243, n, 0 };
S sf0yg[] = { 240, u, a };
S sXf0m[] = { 97, 240, i, 0 };
S sif0[] = { e, 240, 0 };
S slij[] = { h, e, f, 0 };
S srkm[] = { n, g, i, 0 };
S sytt[] = { u, p, p, 0 };
S sglij[] = { 32, h, e, f, 0 };
S sWf0[] = { 230, 240, 0 };
S sivf0y[] = { e, r, 240, u, 0 };
S svmvg[] = { r, i, r, a };
S sivy[] = { e, r, u, 0 };
S soyr[] = { k, u, n, 0 };
S sWx[] = { 230, t, 0 };
S sXzedo[] = { 97, v, 237, k, 0 };
S sgjWo[] = { 32, f, 230, k, 0 };
S sgivy[] = { 32, e, r, u, 0 };
S sgjn[] = { 32, f, j, 0 };
S svi79[] = { r, e, y, 0 };
S sjWo[] = { f, 230, k, 0 };
S sWoo[] = { 230, k, k, 0 };
S simf0[] = { e, i, 240, 0 };
S sivyg[] = { e, r, u, a };
S snXv[] = { j, 97, r, 0 };
S sjr[] = { f, n, 0 };
S sfaxg[] = { 250, t, a };
S sgjW[] = { 32, f, 230, 0 };
S svf0yv[] = { r, 240, u, r, 0 };
S smrrm[] = { i, n, n, i, 0 };
S svmf0[] = { r, i, 240, 0 };
S sf0Xv[] = { 240, 97, r, 0 };
S sXzed[] = { 97, v, 237, 0 };
S sjWoo[] = { f, 230, k, k, 0 };
S szedo[] = { v, 237, k, 0 };
S sirk[] = { e, n, g, 0 };
S sjyvg[] = { f, u, r, a };
S swos[] = { s, k, o, 0 };
S sgij[] = { 32, e, f, 0 };
S sgfax[] = { 32, 250, t, 0 };
S spmf0[] = { l, i, 240, 0 };
S shXk[] = { d, 97, g, 0 };
S sWvg[] = { 230, r, a };
S sryf0[] = { n, u, 240, 0 };
S slz[] = { h, v, 0 };
S smf0w[] = { i, 240, s, 0 };
S spk[] = { l, g, 0 };
S sonX[] = { k, j, 97, 0 };
S szedoy[] = { v, 237, k, u, 0 };
S shyvg[] = { d, u, r, a };
S sxmv[] = { t, i, r, 0 };
S sg25[] = { 32, 37, 0 };
S sedoyv[] = { 237, k, u, r, 0 };
S swxyg[] = { s, t, u, a };
S sf3x[] = { 243, t, 0 };
S smrrg[] = { i, n, n, a };
S sXf0mg[] = { 97, 240, i, a };
S soXf0m[] = { k, 97, 240, i, 0 };
S sjvX[] = { f, r, 97, 0 };
S soXf0[] = { k, 97, 240, 0 };
S sje9[] = { f, 233, 0 };
S s25g[] = { 37, a };
S sYWg[] = { 98, 230, a };
S sXrrg[] = { 97, n, n, a };
S sxW[] = { t, 230, 0 };
S sxmvg[] = { t, i, r, a };
S sedoy[] = { 237, k, u, 0 };
S s79w[] = { y, s, 0 };
S sjvXq[] = { f, r, 97, m, 0 };
S sg25g[] = { 32, 37, a };
S sxXvj[] = { t, 97, r, f, 0 };
S smryg[] = { i, n, u, a };
S s79o[] = { y, k, 0 };
S sirr[] = { e, n, n, 0 };
S sjyv[] = { f, u, r, 0 };
S snXr[] = { j, 97, n, 0 };
S soyrg[] = { k, u, n, a };
S spXf0[] = { l, 97, 240, 0 };
S sgjp[] = { 32, f, l, 0 };
S spyq[] = { l, u, m, 0 };
S swe9vg[] = { s, 233, r, a };
S sgvi79[] = { 32, r, e, y, 0 };
S sgfaxg[] = { 32, 250, t, a };
S skyqg[] = { g, u, m, a };
S sfeXv[] = { 254, 97, r, 0 };
S si79on[] = { e, y, k, j, 0 };
S sgfeim[] = { 32, 254, e, i, 0 };
S sijy[] = { e, f, u, 0 };
S swpyg[] = { s, l, u, a };

N l22n0[] = { { srrg, .500 }, { stt, .131 }, { soyvg, .235 }, H };
N l22n1[] = { { sgXf0g, 1.216 }, { sij, .274 }, { swxg, .294 }, { snXr, .098 }, H };
N l22n2[] = { { syk, .078 }, H };
N l22n3[] = { { ssv, .131 }, H };
N l22n5[] = { { smr, .719 }, { sxm, .366 }, { sXzedo, .183 }, { sjyv, .118 }, H };
N l22n6[] = { { svim, .098 }, H };
N l22n7[] = { { smf0g, .676 }, { sri, .170 }, { szed, .118 }, H };
N l22n8[] = { { swo, .248 }, { swxyg, .235 }, { sijy, .098 }, H };
N l22n9[] = { { sf0m, .735 }, { slX, .183 }, { srXvg, .471 }, { sxmpg, .353 }, H };
N l22n11[] = { { skv, .131 }, H };
N l22n12[] = { { sgskg, 1.294 }, { sgp, .392 }, { smry, .216 }, H };
N l22n13[] = { { sXr, .471 }, { sgzi, .765 }, { swg, .353 }, { spm, .170 }, { svmvg, .274 }, H };
N l22n14[] = { { sgki, .294 }, H };
N l22n15[] = { { sXf0g, 1.382 }, { sji, .105 }, H };
N l22n16[] = { { soo, .301 }, H };
N l22n18[] = { { sik, .209 }, { s79vmv, .288 }, H };
N l22n19[] = { { sgXjg, .196 }, H };
N l22n21[] = { { sgfei, .412 }, { sog, .235 }, { shm, .144 }, H };
N l22n23[] = { { sry, .523 }, { sgxm, .265 }, { svmf0, .137 }, { sjvX, .118 }, H };
N l22n24[] = { { sgim, .265 }, { sf6r, .176 }, H };
N l22n25[] = { { swp, .301 }, { sfeXv, .221 }, H };
N l22n26[] = { { simv, .118 }, H };
N l22n27[] = { { syf0, .170 }, { sf0yvg, .794 }, { svf0yv, .183 }, { si79on, .131 }, H };
N l22n28[] = { { svr, .131 }, { sgwo, .265 }, H };
N l22n29[] = { { syvg, 1.088 }, { sgq, .725 }, { sivf0, .216 }, H };
N l22n30[] = { { spn, .091 }, H };
N l22n31[] = { { sgli, .353 }, { sjy, .131 }, { smrrg, .235 }, H };
N l22n32[] = { { swpy, .216 }, H };
N l22n33[] = { { sgwiq, .588 }, { srhX, .157 }, { sf3x, .176 }, H };
N l22n34[] = { { syf0y, .157 }, H };
N l22n35[] = { { srXg, .265 }, { srrm, .176 }, H };
N l22n36[] = { { sYW, .183 }, H };
N l22n38[] = { { sryqg, .627 }, H };
N l22n39[] = { { shyvg, .235 }, { sXrrg, .235 }, H };
N l22n41[] = { { srk, .314 }, H };
N l22n42[] = { { sioom, .261 }, { sonX, .118 }, H };
N l22n43[] = { { sif0, .105 }, { sedoyv, .353 }, H };
N l22n44[] = { { sxg, .588 }, { sqm, .209 }, H };
N l22n45[] = { { sivg, .265 }, { snXv, .137 }, H };
N l22n46[] = { { sgr, .392 }, { ski, .183 }, { sgio, .294 }, H };
N l22n47[] = { { sgj79v, .353 }, H };
N l22n48[] = { { sf0g, 3.617 }, { simx, .118 }, H };
N l22n49[] = { { sgRg, .765 }, { sxyg, .235 }, H };
N l22n50[] = { { sXf0m, .157 }, H };
N l22n51[] = { { sfeX, .294 }, { syrr, .118 }, H };
N l22n52[] = { { sim, .536 }, { spg, .274 }, { sgjn, .206 }, { sivyg, .274 }, { sgvi79, .196 }, H };
N l22n53[] = { { sf0yg, .529 }, H };
N l22n57[] = { { s79v, .183 }, { spyg, .265 }, { sgzm, .235 }, { sjWo, .137 }, H };
N l22n62[] = { { sky, .196 }, H };
N l22n63[] = { { sgs, .706 }, { svX, .301 }, H };
N l22n64[] = { { spp, .170 }, H };
N l22n67[] = { { szm, .170 }, { smpg, .294 }, { sirr, .118 }, H };
N l22n68[] = { { si79, .157 }, { sgYW, .235 }, H };
N l22n71[] = { { snX, .314 }, H };
N l22n72[] = { { ssk, .444 }, { sgYv, .206 }, { sgqX, .176 }, H };
N l22n73[] = { { smv, .471 }, { sj79v, .216 }, H };
N l22n74[] = { { skXg, .235 }, { s79w, .078 }, { sgjp, .147 }, H };
N l22n75[] = { { syg, 1.098 }, { srm, .222 }, { sxmvg, .235 }, H };
N l22n77[] = { { sli, .170 }, { skyqg, .196 }, H };
N l22n78[] = { { somg, .382 }, H };
N l22n79[] = { { sgir, .235 }, H };
N l22n80[] = { { sgfeim, .196 }, H };
N l22n81[] = { { sXv, .954 }, { sgX, 1.039 }, { swiq, .314 }, { sglij, .314 }, H };
N l22n82[] = { { sgoi, .235 }, { sxW, .078 }, H };
N l22n83[] = { { sqg, 1.353 }, { sjm, .091 }, H };
N l22n84[] = { { sos, .157 }, { sgyq, .294 }, { srkX, .118 }, H };
N l22n85[] = { { sg25, .118 }, H };
N l22n86[] = { { sio, .222 }, H };
N l22n87[] = { { se9g, .265 }, H };
N l22n89[] = { { sXrh, .118 }, H };
N l22n90[] = { { smw, .170 }, { sfaxg, .463 }, H };
N l22n91[] = { { sgxmp, .353 }, H };
N l22n93[] = { { spmf0, .118 }, H };
N l22n94[] = { { swX, .131 }, { sjvXq, .157 }, H };
N l22n95[] = { { sRg, 1.588 }, { sgyr, .235 }, H };
N l22n98[] = { { sgY, .627 }, { sXw, .091 }, { skvi, .137 }, { sgimr, .196 }, H };
N l22n99[] = { { sgziv, .627 }, { sj79, .144 }, { sxXv, .118 }, H };
N l22n100[] = { { sjn, .131 }, H };
N l22n101[] = { { sjyvg, .235 }, { sxmg, .176 }, H };
N l22n102[] = { { soX, .209 }, { swe9, .105 }, H };
N l22n103[] = { { sip, .091 }, { sf0Xv, .309 }, { sryf0, .118 }, H };
N l22n104[] = { { syq, .640 }, H };
N l22n105[] = { { sf0mg, .993 }, H };
N l22n106[] = { { spf6, .196 }, H };
N l22n107[] = { { smx, .105 }, { sytt, .157 }, H };
N l22n108[] = { { sWv, .235 }, { smryg, .235 }, H };
N l22n109[] = { { sXrg, .265 }, { svwx, .118 }, H };
N l22n110[] = { { slz, .078 }, H };
N l22n111[] = { { sgioo, .392 }, H };
N l22n112[] = { { sYv, .131 }, H };
N l22n113[] = { { svw, .118 }, H };
N l22n114[] = { { srg, 1.098 }, { skm, .196 }, { sgv, .176 }, { smrk, .157 }, H };
N l22n115[] = { { sXx, .078 }, H };
N l22n116[] = { { sgqi, .265 }, { soyr, .137 }, H };
N l22n117[] = { { sgyt, .235 }, H };
N l22n118[] = { { sgfax, .176 }, H };
N l22n119[] = { { sfei, .412 }, { sryg, .265 }, H };
N l22n120[] = { { siq, .261 }, H };
N l22n121[] = { { syr, .444 }, H };
N l22n122[] = { { sjg, .196 }, { sgfa, .137 }, { sjWoo, .183 }, H };
N l22n123[] = { { sgiv, .500 }, H };
N l22n124[] = { { sivf0y, .183 }, H };
N l22n125[] = { { sxX, .405 }, H };
N l22n127[] = { { sgwx, .294 }, H };
N l22n128[] = { { swpyg, .196 }, H };
N l22n129[] = { { sf0X, .529 }, H };
N l22n130[] = { { svx, .091 }, H };
N l22n131[] = { { sgw, 1.588 }, { svi, .248 }, H };
N l22n132[] = { { sj79vm, .288 }, { simf0, .137 }, { sXy, .078 }, { sYWg, .176 }, H };
N l22n133[] = { { spX, .366 }, { sXj, .222 }, H };
N l22n134[] = { { sjp, .170 }, { sgwe9, .235 }, H };
N l22n136[] = { { sgjW, .206 }, { spyq, .098 }, H };
N l22n137[] = { { sir, .379 }, H };
N l22n140[] = { { sgjv, .265 }, H };
N l22n141[] = { { shX, .196 }, H };
N l22n142[] = { { sWx, .206 }, { sWoo, .309 }, { smk, .091 }, H };
N l22n144[] = { { sww, .105 }, H };
N l22n146[] = { { sXf0mg, .235 }, H };
N l22n147[] = { { svy, .144 }, { soom, .196 }, H };
N l22n148[] = { { sgx, .451 }, { svj, .183 }, H };
N l22n149[] = { { sgi, 1.059 }, { sXz, .118 }, { sxXvj, .157 }, H };
N l22n150[] = { { sXk, .196 }, H };
N l22n152[] = { { smf0w, .118 }, H };
N l22n153[] = { { skg, .941 }, { sf3p, .206 }, H };
N l22n155[] = { { sny, .144 }, { syt, .105 }, { s25g, .118 }, H };
N l22n157[] = { { sged, .902 }, H };
N l22n158[] = { { sxv, .078 }, { sgO, .098 }, H };
N l22n159[] = { { svXg, .176 }, H };
N l22n160[] = { { srr, .549 }, { sgqm, .324 }, { soyv, .176 }, { sjW, .118 }, { szedo, .137 }, H };
N l22n161[] = { { swx, .575 }, { sgXf0, 1.088 }, { sf6k, .382 }, H };
N l22n162[] = { { swi, .248 }, H };
N l22n164[] = { { sqX, .157 }, H };
N l22n165[] = { { sgy, .529 }, { skp, .091 }, H };
N l22n166[] = { { sgj, 1.118 }, H };
N l22n167[] = { { smf0, .497 }, { snXg, .235 }, H };
N l22n168[] = { { sskg, .971 }, { swxy, .157 }, { sjr, .091 }, H };
N l22n169[] = { { smvg, .647 }, { srXv, .274 }, { sxmp, .176 }, { sox, .105 }, H };
N l22n170[] = { { soi, .118 }, { swed, .065 }, H };
N l22n171[] = { { srmg, .176 }, H };
N l22n172[] = { { sgsk, .971 }, { srkm, .157 }, { swe9vg, .196 }, H };
N l22n173[] = { { svmv, .216 }, H };
N l22n175[] = { { sXf0, .837 }, { slij, .157 }, { sgirg, .274 }, H };
N l22n177[] = { { sXvg, 1.000 }, { swiqg, .588 }, H };
N l22n178[] = { { swy, .118 }, H };
N l22n179[] = { { sf0w, .294 }, { sXvj, .196 }, { sgXj, .235 }, H };
N l22n180[] = { { sgyqg, .353 }, H };
N l22n181[] = { { sg25g, .176 }, H };
N l22n182[] = { { sgz, .823 }, { svi79, .137 }, { soXf0, .118 }, H };
N l22n183[] = { { sgk, .569 }, H };
N l22n184[] = { { sph, .091 }, H };
N l22n186[] = { { soy, .261 }, H };
N l22n187[] = { { sf0yv, .618 }, { szX, .118 }, { sf3r, .235 }, H };
N l22n188[] = { { s79vm, .216 }, H };
N l22n189[] = { { syv, .627 }, H };
N l22n190[] = { { sgfe, .706 }, { svf0, .301 }, H };
N l22n191[] = { { smrr, .373 }, H };
N l22n192[] = { { sxx, .170 }, H };
N l22n193[] = { { sxi, .157 }, H };
N l22n194[] = { { s79o, .078 }, H };
N l22n195[] = { { srX, .392 }, { swz, .065 }, H };
N l22n196[] = { { sXzed, .137 }, H };
N l22n197[] = { { svf0y, .196 }, { sgytt, .314 }, { syrh, .137 }, H };
N l22n198[] = { { sryq, .314 }, H };
N l22n199[] = { { svm, .366 }, { skr, .118 }, { sXrr, .176 }, { snR, .078 }, { shyv, .118 }, H };
N l22n200[] = { { sgl, .882 }, { syqg, 1.323 }, H };
N l22n201[] = { { spi, .131 }, { sgvi, .206 }, { sgjWo, .274 }, H };
N l22n202[] = { { sWf0, .206 }, { sywx, .137 }, H };
N l22n203[] = { { sjX, .105 }, { srrX, .118 }, H };
N l22n204[] = { { sWvg, .397 }, H };
N l22n205[] = { { siv, .575 }, { swos, .118 }, H };
N l22n206[] = { { sedo, .353 }, { syw, .144 }, H };
N l22n208[] = { { skXv, .157 }, H };
N l22n209[] = { { sgR, .706 }, { sxy, .261 }, { sRv, .176 }, H };
N l22n210[] = { { smo, .105 }, H };
N l22n211[] = { { sedg, 1.853 }, { sje9, .078 }, H };
N l22n212[] = { { sivy, .137 }, { soyrg, .196 }, H };
N l22n213[] = { { sf0y, .853 }, { sedoy, .265 }, { spXf0, .098 }, { sirh, .098 }, H };
N l22n214[] = { { sgfaxg, .196 }, H };
N l22n215[] = { { smg, 1.137 }, { spf6k, .176 }, H };
N l22n216[] = { { siqg, .441 }, H };
N l22n217[] = { { spy, .366 }, { syrg, .265 }, { sgj79, .265 }, H };
N l22n218[] = { { sgwi, .471 }, { sgivy, .274 }, H };
N l22n219[] = { { sgivg, .353 }, H };
N l22n221[] = { { sxXg, .265 }, H };
N l22n222[] = { { siw, .196 }, H };
N l22n223[] = { { sXg, 1.294 }, { syx, .105 }, H };
N l22n225[] = { { shy, .118 }, { sf0Xg, .529 }, H };
N l22n227[] = { { smp, .248 }, H };
N l22n229[] = { { sziv, .353 }, { sXjg, .147 }, H };
N l22n230[] = { { swm, .131 }, { sqmr, .098 }, H };
N l22n232[] = { { sqi, .157 }, H };
N l22n233[] = { { sgfeX, .294 }, { svo, .091 }, { sirg, .206 }, H };
N l22n234[] = { { skX, .261 }, H };
N l22n235[] = { { sXp, .170 }, { spk, .078 }, { sxmv, .118 }, H };
N l22n236[] = { { sjv, .170 }, H };
N l22n238[] = { { svg, 2.314 }, { som, .301 }, { simr, .157 }, { svXq, .137 }, H };
N l22n239[] = { { sioo, .235 }, { six, .131 }, H };
N l22n241[] = { { soXf0m, .157 }, H };
N l22n243[] = { { sglX, .382 }, { soomg, .392 }, { svyg, .265 }, H };
N l22n245[] = { { sWo, .412 }, { srw, .131 }, H };
N l22n246[] = { { srh, .314 }, { sirk, .137 }, { sf6p, .176 }, H };
N l22n247[] = { { sgij, .176 }, H };
N l22n248[] = { { sriw, .157 }, { sqy, .078 }, H };
N l22n249[] = { { snf3, .183 }, H };
N l22n250[] = { { sfax, .235 }, { svp, .091 }, { smrrm, .183 }, { shXk, .118 }, { sWg, .265 }, H };
N l22n251[] = { { sgo, .373 }, H };
N l22n252[] = { { sXq, .183 }, H };
N l22n253[] = { { sgedg, 1.206 }, H };
N l22n255[] = { { szi, .457 }, { son, .131 }, { szedoy, .157 }, H };

D l22_d = {
	"icelandic",
	"iso-8859-1",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, 0.003, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.176, 0.027, W, 0.025, 0.127, 0.071, 0.086, 0.029, 0.133, 0.033, 0.079, 0.087, 0.073, 0.149, 0.037,
	    0.018, W, 0.166, 0.108, 0.094, 0.130, 0.040, W, W, 0.019, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.001, V, V, V, V, V, V, V, 0.001, V, V, V, 0.005, V, V,
	    V, V, V, V, V, V, V, V, V, V, 0.001, V, V, V, 0.006, V,
	    V, 0.074, V, V, V, V, 0.065, V, V, 0.021, V, V, V, 0.084, V, V,
	    0.206, V, V, 0.051, V, V, 0.051, V, V, V, 0.031, V, V, 0.011, 0.045, V },
	{ l22n0, l22n1, l22n2, l22n3, X, l22n5, l22n6, l22n7, l22n8, l22n9, X, l22n11, l22n12, l22n13, l22n14, l22n15,
	    l22n16, X, l22n18, l22n19, X, l22n21, X, l22n23, l22n24, l22n25, l22n26, l22n27, l22n28, l22n29, l22n30, l22n31,
	    l22n32, l22n33, l22n34, l22n35, l22n36, X, l22n38, l22n39, X, l22n41, l22n42, l22n43, l22n44, l22n45, l22n46, l22n47,
	    l22n48, l22n49, l22n50, l22n51, l22n52, l22n53, X, X, X, l22n57, X, X, X, X, l22n62, l22n63,
	    l22n64, X, X, l22n67, l22n68, X, X, l22n71, l22n72, l22n73, l22n74, l22n75, X, l22n77, l22n78, l22n79,
	    l22n80, l22n81, l22n82, l22n83, l22n84, l22n85, l22n86, l22n87, X, l22n89, l22n90, l22n91, X, l22n93, l22n94, l22n95,
	    X, X, l22n98, l22n99, l22n100, l22n101, l22n102, l22n103, l22n104, l22n105, l22n106, l22n107, l22n108, l22n109, l22n110, l22n111,
	    l22n112, l22n113, l22n114, l22n115, l22n116, l22n117, l22n118, l22n119, l22n120, l22n121, l22n122, l22n123, l22n124, l22n125, X, l22n127,
	    l22n128, l22n129, l22n130, l22n131, l22n132, l22n133, l22n134, X, l22n136, l22n137, X, X, l22n140, l22n141, l22n142, X,
	    l22n144, X, l22n146, l22n147, l22n148, l22n149, l22n150, X, l22n152, l22n153, X, l22n155, X, l22n157, l22n158, l22n159,
	    l22n160, l22n161, l22n162, X, l22n164, l22n165, l22n166, l22n167, l22n168, l22n169, l22n170, l22n171, l22n172, l22n173, X, l22n175,
	    X, l22n177, l22n178, l22n179, l22n180, l22n181, l22n182, l22n183, l22n184, X, l22n186, l22n187, l22n188, l22n189, l22n190, l22n191,
	    l22n192, l22n193, l22n194, l22n195, l22n196, l22n197, l22n198, l22n199, l22n200, l22n201, l22n202, l22n203, l22n204, l22n205, l22n206, X,
	    l22n208, l22n209, l22n210, l22n211, l22n212, l22n213, l22n214, l22n215, l22n216, l22n217, l22n218, l22n219, X, l22n221, l22n222, l22n223,
	    X, l22n225, X, l22n227, X, l22n229, l22n230, X, l22n232, l22n233, l22n234, l22n235, l22n236, X, l22n238, l22n239,
	    X, l22n241, X, l22n243, X, l22n245, l22n246, l22n247, l22n248, l22n249, l22n250, l22n251, l22n252, l22n253, X, l22n255 }
};

//
// Lng: irish
// Enc: iso-8859-1
//

S sYl[] = { 98, h, 0 };
S sgYl[] = { 32, 98, h, 0 };
S sgXrg[] = { 32, 97, n, a };
S sgXk[] = { 32, 97, g, 0 };
S sql[] = { m, h, 0 };
S sXZlg[] = { 97, 99, h, a };
S swe9g[] = { s, 233, a };
S sRm[] = { 225, i, 0 };
S sgwe9g[] = { 32, s, 233, a };
S siXr[] = { e, 97, n, 0 };
S se9X[] = { 233, 97, 0 };
S slXm[] = { h, 97, i, 0 };
S sXkyw[] = { 97, g, u, s, 0 };
S sgXvg[] = { 32, 97, r, a };
S skyw[] = { g, u, s, 0 };
S sgXky[] = { 32, 97, g, u, 0 };
S skywg[] = { g, u, s, a };
S sXky[] = { 97, g, u, 0 };
S sgXZ[] = { 32, 97, 99, 0 };
S shlg[] = { d, h, a };
S sled[] = { h, 237, 0 };
S se9m[] = { 233, i, 0 };
S sYled[] = { 98, h, 237, 0 };
S sgYled[] = { 32, 98, h, 237, 0 };
S sxRg[] = { t, 225, a };
S skl[] = { g, h, 0 };
S sgred[] = { 32, n, 237, 0 };
S siXv[] = { e, 97, r, 0 };
S sXql[] = { 97, m, h, 0 };
S smkl[] = { i, g, h, 0 };
S siXZ[] = { e, 97, 99, 0 };
S sgXkg[] = { 32, 97, g, a };
S sYledg[] = { 98, h, 237, a };
S sledg[] = { h, 237, a };
S siXZl[] = { e, 97, 99, h, 0 };
S sgksg[] = { 32, g, o, a };
S sjl[] = { f, h, 0 };
S sqlg[] = { m, h, a };
S sliX[] = { h, e, 97, 0 };
S sved[] = { r, 237, 0 };
S sis[] = { e, o, 0 };
S seds[] = { 237, o, 0 };
S sgjl[] = { 32, f, h, 0 };
S slRm[] = { h, 225, i, 0 };
S sgxRg[] = { 32, t, 225, a };
S sxlg[] = { t, h, a };
S sgxR[] = { 32, t, 225, 0 };
S sXmk[] = { 97, i, g, 0 };
S sXmh[] = { 97, i, d, 0 };
S sZlX[] = { 99, h, 97, 0 };
S smxlg[] = { i, t, h, a };
S sXmxl[] = { 97, i, t, h, 0 };
S sgXZl[] = { 32, 97, 99, h, 0 };
S sXqlg[] = { 97, m, h, a };
S slj[] = { h, f, 0 };
S sklg[] = { g, h, a };
S sXZlX[] = { 97, 99, h, 97, 0 };
S sXmkl[] = { 97, i, g, h, 0 };
S smklg[] = { i, g, h, a };
S sXmvg[] = { 97, i, r, a };
S sle9[] = { h, 233, 0 };
S sYiX[] = { 98, e, 97, 0 };
S smhlg[] = { i, d, h, a };
S swiX[] = { s, e, 97, 0 };
S siXk[] = { e, 97, g, 0 };
S sgql[] = { 32, m, h, 0 };
S sgYlj[] = { 32, 98, h, f, 0 };
S sxiX[] = { t, e, 97, 0 };
S siXrg[] = { e, 97, n, a };
S smpi[] = { i, l, e, 0 };
S sXkX[] = { 97, g, 97, 0 };
S smhg[] = { i, d, a };
S sZly[] = { 99, h, u, 0 };
S sYlj[] = { 98, h, f, 0 };
S symp[] = { u, i, l, 0 };
S smhl[] = { i, d, h, 0 };
S sgZly[] = { 32, 99, h, u, 0 };
S sfam[] = { 250, i, 0 };
S smpig[] = { i, l, e, a };
S sgYiX[] = { 32, 98, e, 97, 0 };
S se9Xr[] = { 233, 97, n, 0 };
S sqlX[] = { m, h, 97, 0 };
S sXmp[] = { 97, i, l, 0 };
S sqe9g[] = { m, 233, a };
S sYli[] = { 98, h, e, 0 };
S sliXr[] = { h, e, 97, n, 0 };
S sf3w[] = { 243, s, 0 };
S sgwed[] = { 32, s, 237, 0 };
S sgqe9g[] = { 32, m, 233, a };
S sgredg[] = { 32, n, 237, a };
S sXhl[] = { 97, d, h, 0 };
S sjXm[] = { f, 97, i, 0 };
S swedg[] = { s, 237, a };
S shiX[] = { d, e, 97, 0 };
S sgYli[] = { 32, 98, h, e, 0 };
S sgwedg[] = { 32, s, 237, a };
S sXhlg[] = { 97, d, h, a };
S shim[] = { d, e, i, 0 };
S sghim[] = { 32, d, e, i, 0 };
S spim[] = { l, e, i, 0 };
S sgpim[] = { 32, l, e, i, 0 };
S shimv[] = { d, e, i, r, 0 };
S swiXr[] = { s, e, 97, n, 0 };
S slym[] = { h, u, i, 0 };
S sgXq[] = { 32, 97, m, 0 };
S slf3[] = { h, 243, 0 };
S sRmh[] = { 225, i, d, 0 };
S swis[] = { s, e, o, 0 };
S siXrr[] = { e, 97, n, n, 0 };
S slyX[] = { h, u, 97, 0 };
S sgmrX[] = { 32, i, n, 97, 0 };
S sgXkX[] = { 32, 97, g, 97, 0 };
S symh[] = { u, i, d, 0 };
S ssmw[] = { o, i, s, 0 };
S slXmv[] = { h, 97, i, r, 0 };
S sgZls[] = { 32, 99, h, o, 0 };
S simw[] = { e, i, s, 0 };
S srXZ[] = { n, 97, 99, 0 };
S sRmp[] = { 225, i, l, 0 };
S sXed[] = { 97, 237, 0 };
S sZlXg[] = { 99, h, 97, a };
S syXm[] = { u, 97, i, 0 };
S syed[] = { u, 237, 0 };
S smZg[] = { i, 99, a };
S stl[] = { p, h, 0 };
S sYliX[] = { 98, h, e, 97, 0 };
S sf3wx[] = { 243, s, t, 0 };
S ssZl[] = { o, 99, h, 0 };
S sXmhl[] = { 97, i, d, h, 0 };
S smrX[] = { i, n, 97, 0 };
S se9Xp[] = { 233, 97, l, 0 };
S sxlXm[] = { t, h, 97, i, 0 };
S smrXg[] = { i, n, 97, a };
S symhg[] = { u, i, d, a };
S siXvg[] = { e, 97, r, a };
S sXvvX[] = { 97, r, r, 97, 0 };
S sgpR[] = { 32, l, 225, 0 };
S sXxl[] = { 97, t, h, 0 };
S sZe9[] = { 99, 233, 0 };
S syedg[] = { u, 237, a };
S sxiXZ[] = { t, e, 97, 99, 0 };
S svvX[] = { r, r, 97, 0 };
S srXZl[] = { n, 97, 99, h, 0 };
S sxfa[] = { t, 250, 0 };
S sympg[] = { u, i, l, a };
S sgwiX[] = { 32, s, e, 97, 0 };
S spimw[] = { l, e, i, s, 0 };
S sisg[] = { e, o, a };
S sghfa[] = { 32, d, 250, 0 };
S sYlg[] = { 98, h, a };
S sgf3w[] = { 32, 243, s, 0 };
S sle9X[] = { h, 233, 97, 0 };
S sedrg[] = { 237, n, a };
S swisg[] = { s, e, o, a };
S skXm[] = { g, 97, i, 0 };
S shed[] = { d, 237, 0 };
S sjym[] = { f, u, i, 0 };
S sgXZy[] = { 32, 97, 99, u, 0 };
S sveds[] = { r, 237, o, 0 };
S sgtl[] = { 32, p, h, 0 };
S sZyg[] = { 99, u, a };
S sRmr[] = { 225, i, n, 0 };
S sxlXv[] = { t, h, 97, r, 0 };
S sljy[] = { h, f, u, 0 };
S sYiXk[] = { 98, e, 97, g, 0 };
S svxl[] = { r, t, h, 0 };
S spsm[] = { l, o, i, 0 };
S sgpRg[] = { 32, l, 225, a };
S se9Xpg[] = { 233, 97, l, a };
S sge9g[] = { 32, 233, a };

N l23n0[] = { { srrg, .626 }, { sgXq, .231 }, H };
N l23n1[] = { { stX, .102 }, H };
N l23n3[] = { { ssv, .161 }, { sgf3, .241 }, H };
N l23n4[] = { { shl, .381 }, { sXmh, .241 }, { ssZ, .117 }, { srXZ, .132 }, H };
N l23n5[] = { { smr, .820 }, { sxm, .190 }, { spR, .132 }, H };
N l23n6[] = { { smkl, .307 }, { srx, .132 }, { sgwm, .231 }, H };
N l23n7[] = { { sri, .132 }, { sghm, .198 }, H };
N l23n9[] = { { slX, .644 }, { sgYli, .307 }, H };
N l23n10[] = { { swedg, .231 }, H };
N l23n11[] = { { sgXr, 1.482 }, H };
N l23n12[] = { { sgp, .856 }, { slRm, .263 }, { sgYlj, .395 }, { sgxl, .263 }, { sqe9g, .263 }, { sf3wx, .296 }, H };
N l23n13[] = { { sXr, 1.273 }, { swg, 1.317 }, { spm, .132 }, H };
N l23n15[] = { { sred, .220 }, { sji, .088 }, H };
N l23n16[] = { { sZlX, .241 }, { sf3w, .263 }, H };
N l23n17[] = { { sle9, .146 }, H };
N l23n18[] = { { seds, .428 }, { sgwedg, .307 }, H };
N l23n20[] = { { ssw, .088 }, H };
N l23n21[] = { { shm, .117 }, { sxiXZ, .176 }, H };
N l23n22[] = { { sms, .132 }, { sghim, .307 }, H };
N l23n23[] = { { sgxm, .263 }, { swiXr, .205 }, { sgpRg, .220 }, H };
N l23n25[] = { { siXk, .198 }, H };
N l23n26[] = { { simv, .154 }, H };
N l23n27[] = { { sql, .439 }, H };
N l23n29[] = { { sgq, 1.142 }, { sgXky, .790 }, { sZg, .285 }, { sYli, .176 }, H };
N l23n30[] = { { sgXkg, .615 }, { sgjl, .395 }, { sXs, .073 }, H };
N l23n31[] = { { sxlX, .351 }, { syXm, .132 }, { sjy, .073 }, H };
N l23n32[] = { { sgqe9, .263 }, H };
N l23n33[] = { { sxig, .231 }, H };
N l23n34[] = { { sZyg, .165 }, H };
N l23n35[] = { { srXg, .494 }, H };
N l23n36[] = { { sym, .322 }, { sgqy, .231 }, H };
N l23n37[] = { { siXZl, .410 }, { sXmk, .241 }, { simw, .132 }, H };
N l23n38[] = { { sYlg, .165 }, H };
N l23n39[] = { { sXrrg, .571 }, H };
N l23n40[] = { { smX, .220 }, { sYlj, .198 }, { sympg, .263 }, H };
N l23n41[] = { { spig, .461 }, { srk, .176 }, H };
N l23n42[] = { { sXZlg, 1.142 }, { slv, .117 }, H };
N l23n44[] = { { sxg, .615 }, H };
N l23n45[] = { { svs, .073 }, H };
N l23n46[] = { { sgr, .659 }, { sywg, .593 }, H };
N l23n47[] = { { skyw, .395 }, H };
N l23n48[] = { { se9m, .494 }, { smrX, .132 }, { simx, .110 }, H };
N l23n51[] = { { smhlg, .395 }, H };
N l23n52[] = { { spg, .812 }, { sim, .351 }, H };
N l23n55[] = { { sgXv, .823 }, { sXvv, .132 }, H };
N l23n56[] = { { sRm, .790 }, { sksg, .494 }, { sXrX, .154 }, { sgZls, .263 }, H };
N l23n57[] = { { sgmg, .198 }, H };
N l23n58[] = { { smpi, .198 }, H };
N l23n59[] = { { sXhlg, .307 }, H };
N l23n60[] = { { shg, .461 }, { sXmhl, .176 }, { srXZl, .176 }, { sle9X, .110 }, { sZli, .110 }, H };
N l23n61[] = { { sYs, .073 }, H };
N l23n62[] = { { sky, .307 }, H };
N l23n63[] = { { svX, .337 }, { sgxR, .395 }, { sgs, .198 }, { sfam, .263 }, H };
N l23n64[] = { { spp, .117 }, { sYliX, .176 }, H };
N l23n65[] = { { sZlxg, .263 }, H };
N l23n66[] = { { sjl, .190 }, { sghfa, .165 }, { sgXw, .165 }, H };
N l23n67[] = { { smpg, .494 }, { smxlg, .483 }, H };
N l23n69[] = { { sZlg, .889 }, H };
N l23n70[] = { { sqlX, .176 }, H };
N l23n72[] = { { sgqX, .329 }, { sgYv, .198 }, { syedg, .198 }, H };
N l23n73[] = { { smv, .644 }, H };
N l23n74[] = { { sgZly, .395 }, { smZ, .117 }, H };
N l23n75[] = { { sXpg, .329 }, { syg, .110 }, H };
N l23n76[] = { { slx, .132 }, { spim, .154 }, { se9Xp, .296 }, H };
N l23n77[] = { { sli, .337 }, { sXvx, .220 }, { sgXx, .198 }, H };
N l23n78[] = { { sjXm, .154 }, H };
N l23n79[] = { { sYX, .102 }, H };
N l23n80[] = { { sgt, .461 }, { sveds, .110 }, H };
N l23n81[] = { { sgX, 4.347 }, { sXv, .864 }, H };
N l23n82[] = { { sXZ, .717 }, H };
N l23n83[] = { { sqg, .285 }, H };
N l23n84[] = { { sxlg, .395 }, { shim, .154 }, { srkX, .110 }, H };
N l23n85[] = { { sled, .220 }, { sYledg, .615 }, H };
N l23n86[] = { { smwx, .176 }, H };
N l23n87[] = { { se9g, 1.877 }, H };
N l23n89[] = { { sge9, .263 }, { sgrX, .263 }, H };
N l23n90[] = { { smw, .483 }, { sxlXm, .176 }, { sXvvX, .176 }, H };
N l23n91[] = { { sig, .812 }, { smh, .468 }, { ssmw, .132 }, H };
N l23n92[] = { { sXmp, .176 }, H };
N l23n93[] = { { sly, .278 }, { sxRg, .494 }, { sgred, .494 }, { sXmkl, .293 }, H };
N l23n94[] = { { swX, .263 }, { slj, .146 }, H };
N l23n95[] = { { sRg, 1.284 }, H };
N l23n96[] = { { svv, .088 }, H };
N l23n97[] = { { skl, .220 }, { sedrg, .370 }, H };
N l23n98[] = { { sgY, 1.427 }, { sXw, .293 }, { se9Xr, .395 }, H };
N l23n99[] = { { sgpi, .790 }, { sXh, .220 }, { ssvg, .165 }, H };
N l23n100[] = { { shlg, .527 }, H };
N l23n101[] = { { smrg, .593 }, { sljy, .110 }, H };
N l23n102[] = { { swe9, .366 }, { siXr, .483 }, { smklg, .439 }, { sfag, .346 }, H };
N l23n103[] = { { swis, .154 }, H };
N l23n105[] = { { slXg, .362 }, H };
N l23n106[] = { { ssm, .278 }, H };
N l23n107[] = { { sgXrg, 1.668 }, { smx, .381 }, H };
N l23n109[] = { { sXrg, 1.778 }, { skXm, .110 }, H };
N l23n110[] = { { sZX, .146 }, H };
N l23n111[] = { { sredg, .231 }, H };
N l23n112[] = { { symh, .132 }, { sYv, .088 }, { sZlXg, .263 }, H };
N l23n114[] = { { srg, 2.569 }, { sgv, .241 }, { sXmr, .220 }, { smrk, .154 }, H };
N l23n115[] = { { sgZ, 1.251 }, { sXx, .220 }, { sps, .073 }, H };
N l23n116[] = { { sXql, .307 }, H };
N l23n117[] = { { sxlXv, .146 }, H };
N l23n118[] = { { sZe9, .088 }, H };
N l23n120[] = { { sliX, .285 }, { stl, .088 }, H };
N l23n122[] = { { simvg, .307 }, H };
N l23n123[] = { { sqlg, .428 }, H };
N l23n124[] = { { sgks, .494 }, { sXed, .088 }, { ssZl, .132 }, H };
N l23n125[] = { { sxX, .322 }, H };
N l23n127[] = { { sxlXg, .220 }, H };
N l23n128[] = { { swZ, .161 }, { sgqe9g, .351 }, H };
N l23n130[] = { { svx, .234 }, H };
N l23n131[] = { { sgw, 1.712 }, { svi, .205 }, H };
N l23n132[] = { { sgh, 1.120 }, { sRmh, .346 }, H };
N l23n133[] = { { spX, .205 }, { smwxi, .205 }, H };
N l23n134[] = { { sgwe9, .823 }, H };
N l23n136[] = { { slyX, .154 }, H };
N l23n137[] = { { slR, .234 }, { sir, .102 }, { srkg, .165 }, H };
N l23n139[] = { { sved, .190 }, { svvX, .132 }, H };
N l23n140[] = { { slXm, .417 }, H };
N l23n141[] = { { sRr, .362 }, { shX, .088 }, H };
N l23n142[] = { { smk, .307 }, H };
N l23n143[] = { { skywg, .790 }, H };
N l23n144[] = { { smrXg, .263 }, H };
N l23n145[] = { { ssg, .571 }, { slm, .176 }, H };
N l23n146[] = { { sgXZ, .527 }, { siXv, .307 }, { sqs, .088 }, H };
N l23n147[] = { { sYi, .146 }, { sgmr, .329 }, H };
N l23n148[] = { { sgx, 1.273 }, H };
N l23n149[] = { { sgql, .296 }, { sgi, .110 }, H };
N l23n150[] = { { sXk, .703 }, H };
N l23n151[] = { { sgXvg, .790 }, H };
N l23n153[] = { { skg, .768 }, H };
N l23n154[] = { { sis, .190 }, { smpig, .351 }, H };
N l23n156[] = { { syX, .249 }, H };
N l23n157[] = { { sXky, .395 }, { ssp, .102 }, H };
N l23n158[] = { { sXmv, .263 }, { sgpim, .307 }, { sxv, .088 }, H };
N l23n159[] = { { sgxRg, .527 }, { svXg, .263 }, H };
N l23n160[] = { { srr, .410 }, H };
N l23n161[] = { { swx, .263 }, { sgYled, .659 }, H };
N l23n162[] = { { swi, .293 }, { sjym, .110 }, H };
N l23n164[] = { { sqX, .220 }, H };
N l23n165[] = { { spimw, .146 }, H };
N l23n166[] = { { sgj, .768 }, { sxfa, .088 }, H };
N l23n168[] = { { se9X, .692 }, H };
N l23n169[] = { { smvg, .856 }, H };
N l23n170[] = { { swed, .117 }, { shimv, .205 }, { smZg, .198 }, { sZls, .132 }, H };
N l23n172[] = { { siX, 1.098 }, { sqe9, .117 }, { slxg, .198 }, { se9Xpg, .494 }, H };
N l23n174[] = { { ssq, .146 }, { sviX, .198 }, { sgwX, .231 }, { shv, .088 }, H };
N l23n176[] = { { siXrr, .205 }, H };
N l23n177[] = { { sgXg, 1.581 }, { sXvg, 1.054 }, H };
N l23n178[] = { { sgwed, .263 }, { sZi, .088 }, H };
N l23n180[] = { { sXmx, .307 }, H };
N l23n181[] = { { sledg, .461 }, H };
N l23n182[] = { { sgmrX, .263 }, H };
N l23n183[] = { { sgk, .637 }, { sgpR, .198 }, H };
N l23n184[] = { { slg, 1.822 }, { sXm, 1.142 }, H };
N l23n185[] = { { sgYi, .263 }, { sge9g, .165 }, H };
N l23n186[] = { { smwg, .560 }, H };
N l23n187[] = { { smhg, .296 }, { slf3, .102 }, H };
N l23n189[] = { { sgredg, .307 }, H };
N l23n190[] = { { sgXk, 1.251 }, { swXg, .329 }, { sYiX, .198 }, H };
N l23n191[] = { { smrr, .263 }, { sgxX, .329 }, { ssr, .117 }, H };
N l23n193[] = { { sxi, .293 }, { sklg, .329 }, { sXkX, .198 }, H };
N l23n194[] = { { sXwg, .395 }, { svXm, .241 }, { sZy, .132 }, { sliXr, .234 }, H };
N l23n195[] = { { srX, .468 }, { sgpig, .263 }, H };
N l23n196[] = { { sgwZ, .231 }, H };
N l23n198[] = { { sYl, .732 }, { swe9g, .790 }, { siXrg, .395 }, H };
N l23n199[] = { { sXrr, .329 }, { svm, .117 }, { swisg, .220 }, H };
N l23n200[] = { { symp, .198 }, { spx, .102 }, { sgtl, .165 }, H };
N l23n201[] = { { spi, .498 }, H };
N l23n202[] = { { sXZl, .900 }, { sgXZl, .483 }, { sgmw, .296 }, H };
N l23n203[] = { { sjX, .205 }, { smxg, .198 }, H };
N l23n205[] = { { swiX, .198 }, H };
N l23n206[] = { { syw, .307 }, H };
N l23n208[] = { { symhg, .263 }, H };
N l23n209[] = { { shi, .278 }, { sgjX, .263 }, { sgR, .132 }, H };
N l23n211[] = { { sedg, 2.519 }, { smhl, .198 }, { sXxg, .165 }, H };
N l23n212[] = { { sXqlg, .439 }, { sgXm, .231 }, H };
N l23n213[] = { { swl, .088 }, H };
N l23n215[] = { { smg, .351 }, H };
N l23n216[] = { { sks, .234 }, H };
N l23n217[] = { { sgm, .703 }, { shed, .073 }, H };
N l23n218[] = { { sgYl, 1.251 }, { sgwi, .395 }, H };
N l23n219[] = { { sghi, .395 }, { sXhl, .154 }, H };
N l23n220[] = { { sgksg, .615 }, { sgYiX, .351 }, { sRmp, .296 }, H };
N l23n221[] = { { sxXg, .329 }, H };
N l23n223[] = { { sXg, 2.656 }, H };
N l23n224[] = { { slym, .154 }, H };
N l23n225[] = { { sZlx, .154 }, { sgXkX, .263 }, H };
N l23n226[] = { { svxg, .231 }, { slXmv, .176 }, H };
N l23n227[] = { { smp, .483 }, { smxl, .395 }, H };
N l23n229[] = { { sZl, 1.127 }, H };
N l23n230[] = { { sgwe9g, 1.054 }, { swm, .117 }, H };
N l23n232[] = { { syed, .088 }, H };
N l23n234[] = { { skX, .263 }, H };
N l23n235[] = { { sgZl, .922 }, { sXp, .337 }, { sXxl, .132 }, H };
N l23n236[] = { { sXmxl, .322 }, { sxiX, .198 }, { sZly, .198 }, H };
N l23n237[] = { { siXZ, .307 }, { sXZlX, .293 }, { sRrg, .667 }, H };
N l23n238[] = { { svg, 1.559 }, { smkg, .198 }, H };
N l23n239[] = { { slXv, .198 }, H };
N l23n241[] = { { sgXZy, .220 }, H };
N l23n242[] = { { siXvg, .263 }, { sRmr, .247 }, H };
N l23n243[] = { { ssY, .088 }, { sYiXk, .146 }, H };
N l23n244[] = { { sxl, .659 }, { smq, .132 }, { sgf3w, .165 }, H };
N l23n245[] = { { sYled, .329 }, { srw, .088 }, H };
N l23n246[] = { { sXkg, .626 }, { sXkyw, .527 }, { spsm, .110 }, H };
N l23n247[] = { { sls, .176 }, H };
N l23n248[] = { { sqy, .117 }, { swxi, .154 }, H };
N l23n250[] = { { sisg, .165 }, { svxl, .110 }, H };
N l23n252[] = { { sXq, .351 }, { sghl, .329 }, { shiX, .154 }, H };
N l23n253[] = { { sxR, .220 }, { sgwiX, .263 }, H };
N l23n254[] = { { sXmvg, .439 }, { sXrw, .110 }, H };

D l23_d = {
	"irish",
	"iso-8859-1",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.004, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, 0.002, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.326, 0.051, 0.085, 0.066, 0.100, 0.034, 0.071, 0.160, 0.181, 0.001, W, 0.083, 0.059, 0.145, 0.069,
	    0.019, W, 0.111, 0.109, 0.100, 0.050, W, 0.001, W, 0.004, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, 0.004, V, V, V, 0.003, V, V,
	    V, V, V, 0.001, V, V, V, V, V, V, 0.001, V, V, V, V, V,
	    V, 0.096, V, V, V, V, V, V, V, 0.100, V, V, V, 0.104, V, V,
	    V, V, V, 0.040, V, V, V, V, V, V, 0.030, V, V, V, V, V },
	{ l23n0, l23n1, X, l23n3, l23n4, l23n5, l23n6, l23n7, X, l23n9, l23n10, l23n11, l23n12, l23n13, X, l23n15,
	    l23n16, l23n17, l23n18, X, l23n20, l23n21, l23n22, l23n23, X, l23n25, l23n26, l23n27, X, l23n29, l23n30, l23n31,
	    l23n32, l23n33, l23n34, l23n35, l23n36, l23n37, l23n38, l23n39, l23n40, l23n41, l23n42, X, l23n44, l23n45, l23n46, l23n47,
	    l23n48, X, X, l23n51, l23n52, X, X, l23n55, l23n56, l23n57, l23n58, l23n59, l23n60, l23n61, l23n62, l23n63,
	    l23n64, l23n65, l23n66, l23n67, X, l23n69, l23n70, X, l23n72, l23n73, l23n74, l23n75, l23n76, l23n77, l23n78, l23n79,
	    l23n80, l23n81, l23n82, l23n83, l23n84, l23n85, l23n86, l23n87, X, l23n89, l23n90, l23n91, l23n92, l23n93, l23n94, l23n95,
	    l23n96, l23n97, l23n98, l23n99, l23n100, l23n101, l23n102, l23n103, X, l23n105, l23n106, l23n107, X, l23n109, l23n110, l23n111,
	    l23n112, X, l23n114, l23n115, l23n116, l23n117, l23n118, X, l23n120, X, l23n122, l23n123, l23n124, l23n125, X, l23n127,
	    l23n128, X, l23n130, l23n131, l23n132, l23n133, l23n134, X, l23n136, l23n137, X, l23n139, l23n140, l23n141, l23n142, l23n143,
	    l23n144, l23n145, l23n146, l23n147, l23n148, l23n149, l23n150, l23n151, X, l23n153, l23n154, X, l23n156, l23n157, l23n158, l23n159,
	    l23n160, l23n161, l23n162, X, l23n164, l23n165, l23n166, X, l23n168, l23n169, l23n170, X, l23n172, X, l23n174, X,
	    l23n176, l23n177, l23n178, X, l23n180, l23n181, l23n182, l23n183, l23n184, l23n185, l23n186, l23n187, X, l23n189, l23n190, l23n191,
	    X, l23n193, l23n194, l23n195, l23n196, X, l23n198, l23n199, l23n200, l23n201, l23n202, l23n203, X, l23n205, l23n206, X,
	    l23n208, l23n209, X, l23n211, l23n212, l23n213, X, l23n215, l23n216, l23n217, l23n218, l23n219, l23n220, l23n221, X, l23n223,
	    l23n224, l23n225, l23n226, l23n227, X, l23n229, l23n230, X, l23n232, X, l23n234, l23n235, l23n236, l23n237, l23n238, l23n239,
	    X, l23n241, l23n242, l23n243, l23n244, l23n245, l23n246, l23n247, l23n248, X, l23n250, X, l23n252, l23n253, l23n254, X }
};

//
// Lng: italian
// Enc: iso-8859-15
//

S sZZ[] = { 99, 99, 0 };
S skpm[] = { g, l, i, 0 };
S sgZli[] = { 32, 99, h, e, 0 };
S sghmg[] = { 32, d, i, a };
S shmg[] = { d, i, a };
S sZlm[] = { 99, h, i, 0 };
S sxxs[] = { t, t, o, 0 };
S sizX[] = { e, v, 97, 0 };
S sXzXg[] = { 97, v, 97, a };
S sivXg[] = { e, r, 97, a };
S stivg[] = { p, e, r, a };
S sXrsg[] = { 97, n, o, a };
S sXvig[] = { 97, r, e, a };
S skpmg[] = { g, l, i, a };
S sguyX[] = { 32, q, u, 97, 0 };
S sgrsr[] = { 32, n, o, n, 0 };
S srsr[] = { n, o, n, 0 };
S sgwmg[] = { 32, s, i, a };
S suyX[] = { q, u, 97, 0 };
S sxxsg[] = { t, t, o, a };
S sizXg[] = { e, v, 97, a };
S sZsp[] = { 99, o, l, 0 };
S sgkpm[] = { 32, g, l, i, 0 };
S srsrg[] = { n, o, n, a };
S ssqi[] = { o, m, e, 0 };
S sgZXw[] = { 32, 99, 97, s, 0 };
S sZXw[] = { 99, 97, s, 0 };
S sgZsp[] = { 32, 99, o, l, 0 };
S sZZl[] = { 99, 99, h, 0 };
S sXZZ[] = { 97, 99, 99, 0 };
S shh[] = { d, d, 0 };
S sgvm[] = { 32, r, i, 0 };
S sgXpp[] = { 32, 97, l, l, 0 };
S sXwXg[] = { 97, s, 97, a };
S sZZlm[] = { 99, 99, h, i, 0 };
S sXwX[] = { 97, s, 97, 0 };
S sZXwX[] = { 99, 97, s, 97, 0 };
S sXxs[] = { 97, t, o, 0 };
S shipp[] = { d, e, l, l, 0 };
S ssqig[] = { o, m, e, a };
S srhsg[] = { n, d, o, a };
S syvm[] = { u, r, i, 0 };
S sZsqi[] = { 99, o, m, e, 0 };
S sjXv[] = { f, 97, r, 0 };
S sXrhs[] = { 97, n, d, o, 0 };
S svmh[] = { r, i, d, 0 };
S sXxsg[] = { 97, t, o, a };
S sXpig[] = { 97, l, e, a };
S swwig[] = { s, s, e, a };
S ssvX[] = { o, r, 97, 0 };
S sgtm[] = { 32, p, i, 0 };
S szXrs[] = { v, 97, n, o, 0 };
S syip[] = { u, e, l, 0 };
S ssZZ[] = { o, 99, 99, 0 };
S smhh[] = { i, d, d, 0 };
S ssmg[] = { o, i, a };
S svmhh[] = { r, i, d, d, 0 };
S sZZs[] = { 99, 99, o, 0 };
S sr7a[] = { n, z, 0 };
S sgXzi[] = { 32, 97, v, e, 0 };
S sgps[] = { 32, l, o, 0 };
S sZsg[] = { 99, o, a };
S sZlmg[] = { 99, h, i, a };
S swsg[] = { s, o, a };
S s7amX[] = { z, i, 97, 0 };
S sgjXv[] = { 32, f, 97, r, 0 };
S sskp[] = { o, g, l, 0 };
S spps[] = { l, l, o, 0 };
S suyip[] = { q, u, e, l, 0 };
S sspX[] = { o, l, 97, 0 };
S sskpm[] = { o, g, l, i, 0 };
S shXz[] = { d, 97, v, 0 };
S sZspp[] = { 99, o, l, l, 0 };
S srxs[] = { n, t, o, 0 };
S sqtX[] = { m, p, 97, 0 };
S shXzX[] = { d, 97, v, 97, 0 };
S sgxyv[] = { 32, t, u, r, 0 };
S sxyvm[] = { t, u, r, i, 0 };
S sXppX[] = { 97, l, l, 97, 0 };
S sle9g[] = { h, 233, a };
S smhhy[] = { i, d, d, u, 0 };
S sZle9g[] = { 99, h, 233, a };
S szizX[] = { v, e, v, 97, 0 };
S syvmh[] = { u, r, i, d, 0 };
S swXr[] = { s, 97, n, 0 };
S sgtmfa[] = { 32, p, i, 250, 0 };
S smrs[] = { i, n, o, 0 };
S sgwXr[] = { 32, s, 97, n, 0 };
S shhy[] = { d, d, u, 0 };
S stmfa[] = { p, i, 250, 0 };
S sZZm[] = { 99, 99, i, 0 };
S sghmw[] = { 32, d, i, s, 0 };
S stmfag[] = { p, i, 250, a };
S syXrh[] = { u, 97, n, d, 0 };
S svvi[] = { r, r, e, 0 };
S sXziz[] = { 97, v, e, v, 0 };
S svmz[] = { r, i, v, 0 };
S sziz[] = { v, e, v, 0 };
S sXxx[] = { 97, t, t, 0 };
S shhyg[] = { d, d, u, a };
S syXr[] = { u, 97, n, 0 };
S suyXr[] = { q, u, 97, n, 0 };
S sixxs[] = { e, t, t, o, 0 };
S smfag[] = { i, 250, a };
S sivZ[] = { e, r, 99, 0 };

N l24n0[] = { { sZsp, .224 }, { stt, .075 }, H };
N l24n1[] = { { stX, .261 }, H };
N l24n2[] = { { swig, .644 }, H };
N l24n3[] = { { ssv, .435 }, H };
N l24n4[] = { { ssZ, .162 }, { syrXg, .299 }, H };
N l24n5[] = { { smr, .498 }, { sxm, .286 }, { ssqi, .205 }, { spps, .131 }, H };
N l24n6[] = { { srx, .311 }, { sgwm, .532 }, { smhhy, .149 }, { shmw, .112 }, H };
N l24n7[] = { { sghm, 1.175 }, { sri, .323 }, H };
N l24n8[] = { { sXvig, .522 }, { sZZl, .205 }, H };
N l24n9[] = { { sXrx, .149 }, H };
N l24n11[] = { { sipp, .448 }, { sZsq, .280 }, { sgXr, .252 }, H };
N l24n12[] = { { sgp, 1.026 }, H };
N l24n13[] = { { sXr, .709 }, { spm, .423 }, { sgzi, .336 }, H };
N l24n14[] = { { sivZ, .112 }, H };
N l24n15[] = { { suyip, .174 }, H };
N l24n17[] = { { srsg, .728 }, { siz, .224 }, { sziz, .112 }, H };
N l24n19[] = { { svmh, .168 }, { sZZm, .112 }, H };
N l24n20[] = { { ssw, .199 }, H };
N l24n21[] = { { shm, .572 }, { sgts, .168 }, H };
N l24n22[] = { { sms, .348 }, { sZsr, .149 }, H };
N l24n24[] = { { swXr, .112 }, H };
N l24n26[] = { { sgZli, .821 }, H };
N l24n27[] = { { szXg, .868 }, { srhsg, .373 }, H };
N l24n29[] = { { sgq, .933 }, H };
N l24n31[] = { { sghip, .746 }, { ssrg, .392 }, { sjy, .075 }, H };
N l24n32[] = { { sXzXg, .560 }, H };
N l24n33[] = { { sxig, .364 }, { srhX, .168 }, { sZmX, .131 }, H };
N l24n34[] = { { stv, .149 }, H };
N l24n35[] = { { srXg, .672 }, H };
N l24n36[] = { { sivi, .131 }, H };
N l24n37[] = { { ssx, .112 }, H };
N l24n39[] = { { sgjXv, .261 }, { sskpm, .174 }, { shhyg, .224 }, H };
N l24n40[] = { { smX, .522 }, { skpm, .466 }, H };
N l24n41[] = { { spig, .644 }, { sgjm, .168 }, H };
N l24n42[] = { { s27X, .187 }, H };
N l24n43[] = { { stiv, .354 }, H };
N l24n44[] = { { sqm, .162 }, H };
N l24n45[] = { { svs, .187 }, { sivg, .392 }, H };
N l24n46[] = { { sgr, .765 }, { sippX, .323 }, { ssvX, .149 }, H };
N l24n47[] = { { sXt, .100 }, H };
N l24n48[] = { { smrX, .149 }, H };
N l24n50[] = { { sXrsg, .522 }, H };
N l24n52[] = { { spg, .933 }, { szizX, .149 }, H };
N l24n54[] = { { sgtv, .224 }, H };
N l24n55[] = { { sgpX, .588 }, { s7aX, .087 }, H };
N l24n56[] = { { sgZs, 1.035 }, { sXxs, .187 }, { sixxs, .149 }, H };
N l24n57[] = { { sgzm, .448 }, { sgXpp, .373 }, { sgmg, .224 }, H };
N l24n58[] = { { sZsqi, .224 }, { sgwig, .299 }, H };
N l24n60[] = { { sZli, .429 }, { sizX, .280 }, H };
N l24n61[] = { { sgrsr, .485 }, H };
N l24n63[] = { { svX, .572 }, { sgs, .187 }, { svmhh, .199 }, H };
N l24n64[] = { { spp, .634 }, { syvm, .168 }, H };
N l24n65[] = { { sspp, .131 }, { shyg, .168 }, H };
N l24n66[] = { { sXpi, .187 }, H };
N l24n67[] = { { smpg, .700 }, { szm, .274 }, { sZZlm, .249 }, H };
N l24n68[] = { { sZspp, .174 }, H };
N l24n69[] = { { sti, .410 }, { ssZZ, .149 }, H };
N l24n70[] = { { swmg, .588 }, H };
N l24n71[] = { { swwig, .336 }, { stmfa, .112 }, H };
N l24n72[] = { { sgqX, .616 }, { sqig, .336 }, { ssk, .124 }, { sZle9g, .224 }, H };
N l24n73[] = { { sghs, .364 }, { smv, .100 }, H };
N l24n74[] = { { smZ, .187 }, H };
N l24n75[] = { { srm, .149 }, { syg, .168 }, H };
N l24n76[] = { { sws, .162 }, H };
N l24n77[] = { { sli, .286 }, { szsp, .112 }, H };
N l24n78[] = { { sXziz, .149 }, H };
N l24n79[] = { { sYX, .100 }, H };
N l24n80[] = { { sgt, 1.157 }, H };
N l24n81[] = { { sgX, 1.287 }, { sXv, .734 }, H };
N l24n82[] = { { sXZ, .174 }, H };
N l24n83[] = { { sjm, .137 }, H };
N l24n85[] = { { sZZs, .149 }, H };
N l24n86[] = { { syXr, .112 }, H };
N l24n87[] = { { se9g, .504 }, { syp, .137 }, H };
N l24n88[] = { { sivXg, .522 }, H };
N l24n89[] = { { sXrh, .336 }, { sgrX, .168 }, H };
N l24n90[] = { { smw, .224 }, H };
N l24n91[] = { { sig, 3.433 }, { smh, .149 }, { sgkp, .336 }, H };
N l24n92[] = { { sZs, .659 }, H };
N l24n93[] = { { swt, .087 }, H };
N l24n94[] = { { swX, .373 }, { sqXr, .187 }, H };
N l24n95[] = { { sgyr, .588 }, { sZXw, .205 }, { sRg, .252 }, H };
N l24n96[] = { { svv, .124 }, { sghmw, .224 }, H };
N l24n97[] = { { sgu, .429 }, { svZ, .087 }, H };
N l24n98[] = { { sXw, .373 }, { sgY, .429 }, H };
N l24n99[] = { { sXh, .174 }, { sgXz, .280 }, { sgpi, .252 }, H };
N l24n101[] = { { smrg, .392 }, { sxmg, .336 }, { ssqig, .373 }, H };
N l24n102[] = { { sgwmg, .485 }, H };
N l24n103[] = { { sip, .560 }, { sghmg, .821 }, { srig, .420 }, H };
N l24n104[] = { { sguy, .644 }, { sZlm, .299 }, H };
N l24n106[] = { { ssm, .112 }, H };
N l24n107[] = { { sxs, .547 }, { sppX, .560 }, { smx, .187 }, { srsr, .243 }, H };
N l24n108[] = { { smi, .199 }, { sr7a, .100 }, { syvmh, .149 }, H };
N l24n109[] = { { spmg, .420 }, H };
N l24n110[] = { { sZX, .423 }, { s27i, .087 }, H };
N l24n111[] = { { sXxx, .112 }, H };
N l24n113[] = { { sle9g, .168 }, H };
N l24n114[] = { { srg, .802 }, { sgv, .336 }, { skm, .087 }, H };
N l24n115[] = { { sgZ, 1.791 }, { sXx, .286 }, { sps, .274 }, H };
N l24n116[] = { { suy, .286 }, { sgqi, .252 }, H };
N l24n117[] = { { shmg, .616 }, { ship, .373 }, { szXr, .168 }, H };
N l24n118[] = { { smsg, .644 }, H };
N l24n120[] = { { siq, .087 }, H };
N l24n121[] = { { syr, .274 }, { stvi, .131 }, H };
N l24n123[] = { { shs, .460 }, { sgtX, .280 }, { sgzs, .280 }, { sgiv, .224 }, H };
N l24n124[] = { { sgZsp, .410 }, { sXrhX, .224 }, H };
N l24n125[] = { { sxX, .423 }, { sgmp, .700 }, H };
N l24n127[] = { { sgZsq, .560 }, { sgwx, .280 }, H };
N l24n128[] = { { swZ, .199 }, H };
N l24n130[] = { { sZXwX, .249 }, { sgyrX, .261 }, { svx, .075 }, { sgZsr, .224 }, { syXrh, .149 }, H };
N l24n131[] = { { sgw, 1.791 }, { svi, .634 }, H };
N l24n132[] = { { sgh, 1.735 }, { syip, .149 }, H };
N l24n133[] = { { spX, .808 }, { sxxs, .280 }, { sgri, .308 }, { sirx, .187 }, H };
N l24n136[] = { { smXg, .728 }, { skpmg, .522 }, { swiv, .149 }, H };
N l24n137[] = { { sir, .423 }, { stm, .137 }, H };
N l24n138[] = { { sgwy, .420 }, { sys, .149 }, H };
N l24n139[] = { { stivg, .522 }, { sguyX, .485 }, H };
N l24n141[] = { { shX, .398 }, { sXwX, .187 }, { sf3g, .378 }, { smz, .112 }, H };
N l24n142[] = { { smk, .137 }, H };
N l24n143[] = { { sXpp, .280 }, H };
N l24n144[] = { { sZZ, .361 }, { sww, .236 }, { smrXg, .224 }, H };
N l24n145[] = { { ssg, 2.799 }, { slm, .211 }, H };
N l24n146[] = { { sqs, .187 }, { sgXzi, .299 }, H };
N l24n147[] = { { sgmr, .448 }, { sYi, .149 }, { sXZZ, .205 }, H };
N l24n148[] = { { sgx, .336 }, H };
N l24n149[] = { { sgi, .709 }, { sXz, .473 }, H };
N l24n150[] = { { sgkpm, .448 }, H };
N l24n151[] = { { sgpXg, .634 }, { sguyi, .373 }, H };
N l24n152[] = { { sXxsg, .336 }, H };
N l24n155[] = { { sgxy, .308 }, H };
N l24n156[] = { { sZlig, .858 }, { syX, .199 }, { sizXg, .448 }, H };
N l24n157[] = { { ssp, .373 }, { sgXh, .196 }, H };
N l24n158[] = { { sgZX, .644 }, { sxv, .187 }, { sgivX, .299 }, H };
N l24n159[] = { { svXg, .672 }, { suyX, .243 }, { shXz, .131 }, H };
N l24n161[] = { { swx, .311 }, H };
N l24n162[] = { { swi, .535 }, { sXpig, .336 }, H };
N l24n163[] = { { sqt, .162 }, H };
N l24n164[] = { { sqX, .386 }, { syrX, .149 }, { svz, .087 }, H };
N l24n165[] = { { skp, .311 }, { sgy, .448 }, H };
N l24n166[] = { { sgj, .522 }, { sXrhs, .224 }, H };
N l24n167[] = { { sgti, .728 }, { smhh, .149 }, { stmfag, .224 }, H };
N l24n168[] = { { sXvi, .280 }, H };
N l24n169[] = { { szs, .249 }, H };
N l24n171[] = { { sp27, .211 }, H };
N l24n172[] = { { swsg, .196 }, H };
N l24n173[] = { { slig, .644 }, H };
N l24n174[] = { { ssq, .286 }, { sgwX, .308 }, H };
N l24n175[] = { { sghX, .308 }, H };
N l24n177[] = { { srs, .585 }, { sgXg, .420 }, { sjXv, .168 }, { smfag, .168 }, H };
N l24n178[] = { { swy, .187 }, { sZi, .149 }, { sXppX, .174 }, H };
N l24n182[] = { { sgz, .784 }, H };
N l24n183[] = { { sgk, .373 }, { sxyv, .131 }, { svvi, .112 }, H };
N l24n184[] = { { sXm, .075 }, H };
N l24n185[] = { { sgp27, .336 }, { shipp, .249 }, { sgYi, .252 }, { szir, .112 }, H };
N l24n187[] = { { szX, .535 }, { srhs, .261 }, H };
N l24n188[] = { { sZsg, .196 }, H };
N l24n189[] = { { syv, .162 }, H };
N l24n190[] = { { swXg, .420 }, H };
N l24n191[] = { { ssr, .448 }, { sgyrg, .485 }, { s7am, .124 }, H };
N l24n192[] = { { sxx, .323 }, { sXzX, .373 }, { shh, .137 }, H };
N l24n193[] = { { sxi, .261 }, { sgtmfa, .224 }, H };
N l24n194[] = { { szXrs, .199 }, { shXzX, .174 }, H };
N l24n195[] = { { srX, .435 }, { sgpig, .299 }, H };
N l24n196[] = { { sgwZ, .168 }, H };
N l24n199[] = { { svm, .647 }, { sipg, .448 }, { skr, .137 }, { shhy, .112 }, H };
N l24n200[] = { { sZlmg, .261 }, { sspX, .131 }, { sgl, .112 }, H };
N l24n201[] = { { spi, .373 }, { sxvX, .131 }, H };
N l24n202[] = { { ssmg, .224 }, { smrs, .112 }, H };
N l24n203[] = { { sxsg, 1.007 }, { sppXg, 1.045 }, { sjX, .174 }, { srsrg, .448 }, { suyi, .187 }, { srxs, .131 }, H };
N l24n204[] = { { swxX, .168 }, H };
N l24n205[] = { { siv, .734 }, H };
N l24n206[] = { { sqtX, .131 }, H };
N l24n207[] = { { siww, .168 }, H };
N l24n209[] = { { shi, .373 }, { sxy, .162 }, { sgjX, .308 }, { sgps, .224 }, H };
N l24n210[] = { { sXrs, .261 }, H };
N l24n211[] = { { spsg, .420 }, { sgtm, .224 }, H };
N l24n212[] = { { sXvm, .243 }, H };
N l24n213[] = { { shipg, .336 }, H };
N l24n214[] = { { sp27X, .205 }, H };
N l24n215[] = { { smg, 2.425 }, { sYm, .112 }, H };
N l24n217[] = { { sgm, .933 }, { syrg, .364 }, { svmz, .112 }, H };
N l24n218[] = { { sgwi, .672 }, H };
N l24n219[] = { { sghi, .672 }, { shsg, .364 }, { syxx, .131 }, H };
N l24n220[] = { { sgp27X, .336 }, H };
N l24n221[] = { { sgmpg, .933 }, { sxXg, .392 }, H };
N l24n222[] = { { siw, .224 }, H };
N l24n223[] = { { sXg, 4.478 }, { syx, .149 }, H };
N l24n224[] = { { syi, .149 }, { siri, .149 }, H };
N l24n225[] = { { shy, .075 }, H };
N l24n226[] = { { sgqs, .280 }, H };
N l24n227[] = { { svig, .979 }, { smp, .336 }, H };
N l24n229[] = { { spXg, 1.427 }, { sZl, .572 }, { sxxsg, .485 }, H };
N l24n230[] = { { swm, .398 }, H };
N l24n231[] = { { swwi, .224 }, { stXv, .168 }, H };
N l24n232[] = { { sqi, .286 }, H };
N l24n233[] = { { suyXr, .149 }, H };
N l24n234[] = { { s7amX, .131 }, H };
N l24n235[] = { { sXp, .473 }, { sgZl, .700 }, { sixx, .131 }, H };
N l24n236[] = { { sXzi, .205 }, { sskp, .131 }, H };
N l24n237[] = { { shXg, .336 }, { sXwXg, .373 }, H };
N l24n238[] = { { svg, .354 }, H };
N l24n239[] = { { six, .224 }, { sts, .211 }, H };
N l24n241[] = { { slmg, .224 }, { sgxyv, .261 }, H };
N l24n242[] = { { sxyvm, .174 }, H };
N l24n243[] = { { sgrs, .504 }, { sgmrg, .522 }, H };
N l24n245[] = { { sgig, .756 }, { sgXp, .448 }, { sgvm, .308 }, H };
N l24n246[] = { { srh, .323 }, { sZm, .274 }, H };
N l24n247[] = { { sgZXw, .410 }, H };
N l24n248[] = { { sivX, .317 }, { sgwXr, .224 }, H };
N l24n252[] = { { sXq, .124 }, H };
N l24n253[] = { { sgtiv, .709 }, H };
N l24n255[] = { { szi, .386 }, H };

D l24_d = {
	"italian",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, 0.001, 0.017, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.273, 0.021, 0.102, 0.086, 0.205, 0.020, 0.030, 0.028, 0.196, W, W, 0.142, 0.052, 0.123, 0.171,
	    0.052, 0.011, 0.122, 0.104, 0.092, 0.062, 0.060, W, W, W, 0.010, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, 0.007, V, V, V, V, V, V, V, 0.013, V, V, V, 0.002, V, V,
	    V, V, V, 0.010, V, V, V, V, V, V, 0.007, V, V, V, V, V },
	{ l24n0, l24n1, l24n2, l24n3, l24n4, l24n5, l24n6, l24n7, l24n8, l24n9, X, l24n11, l24n12, l24n13, l24n14, l24n15,
	    X, l24n17, X, l24n19, l24n20, l24n21, l24n22, X, l24n24, X, l24n26, l24n27, X, l24n29, X, l24n31,
	    l24n32, l24n33, l24n34, l24n35, l24n36, l24n37, X, l24n39, l24n40, l24n41, l24n42, l24n43, l24n44, l24n45, l24n46, l24n47,
	    l24n48, X, l24n50, X, l24n52, X, l24n54, l24n55, l24n56, l24n57, l24n58, X, l24n60, l24n61, X, l24n63,
	    l24n64, l24n65, l24n66, l24n67, l24n68, l24n69, l24n70, l24n71, l24n72, l24n73, l24n74, l24n75, l24n76, l24n77, l24n78, l24n79,
	    l24n80, l24n81, l24n82, l24n83, X, l24n85, l24n86, l24n87, l24n88, l24n89, l24n90, l24n91, l24n92, l24n93, l24n94, l24n95,
	    l24n96, l24n97, l24n98, l24n99, X, l24n101, l24n102, l24n103, l24n104, X, l24n106, l24n107, l24n108, l24n109, l24n110, l24n111,
	    X, l24n113, l24n114, l24n115, l24n116, l24n117, l24n118, X, l24n120, l24n121, X, l24n123, l24n124, l24n125, X, l24n127,
	    l24n128, X, l24n130, l24n131, l24n132, l24n133, X, X, l24n136, l24n137, l24n138, l24n139, X, l24n141, l24n142, l24n143,
	    l24n144, l24n145, l24n146, l24n147, l24n148, l24n149, l24n150, l24n151, l24n152, X, X, l24n155, l24n156, l24n157, l24n158, l24n159,
	    X, l24n161, l24n162, l24n163, l24n164, l24n165, l24n166, l24n167, l24n168, l24n169, X, l24n171, l24n172, l24n173, l24n174, l24n175,
	    X, l24n177, l24n178, X, X, X, l24n182, l24n183, l24n184, l24n185, X, l24n187, l24n188, l24n189, l24n190, l24n191,
	    l24n192, l24n193, l24n194, l24n195, l24n196, X, X, l24n199, l24n200, l24n201, l24n202, l24n203, l24n204, l24n205, l24n206, l24n207,
	    X, l24n209, l24n210, l24n211, l24n212, l24n213, l24n214, l24n215, X, l24n217, l24n218, l24n219, l24n220, l24n221, l24n222, l24n223,
	    l24n224, l24n225, l24n226, l24n227, X, l24n229, l24n230, l24n231, l24n232, l24n233, l24n234, l24n235, l24n236, l24n237, l24n238, l24n239,
	    X, l24n241, l24n242, l24n243, X, l24n245, l24n246, l24n247, l24n248, X, X, X, l24n252, l24n253, X, l24n255 }
};

//
// Lng: italian
// Enc: utf8
//

S sc3a9[] = { 195, 169, 0 };
S sc3a9g[] = { 195, 169, a };
S sc3b3[] = { 195, 179, 0 };
S sc3b3g[] = { 195, 179, a };
S smc3[] = { i, 195, 0 };
S stmc3[] = { p, i, 195, 0 };
S sc3a1g[] = { 195, 161, a };
S sc3a1[] = { 195, 161, 0 };
S sc3ba[] = { 195, 186, 0 };
S smc3ba[] = { i, 195, 186, 0 };
S slc3a9g[] = { h, 195, 169, a };
S smc3bag[] = { i, 195, 186, a };
S slc3a9[] = { h, 195, 169, 0 };
S stmc3ba[] = { p, i, 195, 186, 0 };
S sc3bag[] = { 195, 186, a };

N l25n0[] = { { sZsp, .222 }, { stt, .074 }, H };
N l25n1[] = { { stX, .259 }, H };
N l25n2[] = { { swig, .638 }, H };
N l25n3[] = { { ssv, .432 }, H };
N l25n4[] = { { ssZ, .160 }, { syrXg, .296 }, H };
N l25n5[] = { { smr, .493 }, { sxm, .284 }, { ssqi, .203 }, { spps, .129 }, H };
N l25n6[] = { { srx, .308 }, { sgwm, .527 }, { smhhy, .148 }, { shmw, .111 }, H };
N l25n7[] = { { sghm, 1.165 }, { sri, .321 }, H };
N l25n8[] = { { sXvig, .518 }, { sZZl, .203 }, { smc3bag, .222 }, H };
N l25n9[] = { { sXrx, .148 }, H };
N l25n11[] = { { sipp, .444 }, { sZsq, .277 }, { sgXr, .250 }, H };
N l25n12[] = { { sgp, 1.017 }, H };
N l25n13[] = { { sXr, .703 }, { spm, .419 }, { sgzi, .333 }, H };
N l25n15[] = { { suyip, .173 }, H };
N l25n17[] = { { srsg, .721 }, { siz, .222 }, { sziz, .111 }, H };
N l25n19[] = { { svmh, .166 }, { sZZm, .111 }, H };
N l25n20[] = { { ssw, .197 }, H };
N l25n21[] = { { shm, .567 }, { sgts, .166 }, H };
N l25n22[] = { { sms, .345 }, { sZsr, .148 }, H };
N l25n24[] = { { swXr, .111 }, { stmc3ba, .148 }, H };
N l25n26[] = { { sgZli, .814 }, H };
N l25n27[] = { { szXg, .860 }, { srhsg, .370 }, H };
N l25n29[] = { { sgq, .925 }, H };
N l25n31[] = { { sghip, .740 }, { ssrg, .388 }, { sjy, .074 }, H };
N l25n32[] = { { sXzXg, .555 }, H };
N l25n33[] = { { sxig, .361 }, { srhX, .166 }, { sZmX, .129 }, H };
N l25n34[] = { { stv, .148 }, H };
N l25n35[] = { { srXg, .666 }, H };
N l25n36[] = { { sivi, .129 }, H };
N l25n37[] = { { ssx, .111 }, H };
N l25n39[] = { { sgjXv, .259 }, { sskpm, .173 }, H };
N l25n40[] = { { smX, .518 }, { skpm, .462 }, H };
N l25n41[] = { { spig, .638 }, H };
N l25n42[] = { { s27X, .185 }, H };
N l25n43[] = { { stiv, .351 }, H };
N l25n44[] = { { sqm, .160 }, H };
N l25n45[] = { { svs, .185 }, { sivg, .388 }, H };
N l25n46[] = { { sgr, .758 }, { sippX, .321 }, { ssvX, .148 }, { slc3a9g, .222 }, H };
N l25n47[] = { { sXt, .099 }, H };
N l25n48[] = { { smrX, .148 }, H };
N l25n50[] = { { sXrsg, .518 }, H };
N l25n52[] = { { spg, .925 }, { szizX, .148 }, H };
N l25n54[] = { { sc3a9g, .749 }, { sgtv, .222 }, H };
N l25n55[] = { { sgpX, .583 }, { s7aX, .086 }, H };
N l25n56[] = { { sgZs, 1.027 }, { sXxs, .185 }, H };
N l25n57[] = { { sgzm, .444 }, { sgXpp, .370 }, { sgmg, .222 }, H };
N l25n58[] = { { sZsqi, .222 }, { sgwig, .296 }, H };
N l25n60[] = { { sZli, .425 }, { sizX, .277 }, H };
N l25n61[] = { { sgrsr, .481 }, H };
N l25n63[] = { { svX, .567 }, { sgs, .185 }, { svmhh, .197 }, H };
N l25n64[] = { { spp, .629 }, { syvm, .166 }, H };
N l25n65[] = { { sspp, .129 }, H };
N l25n66[] = { { sXpi, .185 }, H };
N l25n67[] = { { smpg, .694 }, { szm, .271 }, { sZZlm, .247 }, H };
N l25n68[] = { { sZspp, .173 }, H };
N l25n69[] = { { sti, .407 }, { ssZZ, .148 }, H };
N l25n70[] = { { swmg, .583 }, H };
N l25n71[] = { { swwig, .333 }, H };
N l25n72[] = { { sgqX, .610 }, { sqig, .333 }, { ssk, .123 }, H };
N l25n73[] = { { sghs, .361 }, { smv, .099 }, H };
N l25n74[] = { { smZ, .185 }, H };
N l25n75[] = { { srm, .148 }, { syg, .166 }, H };
N l25n76[] = { { sws, .160 }, H };
N l25n77[] = { { sli, .284 }, { szsp, .111 }, H };
N l25n78[] = { { sc3a1, .166 }, { sXziz, .148 }, H };
N l25n79[] = { { sYX, .099 }, H };
N l25n80[] = { { sgt, 1.147 }, H };
N l25n81[] = { { sgX, 1.276 }, { sXv, .727 }, H };
N l25n82[] = { { sXZ, .173 }, H };
N l25n83[] = { { sjm, .136 }, H };
N l25n85[] = { { sZZs, .148 }, H };
N l25n87[] = { { syp, .136 }, { sc3bag, .375 }, H };
N l25n88[] = { { sivXg, .518 }, H };
N l25n89[] = { { sXrh, .333 }, { sgrX, .166 }, H };
N l25n90[] = { { smw, .222 }, H };
N l25n91[] = { { sig, 3.403 }, { smh, .148 }, { sgkp, .333 }, H };
N l25n92[] = { { sZs, .654 }, H };
N l25n93[] = { { swt, .086 }, H };
N l25n94[] = { { swX, .370 }, { sqXr, .185 }, H };
N l25n95[] = { { sgyr, .583 }, { sZXw, .203 }, H };
N l25n96[] = { { svv, .123 }, { sghmw, .222 }, H };
N l25n97[] = { { sgu, .425 }, { svZ, .086 }, H };
N l25n98[] = { { sXw, .370 }, { sgY, .425 }, H };
N l25n99[] = { { sXh, .173 }, { sgXz, .277 }, { sgpi, .250 }, H };
N l25n101[] = { { smrg, .388 }, { sxmg, .333 }, { ssqig, .370 }, H };
N l25n102[] = { { sgwmg, .481 }, H };
N l25n103[] = { { sip, .555 }, { sghmg, .814 }, { srig, .416 }, H };
N l25n104[] = { { sguy, .638 }, { sZlm, .296 }, H };
N l25n106[] = { { ssm, .111 }, H };
N l25n107[] = { { sxs, .543 }, { sppX, .555 }, { smx, .185 }, { srsr, .240 }, H };
N l25n108[] = { { smi, .197 }, { sr7a, .099 }, { syvmh, .148 }, H };
N l25n109[] = { { spmg, .416 }, H };
N l25n110[] = { { sZX, .419 }, { s27i, .086 }, H };
N l25n114[] = { { srg, .795 }, { sgv, .333 }, { skm, .086 }, H };
N l25n115[] = { { sgZ, 1.776 }, { sXx, .284 }, { sps, .271 }, H };
N l25n116[] = { { suy, .284 }, { sgqi, .250 }, H };
N l25n117[] = { { shmg, .610 }, { ship, .370 }, { szXr, .166 }, H };
N l25n118[] = { { smsg, .638 }, H };
N l25n120[] = { { siq, .086 }, H };
N l25n121[] = { { syr, .271 }, { stvi, .129 }, H };
N l25n123[] = { { shs, .456 }, { sgtX, .277 }, { sgzs, .277 }, { sgiv, .222 }, H };
N l25n124[] = { { sgZsp, .407 }, { sXrhX, .222 }, H };
N l25n125[] = { { sxX, .419 }, { sgmp, .694 }, H };
N l25n127[] = { { sgZsq, .555 }, { sgwx, .277 }, H };
N l25n128[] = { { swZ, .197 }, { sc3b3, .250 }, H };
N l25n130[] = { { sZXwX, .247 }, { sgyrX, .259 }, { svx, .074 }, { sgZsr, .222 }, { syXrh, .148 }, H };
N l25n131[] = { { sgw, 1.776 }, { svi, .629 }, H };
N l25n132[] = { { sgh, 1.720 }, { syip, .148 }, H };
N l25n133[] = { { spX, .801 }, { sxxs, .277 }, { sgri, .305 }, { sirx, .185 }, H };
N l25n136[] = { { smXg, .721 }, { skpmg, .518 }, { swiv, .148 }, H };
N l25n137[] = { { sir, .419 }, { stm, .136 }, H };
N l25n138[] = { { sgwy, .416 }, { sys, .148 }, H };
N l25n139[] = { { stivg, .518 }, { sguyX, .481 }, H };
N l25n141[] = { { shX, .395 }, { sXwX, .185 }, { smz, .111 }, H };
N l25n142[] = { { smk, .136 }, H };
N l25n143[] = { { sXpp, .277 }, H };
N l25n144[] = { { sZZ, .358 }, { sww, .234 }, H };
N l25n145[] = { { ssg, 2.774 }, { slm, .210 }, H };
N l25n146[] = { { sqs, .185 }, { sgXzi, .296 }, H };
N l25n147[] = { { sgmr, .444 }, { sYi, .148 }, { sXZZ, .203 }, H };
N l25n148[] = { { sgx, .333 }, H };
N l25n149[] = { { sgi, .703 }, { sXz, .469 }, H };
N l25n150[] = { { sgkpm, .444 }, H };
N l25n151[] = { { sgpXg, .629 }, { sa9g, .333 }, { sguyi, .370 }, H };
N l25n152[] = { { sXxsg, .333 }, H };
N l25n155[] = { { sgxy, .305 }, H };
N l25n156[] = { { sZlig, .851 }, { syX, .197 }, { sizXg, .444 }, H };
N l25n157[] = { { ssp, .370 }, { sgXh, .194 }, H };
N l25n158[] = { { sgZX, .638 }, { sxv, .185 }, { sgivX, .296 }, H };
N l25n159[] = { { svXg, .666 }, { suyX, .240 }, { shXz, .129 }, { sa1g, .166 }, H };
N l25n161[] = { { swx, .308 }, H };
N l25n162[] = { { swi, .530 }, { sXpig, .333 }, H };
N l25n163[] = { { sqt, .160 }, H };
N l25n164[] = { { sqX, .382 }, { syrX, .148 }, { svz, .086 }, H };
N l25n165[] = { { skp, .308 }, { sgy, .444 }, H };
N l25n166[] = { { sgj, .518 }, { sXrhs, .222 }, { sbag, .166 }, H };
N l25n167[] = { { sgti, .721 }, { smhh, .148 }, H };
N l25n168[] = { { sXvi, .277 }, { smc3ba, .111 }, H };
N l25n169[] = { { szs, .247 }, H };
N l25n170[] = { { smc3, .086 }, H };
N l25n171[] = { { sp27, .210 }, H };
N l25n172[] = { { swsg, .194 }, H };
N l25n173[] = { { slig, .638 }, H };
N l25n174[] = { { ssq, .284 }, { sgwX, .305 }, { sc3a1g, .375 }, H };
N l25n175[] = { { sghX, .305 }, H };
N l25n177[] = { { srs, .580 }, { sgXg, .416 }, { sjXv, .166 }, H };
N l25n178[] = { { swy, .185 }, { sZi, .148 }, { sXppX, .173 }, H };
N l25n182[] = { { sgz, .777 }, H };
N l25n183[] = { { sgk, .370 }, { sxyv, .129 }, { svvi, .111 }, H };
N l25n184[] = { { sXm, .074 }, H };
N l25n185[] = { { sgp27, .333 }, { shipp, .247 }, { sgYi, .250 }, { szir, .111 }, H };
N l25n187[] = { { szX, .530 }, { srhs, .259 }, H };
N l25n188[] = { { sZsg, .194 }, H };
N l25n189[] = { { syv, .160 }, H };
N l25n190[] = { { swXg, .416 }, H };
N l25n191[] = { { ssr, .444 }, { sgyrg, .481 }, { s7am, .123 }, H };
N l25n192[] = { { sxx, .321 }, { sXzX, .370 }, { shh, .136 }, H };
N l25n193[] = { { sxi, .259 }, H };
N l25n194[] = { { szXrs, .197 }, { shXzX, .173 }, H };
N l25n195[] = { { srX, .432 }, { sgpig, .296 }, H };
N l25n196[] = { { sgwZ, .166 }, H };
N l25n199[] = { { svm, .641 }, { sipg, .444 }, { skr, .136 }, { shhy, .111 }, H };
N l25n200[] = { { sZlmg, .259 }, { sspX, .129 }, { sgl, .111 }, H };
N l25n201[] = { { spi, .370 }, { sxvX, .129 }, H };
N l25n202[] = { { ssmg, .222 }, { smrs, .111 }, H };
N l25n203[] = { { sxsg, .999 }, { sppXg, 1.036 }, { sjX, .173 }, { srsrg, .444 }, { suyi, .185 }, { srxs, .129 }, H };
N l25n204[] = { { swxX, .166 }, H };
N l25n205[] = { { siv, .727 }, { sb3g, .250 }, H };
N l25n206[] = { { sqtX, .129 }, { slc3a9, .111 }, H };
N l25n207[] = { { siww, .166 }, H };
N l25n209[] = { { shi, .370 }, { sxy, .160 }, { sgjX, .305 }, { sgps, .222 }, H };
N l25n210[] = { { sXrs, .259 }, H };
N l25n211[] = { { spsg, .416 }, { sgtm, .222 }, H };
N l25n212[] = { { sXvm, .240 }, H };
N l25n213[] = { { shipg, .333 }, H };
N l25n214[] = { { sc3a9, .333 }, { sp27X, .203 }, H };
N l25n215[] = { { smg, 2.404 }, { sYm, .111 }, H };
N l25n217[] = { { sgm, .925 }, { syrg, .361 }, { svmz, .111 }, H };
N l25n218[] = { { sgwi, .666 }, H };
N l25n219[] = { { sghi, .666 }, { shsg, .361 }, { syxx, .129 }, H };
N l25n220[] = { { sgp27X, .333 }, H };
N l25n221[] = { { sgmpg, .925 }, { sxXg, .388 }, H };
N l25n222[] = { { siw, .222 }, H };
N l25n223[] = { { sXg, 4.439 }, { syx, .148 }, H };
N l25n224[] = { { syi, .148 }, { sc3b3g, .562 }, { siri, .148 }, H };
N l25n226[] = { { sgqs, .277 }, H };
N l25n227[] = { { svig, .971 }, { smp, .333 }, H };
N l25n229[] = { { spXg, 1.415 }, { sZl, .567 }, { sxxsg, .481 }, H };
N l25n230[] = { { swm, .395 }, H };
N l25n231[] = { { swwi, .222 }, { stXv, .166 }, H };
N l25n232[] = { { sqi, .284 }, H };
N l25n234[] = { { s7amX, .129 }, { stmc3, .111 }, H };
N l25n235[] = { { sXp, .469 }, { sgZl, .694 }, { sixx, .129 }, H };
N l25n236[] = { { sXzi, .203 }, { sskp, .129 }, H };
N l25n237[] = { { shXg, .333 }, { sXwXg, .370 }, H };
N l25n238[] = { { svg, .351 }, H };
N l25n239[] = { { six, .222 }, { sts, .210 }, H };
N l25n241[] = { { slmg, .222 }, { sgxyv, .259 }, H };
N l25n242[] = { { sxyvm, .173 }, H };
N l25n243[] = { { sgrs, .499 }, { sgmrg, .518 }, H };
N l25n245[] = { { sgig, .749 }, { sgXp, .444 }, { sgvm, .305 }, H };
N l25n246[] = { { srh, .321 }, { sZm, .271 }, H };
N l25n247[] = { { sgZXw, .407 }, { sc3ba, .166 }, H };
N l25n248[] = { { sivX, .314 }, { sgwXr, .222 }, H };
N l25n252[] = { { sXq, .123 }, H };
N l25n253[] = { { sgtiv, .703 }, H };
N l25n255[] = { { szi, .382 }, H };

D l25_d = {
	"italian",
	"utf8",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, 0.001, 0.017, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.271, 0.021, 0.102, 0.085, 0.203, 0.020, 0.030, 0.028, 0.194, W, W, 0.141, 0.052, 0.122, 0.170,
	    0.052, 0.011, 0.121, 0.104, 0.091, 0.061, 0.060, W, W, W, 0.010, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.004, Y, Y, Y, Y, Y, Y, Y, 0.009, Y, Y, Y, 0.001, Y, Y,
	    Y, Y, Y, 0.007, Y, Y, Y, Y, Y, Y, 0.004, Y, Y, Y, Y, Y,
	    Y, V, V, 0.039, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l25n0, l25n1, l25n2, l25n3, l25n4, l25n5, l25n6, l25n7, l25n8, l25n9, X, l25n11, l25n12, l25n13, X, l25n15,
	    X, l25n17, X, l25n19, l25n20, l25n21, l25n22, X, l25n24, X, l25n26, l25n27, X, l25n29, X, l25n31,
	    l25n32, l25n33, l25n34, l25n35, l25n36, l25n37, X, l25n39, l25n40, l25n41, l25n42, l25n43, l25n44, l25n45, l25n46, l25n47,
	    l25n48, X, l25n50, X, l25n52, X, l25n54, l25n55, l25n56, l25n57, l25n58, X, l25n60, l25n61, X, l25n63,
	    l25n64, l25n65, l25n66, l25n67, l25n68, l25n69, l25n70, l25n71, l25n72, l25n73, l25n74, l25n75, l25n76, l25n77, l25n78, l25n79,
	    l25n80, l25n81, l25n82, l25n83, X, l25n85, X, l25n87, l25n88, l25n89, l25n90, l25n91, l25n92, l25n93, l25n94, l25n95,
	    l25n96, l25n97, l25n98, l25n99, X, l25n101, l25n102, l25n103, l25n104, X, l25n106, l25n107, l25n108, l25n109, l25n110, X,
	    X, X, l25n114, l25n115, l25n116, l25n117, l25n118, X, l25n120, l25n121, X, l25n123, l25n124, l25n125, X, l25n127,
	    l25n128, X, l25n130, l25n131, l25n132, l25n133, X, X, l25n136, l25n137, l25n138, l25n139, X, l25n141, l25n142, l25n143,
	    l25n144, l25n145, l25n146, l25n147, l25n148, l25n149, l25n150, l25n151, l25n152, X, X, l25n155, l25n156, l25n157, l25n158, l25n159,
	    X, l25n161, l25n162, l25n163, l25n164, l25n165, l25n166, l25n167, l25n168, l25n169, l25n170, l25n171, l25n172, l25n173, l25n174, l25n175,
	    X, l25n177, l25n178, X, X, X, l25n182, l25n183, l25n184, l25n185, X, l25n187, l25n188, l25n189, l25n190, l25n191,
	    l25n192, l25n193, l25n194, l25n195, l25n196, X, X, l25n199, l25n200, l25n201, l25n202, l25n203, l25n204, l25n205, l25n206, l25n207,
	    X, l25n209, l25n210, l25n211, l25n212, l25n213, l25n214, l25n215, X, l25n217, l25n218, l25n219, l25n220, l25n221, l25n222, l25n223,
	    l25n224, X, l25n226, l25n227, X, l25n229, l25n230, l25n231, l25n232, X, l25n234, l25n235, l25n236, l25n237, l25n238, l25n239,
	    X, l25n241, l25n242, l25n243, X, l25n245, l25n246, l25n247, l25n248, X, X, X, l25n252, l25n253, X, l25n255 }
};

//
// Lng: japanese
// Enc: euc_jp
//

S sa1bc[] = { 161, 188, 0 };
S sa4ce[] = { 164, 206, 0 };
S sbca5[] = { 188, 165, 0 };
S sa1bca5[] = { 161, 188, 165, 0 };
S sa4eb[] = { 164, 235, 0 };
S saca7[] = { 172, 167, 0 };
S sa4cb[] = { 164, 203, 0 };
S sbfae[] = { 191, 174, 0 };
S sa1a4[] = { 161, 164, 0 };
S sa5b9[] = { 165, 185, 0 };
S sa4cf[] = { 164, 207, 0 };
S seca4[] = { 236, 164, 0 };
S sa4ec[] = { 164, 236, 0 };
S seba1[] = { 235, 161, 0 };
S sa4eca4[] = { 164, 236, 164, 0 };
S sa5c3[] = { 165, 195, 0 };
S sc3a5[] = { 195, 165, 0 };
S sa5c3a5[] = { 165, 195, 165, 0 };
S sa1a5[] = { 161, 165, 0 };
S sa4c8[] = { 164, 200, 0 };
S sa4b7[] = { 164, 183, 0 };
S sa5b8[] = { 165, 184, 0 };
S sa4f2[] = { 164, 242, 0 };
S sa4c6[] = { 164, 198, 0 };
S sa4bf[] = { 164, 191, 0 };
S sc8a4[] = { 200, 164, 0 };
S sa4c7[] = { 164, 199, 0 };
S sa4ca[] = { 164, 202, 0 };
S sa4eba1[] = { 164, 235, 161, 0 };
S sc7a4[] = { 199, 164, 0 };
S sa4eba1a3[] = { 164, 235, 161, 163, 0 };
S seba1a3[] = { 235, 161, 163, 0 };
S sb5a1[] = { 181, 161, 0 };
S sa5f3[] = { 165, 243, 0 };
S seba1a3g[] = { 235, 161, 163, a };
S sa4b9[] = { 164, 185, 0 };
S sDa5[] = { 211, 165, 0 };
S sa4ac[] = { 164, 172, 0 };
S sa4b9a4[] = { 164, 185, 164, 0 };
S sa4b9a4eb[] = { 164, 185, 164, 235, 0 };
S sb9a4eb[] = { 185, 164, 235, 0 };
S sa4b5a4[] = { 164, 181, 164, 0 };
S sa5f3a5[] = { 165, 243, 165, 0 };
S sbcE[] = { 188, 212, 0 };
S sa4b7a4[] = { 164, 183, 164, 0 };
S sa4b5a4ec[] = { 164, 181, 164, 236, 0 };
S sb7a4[] = { 183, 164, 0 };
S sb5a4ec[] = { 181, 164, 236, 0 };
S sb5a4eca4[] = { 181, 164, 236, 164, 0 };
S sf3a5[] = { 243, 165, 0 };
S sa3cd[] = { 163, 205, 0 };
S sa4b5[] = { 164, 181, 0 };
S sb5a4[] = { 181, 164, 0 };
S sbca5b8[] = { 188, 165, 184, 0 };
S sa5bf[] = { 165, 191, 0 };
S sa5D[] = { 165, 211, 0 };
S sa1bca5b8[] = { 161, 188, 165, 184, 0 };
S sRa5[] = { 225, 165, 0 };
S se8a4[] = { 232, 164, 0 };
S saca7a3[] = { 172, 167, 163, 0 };
S sa5Da5[] = { 165, 211, 165, 0 };
S sa7a3[] = { 167, 163, 0 };
S sa5a3[] = { 165, 163, 0 };
S sEa4[] = { 212, 164, 0 };
S sa5Ra5[] = { 165, 225, 165, 0 };
S sa4a5[] = { 164, 165, 0 };
S sa5c8[] = { 165, 200, 0 };
S sa5R[] = { 165, 225, 0 };
S sbfa4[] = { 191, 164, 0 };
S scaa4[] = { 202, 164, 0 };
S sa5b5[] = { 165, 181, 0 };
S sa5bba1[] = { 165, 187, 161, 0 };
S sa5c3a5bb[] = { 165, 195, 165, 187, 0 };
S sa4c8a4[] = { 164, 200, 164, 0 };
S sRa5c3[] = { 225, 165, 195, 0 };
S sc3a5bba1[] = { 195, 165, 187, 161, 0 };
S sc3a5bb[] = { 195, 165, 187, 0 };
S sbba1bca5[] = { 187, 161, 188, 165, 0 };
S sa5Ra5c3[] = { 165, 225, 165, 195, 0 };
S sa5bba1bc[] = { 165, 187, 161, 188, 0 };
S sbba1[] = { 187, 161, 0 };
S sRa5c3a5[] = { 225, 165, 195, 165, 0 };
S sbba1bc[] = { 187, 161, 188, 0 };
S sb5a1bc[] = { 181, 161, 188, 0 };
S sbca5D[] = { 188, 165, 211, 0 };
S scba4[] = { 203, 164, 0 };
S sDa5b9[] = { 211, 165, 185, 0 };
S sb5a1bca5[] = { 181, 161, 188, 165, 0 };
S sa5af[] = { 165, 175, 0 };
S sbcEa4[] = { 188, 212, 164, 0 };
S sa4a4a4[] = { 164, 164, 164, 0 };
S sa4c7a4[] = { 164, 199, 164, 0 };
S sa1bca5D[] = { 161, 188, 165, 211, 0 };
S sa5b5a1[] = { 165, 181, 161, 0 };
S sa5Da5b9[] = { 165, 211, 165, 185, 0 };
S sbca5Da5[] = { 188, 165, 211, 165, 0 };
S sa5b5a1bc[] = { 165, 181, 161, 188, 0 };
S sa4eca4eb[] = { 164, 236, 164, 235, 0 };
S sa5a4a5[] = { 165, 164, 165, 0 };
S sa1a5g[] = { 161, 165, a };
S sa5a4[] = { 165, 164, 0 };
S sa3c1[] = { 163, 193, 0 };
S sa4bfa4[] = { 164, 191, 164, 0 };
S seca4eb[] = { 236, 164, 235, 0 };
S sa5eb[] = { 165, 235, 0 };
S sa4caa4[] = { 164, 202, 164, 0 };
S seba5[] = { 235, 165, 0 };
S sgaca7[] = { 32, 172, 167, 0 };
S sa3cda3[] = { 163, 205, 163, 0 };
S sa4e8a4[] = { 164, 232, 164, 0 };
S sa4cba4[] = { 164, 203, 164, 0 };
S scda3[] = { 205, 163, 0 };
S sa4e8[] = { 164, 232, 0 };
S sa5ea[] = { 165, 234, 0 };
S seba4[] = { 235, 164, 0 };
S sa4eba4[] = { 164, 235, 164, 0 };
S sf5bf[] = { 245, 191, 0 };
S sbcf5[] = { 188, 245, 0 };
S sbcf5bf[] = { 188, 245, 191, 0 };
S sbcf5bfae[] = { 188, 245, 191, 174, 0 };
S sc6a4[] = { 198, 164, 0 };
S sf5bfae[] = { 245, 191, 174, 0 };
S saca7g[] = { 172, 167, a };
S scdfd[] = { 205, 253, 0 };
S scdH[] = { 205, 215, 0 };
S sbfa5[] = { 191, 165, 0 };
S safa5[] = { 175, 165, 0 };
S scfa1[] = { 207, 161, 0 };
S sa5afa5[] = { 165, 175, 165, 0 };
S sc6a1[] = { 198, 161, 0 };
S sa4b3a4[] = { 164, 179, 164, 0 };
S sb8a4[] = { 184, 164, 0 };
S sc9bd[] = { 201, 189, 0 };
S sb9e7[] = { 185, 231, 0 };
S sa4b3[] = { 164, 179, 0 };
S sc6a5[] = { 198, 165, 0 };
S sa4c6a4[] = { 164, 198, 164, 0 };
S saebcE[] = { 174, 188, 212, 0 };
S sa5c6[] = { 165, 198, 0 };
S saea4[] = { 174, 164, 0 };
S sa2a4[] = { 162, 164, 0 };
S saebc[] = { 174, 188, 0 };
S sbfaebc[] = { 191, 174, 188, 0 };
S scea4[] = { 206, 164, 0 };
S sb8a5[] = { 184, 165, 0 };
S sa5c6a5[] = { 165, 198, 165, 0 };
S sbfaebcE[] = { 191, 174, 188, 212, 0 };
S sa1ca[] = { 161, 202, 0 };
S saaa4[] = { 170, 164, 0 };
S sa5b8a5[] = { 165, 184, 165, 0 };
S sa5b9a4[] = { 165, 185, 164, 0 };
S sa5ec[] = { 165, 236, 0 };
S sb7a4c6[] = { 183, 164, 198, 0 };
S sa5c7[] = { 165, 199, 0 };
S sa5b7a5[] = { 165, 183, 165, 0 };
S scfa1a4[] = { 207, 161, 164, 0 };
S sccbf[] = { 204, 191, 0 };
S saca7ac[] = { 172, 167, 172, 0 };
S sada4[] = { 173, 164, 0 };
S sa5b7[] = { 165, 183, 0 };
S sa3A[] = { 163, 208, 0 };
S sa5bfa5[] = { 165, 191, 165, 0 };
S sa4cfa1a4[] = { 164, 207, 161, 164, 0 };
S sa7aca7[] = { 167, 172, 167, 0 };
S sa4b7a4c6[] = { 164, 183, 164, 198, 0 };
S sbda4[] = { 189, 164, 0 };
S sb7a5[] = { 183, 165, 0 };
S saca7aca7[] = { 172, 167, 172, 167, 0 };
S sa7ac[] = { 167, 172, 0 };
S sa4cfa1[] = { 164, 207, 161, 0 };
S sa4a2[] = { 164, 162, 0 };
S sa3c2a1[] = { 163, 194, 161, 0 };
S sAa3[] = { 208, 163, 0 };
S sFa5[] = { 213, 165, 0 };
S scdf8cd[] = { 205, 248, 205, 0 };
S sa4aa[] = { 164, 170, 0 };
S sa1cb[] = { 161, 203, 0 };
S sa8a4[] = { 168, 164, 0 };
S scdf8[] = { 205, 248, 0 };
S sa3Aa3[] = { 163, 208, 163, 0 };
S sb9a5[] = { 185, 165, 0 };
S scdf8cdB[] = { 205, 248, 205, 209, 0 };
S sc7L[] = { 199, 219, 0 };
S seaa1[] = { 234, 161, 0 };
S sbde8[] = { 189, 232, 0 };
S saebcEa4[] = { 174, 188, 212, 164, 0 };
S sccbfae[] = { 204, 191, 174, 0 };
S sf8cdB[] = { 248, 205, 209, 0 };
S scea5[] = { 206, 165, 0 };
S sa5F[] = { 165, 213, 0 };
S sc4ccbfae[] = { 196, 204, 191, 174, 0 };
S sc4ccbf[] = { 196, 204, 191, 0 };
S sa4a5f3[] = { 164, 165, 243, 0 };
S sa1a5a3[] = { 161, 165, 163, 0 };
S sa3c2[] = { 163, 194, 0 };
S sa5H[] = { 165, 215, 0 };
S sa5eca5[] = { 165, 236, 165, 0 };
S sa5Fa5[] = { 165, 213, 165, 0 };
S seca5[] = { 236, 165, 0 };
S sa4a2a4[] = { 164, 162, 164, 0 };
S sa5a4a5f3[] = { 165, 164, 165, 243, 0 };
S sGa4[] = { 214, 164, 0 };
S sc2a1[] = { 194, 161, 0 };
S sbca8[] = { 188, 168, 0 };
S seaa5[] = { 234, 165, 0 };
S sa4a5f3a5[] = { 164, 165, 243, 165, 0 };
S sa5b9a5[] = { 165, 185, 165, 0 };
S sf8cd[] = { 248, 205, 0 };
S sa3F[] = { 163, 213, 0 };
S sa4aaa4[] = { 164, 170, 164, 0 };
S sb9a4eba1[] = { 185, 164, 235, 161, 0 };
S sbde8cdfd[] = { 189, 232, 205, 253, 0 };
S sf5bfaebc[] = { 245, 191, 174, 188, 0 };
S sb9cd[] = { 185, 205, 0 };
S sBbcE[] = { 209, 188, 212, 0 };
S scdHc1c7[] = { 205, 215, 193, 199, 0 };
S sf8cdBbc[] = { 248, 205, 209, 188, 0 };
S sbca5b8a4[] = { 188, 165, 184, 164, 0 };
S sa3c2a1a5[] = { 163, 194, 161, 165, 0 };
S sa5c9[] = { 165, 201, 0 };
S sa4b7a4bf[] = { 164, 183, 164, 191, 0 };
S sc2a1a5[] = { 194, 161, 165, 0 };
S sc4a4[] = { 196, 164, 0 };
S sOa4[] = { 222, 164, 0 };
S sa4a6[] = { 164, 166, 0 };
S sa4c7a4a2[] = { 164, 199, 164, 162, 0 };
S sabb9[] = { 171, 185, 0 };
S sb7a4bf[] = { 183, 164, 191, 0 };
S sa5N[] = { 165, 221, 0 };
S sbde8cd[] = { 189, 232, 205, 0 };
S sc0ae[] = { 192, 174, 0 };
S sc7a4a2a4[] = { 199, 164, 162, 164, 0 };
S sHa5[] = { 215, 165, 0 };
S sa4eba5[] = { 164, 235, 165, 0 };
S sHc1[] = { 215, 193, 0 };
S sBbc[] = { 209, 188, 0 };
S scdBbcE[] = { 205, 209, 188, 212, 0 };
S se8cd[] = { 232, 205, 0 };
S scdBbc[] = { 205, 209, 188, 0 };
S sa5Ha5[] = { 165, 215, 165, 0 };
S scdHc1[] = { 205, 215, 193, 0 };
S sHc1c7[] = { 215, 193, 199, 0 };
S sc7a4a2[] = { 199, 164, 162, 0 };
S sc1c7[] = { 193, 199, 0 };
S sa5b8a4[] = { 165, 184, 164, 0 };
S sb9f0[] = { 185, 240, 0 };
S sb4abb9[] = { 180, 171, 185, 0 };
S sa4cea5[] = { 164, 206, 165, 0 };
S sb4abb9f0[] = { 180, 171, 185, 240, 0 };
S sa5eaa5[] = { 165, 234, 165, 0 };
S seaa4[] = { 234, 164, 0 };
S sc8af[] = { 200, 175, 0 };
S sc3a4[] = { 195, 164, 0 };
S sAa5[] = { 208, 165, 0 };
S sb4ab[] = { 180, 171, 0 };
S se8cdfd[] = { 232, 205, 253, 0 };
S sabb9f0[] = { 171, 185, 240, 0 };
S sa5c8a4[] = { 165, 200, 164, 0 };
S sbfa3[] = { 191, 163, 0 };
S sa4ea[] = { 164, 234, 0 };
S sDa5b9cd[] = { 211, 165, 185, 205, 0 };
S sc1a4[] = { 193, 164, 0 };
S sa3c8[] = { 163, 200, 0 };
S sa4c6a4a4[] = { 164, 198, 164, 164, 0 };
S sbfaea4[] = { 191, 174, 164, 0 };
S sa3Fa3[] = { 163, 213, 163, 0 };
S saca4[] = { 172, 164, 0 };
S sf3a5bf[] = { 243, 165, 191, 0 };
S sa4ada4[] = { 164, 173, 164, 0 };
S sc6b0[] = { 198, 176, 0 };
S sa3c9[] = { 163, 201, 0 };
S sa5c7a5[] = { 165, 199, 165, 0 };
S sa2a4eb[] = { 162, 164, 235, 0 };
S sJa4[] = { 217, 164, 0 };
S sFa3[] = { 213, 163, 0 };
S sc6a4a4[] = { 198, 164, 164, 0 };
S sa3a5[] = { 163, 165, 0 };
S sga4b3[] = { 32, 164, 179, 0 };
S sc1f7[] = { 193, 247, 0 };
S sa4caa4a4[] = { 164, 202, 164, 164, 0 };
S sb9a4eba4[] = { 185, 164, 235, 164, 0 };
S sc6a4a4a4[] = { 198, 164, 164, 164, 0 };
S scaa4a4[] = { 202, 164, 164, 0 };
S sc8a3[] = { 200, 163, 0 };
S sa5b9cdH[] = { 165, 185, 205, 215, 0 };
S sb9cdHc1[] = { 185, 205, 215, 193, 0 };
S sc7a5[] = { 199, 165, 0 };
S sb9cdH[] = { 185, 205, 215, 0 };
S sga4b3a4[] = { 32, 164, 179, 164, 0 };
S sc1c7a4[] = { 193, 199, 164, 0 };
S sHc1c7a4[] = { 215, 193, 199, 164, 0 };
S sa4e9a4[] = { 164, 233, 164, 0 };
S sa4cea4[] = { 164, 206, 164, 0 };
S sa5f3a5bf[] = { 165, 243, 165, 191, 0 };
S sa5a3a5[] = { 165, 163, 165, 0 };
S sa3D[] = { 163, 211, 0 };
S sa3c4[] = { 163, 196, 0 };
S se9a4[] = { 233, 164, 0 };
S sa5b9cd[] = { 165, 185, 205, 0 };
S scaa5[] = { 202, 165, 0 };
S sa4a2a4eb[] = { 164, 162, 164, 235, 0 };
S sa4a4eb[] = { 164, 164, 235, 0 };
S scba3[] = { 203, 163, 0 };
S sa4cba4e8[] = { 164, 203, 164, 232, 0 };
S sc8afbf[] = { 200, 175, 191, 0 };
S sc9bdbca8[] = { 201, 189, 188, 168, 0 };
S saca7a3c2[] = { 172, 167, 163, 194, 0 };
S sa5a2[] = { 165, 162, 0 };
S sa5a2a5[] = { 165, 162, 165, 0 };
S sb8c4[] = { 184, 196, 0 };
S sf3a5c8[] = { 243, 165, 200, 0 };
S sa4cfg[] = { 164, 207, a };
S safbf[] = { 175, 191, 0 };
S sa4c6a1[] = { 164, 198, 161, 0 };
S sa5Aa5[] = { 165, 208, 165, 0 };
S sa5A[] = { 165, 208, 0 };
S sa7a3c2a1[] = { 167, 163, 194, 161, 0 };
S seba1bc[] = { 235, 161, 188, 0 };
S sf5c2[] = { 245, 194, 0 };
S sFa3c1[] = { 213, 163, 193, 0 };
S sNa5[] = { 221, 165, 0 };
S sa4c3a4[] = { 164, 195, 164, 0 };
S sa3c9a3A[] = { 163, 201, 163, 208, 0 };
S sa7aca7ac[] = { 167, 172, 167, 172, 0 };
S sa5c3a5af[] = { 165, 195, 165, 175, 0 };
S sa2a5[] = { 162, 165, 0 };
S sa3c6a1[] = { 163, 198, 161, 0 };
S scca4[] = { 204, 164, 0 };
S scba4e8a4[] = { 203, 164, 232, 164, 0 };
S sc9a3[] = { 201, 163, 0 };
S sbdbc[] = { 189, 188, 0 };
S sa5eba5[] = { 165, 235, 165, 0 };
S sc1ac[] = { 193, 172, 0 };
S sc3a5af[] = { 195, 165, 175, 0 };
S sc7bd[] = { 199, 189, 0 };
S sa5c7a5a3[] = { 165, 199, 165, 163, 0 };
S sa2a4eba1[] = { 162, 164, 235, 161, 0 };
S sc6a1a5g[] = { 198, 161, 165, a };
S scfa4[] = { 207, 164, 0 };
S sc8afbfae[] = { 200, 175, 191, 174, 0 };
S sc6a1a5[] = { 198, 161, 165, 0 };
S sa1bf[] = { 161, 191, 0 };
S sa5a7[] = { 165, 167, 0 };
S sa4c3[] = { 164, 195, 0 };
S seba1bca5[] = { 235, 161, 188, 165, 0 };
S sa3c1ac[] = { 163, 193, 172, 0 };
S sc1aca7[] = { 193, 172, 167, 0 };
S safbfae[] = { 175, 191, 174, 0 };
S sf5c2G[] = { 245, 194, 214, 0 };
S sbef5c2[] = { 190, 245, 194, 0 };
S sbef5[] = { 190, 245, 0 };
S sbca8a4[] = { 188, 168, 164, 0 };
S sa3Fa3c1[] = { 163, 213, 163, 193, 0 };
S sa1bca5H[] = { 161, 188, 165, 215, 0 };
S sa3c1aca7[] = { 163, 193, 172, 167, 0 };
S sa7a1[] = { 167, 161, 0 };
S sc9bdbc[] = { 201, 189, 188, 0 };
S scba4e8[] = { 203, 164, 232, 0 };
S sDa5b9a4[] = { 211, 165, 185, 164, 0 };
S sa5f3a5c8[] = { 165, 243, 165, 200, 0 };
S sbca5H[] = { 188, 165, 215, 0 };
S sc6a1a4[] = { 198, 161, 164, 0 };
S sbef5c2G[] = { 190, 245, 194, 214, 0 };
S sa4Oa4[] = { 164, 222, 164, 0 };
S sa4a4a4eb[] = { 164, 164, 164, 235, 0 };
S sc2G[] = { 194, 214, 0 };
S sc9a3A[] = { 201, 163, 208, 0 };
S sa7a3c2[] = { 167, 163, 194, 0 };
S sa3E[] = { 163, 212, 0 };
S sa1bfa3[] = { 161, 191, 163, 0 };
S sb7a4bfa4[] = { 183, 164, 191, 164, 0 };
S sBbcEa4[] = { 209, 188, 212, 164, 0 };
S sa5eba1bc[] = { 165, 235, 161, 188, 0 };
S sa4O[] = { 164, 222, 0 };
S sa4c6a1a4[] = { 164, 198, 161, 164, 0 };
S sc1aca7a3[] = { 193, 172, 167, 163, 0 };
S sc7a4ce[] = { 199, 164, 206, 0 };
S sbdbca8[] = { 189, 188, 168, 0 };

N l26n0[] = { { sa5b5, .292 }, H };
N l26n2[] = { { sa4c6, .422 }, { scacc, .146 }, H };
N l26n3[] = { { sa4b7, .438 }, { sa5Ra5, .438 }, { sAa3, .219 }, H };
N l26n4[] = { { sb9cd, .130 }, H };
N l26n5[] = { { sa5c3a5, .706 }, { sbfa4, .292 }, { sa4c7a4a2, .260 }, { sa3c8, .114 }, H };
N l26n7[] = { { seaa1, .219 }, H };
N l26n8[] = { { sf5bfaebc, .389 }, H };
N l26n9[] = { { sbcf5, .211 }, H };
N l26n11[] = { { sc8a3, .170 }, H };
N l26n12[] = { { sa7a3, .308 }, { sc8afbf, .219 }, H };
N l26n13[] = { { sb7a4, .324 }, H };
N l26n14[] = { { sa4c6a4, .292 }, { sc7a5, .170 }, H };
N l26n15[] = { { sa4b7a4, .487 }, H };
N l26n17[] = { { sbde8cdfd, .260 }, H };
N l26n18[] = { { sa1bca5, 1.630 }, { sa5c3a5af, .195 }, { sa5a7, .097 }, H };
N l26n19[] = { { sa4c7, .406 }, { sa5b9cd, .170 }, H };
N l26n21[] = { { sa5Da5, .462 }, H };
N l26n22[] = { { sbfa5, .211 }, { sa3c9, .114 }, { sc8afbfae, .292 }, H };
N l26n23[] = { { sc3a5af, .219 }, H };
N l26n26[] = { { scdH, .316 }, { scdf8cd, .329 }, { sbde8cd, .195 }, { sb4abb9, .195 }, { sc9a3A, .219 }, H };
N l26n27[] = { { sa5g, .365 }, { se9a4, .170 }, { sa4cba4e8, .195 }, H };
N l26n28[] = { { sc8a4, .608 }, H };
N l26n30[] = { { sa5f3, .373 }, { sb7a5, .162 }, H };
N l26n31[] = { { sa4c7a4, .389 }, { sa5b5a1bc, .519 }, { sbef5c2G, .195 }, H };
N l26n32[] = { { sa5F, .146 }, H };
N l26n33[] = { { sa5c6, .178 }, H };
N l26n34[] = { { sa5b7, .162 }, { sc6a1a5g, .438 }, H };
N l26n36[] = { { sa4c8, .454 }, H };
N l26n37[] = { { sa4b9, .357 }, { sAa5, .195 }, H };
N l26n38[] = { { seba1, .730 }, { safa5, .195 }, { sa4aa, .146 }, { sa3Fa3c1, .195 }, H };
N l26n39[] = { { seba1a3, .840 }, { sb4ab, .130 }, H };
N l26n41[] = { { seba1bca5, .292 }, H };
N l26n42[] = { { sc9a3, .146 }, H };
N l26n43[] = { { sJa4, .170 }, H };
N l26n44[] = { { sb8a4, .195 }, { sxg, .114 }, H };
N l26n46[] = { { sa1bf, .097 }, { sb7a4bfa4, .195 }, H };
N l26n47[] = { { sc2a1, .219 }, { sa1bfa3, .146 }, H };
N l26n48[] = { { sa4c8a4, .414 }, H };
N l26n49[] = { { sa4b9a4, .511 }, { sa4a5f3a5, .292 }, H };
N l26n50[] = { { sa5c7, .162 }, { sa4aaa4, .219 }, { saca7a3c2, .195 }, { sa5c7a5a3, .195 }, H };
N l26n51[] = { { sa5b8, .438 }, H };
N l26n52[] = { { sRa5, .462 }, H };
N l26n53[] = { { sa5f3a5, .487 }, H };
N l26n54[] = { { sa5c3a5bb, .552 }, H };
N l26n55[] = { { sa5Fa5, .219 }, H };
N l26n56[] = { { sa5c6a5, .268 }, H };
N l26n57[] = { { sa5b7a5, .243 }, H };
N l26n58[] = { { sa1bca5b8, .616 }, { seaa4, .195 }, { seba1bc, .219 }, H };
N l26n60[] = { { sa8a4, .146 }, H };
N l26n61[] = { { sb8a5, .178 }, H };
N l26n62[] = { { sbcf5bf, .316 }, { sa4caa4a4, .227 }, H };
N l26n63[] = { { sbfaebcE, .357 }, { sa5b8a4, .195 }, H };
N l26n64[] = { { sa5Da5b9, .519 }, H };
N l26n65[] = { { sb9cdH, .170 }, H };
N l26n66[] = { { sa4a5f3, .219 }, { sa5H, .146 }, { sb7a4bf, .195 }, H };
N l26n67[] = { { sa5c8, .292 }, { sc1a4, .170 }, H };
N l26n68[] = { { sa5b9, .616 }, { sa4e8, .227 }, { saca7aca7, .324 }, { scdBbcE, .389 }, H };
N l26n69[] = { { sa7a3c2a1, .195 }, H };
N l26n70[] = { { sa4ca, .389 }, { sc4ea, .219 }, { sc2a1a5, .292 }, H };
N l26n71[] = { { sb9a4eba1, .260 }, { sbef5, .097 }, H };
N l26n72[] = { { sa4ac, .341 }, { sc4cc, .316 }, { sbcf5bfae, .422 }, H };
N l26n73[] = { { sa5c7a5, .170 }, H };
N l26n74[] = { { sa5b8a5, .268 }, H };
N l26n75[] = { { sb9a4, .535 }, { sa4eba1a3, .746 }, { saca7g, .475 }, { scdf8, .219 }, { sbde8, .146 }, { seaa5, .219 }, H };
N l26n76[] = { { sa5Ra5c3, .552 }, { sgac, .227 }, { sa4b7a4bf, .260 }, { sb8c4, .097 }, H };
N l26n78[] = { { sabb9f0, .195 }, H };
N l26n79[] = { { saca7ac, .243 }, { sa5c8a4, .195 }, H };
N l26n80[] = { { sa4e8a4, .341 }, { sa5b9a4, .268 }, { sb9a4eba4, .227 }, H };
N l26n81[] = { { sa5bba1, .414 }, H };
N l26n82[] = { { sa1a3, .568 }, { sa4caa4, .365 }, H };
N l26n83[] = { { sHc1c7a4, .341 }, H };
N l26n84[] = { { sa5c9, .130 }, H };
N l26n85[] = { { sa4eca4eb, .487 }, { sa4e9, .146 }, H };
N l26n86[] = { { sbba1, .276 }, H };
N l26n87[] = { { sa4cb, .681 }, { sb9f0, .130 }, H };
N l26n89[] = { { sbba1bca5, .552 }, { seba4, .341 }, { sa7g, .316 }, { sa4ad, .146 }, { sa5Ha5, .195 }, H };
N l26n90[] = { { sa3cd, .324 }, { scaa4, .438 }, { sf5bf, .316 }, { safbfae, .146 }, H };
N l26n91[] = { { sa3cda3, .341 }, { sa5b9a5, .219 }, H };
N l26n92[] = { { sb9a5, .146 }, H };
N l26n93[] = { { scba4e8a4, .292 }, H };
N l26n95[] = { { sbdbc, .097 }, H };
N l26n97[] = { { sa4b7a4c6, .324 }, { sga4b3a4, .227 }, { sa4e9a4, .170 }, { sDa5b9a4, .292 }, H };
N l26n98[] = { { sa4eba1, .584 }, { sf3a5, .487 }, { sa7a3c2, .146 }, H };
N l26n99[] = { { sa1a4, .633 }, { sa4cba4, .341 }, { sccbf, .243 }, H };
N l26n100[] = { { sb9a4eb, .511 }, H };
N l26n101[] = { { scdHc1, .292 }, { sa4ada4, .170 }, H };
N l26n102[] = { { sa5bb, .341 }, { sa4ea, .114 }, { scaa4a4, .256 }, H };
N l26n103[] = { { sHc1c7, .292 }, H };
N l26n104[] = { { scba3, .146 }, H };
N l26n106[] = { { sbba1bc, .414 }, { seba5, .341 }, H };
N l26n107[] = { { scaa5, .170 }, { sa4a2a4eb, .227 }, H };
N l26n113[] = { { scba4e8, .219 }, H };
N l26n114[] = { { sa4cfa1a4, .324 }, { sa5f3a5bf, .227 }, H };
N l26n116[] = { { sa1a5, .454 }, H };
N l26n117[] = { { sDa5b9, .584 }, { sa1a5a3, .219 }, { sga4b3, .170 }, H };
N l26n119[] = { { sa4eb, .957 }, H };
N l26n120[] = { { seca4, .754 }, H };
N l26n121[] = { { scba4, .389 }, { sgaca7, .341 }, { sa3c2a1a5, .260 }, H };
N l26n122[] = { { saaa4, .178 }, H };
N l26n125[] = { { sc4ccbf, .329 }, H };
N l26n126[] = { { sc3a5bba1, .827 }, { sa2a4eba1, .195 }, H };
N l26n129[] = { { sc3a4, .195 }, H };
N l26n130[] = { { sDa5, .511 }, { sa2a4, .178 }, H };
N l26n131[] = { { sa4eba4, .316 }, H };
N l26n132[] = { { sRa5c3a5, .827 }, { sb9cdHc1, .227 }, H };
N l26n133[] = { { sa5bba1bc, .552 }, { sa5ea, .227 }, H };
N l26n134[] = { { sa4cfa1, .243 }, H };
N l26n135[] = { { seba1a3g, 1.679 }, { sc4ccbfae, .438 }, { sa3c9a3A, .195 }, H };
N l26n136[] = { { sa4ec, .487 }, H };
N l26n137[] = { { seca5, .219 }, H };
N l26n138[] = { { sa4ce, 1.103 }, { sa3c2a1, .219 }, H };
N l26n139[] = { { sa4bf, .422 }, { sa1bca5D, .519 }, H };
N l26n141[] = { { sa3A, .162 }, { scdf8cdB, .438 }, { sbca5b8a4, .260 }, { sf5c2, .146 }, { sa5f3a5c8, .195 }, { sa4a4a4eb, .195 }, H };
N l26n142[] = { { sa3c1, .243 }, { saebc, .178 }, { sa3Aa3, .219 }, { sa4eba5, .195 }, H };
N l26n143[] = { { sb7a4c6, .243 }, H };
N l26n144[] = { { sEa4, .438 }, H };
N l26n145[] = { { seca4eb, .548 }, { sb3a4, .211 }, { sga1, .211 }, H };
N l26n146[] = { { sc3a5, .706 }, H };
N l26n147[] = { { sa2a5, .097 }, H };
N l26n148[] = { { sa4eca4, .730 }, { se8cdfd, .292 }, H };
N l26n149[] = { { sRa5c3, .621 }, H };
N l26n150[] = { { sa5eb, .243 }, { saebcEa4, .292 }, { sc1c7, .195 }, { sa4cea4, .170 }, H };
N l26n151[] = { { sa4bfa4, .365 }, { sf3a5bf, .256 }, { sa1bca5H, .195 }, { sbdbca8, .146 }, H };
N l26n152[] = { { sa5b9cdH, .227 }, { scca4, .146 }, H };
N l26n154[] = { { sa5af, .260 }, { sa4O, .097 }, H };
N l26n155[] = { { sa4cf, .568 }, { sc3a5bb, .621 }, { sa2a4eb, .170 }, H };
N l26n156[] = { { sb5a1, .373 }, { sa5eaa5, .195 }, H };
N l26n157[] = { { sbef5c2, .146 }, H };
N l26n158[] = { { sa4a2, .146 }, { sFa3, .170 }, H };
N l26n159[] = { { sb5a1bca5, .519 }, { sa3c2, .146 }, H };
N l26n160[] = { { scdfd, .316 }, { sf8cdB, .329 }, { sc4a4, .195 }, H };
N l26n161[] = { { sbca5b8, .462 }, { sa4cea5, .195 }, { sa3a4, .097 }, H };
N l26n162[] = { { sc1c7a4, .256 }, H };
N l26n164[] = { { sc7L, .219 }, H };
N l26n165[] = { { sa7ac, .162 }, { sf8cd, .219 }, H };
N l26n166[] = { { scda3, .341 }, { sc7bd, .146 }, { sa4Oa4, .146 }, H };
N l26n167[] = { { sa5ec, .162 }, H };
N l26n168[] = { { sa5N, .130 }, H };
N l26n170[] = { { sa5bf, .308 }, { saebcE, .268 }, { sa4a2a4, .219 }, { sc6b0, .170 }, H };
N l26n171[] = { { sc6a1, .292 }, H };
N l26n173[] = { { sa5eba5, .146 }, H };
N l26n175[] = { { sbfae, .649 }, H };
N l26n176[] = { { sb5a1bc, .389 }, H };
N l26n177[] = { { sa4b5a4ec, .649 }, { sa5afa5, .292 }, H };
N l26n178[] = { { sa1a3g, 1.278 }, { sa3a5, .114 }, H };
N l26n179[] = { { sga3, .195 }, H };
N l26n180[] = { { scdB, .316 }, { sc2G, .146 }, H };
N l26n181[] = { { se8cd, .195 }, { sa5eba1bc, .195 }, H };
N l26n183[] = { { sc6a1a4, .219 }, H };
N l26n184[] = { { saca4, .114 }, { sNa5, .146 }, H };
N l26n185[] = { { sbca5, 1.087 }, { sbca5Da5, .519 }, H };
N l26n186[] = { { scdHc1c7, .389 }, H };
N l26n187[] = { { sbfaea4, .170 }, H };
N l26n189[] = { { sa5a2, .097 }, H };
N l26n190[] = { { sb9e7, .195 }, { sa5eca5, .219 }, H };
N l26n191[] = { { sa4b3, .195 }, { sf5c2G, .219 }, H };
N l26n192[] = { { sa4a4, .730 }, { sFa5, .219 }, { sa3D, .114 }, H };
N l26n193[] = { { sa5bfa5, .243 }, { sa3c4, .114 }, H };
N l26n194[] = { { scfa1, .292 }, { sc6a1a5, .219 }, H };
N l26n195[] = { { sbfaebc, .268 }, H };
N l26n196[] = { { sga4, .308 }, H };
N l26n198[] = { { sOa4, .195 }, { sc1f7, .170 }, H };
N l26n199[] = { { sbda4, .162 }, H };
N l26n200[] = { { scdBbc, .292 }, H };
N l26n202[] = { { sbca5D, .389 }, H };
N l26n203[] = { { sa4b3a4, .292 }, { sBbc, .195 }, { sa5A, .097 }, { sc1ac, .146 }, H };
N l26n204[] = { { sa4a4a4, .389 }, H };
N l26n206[] = { { sa5a3, .308 }, { scfa1a4, .365 }, { sGa4, .219 }, { sc0ae, .195 }, { sa3c6a1, .146 }, H };
N l26n207[] = { { sb5a4, .324 }, { sa5a4a5f3, .292 }, { sa4c3, .097 }, H };
N l26n209[] = { { sa4a5, .292 }, { sa3E, .097 }, H };
N l26n210[] = { { sa7aca7, .243 }, H };
N l26n211[] = { { sBbcEa4, .292 }, H };
N l26n212[] = { { sa1a5g, .548 }, { sf5bfae, .475 }, { sf8cdBbc, .389 }, { sa5a2a5, .146 }, H };
N l26n213[] = { { sga5, .341 }, H };
N l26n214[] = { { scea4, .268 }, { sc6a4a4a4, .341 }, { sa7aca7ac, .195 }, H };
N l26n215[] = { { sada4, .162 }, { sc8af, .195 }, { sc7a4ce, .219 }, H };
N l26n216[] = { { sbcE, .324 }, H };
N l26n217[] = { { sa4a4eb, .146 }, { sa4c6a1a4, .195 }, H };
N l26n218[] = { { sHc1, .195 }, H };
N l26n219[] = { { sa4c3a4, .146 }, H };
N l26n220[] = { { sDa5b9cd, .341 }, H };
N l26n221[] = { { sa3g, .852 }, { sccbfae, .329 }, H };
N l26n222[] = { { sc6a4, .316 }, H };
N l26n223[] = { { sb5a4eca4, .649 }, { sa5a4, .243 }, { sc7a4a2a4, .389 }, H };
N l26n224[] = { { safbf, .097 }, H };
N l26n225[] = { { sa4b5, .324 }, { sc1aca7a3, .292 }, H };
N l26n226[] = { { sa3F, .146 }, { sa4a6, .130 }, { sa5Aa5, .146 }, H };
N l26n227[] = { { sa3Fa3, .170 }, H };
N l26n228[] = { { sbcEa4, .389 }, { sc9bd, .292 }, H };
N l26n229[] = { { sa5a3a5, .170 }, H };
N l26n231[] = { { scea5, .219 }, { sBbcE, .292 }, { sa3c1aca7, .195 }, H };
N l26n233[] = { { sa1ca, .178 }, { sFa3c1, .219 }, H };
N l26n234[] = { { sb4abb9f0, .260 }, { sc6a4a4, .256 }, { sa7a1, .097 }, H };
N l26n235[] = { { saca7, .892 }, { sa5b5a1, .389 }, H };
N l26n236[] = { { saca7a3, .462 }, { sa5R, .292 }, { sbca8, .146 }, H };
N l26n237[] = { { sa4b5a4, .487 }, { sa4c6a1, .146 }, H };
N l26n238[] = { { sa5c3, .470 }, { sa4f2, .438 }, H };
N l26n239[] = { { sc6a5, .292 }, H };
N l26n240[] = { { sc9bdbca8, .292 }, H };
N l26n242[] = { { sa4b9a4eb, .681 }, { sa3c1ac, .146 }, H };
N l26n243[] = { { sb5a4ec, .487 }, { sc7a4a2, .292 }, H };
N l26n244[] = { { sbfa3, .114 }, H };
N l26n245[] = { { scfa4, .146 }, H };
N l26n246[] = { { sa5a4a5, .365 }, { saea4, .178 }, { sbca5H, .146 }, H };
N l26n248[] = { { sc1aca7, .219 }, { sbca8a4, .146 }, { sc9bdbc, .219 }, H };
N l26n250[] = { { sa1cb, .146 }, { sa4c6a4a4, .227 }, { sf3a5c8, .219 }, H };
N l26n251[] = { { sa1bc, 1.119 }, { sa4cfg, .219 }, H };
N l26n252[] = { { se8a4, .462 }, H };
N l26n253[] = { { sc7a4, .584 }, H };
N l26n254[] = { { sa5D, .308 }, { sabb9, .130 }, { sHa5, .195 }, H };

D l26_d = {
	"japanese",
	"euc_jp",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, 0.001, W, W, W, 0.002,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.005, 0.001, 0.002, 0.006, 0.002, 0.002, 0.003, 0.001, 0.006, W, W, 0.002, 0.002, 0.007, 0.003,
	    0.002, 0.000, 0.003, 0.006, 0.008, 0.003, 0.002, W, W, 0.001, 0.000, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.147, 0.014, 0.130, 0.457, 0.316, 0.006, 0.041, 0.012, 0.006, 0.013, 0.010, 0.054, 0.010, 0.033, 0.023,
	    0.022, 0.008, 0.014, 0.019, 0.025, 0.039, 0.007, 0.030, 0.038, 0.071, 0.009, 0.032, 0.086, 0.037, 0.019, 0.069,
	    0.022, 0.052, 0.041, 0.057, 0.048, 0.028, 0.064, 0.060, 0.068, 0.042, 0.067, 0.060, 0.048, 0.077, 0.089, 0.049,
	    0.027, 0.016, 0.004, 0.029, 0.030, 0.019, 0.021, 0.023, 0.018, 0.010, 0.002, 0.015, 0.014, 0.017, 0.014, 0.011,
	    0.007, 0.027, 0.010, 0.004, 0.009, 0.008, 0.010, 0.022, 0.030, 0.014, 0.037, 0.075, 0.046, 0.004, 0.004, 0.007,
	    0.014, 0.006, 0.031, 0.035, 0.005, 0.022, 0.005, 0.008, 0.011, 0.001, 0.003, V, 0.005, 0.019, 0.014, V },
	{ l26n0, X, l26n2, l26n3, l26n4, l26n5, X, l26n7, l26n8, l26n9, X, l26n11, l26n12, l26n13, l26n14, l26n15,
	    X, l26n17, l26n18, l26n19, X, l26n21, l26n22, l26n23, X, X, l26n26, l26n27, l26n28, X, l26n30, l26n31,
	    l26n32, l26n33, l26n34, X, l26n36, l26n37, l26n38, l26n39, X, l26n41, l26n42, l26n43, l26n44, X, l26n46, l26n47,
	    l26n48, l26n49, l26n50, l26n51, l26n52, l26n53, l26n54, l26n55, l26n56, l26n57, l26n58, X, l26n60, l26n61, l26n62, l26n63,
	    l26n64, l26n65, l26n66, l26n67, l26n68, l26n69, l26n70, l26n71, l26n72, l26n73, l26n74, l26n75, l26n76, X, l26n78, l26n79,
	    l26n80, l26n81, l26n82, l26n83, l26n84, l26n85, l26n86, l26n87, X, l26n89, l26n90, l26n91, l26n92, l26n93, X, l26n95,
	    X, l26n97, l26n98, l26n99, l26n100, l26n101, l26n102, l26n103, l26n104, X, l26n106, l26n107, X, X, X, X,
	    X, l26n113, l26n114, X, l26n116, l26n117, X, l26n119, l26n120, l26n121, l26n122, X, X, l26n125, l26n126, X,
	    X, l26n129, l26n130, l26n131, l26n132, l26n133, l26n134, l26n135, l26n136, l26n137, l26n138, l26n139, X, l26n141, l26n142, l26n143,
	    l26n144, l26n145, l26n146, l26n147, l26n148, l26n149, l26n150, l26n151, l26n152, X, l26n154, l26n155, l26n156, l26n157, l26n158, l26n159,
	    l26n160, l26n161, l26n162, X, l26n164, l26n165, l26n166, l26n167, l26n168, X, l26n170, l26n171, X, l26n173, X, l26n175,
	    l26n176, l26n177, l26n178, l26n179, l26n180, l26n181, X, l26n183, l26n184, l26n185, l26n186, l26n187, X, l26n189, l26n190, l26n191,
	    l26n192, l26n193, l26n194, l26n195, l26n196, X, l26n198, l26n199, l26n200, X, l26n202, l26n203, l26n204, X, l26n206, l26n207,
	    X, l26n209, l26n210, l26n211, l26n212, l26n213, l26n214, l26n215, l26n216, l26n217, l26n218, l26n219, l26n220, l26n221, l26n222, l26n223,
	    l26n224, l26n225, l26n226, l26n227, l26n228, l26n229, X, l26n231, X, l26n233, l26n234, l26n235, l26n236, l26n237, l26n238, l26n239,
	    l26n240, X, l26n242, l26n243, l26n244, l26n245, l26n246, X, l26n248, X, l26n250, l26n251, l26n252, l26n253, l26n254, X }
};

//
// Lng: japanese
// Enc: shift_jis
//

S s82cc[] = { 130, 204, 0 };
S s81X[] = { 129, 97, 0 };
S s82c9[] = { 130, 201, 0 };
S s82f0[] = { 130, 240, 0 };
S s82c6[] = { 130, 198, 0 };
S s82b5[] = { 130, 181, 0 };
S s82bd[] = { 130, 189, 0 };
S s82c8[] = { 130, 200, 0 };
S s82c4[] = { 130, 196, 0 };
S s81Y[] = { 129, 98, 0 };
S s82c5[] = { 130, 197, 0 };
S sb582[] = { 181, 130, 0 };
S s82b582[] = { 130, 181, 130, 0 };
S sg82[] = { 32, 130, 0 };
S s82e9[] = { 130, 233, 0 };
S sc882[] = { 200, 130, 0 };
S s82c882[] = { 130, 200, 130, 0 };
S s82a9[] = { 130, 169, 0 };
S sa982[] = { 169, 130, 0 };
S s82cd[] = { 130, 205, 0 };
S s82b7[] = { 130, 183, 0 };
S sc682[] = { 198, 130, 0 };
S s82e8[] = { 130, 232, 0 };
S s82a2[] = { 130, 162, 0 };
S s82a982[] = { 130, 169, 130, 0 };
S s82c682[] = { 130, 198, 130, 0 };
S sbd82[] = { 189, 130, 0 };
S s82M[] = { 130, 220, 0 };
S sa282[] = { 162, 130, 0 };
S s82e7[] = { 130, 231, 0 };
S s82a282[] = { 130, 162, 130, 0 };
S s82M82[] = { 130, 220, 130, 0 };
S sc582[] = { 197, 130, 0 };
S sM82[] = { 220, 130, 0 };
S s82aa[] = { 130, 170, 0 };
S s82ad[] = { 130, 173, 0 };
S sc482[] = { 196, 130, 0 };
S s82c582[] = { 130, 197, 130, 0 };
S s82bd82[] = { 130, 189, 130, 0 };
S sg81[] = { 32, 129, 0 };
S sX82[] = { 97, 130, 0 };
S s82c482[] = { 130, 196, 130, 0 };
S se882[] = { 232, 130, 0 };
S sad82[] = { 173, 130, 0 };
S sc182[] = { 193, 130, 0 };
S s81X82[] = { 129, 97, 130, 0 };
S s82c1[] = { 130, 193, 0 };
S s8140[] = { 129, 64, 0 };
S s82c182[] = { 130, 193, 130, 0 };
S s81Yg[] = { 129, 98, a };
S sz82[] = { v, 130, 0 };
S s82c982[] = { 130, 201, 130, 0 };
S sc982[] = { 201, 130, 0 };
S s82Q[] = { 130, 224, 0 };
S sb781[] = { 183, 129, 0 };
S se982[] = { 233, 130, 0 };
S sg83[] = { 32, 131, 0 };
S s82e982[] = { 130, 233, 130, 0 };
S s7882[] = { x, 130, 0 };
S sm82[] = { i, 130, 0 };
S s82b582c4[] = { 130, 181, 130, 196, 0 };
S sb781Y[] = { 183, 129, 98, 0 };
S sg8140[] = { 32, 129, 64, 0 };
S sb582c4[] = { 181, 130, 196, 0 };
S s82e882[] = { 130, 232, 130, 0 };
S s82t[] = { 130, p, 0 };
S sb782[] = { 183, 130, 0 };
S sbd81[] = { 189, 129, 0 };
S s82b781Y[] = { 130, 183, 129, 98, 0 };
S s82bd81[] = { 130, 189, 129, 0 };
S sY82[] = { 98, 130, 0 };
S s82b781[] = { 130, 183, 129, 0 };
S s82a982e7[] = { 130, 169, 130, 231, 0 };
S s92r[] = { 146, n, 0 };
S scd82[] = { 205, 130, 0 };
S s82a4[] = { 130, 164, 0 };
S sb182[] = { 177, 130, 0 };
S sa982e7[] = { 169, 130, 231, 0 };
S se782[] = { 231, 130, 0 };
S sea82[] = { 234, 130, 0 };
S sW82[] = { 230, 130, 0 };
S s81Y82[] = { 129, 98, 130, 0 };
S s82ab[] = { 130, 171, 0 };
S sab82[] = { 171, 130, 0 };
S s82be[] = { 130, 190, 0 };
S sP82[] = { 223, 130, 0 };
S s82b782[] = { 130, 183, 130, 0 };
S s82M82b7[] = { 130, 220, 130, 183, 0 };
S sbe82[] = { 190, 130, 0 };
S saf82[] = { 175, 130, 0 };
S sM82b7[] = { 220, 130, 183, 0 };
S scc82[] = { 204, 130, 0 };
S sr82[] = { n, 130, 0 };
S s82P[] = { 130, 223, 0 };
S s82ad82[] = { 130, 173, 130, 0 };
S sa082[] = { 160, 130, 0 };
S sf082[] = { 240, 130, 0 };
S s8378[] = { 131, x, 0 };
S sf182[] = { 241, 130, 0 };
S s9286[] = { 146, 134, 0 };
S s81g[] = { 129, a };
S saa82[] = { 170, 130, 0 };
S s82ea[] = { 130, 234, 0 };
S s94r[] = { 148, n, 0 };
S s82ea82[] = { 130, 234, 130, 0 };
S sbd81Y[] = { 189, 129, 98, 0 };
S sX90[] = { 97, 144, 0 };
S s91V[] = { 145, 229, 0 };
S sM82b781[] = { 220, 130, 183, 129, 0 };
S s81z[] = { 129, v, 0 };
S s82e782[] = { 130, 231, 130, 0 };
S s82be82[] = { 130, 190, 130, 0 };
S st82[] = { p, 130, 0 };
S s82bd81Y[] = { 130, 189, 129, 98, 0 };
S s82af[] = { 130, 175, 0 };
S scc8e[] = { 204, 142, 0 };
S sb582bd[] = { 181, 130, 189, 0 };
S s82b582bd[] = { 130, 181, 130, 189, 0 };
S s82b182[] = { 130, 177, 130, 0 };
S s82cc8e[] = { 130, 204, 142, 0 };
S sb982[] = { 185, 130, 0 };
S s82cc82[] = { 130, 204, 130, 0 };
S s95aa[] = { 149, 170, 0 };
S sa482[] = { 164, 130, 0 };
S s82b1[] = { 130, 177, 0 };
S s81y[] = { 129, u, 0 };
S s90p[] = { 144, l, 0 };
S sk82[] = { g, 130, 0 };
S scd81[] = { 205, 129, 0 };
S s82ab82[] = { 130, 171, 130, 0 };
S s82cd81[] = { 130, 205, 129, 0 };
S s82P82[] = { 130, 223, 130, 0 };
S sbb82[] = { 187, 130, 0 };
S s82f1[] = { 130, 241, 0 };
S s82cd82[] = { 130, 205, 130, 0 };
S sb382[] = { 179, 130, 0 };
S s81X90[] = { 129, 97, 144, 0 };
S s8d91[] = { 141, 145, 0 };
S s90ad[] = { 144, 173, 0 };
S s82a482[] = { 130, 164, 130, 0 };
S sp82[] = { l, 130, 0 };
S s82bf[] = { 130, 191, 0 };
S s89fc[] = { 137, 252, 0 };
S s89fc8a[] = { 137, 252, 138, 0 };
S s82e882M[] = { 130, 232, 130, 220, 0 };
S se882M[] = { 232, 130, 220, 0 };
S sw82[] = { s, 130, 0 };
S s82c481[] = { 130, 196, 129, 0 };
S sc182bd[] = { 193, 130, 189, 0 };
S s8az[] = { 138, v, 0 };
S s82cd81X[] = { 130, 205, 129, 97, 0 };
S sQ82[] = { 224, 130, 0 };
S s93m[] = { 147, i, 0 };
S sfc8a[] = { 252, 138, 0 };
S s82c182bd[] = { 130, 193, 130, 189, 0 };
S s82c182c4[] = { 130, 193, 130, 196, 0 };
S sb782e9[] = { 183, 130, 233, 0 };
S s82f082[] = { 130, 240, 130, 0 };
S s89fc8az[] = { 137, 252, 138, v, 0 };
S s95fb[] = { 149, 251, 0 };
S se882M82[] = { 232, 130, 220, 130, 0 };
S sfc8az[] = { 252, 138, v, 0 };
S scd81X[] = { 205, 129, 97, 0 };
S s82b782e9[] = { 130, 183, 130, 233, 0 };
S sc182c4[] = { 193, 130, 196, 0 };
S s93m82[] = { 147, i, 130, 0 };
S s8a_[] = { 138, w, 0 };
S sc481[] = { 196, 129, 0 };
S sb582c482[] = { 181, 130, 196, 130, 0 };
S s4082[] = { 64, 130, 0 };
S s82aa82[] = { 130, 170, 130, 0 };
S sc482a2[] = { 196, 130, 162, 0 };
S s81z82[] = { 129, v, 130, 0 };
S sf08e[] = { 240, 142, 0 };
S s82c481X[] = { 130, 196, 129, 97, 0 };
S s82a082[] = { 130, 160, 130, 0 };
S s82b382[] = { 130, 179, 130, 0 };
S s81X92[] = { 129, 97, 146, 0 };
S s83n[] = { 131, j, 0 };
S sb781Y82[] = { 183, 129, 98, 130, 0 };
S s82t82[] = { 130, p, 130, 0 };
S scc8d[] = { 204, 141, 0 };
S s82u[] = { 130, q, 0 };
S s9594[] = { 149, 148, 0 };
S s82c482a2[] = { 130, 196, 130, 162, 0 };
S sc981[] = { 201, 129, 0 };
S s82f182[] = { 130, 241, 130, 0 };
S s82a0[] = { 130, 160, 0 };
S s82f08e[] = { 130, 240, 142, 0 };
S s94r82[] = { 148, n, 130, 0 };
S s90b6[] = { 144, 182, 0 };
S s82c7[] = { 130, 199, 0 };
S sc481X[] = { 196, 129, 97, 0 };
S s82cc8d[] = { 130, 204, 141, 0 };
S sb182c6[] = { 177, 130, 198, 0 };
S sX92[] = { 97, 146, 0 };
S s82b3[] = { 130, 179, 0 };
S s82c981X[] = { 130, 201, 129, 97, 0 };
S s82af82[] = { 130, 175, 130, 0 };
S sX83[] = { 97, 131, 0 };
S sc182bd81[] = { 193, 130, 189, 129, 0 };
S s_82[] = { w, 130, 0 };
S s89ef[] = { 137, 239, 0 };
S sf08a[] = { 240, 138, 0 };
S scc92[] = { 204, 146, 0 };
S s82f090[] = { 130, 240, 144, 0 };
S s82cc91[] = { 130, 204, 145, 0 };
S sf090[] = { 240, 144, 0 };
S s82bf82[] = { 130, 191, 130, 0 };
S sr95fb[] = { n, 149, 251, 0 };
S s82Q82[] = { 130, 224, 130, 0 };
S sX8e[] = { 97, 142, 0 };
S sca82[] = { 202, 130, 0 };
S s82b9[] = { 130, 185, 0 };
S s82e982c6[] = { 130, 233, 130, 198, 0 };
S sbf82[] = { 191, 130, 0 };
S sc98e[] = { 201, 142, 0 };
S s8278[] = { 130, x, 0 };
S sc482a282[] = { 196, 130, 162, 130, 0 };
S sc981X[] = { 201, 129, 97, 0 };
S s8dw[] = { 141, s, 0 };
S sad81[] = { 173, 129, 0 };
S sb781Yg[] = { 183, 129, 98, a };
S s82S[] = { 130, 226, 0 };
S s82W82[] = { 130, 230, 130, 0 };
S s92r95fb[] = { 146, n, 149, 251, 0 };
S s827882[] = { 130, x, 130, 0 };
S scc91[] = { 204, 145, 0 };
S s92r95[] = { 146, n, 149, 0 };
S sr95[] = { n, 149, 0 };
S s835e[] = { 131, 94, 0 };
S s82W[] = { 130, 230, 0 };
S s9182[] = { 145, 130, 0 };
S s97cd[] = { 151, 205, 0 };
S s82ed[] = { 130, 237, 0 };
S s82c98e[] = { 130, 201, 142, 0 };
S sed82[] = { 237, 130, 0 };
S sc782[] = { 199, 130, 0 };
S s8393[] = { 131, 147, 0 };
S s82cc92[] = { 130, 204, 146, 0 };
S sa882[] = { 168, 130, 0 };
S se982c6[] = { 233, 130, 198, 0 };
S s82b982[] = { 130, 185, 130, 0 };
S s81X8e[] = { 129, 97, 142, 0 };
S s82c981[] = { 130, 201, 129, 0 };
S s82v[] = { 130, r, 0 };
S s89ca[] = { 137, 202, 0 };
S s8f97[] = { 143, 151, 0 };
S s838c[] = { 131, 140, 0 };
S sa282bd[] = { 162, 130, 189, 0 };
S sb182c682[] = { 177, 130, 198, 130, 0 };
S s82f08c[] = { 130, 240, 140, 0 };
S sc082[] = { 192, 130, 0 };
S sz89[] = { v, 137, 0 };
S se981[] = { 233, 129, 0 };
S sX8d[] = { 97, 141, 0 };
S sb682[] = { 182, 130, 0 };
S s8ec0[] = { 142, 192, 0 };
S s93af[] = { 147, 175, 0 };
S s82ed82[] = { 130, 237, 130, 0 };
S s82e981[] = { 130, 233, 129, 0 };
S s90z[] = { 144, v, 0 };
S sx82[] = { t, 130, 0 };
S sf08c[] = { 240, 140, 0 };
S s82c682b5[] = { 130, 198, 130, 181, 0 };
S s81m[] = { 129, i, 0 };
S s96f0[] = { 150, 240, 0 };
S s8ea9[] = { 142, 169, 0 };
S s82b182c6[] = { 130, 177, 130, 198, 0 };
S sc682b582[] = { 198, 130, 181, 130, 0 };
S s9085[] = { 144, 133, 0 };
S sX91[] = { 97, 145, 0 };
S sb782e982[] = { 183, 130, 233, 130, 0 };
S s837883[] = { 131, x, 131, 0 };
S s7883[] = { x, 131, 0 };
S sc582ab82[] = { 197, 130, 171, 130, 0 };
S sfb82[] = { 251, 130, 0 };
S sbd81Y82[] = { 189, 129, 98, 130, 0 };
S s89ba[] = { 137, 186, 0 };
S s8d9182[] = { 141, 145, 130, 0 };
S sg8d[] = { 32, 141, 0 };
S s90p82[] = { 144, l, 130, 0 };
S s8c8e[] = { 140, 142, 0 };
S s97a7[] = { 151, 167, 0 };
S s8dec[] = { 141, 236, 0 };
S sc582ab[] = { 197, 130, 171, 0 };
S s82c582ab[] = { 130, 197, 130, 171, 0 };
S s82a282bd[] = { 130, 162, 130, 189, 0 };
S sa682[] = { 166, 130, 0 };
S s90m[] = { 144, i, 0 };
S sc882e8[] = { 200, 130, 232, 0 };
S s8582[] = { 133, 130, 0 };
S sn83[] = { j, 131, 0 };
S s82c882e8[] = { 130, 200, 130, 232, 0 };
S sc682b5[] = { 198, 130, 181, 0 };
S s8ca0[] = { 140, 160, 0 };
S s83_[] = { 131, w, 0 };
S sa282bd82[] = { 162, 130, 189, 130, 0 };
S s8e9e[] = { 142, 158, 0 };
S sV82[] = { 229, 130, 0 };
S s82y[] = { 130, u, 0 };
S s93Q[] = { 147, 224, 0 };
S s8eu[] = { 142, q, 0 };
S s81z82c6[] = { 129, v, 130, 198, 0 };
S s82cc8f[] = { 130, 204, 143, 0 };
S s82ab82e9[] = { 130, 171, 130, 233, 0 };
S sQ90[] = { 224, 144, 0 };
S s83l[] = { 131, h, 0 };
S s82f08a[] = { 130, 240, 138, 0 };
S s839383[] = { 131, 147, 131, 0 };
S s83r[] = { 131, n, 0 };
S s81X8d[] = { 129, 97, 141, 0 };
S se981Y[] = { 233, 129, 98, 0 };
S s9383[] = { 147, 131, 0 };
S s8f_[] = { 143, w, 0 };
S sc582Q[] = { 197, 130, 224, 0 };
S sg8b[] = { 32, 139, 0 };
S sbd81Yg[] = { 189, 129, 98, a };
S ss83[] = { o, 131, 0 };
S s82N[] = { 130, 221, 0 };
S s82bb[] = { 130, 187, 0 };
S sc882e882[] = { 200, 130, 232, 130, 0 };
S s98X[] = { 152, 97, 0 };
S sfc8azg[] = { 252, 138, v, a };
S s93m82c8[] = { 147, i, 130, 200, 0 };
S se981Yg[] = { 233, 129, 98, a };
S s837882[] = { 131, x, 130, 0 };
S se781[] = { 231, 129, 0 };
S s90ab[] = { 144, 171, 0 };
S s92b2[] = { 146, 178, 0 };
S s82bb82[] = { 130, 187, 130, 0 };
S s8fT[] = { 143, 227, 0 };
S s838b[] = { 131, 139, 0 };
S sz82c6[] = { v, 130, 198, 0 };
S s8azg[] = { 138, v, a };
S s83n83[] = { 131, j, 131, 0 };
S sY83[] = { 98, 131, 0 };
S s82b581[] = { 130, 181, 129, 0 };
S sL82[] = { 219, 130, 0 };
S s82x[] = { 130, t, 0 };
S s8b82[] = { 139, 130, 0 };
S s838c83[] = { 131, 140, 131, 0 };
S s82Q81[] = { 130, 224, 129, 0 };
S s90ec[] = { 144, 236, 0 };
S sv82[] = { r, 130, 0 };
S sn82[] = { j, 130, 0 };
S s8cs[] = { 140, o, 0 };
S s9182cc[] = { 145, 130, 204, 0 };
S s96b1[] = { 150, 177, 0 };
S s88c0[] = { 136, 192, 0 };
S s8e9f[] = { 142, 159, 0 };
S scc8f[] = { 204, 143, 0 };
S sg82c9[] = { 32, 130, 201, 0 };
S s82c882a2[] = { 130, 200, 130, 162, 0 };
S s8c83[] = { 140, 131, 0 };
S s83l83[] = { 131, h, 131, 0 };
S sl83[] = { h, 131, 0 };
S s7a82[] = { z, 130, 0 };
S s8e96[] = { 142, 150, 0 };
S sba82[] = { 186, 130, 0 };
S sa782[] = { 167, 130, 0 };
S s8bad[] = { 139, 173, 0 };
S s814082[] = { 129, 64, 130, 0 };
S sQ81[] = { 224, 129, 0 };
S s8cbb[] = { 140, 187, 0 };
S s82e981Y[] = { 130, 233, 129, 98, 0 };
S s97cd82[] = { 151, 205, 130, 0 };
S s8bc6[] = { 139, 198, 0 };
S s81n[] = { 129, j, 0 };
S sb581[] = { 181, 129, 0 };
S s91w[] = { 145, s, 0 };
S s8dQ[] = { 141, 224, 0 };
S sf094[] = { 240, 148, 0 };
S sc882a2[] = { 200, 130, 162, 0 };
S s81X83[] = { 129, 97, 131, 0 };
S s8eg[] = { 142, a };
S scc89[] = { 204, 137, 0 };
S s89c6[] = { 137, 198, 0 };
S s5c91[] = { 92, 145, 0 };
S s82c2[] = { 130, 194, 0 };
S sQ90ad[] = { 224, 144, 173, 0 };
S s82cb[] = { 130, 203, 0 };
S sc182c482[] = { 193, 130, 196, 130, 0 };
S s82s[] = { 130, o, 0 };
S sab82e9[] = { 171, 130, 233, 0 };
S sm82c8[] = { i, 130, 200, 0 };
S s88ea[] = { 136, 234, 0 };
S s8fac[] = { 143, 172, 0 };
S ss8d[] = { o, 141, 0 };
S s81X9286[] = { 129, 97, 146, 134, 0 };
S s8d9182cc[] = { 141, 145, 130, 204, 0 };
S s82u94[] = { 130, q, 148, 0 };
S sS82[] = { 226, 130, 0 };
S s82cc96[] = { 130, 204, 150, 0 };
S sfa82[] = { 250, 130, 0 };
S sN82[] = { 221, 130, 0 };
S sc582b7[] = { 197, 130, 183, 0 };

N l27n0[] = { { sr95fb, .106 }, { sS82, .091 }, H };
N l27n1[] = { { sc182, .498 }, { s89ca, .106 }, H };
N l27n2[] = { { sa082, .196 }, { s88ea, .075 }, H };
N l27n3[] = { { s82bf82, .158 }, H };
N l27n4[] = { { s82W, .106 }, H };
N l27n6[] = { { s82c8, .709 }, { sa982e7, .362 }, H };
N l27n7[] = { { s82b9, .106 }, { sfb82, .136 }, H };
N l27n8[] = { { s82aa, .392 }, H };
N l27n9[] = { { sb982, .166 }, { s82cd81X, .272 }, H };
N l27n10[] = { { sbd81Yg, .226 }, H };
N l27n11[] = { { s81z82, .181 }, { s_82, .070 }, H };
N l27n16[] = { { s81X, 1.282 }, H };
N l27n17[] = { { sb182, .241 }, { scc8d, .181 }, { s82ed82, .136 }, H };
N l27n19[] = { { sc981X, .238 }, { sadg, .113 }, H };
N l27n21[] = { { s82e7, .422 }, { s82M82b7, .392 }, { s82b182, .249 }, H };
N l27n22[] = { { s82a282, .634 }, H };
N l27n23[] = { { s82c9, .935 }, H };
N l27n24[] = { { sca82, .158 }, { s838b, .075 }, H };
N l27n25[] = { { sa982, .513 }, { s82ab, .226 }, { sb182c682, .181 }, H };
N l27n26[] = { { s96f0, .091 }, H };
N l27n27[] = { { sk82, .101 }, { s835e, .106 }, { sg8b, .075 }, H };
N l27n28[] = { { sX8d, .060 }, { s90ec, .075 }, H };
N l27n29[] = { { sc582Q, .170 }, { s82s, .075 }, H };
N l27n31[] = { { s82e982c6, .211 }, { s81X8d, .113 }, { sQ90ad, .170 }, H };
N l27n32[] = { { sc182bd, .306 }, { sfc8azg, .339 }, H };
N l27n33[] = { { s81Y, .694 }, H };
N l27n34[] = { { scc8e, .249 }, H };
N l27n35[] = { { sM82b7, .441 }, { s82P82, .226 }, H };
N l27n36[] = { { ss83, .050 }, H };
N l27n37[] = { { s82c182, .475 }, { sg82c9, .113 }, H };
N l27n38[] = { { s82e8, .498 }, H };
N l27n39[] = { { sL82, .113 }, H };
N l27n40[] = { { s8e96, .075 }, { sba82, .075 }, H };
N l27n41[] = { { s838c, .091 }, { s82bb, .075 }, { s82Q81, .113 }, H };
N l27n42[] = { { s7882, .181 }, { s81X8e, .158 }, H };
N l27n43[] = { { s83r, .075 }, H };
N l27n45[] = { { sX8e, .070 }, H };
N l27n46[] = { { s82t, .272 }, { se882M, .306 }, H };
N l27n48[] = { { sbd81Y82, .181 }, H };
N l27n49[] = { { sg8140, .407 }, { s9182, .106 }, { s82c98e, .158 }, H };
N l27n50[] = { { st82, .121 }, { s90p82, .136 }, { s91w, .075 }, H };
N l27n51[] = { { scc8f, .113 }, H };
N l27n52[] = { { s82Q82, .158 }, H };
N l27n54[] = { { s82b782e9, .272 }, H };
N l27n55[] = { { s82e9, .588 }, { s82b382, .181 }, { sr95, .070 }, H };
N l27n56[] = { { saa82, .196 }, { s82a482, .226 }, { s8f_, .075 }, { s88c0, .075 }, H };
N l27n57[] = { { s82cb, .075 }, H };
N l27n58[] = { { s94r, .196 }, { sf08a, .158 }, H };
N l27n59[] = { { s82ad, .392 }, { s7883, .060 }, H };
N l27n61[] = { { sg8d, .091 }, H };
N l27n62[] = { { s82c482a2, .241 }, H };
N l27n63[] = { { s82u, .121 }, H };
N l27n64[] = { { sa282, .438 }, { s81X90, .226 }, H };
N l27n65[] = { { s89fc8a, .204 }, { s839383, .113 }, H };
N l27n66[] = { { s82a982e7, .483 }, H };
N l27n68[] = { { s82f082, .204 }, H };
N l27n69[] = { { s9085, .091 }, H };
N l27n70[] = { { sM82, .611 }, { s90z, .091 }, H };
N l27n71[] = { { sbb82, .151 }, H };
N l27n72[] = { { s82ea, .196 }, H };
N l27n74[] = { { s82cc, 1.358 }, { s8d9182, .136 }, H };
N l27n75[] = { { s82bd, .769 }, { sl83, .050 }, H };
N l27n76[] = { { s827882, .158 }, H };
N l27n77[] = { { s82c481, .204 }, { sc481, .204 }, { s82a282bd, .181 }, H };
N l27n78[] = { { s82b581, .113 }, H };
N l27n79[] = { { sX90, .121 }, { sb382, .151 }, H };
N l27n80[] = { { s82e882M, .272 }, { sb781Yg, .317 }, { s82v, .106 }, H };
N l27n82[] = { { s8bad, .075 }, { s8eg, .113 }, H };
N l27n83[] = { { s89fc, .136 }, { s8cs, .075 }, H };
N l27n84[] = { { sc482a2, .272 }, { s92r95fb, .211 }, { sb782e982, .181 }, { s82c882e8, .181 }, H };
N l27n85[] = { { s95aa, .166 }, { s82f182, .181 }, { scc91, .158 }, { sed82, .158 }, H };
N l27n86[] = { { scc82, .294 }, { s81X92, .181 }, H };
N l27n87[] = { { sab82, .211 }, H };
N l27n88[] = { { s82c482, .520 }, { s8f97, .091 }, { sc882e882, .226 }, H };
N l27n89[] = { { s82b582, .973 }, { sm82, .181 }, { s82cc8d, .181 }, H };
N l27n90[] = { { s82M, .438 }, { sab82e9, .113 }, { sc582b7, .136 }, H };
N l27n91[] = { { s82cd, .513 }, { se982c6, .238 }, H };
N l27n92[] = { { s82be, .211 }, { s82c182bd, .272 }, { s93m82, .204 }, { sf08c, .136 }, { sc582ab82, .272 }, H };
N l27n93[] = { { s82af, .166 }, { sV82, .113 }, { s81z82c6, .151 }, H };
N l27n94[] = { { sc482, .588 }, { s82a0, .121 }, { se981Yg, .339 }, H };
N l27n95[] = { { sa282bd, .136 }, { s8cbb, .075 }, H };
N l27n96[] = { { sX91, .060 }, { s97a7, .091 }, H };
N l27n97[] = { { sX82, .231 }, H };
N l27n98[] = { { s4082, .080 }, { s8c8e, .091 }, H };
N l27n99[] = { { s92r95, .158 }, { sz89, .060 }, { sc682b5, .204 }, H };
N l27n100[] = { { s82cc8e, .249 }, { s81y, .166 }, { scd81, .226 }, { s8fT, .075 }, H };
N l27n101[] = { { sN82, .091 }, H };
N l27n102[] = { { scc92, .158 }, { s83l83, .113 }, H };
N l27n103[] = { { s82b182c6, .181 }, H };
N l27n104[] = { { s7a82, .050 }, H };
N l27n105[] = { { s82c582, .566 }, { s90m, .091 }, H };
N l27n106[] = { { szg, .106 }, { s82c582ab, .181 }, { s82ab82e9, .151 }, H };
N l27n107[] = { { s8ea9, .091 }, { s82N, .075 }, { s837882, .113 }, H };
N l27n108[] = { { s93af, .091 }, H };
N l27n109[] = { { s82bf, .136 }, { sc182c4, .306 }, H };
N l27n110[] = { { sz82c6, .075 }, H };
N l27n111[] = { { s82cc8f, .113 }, H };
N l27n112[] = { { s82b781, .385 }, { s82c481X, .241 }, { sv82, .050 }, H };
N l27n113[] = { { sg81, .362 }, { s82c182c4, .272 }, { sX92, .080 }, H };
N l27n114[] = { { sX83, .070 }, { s82x, .075 }, H };
N l27n116[] = { { sbd81, .256 }, H };
N l27n117[] = { { scd82, .362 }, { s81z, .181 }, { s814082, .113 }, H };
N l27n118[] = { { sb781Y82, .241 }, { s89ef, .106 }, { s837883, .136 }, H };
N l27n119[] = { { s8b82, .075 }, H };
N l27n120[] = { { sc481X, .272 }, { sn82, .050 }, H };
N l27n122[] = { { s82c682, .702 }, H };
N l27n123[] = { { s82b782, .294 }, { s82ed, .106 }, H };
N l27n124[] = { { sW82, .339 }, { s97cd82, .113 }, { sb581, .075 }, H };
N l27n125[] = { { sc582, .611 }, H };
N l27n126[] = { { sa482, .166 }, { sf08e, .181 }, H };
N l27n127[] = { { s82b1, .166 }, { sb582c482, .272 }, H };
N l27n128[] = { { s82a2, .498 }, { sY82, .171 }, { s9383, .075 }, { s92b2, .075 }, H };
N l27n129[] = { { s81Yg, .713 }, H };
N l27n130[] = { { sg82, .634 }, { s82c882a2, .151 }, H };
N l27n131[] = { { s82y, .075 }, H };
N l27n132[] = { { sad81, .106 }, H };
N l27n133[] = { { sbd82, .468 }, { s82cc91, .158 }, H };
N l27n134[] = { { s90b6, .121 }, H };
N l27n136[] = { { s83n83, .113 }, H };
N l27n137[] = { { sn83, .060 }, H };
N l27n138[] = { { se781, .113 }, H };
N l27n140[] = { { s8az, .136 }, H };
N l27n141[] = { { sb582, .649 }, { s82a982, .724 }, { s82P, .196 }, H };
N l27n143[] = { { s82c1, .317 }, { sw82, .091 }, { scd81X, .306 }, H };
N l27n144[] = { { s82b582bd, .332 }, { s82cc92, .158 }, H };
N l27n145[] = { { sY83, .050 }, H };
N l27n147[] = { { sg83, .287 }, { sb182c6, .181 }, H };
N l27n148[] = { { s9286, .196 }, { s8ca0, .091 }, H };
N l27n149[] = { { sad82, .332 }, H };
N l27n150[] = { { s82b781Y, .513 }, H };
N l27n152[] = { { s81m, .091 }, H };
N l27n153[] = { { s82c682b5, .181 }, H };
N l27n154[] = { { s82W82, .158 }, H };
N l27n155[] = { { se782, .362 }, { s82u94, .091 }, H };
N l27n156[] = { { s82c882, .792 }, { sc682, .747 }, { s90p, .151 }, { s82f08a, .113 }, H };
N l27n157[] = { { s8a_, .136 }, { s82b982, .158 }, H };
N l27n158[] = { { s82Q, .287 }, { s82aa82, .181 }, H };
N l27n160[] = { { sf090, .158 }, { s8393, .106 }, { s82c2, .075 }, H };
N l27n161[] = { { s82b3, .121 }, H };
N l27n162[] = { { s82a4, .241 }, { s82c981, .158 }, H };
N l27n163[] = { { sP82, .317 }, { s89fc8az, .272 }, { sc182bd81, .317 }, H };
N l27n164[] = { { sbe82, .196 }, H };
N l27n165[] = { { s82b582c4, .543 }, H };
N l27n166[] = { { s81X82, .475 }, { sM82b781, .543 }, H };
N l27n167[] = { { s8c83, .075 }, H };
N l27n169[] = { { s81n, .075 }, H };
N l27n170[] = { { sbd81Y, .272 }, H };
N l27n171[] = { { s82e782, .272 }, H };
N l27n172[] = { { sb582bd, .249 }, { sb682, .091 }, H };
N l27n173[] = { { s82c982, .453 }, { s93Q, .075 }, H };
N l27n174[] = { { s82f0, .875 }, { sfc8a, .204 }, { sx82, .060 }, { s8d9182cc, .121 }, H };
N l27n175[] = { { s82ab82, .226 }, H };
N l27n176[] = { { s8e9e, .075 }, { sQ90, .113 }, H };
N l27n177[] = { { sQ81, .113 }, { s81X83, .113 }, H };
N l27n178[] = { { sf082, .294 }, { s82f08c, .136 }, H };
N l27n179[] = { { s8eu, .075 }, H };
N l27n180[] = { { s8d91, .151 }, { se882M82, .407 }, { s93m82c8, .151 }, H };
N l27n182[] = { { sp82, .101 }, { s95fb, .136 }, { s8278, .106 }, { s8dw, .106 }, H };
N l27n183[] = { { s81Y82, .339 }, H };
N l27n186[] = { { se882, .498 }, { sb781, .287 }, H };
N l27n187[] = { { sc782, .158 }, H };
N l27n188[] = { { s82e882, .407 }, { sa682, .091 }, { s82cc96, .091 }, H };
N l27n189[] = { { s8582, .091 }, { s89c6, .075 }, { s8fac, .060 }, H };
N l27n191[] = { { s81g, .294 }, { s82f1, .151 }, { s8dec, .091 }, { s82bb82, .113 }, H };
N l27n192[] = { { sfc8az, .306 }, { s82S, .106 }, H };
N l27n193[] = { { s8e9f, .075 }, H };
N l27n194[] = { { s82c4, .709 }, { sQ82, .204 }, { s82e981, .136 }, H };
N l27n195[] = { { s82b5, .785 }, { sbf82, .106 }, H };
N l27n196[] = { { s91V, .181 }, { s82t82, .181 }, { s83_, .075 }, H };
N l27n197[] = { { s82c981X, .211 }, { sc98e, .158 }, { s83l, .075 }, { s5c91, .050 }, H };
N l27n198[] = { { s93m, .136 }, H };
N l27n200[] = { { s82f08e, .181 }, { se981, .136 }, H };
N l27n202[] = { { s838c83, .113 }, H };
N l27n203[] = { { sb782, .256 }, { s90ab, .075 }, H };
N l27n205[] = { { s82e982, .430 }, { scc89, .113 }, H };
N l27n206[] = { { sb782e9, .204 }, { ss8d, .040 }, H };
N l27n208[] = { { s94r82, .181 }, { sc882a2, .170 }, H };
N l27n209[] = { { s82ad82, .294 }, { sf182, .294 }, H };
N l27n210[] = { { sc882e8, .204 }, H };
N l27n211[] = { { s82c5, .664 }, { saf82, .196 }, H };
N l27n213[] = { { s8378, .196 }, H };
N l27n214[] = { { s82bd81, .385 }, { sc582ab, .204 }, H };
N l27n217[] = { { se982, .430 }, { s98X, .075 }, H };
N l27n218[] = { { sc882, .860 }, { sc482a282, .317 }, H };
N l27n219[] = { { sa782, .075 }, H };
N l27n222[] = { { s82ea82, .272 }, { s82f090, .158 }, H };
N l27n223[] = { { s8140, .317 }, { s9594, .121 }, H };
N l27n224[] = { { s82cc82, .249 }, H };
N l27n225[] = { { s82bd82, .566 }, H };
N l27n226[] = { { sc082, .136 }, H };
N l27n228[] = { { s82c6, .800 }, { sf094, .113 }, H };
N l27n229[] = { { s82b7, .513 }, { sa282bd82, .151 }, H };
N l27n230[] = { { s82cd81, .226 }, { s97cd, .106 }, H };
N l27n231[] = { { s83n, .121 }, H };
N l27n232[] = { { sc981, .181 }, { s82e981Y, .151 }, { s81X9286, .121 }, { sfa82, .091 }, H };
N l27n233[] = { { sc682b582, .272 }, H };
N l27n235[] = { { s96b1, .075 }, H };
N l27n236[] = { { sz82, .201 }, { s8azg, .170 }, H };
N l27n237[] = { { s90ad, .151 }, H };
N l27n240[] = { { s82M82, .611 }, { sb781Y, .407 }, H };
N l27n241[] = { { s82cd82, .226 }, { s89ba, .091 }, { sm82c8, .075 }, H };
N l27n242[] = { { s82be82, .272 }, { s8ec0, .091 }, H };
N l27n243[] = { { s82af82, .158 }, { s8dQ, .075 }, { sc182c482, .226 }, H };
N l27n244[] = { { sr82, .131 }, { s82a082, .181 }, H };
N l27n245[] = { { s82c7, .121 }, { s9182cc, .113 }, H };
N l27n247[] = { { s82a9, .528 }, H };
N l27n248[] = { { sea82, .339 }, H };
N l27n249[] = { { sc982, .453 }, { sb582c4, .407 }, H };
N l27n250[] = { { sa882, .106 }, H };
N l27n251[] = { { s8bc6, .075 }, H };
N l27n252[] = { { s92r, .241 }, { s82bd81Y, .362 }, H };
N l27n254[] = { { sYg, .317 }, { se981Y, .170 }, H };

D l27_d = {
	"japanese",
	"shift_jis",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    0.010, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.004, W, 0.004, W,
	    0.002, 0.039, 0.021, 0.005, 0.004, 0.004, 0.001, 0.006, 0.005, 0.012, 0.007, 0.004, 0.007, 0.001, 0.014, 0.008,
	    0.010, 0.006, 0.006, 0.009, 0.005, 0.006, 0.017, 0.010, 0.011, 0.004, 0.007, W, W, W, 0.003, W,
	    0.002, 0.134, 0.697, 0.077, 0.006, 0.006, 0.008, 0.004, 0.019, 0.040, 0.037, 0.034, 0.045, 0.056, 0.062, 0.034,
	    0.060, 0.044, 0.039, 0.048, 0.032, 0.036, 0.039, 0.039, 0.005, 0.002, 0.002, 0.001, Y, 0.005, 0.004, 0.004,
	    0.011, 0.004, 0.024, 0.001, 0.011, 0.001, 0.005, 0.005, 0.004, 0.028, 0.025, 0.013, 0.007, 0.030, 0.004, 0.015,
	    0.005, 0.011, 0.004, 0.010, 0.003, 0.031, 0.008, 0.025, 0.004, 0.007, 0.005, 0.009, 0.004, 0.036, 0.010, 0.007,
	    0.010, 0.022, 0.006, 0.004, 0.048, 0.043, 0.058, 0.012, 0.047, 0.060, 0.011, 0.005, 0.086, 0.040, 0.006, 0.007,
	    0.004, 0.002, V, 0.001, 0.003, 0.001, 0.005, 0.005, 0.004, 0.005, 0.005, 0.010, 0.027, 0.008, 0.002, 0.015,
	    0.028, 0.003, 0.010, 0.006, 0.002, 0.017, 0.019, 0.032, 0.036, 0.036, 0.020, 0.004, 0.015, 0.010, 0.003, 0.006,
	    0.062, 0.017, V, 0.005, 0.002, 0.004, 0.003, 0.001, 0.004, 0.001, 0.006, 0.014, 0.015, V, V, V },
	{ l27n0, l27n1, l27n2, l27n3, l27n4, X, l27n6, l27n7, l27n8, l27n9, l27n10, l27n11, X, X, X, X,
	    l27n16, l27n17, X, l27n19, X, l27n21, l27n22, l27n23, l27n24, l27n25, l27n26, l27n27, l27n28, l27n29, X, l27n31,
	    l27n32, l27n33, l27n34, l27n35, l27n36, l27n37, l27n38, l27n39, l27n40, l27n41, l27n42, l27n43, X, l27n45, l27n46, X,
	    l27n48, l27n49, l27n50, l27n51, l27n52, X, l27n54, l27n55, l27n56, l27n57, l27n58, l27n59, X, l27n61, l27n62, l27n63,
	    l27n64, l27n65, l27n66, X, l27n68, l27n69, l27n70, l27n71, l27n72, X, l27n74, l27n75, l27n76, l27n77, l27n78, l27n79,
	    l27n80, X, l27n82, l27n83, l27n84, l27n85, l27n86, l27n87, l27n88, l27n89, l27n90, l27n91, l27n92, l27n93, l27n94, l27n95,
	    l27n96, l27n97, l27n98, l27n99, l27n100, l27n101, l27n102, l27n103, l27n104, l27n105, l27n106, l27n107, l27n108, l27n109, l27n110, l27n111,
	    l27n112, l27n113, l27n114, X, l27n116, l27n117, l27n118, l27n119, l27n120, X, l27n122, l27n123, l27n124, l27n125, l27n126, l27n127,
	    l27n128, l27n129, l27n130, l27n131, l27n132, l27n133, l27n134, X, l27n136, l27n137, l27n138, X, l27n140, l27n141, X, l27n143,
	    l27n144, l27n145, X, l27n147, l27n148, l27n149, l27n150, X, l27n152, l27n153, l27n154, l27n155, l27n156, l27n157, l27n158, X,
	    l27n160, l27n161, l27n162, l27n163, l27n164, l27n165, l27n166, l27n167, X, l27n169, l27n170, l27n171, l27n172, l27n173, l27n174, l27n175,
	    l27n176, l27n177, l27n178, l27n179, l27n180, X, l27n182, l27n183, X, X, l27n186, l27n187, l27n188, l27n189, X, l27n191,
	    l27n192, l27n193, l27n194, l27n195, l27n196, l27n197, l27n198, X, l27n200, X, l27n202, l27n203, X, l27n205, l27n206, X,
	    l27n208, l27n209, l27n210, l27n211, X, l27n213, l27n214, X, X, l27n217, l27n218, l27n219, X, X, l27n222, l27n223,
	    l27n224, l27n225, l27n226, X, l27n228, l27n229, l27n230, l27n231, l27n232, l27n233, X, l27n235, l27n236, l27n237, X, X,
	    l27n240, l27n241, l27n242, l27n243, l27n244, l27n245, X, l27n247, l27n248, l27n249, l27n250, l27n251, l27n252, X, l27n254, X }
};

//
// Lng: norwegian
// Enc: iso-8859-15
//

S sglXr[] = { 32, h, 97, n, 0 };
S slXrg[] = { h, 97, n, a };
S slyr[] = { h, u, n, 0 };
S slyrg[] = { h, u, n, a };
S sglyr[] = { 32, h, u, n, 0 };
S sglXv[] = { 32, h, 97, r, 0 };
S sgwsq[] = { 32, s, o, m, 0 };
S swsqg[] = { s, o, m, a };
S sgtV[] = { 32, p, 229, 0 };
S stVg[] = { p, 229, a };
S sgtVg[] = { 32, p, 229, a };
S stV[] = { p, 229, 0 };
S sVv[] = { 229, r, 0 };
S sirri[] = { e, n, n, e, 0 };
S sVvg[] = { 229, r, a };
S srrig[] = { n, n, e, a };
S sglXq[] = { 32, h, 97, m, 0 };
S swxig[] = { s, t, e, a };
S slXqg[] = { h, 97, m, a };
S stirg[] = { p, e, n, a };
S sXqg[] = { 97, m, a };
S slXq[] = { h, 97, m, 0 };
S sglir[] = { 32, h, e, n, 0 };
S sXzg[] = { 97, v, a };
S sglz[] = { 32, h, v, 0 };
S swVg[] = { s, 229, a };
S swV[] = { s, 229, 0 };
S swik[] = { s, e, g, 0 };
S sgXzg[] = { 32, 97, v, a };
S sgVg[] = { 32, 229, a };
S sgwV[] = { 32, s, 229, 0 };
S sgwVg[] = { 32, s, 229, a };
S sXrk[] = { 97, n, g, 0 };
S sgwik[] = { 32, s, e, g, 0 };
S swikg[] = { s, e, g, a };
S sqih[] = { m, e, d, 0 };
S sgqih[] = { 32, m, e, d, 0 };
S sirig[] = { e, n, e, a };
S syrrm[] = { u, n, n, i, 0 };
S slirr[] = { h, e, n, n, 0 };
S sqihg[] = { m, e, d, a };
S soXrg[] = { k, 97, n, a };
S skXr[] = { g, 97, n, 0 };
S sgyrr[] = { 32, u, n, n, 0 };
S soivg[] = { k, e, r, a };
S sgky[] = { 32, g, u, 0 };
S spmkg[] = { l, i, g, a };
S sqivg[] = { m, e, r, a };
S srsi[] = { n, o, e, 0 };
S sf8vg[] = { 248, r, a };
S sgrsi[] = { 32, n, o, e, 0 };
S spXr[] = { l, 97, n, 0 };
S srV[] = { n, 229, 0 };
S sgmrr[] = { 32, i, n, n, 0 };
S sgrV[] = { 32, n, 229, 0 };
S sgzmp[] = { 32, v, i, l, 0 };
S ssir[] = { o, e, n, 0 };
S swzX[] = { s, v, 97, 0 };
S szmp[] = { v, i, l, 0 };
S sqXrr[] = { m, 97, n, n, 0 };
S sirki[] = { e, n, g, e, 0 };
S sgwiv[] = { 32, s, e, r, 0 };
S skXrk[] = { g, 97, n, g, 0 };
S szmr[] = { v, i, n, 0 };
S swti[] = { s, p, e, 0 };
S sqip[] = { m, e, l, 0 };
S siwti[] = { e, s, p, e, 0 };
S sipmk[] = { e, l, i, g, 0 };
S siwt[] = { e, s, p, 0 };
S skV[] = { g, 229, 0 };
S snf8[] = { j, 248, 0 };
S sgmrk[] = { 32, i, n, g, 0 };
S sgoz[] = { 32, k, v, 0 };
S sgkXr[] = { 32, g, 97, n, 0 };
S sqqiv[] = { m, m, e, r, 0 };
S sknf8v[] = { g, j, 248, r, 0 };
S snikg[] = { j, e, g, a };
S sgiwt[] = { 32, e, s, p, 0 };
S sipwo[] = { e, l, s, k, 0 };
S srVg[] = { n, 229, a };
S ssvk[] = { o, r, g, 0 };
S szixg[] = { v, e, t, a };
S soirg[] = { k, e, n, a };
S shx[] = { d, t, 0 };

N l28n0[] = { { stt, .105 }, { srrg, .236 }, H };
N l28n2[] = { { sqirg, .314 }, H };
N l28n3[] = { { ssv, .707 }, H };
N l28n5[] = { { smr, .445 }, { sxm, .327 }, { sgrV, .177 }, H };
N l28n6[] = { { srx, .183 }, { sgwm, .177 }, { sgYp, .147 }, H };
N l28n7[] = { { sri, .681 }, { slir, .236 }, { sxivg, .314 }, H };
N l28n8[] = { { swo, .367 }, { srsi, .138 }, H };
N l28n9[] = { { slX, 1.048 }, { sxmpg, .550 }, H };
N l28n10[] = { { soig, .589 }, { sYp, .092 }, H };
N l28n11[] = { { sipp, .118 }, H };
N l28n12[] = { { sgskg, 1.454 }, { sgp, .373 }, H };
N l28n13[] = { { sXr, 1.166 }, { spm, .301 }, { swg, .334 }, { sgzi, .354 }, { sgoz, .177 }, H };
N l28n14[] = { { ssqg, .825 }, H };
N l28n15[] = { { swik, .177 }, { sgwik, .354 }, H };
N l28n16[] = { { soo, .327 }, H };
N l28n18[] = { { sik, .262 }, H };
N l28n20[] = { { skiv, .138 }, { ssw, .079 }, H };
N l28n21[] = { { sgV, .275 }, { sog, .196 }, H };
N l28n23[] = { { slyr, .373 }, { sgxm, .472 }, { sxxi, .216 }, { shivg, .275 }, H };
N l28n24[] = { { slXqg, .432 }, H };
N l28n25[] = { { sglyr, .747 }, { swp, .092 }, H };
N l28n28[] = { { sgwo, .265 }, H };
N l28n29[] = { { sgq, .786 }, { sqqiv, .131 }, H };
N l28n31[] = { { sgli, .383 }, { sipmk, .157 }, H };
N l28n32[] = { { soXr, .177 }, { sxxg, .265 }, H };
N l28n33[] = { { sxig, .648 }, { srirg, .236 }, H };
N l28n34[] = { { swV, .131 }, { sgrsi, .275 }, H };
N l28n35[] = { { slXrg, 1.611 }, { srrm, .177 }, H };
N l28n36[] = { { sivi, .177 }, H };
N l28n37[] = { { stVg, .413 }, { sghir, .432 }, { sirki, .157 }, { ssx, .065 }, H };
N l28n38[] = { { sgoX, .383 }, { ssi, .118 }, H };
N l28n39[] = { { sgtV, .413 }, H };
N l28n41[] = { { srk, .419 }, { spig, .265 }, H };
N l28n43[] = { { skipw, .131 }, H };
N l28n44[] = { { sxg, 2.220 }, { sqm, .065 }, { sgkXr, .196 }, H };
N l28n45[] = { { sivg, 2.771 }, { shixg, .825 }, { svs, .105 }, H };
N l28n46[] = { { ski, .445 }, { sgr, .531 }, { sqivg, .275 }, H };
N l28n48[] = { { sgwiv, .236 }, H };
N l28n49[] = { { shig, .531 }, H };
N l28n51[] = { { syrr, .196 }, H };
N l28n52[] = { { spg, .570 }, { sim, .144 }, { sqih, .177 }, H };
N l28n55[] = { { sghix, .668 }, H };
N l28n57[] = { { sgmg, .501 }, { sgzm, .354 }, H };
N l28n58[] = { { sglXq, .432 }, H };
N l28n59[] = { { sghig, .314 }, H };
N l28n60[] = { { shg, .393 }, H };
N l28n61[] = { { sglXr, 1.808 }, { sYs, .079 }, { svir, .118 }, H };
N l28n62[] = { { sky, .092 }, H };
N l28n63[] = { { sgs, 1.179 }, { sihg, .324 }, { svX, .118 }, { spXr, .138 }, H };
N l28n64[] = { { spp, .223 }, { sirig, .314 }, H };
N l28n65[] = { { sgni, .177 }, H };
N l28n67[] = { { szm, .249 }, { smpg, .531 }, { sirr, .275 }, H };
N l28n69[] = { { sti, .236 }, H };
N l28n72[] = { { ssk, .511 }, { sgws, .560 }, { skirg, .393 }, H };
N l28n73[] = { { sglXv, .668 }, H };
N l28n75[] = { { srm, .144 }, H };
N l28n76[] = { { sws, .262 }, H };
N l28n77[] = { { sli, .236 }, { sVv, .383 }, { sgXx, .324 }, { srhi, .138 }, H };
N l28n78[] = { { sgsqg, .354 }, { snf8, .079 }, H };
N l28n79[] = { { sixg, 1.444 }, { slXvg, .668 }, { sgir, .472 }, { ssvh, .157 }, H };
N l28n80[] = { { sgt, .452 }, H };
N l28n81[] = { { sXv, .485 }, { sgX, .629 }, { slirr, .210 }, H };
N l28n83[] = { { sqg, .806 }, H };
N l28n84[] = { { sos, .157 }, H };
N l28n86[] = { { sio, .092 }, H };
N l28n87[] = { { srrig, .432 }, { syp, .079 }, H };
N l28n88[] = { { swxig, .432 }, { sipw, .177 }, { snikg, .196 }, H };
N l28n90[] = { { smw, .275 }, { sgwV, .265 }, H };
N l28n91[] = { { sig, 2.712 }, { swsqg, .629 }, { sgxmp, .589 }, { szixg, .196 }, H };
N l28n92[] = { { sXqg, .324 }, { swir, .138 }, { s79i, .079 }, H };
N l28n93[] = { { sly, .301 }, { swt, .118 }, H };
N l28n94[] = { { swX, .105 }, { sqXr, .118 }, H };
N l28n95[] = { { stirg, .432 }, { sgyr, .295 }, { swoi, .157 }, H };
N l28n98[] = { { sgY, .550 }, { sXw, .079 }, H };
N l28n99[] = { { ssvg, .648 }, { sgXz, .354 }, { sgpi, .177 }, H };
N l28n100[] = { { soir, .118 }, H };
N l28n102[] = { { soX, .236 }, H };
N l28n103[] = { { sip, .445 }, { srig, .766 }, { sooi, .432 }, H };
N l28n105[] = { { sglir, .393 }, H };
N l28n106[] = { { szg, .275 }, H };
N l28n107[] = { { sgjs, .884 }, { smoo, .275 }, { smx, .131 }, H };
N l28n108[] = { { sWv, .295 }, { smi, .105 }, H };
N l28n109[] = { { sXrg, 1.474 }, { sro, .079 }, H };
N l28n110[] = { { slz, .157 }, { syrrm, .210 }, H };
N l28n111[] = { { swikg, .354 }, { sXxx, .118 }, H };
N l28n112[] = { { sqq, .170 }, { sgoXr, .354 }, { sYv, .079 }, { ssvk, .098 }, H };
N l28n113[] = { { svw, .118 }, H };
N l28n114[] = { { srg, 3.380 }, { sgv, .373 }, { sikg, .442 }, { sgmo, .354 }, { sirri, .314 }, { smrk, .236 }, { svh, .105 }, H };
N l28n115[] = { { sXx, .275 }, { sps, .157 }, H };
N l28n116[] = { { sgqi, .589 }, { skivg, .275 }, H };
N l28n117[] = { { sgVg, .265 }, H };
N l28n119[] = { { slyrg, .747 }, H };
N l28n120[] = { { siq, .157 }, H };
N l28n121[] = { { syr, .472 }, H };
N l28n122[] = { { spmk, .236 }, { sXrk, .177 }, { sgxv, .177 }, H };
N l28n123[] = { { sgiv, .855 }, { sxir, .275 }, H };
N l28n125[] = { { sxX, .183 }, { sgzmp, .236 }, H };
N l28n127[] = { { sgwx, .324 }, H };
N l28n128[] = { { srki, .354 }, { soXrg, .314 }, H };
N l28n129[] = { { sknf8v, .131 }, H };
N l28n130[] = { { svx, .275 }, { swVg, .295 }, H };
N l28n131[] = { { sgw, 1.945 }, { svi, .511 }, { skn, .092 }, H };
N l28n132[] = { { sgh, 1.238 }, H };
N l28n133[] = { { spX, .210 }, H };
N l28n135[] = { { sgtVg, .550 }, { srV, .092 }, H };
N l28n136[] = { { swiv, .177 }, H };
N l28n137[] = { { sir, 1.808 }, { srkg, .265 }, H };
N l28n139[] = { { sni, .236 }, { shir, .236 }, { sghy, .265 }, H };
N l28n140[] = { { sqip, .118 }, { sgjv, .147 }, H };
N l28n141[] = { { shX, .118 }, H };
N l28n142[] = { { smk, .210 }, H };
N l28n143[] = { { sgwsq, .629 }, H };
N l28n144[] = { { sww, .105 }, { soiv, .138 }, H };
N l28n145[] = { { sgix, .265 }, { ssg, .138 }, H };
N l28n146[] = { { sqs, .092 }, H };
N l28n147[] = { { sgmr, .383 }, { sYi, .131 }, { svy, .105 }, H };
N l28n148[] = { { sgx, .688 }, { sqihg, .314 }, H };
N l28n149[] = { { sgi, 1.297 }, { sXz, .183 }, H };
N l28n150[] = { { sXk, .079 }, H };
N l28n151[] = { { sppi, .157 }, H };
N l28n153[] = { { skg, 1.395 }, { sipwo, .131 }, H };
N l28n154[] = { { sf8v, .531 }, { smooi, .314 }, H };
N l28n157[] = { { ssp, .105 }, H };
N l28n158[] = { { sxv, .144 }, H };
N l28n159[] = { { sjsv, .648 }, H };
N l28n160[] = { { srr, .576 }, { sgqih, .314 }, H };
N l28n161[] = { { swx, .498 }, { smrki, .210 }, { szXv, .138 }, { sgyx, .177 }, H };
N l28n162[] = { { swi, .524 }, { sqir, .177 }, H };
N l28n164[] = { { sqX, .131 }, { skXr, .157 }, H };
N l28n165[] = { { sgy, .373 }, { svk, .079 }, H };
N l28n166[] = { { sgj, 1.081 }, H };
N l28n167[] = { { sxiv, .314 }, H };
N l28n168[] = { { sskg, 1.091 }, { sqXrr, .157 }, H };
N l28n169[] = { { sxmp, .314 }, { szs, .105 }, { sox, .105 }, { sgyrr, .314 }, H };
N l28n170[] = { { soi, .563 }, H };
N l28n172[] = { { sgsk, 1.120 }, H };
N l28n173[] = { { sVvg, .796 }, { sgXxg, .354 }, H };
N l28n174[] = { { ssq, .498 }, { sgwX, .177 }, { siwt, .118 }, { skV, .079 }, H };
N l28n175[] = { { sgirg, .354 }, { spiv, .118 }, H };
N l28n176[] = { { stg, .118 }, H };
N l28n177[] = { { sXvg, .707 }, { srs, .170 }, H };
N l28n179[] = { { sgmoo, .472 }, H };
N l28n180[] = { { swti, .118 }, H };
N l28n182[] = { { sgz, .786 }, H };
N l28n183[] = { { sgk, .531 }, { spw, .118 }, { shiv, .177 }, H };
N l28n184[] = { { slXq, .216 }, { sph, .118 }, H };
N l28n185[] = { { sjs, .445 }, { sgYi, .236 }, H };
N l28n186[] = { { sgwVg, .354 }, H };
N l28n187[] = { { szX, .288 }, H };
N l28n190[] = { { sgky, .206 }, { sgqir, .236 }, H };
N l28n191[] = { { ssr, .170 }, { smrr, .216 }, { sgxX, .177 }, H };
N l28n192[] = { { sxx, .288 }, { sgos, .206 }, { shh, .079 }, H };
N l28n193[] = { { sxi, .773 }, { sgjsv, 1.179 }, { srir, .118 }, H };
N l28n195[] = { { slXr, .904 }, { sgXzg, .354 }, { swz, .118 }, { srX, .079 }, H };
N l28n196[] = { { soirg, .196 }, H };
N l28n197[] = { { stV, .183 }, H };
N l28n199[] = { { sooig, .550 }, { sqqi, .255 }, { sXrr, .138 }, { svm, .092 }, H };
N l28n200[] = { { sgl, 2.633 }, { spx, .118 }, { sgmrk, .236 }, H };
N l28n201[] = { { spi, .367 }, { sgvi, .206 }, H };
N l28n202[] = { { srkir, .210 }, H };
N l28n203[] = { { sjX, .079 }, { soz, .079 }, H };
N l28n205[] = { { siv, 1.520 }, { shix, .432 }, H };
N l28n206[] = { { sqiv, .138 }, H };
N l28n207[] = { { sgly, .619 }, H };
N l28n208[] = { { shx, .065 }, H };
N l28n209[] = { { shi, .865 }, H };
N l28n210[] = { { smo, .196 }, { skip, .118 }, H };
N l28n211[] = { { sXxg, .265 }, H };
N l28n213[] = { { sirh, .138 }, H };
N l28n214[] = { { sgiwt, .196 }, H };
N l28n215[] = { { smg, .589 }, H };
N l28n217[] = { { sgm, .924 }, { syrg, .560 }, { svxi, .118 }, { skXrk, .157 }, H };
N l28n218[] = { { sgwi, .619 }, { sglz, .295 }, { siwx, .177 }, { sXo, .118 }, { spmkg, .275 }, H };
N l28n219[] = { { sghi, 1.267 }, { sVg, 1.857 }, { sgivg, 1.140 }, { sxirg, .432 }, { syxx, .118 }, H };
N l28n221[] = { { sgmrr, .236 }, { siwti, .157 }, H };
N l28n222[] = { { siw, .301 }, H };
N l28n223[] = { { sih, .249 }, { sXg, .275 }, { syx, .170 }, H };
N l28n224[] = { { siri, .255 }, { ssir, .118 }, H };
N l28n225[] = { { shy, .131 }, { sgzX, .265 }, { sst, .079 }, H };
N l28n226[] = { { svxg, .236 }, H };
N l28n227[] = { { smp, .380 }, { svig, .383 }, H };
N l28n229[] = { { sziv, .118 }, H };
N l28n230[] = { { swm, .092 }, H };
N l28n231[] = { { szmp, .118 }, { srVg, .147 }, H };
N l28n232[] = { { sqi, .498 }, { skir, .275 }, { swivg, .314 }, H };
N l28n233[] = { { sirg, 2.594 }, { svo, .079 }, H };
N l28n234[] = { { skX, .105 }, { sgn, .138 }, { spz, .092 }, { sipm, .118 }, H };
N l28n235[] = { { sXp, .327 }, { shirg, .472 }, H };
N l28n237[] = { { sriv, .138 }, H };
N l28n238[] = { { svg, 3.163 }, { smkg, .265 }, { sgsq, .265 }, { swzX, .118 }, H };
N l28n239[] = { { six, .747 }, { slXv, .334 }, H };
N l28n240[] = { { soivg, .275 }, H };
N l28n241[] = { { sgixg, .275 }, H };
N l28n243[] = { { sglX, 2.328 }, { sgrs, .324 }, H };
N l28n245[] = { { srw, .196 }, { sXzg, .295 }, { sxvi, .098 }, H };
N l28n246[] = { { srh, .183 }, { sirk, .177 }, H };
N l28n247[] = { { srri, .432 }, H };
N l28n248[] = { { swxi, .314 }, H };
N l28n250[] = { { sf8vg, .464 }, H };
N l28n251[] = { { sgo, .668 }, { swsq, .334 }, { szix, .118 }, H };
N l28n252[] = { { sXq, .196 }, H };
N l28n253[] = { { szmr, .118 }, H };
N l28n254[] = { { sXrw, .196 }, H };
N l28n255[] = { { szi, .341 }, { sjsvg, .786 }, { stir, .216 }, { ssvx, .138 }, H };

D l28_d = {
	"norwegian",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.130, 0.020, 0.001, 0.071, 0.307, 0.039, 0.081, 0.076, 0.092, 0.016, 0.079, 0.093, 0.069, 0.207, 0.105,
	    0.034, W, 0.159, 0.115, 0.142, 0.046, 0.052, W, W, 0.011, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, 0.001, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, 0.074, 0.012, V, V, 0.001, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, 0.035, V, V, V, V, V, V, V },
	{ l28n0, X, l28n2, l28n3, X, l28n5, l28n6, l28n7, l28n8, l28n9, l28n10, l28n11, l28n12, l28n13, l28n14, l28n15,
	    l28n16, X, l28n18, X, l28n20, l28n21, X, l28n23, l28n24, l28n25, X, X, l28n28, l28n29, X, l28n31,
	    l28n32, l28n33, l28n34, l28n35, l28n36, l28n37, l28n38, l28n39, X, l28n41, X, l28n43, l28n44, l28n45, l28n46, X,
	    l28n48, l28n49, X, l28n51, l28n52, X, X, l28n55, X, l28n57, l28n58, l28n59, l28n60, l28n61, l28n62, l28n63,
	    l28n64, l28n65, X, l28n67, X, l28n69, X, X, l28n72, l28n73, X, l28n75, l28n76, l28n77, l28n78, l28n79,
	    l28n80, l28n81, X, l28n83, l28n84, X, l28n86, l28n87, l28n88, X, l28n90, l28n91, l28n92, l28n93, l28n94, l28n95,
	    X, X, l28n98, l28n99, l28n100, X, l28n102, l28n103, X, l28n105, l28n106, l28n107, l28n108, l28n109, l28n110, l28n111,
	    l28n112, l28n113, l28n114, l28n115, l28n116, l28n117, X, l28n119, l28n120, l28n121, l28n122, l28n123, X, l28n125, X, l28n127,
	    l28n128, l28n129, l28n130, l28n131, l28n132, l28n133, X, l28n135, l28n136, l28n137, X, l28n139, l28n140, l28n141, l28n142, l28n143,
	    l28n144, l28n145, l28n146, l28n147, l28n148, l28n149, l28n150, l28n151, X, l28n153, l28n154, X, X, l28n157, l28n158, l28n159,
	    l28n160, l28n161, l28n162, X, l28n164, l28n165, l28n166, l28n167, l28n168, l28n169, l28n170, X, l28n172, l28n173, l28n174, l28n175,
	    l28n176, l28n177, X, l28n179, l28n180, X, l28n182, l28n183, l28n184, l28n185, l28n186, l28n187, X, X, l28n190, l28n191,
	    l28n192, l28n193, X, l28n195, l28n196, l28n197, X, l28n199, l28n200, l28n201, l28n202, l28n203, X, l28n205, l28n206, l28n207,
	    l28n208, l28n209, l28n210, l28n211, X, l28n213, l28n214, l28n215, X, l28n217, l28n218, l28n219, X, l28n221, l28n222, l28n223,
	    l28n224, l28n225, l28n226, l28n227, X, l28n229, l28n230, l28n231, l28n232, l28n233, l28n234, l28n235, X, l28n237, l28n238, l28n239,
	    l28n240, l28n241, X, l28n243, X, l28n245, l28n246, l28n247, l28n248, X, l28n250, l28n251, l28n252, l28n253, l28n254, l28n255 }
};

//
// Lng: polish
// Enc: iso-8859-15
//

S sZ7a[] = { 99, z, 0 };
S ss_[] = { o, w, 0 };
S sh7a[] = { d, z, 0 };
S sg_g[] = { 32, w, a };
S smea[] = { i, 234, 0 };
S s79Z[] = { y, 99, 0 };
S s_79[] = { w, y, 0 };
S sZ7ai[] = { 99, z, e, 0 };
S siksg[] = { e, g, o, a };
S sX_[] = { 97, w, 0 };
S sXb3[] = { 97, 179, 0 };
S siks[] = { e, g, o, 0 };
S sb3s[] = { 179, o, 0 };
S sh7am[] = { d, z, i, 0 };
S sv7ai[] = { r, z, e, 0 };
S somi[] = { k, i, e, 0 };
S s7ami[] = { z, i, e, 0 };
S sf3_[] = { 243, w, 0 };
S s_mi[] = { w, i, e, 0 };
S sgtv7a[] = { 32, p, r, z, 0 };
S sh7ami[] = { d, z, i, e, 0 };
S sghsg[] = { 32, d, o, a };
S stv7a[] = { p, r, z, 0 };
S sbfi[] = { 191, e, 0 };
S sb3X[] = { 179, 97, 0 };
S s79Zl[] = { y, 99, h, 0 };
S s7aZ[] = { z, 99, 0 };
S s79q[] = { y, m, 0 };
S s_w[] = { w, s, 0 };
S s79Zlg[] = { y, 99, h, a };
S sbfig[] = { 191, e, a };
S sring[] = { n, e, j, a };
S ss_X[] = { o, w, 97, 0 };
S srin[] = { n, e, j, 0 };
S sw7aZ[] = { s, z, 99, 0 };
S sg_79[] = { 32, w, y, 0 };
S sw7aZ7a[] = { s, z, 99, z, 0 };
S s79qg[] = { y, m, a };
S s7aZ7a[] = { z, 99, z, 0 };
S stv7ai[] = { p, r, z, e, 0 };
S sgbfi[] = { 32, 191, e, 0 };
S sgbfig[] = { 32, 191, e, a };
S swom[] = { s, k, i, 0 };
S srmX[] = { n, i, 97, 0 };
S smin[] = { i, e, j, 0 };
S sv7a79[] = { r, z, y, 0 };
S sXb3g[] = { 97, 179, a };
S sgx79[] = { 32, t, y, 0 };
S sx_[] = { t, w, 0 };
S s79b3[] = { y, 179, 0 };
S smeag[] = { i, 234, a };
S sY79b3[] = { 98, y, 179, 0 };
S sb3sg[] = { 179, o, a };
S sming[] = { i, e, j, a };
S stvX_[] = { p, r, 97, w, 0 };
S sgtvX[] = { 32, p, r, 97, 0 };
S stXr[] = { p, 97, n, 0 };
S sf3_g[] = { 243, w, a };
S srmXg[] = { n, i, 97, a };
S svX_[] = { r, 97, w, 0 };
S sXbf[] = { 97, 191, 0 };
S sb379[] = { 179, y, 0 };
S sriks[] = { n, e, g, o, 0 };
S s7a79g[] = { z, y, a };
S sgZ7a[] = { 32, 99, z, 0 };
S sf1w[] = { 241, s, 0 };
S srik[] = { n, e, g, 0 };
S s7aZ7ai[] = { z, 99, z, e, 0 };
S swmeag[] = { s, i, 234, a };
S smik[] = { i, e, g, 0 };
S swmea[] = { s, i, 234, 0 };
S sgwmea[] = { 32, s, i, 234, 0 };
S sXf1[] = { 97, 241, 0 };
S snXo[] = { j, 97, k, 0 };
S smy[] = { i, u, 0 };
S sZ7a79[] = { 99, z, y, 0 };
S swomi[] = { s, k, i, e, 0 };
S sgnXo[] = { 32, j, 97, k, 0 };
S sybf[] = { u, 191, 0 };
S sgox[] = { 32, k, t, 0 };
S ssb6[] = { o, 182, 0 };
S smyg[] = { i, u, a };
S smZ7a[] = { i, 99, z, 0 };
S smip[] = { i, e, l, 0 };
S sqmi[] = { m, i, e, 0 };
S sb3y[] = { 179, u, 0 };
S sihr[] = { e, d, n, 0 };
S sgY79b3[] = { 32, 98, y, 179, 0 };
S shrm[] = { d, n, i, 0 };
S seah[] = { 234, d, 0 };
S srXn[] = { n, 97, j, 0 };
S s_wo[] = { w, s, k, 0 };
S smiq[] = { i, e, m, 0 };
S smiks[] = { i, e, g, o, 0 };
S srmyg[] = { n, i, u, a };
S sxf3v[] = { t, 243, r, 0 };
S sf3v[] = { 243, r, 0 };
S s_Xr[] = { w, 97, n, 0 };
S sZ7ar[] = { 99, z, n, 0 };
S syw7a[] = { u, s, z, 0 };
S ss_m[] = { o, w, i, 0 };
S seah7a[] = { 234, d, z, 0 };
S smeaZ[] = { i, 234, 99, 0 };
S s_wom[] = { w, s, k, i, 0 };
S sZmig[] = { 99, i, e, a };
S seaZ[] = { 234, 99, 0 };
S smb3[] = { i, 179, 0 };
S ss_w[] = { o, w, s, 0 };
S sibf[] = { e, 191, 0 };
S spri[] = { l, n, e, 0 };
S snihr[] = { j, e, d, n, 0 };
S soxf3[] = { k, t, 243, 0 };
S sgnih[] = { 32, j, e, d, 0 };
S sgoxf3[] = { 32, k, t, 243, 0 };
S sgrXn[] = { 32, n, 97, j, 0 };
S soxf3v[] = { k, t, 243, r, 0 };
S sgtsq[] = { 32, p, o, m, 0 };
S skb3[] = { g, 179, 0 };
S sbfX[] = { 191, 97, 0 };
S swb3[] = { s, 179, 0 };
S sb1h[] = { 177, d, 0 };
S srmZ[] = { n, i, 99, 0 };
S srmy[] = { n, i, u, 0 };
S sqf3[] = { m, 243, 0 };
S s79Y[] = { y, 98, 0 };
S stsq[] = { p, o, m, 0 };
S sXpr[] = { 97, l, n, 0 };
S swx_[] = { s, t, w, 0 };
S ssYm[] = { o, 98, i, 0 };
S sqf3_m[] = { m, 243, w, i, 0 };
S s_w7a[] = { w, s, z, 0 };
S srmo[] = { n, i, k, 0 };
S sXom[] = { 97, k, i, 0 };
S somik[] = { k, i, e, g, 0 };
S sb3Xg[] = { 179, 97, a };
S s_sg[] = { w, o, a };
S sZnm[] = { 99, j, i, 0 };
S s7airm[] = { z, e, n, i, 0 };
S sqf3_[] = { m, 243, w, 0 };
S s79wx[] = { y, s, t, 0 };
S sr79Z[] = { n, y, 99, 0 };
S shpX[] = { d, l, 97, 0 };
S skh[] = { g, d, 0 };
S sZir[] = { 99, e, n, 0 };
S sXf1w[] = { 97, 241, s, 0 };
S sghp[] = { 32, d, l, 0 };
S sg_mi[] = { 32, w, i, e, 0 };
S s_Xg[] = { w, 97, a };

N l29n1[] = { { stX, .166 }, H };
N l29n2[] = { { srmig, .959 }, { sXb3g, .259 }, H };
N l29n3[] = { { ssv, .256 }, H };
N l29n4[] = { { ssZ, .089 }, H };
N l29n5[] = { { smr, .115 }, H };
N l29n6[] = { { srx, .128 }, { sgwm, .230 }, H };
N l29n7[] = { { sw7a, .537 }, { sri, .345 }, { sZn, .128 }, H };
N l29n8[] = { { swo, .243 }, H };
N l29n11[] = { { skv, .141 }, H };
N l29n12[] = { { sb3s, .345 }, { sirm, .268 }, { sgp, .268 }, { s_w, .166 }, { syw7a, .115 }, H };
N l29n13[] = { { sXr, .447 }, { spm, .320 }, H };
N l29n16[] = { { smip, .134 }, H };
N l29n17[] = { { srsg, .201 }, H };
N l29n18[] = { { sik, .358 }, { s79Zlg, .498 }, H };
N l29n19[] = { { sb1h, .115 }, H };
N l29n20[] = { { s7ar, .153 }, { ssw, .128 }, H };
N l29n21[] = { { sgts, 1.064 }, { sx79, .217 }, { ssh, .166 }, { sog, .249 }, { sgnX, .288 }, { sxf3v, .115 }, H };
N l29n22[] = { { s7ami, .307 }, { sms, .077 }, { sxXo, .096 }, H };
N l29n23[] = { { sZ7a, .524 }, H };
N l29n26[] = { { soyg, .201 }, { soxf3, .115 }, H };
N l29n27[] = { { sv7a79, .192 }, { smiq, .115 }, H };
N l29n28[] = { { siw7a, .153 }, H };
N l29n29[] = { { sgq, .403 }, { skh, .064 }, H };
N l29n30[] = { { sb3X, .268 }, { s_i, .141 }, H };
N l29n33[] = { { snihr, .153 }, H };
N l29n34[] = { { stv, .550 }, H };
N l29n35[] = { { srXg, .431 }, H };
N l29n37[] = { { sg7aX, .575 }, { sh79, .141 }, { ssx, .115 }, H };
N l29n38[] = { { smiks, .153 }, { smir, .115 }, H };
N l29n39[] = { { sg_g, .690 }, H };
N l29n40[] = { { smX, .332 }, { s_sg, .144 }, { sghp, .144 }, H };
N l29n41[] = { { s79Y, .077 }, { spig, .144 }, H };
N l29n44[] = { { sqm, .230 }, { sxg, .115 }, H };
N l29n45[] = { { svs, .371 }, H };
N l29n46[] = { { sgr, 1.093 }, H };
N l29n47[] = { { s7a79g, .230 }, { sxf3, .102 }, { snmg, .173 }, { sXt, .077 }, H };
N l29n53[] = { { s7air, .115 }, H };
N l29n54[] = { { sgtv, .978 }, { sh7a, .320 }, { sbfig, .518 }, { skvX, .115 }, H };
N l29n55[] = { { s7aX, .447 }, { siksg, .728 }, { sgvs, .201 }, H };
N l29n56[] = { { sksg, .546 }, { seah7a, .259 }, H };
N l29n57[] = { { sgmg, .546 }, H };
N l29n58[] = { { s79Z, .243 }, { sXog, .173 }, { s_Xg, .144 }, H };
N l29n60[] = { { sq79, .115 }, { shg, .096 }, H };
N l29n61[] = { { sYs, .102 }, H };
N l29n63[] = { { svX, .435 }, { sgs, .498 }, { sv7ai, .326 }, H };
N l29n65[] = { { smea, .268 }, { sgni, .403 }, { sbfg, .230 }, H };
N l29n66[] = { { sXpi, .115 }, H };
N l29n68[] = { { s79qg, .316 }, H };
N l29n69[] = { { sin, .396 }, { sZlg, .546 }, { somi, .307 }, H };
N l29n70[] = { { sgbfig, .383 }, { syo, .077 }, { s79wx, .096 }, H };
N l29n71[] = { { snX, .179 }, { sY79g, .230 }, H };
N l29n72[] = { { sw7aZ, .230 }, { ssk, .128 }, { sgqX, .173 }, H };
N l29n73[] = { { sghs, .546 }, { ss_w, .115 }, H };
N l29n74[] = { { smZ, .179 }, { sg_m, .316 }, { s79w, .141 }, { sZ7a79, .134 }, { s_w7a, .096 }, H };
N l29n75[] = { { srm, 1.201 }, { syg, .594 }, { s79h, .077 }, H };
N l29n77[] = { { stvX, .249 }, { sZmi, .134 }, H };
N l29n78[] = { { somg, .230 }, H };
N l29n79[] = { { sYX, .077 }, H };
N l29n80[] = { { sgt, 1.821 }, H };
N l29n81[] = { { sXv, .217 }, { sgX, .230 }, { srXn, .134 }, H };
N l29n82[] = { { sXZ, .230 }, { smiv, .115 }, { srmy, .115 }, H };
N l29n83[] = { { sqg, .709 }, { sgwt, .173 }, H };
N l29n84[] = { { sos, .332 }, { sf3_, .431 }, { swmeag, .268 }, H };
N l29n85[] = { { si7a, .166 }, H };
N l29n86[] = { { sio, .166 }, { sgnXo, .268 }, { sqf3, .077 }, H };
N l29n88[] = { { ss_, .409 }, H };
N l29n89[] = { { sgrX, .891 }, { s7aZ, .166 }, { sgxs, .288 }, { sgtvX, .307 }, H };
N l29n90[] = { { smw, .141 }, { sg7ag, .288 }, { sming, .307 }, H };
N l29n91[] = { { sig, 1.553 }, { sr79, .192 }, { s79x, .077 }, H };
N l29n92[] = { { svX_, .153 }, { sgtsq, .230 }, { skb3, .077 }, H };
N l29n93[] = { { swt, .089 }, { sXom, .096 }, H };
N l29n94[] = { { sw7ai, .134 }, { sXwx, .096 }, H };
N l29n96[] = { { stv7a, .288 }, H };
N l29n98[] = { { s_m, .473 }, { sgY, .556 }, { sXw, .153 }, { spr, .128 }, H };
N l29n99[] = { { sXh, .141 }, H };
N l29n101[] = { { sgtvi, .268 }, H };
N l29n102[] = { { soX, .243 }, H };
N l29n103[] = { { sip, .192 }, H };
N l29n106[] = { { shr, .166 }, { sghv, .144 }, H };
N l29n107[] = { { sxs, .307 }, H };
N l29n108[] = { { smi, 1.393 }, { sb3sg, .388 }, { sZir, .096 }, H };
N l29n109[] = { { spmg, .288 }, { sgnih, .230 }, H };
N l29n110[] = { { sZ7ai, .364 }, { sXbf, .102 }, { sXpm, .115 }, H };
N l29n112[] = { { sxiq, .134 }, { soxf3v, .153 }, { s7airm, .128 }, H };
N l29n113[] = { { svw, .064 }, H };
N l29n114[] = { { s_79, .243 }, { sgv, .307 }, { sb3y, .134 }, { skm, .089 }, H };
N l29n115[] = { { sgZ, .345 }, { sXx, .128 }, { sqf3_, .096 }, { shpX, .096 }, H };
N l29n116[] = { { srik, .153 }, H };
N l29n117[] = { { sgsY, .173 }, H };
N l29n118[] = { { seag, .949 }, { srmX, .192 }, { ssYm, .096 }, H };
N l29n120[] = { { siq, .320 }, H };
N l29n121[] = { { stvi, .153 }, { syr, .077 }, { sg_mi, .192 }, H };
N l29n122[] = { { somik, .128 }, H };
N l29n123[] = { { s7ai, .626 }, { shs, .358 }, { sgtX, .259 }, H };
N l29n124[] = { { smy, .089 }, { sniw, .096 }, H };
N l29n125[] = { { sxX, .332 }, H };
N l29n126[] = { { sb3Xg, .216 }, H };
N l29n127[] = { { sgwx, .230 }, H };
N l29n128[] = { { svXZ, .134 }, H };
N l29n130[] = { { smeaZ, .115 }, H };
N l29n131[] = { { sgw, .959 }, { svi, .243 }, { ss_X, .230 }, { sqmi, .134 }, H };
N l29n132[] = { { sgh, .786 }, H };
N l29n133[] = { { sirx, .192 }, { spX, .102 }, { sh79g, .144 }, H };
N l29n135[] = { { ssb6, .089 }, { swxv, .134 }, { sov, .077 }, H };
N l29n136[] = { { smXg, .288 }, { smZ7a, .134 }, H };
N l29n137[] = { { s_g, .652 }, { sir, .409 }, { stm, .166 }, H };
N l29n138[] = { { s79b3, .115 }, { sZnm, .096 }, H };
N l29n139[] = { { sni, .230 }, { swom, .192 }, { shir, .115 }, { ss7a, .077 }, { s7ay, .077 }, H };
N l29n140[] = { { sso, .153 }, { srmZ, .115 }, H };
N l29n141[] = { { shX, .115 }, H };
N l29n143[] = { { sb1g, .345 }, { stv7ai, .281 }, { sgbf, .211 }, H };
N l29n144[] = { { sXrm, .364 }, H };
N l29n145[] = { { ssg, 1.572 }, H };
N l29n146[] = { { sqs, .077 }, { sbfX, .115 }, H };
N l29n147[] = { { svy, .115 }, { sYi, .089 }, H };
N l29n148[] = { { sgx, .709 }, { s_Xr, .115 }, H };
N l29n149[] = { { srin, .230 }, { sgY79, .316 }, H };
N l29n151[] = { { s7aZ7a, .211 }, { s7aXg, .201 }, { sgrXn, .230 }, H };
N l29n152[] = { { sY79b3, .173 }, H };
N l29n153[] = { { sihr, .134 }, H };
N l29n154[] = { { smb3, .077 }, H };
N l29n155[] = { { sny, .077 }, H };
N l29n156[] = { { sr79Z, .096 }, H };
N l29n157[] = { { ssp, .166 }, { sgkv, .201 }, H };
N l29n158[] = { { sxv, .166 }, { stsq, .115 }, H };
N l29n161[] = { { swx, .498 }, { smeag, .259 }, H };
N l29n162[] = { { srmi, .728 }, { sXb3, .243 }, H };
N l29n164[] = { { sgtv7a, .575 }, { sqX, .166 }, H };
N l29n165[] = { { sing, .834 }, { sgy, .230 }, { s_wo, .134 }, { sXpr, .115 }, H };
N l29n166[] = { { sX_, .243 }, H };
N l29n169[] = { { sghsg, .575 }, { sox, .102 }, H };
N l29n171[] = { { srmg, .259 }, H };
N l29n173[] = { { sZmig, .230 }, H };
N l29n174[] = { { ssq, .192 }, { shv, .102 }, { sgY79b3, .268 }, { sqf3_m, .128 }, H };
N l29n177[] = { { sgrm, .661 }, { srs, .141 }, { sgZ7a, .230 }, { sXf1w, .096 }, H };
N l29n178[] = { { s79Zl, .268 }, { sZi, .153 }, { stvX_, .204 }, { srmyg, .230 }, H };
N l29n180[] = { { sf3_g, .518 }, { sosg, .201 }, H };
N l29n182[] = { { sw7aZ7a, .281 }, { sb379, .153 }, H };
N l29n183[] = { { sgk, .326 }, H };
N l29n184[] = { { slg, .364 }, H };
N l29n185[] = { { sh7am, .326 }, { s_mi, .288 }, { sgrXg, .422 }, { sgxsg, .383 }, { spri, .115 }, { sgYi, .144 }, H };
N l29n186[] = { { soy, .141 }, { swomi, .179 }, H };
N l29n187[] = { { stXr, .153 }, { sr79g, .201 }, H };
N l29n190[] = { { swx_, .115 }, H };
N l29n191[] = { { s7am, .230 }, { ssr, .204 }, { sgxX, .230 }, H };
N l29n192[] = { { sXf1, .089 }, { sgos, .201 }, H };
N l29n193[] = { { sxi, .256 }, { sgw7a, .288 }, { sriks, .204 }, H };
N l29n195[] = { { srX, .562 }, H };
N l29n196[] = { { sgwmea, .268 }, H };
N l29n198[] = { { s7aZ7ai, .204 }, { soXg, .201 }, H };
N l29n199[] = { { sg_, 1.227 }, { s79g, .978 }, { sgx79, .259 }, H };
N l29n200[] = { { s_s, .141 }, H };
N l29n201[] = { { spi, .256 }, { sXn, .128 }, H };
N l29n203[] = { { sxsg, .374 }, H };
N l29n204[] = { { smig, 1.237 }, { swxX, .134 }, H };
N l29n205[] = { { sb3g, .518 }, { siv, .179 }, H };
N l29n206[] = { { siZ, .179 }, { syw, .115 }, H };
N l29n207[] = { { s7a79, .383 }, { syh, .128 }, { snm, .077 }, H };
N l29n208[] = { { sgoxf3, .230 }, { swb3, .077 }, H };
N l29n209[] = { { shi, .166 }, { sxy, .089 }, { sZ7ar, .115 }, H };
N l29n210[] = { { sf1w, .230 }, { smo, .077 }, H };
N l29n214[] = { { sbfi, .268 }, { srmXg, .307 }, H };
N l29n215[] = { { smg, 1.246 }, { siks, .364 }, { sv79, .089 }, { sYm, .089 }, { snih, .115 }, H };
N l29n216[] = { { sks, .294 }, { siqg, .489 }, H };
N l29n217[] = { { sgm, .460 }, { smik, .134 }, { spy, .089 }, H };
N l29n218[] = { { s_X, .358 }, { sXo, .230 }, { sybf, .089 }, { siwx, .115 }, H };
N l29n219[] = { { shsg, .431 }, { s7aig, .259 }, { ss_m, .115 }, H };
N l29n220[] = { { smyg, .201 }, H };
N l29n221[] = { { sxXg, .173 }, H };
N l29n222[] = { { siw, .204 }, H };
N l29n223[] = { { sXg, 1.553 }, { sih, .166 }, H };
N l29n224[] = { { sgrmi, .767 }, { snXo, .134 }, { s_wom, .153 }, H };
N l29n227[] = { { smp, .077 }, H };
N l29n228[] = { { s79q, .166 }, { srmo, .096 }, H };
N l29n229[] = { { sZl, .371 }, H };
N l29n230[] = { { s7ag, .326 }, { sgbfi, .288 }, { swm, .115 }, H };
N l29n231[] = { { sY79, .256 }, { shirx, .153 }, H };
N l29n232[] = { { sv7a, .447 }, { sh7ami, .383 }, H };
N l29n233[] = { { seaZ, .173 }, H };
N l29n234[] = { { sgn, .575 }, { skX, .102 }, { sibf, .077 }, H };
N l29n235[] = { { sXp, .256 }, { sgxi, .201 }, H };
N l29n237[] = { { shrm, .134 }, H };
N l29n238[] = { { som, .383 }, { svg, .096 }, H };
N l29n239[] = { { sts, .511 }, { six, .089 }, H };
N l29n243[] = { { ssY, .153 }, { sx_, .115 }, H };
N l29n244[] = { { swmea, .134 }, H };
N l29n245[] = { { sring, .460 }, H };
N l29n246[] = { { sng, .594 }, { sZm, .268 }, { srh, .077 }, { sw79, .077 }, H };
N l29n247[] = { { sgox, .201 }, H };
N l29n250[] = { { sg7a, .844 }, { sWg, .647 }, { sg_79, .345 }, { smin, .192 }, { seah, .201 }, H };
N l29n251[] = { { sgo, .556 }, H };
N l29n252[] = { { sXq, .179 }, H };
N l29n255[] = { { sf3v, .173 }, H };

D l29_d = {
	"polish",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, 0.001,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.168, 0.033, 0.072, 0.067, 0.174, 0.007, 0.037, 0.016, 0.167, 0.047, 0.067, 0.047, 0.054, 0.120, 0.145,
	    0.067, W, 0.088, 0.079, 0.075, 0.051, W, 0.089, W, 0.078, 0.113, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, 0.001, Y, Y, 0.002, Y, Y, Y, Y, Y, Y, Y, Y, 0.001,
	    Y, 0.021, Y, 0.058, Y, Y, 0.016, Y, Y, Y, Y, Y, 0.001, Y, Y, 0.031,
	    Y, V, V, V, V, V, 0.001, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, 0.017, V, V, V, 0.052, V, V, V, V, V,
	    V, 0.015, V, 0.032, V, V, V, V, V, V, V, V, V, V, V, V },
	{ X, l29n1, l29n2, l29n3, l29n4, l29n5, l29n6, l29n7, l29n8, X, X, l29n11, l29n12, l29n13, X, X,
	    l29n16, l29n17, l29n18, l29n19, l29n20, l29n21, l29n22, l29n23, X, X, l29n26, l29n27, l29n28, l29n29, l29n30, X,
	    X, l29n33, l29n34, l29n35, X, l29n37, l29n38, l29n39, l29n40, l29n41, X, X, l29n44, l29n45, l29n46, l29n47,
	    X, X, X, X, X, l29n53, l29n54, l29n55, l29n56, l29n57, l29n58, X, l29n60, l29n61, X, l29n63,
	    X, l29n65, l29n66, X, l29n68, l29n69, l29n70, l29n71, l29n72, l29n73, l29n74, l29n75, X, l29n77, l29n78, l29n79,
	    l29n80, l29n81, l29n82, l29n83, l29n84, l29n85, l29n86, X, l29n88, l29n89, l29n90, l29n91, l29n92, l29n93, l29n94, X,
	    l29n96, X, l29n98, l29n99, X, l29n101, l29n102, l29n103, X, X, l29n106, l29n107, l29n108, l29n109, l29n110, X,
	    l29n112, l29n113, l29n114, l29n115, l29n116, l29n117, l29n118, X, l29n120, l29n121, l29n122, l29n123, l29n124, l29n125, l29n126, l29n127,
	    l29n128, X, l29n130, l29n131, l29n132, l29n133, X, l29n135, l29n136, l29n137, l29n138, l29n139, l29n140, l29n141, X, l29n143,
	    l29n144, l29n145, l29n146, l29n147, l29n148, l29n149, X, l29n151, l29n152, l29n153, l29n154, l29n155, l29n156, l29n157, l29n158, X,
	    X, l29n161, l29n162, X, l29n164, l29n165, l29n166, X, X, l29n169, X, l29n171, X, l29n173, l29n174, X,
	    X, l29n177, l29n178, X, l29n180, X, l29n182, l29n183, l29n184, l29n185, l29n186, l29n187, X, X, l29n190, l29n191,
	    l29n192, l29n193, X, l29n195, l29n196, X, l29n198, l29n199, l29n200, l29n201, X, l29n203, l29n204, l29n205, l29n206, l29n207,
	    l29n208, l29n209, l29n210, X, X, X, l29n214, l29n215, l29n216, l29n217, l29n218, l29n219, l29n220, l29n221, l29n222, l29n223,
	    l29n224, X, X, l29n227, l29n228, l29n229, l29n230, l29n231, l29n232, l29n233, l29n234, l29n235, X, l29n237, l29n238, l29n239,
	    X, X, X, l29n243, l29n244, l29n245, l29n246, l29n247, X, X, l29n250, l29n251, l29n252, X, X, l29n255 }
};

//
// Lng: polish
// Enc: utf8
//

S sc2b3[] = { 194, 179, 0 };
S sc3aa[] = { 195, 170, 0 };
S sc2bf[] = { 194, 191, 0 };
S sXc2[] = { 97, 194, 0 };
S sc2b1[] = { 194, 177, 0 };
S sc3aag[] = { 195, 170, a };
S smc3aa[] = { i, 195, 170, 0 };
S sc2b6[] = { 194, 182, 0 };
S sXc2b3[] = { 97, 194, 179, 0 };
S sc2b3s[] = { 194, 179, o, 0 };
S sc2b3g[] = { 194, 179, a };
S smc2[] = { i, 194, 0 };
S sc3a6g[] = { 195, 166, a };
S sc3b3_[] = { 195, 179, w, 0 };
S sc3a6[] = { 195, 166, 0 };
S sb3_[] = { 179, w, 0 };
S sc2b3X[] = { 194, 179, 97, 0 };
S sc2bfi[] = { 194, 191, e, 0 };
S s79c2[] = { y, 194, 0 };
S sc3b1[] = { 195, 177, 0 };
S ssc2[] = { o, 194, 0 };
S sc2b1g[] = { 194, 177, a };
S sc2bfig[] = { 194, 191, e, a };
S sXc3[] = { 97, 195, 0 };
S syc2[] = { u, 194, 0 };
S sgc2bf[] = { 32, 194, 191, 0 };
S sic2[] = { e, 194, 0 };
S s_Xc2[] = { w, 97, 194, 0 };
S swc2[] = { s, 194, 0 };
S sgc2bfi[] = { 32, 194, 191, e, 0 };
S sY79c2[] = { 98, y, 194, 0 };
S smc3aag[] = { i, 195, 170, a };
S sc2b3sg[] = { 194, 179, o, a };
S sY79c2b3[] = { 98, y, 194, 179, 0 };
S sXc2b3g[] = { 97, 194, 179, a };
S s79c2b3[] = { y, 194, 179, 0 };
S sxc3b3[] = { t, 195, 179, 0 };
S sb1w[] = { 177, s, 0 };
S sXc2bf[] = { 97, 194, 191, 0 };
S sgY79c2[] = { 32, 98, y, 194, 0 };
S sc3b1w[] = { 195, 177, s, 0 };
S sc3b3_g[] = { 195, 179, w, a };
S sb3_g[] = { 179, w, a };
S sc2b379[] = { 194, 179, y, 0 };
S sc2bfg[] = { 194, 191, a };
S swmc3[] = { s, i, 195, 0 };
S sc3aah[] = { 195, 170, d, 0 };
S saah[] = { 170, d, 0 };
S s7ac2[] = { z, 194, 0 };
S syc2bf[] = { u, 194, 191, 0 };
S sgwmc3[] = { 32, s, i, 195, 0 };
S sXc3b1[] = { 97, 195, 177, 0 };
S ssc2b6[] = { o, 194, 182, 0 };
S sc2b3y[] = { 194, 179, u, 0 };
S swmc3aa[] = { s, i, 195, 170, 0 };
S sc3aah7a[] = { 195, 170, d, z, 0 };
S soxc3b3[] = { k, t, 195, 179, 0 };
S saaZ[] = { 170, 99, 0 };
S sic2bf[] = { e, 194, 191, 0 };
S sgoxc3[] = { 32, k, t, 195, 0 };
S smc3aaZ[] = { i, 195, 170, 99, 0 };
S sb3v[] = { 179, r, 0 };
S s_mc2[] = { w, i, 194, 0 };
S saah7a[] = { 170, d, z, 0 };
S sc2b1h[] = { 194, 177, d, 0 };
S skc2[] = { g, 194, 0 };
S sc2bfX[] = { 194, 191, 97, 0 };
S sqc3b3[] = { m, 195, 179, 0 };
S smc2b3[] = { i, 194, 179, 0 };
S sc3aaZ[] = { 195, 170, 99, 0 };
S swc2b3[] = { s, 194, 179, 0 };
S sic3[] = { e, 195, 0 };
S s_mc3[] = { w, i, 195, 0 };
S sc3b3v[] = { 195, 179, r, 0 };
S soxc3[] = { k, t, 195, 0 };

N l30n1[] = { { stX, .155 }, H };
N l30n2[] = { { srmig, .896 }, H };
N l30n3[] = { { ssv, .239 }, { sc3a6g, .908 }, H };
N l30n4[] = { { ssZ, .084 }, H };
N l30n5[] = { { smr, .108 }, H };
N l30n6[] = { { srx, .120 }, { sgwm, .215 }, H };
N l30n7[] = { { sw7a, .502 }, { sri, .323 }, { sZn, .120 }, H };
N l30n8[] = { { swo, .227 }, H };
N l30n10[] = { { soxc3, .108 }, H };
N l30n11[] = { { skv, .131 }, H };
N l30n12[] = { { sb3s, .323 }, { sirm, .251 }, { sgp, .251 }, { s_w, .155 }, { syw7a, .108 }, H };
N l30n13[] = { { sXr, .418 }, { spm, .299 }, { syc2, .131 }, H };
N l30n16[] = { { smip, .126 }, H };
N l30n17[] = { { srsg, .188 }, H };
N l30n18[] = { { sik, .335 }, { s79Zlg, .466 }, { sb1w, .143 }, H };
N l30n20[] = { { s7ar, .143 }, { ssw, .120 }, H };
N l30n21[] = { { sgts, .995 }, { sx79, .203 }, { ssh, .155 }, { sog, .233 }, { sgnX, .269 }, H };
N l30n22[] = { { s7ami, .287 }, { sms, .072 }, H };
N l30n23[] = { { sZ7a, .490 }, H };
N l30n26[] = { { soyg, .188 }, H };
N l30n27[] = { { sv7a79, .179 }, { smiq, .108 }, H };
N l30n28[] = { { siw7a, .143 }, H };
N l30n29[] = { { sgq, .377 }, { sic2, .120 }, H };
N l30n30[] = { { sb3X, .251 }, { s_i, .131 }, H };
N l30n33[] = { { smc3aaZ, .143 }, { snihr, .143 }, H };
N l30n34[] = { { stv, .514 }, H };
N l30n35[] = { { srXg, .403 }, { soxc3b3, .143 }, H };
N l30n37[] = { { sg7aX, .538 }, { sh79, .131 }, { ssx, .108 }, { ssc2b6, .126 }, H };
N l30n38[] = { { sc2b3s, .726 }, { sgc2bfi, .359 }, { smiks, .143 }, { smir, .108 }, { sqc3, .072 }, H };
N l30n39[] = { { sg_g, .645 }, H };
N l30n40[] = { { smX, .311 }, { sc3aaZ, .242 }, H };
N l30n41[] = { { saaZ, .108 }, H };
N l30n44[] = { { sqm, .215 }, H };
N l30n45[] = { { sc2bf, 1.103 }, { svs, .347 }, H };
N l30n46[] = { { sgr, 1.022 }, { sic3, .072 }, H };
N l30n47[] = { { s7a79g, .215 }, { snmg, .161 }, H };
N l30n48[] = { { s_Xc2, .179 }, H };
N l30n51[] = { { sc3aah, .282 }, H };
N l30n53[] = { { s7air, .108 }, H };
N l30n54[] = { { sgtv, .914 }, { sh7a, .299 }, { sbfig, .484 }, { skvX, .108 }, H };
N l30n55[] = { { s7aX, .418 }, { siksg, .681 }, { sgvs, .188 }, H };
N l30n56[] = { { sksg, .511 }, H };
N l30n57[] = { { sgmg, .511 }, H };
N l30n58[] = { { s79Z, .227 }, { sa6g, .403 }, { s79c2b3, .161 }, { saah, .126 }, { sXog, .161 }, H };
N l30n60[] = { { sq79, .108 }, H };
N l30n61[] = { { sY79c2, .179 }, { sYs, .096 }, H };
N l30n63[] = { { svX, .406 }, { sc2b1, .726 }, { sgs, .466 }, { sv7ai, .305 }, { sb3v, .108 }, H };
N l30n64[] = { { sgoxc3, .215 }, H };
N l30n65[] = { { sgni, .377 }, { sbfg, .215 }, H };
N l30n66[] = { { syc2bf, .126 }, H };
N l30n68[] = { { s79qg, .296 }, H };
N l30n69[] = { { sin, .371 }, { sZlg, .511 }, { somi, .287 }, { swmc3aa, .167 }, H };
N l30n71[] = { { sc3aag, 1.331 }, { snX, .167 }, { sY79g, .215 }, { swmc3, .126 }, H };
N l30n72[] = { { sw7aZ, .215 }, { ssk, .120 }, H };
N l30n73[] = { { sghs, .511 }, { ss_w, .108 }, H };
N l30n74[] = { { smZ, .167 }, { sg_m, .296 }, { s79w, .131 }, { sZ7a79, .126 }, { smc2b3, .108 }, H };
N l30n75[] = { { srm, 1.124 }, { syg, .556 }, { s79h, .072 }, H };
N l30n77[] = { { stvX, .233 }, { sXc3b1, .126 }, { sZmi, .126 }, H };
N l30n78[] = { { somg, .215 }, H };
N l30n79[] = { { sc3b1w, .323 }, { sgwmc3, .251 }, { sYX, .072 }, H };
N l30n80[] = { { sgt, 1.703 }, H };
N l30n81[] = { { sXv, .203 }, { sgX, .215 }, { srXn, .126 }, H };
N l30n82[] = { { sXc2b3, .341 }, { sXZ, .215 }, { sic2bf, .108 }, { smiv, .108 }, H };
N l30n83[] = { { sqg, .663 }, { ssc2, .155 }, { sgwt, .161 }, H };
N l30n84[] = { { sos, .311 }, H };
N l30n85[] = { { si7a, .155 }, H };
N l30n86[] = { { sio, .155 }, { sY79c2b3, .215 }, { sgnXo, .251 }, H };
N l30n88[] = { { ss_, .382 }, { smc3aag, .323 }, { sc2bfX, .242 }, H };
N l30n89[] = { { sgrX, .834 }, { s7aZ, .155 }, { sgxs, .269 }, { sgtvX, .287 }, H };
N l30n90[] = { { smw, .131 }, { sg7ag, .269 }, { sming, .287 }, H };
N l30n91[] = { { sig, 1.452 }, { sr79, .179 }, { skc2, .072 }, { s79x, .072 }, H };
N l30n92[] = { { svX_, .143 }, { sgtsq, .215 }, H };
N l30n93[] = { { swt, .084 }, H };
N l30n94[] = { { sc3b1, .350 }, { sw7ai, .126 }, H };
N l30n96[] = { { stv7a, .269 }, H };
N l30n97[] = { { sc2b3, 2.017 }, H };
N l30n98[] = { { s_m, .442 }, { sgY, .520 }, { sXw, .143 }, { spr, .120 }, H };
N l30n99[] = { { sXh, .131 }, H };
N l30n101[] = { { sgtvi, .251 }, H };
N l30n102[] = { { soX, .227 }, { sc3b3v, .242 }, H };
N l30n103[] = { { sip, .179 }, H };
N l30n104[] = { { sc2b3y, .282 }, H };
N l30n106[] = { { shr, .155 }, H };
N l30n107[] = { { sxs, .287 }, H };
N l30n108[] = { { smi, 1.303 }, { sb3sg, .363 }, H };
N l30n109[] = { { spmg, .269 }, { sgnih, .215 }, H };
N l30n110[] = { { sZ7ai, .341 }, { sXpm, .108 }, H };
N l30n112[] = { { sxiq, .126 }, H };
N l30n114[] = { { s_79, .227 }, { sgv, .287 }, { sb3y, .126 }, { skm, .084 }, H };
N l30n115[] = { { sgZ, .323 }, { sXx, .120 }, H };
N l30n116[] = { { srik, .143 }, H };
N l30n117[] = { { sgsY, .161 }, H };
N l30n118[] = { { srmX, .179 }, H };
N l30n120[] = { { siq, .299 }, { saah7a, .161 }, H };
N l30n121[] = { { stvi, .143 }, { syr, .072 }, H };
N l30n123[] = { { s7ai, .586 }, { shs, .335 }, { sgtX, .242 }, H };
N l30n124[] = { { smy, .084 }, H };
N l30n125[] = { { sxX, .311 }, H };
N l30n127[] = { { sgwx, .215 }, H };
N l30n128[] = { { sc3b3, .753 }, { svXZ, .126 }, { swc2b3, .108 }, H };
N l30n131[] = { { sgw, .896 }, { svi, .227 }, { ss_X, .215 }, { sqmi, .126 }, H };
N l30n132[] = { { sgh, .735 }, { sc2bfi, .565 }, H };
N l30n133[] = { { sirx, .179 }, { spX, .096 }, H };
N l30n134[] = { { sc2b3sg, .726 }, H };
N l30n135[] = { { swxv, .126 }, { sov, .072 }, H };
N l30n136[] = { { smXg, .269 }, { smZ7a, .126 }, H };
N l30n137[] = { { s_g, .610 }, { sir, .382 }, { s79c2, .167 }, { stm, .155 }, H };
N l30n139[] = { { sni, .215 }, { swom, .179 }, { sc2b1h, .242 }, { shir, .108 }, { ss7a, .072 }, H };
N l30n140[] = { { sc2b3X, .565 }, { sso, .143 }, H };
N l30n141[] = { { shX, .108 }, { sc2bfg, .484 }, H };
N l30n143[] = { { sb1g, .430 }, { stv7ai, .263 }, H };
N l30n144[] = { { sXrm, .341 }, H };
N l30n145[] = { { ssg, 1.470 }, H };
N l30n146[] = { { sqs, .072 }, H };
N l30n147[] = { { svy, .108 }, { sYi, .084 }, H };
N l30n148[] = { { sgx, .663 }, { sc2b6, .565 }, { sb3_, .269 }, { sc2b379, .323 }, { s_Xr, .108 }, H };
N l30n149[] = { { srin, .215 }, { sgY79, .296 }, H };
N l30n151[] = { { s7aZ7a, .197 }, { s7aXg, .188 }, { sgrXn, .215 }, H };
N l30n153[] = { { smc2, .179 }, { sihr, .126 }, H };
N l30n157[] = { { sc3b3_, .605 }, { ssp, .155 }, { sgkv, .188 }, H };
N l30n158[] = { { sxv, .155 }, H };
N l30n159[] = { { sc2b1g, .726 }, H };
N l30n161[] = { { swx, .466 }, { sXc2, .359 }, { sc3aah7a, .323 }, H };
N l30n162[] = { { srmi, .681 }, H };
N l30n163[] = { { sc3a6, .403 }, H };
N l30n164[] = { { sgtv7a, .538 }, { sqX, .155 }, H };
N l30n165[] = { { sing, .780 }, { sgy, .215 }, { s_wo, .126 }, H };
N l30n166[] = { { sX_, .227 }, H };
N l30n168[] = { { s7ac2, .084 }, H };
N l30n169[] = { { sghsg, .538 }, { sox, .096 }, H };
N l30n170[] = { { smc3, .287 }, H };
N l30n171[] = { { srmg, .242 }, H };
N l30n173[] = { { sZmig, .215 }, H };
N l30n174[] = { { ssq, .179 }, { shv, .096 }, H };
N l30n176[] = { { sxc3b3, .143 }, H };
N l30n177[] = { { sgrm, .619 }, { srs, .131 }, { sgZ7a, .215 }, H };
N l30n178[] = { { s79Zl, .251 }, { sZi, .143 }, { sXc3, .143 }, { sXc2b3g, .323 }, { stvX_, .191 }, { srmyg, .215 }, H };
N l30n180[] = { { sosg, .188 }, H };
N l30n182[] = { { saag, .592 }, { sw7aZ7a, .263 }, { sb379, .143 }, H };
N l30n183[] = { { sgk, .305 }, H };
N l30n184[] = { { slg, .341 }, { s_mc2, .108 }, H };
N l30n185[] = { { sh7am, .305 }, { s_mi, .269 }, { sgrXg, .394 }, { sgxsg, .359 }, { spri, .108 }, H };
N l30n186[] = { { soy, .131 }, { swomi, .167 }, H };
N l30n187[] = { { stXr, .143 }, { sr79g, .188 }, H };
N l30n191[] = { { s7am, .215 }, { ssr, .191 }, { sgxX, .215 }, H };
N l30n192[] = { { sgos, .188 }, H };
N l30n193[] = { { sxi, .239 }, { sc2b3g, 1.089 }, { sgw7a, .269 }, { sriks, .191 }, H };
N l30n194[] = { { sgc2, .323 }, H };
N l30n195[] = { { srX, .526 }, { s_mc3, .108 }, H };
N l30n198[] = { { s7aZ7ai, .191 }, { soXg, .188 }, H };
N l30n199[] = { { sg_, 1.147 }, { s79g, .914 }, { sgx79, .242 }, H };
N l30n200[] = { { s_s, .131 }, H };
N l30n201[] = { { spi, .239 }, { sXn, .120 }, H };
N l30n203[] = { { sxsg, .350 }, H };
N l30n204[] = { { smig, 1.156 }, { swxX, .126 }, H };
N l30n205[] = { { sb3g, .511 }, { siv, .167 }, H };
N l30n206[] = { { siZ, .167 }, { syw, .108 }, H };
N l30n207[] = { { s7a79, .359 }, { syh, .120 }, { swc2, .120 }, { snm, .072 }, H };
N l30n209[] = { { shi, .155 }, { sxy, .084 }, { sZ7ar, .108 }, H };
N l30n210[] = { { smo, .072 }, H };
N l30n214[] = { { sbfi, .251 }, { srmXg, .287 }, { sXc2bf, .143 }, H };
N l30n215[] = { { smg, 1.165 }, { siks, .341 }, { sv79, .084 }, { sYm, .084 }, { snih, .108 }, { sqc3b3, .108 }, H };
N l30n216[] = { { sks, .275 }, { siqg, .457 }, H };
N l30n217[] = { { sgm, .430 }, { smik, .126 }, { spy, .084 }, H };
N l30n218[] = { { s_X, .335 }, { sXo, .215 }, { siwx, .108 }, H };
N l30n219[] = { { shsg, .403 }, { s7aig, .242 }, { sgY79c2, .287 }, { ss_m, .108 }, H };
N l30n220[] = { { smyg, .188 }, H };
N l30n221[] = { { sxXg, .161 }, H };
N l30n222[] = { { siw, .191 }, H };
N l30n223[] = { { sXg, 1.452 }, { sih, .155 }, H };
N l30n224[] = { { sgrmi, .717 }, { snXo, .126 }, { s_wom, .143 }, H };
N l30n227[] = { { smp, .072 }, H };
N l30n228[] = { { s79q, .155 }, { sc2bfig, .968 }, H };
N l30n229[] = { { sZl, .347 }, H };
N l30n230[] = { { s7ag, .305 }, { swm, .108 }, H };
N l30n231[] = { { sc3aa, 1.210 }, { sY79, .239 }, { shirx, .143 }, H };
N l30n232[] = { { sv7a, .418 }, { sh7ami, .359 }, H };
N l30n234[] = { { sgn, .538 }, { skX, .096 }, H };
N l30n235[] = { { sXp, .239 }, { sgxi, .188 }, H };
N l30n237[] = { { shrm, .126 }, H };
N l30n238[] = { { som, .359 }, H };
N l30n239[] = { { sts, .478 }, { six, .084 }, H };
N l30n243[] = { { ssY, .143 }, { sx_, .108 }, H };
N l30n244[] = { { sb3_g, .323 }, H };
N l30n245[] = { { sring, .430 }, H };
N l30n246[] = { { sng, .556 }, { sZm, .251 }, { srh, .072 }, { sw79, .072 }, H };
N l30n247[] = { { sgc2bf, .296 }, { sgox, .188 }, H };
N l30n248[] = { { smc3aa, .377 }, H };
N l30n250[] = { { sg7a, .789 }, { sg_79, .323 }, { smin, .179 }, H };
N l30n251[] = { { sgo, .520 }, H };
N l30n252[] = { { sXq, .167 }, H };
N l30n253[] = { { sc3b3_g, .645 }, H };
N l30n255[] = { { sxc3, .131 }, H };

D l30_d = {
	"polish",
	"utf8",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, 0.001,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.157, 0.031, 0.067, 0.063, 0.163, 0.006, 0.034, 0.015, 0.156, 0.044, 0.063, 0.044, 0.051, 0.112, 0.135,
	    0.063, W, 0.083, 0.074, 0.070, 0.047, W, 0.083, W, 0.073, 0.106, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, 0.001, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, 0.001, Y, Y, 0.012, Y, Y, Y, 0.032, Y, Y, Y, Y, 0.001,
	    Y, 0.029, Y, 0.074, Y, Y, 0.015, Y, Y, Y, Y, Y, 0.001, Y, Y, 0.029,
	    Y, V, 0.182, 0.110, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ X, l30n1, l30n2, l30n3, l30n4, l30n5, l30n6, l30n7, l30n8, X, l30n10, l30n11, l30n12, l30n13, X, X,
	    l30n16, l30n17, l30n18, X, l30n20, l30n21, l30n22, l30n23, X, X, l30n26, l30n27, l30n28, l30n29, l30n30, X,
	    X, l30n33, l30n34, l30n35, X, l30n37, l30n38, l30n39, l30n40, l30n41, X, X, l30n44, l30n45, l30n46, l30n47,
	    l30n48, X, X, l30n51, X, l30n53, l30n54, l30n55, l30n56, l30n57, l30n58, X, l30n60, l30n61, X, l30n63,
	    l30n64, l30n65, l30n66, X, l30n68, l30n69, X, l30n71, l30n72, l30n73, l30n74, l30n75, X, l30n77, l30n78, l30n79,
	    l30n80, l30n81, l30n82, l30n83, l30n84, l30n85, l30n86, X, l30n88, l30n89, l30n90, l30n91, l30n92, l30n93, l30n94, X,
	    l30n96, l30n97, l30n98, l30n99, X, l30n101, l30n102, l30n103, l30n104, X, l30n106, l30n107, l30n108, l30n109, l30n110, X,
	    l30n112, X, l30n114, l30n115, l30n116, l30n117, l30n118, X, l30n120, l30n121, X, l30n123, l30n124, l30n125, X, l30n127,
	    l30n128, X, X, l30n131, l30n132, l30n133, l30n134, l30n135, l30n136, l30n137, X, l30n139, l30n140, l30n141, X, l30n143,
	    l30n144, l30n145, l30n146, l30n147, l30n148, l30n149, X, l30n151, X, l30n153, X, X, X, l30n157, l30n158, l30n159,
	    X, l30n161, l30n162, l30n163, l30n164, l30n165, l30n166, X, l30n168, l30n169, l30n170, l30n171, X, l30n173, l30n174, X,
	    l30n176, l30n177, l30n178, X, l30n180, X, l30n182, l30n183, l30n184, l30n185, l30n186, l30n187, X, X, X, l30n191,
	    l30n192, l30n193, l30n194, l30n195, X, X, l30n198, l30n199, l30n200, l30n201, X, l30n203, l30n204, l30n205, l30n206, l30n207,
	    X, l30n209, l30n210, X, X, X, l30n214, l30n215, l30n216, l30n217, l30n218, l30n219, l30n220, l30n221, l30n222, l30n223,
	    l30n224, X, X, l30n227, l30n228, l30n229, l30n230, l30n231, l30n232, X, l30n234, l30n235, X, l30n237, l30n238, l30n239,
	    X, X, X, l30n243, l30n244, l30n245, l30n246, l30n247, l30n248, X, l30n250, l30n251, l30n252, l30n253, X, l30n255 }
};

//
// Lng: portuguese
// Enc: iso-8859-15
//

S sTs[] = { 227, o, 0 };
S sTsg[] = { 227, o, a };
S sXe7[] = { 97, 231, 0 };
S se7Tsg[] = { 231, 227, o, a };
S se7Ts[] = { 231, 227, o, 0 };
S se7T[] = { 231, 227, 0 };
S shsw[] = { d, o, s, 0 };
S shswg[] = { d, o, s, a };
S syqX[] = { u, m, 97, 0 };
S spl[] = { l, h, 0 };
S syqXg[] = { u, m, 97, a };
S srxsg[] = { n, t, o, a };
S svms[] = { r, i, o, 0 };
S sgrsg[] = { 32, n, o, a };
S sxswg[] = { t, o, s, a };
S sXhi[] = { 97, d, e, 0 };
S sXe7Ts[] = { 97, 231, 227, o, 0 };
S sXe7T[] = { 97, 231, 227, 0 };
S sXvXg[] = { 97, r, 97, a };
S shXh[] = { d, 97, d, 0 };
S sgyqX[] = { 32, u, m, 97, 0 };
S sXhsg[] = { 97, d, o, a };
S sgtsv[] = { 32, p, o, r, 0 };
S sZsrx[] = { 99, o, n, t, 0 };
S stsv[] = { p, o, r, 0 };
S smhX[] = { i, d, 97, 0 };
S sf5i[] = { 245, e, 0 };
S sf5iwg[] = { 245, e, s, a };
S se7X[] = { 231, 97, 0 };
S sf5iw[] = { 245, e, s, 0 };
S sxXh[] = { t, 97, d, 0 };
S sgswg[] = { 32, o, s, a };
S sgiq[] = { 32, e, m, 0 };
S sxiw[] = { t, e, s, 0 };
S smqi[] = { i, m, e, 0 };
S sxXhs[] = { t, 97, d, o, 0 };
S sqsg[] = { m, o, a };
S sirxs[] = { e, n, t, o, 0 };
S siZi[] = { e, 99, e, 0 };
S se7Xg[] = { 231, 97, a };
S svmXg[] = { r, i, 97, a };
S sgiqg[] = { 32, e, m, a };
S shXhi[] = { d, 97, d, e, 0 };
S sZsqs[] = { 99, o, m, o, 0 };
S ssqsg[] = { o, m, o, a };
S ssqs[] = { o, m, o, 0 };
S smxs[] = { i, t, o, 0 };
S smhXh[] = { i, d, 97, d, 0 };
S sgrsw[] = { 32, n, o, s, 0 };
S siyg[] = { e, u, a };
S sxXrx[] = { t, 97, n, t, 0 };
S srswg[] = { n, o, s, a };
S srl[] = { n, h, 0 };
S sqym[] = { m, u, i, 0 };
S sXrxi[] = { 97, n, t, e, 0 };
S sgXs[] = { 32, 97, o, 0 };
S sRvms[] = { 225, r, i, o, 0 };
S srxiw[] = { n, t, e, s, 0 };
S svsg[] = { r, o, a };
S svmsg[] = { r, i, o, a };
S smsw[] = { i, o, s, 0 };
S sgqym[] = { 32, m, u, i, 0 };
S spls[] = { l, h, o, 0 };
S sqymx[] = { m, u, i, t, 0 };
S smswg[] = { i, o, s, a };
S sXrxs[] = { 97, n, t, o, 0 };
S sRvm[] = { 225, r, i, 0 };
S sxmZ[] = { t, i, 99, 0 };
S smqir[] = { i, m, e, n, 0 };
S sxiwg[] = { t, e, s, a };
S sgqmp[] = { 32, m, i, l, 0 };
S sYvX[] = { 98, r, 97, 0 };
S smZs[] = { i, 99, o, 0 };
S sXwm[] = { 97, s, i, 0 };
S sXhig[] = { 97, d, e, a };
S sZXg[] = { 99, 97, a };
S sgtip[] = { 32, p, e, l, 0 };
S sXvmX[] = { 97, r, i, 97, 0 };
S sgviw[] = { 32, r, e, s, 0 };
S sgXsg[] = { 32, 97, o, a };
S swTs[] = { s, 227, o, 0 };
S sgwir[] = { 32, s, e, n, 0 };
S sgYvX[] = { 32, 98, r, 97, 0 };

N l31n0[] = { { siy, .091 }, H };
N l31n1[] = { { stX, .364 }, { smrx, .097 }, H };
N l31n2[] = { { swig, .205 }, { srswg, .234 }, H };
N l31n3[] = { { ssv, .585 }, H };
N l31n4[] = { { sqXg, .409 }, { ssZ, .104 }, H };
N l31n5[] = { { smr, .390 }, { sxm, .351 }, { ssqi, .117 }, H };
N l31n6[] = { { srx, .767 }, H };
N l31n7[] = { { sri, .130 }, { smsw, .117 }, H };
N l31n8[] = { { sghXw, .273 }, { shXhi, .182 }, H };
N l31n9[] = { { sXrx, .292 }, { sXmwg, .234 }, H };
N l31n10[] = { { stXvX, .234 }, H };
N l31n11[] = { { sZsq, .273 }, { skv, .130 }, { sgXr, .146 }, H };
N l31n12[] = { { se7T, .409 }, { sgp, .253 }, H };
N l31n13[] = { { swg, 2.495 }, { sXr, .390 }, { spm, .234 }, H };
N l31n15[] = { { sghXg, .312 }, { smZs, .097 }, { sji, .065 }, H };
N l31n17[] = { { srsg, .526 }, { siz, .065 }, H };
N l31n18[] = { { sik, .117 }, { sxiwg, .234 }, H };
N l31n20[] = { { ssw, .871 }, H };
N l31n21[] = { { sgts, .585 }, { shm, .156 }, { ssh, .078 }, H };
N l31n22[] = { { sms, .351 }, { sXe7, .234 }, { sZsr, .273 }, { sxXhs, .208 }, { sgXs, .175 }, H };
N l31n23[] = { { sxmz, .156 }, H };
N l31n26[] = { { sXhig, .195 }, H };
N l31n27[] = { { szXg, .205 }, { srhsg, .273 }, H };
N l31n28[] = { { svr, .078 }, H };
N l31n29[] = { { sgq, .936 }, H };
N l31n30[] = { { sXs, .078 }, H };
N l31n32[] = { { sgQg, .175 }, { symx, .117 }, H };
N l31n33[] = { { sxig, .614 }, { sgXt, .263 }, { sZmX, .136 }, H };
N l31n34[] = { { stv, .208 }, { sgviw, .195 }, H };
N l31n35[] = { { srXg, .175 }, H };
N l31n36[] = { { sXe7Ts, .260 }, { sym, .117 }, { sgqy, .234 }, { swxm, .117 }, { sgwir, .195 }, H };
N l31n37[] = { { siZi, .136 }, H };
N l31n39[] = { { sqXm, .117 }, H };
N l31n40[] = { { smX, .390 }, { sXhs, .351 }, H };
N l31n43[] = { { suyig, .819 }, { srxsg, .468 }, H };
N l31n44[] = { { sqm, .221 }, H };
N l31n45[] = { { svs, .182 }, { sivg, .409 }, H };
N l31n46[] = { { sgr, .838 }, { ski, .078 }, H };
N l31n47[] = { { sXt, .117 }, H };
N l31n48[] = { { sgwiv, .312 }, { sgsw, .234 }, { smxs, .136 }, H };
N l31n49[] = { { shig, 1.579 }, { se7Tsg, 1.228 }, { srxX, .156 }, H };
N l31n52[] = { { sim, .247 }, { spg, .292 }, { sghiw, .312 }, H };
N l31n54[] = { { ssy, .234 }, { sgtv, .322 }, { skvX, .156 }, H };
N l31n55[] = { { sxXr, .136 }, H };
N l31n56[] = { { sgZs, .965 }, { sXrxi, .156 }, H };
N l31n58[] = { { srl, .078 }, { sgwig, .195 }, H };
N l31n59[] = { { sghig, 1.638 }, { sgab, .253 }, H };
N l31n60[] = { { sTsg, 2.040 }, H };
N l31n61[] = { { sYs, .065 }, H };
N l31n62[] = { { siwg, .760 }, { sky, .143 }, H };
N l31n63[] = { { svX, .793 }, { sgs, .643 }, H };
N l31n64[] = { { syig, .614 }, { sQg, .263 }, H };
N l31n65[] = { { sXY, .104 }, H };
N l31n66[] = { { sZsv, .117 }, H };
N l31n67[] = { { szm, .143 }, { stXvx, .130 }, H };
N l31n68[] = { { sgiq, .234 }, H };
N l31n69[] = { { sti, .156 }, H };
N l31n70[] = { { sxmZ, .117 }, H };
N l31n71[] = { { ssz, .104 }, H };
N l31n72[] = { { sgqX, .439 }, { sgws, .175 }, { sgYv, .175 }, H };
N l31n73[] = { { sghs, .731 }, { smv, .169 }, H };
N l31n74[] = { { smZ, .247 }, H };
N l31n75[] = { { syg, .409 }, { srm, .143 }, { sXpg, .263 }, { smqi, .156 }, H };
N l31n76[] = { { sws, .208 }, { sgrsw, .234 }, H };
N l31n77[] = { { sXvx, .097 }, H };
N l31n79[] = { { sYX, .104 }, H };
N l31n80[] = { { sgt, 1.287 }, { sivm, .117 }, H };
N l31n81[] = { { sgX, 1.482 }, { sXv, .598 }, { sf5iw, .395 }, { sxsv, .117 }, { smrh, .097 }, H };
N l31n82[] = { { sXZ, .169 }, { svmXg, .273 }, H };
N l31n83[] = { { sqg, .780 }, { sgrsg, .429 }, { sjm, .104 }, { sXww, .097 }, H };
N l31n84[] = { { sgyq, .322 }, { sRvm, .263 }, H };
N l31n85[] = { { sty, .078 }, H };
N l31n86[] = { { smwx, .195 }, { sXrxs, .156 }, H };
N l31n87[] = { { syp, .117 }, H };
N l31n88[] = { { sZsqs, .182 }, H };
N l31n89[] = { { sgrX, .322 }, { sgxs, .175 }, { sgZv, .146 }, H };
N l31n90[] = { { smw, .416 }, H };
N l31n91[] = { { sig, 2.651 }, { smh, .221 }, H };
N l31n92[] = { { sZs, .585 }, { sXqg, .322 }, { sxsw, .214 }, { swir, .175 }, H };
N l31n93[] = { { srxi, .507 }, H };
N l31n94[] = { { swX, .208 }, H };
N l31n95[] = { { sgqym, .234 }, H };
N l31n96[] = { { sf5i, .263 }, { svv, .104 }, { siyg, .175 }, H };
N l31n97[] = { { sgu, .546 }, H };
N l31n98[] = { { sXw, .507 }, { sgY, .273 }, H };
N l31n99[] = { { sXh, .481 }, { ssvg, .380 }, { sxXv, .136 }, H };
N l31n103[] = { { sip, .195 }, { smswg, .234 }, H };
N l31n104[] = { { sguy, .819 }, { syq, .208 }, H };
N l31n106[] = { { se7X, .263 }, H };
N l31n107[] = { { sxs, .624 }, { smx, .195 }, { sgjs, .351 }, { sgtsv, .351 }, { sgYvX, .195 }, H };
N l31n108[] = { { shsw, .253 }, H };
N l31n110[] = { { sZX, .325 }, { sXpm, .117 }, H };
N l31n112[] = { { sYv, .117 }, H };
N l31n114[] = { { sgv, .409 }, { sZsrx, .234 }, { skm, .104 }, H };
N l31n115[] = { { sgZ, .994 }, { sXx, .143 }, { sps, .130 }, { ssqs, .136 }, H };
N l31n116[] = { { sswg, 1.784 }, { suy, .442 }, { sviw, .312 }, { sgqi, .263 }, H };
N l31n117[] = { { smZX, .195 }, H };
N l31n118[] = { { smsg, .292 }, { sgXsg, .195 }, H };
N l31n119[] = { { sgyqX, .390 }, H };
N l31n120[] = { { siq, .299 }, H };
N l31n121[] = { { syr, .091 }, H };
N l31n122[] = { { sgxv, .175 }, H };
N l31n123[] = { { shs, .793 }, { sgtX, .614 }, { sqym, .117 }, H };
N l31n124[] = { { sXvX, .273 }, { smy, .065 }, H };
N l31n125[] = { { sxX, .585 }, H };
N l31n126[] = { { shXw, .136 }, H };
N l31n127[] = { { sgZsq, .507 }, H };
N l31n128[] = { { swZ, .065 }, H };
N l31n130[] = { { svx, .195 }, { sgZsr, .390 }, H };
N l31n131[] = { { sgw, 1.131 }, { svi, .637 }, { sgqXm, .234 }, H };
N l31n132[] = { { sgh, 2.008 }, H };
N l31n133[] = { { sirx, .487 }, { spX, .169 }, { sgri, .175 }, { sxe9, .065 }, H };
N l31n134[] = { { sgiw, .322 }, { smhX, .175 }, { ssvm, .117 }, H };
N l31n135[] = { { swxv, .136 }, H };
N l31n136[] = { { smXg, .409 }, { sXhsg, .390 }, { swiv, .175 }, H };
N l31n137[] = { { sir, .572 }, H };
N l31n140[] = { { svms, .214 }, H };
N l31n141[] = { { shX, .481 }, { smz, .117 }, { svsg, .175 }, H };
N l31n142[] = { { smk, .078 }, H };
N l31n143[] = { { sZv, .078 }, { sgpm, .146 }, H };
N l31n144[] = { { sww, .234 }, { sgswg, .312 }, H };
N l31n145[] = { { ssg, 3.645 }, H };
N l31n146[] = { { sqs, .195 }, { sipX, .097 }, H };
N l31n147[] = { { syqX, .234 }, { sgmr, .292 }, { sxXrx, .156 }, { sYi, .078 }, H };
N l31n148[] = { { sgx, .760 }, H };
N l31n149[] = { { sgi, .897 }, { sXz, .091 }, { smqir, .156 }, H };
N l31n150[] = { { ssyg, .351 }, { smxX, .097 }, H };
N l31n151[] = { { sguyi, .936 }, H };
N l31n155[] = { { sYvX, .097 }, H };
N l31n156[] = { { syX, .130 }, H };
N l31n157[] = { { ssp, .130 }, H };
N l31n158[] = { { sxv, .247 }, H };
N l31n159[] = { { svXg, .643 }, { sgsg, .497 }, H };
N l31n160[] = { { sgqm, .263 }, H };
N l31n161[] = { { swx, .442 }, { sRvms, .351 }, H };
N l31n162[] = { { swi, .559 }, { sqir, .312 }, { srsw, .136 }, H };
N l31n163[] = { { sqt, .117 }, H };
N l31n164[] = { { sqX, .507 }, { sgiqg, .273 }, H };
N l31n165[] = { { sgy, .214 }, H };
N l31n166[] = { { sgj, .546 }, H };
N l31n167[] = { { sxiv, .175 }, { sgti, .234 }, H };
N l31n169[] = { { sghsg, .663 }, { szs, .143 }, { sXmw, .117 }, H };
N l31n171[] = { { sit, .078 }, H };
N l31n174[] = { { ssq, .312 }, H };
N l31n175[] = { { sghX, .497 }, H };
N l31n177[] = { { srs, .429 }, { sgXg, .702 }, { sXvg, .380 }, { sZx, .117 }, { sf5iwg, .790 }, H };
N l31n178[] = { { sZi, .234 }, { sxiw, .156 }, { smhXh, .182 }, { swy, .065 }, H };
N l31n180[] = { { sirxi, .286 }, H };
N l31n182[] = { { sgz, .234 }, { srxiw, .156 }, H };
N l31n183[] = { { sgk, .136 }, { sxyv, .097 }, H };
N l31n184[] = { { sXm, .208 }, H };
N l31n185[] = { { sjs, .182 }, { sgrXg, .234 }, H };
N l31n186[] = { { smwg, .322 }, { sXhi, .195 }, H };
N l31n187[] = { { ssrx, .253 }, { szX, .156 }, { srhs, .136 }, H };
N l31n188[] = { { sxswg, .429 }, H };
N l31n189[] = { { srxig, .507 }, { syv, .130 }, H };
N l31n191[] = { { ssr, .351 }, { sgxX, .263 }, H };
N l31n192[] = { { sgQ, .136 }, H };
N l31n193[] = { { sxi, .611 }, { spls, .117 }, { sgjsv, .195 }, H };
N l31n194[] = { { sXwg, .673 }, { shiw, .195 }, H };
N l31n195[] = { { srX, .260 }, H };
N l31n196[] = { { sviZ, .175 }, H };
N l31n197[] = { { sbbg, .351 }, { swTs, .097 }, H };
N l31n199[] = { { svm, .494 }, H };
N l31n200[] = { { sgl, .097 }, H };
N l31n201[] = { { sgvi, .526 }, { sxvX, .214 }, { spi, .117 }, { sxXh, .156 }, H };
N l31n202[] = { { se7Xg, .461 }, { siZx, .117 }, H };
N l31n203[] = { { suyi, .507 }, { sxsg, .673 }, { srxs, .331 }, H };
N l31n204[] = { { shswg, .507 }, { swxX, .234 }, H };
N l31n205[] = { { siv, .533 }, H };
N l31n206[] = { { siZ, .260 }, { syw, .078 }, { sZXg, .146 }, H };
N l31n207[] = { { siww, .156 }, H };
N l31n209[] = { { shi, 1.027 }, { sgtXv, .585 }, { se7Ts, .614 }, { sxy, .156 }, { sRv, .175 }, H };
N l31n210[] = { { sirxs, .182 }, H };
N l31n211[] = { { ssqsg, .273 }, H };
N l31n212[] = { { sviwg, .234 }, { sXvm, .097 }, H };
N l31n213[] = { { stsv, .175 }, H };
N l31n215[] = { { sXe7T, .195 }, { smg, .136 }, { sqymx, .156 }, H };
N l31n216[] = { { siqg, .556 }, { sks, .091 }, H };
N l31n217[] = { { sgm, .351 }, { shXh, .195 }, { svxi, .117 }, H };
N l31n218[] = { { sgwi, .936 }, { siwx, .273 }, H };
N l31n219[] = { { sghi, 1.696 }, { shsg, 1.228 }, H };
N l31n220[] = { { sTs, .936 }, { sXvXg, .390 }, H };
N l31n221[] = { { sxXg, .205 }, H };
N l31n222[] = { { siw, .884 }, { shXwg, .273 }, H };
N l31n223[] = { { sXg, 2.671 }, { sih, .104 }, { syx, .091 }, H };
N l31n224[] = { { syi, .364 }, H };
N l31n226[] = { { sgiwx, .273 }, H };
N l31n227[] = { { smp, .195 }, H };
N l31n228[] = { { sgqmp, .195 }, H };
N l31n229[] = { { srZ, .130 }, { sXwm, .097 }, { sziv, .097 }, H };
N l31n230[] = { { swm, .234 }, { sqmr, .136 }, H };
N l31n231[] = { { stXv, .331 }, { swwi, .097 }, H };
N l31n232[] = { { sqi, .377 }, { swivg, .273 }, H };
N l31n234[] = { { sgn, .117 }, H };
N l31n235[] = { { sXp, .351 }, { sgxi, .263 }, { sgtip, .195 }, H };
N l31n236[] = { { svmsg, .234 }, H };
N l31n237[] = { { shXg, .439 }, H };
N l31n238[] = { { svg, .897 }, { svXq, .117 }, H };
N l31n239[] = { { sts, .351 }, H };
N l31n242[] = { { svmX, .195 }, { sqsg, .234 }, H };
N l31n243[] = { { sgrs, .585 }, { syqXg, .468 }, H };
N l31n244[] = { { smq, .208 }, H };
N l31n245[] = { { sgig, .526 }, { srw, .104 }, H };
N l31n246[] = { { sZm, .299 }, { srh, .221 }, H };
N l31n247[] = { { sls, .156 }, { sXvmX, .130 }, H };
N l31n248[] = { { sqy, .130 }, { swxi, .097 }, H };
N l31n249[] = { { svXr, .097 }, H };
N l31n252[] = { { sXq, .338 }, { spl, .156 }, H };
N l31n253[] = { { siwxX, .182 }, H };
N l31n254[] = { { sqirx, .338 }, H };
N l31n255[] = { { szi, .195 }, { ssvx, .136 }, H };

D l31_d = {
	"portuguese",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.236, 0.020, 0.072, 0.104, 0.218, 0.021, 0.024, 0.014, 0.140, 0.005, W, 0.050, 0.088, 0.103, 0.221,
	    0.055, 0.018, 0.139, 0.160, 0.109, 0.076, 0.028, 0.001, 0.006, 0.001, 0.004, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.010, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.009, Y, Y, Y, Y,
	    Y, 0.002, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    0.008, 0.019, 0.001, 0.037, V, V, V, 0.037, V, 0.025, 0.004, V, V, 0.018, V, V,
	    V, V, V, 0.005, V, 0.011, V, V, V, V, 0.002, V, V, V, V, V },
	{ l31n0, l31n1, l31n2, l31n3, l31n4, l31n5, l31n6, l31n7, l31n8, l31n9, l31n10, l31n11, l31n12, l31n13, X, l31n15,
	    X, l31n17, l31n18, X, l31n20, l31n21, l31n22, l31n23, X, X, l31n26, l31n27, l31n28, l31n29, l31n30, X,
	    l31n32, l31n33, l31n34, l31n35, l31n36, l31n37, X, l31n39, l31n40, X, X, l31n43, l31n44, l31n45, l31n46, l31n47,
	    l31n48, l31n49, X, X, l31n52, X, l31n54, l31n55, l31n56, X, l31n58, l31n59, l31n60, l31n61, l31n62, l31n63,
	    l31n64, l31n65, l31n66, l31n67, l31n68, l31n69, l31n70, l31n71, l31n72, l31n73, l31n74, l31n75, l31n76, l31n77, X, l31n79,
	    l31n80, l31n81, l31n82, l31n83, l31n84, l31n85, l31n86, l31n87, l31n88, l31n89, l31n90, l31n91, l31n92, l31n93, l31n94, l31n95,
	    l31n96, l31n97, l31n98, l31n99, X, X, X, l31n103, l31n104, X, l31n106, l31n107, l31n108, X, l31n110, X,
	    l31n112, X, l31n114, l31n115, l31n116, l31n117, l31n118, l31n119, l31n120, l31n121, l31n122, l31n123, l31n124, l31n125, l31n126, l31n127,
	    l31n128, X, l31n130, l31n131, l31n132, l31n133, l31n134, l31n135, l31n136, l31n137, X, X, l31n140, l31n141, l31n142, l31n143,
	    l31n144, l31n145, l31n146, l31n147, l31n148, l31n149, l31n150, l31n151, X, X, X, l31n155, l31n156, l31n157, l31n158, l31n159,
	    l31n160, l31n161, l31n162, l31n163, l31n164, l31n165, l31n166, l31n167, X, l31n169, X, l31n171, X, X, l31n174, l31n175,
	    X, l31n177, l31n178, X, l31n180, X, l31n182, l31n183, l31n184, l31n185, l31n186, l31n187, l31n188, l31n189, X, l31n191,
	    l31n192, l31n193, l31n194, l31n195, l31n196, l31n197, X, l31n199, l31n200, l31n201, l31n202, l31n203, l31n204, l31n205, l31n206, l31n207,
	    X, l31n209, l31n210, l31n211, l31n212, l31n213, X, l31n215, l31n216, l31n217, l31n218, l31n219, l31n220, l31n221, l31n222, l31n223,
	    l31n224, X, l31n226, l31n227, l31n228, l31n229, l31n230, l31n231, l31n232, X, l31n234, l31n235, l31n236, l31n237, l31n238, l31n239,
	    X, X, l31n242, l31n243, l31n244, l31n245, l31n246, l31n247, l31n248, l31n249, X, X, l31n252, l31n253, l31n254, l31n255 }
};

//
// Lng: romanian
// Enc: iso-8859-2
//

S sZXv[] = { 99, 97, r, 0 };
S sZXvi[] = { 99, 97, r, e, 0 };
S sypg[] = { u, l, a };
S smmg[] = { i, i, a };
S sXxX[] = { 97, t, 97, 0 };
S siwxi[] = { e, s, t, e, 0 };
S sXxXg[] = { 97, t, 97, a };
S sgZXv[] = { 32, 99, 97, r, 0 };
S sgZyg[] = { 32, 99, u, a };
S stig[] = { p, e, a };
S sXZi[] = { 97, 99, e, 0 };
S sgtig[] = { 32, p, e, a };
S spym[] = { l, u, i, 0 };
S sgZXg[] = { 32, 99, 97, a };
S spymg[] = { l, u, i, a };
S sZmg[] = { 99, i, a };
S ssXv[] = { o, 97, r, 0 };
S sipig[] = { e, l, e, a };
S srxv[] = { n, t, r, 0 };
S sZip[] = { 99, e, l, 0 };
S sgwXg[] = { 32, s, 97, a };
S sgryg[] = { 32, n, u, a };
S sypym[] = { u, l, u, i, 0 };
S sghmr[] = { 32, d, i, n, 0 };
S sgpy[] = { 32, l, u, 0 };
S sxvy[] = { t, r, u, 0 };
S sqyp[] = { m, u, l, 0 };
S sgXZi[] = { 32, 97, 99, e, 0 };
S spsvg[] = { l, o, r, a };
S sqXmg[] = { m, 97, i, a };
S syri[] = { u, n, e, 0 };
S smrm[] = { i, n, i, 0 };
S spsv[] = { l, o, r, 0 };
S sXxsv[] = { 97, t, o, r, 0 };
S sxmr[] = { t, i, n, 0 };
S sxyp[] = { t, u, l, 0 };
S stmr[] = { p, i, n, 0 };
S sgZip[] = { 32, 99, e, l, 0 };
S smpsv[] = { i, l, o, r, 0 };
S srxXg[] = { n, t, 97, a };
S sgty[] = { 32, p, u, 0 };
S swZg[] = { s, 99, a };
S ssXw[] = { o, 97, s, 0 };
S siwZg[] = { e, s, 99, a };
S ssXvi[] = { o, 97, r, e, 0 };
S smrxv[] = { i, n, t, r, 0 };
S shmrg[] = { d, i, n, a };
S srxm[] = { n, t, i, 0 };
S smqt[] = { i, m, p, 0 };
S smXx[] = { i, 97, t, 0 };
S svyp[] = { r, u, l, 0 };
S sxmig[] = { t, i, e, a };
S ssqy[] = { o, m, u, 0 };
S sXxig[] = { 97, t, e, a };
S ssvq[] = { o, r, m, 0 };
S sgvX[] = { 32, r, 97, 0 };
S svxm[] = { r, t, i, 0 };
S sqmrx[] = { m, i, n, t, 0 };
S sjXvX[] = { f, 97, r, 97, 0 };
S stXg[] = { p, 97, a };
S srim[] = { n, e, i, 0 };
S smxm[] = { i, t, i, 0 };
S stpm[] = { p, l, i, 0 };
S sxsvm[] = { t, o, r, i, 0 };
S svxX[] = { r, t, 97, 0 };
S siZm[] = { e, 99, i, 0 };
S svypg[] = { r, u, l, a };
S sgtp[] = { 32, p, l, 0 };
S sxmm[] = { t, i, i, 0 };
S swxXx[] = { s, t, 97, t, 0 };
S smrig[] = { i, n, e, a };
S spXv[] = { l, 97, r, 0 };
S srimg[] = { n, e, i, a };
S smsX[] = { i, o, 97, 0 };
S syxX[] = { u, t, 97, 0 };

N l32n0[] = { { siy, .078 }, H };
N l32n1[] = { { smrx, .466 }, { stX, .311 }, { swxg, .175 }, H };
N l32n2[] = { { swig, .524 }, H };
N l32n3[] = { { ssv, .518 }, H };
N l32n4[] = { { ssZ, .104 }, { sqXg, .233 }, { syrXg, .194 }, H };
N l32n5[] = { { smr, 1.346 }, { sxm, .660 }, { svxm, .117 }, H };
N l32n6[] = { { srx, .544 }, { sgwm, .990 }, H };
N l32n7[] = { { sri, .337 }, { sgtig, .544 }, { sghm, .320 }, H };
N l32n8[] = { { sXvig, 1.126 }, H };
N l32n9[] = { { siwxi, .466 }, H };
N l32n10[] = { { syxX, .097 }, H };
N l32n11[] = { { svq, .091 }, { skv, .078 }, H };
N l32n12[] = { { sgp, .583 }, { siXg, .350 }, H };
N l32n13[] = { { sXr, .337 }, { spm, .311 }, { swg, .136 }, { sgzi, .175 }, H };
N l32n14[] = { { sgwXg, .388 }, { sgZip, .233 }, H };
N l32n15[] = { { sji, .155 }, { sgst, .175 }, H };
N l32n16[] = { { smmg, .524 }, { sswx, .155 }, H };
N l32n18[] = { { sZig, .379 }, H };
N l32n19[] = { { sgpy, .262 }, H };
N l32n20[] = { { ssw, .155 }, H };
N l32n21[] = { { shm, .168 }, { sgts, .262 }, H };
N l32n22[] = { { sms, .168 }, H };
N l32n23[] = { { sry, .194 }, { sgxm, .175 }, H };
N l32n24[] = { { sXmg, .350 }, H };
N l32n29[] = { { sgq, .874 }, { sZg, .214 }, H };
N l32n30[] = { { sipig, .427 }, H };
N l32n31[] = { { siwZ, .136 }, H };
N l32n33[] = { { sxig, .961 }, H };
N l32n34[] = { { sZyg, .524 }, { stv, .207 }, H };
N l32n35[] = { { srXg, .437 }, H };
N l32n36[] = { { sym, .233 }, { smXx, .117 }, { sgqy, .175 }, { sivi, .097 }, { swxm, .097 }, H };
N l32n37[] = { { ssx, .168 }, { sgsv, .233 }, H };
N l32n39[] = { { sqXm, .155 }, { svmg, .204 }, { sgjXv, .194 }, { sXqX, .097 }, H };
N l32n40[] = { { smX, .388 }, { swxXx, .129 }, H };
N l32n41[] = { { spig, .495 }, { srk, .104 }, { sgjm, .175 }, H };
N l32n42[] = { { sXxig, .233 }, H };
N l32n44[] = { { sxg, .893 }, { sqm, .168 }, H };
N l32n45[] = { { svs, .104 }, H };
N l32n46[] = { { sgr, .427 }, { ski, .078 }, { ssvX, .097 }, H };
N l32n47[] = { { sXt, .194 }, { shmrg, .233 }, H };
N l32n48[] = { { smrX, .136 }, H };
N l32n49[] = { { shig, 1.369 }, { srxX, .136 }, H };
N l32n52[] = { { spg, .680 }, { sim, .324 }, H };
N l32n53[] = { { sgry, .320 }, H };
N l32n54[] = { { sgtv, .233 }, H };
N l32n55[] = { { sgpX, .379 }, { sgXv, .262 }, { svyp, .117 }, { s7aX, .065 }, H };
N l32n56[] = { { sgZs, .350 }, { sXxs, .136 }, H };
N l32n58[] = { { sgwig, .466 }, H };
N l32n59[] = { { sghig, 1.515 }, H };
N l32n60[] = { { shg, .136 }, H };
N l32n61[] = { { sYs, .078 }, H };
N l32n63[] = { { svX, .803 }, { sgs, .854 }, { stpm, .097 }, H };
N l32n65[] = { { smsX, .097 }, H };
N l32n66[] = { { sqmrx, .129 }, H };
N l32n67[] = { { stmr, .136 }, { szm, .078 }, H };
N l32n68[] = { { stx, .078 }, H };
N l32n69[] = { { sti, .324 }, H };
N l32n70[] = { { swmg, .874 }, H };
N l32n72[] = { { sgqX, .757 }, { ssk, .078 }, H };
N l32n73[] = { { smv, .142 }, { sghs, .233 }, H };
N l32n74[] = { { smZ, .324 }, H };
N l32n75[] = { { syg, .990 }, { srm, .375 }, H };
N l32n76[] = { { sws, .078 }, H };
N l32n77[] = { { sXvx, .136 }, { srhi, .136 }, H };
N l32n79[] = { { sYX, .078 }, H };
N l32n80[] = { { sgt, 1.321 }, { sivm, .117 }, H };
N l32n81[] = { { sXv, 1.126 }, { sgX, 1.379 }, { sghmr, .350 }, { smrh, .155 }, { sxsv, .136 }, { siZm, .097 }, H };
N l32n82[] = { { sXZ, .311 }, H };
N l32n83[] = { { sqg, .175 }, { sjm, .104 }, H };
N l32n84[] = { { sZXv, .408 }, H };
N l32n85[] = { { sty, .129 }, { si7a, .078 }, H };
N l32n86[] = { { sZmg, .350 }, { sZip, .194 }, H };
N l32n87[] = { { syp, .531 }, { sgty, .175 }, { smrxv, .155 }, H };
N l32n88[] = { { swxig, .621 }, H };
N l32n89[] = { { spsv, .155 }, { sgxs, .204 }, H };
N l32n90[] = { { smw, .168 }, H };
N l32n91[] = { { sig, 4.195 }, { smh, .078 }, H };
N l32n92[] = { { sZs, .220 }, { spym, .252 }, { sxmi, .155 }, { smri, .155 }, H };
N l32n94[] = { { swX, .272 }, { sypy, .194 }, { sXwx, .136 }, { sqXr, .117 }, H };
N l32n95[] = { { sgyr, .728 }, H };
N l32n97[] = { { stXg, .146 }, { svZ, .065 }, H };
N l32n98[] = { { sXw, .350 }, { sgY, .330 }, H };
N l32n99[] = { { ssvg, .350 }, { sXh, .104 }, H };
N l32n101[] = { { smrg, .961 }, { sxmg, .291 }, H };
N l32n102[] = { { sgwmg, 1.088 }, { srxg, .175 }, H };
N l32n103[] = { { sip, .427 }, { srig, .350 }, { sxsx, .136 }, H };
N l32n104[] = { { syq, .142 }, H };
N l32n107[] = { { sxs, .259 }, { smx, .259 }, { sgjs, .291 }, { spXv, .097 }, H };
N l32n108[] = { { smi, .259 }, H };
N l32n110[] = { { sZX, .673 }, H };
N l32n114[] = { { srg, 1.068 }, { sgv, .311 }, { skm, .104 }, H };
N l32n115[] = { { sgZ, 2.020 }, { sXx, .803 }, { sps, .220 }, H };
N l32n116[] = { { sviw, .136 }, H };
N l32n117[] = { { sxyp, .136 }, H };
N l32n119[] = { { sryg, .291 }, H };
N l32n120[] = { { siq, .104 }, H };
N l32n121[] = { { syr, .596 }, { sxXx, .214 }, { stvi, .097 }, H };
N l32n122[] = { { sgZy, .583 }, { sgxv, .233 }, H };
N l32n123[] = { { sgtX, .350 }, { shs, .117 }, { sYmp, .097 }, H };
N l32n124[] = { { sXvX, .330 }, { smy, .129 }, H };
N l32n125[] = { { sxX, .699 }, H };
N l32n127[] = { { sgwx, .262 }, { siwZg, .233 }, H };
N l32n128[] = { { swZ, .168 }, H };
N l32n130[] = { { svx, .194 }, H };
N l32n131[] = { { sgw, 1.806 }, { svi, .932 }, { sZXvi, .492 }, { sgqXm, .272 }, H };
N l32n132[] = { { sgh, 1.728 }, { sXy, .233 }, { symg, .466 }, H };
N l32n133[] = { { spX, .479 }, { sirx, .214 }, H };
N l32n134[] = { { sgiw, .291 }, { ssvm, .175 }, H };
N l32n135[] = { { sqXmg, .311 }, { swxv, .155 }, H };
N l32n136[] = { { smXg, .379 }, { smrm, .155 }, { sxmm, .097 }, H };
N l32n137[] = { { sir, .246 }, { stm, .168 }, { shXx, .175 }, { srxm, .117 }, H };
N l32n138[] = { { sqXv, .194 }, { srim, .097 }, H };
N l32n140[] = { { srmZ, .155 }, { sxsvm, .129 }, H };
N l32n141[] = { { shX, .337 }, { smz, .091 }, H };
N l32n142[] = { { sXxsv, .181 }, { sXhX, .117 }, H };
N l32n143[] = { { sZv, .091 }, H };
N l32n144[] = { { sXrm, .136 }, { smrXg, .233 }, H };
N l32n145[] = { { ssg, .388 }, { slm, .117 }, { srxXg, .233 }, H };
N l32n146[] = { { sgXZ, .350 }, { sqs, .117 }, { sipX, .097 }, H };
N l32n147[] = { { sgmr, 1.282 }, { svy, .207 }, H };
N l32n148[] = { { sgx, .621 }, { simg, .553 }, H };
N l32n149[] = { { sgi, .602 }, { sgryg, .350 }, H };
N l32n150[] = { { sXk, .078 }, H };
N l32n151[] = { { sgpXg, .427 }, { svypg, .194 }, H };
N l32n153[] = { { sypym, .233 }, H };
N l32n155[] = { { syt, .078 }, H };
N l32n156[] = { { sqyp, .155 }, H };
N l32n157[] = { { ssp, .129 }, { sgvX, .175 }, H };
N l32n158[] = { { sgZX, 1.194 }, { sxv, .440 }, { sXxX, .350 }, { sgqXv, .311 }, H };
N l32n159[] = { { svXg, .699 }, { sgsg, .553 }, H };
N l32n160[] = { { swmr, .136 }, H };
N l32n161[] = { { swx, .699 }, H };
N l32n162[] = { { swi, .414 }, H };
N l32n163[] = { { sqt, .091 }, { sYy, .078 }, H };
N l32n164[] = { { sqX, .505 }, { syrX, .136 }, H };
N l32n165[] = { { sgy, .602 }, { stig, .466 }, { sxvy, .155 }, { stvm, .136 }, H };
N l32n166[] = { { sgj, .738 }, H };
N l32n167[] = { { sgti, .612 }, H };
N l32n168[] = { { sXvi, .719 }, { smps, .136 }, H };
N l32n169[] = { { sXZi, .272 }, { szs, .065 }, H };
N l32n172[] = { { siX, .427 }, H };
N l32n173[] = { { svxX, .097 }, H };
N l32n174[] = { { ssq, .207 }, { sgwX, .437 }, { sviX, .136 }, H };
N l32n175[] = { { sghX, .408 }, H };
N l32n176[] = { { smm, .272 }, H };
N l32n177[] = { { sgXg, .291 }, { sXvg, .204 }, { sjXv, .136 }, { srs, .078 }, H };
N l32n178[] = { { sZi, .544 }, { swy, .117 }, { ssvq, .117 }, H };
N l32n181[] = { { sgxsx, .233 }, { ssqy, .117 }, H };
N l32n182[] = { { sgz, .330 }, H };
N l32n183[] = { { sypg, .524 }, { sgk, .175 }, H };
N l32n184[] = { { sXm, .246 }, { sgXyg, .194 }, H };
N l32n185[] = { { sjs, .155 }, { spsvg, .311 }, H };
N l32n188[] = { { spymg, .466 }, { stp, .091 }, { sxmig, .233 }, { smrig, .194 }, H };
N l32n189[] = { { syv, .181 }, H };
N l32n190[] = { { swXg, .408 }, { sipi, .233 }, H };
N l32n191[] = { { sgyrg, .505 }, { s7am, .168 }, { ssr, .117 }, { sxmr, .136 }, H };
N l32n193[] = { { sxi, .647 }, { sgXZi, .311 }, H };
N l32n194[] = { { sZy, .375 }, H };
N l32n195[] = { { srX, .259 }, H };
N l32n196[] = { { smqt, .117 }, H };
N l32n199[] = { { svm, .531 }, { sipg, .175 }, { spmr, .117 }, H };
N l32n200[] = { { ssXv, .233 }, { spx, .091 }, { sgl, .097 }, H };
N l32n201[] = { { spi, .337 }, { sxvX, .272 }, { sgvi, .175 }, H };
N l32n202[] = { { sgZi, .466 }, { sXxi, .155 }, H };
N l32n203[] = { { sjX, .207 }, { smxg, .262 }, H };
N l32n204[] = { { smig, .320 }, { swxX, .194 }, H };
N l32n205[] = { { siv, .311 }, { smZm, .194 }, { swiX, .117 }, H };
N l32n206[] = { { sZXg, .466 }, { siZ, .129 }, H };
N l32n207[] = { { shmr, .175 }, H };
N l32n208[] = { { syri, .155 }, H };
N l32n209[] = { { shi, .867 }, { sxy, .181 }, { sgjX, .350 }, { sgtXv, .233 }, H };
N l32n211[] = { { sXxg, .350 }, { ssXw, .117 }, { sgtm, .146 }, H };
N l32n212[] = { { sXvm, .117 }, { sjXvX, .129 }, H };
N l32n215[] = { { smg, 2.758 }, { sYm, .155 }, H };
N l32n217[] = { { sgm, 1.068 }, { spy, .311 }, { syrg, .524 }, { sX7a, .091 }, H };
N l32n218[] = { { siwx, .447 }, { sgwi, .583 }, { sgZyg, .660 }, H };
N l32n219[] = { { sghi, 1.427 }, H };
N l32n220[] = { { sXvXg, .544 }, H };
N l32n221[] = { { sxXg, 1.049 }, H };
N l32n222[] = { { siw, .492 }, H };
N l32n223[] = { { sXg, 3.748 }, { syx, .155 }, H };
N l32n224[] = { { swZg, .175 }, H };
N l32n225[] = { { sst, .129 }, { shy, .078 }, H };
N l32n226[] = { { ssX, .388 }, { sgiwx, .388 }, { sgqs, .175 }, H };
N l32n227[] = { { svig, .961 }, { smp, .246 }, H };
N l32n228[] = { { sXyg, .379 }, H };
N l32n229[] = { { spXg, .641 }, { srZ, .104 }, { sZl, .091 }, H };
N l32n230[] = { { swm, .608 }, { sqmr, .136 }, H };
N l32n231[] = { { stXv, .175 }, H };
N l32n232[] = { { sqi, .220 }, H };
N l32n234[] = { { skX, .129 }, { srimg, .194 }, H };
N l32n235[] = { { sXp, .259 }, H };
N l32n236[] = { { srxv, .194 }, { sjv, .078 }, H };
N l32n237[] = { { shXg, .204 }, H };
N l32n238[] = { { svg, .447 }, { smxm, .097 }, H };
N l32n239[] = { { sts, .155 }, { six, .142 }, { sgmrx, .427 }, H };
N l32n243[] = { { sgmrg, .777 }, H };
N l32n244[] = { { sgZXv, .660 }, { smq, .129 }, { sgtp, .146 }, H };
N l32n245[] = { { srw, .117 }, { sgig, .233 }, { sxvi, .117 }, H };
N l32n246[] = { { sZm, .427 }, { srh, .168 }, { sXxm, .175 }, { sgZm, .204 }, H };
N l32n247[] = { { ssXvi, .155 }, H };
N l32n248[] = { { swxi, .427 }, { sqy, .168 }, H };
N l32n249[] = { { svXr, .136 }, H };
N l32n250[] = { { sg7a, .117 }, H };
N l32n252[] = { { sXq, .220 }, H };
N l32n254[] = { { sXxXg, .660 }, { sgZXg, .505 }, { smpsv, .155 }, H };
N l32n255[] = { { szi, .155 }, H };

D l32_d = {
	"romanian",
	"iso-8859-2",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.004, W, W, W, W, W, W, W, 0.001,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, W, 0.001, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.284, 0.021, 0.107, 0.068, 0.235, 0.031, 0.022, 0.008, 0.243, 0.004, 0.001, 0.091, 0.061, 0.123, 0.098,
	    0.061, W, 0.140, 0.104, 0.143, 0.115, 0.018, W, 0.002, W, 0.014, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l32n0, l32n1, l32n2, l32n3, l32n4, l32n5, l32n6, l32n7, l32n8, l32n9, l32n10, l32n11, l32n12, l32n13, l32n14, l32n15,
	    l32n16, X, l32n18, l32n19, l32n20, l32n21, l32n22, l32n23, l32n24, X, X, X, X, l32n29, l32n30, l32n31,
	    X, l32n33, l32n34, l32n35, l32n36, l32n37, X, l32n39, l32n40, l32n41, l32n42, X, l32n44, l32n45, l32n46, l32n47,
	    l32n48, l32n49, X, X, l32n52, l32n53, l32n54, l32n55, l32n56, X, l32n58, l32n59, l32n60, l32n61, X, l32n63,
	    X, l32n65, l32n66, l32n67, l32n68, l32n69, l32n70, X, l32n72, l32n73, l32n74, l32n75, l32n76, l32n77, X, l32n79,
	    l32n80, l32n81, l32n82, l32n83, l32n84, l32n85, l32n86, l32n87, l32n88, l32n89, l32n90, l32n91, l32n92, X, l32n94, l32n95,
	    X, l32n97, l32n98, l32n99, X, l32n101, l32n102, l32n103, l32n104, X, X, l32n107, l32n108, X, l32n110, X,
	    X, X, l32n114, l32n115, l32n116, l32n117, X, l32n119, l32n120, l32n121, l32n122, l32n123, l32n124, l32n125, X, l32n127,
	    l32n128, X, l32n130, l32n131, l32n132, l32n133, l32n134, l32n135, l32n136, l32n137, l32n138, X, l32n140, l32n141, l32n142, l32n143,
	    l32n144, l32n145, l32n146, l32n147, l32n148, l32n149, l32n150, l32n151, X, l32n153, X, l32n155, l32n156, l32n157, l32n158, l32n159,
	    l32n160, l32n161, l32n162, l32n163, l32n164, l32n165, l32n166, l32n167, l32n168, l32n169, X, X, l32n172, l32n173, l32n174, l32n175,
	    l32n176, l32n177, l32n178, X, X, l32n181, l32n182, l32n183, l32n184, l32n185, X, X, l32n188, l32n189, l32n190, l32n191,
	    X, l32n193, l32n194, l32n195, l32n196, X, X, l32n199, l32n200, l32n201, l32n202, l32n203, l32n204, l32n205, l32n206, l32n207,
	    l32n208, l32n209, X, l32n211, l32n212, X, X, l32n215, X, l32n217, l32n218, l32n219, l32n220, l32n221, l32n222, l32n223,
	    l32n224, l32n225, l32n226, l32n227, l32n228, l32n229, l32n230, l32n231, l32n232, X, l32n234, l32n235, l32n236, l32n237, l32n238, l32n239,
	    X, X, X, l32n243, l32n244, l32n245, l32n246, l32n247, l32n248, l32n249, l32n250, X, l32n252, X, l32n254, l32n255 }
};

//
// Lng: russian
// Enc: koi8-r
//

S sEcf[] = { 212, 207, 0 };
S sDE[] = { 211, 212, 0 };
S sCc1[] = { 210, 193, 0 };
S scfH[] = { 207, 215, 0 };
S scecf[] = { 206, 207, 0 };
S sAcf[] = { 208, 207, 0 };
S scec1[] = { 206, 193, 0 };
S sEc1[] = { 212, 193, 0 };
S scbcf[] = { 203, 207, 0 };
S sCcf[] = { 210, 207, 0 };
S sc7cf[] = { 199, 207, 0 };
S scec5[] = { 206, 197, 0 };
S sgAcf[] = { 32, 208, 207, 0 };
S sc5ce[] = { 197, 206, 0 };
S scfcc[] = { 207, 204, 0 };
S sc5E[] = { 197, 212, 0 };
S scec9[] = { 206, 201, 0 };
S scfD[] = { 207, 211, 0 };
S sc1ce[] = { 193, 206, 0 };
S scfc7[] = { 207, 199, 0 };
S sEc5[] = { 212, 197, 0 };
S sc1E[] = { 193, 212, 0 };
S sc5D[] = { 197, 211, 0 };
S sc5C[] = { 197, 210, 0 };
S sccc5[] = { 204, 197, 0 };
S scccf[] = { 204, 207, 0 };
S sc5cc[] = { 197, 204, 0 };
S sCc5[] = { 210, 197, 0 };
S scfcd[] = { 207, 205, 0 };
S sgAC[] = { 32, 208, 210, 0 };
S sc9ce[] = { 201, 206, 0 };
S sDcb[] = { 211, 203, 0 };
S sccI[] = { 204, 216, 0 };
S sc7cfg[] = { 199, 207, a };
S scfc4[] = { 207, 196, 0 };
S sc1cc[] = { 193, 204, 0 };
S sHcf[] = { 215, 207, 0 };
S sCc9[] = { 210, 201, 0 };
S scfce[] = { 207, 206, 0 };
S sEcfg[] = { 212, 207, a };
S sEIg[] = { 212, 216, a };
S scdcf[] = { 205, 207, 0 };
S sgHg[] = { 32, 215, a };
S sHJ[] = { 215, 217, 0 };
S scfE[] = { 207, 212, 0 };
S sc4cf[] = { 196, 207, 0 };
S sccc9[] = { 204, 201, 0 };
S scec1g[] = { 206, 193, a };
S sc5cd[] = { 197, 205, 0 };
S sc9c5[] = { 201, 197, 0 };
S scfc7cf[] = { 207, 199, 207, 0 };
S sc5Eg[] = { 197, 212, a };
S sc1H[] = { 193, 215, 0 };
S scfC[] = { 207, 210, 0 };
S sDc5[] = { 211, 197, 0 };
S scbc1[] = { 203, 193, 0 };
S sgcec1[] = { 32, 206, 193, 0 };
S scfca[] = { 207, 202, 0 };
S sOEcf[] = { 222, 212, 207, 0 };
S sgcec5[] = { 32, 206, 197, 0 };
S scfc7cfg[] = { 207, 199, 207, a };
S sgOE[] = { 32, 222, 212, 0 };
S sccc1[] = { 204, 193, 0 };
S sceJ[] = { 206, 217, 0 };
S sgOEcf[] = { 32, 222, 212, 207, 0 };
S sEc9[] = { 212, 201, 0 };
S sc5H[] = { 197, 215, 0 };
S sc1cd[] = { 193, 205, 0 };
S sAc5[] = { 208, 197, 0 };
S sEH[] = { 212, 215, 0 };
S sEC[] = { 212, 210, 0 };
S sc9E[] = { 201, 212, 0 };
S scfcag[] = { 207, 202, a };
S sACcf[] = { 208, 210, 207, 0 };
S sOEcfg[] = { 222, 212, 207, a };
S sc1C[] = { 193, 210, 0 };
S scdc9[] = { 205, 201, 0 };
S scbc9[] = { 203, 201, 0 };
S sc9cc[] = { 201, 204, 0 };
S sOc1[] = { 222, 193, 0 };
S sc5c7[] = { 197, 199, 0 };
S sc9c9g[] = { 201, 201, a };
S sc5DE[] = { 197, 211, 212, 0 };
S sgDE[] = { 32, 211, 212, 0 };
S sKc1[] = { 218, 193, 0 };
S sc9c9[] = { 201, 201, 0 };
S sDEH[] = { 211, 212, 215, 0 };
S sc9c5g[] = { 201, 197, a };
S sDcf[] = { 211, 207, 0 };
S scecfg[] = { 206, 207, a };
S sc2J[] = { 194, 217, 0 };
S sc9cd[] = { 201, 205, 0 };
S sc2cf[] = { 194, 207, 0 };
S sgACcf[] = { 32, 208, 210, 207, 0 };
S sDcbcf[] = { 211, 203, 207, 0 };
S sc7c9[] = { 199, 201, 0 };
S sgEcf[] = { 32, 212, 207, 0 };
S sc9D[] = { 201, 211, 0 };
S sc7c1[] = { 199, 193, 0 };
S sc1K[] = { 193, 218, 0 };
S sgcbcf[] = { 32, 203, 207, 0 };
S scec5g[] = { 206, 197, a };
S scfcdg[] = { 207, 205, a };
S sDB[] = { 211, 209, 0 };
S sgc4cf[] = { 32, 196, 207, 0 };
S sDEc1[] = { 211, 212, 193, 0 };
S scfG[] = { 207, 214, 0 };
S scbE[] = { 203, 212, 0 };
S sgcdcf[] = { 32, 205, 207, 0 };
S scfc2[] = { 207, 194, 0 };
S sgCc1[] = { 32, 210, 193, 0 };
S scfO[] = { 207, 222, 0 };
S sDBg[] = { 211, 209, a };
S sc5cb[] = { 197, 203, 0 };
S scfHg[] = { 207, 215, a };
S sc9c8g[] = { 201, 200, a };
S sc5K[] = { 197, 218, 0 };
S sgEc1[] = { 32, 212, 193, 0 };
S scfDE[] = { 207, 211, 212, 0 };
S sgc9g[] = { 32, 201, a };
S scfcb[] = { 207, 203, 0 };
S sc1ccI[] = { 193, 204, 216, 0 };
S sc5c5[] = { 197, 197, 0 };
S sAc5C[] = { 208, 197, 210, 0 };
S sccB[] = { 204, 209, 0 };
S sBE[] = { 209, 212, 0 };
S scfccI[] = { 207, 204, 216, 0 };
S sc4c9[] = { 196, 201, 0 };
S sc1B[] = { 193, 209, 0 };
S sc1Bg[] = { 193, 209, a };
S scecfc7[] = { 206, 207, 199, 0 };
S sc3c9[] = { 195, 201, 0 };
S sJc8[] = { 217, 200, 0 };
S sc1Cc1[] = { 193, 210, 193, 0 };
S sJc8g[] = { 217, 200, a };
S sDEcf[] = { 211, 212, 207, 0 };
S sc9cb[] = { 201, 203, 0 };
S sHc1g[] = { 215, 193, a };
S sc5cec9[] = { 197, 206, 201, 0 };
S sceI[] = { 206, 216, 0 };
S sgcec1g[] = { 32, 206, 193, a };
S sc5c7cf[] = { 197, 199, 207, 0 };
S sceIg[] = { 206, 216, a };
S sgEc1cb[] = { 32, 212, 193, 203, 0 };
S sc4ce[] = { 196, 206, 0 };
S sc5cag[] = { 197, 202, a };
S sIce[] = { 216, 206, 0 };
S sgKc1[] = { 32, 218, 193, 0 };
S scfc9[] = { 207, 201, 0 };
S sc1cdg[] = { 193, 205, a };
S sc5ceIg[] = { 197, 206, 216, a };
S sceE[] = { 206, 212, 0 };
S sHD[] = { 215, 211, 0 };
S sDce[] = { 211, 206, 0 };
S sc5cdg[] = { 197, 205, a };
S sccIce[] = { 204, 216, 206, 0 };
S scece[] = { 206, 206, 0 };
S sc5c7cfg[] = { 197, 199, 207, a };
S scecfH[] = { 206, 207, 215, 0 };
S sOc5ce[] = { 222, 197, 206, 0 };
S scfc5[] = { 207, 197, 0 };
S sCcfH[] = { 210, 207, 215, 0 };
S sEc1cb[] = { 212, 193, 203, 0 };
S sHce[] = { 215, 206, 0 };
S sgAc5[] = { 32, 208, 197, 0 };
S sc5ceI[] = { 197, 206, 216, 0 };
S sEc1E[] = { 212, 193, 212, 0 };
S sgDc5[] = { 32, 211, 197, 0 };
S scecfc7cf[] = { 206, 207, 199, 207, 0 };
S sDcbc9[] = { 211, 203, 201, 0 };
S scfGc5[] = { 207, 214, 197, 0 };
S sME[] = { 220, 212, 0 };
S sAcfcc[] = { 208, 207, 204, 0 };
S scec9c5[] = { 206, 201, 197, 0 };
S sc5Cc5[] = { 197, 210, 197, 0 };
S sgACc9[] = { 32, 208, 210, 201, 0 };
S sgHcf[] = { 32, 215, 207, 0 };
S sAc1[] = { 208, 193, 0 };
S sOc5ceI[] = { 222, 197, 206, 216, 0 };
S scfc7c9[] = { 207, 199, 201, 0 };
S sgc2J[] = { 32, 194, 217, 0 };
S sEcfC[] = { 212, 207, 210, 0 };
S sccc9g[] = { 204, 201, a };
S sf0c1[] = { 240, 193, 0 };
S sHc9[] = { 215, 201, 0 };
S scfOc5[] = { 207, 222, 197, 0 };
S sJE[] = { 217, 212, 0 };
S sc9H[] = { 201, 215, 0 };
S sgc2cf[] = { 32, 194, 207, 0 };
S sc1Ec5[] = { 193, 212, 197, 0 };
S sCc1K[] = { 210, 193, 218, 0 };
S sgME[] = { 32, 220, 212, 0 };
S sED[] = { 212, 211, 0 };
S scfHc1[] = { 207, 215, 193, 0 };
S sEc5C[] = { 212, 197, 210, 0 };
S sgHJ[] = { 32, 215, 217, 0 };
S sLc9[] = { 219, 201, 0 };
S sgf0c1[] = { 32, 240, 193, 0 };
S sACc9[] = { 208, 210, 201, 0 };
S sNc5[] = { 221, 197, 0 };
S sHcc[] = { 215, 204, 0 };
S sGc9[] = { 214, 201, 0 };
S sEc5cc[] = { 212, 197, 204, 0 };
S sc9ca[] = { 201, 202, 0 };
S scfc6[] = { 207, 198, 0 };
S sEB[] = { 212, 209, 0 };
S sc4c1g[] = { 196, 193, a };
S sgDcc[] = { 32, 211, 204, 0 };
S scec1B[] = { 206, 193, 209, 0 };
S scfHJ[] = { 207, 215, 217, 0 };
S sCc1g[] = { 210, 193, a };
S sc6c7c1ce[] = { 198, 199, 193, 206, 0 };
S sc1EI[] = { 193, 212, 216, 0 };
S sGc5ce[] = { 214, 197, 206, 0 };
S scfCcf[] = { 207, 210, 207, 0 };
S sc1ccIce[] = { 193, 204, 216, 206, 0 };
S sc1DE[] = { 193, 211, 212, 0 };
S sDc1[] = { 211, 193, 0 };
S sgcfOc5[] = { 32, 207, 222, 197, 0 };
S sGc5g[] = { 214, 197, a };
S sJcd[] = { 217, 205, 0 };
S sc2cfcc[] = { 194, 207, 204, 0 };
S sc1EIg[] = { 193, 212, 216, a };
S sJcdg[] = { 217, 205, a };
S sc1cec5[] = { 193, 206, 197, 0 };
S sc9c2[] = { 201, 194, 0 };
S sccc1g[] = { 204, 193, a };
S sEc1cc[] = { 212, 193, 204, 0 };
S sgDcf[] = { 32, 211, 207, 0 };
S sc9cag[] = { 201, 202, a };
S sEDBg[] = { 212, 211, 209, a };
S scbc1g[] = { 203, 193, a };
S sccc5E[] = { 204, 197, 212, 0 };
S scec3[] = { 206, 195, 0 };
S sNc9[] = { 221, 201, 0 };
S sJca[] = { 217, 202, 0 };
S sc6c7[] = { 198, 199, 0 };
S sFO[] = { 213, 222, 0 };
S sDEc5[] = { 211, 212, 197, 0 };
S sgc4c5[] = { 32, 196, 197, 0 };
S sJcag[] = { 217, 202, a };
S scec1Bg[] = { 206, 193, 209, a };
S sc7c1ce[] = { 199, 193, 206, 0 };
S scfOc5ce[] = { 207, 222, 197, 206, 0 };
S sgcfO[] = { 32, 207, 222, 0 };
S sceB[] = { 206, 209, 0 };
S sc2c5[] = { 194, 197, 0 };
S scfccc5[] = { 207, 204, 197, 0 };
S scccfg[] = { 204, 207, a };
S sEDB[] = { 212, 211, 209, 0 };
S sc9B[] = { 201, 209, 0 };
S sc6c7c1[] = { 198, 199, 193, 0 };
S scfcccf[] = { 207, 204, 207, 0 };
S sACc5[] = { 208, 210, 197, 0 };
S scfK[] = { 207, 218, 0 };
S sc1Hcc[] = { 193, 215, 204, 0 };
S sc9Bg[] = { 201, 209, a };
S sEJ[] = { 212, 217, 0 };
S sFcb[] = { 213, 203, 0 };
S sgAc1[] = { 32, 208, 193, 0 };
S sgedcf[] = { 32, 237, 207, 0 };
S sgACc5[] = { 32, 208, 210, 197, 0 };
S sgcec5g[] = { 32, 206, 197, a };
S sc5Cc1[] = { 197, 210, 193, 0 };
S sc5cccf[] = { 197, 204, 207, 0 };
S scecb[] = { 206, 203, 0 };
S sge7C[] = { 32, 231, 210, 0 };
S scbH[] = { 203, 215, 0 };
S sccBg[] = { 204, 209, a };
S sKce[] = { 218, 206, 0 };
S sgcdc5[] = { 32, 205, 197, 0 };
S sc9cdc5[] = { 201, 205, 197, 0 };
S sgcfE[] = { 32, 207, 212, 0 };
S sc9cec1[] = { 201, 206, 193, 0 };
S sgAcfcc[] = { 32, 208, 207, 204, 0 };
S se7C[] = { 231, 210, 0 };
S sc9O[] = { 201, 222, 0 };
S s80g[] = { 128, a };
S sOc1D[] = { 222, 193, 211, 0 };
S sc9C[] = { 201, 210, 0 };
S sg80[] = { 32, 128, 0 };
S sf0c1H[] = { 240, 193, 215, 0 };
S scccfH[] = { 204, 207, 215, 0 };
S sAcfcd[] = { 208, 207, 205, 0 };
S sKF[] = { 218, 213, 0 };
S sgcdc9[] = { 32, 205, 201, 0 };
S sc5ccc5[] = { 197, 204, 197, 0 };
S sgf0c1H[] = { 32, 240, 193, 215, 0 };
S sc4c5cc[] = { 196, 197, 204, 0 };
S sCc5c4[] = { 210, 197, 196, 0 };
S scfDcb[] = { 207, 211, 203, 0 };
S sedcf[] = { 237, 207, 0 };
S sg80g[] = { 32, 128, a };
S sc1c2[] = { 193, 194, 0 };
S scec9g[] = { 206, 201, a };
S sgccc5[] = { 32, 204, 197, 0 };
S sEce[] = { 212, 206, 0 };
S scdcfG[] = { 205, 207, 214, 0 };
S scdce[] = { 205, 206, 0 };
S sc1O[] = { 193, 222, 0 };
S sJc5g[] = { 217, 197, a };
S sEc5g[] = { 212, 197, a };
S sCc1ce[] = { 210, 193, 206, 0 };
S sDEC[] = { 211, 212, 210, 0 };
S se7Cc1O[] = { 231, 210, 193, 222, 0 };
S sHDcb[] = { 215, 211, 203, 0 };
S scfccIcb[] = { 207, 204, 216, 203, 0 };
S sIcbcf[] = { 216, 203, 207, 0 };
S sgc2JE[] = { 32, 194, 217, 212, 0 };
S sgc2cfcc[] = { 32, 194, 207, 204, 0 };
S sOc9[] = { 222, 201, 0 };
S sccF[] = { 204, 213, 0 };
S sBEIg[] = { 209, 212, 216, a };
S sc2c9[] = { 194, 201, 0 };
S scbc9c5g[] = { 203, 201, 197, a };
S scfHc5[] = { 207, 215, 197, 0 };
S sJEIg[] = { 217, 212, 216, a };
S sc5cbE[] = { 197, 203, 212, 0 };
S scbcfcag[] = { 203, 207, 202, a };
S scfcec1[] = { 207, 206, 193, 0 };
S sc1Oc5[] = { 193, 222, 197, 0 };
S scbcfH[] = { 203, 207, 215, 0 };
S sCcfc4[] = { 210, 207, 196, 0 };

N l33n1[] = { { sAc1, .222 }, { sc2cfcc, .296 }, H };
N l33n3[] = { { scfC, .494 }, { sgf3, .132 }, { sJEIg, .444 }, H };
N l33n4[] = { { sEI, .666 }, H };
N l33n5[] = { { sc9ce, .765 }, { sgcec5, .469 }, { sEc9, .469 }, { sgF, .165 }, { sgACc5, .230 }, H };
N l33n6[] = { { sceE, .247 }, H };
N l33n7[] = { { scec5, 1.061 }, { sACcf, .592 }, H };
N l33n8[] = { { sDcb, .716 }, H };
N l33n10[] = { { sEDBg, .592 }, { scfcec1, .222 }, H };
N l33n11[] = { { sgc2cfcc, .197 }, { sBEIg, .444 }, H };
N l33n12[] = { { sccI, .716 }, { sHD, .247 }, { sgHcf, .222 }, H };
N l33n13[] = { { sc1ce, .963 }, { sccc9, .543 }, H };
N l33n14[] = { { scfcdg, .722 }, H };
N l33n16[] = { { sc9c9g, .833 }, H };
N l33n17[] = { { scecfg, .833 }, { sgACc9, .296 }, { sJcag, .444 }, H };
N l33n18[] = { { sc5c7, .370 }, { sceg, .296 }, H };
N l33n20[] = { { scfD, .963 }, { scfccc5, .296 }, { sKce, .173 }, { sgf4, .115 }, H };
N l33n21[] = { { scfc4, .716 }, { sc4c9, .271 }, { sgc2J, .222 }, { sEJ, .173 }, { sc9O, .173 }, H };
N l33n22[] = { { sgG, .165 }, H };
N l33n23[] = { { sgc7, .197 }, H };
N l33n24[] = { { sDEc5, .296 }, { sc5Cc1, .259 }, H };
N l33n25[] = { { sDcc, .346 }, { sCc1ce, .222 }, H };
N l33n27[] = { { sgf0c1, .222 }, { sc1EIg, .592 }, H };
N l33n28[] = { { sNc9, .197 }, H };
N l33n29[] = { { sgCc1, .296 }, { sc1O, .173 }, H };
N l33n30[] = { { sHc5, .518 }, { scec1Bg, .592 }, { sf0c1H, .259 }, H };
N l33n32[] = { { sgcdc9, .173 }, H };
N l33n33[] = { { sc9cag, .444 }, { sEc5g, .333 }, H };
N l33n34[] = { { sAC, .814 }, { sc5H, .444 }, H };
N l33n35[] = { { scec1g, 1.222 }, { sgACcf, .461 }, H };
N l33n37[] = { { scfE, .568 }, H };
N l33n38[] = { { scfc5, .247 }, H };
N l33n39[] = { { sgH, .938 }, { sgOEcf, .625 }, { sgAc5, .247 }, H };
N l33n41[] = { { sHg, 1.777 }, { sgcfO, .197 }, H };
N l33n44[] = { { scdc9, .395 }, { sc5cec9, .407 }, H };
N l33n45[] = { { sCcf, 1.111 }, { scfc7cf, .814 }, H };
N l33n47[] = { { sc1A, .173 }, H };
N l33n48[] = { { scfDE, .444 }, H };
N l33n49[] = { { scfg, 3.887 }, { sc5ceIg, .740 }, { sc6c7, .197 }, H };
N l33n51[] = { { sc1ccI, .407 }, H };
N l33n54[] = { { sEc1cb, .370 }, H };
N l33n55[] = { { sKc1, .370 }, { sge7, .148 }, { scfc6, .197 }, H };
N l33n56[] = { { sc7cfg, 1.610 }, { sc9B, .197 }, H };
N l33n57[] = { { sgc9, .444 }, { sgcec1g, .362 }, { sc9c2, .197 }, H };
N l33n58[] = { { sHc1g, .611 }, { sc1cbg, .333 }, H };
N l33n59[] = { { sOEcfg, 1.185 }, { sDce, .247 }, { sOc9, .148 }, H };
N l33n61[] = { { sc2cf, .346 }, { sge7C, .173 }, H };
N l33n62[] = { { scecfc7, .407 }, H };
N l33n63[] = { { sCc1, 1.357 }, { sgEc1, .296 }, H };
N l33n64[] = { { sgcbcf, .321 }, { sc1B, .271 }, H };
N l33n65[] = { { sEc1cc, .296 }, { sc1c2, .173 }, H };
N l33n67[] = { { sGc9, .197 }, H };
N l33n68[] = { { sc5Cc5, .333 }, { sJcdg, .444 }, H };
N l33n69[] = { { sAc5, .444 }, { sc5ca, .296 }, H };
N l33n70[] = { { scfOc5, .333 }, { sFcb, .173 }, { scfccIcb, .296 }, H };
N l33n71[] = { { scfG, .321 }, H };
N l33n72[] = { { sIg, 1.814 }, { scfc7, .913 }, { sc4cc, .173 }, H };
N l33n73[] = { { sc9C, .173 }, H };
N l33n74[] = { { sceI, .271 }, H };
N l33n75[] = { { scec9, .963 }, { sAc5C, .407 }, H };
N l33n76[] = { { sDcf, .370 }, { sc5cccf, .259 }, H };
N l33n79[] = { { sc5Eg, 1.166 }, H };
N l33n80[] = { { sc9cec1, .259 }, H };
N l33n81[] = { { sc1C, .395 }, H };
N l33n84[] = { { scbcf, 1.135 }, H };
N l33n85[] = { { sc5K, .296 }, H };
N l33n86[] = { { sc5cb, .296 }, H };
N l33n87[] = { { sc5c7cfg, .740 }, H };
N l33n88[] = { { scfH, 1.333 }, { sc8g, 1.000 }, H };
N l33n89[] = { { sOc5ceI, .444 }, { sge9, .132 }, H };
N l33n90[] = { { sc9D, .346 }, { sgK, .181 }, { sgDc5, .222 }, { sEce, .173 }, H };
N l33n91[] = { { sgcb, .378 }, { sceJ, .469 }, { sJE, .222 }, { sgc4c5, .197 }, H };
N l33n92[] = { { sc1cdg, .555 }, H };
N l33n94[] = { { sDc1, .197 }, H };
N l33n95[] = { { sGc5g, .444 }, H };
N l33n96[] = { { sg80, .115 }, { sc0g, .222 }, H };
N l33n98[] = { { sc1D, .346 }, { sgcdcf, .296 }, { sHc9, .222 }, { scbcfcag, .444 }, H };
N l33n99[] = { { sBE, .271 }, { sc1c4, .173 }, H };
N l33n100[] = { { sEIg, 1.444 }, H };
N l33n101[] = { { sgcec5g, .230 }, H };
N l33n102[] = { { scbc1, .494 }, H };
N l33n103[] = { { sc5cc, .765 }, { sJg, .555 }, { scec5g, .722 }, H };
N l33n106[] = { { sc4ce, .247 }, { scfc9, .247 }, { sCcfH, .370 }, { sc1Hcc, .259 }, H };
N l33n107[] = { { sEcf, 1.777 }, { sc9E, .420 }, { sc9cdc5, .259 }, H };
N l33n108[] = { { sc9c5, .543 }, { sgcc, .214 }, H };
N l33n109[] = { { sccc9g, .500 }, { scecb, .173 }, H };
N l33n110[] = { { sDB, .321 }, H };
N l33n111[] = { { sBg, 1.703 }, H };
N l33n113[] = { { sEcfC, .333 }, H };
N l33n114[] = { { sHJ, .617 }, { sc7c9, .346 }, { sedcf, .173 }, { sc5cbE, .222 }, H };
N l33n115[] = { { sc1E, .888 }, { scccf, .790 }, H };
N l33n119[] = { { sc9g, 2.369 }, H };
N l33n120[] = { { sc5cd, .543 }, { sgcfOc5, .263 }, H };
N l33n122[] = { { sgHJ, .222 }, H };
N l33n123[] = { { sc4cf, .568 }, { scfca, .494 }, { sgeb, .099 }, H };
N l33n124[] = { { sgM, .197 }, { sc6c7c1, .296 }, H };
N l33n125[] = { { sEc1, 1.160 }, { sgcd, .559 }, H };
N l33n126[] = { { sc1DE, .296 }, H };
N l33n127[] = { { sc1g, 3.369 }, H };
N l33n129[] = { { scdce, .173 }, H };
N l33n130[] = { { scfcccf, .259 }, { sgedcf, .173 }, H };
N l33n131[] = { { sCc5, .765 }, H };
N l33n132[] = { { sc1cec5, .296 }, H };
N l33n133[] = { { sccc1, .469 }, { sEc5cc, .296 }, H };
N l33n134[] = { { sDEcf, .407 }, H };
N l33n135[] = { { sgHg, .617 }, H };
N l33n136[] = { { sIcbcf, .222 }, H };
N l33n137[] = { { sc5ce, 1.012 }, { sFO, .197 }, H };
N l33n139[] = { { sFc0, .197 }, { scfK, .173 }, { sKF, .173 }, H };
N l33n140[] = { { scfcb, .271 }, H };
N l33n141[] = { { scfc7cfg, 1.407 }, { sc4c1, .420 }, { sEB, .197 }, H };
N l33n142[] = { { sgce, .773 }, { sCg, .222 }, H };
N l33n143[] = { { sJc8, .271 }, H };
N l33n145[] = { { sgc2JE, .197 }, { scbcfH, .222 }, H };
N l33n146[] = { { scdcf, .617 }, H };
N l33n147[] = { { sCF, .271 }, { sc2c5, .197 }, H };
N l33n148[] = { { sc1Oc5, .222 }, H };
N l33n149[] = { { sgAcf, 1.037 }, { sccB, .271 }, { sHcc, .222 }, { sc4c5cc, .259 }, H };
N l33n150[] = { { scag, 1.592 }, H };
N l33n152[] = { { sgME, .222 }, { sc9Bg, .389 }, { scbD, .148 }, H };
N l33n153[] = { { sgc9g, .296 }, { sEc1E, .333 }, { sACc5, .259 }, { sCcfc4, .222 }, H };
N l33n156[] = { { sc1Cc1, .407 }, H };
N l33n157[] = { { scfcc, 1.012 }, { sged, .165 }, { sCc1K, .333 }, { sc1ccIce, .395 }, H };
N l33n158[] = { { sgO, .444 }, { sEC, .420 }, { sc9H, .222 }, H };
N l33n159[] = { { sgcf, .675 }, { sc9c8, .346 }, { sCc1g, .444 }, H };
N l33n160[] = { { sc1Bg, .611 }, { sgEc1cb, .329 }, { scece, .247 }, { s80g, .173 }, { sgf0c1H, .230 }, H };
N l33n161[] = { { sDE, 1.678 }, H };
N l33n162[] = { { sDc5, .494 }, H };
N l33n163[] = { { scfHc1, .333 }, H };
N l33n164[] = { { scdc1, .296 }, H };
N l33n165[] = { { sc5cag, .555 }, { sgKc1, .247 }, H };
N l33n166[] = { { sc1H, .518 }, H };
N l33n167[] = { { sgc2cf, .222 }, { sgDcc, .197 }, { sDEC, .222 }, H };
N l33n169[] = { { scbE, .321 }, H };
N l33n170[] = { { sceIg, .555 }, { sEDB, .296 }, H };
N l33n171[] = { { scecfc7cf, .444 }, { sDcbc9, .333 }, { scfHJ, .296 }, { scec9g, .389 }, H };
N l33n173[] = { { sDg, .481 }, H };
N l33n174[] = { { scfcd, .765 }, { sgee, .165 }, H };
N l33n175[] = { { sED, .222 }, H };
N l33n176[] = { { sgA, 1.612 }, { sc9c9, .370 }, { scfOc5ce, .395 }, { scccfH, .259 }, H };
N l33n177[] = { { scecf, 1.259 }, { sgc1, .197 }, { sJca, .197 }, H };
N l33n178[] = { { sc3c5, .197 }, H };
N l33n179[] = { { sOc1, .395 }, { sAcfcc, .333 }, H };
N l33n181[] = { { scbg, .629 }, H };
N l33n182[] = { { sgAC, .765 }, H };
N l33n183[] = { { sHce, .247 }, H };
N l33n184[] = { { scfHg, .666 }, { sME, .222 }, H };
N l33n186[] = { { sgOE, .469 }, H };
N l33n187[] = { { sc1EI, .296 }, { sgcfE, .173 }, H };
N l33n188[] = { { sJc5g, .333 }, H };
N l33n189[] = { { sFC, .173 }, H };
N l33n190[] = { { scfGc5, .333 }, { scec1B, .296 }, { sAcfcd, .259 }, H };
N l33n191[] = { { scfce, .642 }, H };
N l33n192[] = { { sg80g, .173 }, H };
N l33n193[] = { { sEc5, .888 }, { sc9ca, .197 }, H };
N l33n194[] = { { sgc2, .378 }, { scec9c5, .333 }, H };
N l33n195[] = { { scec1, 1.209 }, H };
N l33n196[] = { { sc7c1ce, .296 }, { sOc1D, .259 }, { scdcfG, .259 }, H };
N l33n197[] = { { sACc9, .333 }, { sHDcb, .222 }, { scbc9c5g, .444 }, H };
N l33n198[] = { { scbc1g, .444 }, H };
N l33n199[] = { { sCc9, .642 }, { sEc5C, .333 }, H };
N l33n200[] = { { sHcf, .666 }, { sgDcf, .197 }, H };
N l33n201[] = { { sccc5, .814 }, { sgc4cf, .321 }, H };
N l33n203[] = { { sEcfg, 1.444 }, H };
N l33n204[] = { { sEg, 1.259 }, { sc9c5g, .833 }, H };
N l33n205[] = { { sc5C, .839 }, { scfDcb, .259 }, H };
N l33n206[] = { { sDBg, .666 }, H };
N l33n207[] = { { scfO, .296 }, { scfHc5, .222 }, H };
N l33n208[] = { { sgf0, .296 }, { se7Cc1O, .296 }, H };
N l33n209[] = { { sc4c5, .543 }, { sgR, .230 }, { sOc5ce, .370 }, { sc5ceI, .370 }, { sEF, .197 }, H };
N l33n210[] = { { sgC, .329 }, { sc9cb, .271 }, H };
N l33n211[] = { { sceB, .197 }, { scccfg, .444 }, H };
N l33n212[] = { { sccg, .555 }, H };
N l33n214[] = { { sIce, .247 }, H };
N l33n215[] = { { sc2c9, .148 }, H };
N l33n216[] = { { sc7cf, 1.061 }, { sc5cdg, .555 }, { sNc5, .222 }, H };
N l33n217[] = { { sgcec1, .494 }, { sgEcf, .346 }, { sc1K, .321 }, { sGc5ce, .296 }, { sccF, .148 }, H };
N l33n218[] = { { sHc1, .913 }, { sc1cb, .444 }, H };
N l33n219[] = { { sOEcf, .703 }, { scfcag, .944 }, H };
N l33n220[] = { { scbH, .173 }, H };
N l33n222[] = { { sc5D, .864 }, { sDEH, .555 }, { sLc9, .222 }, { sc5ccc5, .259 }, H };
N l33n223[] = { { sc5c4, .370 }, { sFE, .197 }, H };
N l33n225[] = { { sf0c1, .222 }, H };
N l33n227[] = { { sgD, 1.119 }, { sc9cc, .395 }, { sgccc5, .173 }, H };
N l33n228[] = { { sgc4, .592 }, { sJcd, .197 }, H };
N l33n229[] = { { scfccI, .407 }, { sccc1g, .444 }, { sccc5E, .296 }, { scec3, .197 }, H };
N l33n230[] = { { sccIce, .370 }, { sc6c7c1ce, .395 }, H };
N l33n231[] = { { sc2J, .370 }, H };
N l33n232[] = { { scdc5, .543 }, { scfCcf, .296 }, H };
N l33n234[] = { { sc7c1, .346 }, { sc1Ec5, .333 }, H };
N l33n235[] = { { sc1cc, .716 }, { sFg, .851 }, { scfc7c9, .333 }, { se7C, .173 }, H };
N l33n236[] = { { sDEc1, .481 }, H };
N l33n237[] = { { sDcbcf, .518 }, { sc4c1g, .444 }, H };
N l33n238[] = { { scbc9, .395 }, { scecfH, .370 }, H };
N l33n239[] = { { sAcf, 1.234 }, { sc5E, .963 }, { sJc8g, .611 }, { sCc5c4, .259 }, H };
N l33n240[] = { { sc5c5, .271 }, H };
N l33n243[] = { { scdg, 1.629 }, { sEH, .420 }, { scfc2, .296 }, H };
N l33n244[] = { { sgE, .625 }, { sc9cd, .346 }, { sgcdc5, .173 }, H };
N l33n245[] = { { sgc5, .165 }, { sccBg, .389 }, H };
N l33n246[] = { { sOE, .469 }, { sc3c9, .271 }, H };
N l33n247[] = { { sOc5, .691 }, { sc5c7cf, .407 }, H };
N l33n249[] = { { sgAcfcc, .230 }, H };
N l33n250[] = { { sc5DE, .555 }, H };
N l33n251[] = { { sc5g, 3.036 }, { sgAc1, .173 }, H };
N l33n252[] = { { sc1cd, .444 }, H };
N l33n255[] = { { sGc5, .568 }, { sgDE, .370 }, { sc9c8g, .666 }, H };

D l33_d = {
	"russian",
	"koi8-r",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    0.005, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    0.011, 0.364, 0.059, 0.024, 0.115, 0.402, 0.021, 0.088, 0.038, 0.289, 0.052, 0.139, 0.185, 0.136, 0.281, 0.518,
	    0.124, 0.072, 0.201, 0.230, 0.313, 0.092, 0.043, 0.208, 0.078, 0.080, 0.057, 0.017, 0.012, 0.020, 0.074, V,
	    0.004, 0.016, 0.003, V, 0.003, 0.004, 0.001, 0.009, 0.002, 0.009, 0.002, 0.009, 0.001, 0.011, 0.011, 0.008,
	    0.018, 0.002, 0.002, 0.010, 0.007, 0.003, V, 0.004, V, V, 0.001, V, 0.005, V, 0.001, V },
	{ X, l33n1, X, l33n3, l33n4, l33n5, l33n6, l33n7, l33n8, X, l33n10, l33n11, l33n12, l33n13, l33n14, X,
	    l33n16, l33n17, l33n18, X, l33n20, l33n21, l33n22, l33n23, l33n24, l33n25, X, l33n27, l33n28, l33n29, l33n30, X,
	    l33n32, l33n33, l33n34, l33n35, X, l33n37, l33n38, l33n39, X, l33n41, X, X, l33n44, l33n45, X, l33n47,
	    l33n48, l33n49, X, l33n51, X, X, l33n54, l33n55, l33n56, l33n57, l33n58, l33n59, X, l33n61, l33n62, l33n63,
	    l33n64, l33n65, X, l33n67, l33n68, l33n69, l33n70, l33n71, l33n72, l33n73, l33n74, l33n75, l33n76, X, X, l33n79,
	    l33n80, l33n81, X, X, l33n84, l33n85, l33n86, l33n87, l33n88, l33n89, l33n90, l33n91, l33n92, X, l33n94, l33n95,
	    l33n96, X, l33n98, l33n99, l33n100, l33n101, l33n102, l33n103, X, X, l33n106, l33n107, l33n108, l33n109, l33n110, l33n111,
	    X, l33n113, l33n114, l33n115, X, X, X, l33n119, l33n120, X, l33n122, l33n123, l33n124, l33n125, l33n126, l33n127,
	    X, l33n129, l33n130, l33n131, l33n132, l33n133, l33n134, l33n135, l33n136, l33n137, X, l33n139, l33n140, l33n141, l33n142, l33n143,
	    X, l33n145, l33n146, l33n147, l33n148, l33n149, l33n150, X, l33n152, l33n153, X, X, l33n156, l33n157, l33n158, l33n159,
	    l33n160, l33n161, l33n162, l33n163, l33n164, l33n165, l33n166, l33n167, X, l33n169, l33n170, l33n171, X, l33n173, l33n174, l33n175,
	    l33n176, l33n177, l33n178, l33n179, X, l33n181, l33n182, l33n183, l33n184, X, l33n186, l33n187, l33n188, l33n189, l33n190, l33n191,
	    l33n192, l33n193, l33n194, l33n195, l33n196, l33n197, l33n198, l33n199, l33n200, l33n201, X, l33n203, l33n204, l33n205, l33n206, l33n207,
	    l33n208, l33n209, l33n210, l33n211, l33n212, X, l33n214, l33n215, l33n216, l33n217, l33n218, l33n219, l33n220, X, l33n222, l33n223,
	    X, l33n225, X, l33n227, l33n228, l33n229, l33n230, l33n231, l33n232, X, l33n234, l33n235, l33n236, l33n237, l33n238, l33n239,
	    l33n240, X, X, l33n243, l33n244, l33n245, l33n246, l33n247, X, l33n249, l33n250, l33n251, l33n252, X, X, l33n255 }
};

//
// Lng: russian
// Enc: windows1251
//

S sf1f2[] = { 241, 242, 0 };
S sedee[] = { 237, 238, 0 };
S sffg[] = { 255, a };
S seeS[] = { 238, 226, 0 };
S sedQ[] = { 237, 224, 0 };
S sefee[] = { 239, 238, 0 };
S sgefee[] = { 32, 239, 238, 0 };
S seef1[] = { 238, 241, 0 };
S sQeb[] = { 224, 235, 0 };
S sede8[] = { 237, 232, 0 };
S sf0Q[] = { 240, 224, 0 };
S sge8g[] = { 32, 232, a };
S seaee[] = { 234, 238, 0 };
S sf2Q[] = { 242, 224, 0 };
S sebe8[] = { 235, 232, 0 };
S seaQ[] = { 234, 224, 0 };
S sebee[] = { 235, 238, 0 };
S sf2eeg[] = { 242, 238, a };
S seef0[] = { 238, 240, 0 };
S sSee[] = { 226, 238, 0 };
S sf0e8[] = { 240, 232, 0 };
S seff0[] = { 239, 240, 0 };
S sf2fc[] = { 242, 252, 0 };
S sQea[] = { 224, 234, 0 };
S sebQ[] = { 235, 224, 0 };
S sQed[] = { 224, 237, 0 };
S sgedQ[] = { 32, 237, 224, 0 };
S sf2fcg[] = { 242, 252, a };
S se8eb[] = { 232, 235, 0 };
S seeeb[] = { 238, 235, 0 };
S seeed[] = { 238, 237, 0 };
S sQS[] = { 224, 226, 0 };
S sgSg[] = { 32, 226, a };
S se8f2[] = { 232, 242, 0 };
S sVec[] = { 229, 236, 0 };
S sSV[] = { 226, 229, 0 };
S sedQg[] = { 237, 224, a };
S sedfb[] = { 237, 251, 0 };
S sf1ff[] = { 241, 255, 0 };
S sWV[] = { 230, 229, 0 };
S sgeff0[] = { 32, 239, 240, 0 };
S sQf0[] = { 224, 240, 0 };
S seeT[] = { 238, 227, 0 };
S secee[] = { 236, 238, 0 };
S sedf3[] = { 237, 243, 0 };
S se8ea[] = { 232, 234, 0 };
S sSe8[] = { 226, 232, 0 };
S sf1ffg[] = { 241, 255, a };
S sf7f2[] = { 247, 242, 0 };
S sRee[] = { 225, 238, 0 };
S se8ed[] = { 232, 237, 0 };
S se8e7[] = { 232, 231, 0 };
S sgedQg[] = { 32, 237, 224, a };
S sf7f2ee[] = { 247, 242, 238, 0 };
S sgeaee[] = { 32, 234, 238, 0 };
S seee9g[] = { 238, 233, a };
S sQf2[] = { 224, 242, 0 };
S sf7f2eeg[] = { 247, 242, 238, a };
S sSf1[] = { 226, 241, 0 };
S sebfc[] = { 235, 252, 0 };
S sf3eb[] = { 243, 235, 0 };
S sQebg[] = { 224, 235, a };
S seae8[] = { 234, 232, 0 };
S seef1f2[] = { 238, 241, 242, 0 };
S sgf7f2[] = { 32, 247, 242, 0 };
S sf2f0[] = { 242, 240, 0 };
S sQeag[] = { 224, 234, a };
S sgf7f2ee[] = { 32, 247, 242, 238, 0 };
S sf1f2Q[] = { 241, 242, 224, 0 };
S sVecg[] = { 229, 236, a };
S sgf1f2[] = { 32, 241, 242, 0 };
S sf1fcg[] = { 241, 252, a };
S sQf1[] = { 224, 241, 0 };
S sge7Q[] = { 32, 231, 224, 0 };
S sTeeg[] = { 227, 238, a };
S sRfb[] = { 225, 251, 0 };
S sgSf1[] = { 32, 226, 241, 0 };
S se8f2fc[] = { 232, 242, 252, 0 };
S sgRfb[] = { 32, 225, 251, 0 };
S sf3f2[] = { 243, 242, 0 };
S seff0ee[] = { 239, 240, 238, 0 };
S sebe8g[] = { 235, 232, a };
S seaf3[] = { 234, 243, 0 };
S sUVeb[] = { 228, 229, 235, 0 };
S sf2S[] = { 242, 226, 0 };
S sgeef1[] = { 32, 238, 241, 0 };
S sSf1V[] = { 226, 241, 229, 0 };
S sUQg[] = { 228, 224, a };
S seaQg[] = { 234, 224, a };
S sgf2V[] = { 32, 242, 229, 0 };
S sgeaQ[] = { 32, 234, 224, 0 };
S sgf2Q[] = { 32, 242, 224, 0 };
S sfbeb[] = { 251, 235, 0 };
S se8f2fcg[] = { 232, 242, 252, a };
S sf2e8[] = { 242, 232, 0 };
S secf3[] = { 236, 243, 0 };
S seeecg[] = { 238, 236, a };
S sgf1ee[] = { 32, 241, 238, 0 };
S sfbe9[] = { 251, 233, 0 };
S sQff[] = { 224, 255, 0 };
S sedeeg[] = { 237, 238, a };
S sgff[] = { 32, 255, 0 };
S se8ebg[] = { 232, 235, a };
S seded[] = { 237, 237, 0 };
S seef7[] = { 238, 247, 0 };
S sgedVg[] = { 32, 237, 229, a };
S sgcdf3[] = { 32, 205, 243, 0 };
S sfbe9g[] = { 251, 233, a };
S sgTee[] = { 32, 227, 238, 0 };
S scdf3[] = { 205, 243, 0 };
S sWVg[] = { 230, 229, a };
S sf1f2ee[] = { 241, 242, 238, 0 };
S sebf1ffg[] = { 235, 241, 255, a };
S sebf1[] = { 235, 241, 0 };
S sRfbeb[] = { 225, 251, 235, 0 };
S scdf3g[] = { 205, 243, a };
S se8Vg[] = { 232, 229, a };
S sgeef2[] = { 32, 238, 242, 0 };
S sQffg[] = { 224, 255, a };
S seeTee[] = { 238, 227, 238, 0 };
S sQe7[] = { 224, 231, 0 };
S sf3U[] = { 243, 228, 0 };
S sVede8[] = { 229, 237, 232, 0 };
S sgUee[] = { 32, 228, 238, 0 };
S sebf1ff[] = { 235, 241, 255, 0 };
S sf0f3[] = { 240, 243, 0 };
S sUed[] = { 228, 237, 0 };
S sVf1f2[] = { 229, 241, 242, 0 };
S se8e9[] = { 232, 233, 0 };
S sgcdf3g[] = { 32, 205, 243, a };
S sgRfbeb[] = { 32, 225, 251, 235, 0 };
S sgWV[] = { 32, 230, 229, 0 };
S sf2fb[] = { 242, 251, 0 };
S sgSee[] = { 32, 226, 238, 0 };
S sf1f2f0[] = { 241, 242, 240, 0 };
S sSeef0[] = { 226, 238, 240, 0 };
S sf2Qea[] = { 242, 224, 234, 0 };
S sf1ea[] = { 241, 234, 0 };
S sedfc[] = { 237, 252, 0 };
S sgeff0ee[] = { 32, 239, 240, 238, 0 };
S se8ec[] = { 232, 236, 0 };
S sgRf3[] = { 32, 225, 243, 0 };
S sgSf1V[] = { 32, 226, 241, 229, 0 };
S seeSee[] = { 238, 226, 238, 0 };
S sebQg[] = { 235, 224, a };
S sf2f1[] = { 242, 241, 0 };
S sf2f3[] = { 242, 243, 0 };
S sf5ee[] = { 245, 238, 0 };
S sf0fb[] = { 240, 251, 0 };
S sQede8[] = { 224, 237, 232, 0 };
S sefVf0[] = { 239, 229, 240, 0 };
S sebeef1[] = { 235, 238, 241, 0 };
S sf2Veb[] = { 242, 229, 235, 0 };
S se8S[] = { 232, 226, 0 };
S sgf2ee[] = { 32, 242, 238, 0 };
S sgf2Qea[] = { 32, 242, 224, 234, 0 };
S sedeee9[] = { 237, 238, 233, 0 };
S sgeaQea[] = { 32, 234, 224, 234, 0 };
S sf2ed[] = { 242, 237, 0 };
S sWVed[] = { 230, 229, 237, 0 };
S sedf3eb[] = { 237, 243, 235, 0 };
S sf2eef0[] = { 242, 238, 240, 0 };
S se8e9g[] = { 232, 233, a };
S sSQeb[] = { 226, 224, 235, 0 };
S sgUQ[] = { 32, 228, 224, 0 };
S sgf0Q[] = { 32, 240, 224, 0 };
S sgefeeeb[] = { 32, 239, 238, 235, 0 };
S sgecee[] = { 32, 236, 238, 0 };
S sgffg[] = { 32, 255, a };
S sf7Q[] = { 247, 224, 0 };
S sgede8[] = { 32, 237, 232, 0 };
S sedfbe9g[] = { 237, 251, 233, a };
S sebeeg[] = { 235, 238, a };
S sgf1f2Q[] = { 32, 241, 242, 224, 0 };
S seaQea[] = { 234, 224, 234, 0 };
S sWe8[] = { 230, 232, 0 };
S seeSeef0[] = { 238, 226, 238, 240, 0 };
S seeW[] = { 238, 230, 0 };
S se8e8[] = { 232, 232, 0 };
S sf2fbg[] = { 242, 251, a };
S sVebg[] = { 229, 235, a };
S sfbVg[] = { 251, 229, a };
S sedeeS[] = { 237, 238, 226, 0 };
S sf2edee[] = { 242, 237, 238, 0 };
S sVeded[] = { 229, 237, 237, 0 };
S sedfbe9[] = { 237, 251, 233, 0 };
S sefeeeb[] = { 239, 238, 235, 0 };
S sf7e8[] = { 247, 232, 0 };
S sQSQ[] = { 224, 226, 224, 0 };
S sedeee9g[] = { 237, 238, 233, a };
S sVf0V[] = { 229, 240, 229, 0 };
S sf6e8[] = { 246, 232, 0 };
S seeSQ[] = { 238, 226, 224, 0 };
S seeSg[] = { 238, 226, a };
S sfbV[] = { 251, 229, 0 };
S se8e8g[] = { 232, 232, a };
S sf1Vec[] = { 241, 229, 236, 0 };
S sUQS[] = { 228, 224, 226, 0 };
S se8edf3[] = { 232, 237, 243, 0 };
S sebeef1fc[] = { 235, 238, 241, 252, 0 };
S sedfbV[] = { 237, 251, 229, 0 };
S sf1e8[] = { 241, 232, 0 };
S sefeeg[] = { 239, 238, a };
S sedeeT[] = { 237, 238, 227, 0 };
S seaQeag[] = { 234, 224, 234, a };
S sedfbVg[] = { 237, 251, 229, a };
S se8f5[] = { 232, 245, 0 };
S seef8[] = { 238, 248, 0 };
S sVTee[] = { 229, 227, 238, 0 };
S sTeeS[] = { 227, 238, 226, 0 };
S sQf7[] = { 224, 247, 0 };
S seef2ee[] = { 238, 242, 238, 0 };
S seef1fcg[] = { 238, 241, 252, a };
S seff0e8[] = { 239, 240, 232, 0 };
S seeef[] = { 238, 239, 0 };
S seeTeeg[] = { 238, 227, 238, a };
S seef0ee[] = { 238, 240, 238, 0 };
S sgeef1f2[] = { 32, 238, 241, 242, 0 };
S sf8ea[] = { 248, 234, 0 };
S sebff[] = { 235, 255, 0 };
S sgeeR[] = { 32, 238, 225, 0 };
S sgece8[] = { 32, 236, 232, 0 };
S seeUe8[] = { 238, 228, 232, 0 };
S sededfb[] = { 237, 237, 251, 0 };
S sVea[] = { 229, 234, 0 };
S sf0e8f2[] = { 240, 232, 242, 0 };
S sQSe8[] = { 224, 226, 232, 0 };
S sVebQ[] = { 229, 235, 224, 0 };
S se8f6[] = { 232, 246, 0 };
S sSfb[] = { 226, 251, 0 };
S sSe8U[] = { 226, 232, 228, 0 };
S sf0Qg[] = { 240, 224, a };
S sSed[] = { 226, 237, 0 };
S sSVf0[] = { 226, 229, 240, 0 };
S seaf2[] = { 234, 242, 0 };
S secf3g[] = { 236, 243, a };
S seff0Q[] = { 239, 240, 224, 0 };
S sf1f2S[] = { 241, 242, 226, 0 };
S sQf0Q[] = { 224, 240, 224, 0 };
S seef1fc[] = { 238, 241, 252, 0 };
S sSQg[] = { 226, 224, a };
S sTeb[] = { 227, 235, 0 };
S sf3W[] = { 243, 230, 0 };
S sUS[] = { 228, 226, 0 };
S se7fb[] = { 231, 251, 0 };
S sedff[] = { 237, 255, 0 };
S sTeeSee[] = { 227, 238, 226, 238, 0 };
S seeUed[] = { 238, 228, 237, 0 };
S sgefeeg[] = { 32, 239, 238, a };
S sVedf2[] = { 229, 237, 242, 0 };
S seef0e8f2[] = { 238, 240, 232, 242, 0 };
S sf3ebg[] = { 243, 235, a };
S sece8eb[] = { 236, 232, 235, 0 };
S sTf3[] = { 227, 243, 0 };
S sgfdf2[] = { 32, 253, 242, 0 };
S sUedee[] = { 228, 237, 238, 0 };
S sf8eaQ[] = { 248, 234, 224, 0 };
S sRfbebee[] = { 225, 251, 235, 238, 0 };
S sf2f1ff[] = { 242, 241, 255, 0 };
S sQf2fcg[] = { 224, 242, 252, a };
S sgVTee[] = { 32, 229, 227, 238, 0 };
S sf1f2e8[] = { 241, 242, 232, 0 };
S seeebfc[] = { 238, 235, 252, 0 };
S sf0Qed[] = { 240, 224, 237, 0 };
S sgVT[] = { 32, 229, 227, 0 };
S sf2SV[] = { 242, 226, 229, 0 };
S sededfbe9[] = { 237, 237, 251, 233, 0 };
S seeebee[] = { 238, 235, 238, 0 };
S sQef[] = { 224, 239, 0 };
S sgUS[] = { 32, 228, 226, 0 };
S se7Qg[] = { 231, 224, a };
S se8SQ[] = { 232, 226, 224, 0 };
S seced[] = { 236, 237, 0 };
S sefe8[] = { 239, 232, 0 };
S sTQ[] = { 227, 224, 0 };
S sedeeTee[] = { 237, 238, 227, 238, 0 };
S seef5[] = { 238, 245, 0 };
S se8e7ec[] = { 232, 231, 236, 0 };
S sfdf2ee[] = { 253, 242, 238, 0 };
S sede8g[] = { 237, 232, a };
S se8eaee[] = { 232, 234, 238, 0 };
S sf0ff[] = { 240, 255, 0 };
S sfbebee[] = { 251, 235, 238, 0 };
S sVedQ[] = { 229, 237, 224, 0 };
S sefQ[] = { 239, 224, 0 };
S sTe8[] = { 227, 232, 0 };
S sQf0e8[] = { 224, 240, 232, 0 };
S seaf3g[] = { 234, 243, a };

N l34n0[] = { { sfbeb, .291 }, { sUVed, .262 }, H };
N l34n1[] = { { sffg, 1.836 }, { sTeeS, .262 }, H };
N l34n3[] = { { sgf3, .369 }, { sRfbeb, .393 }, H };
N l34n4[] = { { sgU, .661 }, { sUe8, .350 }, H };
N l34n7[] = { { seeV, .408 }, { seef1fcg, .525 }, H };
N l34n8[] = { { sf3eb, .408 }, { sVTee, .262 }, { sQf0e8, .219 }, H };
N l34n9[] = { { sgeef1, .321 }, { sSfb, .175 }, H };
N l34n10[] = { { sf2fc, .758 }, { sQeag, .852 }, { sgeaQ, .291 }, H };
N l34n11[] = { { sf2ed, .204 }, H };
N l34n12[] = { { sedeeTee, .291 }, H };
N l34n13[] = { { sRee, .437 }, H };
N l34n14[] = { { seeSee, .350 }, { sf1ef, .175 }, H };
N l34n15[] = { { sWV, .525 }, { sgeff0, .525 }, { sQff, .291 }, { sf1Q, .262 }, H };
N l34n16[] = { { sQf0, .495 }, H };
N l34n17[] = { { sQR, .146 }, H };
N l34n18[] = { { sVe7, .233 }, H };
N l34n19[] = { { se8ebg, .656 }, { sgfdf2, .146 }, H };
N l34n20[] = { { sgeef2, .262 }, H };
N l34n21[] = { { sgV, .233 }, { sece8eb, .219 }, H };
N l34n23[] = { { secf3g, .393 }, { seef5, .146 }, H };
N l34n24[] = { { seeW, .204 }, { sTeb, .175 }, { sVedQ, .219 }, H };
N l34n25[] = { { se8f1, .291 }, H };
N l34n26[] = { { se8S, .233 }, { sQSe8, .262 }, H };
N l34n27[] = { { sede8, 1.020 }, { sQebg, .852 }, { seff0ee, .481 }, { sgf1ee, .291 }, { sSed, .175 }, H };
N l34n28[] = { { sf2ee, 1.574 }, { sgSee, .233 }, { se7f3, .175 }, H };
N l34n29[] = { { se7U, .175 }, H };
N l34n30[] = { { sf1ff, .525 }, { sf7V, .321 }, { seef2ee, .262 }, H };
N l34n31[] = { { seeTee, .393 }, { sefeeg, .393 }, { sf0Qed, .219 }, H };
N l34n33[] = { { sQf1, .350 }, H };
N l34n34[] = { { sQS, .641 }, { sVf1f2, .393 }, { sVf7, .204 }, H };
N l34n36[] = { { seaee, .962 }, H };
N l34n37[] = { { seeUed, .262 }, H };
N l34n38[] = { { sgW, .272 }, { sefV, .379 }, H };
N l34n39[] = { { sf2SV, .219 }, H };
N l34n42[] = { { se8f2, .612 }, H };
N l34n44[] = { { sSee, .758 }, { sgf2ee, .233 }, { sf0fcg, .393 }, H };
N l34n45[] = { { sVf2g, .787 }, { sgTee, .262 }, H };
N l34n46[] = { { sf2Q, .903 }, H };
N l34n47[] = { { sRf0, .204 }, { sgffg, .204 }, H };
N l34n48[] = { { sf0g, .219 }, H };
N l34n49[] = { { sebfc, .408 }, H };
N l34n50[] = { { sQf2, .408 }, { sf6e8, .204 }, { sUQS, .262 }, { sf8eaQ, .219 }, H };
N l34n51[] = { { sf0f3, .262 }, H };
N l34n52[] = { { sVe9, .233 }, { seeSg, .459 }, H };
N l34n53[] = { { sf7f2ee, .612 }, { sedfbV, .262 }, H };
N l34n54[] = { { seaQ, .874 }, { sSf1V, .437 }, H };
N l34n55[] = { { sge7, .408 }, { sedeeS, .306 }, H };
N l34n56[] = { { se8g, 3.541 }, H };
N l34n57[] = { { seef1f2, .568 }, { seef7, .291 }, { sededfb, .262 }, { sf1f2e8, .219 }, { se7Qg, .328 }, H };
N l34n58[] = { { sfbebee, .219 }, H };
N l34n60[] = { { sf2Qea, .350 }, { se8U, .233 }, H };
N l34n61[] = { { sgedQ, .729 }, { sgSf1, .321 }, { sebe8g, .721 }, { sf8V, .262 }, H };
N l34n62[] = { { sSQ, .903 }, { sf2f0, .379 }, { sfbe9g, .590 }, { sgUee, .262 }, { sWVed, .306 }, H };
N l34n64[] = { { sQg, 3.279 }, H };
N l34n65[] = { { sf1f2, 1.515 }, { seeebfc, .219 }, H };
N l34n66[] = { { sgSg, .612 }, { sgRf3, .233 }, { sWe8, .204 }, { sedeeT, .262 }, H };
N l34n67[] = { { sebee, .787 }, H };
N l34n68[] = { { seaQea, .306 }, { sQU, .204 }, { sf2f1ff, .219 }, H };
N l34n69[] = { { sf0V, .466 }, { sf2edee, .306 }, { sVea, .175 }, H };
N l34n70[] = { { se8edf3, .262 }, H };
N l34n71[] = { { sgf7, .369 }, { sgf1f2, .350 }, H };
N l34n72[] = { { sge8, .894 }, { sedVg, 1.115 }, H };
N l34n74[] = { { seef8, .175 }, H };
N l34n75[] = { { sTee, .758 }, { seee9, .437 }, { sf1fcg, .787 }, H };
N l34n77[] = { { se8V, .350 }, H };
N l34n78[] = { { sgcdf3g, .350 }, H };
N l34n79[] = { { sf1g, .525 }, { sf2f1, .233 }, H };
N l34n80[] = { { sf2S, .321 }, { sgf2Qea, .311 }, { sf0Qg, .393 }, H };
N l34n81[] = { { sf7e8, .204 }, { seced, .146 }, H };
N l34n85[] = { { sebQ, .729 }, H };
N l34n86[] = { { sVeb, .816 }, { scdf3g, .590 }, H };
N l34n87[] = { { se9g, 1.749 }, { sSQeb, .306 }, H };
N l34n89[] = { { sUed, .262 }, { sf2fbg, .459 }, { sgeeR, .175 }, { sgefeeg, .233 }, { sefe8, .146 }, H };
N l34n91[] = { { sgRfbeb, .350 }, H };
N l34n93[] = { { sf3f0, .262 }, { se8f5, .175 }, { sTQ, .146 }, H };
N l34n94[] = { { sedfb, .554 }, { se8f2fcg, .874 }, { sf3R, .204 }, H };
N l34n95[] = { { sSf1, .408 }, H };
N l34n97[] = { { sedfbe9, .306 }, H };
N l34n98[] = { { secee, .495 }, { sRf3, .262 }, H };
N l34n99[] = { { sgecV, .175 }, H };
N l34n100[] = { { sf1V, .583 }, { sebff, .175 }, H };
N l34n102[] = { { sQf2fcg, .437 }, H };
N l34n103[] = { { sVec, .583 }, { seeVg, .525 }, H };
N l34n104[] = { { seaf2, .175 }, { sf3ebg, .328 }, H };
N l34n106[] = { { sgea, .699 }, { sf2fcg, 1.639 }, { sUee, .321 }, H };
N l34n107[] = { { sebf1ff, .393 }, H };
N l34n108[] = { { sgcc, .175 }, { sf2eef0, .306 }, H };
N l34n109[] = { { seeeb, .699 }, H };
N l34n110[] = { { sf2g, 1.137 }, { se8f6, .175 }, H };
N l34n111[] = { { se8e7, .408 }, { sWVg, .590 }, { sQffg, .590 }, { sedfc, .233 }, H };
N l34n112[] = { { seded, .291 }, { sf8e8, .262 }, { sVede8, .393 }, { sgf0Q, .204 }, H };
N l34n113[] = { { sf2f3, .233 }, H };
N l34n116[] = { { sgedV, .699 }, { seeSQ, .306 }, { secQ, .204 }, H };
N l34n118[] = { { seag, .962 }, { sebf1, .262 }, { sefVf0, .350 }, H };
N l34n119[] = { { sgf7f2ee, .505 }, { sQe7, .262 }, H };
N l34n120[] = { { sVed, 1.078 }, { sf0e8, .758 }, H };
N l34n121[] = { { seaf3, .321 }, { sf5ee, .233 }, H };
N l34n123[] = { { sgeb, .194 }, { sf1f2ee, .393 }, { sede8g, .328 }, H };
N l34n124[] = { { sf2eeg, 1.770 }, { sUQ, .758 }, { sSeef0, .350 }, H };
N l34n125[] = { { sgcd, .272 }, H };
N l34n126[] = { { sSg, 1.311 }, { seeec, .466 }, { sf1ffg, 1.049 }, H };
N l34n127[] = { { sf3f2, .321 }, { seeTeeg, .525 }, H };
N l34n128[] = { { se8e8, .204 }, H };
N l34n129[] = { { sedee, 1.282 }, { seff0Q, .262 }, H };
N l34n130[] = { { sVf0V, .306 }, H };
N l34n131[] = { { sf2V, .729 }, H };
N l34n132[] = { { sedeee9, .306 }, { sgece8, .175 }, H };
N l34n133[] = { { sfbg, 1.049 }, H };
N l34n135[] = { { sQf7, .175 }, H };
N l34n136[] = { { sf1Vec, .262 }, H };
N l34n140[] = { { sgec, .602 }, { sefeb, .262 }, H };
N l34n141[] = { { sf3g, 1.530 }, H };
N l34n143[] = { { seeed, .670 }, H };
N l34n144[] = { { seef0e8f2, .291 }, H };
N l34n145[] = { { sf3U, .262 }, { se8e9, .262 }, { sf1f2f0, .350 }, H };
N l34n146[] = { { sgf2Q, .291 }, { sebeef1fc, .350 }, { sf8ea, .175 }, { sSe8U, .262 }, H };
N l34n147[] = { { sedQ, 1.195 }, { sSV, .554 }, { sUedee, .219 }, { se8e7ec, .219 }, H };
N l34n148[] = { { sVe9g, .459 }, H };
N l34n149[] = { { sebg, 1.749 }, { sf7f2eeg, 1.224 }, { sgede8, .204 }, { sedfbVg, .525 }, H };
N l34n150[] = { { seaQg, .656 }, H };
N l34n151[] = { { sf1e8, .175 }, H };
N l34n152[] = { { sQf8, .262 }, H };
N l34n154[] = { { sgRfb, .321 }, { sfbV, .204 }, H };
N l34n156[] = { { sf2Veb, .350 }, H };
N l34n157[] = { { sged, 1.166 }, { sgedQg, .544 }, H };
N l34n158[] = { { sebeef1, .350 }, { sSQg, .393 }, { sUS, .175 }, H };
N l34n159[] = { { sgcf, .117 }, H };
N l34n160[] = { { sTf3, .146 }, { sgVTee, .194 }, H };
N l34n162[] = { { se8ea, .466 }, { sedff, .175 }, H };
N l34n163[] = { { sebeeg, .459 }, H };
N l34n164[] = { { sfcg, 2.492 }, { sgeaee, .408 }, { sgUQ, .204 }, { seaQeag, .525 }, { se7fb, .175 }, H };
N l34n165[] = { { se7ec, .175 }, H };
N l34n167[] = { { sVeded, .306 }, { seef1fc, .262 }, { seeebee, .219 }, H };
N l34n168[] = { { sge8g, .991 }, H };
N l34n170[] = { { sQea, .729 }, { sebV, .379 }, H };
N l34n171[] = { { sVf0, .903 }, { seee9g, .918 }, { sTeeg, .721 }, H };
N l34n173[] = { { sgf7f2, .379 }, { se8Vg, .590 }, H };
N l34n174[] = { { sgee, .758 }, H };
N l34n176[] = { { sQf0Q, .262 }, H };
N l34n177[] = { { seeef, .175 }, H };
N l34n179[] = { { se8eb, .699 }, { sf3W, .175 }, H };
N l34n180[] = { { secg, 1.443 }, H };
N l34n181[] = { { sebQg, .525 }, H };
N l34n182[] = { { se7ed, .291 }, { sf2e8, .291 }, { sVebg, .459 }, H };
N l34n183[] = { { secf3, .291 }, H };
N l34n185[] = { { sf1ea, .233 }, H };
N l34n186[] = { { sgefeeeb, .272 }, { sgUS, .146 }, { se8SQ, .219 }, H };
N l34n187[] = { { sQeb, 1.049 }, { sf0fb, .233 }, H };
N l34n188[] = { { sVf1, .466 }, { sUg, .262 }, H };
N l34n190[] = { { seae8, .379 }, H };
N l34n191[] = { { sgef, 1.379 }, { sefee, 1.137 }, H };
N l34n193[] = { { sgB, .175 }, { sedfbe9g, .612 }, H };
N l34n194[] = { { seef0, .787 }, { sgc2, .233 }, { sQSQ, .306 }, H };
N l34n195[] = { { seeR, .525 }, H };
N l34n196[] = { { se8ec, .233 }, H };
N l34n197[] = { { sedf2, .233 }, H };
N l34n198[] = { { sSe8, .466 }, { sgecee, .204 }, H };
N l34n199[] = { { sVecg, .787 }, H };
N l34n200[] = { { sgeaQea, .272 }, H };
N l34n201[] = { { secV, .437 }, { sgf2V, .291 }, { sf7Q, .204 }, H };
N l34n203[] = { { sf5g, .656 }, { sebf1ffg, .787 }, { sTeeSee, .350 }, H };
N l34n204[] = { { sf0fc, .233 }, { sQec, .233 }, H };
N l34n205[] = { { sVf2, .612 }, { sRfbebee, .291 }, H };
N l34n206[] = { { sVT, .291 }, H };
N l34n207[] = { { sgff, .194 }, H };
N l34n208[] = { { sgf0, .311 }, H };
N l34n209[] = { { sgR, .622 }, { sUV, .845 }, { sefQ, .146 }, H };
N l34n211[] = { { seef1, 1.078 }, { sedg, .306 }, H };
N l34n212[] = { { seeS, 1.195 }, { sgedVg, .389 }, H };
N l34n213[] = { { se8ed, .437 }, { sQede8, .350 }, H };
N l34n214[] = { { sedf3, .466 }, { sgVT, .146 }, H };
N l34n215[] = { { sge7Q, .350 }, H };
N l34n216[] = { { sefeeeb, .306 }, H };
N l34n217[] = { { se7Q, .495 }, { sgeff0ee, .311 }, { seff0e8, .262 }, { seaf3g, .328 }, H };
N l34n219[] = { { sVg, 3.322 }, { sgUV, .204 }, H };
N l34n220[] = { { sUQg, .656 }, { se8eaee, .219 }, H };
N l34n221[] = { { sebe8, .874 }, { sQed, .729 }, H };
N l34n222[] = { { sf0ee, .962 }, { seeecg, .656 }, { sfbe9, .291 }, { seeSeef0, .408 }, { sf0e8f2, .262 }, { sVedf2, .219 }, H };
N l34n223[] = { { sVU, .408 }, { sgeef1f2, .233 }, H };
N l34n224[] = { { se8e8g, .459 }, H };
N l34n225[] = { { sgf1, .971 }, { seff0, .758 }, { sf1f2Q, .568 }, { sedeeg, .656 }, H };
N l34n226[] = { { sgS, 1.030 }, { sfeg, .525 }, H };
N l34n227[] = { { sSVf0, .262 }, H };
N l34n228[] = { { seef2, .699 }, { sedeee9g, .612 }, { sgc4, .117 }, H };
N l34n229[] = { { seeT, .495 }, { sTe8, .146 }, H };
N l34n231[] = { { sgf1f2Q, .272 }, H };
N l34n232[] = { { sedV, 1.137 }, H };
N l34n234[] = { { sRfb, .321 }, { sUVeb, .481 }, H };
N l34n235[] = { { sf1fc, .350 }, H };
N l34n236[] = { { sgSf1V, .311 }, H };
N l34n238[] = { { sgcdf3, .262 }, { seeUe8, .262 }, H };
N l34n239[] = { { sedf3eb, .306 }, { sfdf2ee, .219 }, H };
N l34n240[] = { { sf0Q, 1.020 }, H };
N l34n241[] = { { se8e9g, .459 }, H };
N l34n242[] = { { seeg, 3.541 }, { sgf2, .738 }, H };
N l34n243[] = { { sedQg, 1.246 }, { sgT, .291 }, H };
N l34n244[] = { { sededfbe9, .291 }, H };
N l34n246[] = { { seeU, .641 }, { scdf3, .262 }, { sVebQ, .262 }, H };
N l34n247[] = { { sf1f2S, .262 }, H };
N l34n249[] = { { sgefee, 1.107 }, { sf2fb, .233 }, H };
N l34n250[] = { { sfbVg, .459 }, H };
N l34n251[] = { { sf7f2, .437 }, H };
N l34n252[] = { { sece8, .321 }, { seef0ee, .262 }, H };
N l34n253[] = { { sf1ee, .350 }, { sgWV, .262 }, H };
N l34n254[] = { { se8f2fc, .481 }, H };
N l34n255[] = { { sQef, .146 }, { sf0ff, .146 }, H };

D l34_d = {
	"russian",
	"windows1251",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    0.005, 0.003, 0.014, 0.002, 0.009, 0.002, V, 0.001, 0.005, V, 0.007, 0.001, 0.010, 0.017, 0.005, 0.007,
	    0.002, 0.010, 0.005, 0.001, 0.001, 0.001, 0.001, 0.006, 0.001, V, V, V, V, 0.001, V, 0.006,
	    0.361, 0.083, 0.197, 0.068, 0.142, 0.365, 0.041, 0.073, 0.319, 0.052, 0.150, 0.218, 0.127, 0.286, 0.478, 0.119,
	    0.201, 0.205, 0.274, 0.146, 0.003, 0.040, 0.019, 0.057, 0.044, 0.010, 0.003, 0.084, 0.091, 0.006, 0.022, 0.085 },
	{ l34n0, l34n1, X, l34n3, l34n4, X, X, l34n7, l34n8, l34n9, l34n10, l34n11, l34n12, l34n13, l34n14, l34n15,
	    l34n16, l34n17, l34n18, l34n19, l34n20, l34n21, X, l34n23, l34n24, l34n25, l34n26, l34n27, l34n28, l34n29, l34n30, l34n31,
	    X, l34n33, l34n34, X, l34n36, l34n37, l34n38, l34n39, X, X, l34n42, X, l34n44, l34n45, l34n46, l34n47,
	    l34n48, l34n49, l34n50, l34n51, l34n52, l34n53, l34n54, l34n55, l34n56, l34n57, l34n58, X, l34n60, l34n61, l34n62, X,
	    l34n64, l34n65, l34n66, l34n67, l34n68, l34n69, l34n70, l34n71, l34n72, X, l34n74, l34n75, X, l34n77, l34n78, l34n79,
	    l34n80, l34n81, X, X, X, l34n85, l34n86, l34n87, X, l34n89, X, l34n91, X, l34n93, l34n94, l34n95,
	    X, l34n97, l34n98, l34n99, l34n100, X, l34n102, l34n103, l34n104, X, l34n106, l34n107, l34n108, l34n109, l34n110, l34n111,
	    l34n112, l34n113, X, X, l34n116, X, l34n118, l34n119, l34n120, l34n121, X, l34n123, l34n124, l34n125, l34n126, l34n127,
	    l34n128, l34n129, l34n130, l34n131, l34n132, l34n133, X, l34n135, l34n136, X, X, X, l34n140, l34n141, X, l34n143,
	    l34n144, l34n145, l34n146, l34n147, l34n148, l34n149, l34n150, l34n151, l34n152, X, l34n154, X, l34n156, l34n157, l34n158, l34n159,
	    l34n160, X, l34n162, l34n163, l34n164, l34n165, X, l34n167, l34n168, X, l34n170, l34n171, X, l34n173, l34n174, X,
	    l34n176, l34n177, X, l34n179, l34n180, l34n181, l34n182, l34n183, X, l34n185, l34n186, l34n187, l34n188, X, l34n190, l34n191,
	    X, l34n193, l34n194, l34n195, l34n196, l34n197, l34n198, l34n199, l34n200, l34n201, X, l34n203, l34n204, l34n205, l34n206, l34n207,
	    l34n208, l34n209, X, l34n211, l34n212, l34n213, l34n214, l34n215, l34n216, l34n217, X, l34n219, l34n220, l34n221, l34n222, l34n223,
	    l34n224, l34n225, l34n226, l34n227, l34n228, l34n229, X, l34n231, l34n232, X, l34n234, l34n235, l34n236, X, l34n238, l34n239,
	    l34n240, l34n241, l34n242, l34n243, l34n244, X, l34n246, l34n247, X, l34n249, l34n250, l34n251, l34n252, l34n253, l34n254, l34n255 }
};

//
// Lng: slovak
// Enc: windows1250
//

S s9dg[] = { 157, a };
S sX9d[] = { 97, 157, 0 };
S sX9dg[] = { 97, 157, a };
S szX9d[] = { v, 97, 157, 0 };
S szX9dg[] = { v, 97, 157, a };
S stvih[] = { p, r, e, d, 0 };
S svih[] = { r, e, d, 0 };
S soxs[] = { k, t, o, 0 };
S sszg[] = { o, v, a };
S sszX9d[] = { o, v, 97, 157, 0 };
S sgoxs[] = { 32, k, t, o, 0 };
S soxsv[] = { k, t, o, r, 0 };
S sw9d[] = { s, 157, 0 };
S sgXo[] = { 32, 97, k, 0 };
S sgzp[] = { 32, v, l, 0 };
S szp[] = { v, l, 0 };
S sfdqg[] = { 253, m, a };
S swxXz[] = { s, t, 97, v, 0 };
S srfdZ[] = { n, 253, 99, 0 };
S shsq[] = { d, o, m, 0 };
S szih[] = { v, e, d, 0 };
S srfdZl[] = { n, 253, 99, h, 0 };
S sRZ[] = { 225, 99, 0 };
S sz9a[] = { v, 154, 0 };
S s9ai[] = { 154, e, 0 };
S srsq[] = { n, o, m, 0 };
S sihwx[] = { e, d, s, t, 0 };
S svihw[] = { r, e, d, s, 0 };
S smpm[] = { i, l, i, 0 };
S ssw9d[] = { o, s, 157, 0 };
S s9ei[] = { 158, e, 0 };
S sw9dg[] = { s, 157, a };
S sgtsw[] = { 32, p, o, s, 0 };
S sihw[] = { e, d, s, 0 };
S shwxX[] = { d, s, t, 97, 0 };
S sgXos[] = { 32, 97, k, o, 0 };
S smR[] = { i, 225, 0 };
S shwx[] = { d, s, t, 0 };
S sYyhi[] = { 98, u, d, e, 0 };
S svsz[] = { r, o, v, 0 };
S sils[] = { e, h, o, 0 };
S se8X[] = { 232, 97, 0 };
S sRpr[] = { 225, l, n, 0 };
S sixo[] = { e, t, k, 0 };
S szpR[] = { v, l, 225, 0 };
S s9aixo[] = { 154, e, t, k, 0 };
S s9eig[] = { 158, e, a };
S sgzpR[] = { 32, v, l, 225, 0 };
S syhig[] = { u, d, e, a };
S silsg[] = { e, h, o, a };
S szy[] = { v, u, 0 };
S spRh[] = { l, 225, d, 0 };
S syni[] = { u, j, e, 0 };
S sgwfa[] = { 32, s, 250, 0 };
S sz9ai[] = { v, 154, e, 0 };
S snq[] = { j, m, 0 };
S sXzm[] = { 97, v, i, 0 };
S sRh[] = { 225, d, 0 };
S sie8[] = { e, 232, 0 };
S sibe[] = { e, 190, 0 };
S s9aix[] = { 154, e, t, 0 };
S szpRh[] = { v, l, 225, d, 0 };
S swfa[] = { s, 250, 0 };
S sz9aix[] = { v, 154, e, t, 0 };
S shsqm[] = { d, o, m, i, 0 };
S sxibe[] = { t, e, 190, 0 };
S se8ir[] = { 232, e, n, 0 };
S sgz9a[] = { 32, v, 154, 0 };
S sg9ei[] = { 32, 158, e, 0 };
S sxibes[] = { t, e, 190, o, 0 };
S sswpX[] = { o, s, l, 97, 0 };
S sfaZ[] = { 250, 99, 0 };
S ssxmg[] = { o, t, i, a };
S svsxm[] = { r, o, t, i, 0 };
S stvsx[] = { p, r, o, t, 0 };
S sibesz[] = { e, 190, o, v, 0 };
S ssw9dg[] = { o, s, 157, a };
S sg9e[] = { 32, 158, 0 };
S sgwxv[] = { 32, s, t, r, 0 };
S sxed[] = { t, 237, 0 };
S sbeX[] = { 190, 97, 0 };
S srsqg[] = { n, o, m, a };
S swpX[] = { s, l, 97, 0 };
S sm9d[] = { i, 157, 0 };
S swpXr[] = { s, l, 97, n, 0 };
S smXv[] = { i, 97, r, 0 };
S sbes[] = { 190, o, 0 };
S svszX[] = { r, o, v, 97, 0 };
S svsx[] = { r, o, t, 0 };
S smxibe[] = { i, t, e, 190, 0 };
S sm9dg[] = { i, 157, a };
S sxfd[] = { t, 253, 0 };
S sedw[] = { 237, s, 0 };
S sts7a[] = { p, o, z, 0 };
S se9q[] = { 233, m, 0 };
S shsz[] = { d, o, v, 0 };
S sibes[] = { e, 190, o, 0 };
S smpmg[] = { i, l, i, a };
S srsw9d[] = { n, o, s, 157, 0 };
S ssxm[] = { o, t, i, 0 };
S stswp[] = { p, o, s, l, 0 };
S s7ah[] = { z, d, 0 };
S sbesz[] = { 190, o, v, 0 };

N l35n0[] = { { sibesz, .153 }, H };
N l35n2[] = { { srmig, .268 }, H };
N l35n3[] = { { ssv, .447 }, H };
N l35n5[] = { { sxm, .319 }, { smr, .192 }, { spR, .115 }, H };
N l35n7[] = { { sri, .498 }, H };
N l35n8[] = { { swo, .153 }, { ssxmg, .230 }, H };
N l35n9[] = { { szsg, .172 }, H };
N l35n10[] = { { sYp, .077 }, H };
N l35n12[] = { { sirm, .153 }, H };
N l35n13[] = { { sXr, .549 }, { spm, .357 }, { sgzi, .287 }, { swg, .172 }, H };
N l35n14[] = { { ssqg, .517 }, { sfdZlg, 1.120 }, { sosr, .192 }, { sgwXg, .268 }, { smXv, .115 }, H };
N l35n15[] = { { sred, .115 }, { szy, .089 }, H };
N l35n16[] = { { sswx, .287 }, H };
N l35n17[] = { { se8m, .259 }, { siz, .077 }, H };
N l35n19[] = { { snq, .089 }, H };
N l35n20[] = { { ssw, .472 }, H };
N l35n21[] = { { sgts, .804 }, { ssh, .319 }, { shm, .140 }, { sog, .172 }, { sRz, .230 }, H };
N l35n22[] = { { sgzg, .747 }, H };
N l35n23[] = { { szfd, .089 }, H };
N l35n24[] = { { sZo, .102 }, { sXzm, .134 }, H };
N l35n25[] = { { swp, .192 }, H };
N l35n28[] = { { svr, .140 }, H };
N l35n29[] = { { sgq, .632 }, H };
N l35n30[] = { { sYyhi, .179 }, H };
N l35n31[] = { { srfd, .140 }, { se9l, .201 }, H };
N l35n32[] = { { sspm, .115 }, H };
N l35n33[] = { { szpR, .134 }, { sxig, .172 }, H };
N l35n34[] = { { stv, .804 }, { smZlg, .345 }, H };
N l35n35[] = { { s9dg, 1.120 }, { srXg, .460 }, { sil, .089 }, H };
N l35n36[] = { { swxm, .134 }, { sm9d, .077 }, { stswp, .153 }, H };
N l35n37[] = { { ssx, .153 }, { s7as, .153 }, { sRpr, .302 }, { sgsv, .201 }, { sg7aX, .172 }, H };
N l35n38[] = { { syhi, .134 }, { sgoX, .201 }, H };
N l35n39[] = { { sxo, .089 }, H };
N l35n40[] = { { smX, .345 }, { svihw, .204 }, H };
N l35n41[] = { { svsx, .115 }, H };
N l35n42[] = { { shsq, .172 }, { slv, .102 }, H };
N l35n43[] = { { sre9g, .230 }, H };
N l35n44[] = { { sX9d, .306 }, { sqm, .243 }, { sxg, .172 }, { sihwx, .204 }, H };
N l35n45[] = { { svs, .421 }, { sts7a, .115 }, H };
N l35n46[] = { { sgr, .843 }, { swxXz, .255 }, H };
N l35n49[] = { { shig, .345 }, { sxyg, .230 }, { ssqm, .153 }, H };
N l35n51[] = { { ssw9dg, .230 }, H };
N l35n52[] = { { spg, .249 }, H };
N l35n53[] = { { syn, .089 }, H };
N l35n54[] = { { sgtv, 1.580 }, { sfdZ, .373 }, { ssy, .115 }, H };
N l35n55[] = { { s7aX, .102 }, { sgXos, .306 }, { sgvs, .201 }, { s9eig, .302 }, { sz9aix, .179 }, H };
N l35n56[] = { { sxibes, .153 }, H };
N l35n59[] = { { stsh, .153 }, H };
N l35n60[] = { { shg, .115 }, H };
N l35n61[] = { { sYs, .102 }, H };
N l35n63[] = { { sgs, .728 }, { svX, .306 }, { svsz, .134 }, { spXr, .115 }, H };
N l35n64[] = { { sfdqg, .646 }, H };
N l35n65[] = { { sgni, .230 }, { sgtsh, .268 }, { sgwfa, .201 }, H };
N l35n67[] = { { szm, .268 }, { srR, .140 }, { stvsx, .153 }, H };
N l35n68[] = { { sgoxs, .498 }, { swpX, .115 }, { se9lsg, .517 }, H };
N l35n69[] = { { sZlg, .977 }, { sin, .268 }, { sti, .115 }, H };
N l35n70[] = { { syo, .077 }, H };
N l35n71[] = { { ssz, .689 }, H };
N l35n72[] = { { sgqX, .345 }, { sge8, .172 }, { silsg, .268 }, H };
N l35n73[] = { { sszX9d, .357 }, { sghs, .287 }, { smv, .077 }, H };
N l35n74[] = { { smZ, .243 }, { s79w, .077 }, H };
N l35n75[] = { { srm, .485 }, { syg, .670 }, { szih, .172 }, H };
N l35n76[] = { { sws, .115 }, H };
N l35n77[] = { { stvX, .192 }, { szpRh, .179 }, H };
N l35n79[] = { { sYX, .077 }, H };
N l35n80[] = { { sgt, 1.724 }, H };
N l35n81[] = { { sgX, .919 }, { sXv, .204 }, { sxsv, .268 }, { spRh, .134 }, { svXz, .115 }, H };
N l35n83[] = { { sqg, .766 }, { sz79, .230 }, { sgwt, .172 }, H };
N l35n84[] = { { sos, .421 }, { sgz9a, .172 }, H };
N l35n86[] = { { sio, .077 }, { sedw, .172 }, H };
N l35n87[] = { { slsg, .431 }, { se9g, .560 }, { s9aix, .201 }, H };
N l35n89[] = { { sgrX, .575 }, { sgxs, .172 }, { ssl, .077 }, H };
N l35n90[] = { { sw9d, .140 }, { sgzp, .316 }, { sxr, .140 }, { smw, .115 }, { sg7ag, .230 }, H };
N l35n91[] = { { sig, 1.398 }, { sr79, .115 }, { s9ai, .153 }, H };
N l35n93[] = { { swt, .077 }, H };
N l35n94[] = { { swX, .153 }, { so79g, .259 }, { sg9e, .115 }, H };
N l35n95[] = { { sRg, .345 }, H };
N l35n96[] = { { srfdZ, .172 }, { srsq, .153 }, H };
N l35n97[] = { { sbes, .115 }, H };
N l35n98[] = { { sgY, .326 }, { sXw, .140 }, { spr, .115 }, { svszX, .153 }, H };
N l35n99[] = { { sXh, .153 }, H };
N l35n100[] = { { svsxm, .153 }, H };
N l35n101[] = { { sgtvi, 1.034 }, { sxmg, .345 }, { shsqm, .153 }, H };
N l35n102[] = { { soX, .153 }, { smpm, .153 }, { sfag, .345 }, { swxs, .134 }, { se8r, .201 }, H };
N l35n103[] = { { srig, .402 }, H };
N l35n105[] = { { sgYy, .287 }, H };
N l35n106[] = { { szg, .823 }, { shr, .102 }, { s7ah, .077 }, H };
N l35n107[] = { { sxs, .511 }, { smx, .204 }, { sRp, .316 }, H };
N l35n108[] = { { smi, .421 }, H };
N l35n109[] = { { spmg, .373 }, H };
N l35n110[] = { { soxs, .287 }, { sgtsw, .306 }, { sZX, .077 }, { sXpm, .115 }, H };
N l35n113[] = { { sgtvm, .268 }, H };
N l35n114[] = { { sszX, .402 }, { sgv, .249 }, { srg, .172 }, H };
N l35n115[] = { { sXx, .192 }, { sgZ, .268 }, { sps, .166 }, { sbeX, .115 }, { sbesz, .172 }, H };
N l35n116[] = { { sgqi, .230 }, { se9q, .172 }, H };
N l35n117[] = { { sgsY, .316 }, { szXr, .115 }, { sgyt, .144 }, H };
N l35n118[] = { { szp, .140 }, H };
N l35n120[] = { { siq, .115 }, H };
N l35n121[] = { { stvi, .517 }, { srsw9d, .153 }, H };
N l35n122[] = { { szX9d, .345 }, { sirw, .115 }, H };
N l35n123[] = { { shs, .409 }, { ssn, .128 }, H };
N l35n125[] = { { sxX, .255 }, H };
N l35n127[] = { { sgwx, .316 }, H };
N l35n131[] = { { sgw, 1.168 }, { svi, .536 }, { sgtvs, .345 }, H };
N l35n132[] = { { sgh, .306 }, { sz9a, .115 }, { swxmg, .230 }, { sm9dg, .172 }, H };
N l35n133[] = { { spX, .319 }, { sgri, .460 }, H };
N l35n134[] = { { syhig, .268 }, H };
N l35n135[] = { { swxv, .153 }, { sov, .089 }, { swfa, .089 }, { se8ir, .259 }, H };
N l35n136[] = { { smXg, .373 }, { sixo, .134 }, H };
N l35n137[] = { { sir, .345 }, { se8X, .201 }, H };
N l35n139[] = { { sni, .230 }, { ss7a, .204 }, { sgsh, .287 }, { sved, .077 }, H };
N l35n140[] = { { sX9dg, .689 }, { sso, .140 }, { syni, .134 }, H };
N l35n141[] = { { shX, .102 }, { smz, .089 }, { shsz, .115 }, H };
N l35n142[] = { { swpXr, .153 }, H };
N l35n143[] = { { sxXz, .192 }, H };
N l35n144[] = { { sXrm, .249 }, H };
N l35n145[] = { { ssg, 1.015 }, H };
N l35n146[] = { { sqs, .166 }, H };
N l35n147[] = { { sYi, .089 }, { svy, .077 }, { stsp, .115 }, H };
N l35n148[] = { { sgx, .498 }, H };
N l35n149[] = { { sXz, .255 }, { sgYyh, .383 }, { sgwz, .201 }, H };
N l35n150[] = { { ssyg, .201 }, H };
N l35n152[] = { { srfdZl, .230 }, { s9aixo, .268 }, { szr, .089 }, H };
N l35n155[] = { { syt, .077 }, H };
N l35n157[] = { { ssp, .243 }, H };
N l35n158[] = { { sxv, .166 }, { sibes, .115 }, H };
N l35n159[] = { { sXos, .153 }, H };
N l35n160[] = { { sqXx, .115 }, H };
N l35n161[] = { { swx, .804 }, H };
N l35n162[] = { { srsw, .230 }, { srmi, .211 }, H };
N l35n163[] = { { sYy, .128 }, { sie8, .089 }, H };
N l35n164[] = { { sqX, .204 }, { sihs, .249 }, H };
N l35n165[] = { { stvih, .434 }, { sing, .460 }, { sgy, .192 }, { sg7aR, .259 }, { stvm, .134 }, H };
N l35n166[] = { { sgj, .153 }, H };
N l35n167[] = { { sszg, .431 }, H };
N l35n168[] = { { smR, .102 }, { ssxm, .115 }, H };
N l35n169[] = { { szs, .268 }, { sox, .243 }, H };
N l35n171[] = { { sit, .077 }, H };
N l35n174[] = { { ssq, .421 }, { sfdZl, .560 }, { sgwX, .259 }, H };
N l35n175[] = { { stvXz, .153 }, H };
N l35n177[] = { { srs, .383 }, { sgXg, .718 }, { sgrm, .172 }, H };
N l35n180[] = { { sosg, .259 }, H };
N l35n181[] = { { sg9ei, .172 }, H };
N l35n182[] = { { sgz, 1.666 }, H };
N l35n183[] = { { s7aR, .166 }, H };
N l35n184[] = { { slg, .651 }, { sswp, .115 }, H };
N l35n185[] = { { sgrXg, .383 }, H };
N l35n186[] = { { sw9dg, .230 }, { soy, .077 }, H };
N l35n187[] = { { szX, .434 }, { shwx, .153 }, { sr79g, .172 }, H };
N l35n189[] = { { siY, .102 }, { ssvr, .134 }, H };
N l35n190[] = { { swXg, .230 }, H };
N l35n191[] = { { ssr, .230 }, { shw, .140 }, { svR, .102 }, H };
N l35n192[] = { { srsqg, .230 }, { sgos, .172 }, H };
N l35n193[] = { { sxi, .281 }, H };
N l35n194[] = { { smZl, .172 }, { smxi, .134 }, { sofd, .089 }, H };
N l35n195[] = { { srX, .434 }, { swz, .102 }, { srsz, .153 }, { sfdg, .259 }, H };
N l35n196[] = { { soxsv, .306 }, H };
N l35n198[] = { { smpmg, .230 }, H };
N l35n199[] = { { s79g, .517 }, { svm, .217 }, H };
N l35n200[] = { { sgl, .230 }, H };
N l35n201[] = { { sXn, .294 }, { spi, .179 }, { sxed, .077 }, H };
N l35n202[] = { { sXxi, .134 }, H };
N l35n203[] = { { sxsg, .345 }, { sre9, .140 }, H };
N l35n204[] = { { swxX, .287 }, { smig, .402 }, H };
N l35n205[] = { { siv, .204 }, { se8i, .259 }, H };
N l35n207[] = { { svih, .326 }, { syh, .128 }, H };
N l35n208[] = { { sihw, .153 }, H };
N l35n209[] = { { shi, .268 }, { sxy, .153 }, { sm7a, .102 }, H };
N l35n210[] = { { sRZ, .259 }, { smo, .102 }, H };
N l35n211[] = { { sedg, .689 }, { ssw9d, .153 }, H };
N l35n213[] = { { sgwxv, .230 }, H };
N l35n215[] = { { smg, .881 }, { s9ei, .153 }, H };
N l35n217[] = { { sgm, .306 }, { sibe, .089 }, { sfaZ, .172 }, { sxfd, .077 }, H };
N l35n218[] = { { szX9dg, .689 }, { sXo, .217 }, H };
N l35n219[] = { { sz9ai, .134 }, { sswpX, .153 }, H };
N l35n222[] = { { siw, .115 }, { shwxX, .204 }, H };
N l35n223[] = { { sXg, 1.762 }, { sih, .472 }, H };
N l35n224[] = { { sfdq, .316 }, { stsw, .153 }, H };
N l35n225[] = { { sst, .089 }, H };
N l35n227[] = { { smp, .153 }, { sRh, .201 }, H };
N l35n228[] = { { se9ls, .302 }, H };
N l35n229[] = { { sZl, .523 }, H };
N l35n230[] = { { s7ag, .192 }, H };
N l35n231[] = { { stvs, .192 }, { sY79, .077 }, H };
N l35n232[] = { { sqi, .230 }, { sils, .134 }, H };
N l35n233[] = { { sgz79, .460 }, { svo, .077 }, H };
N l35n234[] = { { sgn, .249 }, { sgXo, .316 }, { skX, .089 }, H };
N l35n235[] = { { sXp, .192 }, { snig, .259 }, { sxibe, .115 }, H };
N l35n238[] = { { svg, .326 }, H };
N l35n239[] = { { sts, .536 }, { six, .192 }, { sYyh, .192 }, H };
N l35n243[] = { { ssY, .294 }, { sRx, .201 }, H };
N l35n245[] = { { srw, .089 }, H };
N l35n246[] = { { sZm, .306 }, { sng, .440 }, H };
N l35n247[] = { { sls, .345 }, { sgox, .373 }, H };
N l35n249[] = { { svXr, .172 }, H };
N l35n250[] = { { sg7a, .709 }, H };
N l35n251[] = { { sgo, .555 }, H };
N l35n252[] = { { sXq, .102 }, { smxibe, .153 }, H };
N l35n253[] = { { sxR, .102 }, { sgzpR, .268 }, H };
N l35n254[] = { { so79, .115 }, H };
N l35n255[] = { { szi, .268 }, { sXosg, .306 }, H };

D l35_d = {
	"slovak",
	"windows1250",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.171, 0.034, 0.047, 0.071, 0.147, 0.007, 0.009, 0.045, 0.123, 0.039, 0.066, 0.062, 0.067, 0.121, 0.194,
	    0.070, W, 0.101, 0.090, 0.099, 0.049, 0.111, W, 0.001, 0.030, 0.040, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.001, Y, Y, 0.002, 0.004, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.018, Y, Y, 0.033, 0.020, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.011, Y,
	    Y, 0.001, V, V, V, V, V, V, 0.011, V, V, V, V, 0.001, V, V,
	    V, V, V, V, V, V, V, V, V, V, 0.002, V, V, 0.003, V, V,
	    V, 0.084, V, V, 0.008, V, V, V, 0.041, 0.033, V, V, V, 0.047, V, 0.003,
	    V, V, 0.009, 0.003, 0.005, V, V, V, V, V, 0.034, V, V, 0.046, V, V },
	{ l35n0, X, l35n2, l35n3, X, l35n5, X, l35n7, l35n8, l35n9, l35n10, X, l35n12, l35n13, l35n14, l35n15,
	    l35n16, l35n17, X, l35n19, l35n20, l35n21, l35n22, l35n23, l35n24, l35n25, X, X, l35n28, l35n29, l35n30, l35n31,
	    l35n32, l35n33, l35n34, l35n35, l35n36, l35n37, l35n38, l35n39, l35n40, l35n41, l35n42, l35n43, l35n44, l35n45, l35n46, X,
	    X, l35n49, X, l35n51, l35n52, l35n53, l35n54, l35n55, l35n56, X, X, l35n59, l35n60, l35n61, X, l35n63,
	    l35n64, l35n65, X, l35n67, l35n68, l35n69, l35n70, l35n71, l35n72, l35n73, l35n74, l35n75, l35n76, l35n77, X, l35n79,
	    l35n80, l35n81, X, l35n83, l35n84, X, l35n86, l35n87, X, l35n89, l35n90, l35n91, X, l35n93, l35n94, l35n95,
	    l35n96, l35n97, l35n98, l35n99, l35n100, l35n101, l35n102, l35n103, X, l35n105, l35n106, l35n107, l35n108, l35n109, l35n110, X,
	    X, l35n113, l35n114, l35n115, l35n116, l35n117, l35n118, X, l35n120, l35n121, l35n122, l35n123, X, l35n125, X, l35n127,
	    X, X, X, l35n131, l35n132, l35n133, l35n134, l35n135, l35n136, l35n137, X, l35n139, l35n140, l35n141, l35n142, l35n143,
	    l35n144, l35n145, l35n146, l35n147, l35n148, l35n149, l35n150, X, l35n152, X, X, l35n155, X, l35n157, l35n158, l35n159,
	    l35n160, l35n161, l35n162, l35n163, l35n164, l35n165, l35n166, l35n167, l35n168, l35n169, X, l35n171, X, X, l35n174, l35n175,
	    X, l35n177, X, X, l35n180, l35n181, l35n182, l35n183, l35n184, l35n185, l35n186, l35n187, X, l35n189, l35n190, l35n191,
	    l35n192, l35n193, l35n194, l35n195, l35n196, X, l35n198, l35n199, l35n200, l35n201, l35n202, l35n203, l35n204, l35n205, X, l35n207,
	    l35n208, l35n209, l35n210, l35n211, X, l35n213, X, l35n215, X, l35n217, l35n218, l35n219, X, X, l35n222, l35n223,
	    l35n224, l35n225, X, l35n227, l35n228, l35n229, l35n230, l35n231, l35n232, l35n233, l35n234, l35n235, X, X, l35n238, l35n239,
	    X, X, X, l35n243, X, l35n245, l35n246, l35n247, X, l35n249, l35n250, l35n251, l35n252, l35n253, l35n254, l35n255 }
};

//
// Lng: slovenian
// Enc: iso-8859-2
//

S sgYs[] = { 32, 98, o, 0 };
S sXb9[] = { 97, 185, 0 };
S szw[] = { v, s, 0 };
S sgtXg[] = { 32, p, 97, a };
S sXrn[] = { 97, n, j, 0 };
S sikX[] = { e, g, 97, 0 };
S sme8[] = { i, 232, 0 };
S sikXg[] = { e, g, 97, a };
S spmx[] = { l, i, t, 0 };
S sqmg[] = { m, i, a };
S svbeX[] = { r, 190, 97, 0 };
S svbe[] = { r, 190, 0 };
S sizg[] = { e, v, a };
S smb9[] = { i, 185, 0 };
S shvbe[] = { d, r, 190, 0 };
S sspmx[] = { o, l, i, t, 0 };
S ssks[] = { o, g, o, 0 };
S sYmg[] = { 98, i, a };
S sb9i[] = { 185, e, 0 };
S shvbeX[] = { d, r, 190, 97, 0 };
S smqmg[] = { i, m, i, a };
S sgYmg[] = { 32, 98, i, a };
S sYsg[] = { 98, o, a };
S stsk[] = { p, o, g, 0 };
S sxiz[] = { t, e, v, 0 };
S sXzr[] = { 97, v, n, 0 };
S sXng[] = { 97, j, a };
S svbeXz[] = { r, 190, 97, v, 0 };
S sbeXz[] = { 190, 97, v, 0 };
S sme8r[] = { i, 232, n, 0 };
S sghvbe[] = { 32, d, r, 190, 0 };
S sb9o[] = { 185, k, 0 };
S spny[] = { l, j, u, 0 };
S sgtsk[] = { 32, p, o, g, 0 };
S soXxi[] = { k, 97, t, e, 0 };
S sxme8[] = { t, i, 232, 0 };
S sovi[] = { k, r, e, 0 };
S sXxiv[] = { 97, t, e, r, 0 };
S sgzw[] = { 32, v, s, 0 };
S sxme8r[] = { t, i, 232, n, 0 };
S swpsz[] = { s, l, o, v, 0 };
S sgwsg[] = { 32, s, o, a };
S stsks[] = { p, o, g, o, 0 };
S ssksz[] = { o, g, o, v, 0 };
S sgomg[] = { 32, k, i, a };
S szrm[] = { v, n, i, 0 };
S spXh[] = { l, 97, d, 0 };
S syhmg[] = { u, d, i, a };
S sXxmg[] = { 97, t, i, a };
S sovit[] = { k, r, e, p, 0 };
S sgzsp[] = { 32, v, o, l, 0 };
S srmlg[] = { n, i, h, a };
S sXlg[] = { 97, h, a };
S srml[] = { n, i, h, 0 };
S sswxm[] = { o, s, t, i, 0 };
S se8y[] = { 232, u, 0 };
S sirmg[] = { e, n, i, a };
S snXp[] = { j, 97, l, 0 };
S szspm[] = { v, o, l, i, 0 };
S sgYsg[] = { 32, 98, o, a };
S svXe8y[] = { r, 97, 232, u, 0 };
S swosg[] = { s, k, o, a };
S sxizg[] = { t, e, v, a };
S sgrmg[] = { 32, n, i, a };
S sshm[] = { o, d, i, 0 };
S sgwps[] = { 32, s, l, o, 0 };
S srmqm[] = { n, i, m, i, 0 };
S sgb9ig[] = { 32, 185, e, a };
S sYsp[] = { 98, o, l, 0 };
S smxiz[] = { i, t, e, v, 0 };
S sXe8y[] = { 97, 232, u, 0 };
S sihX[] = { e, d, 97, 0 };
S svnX[] = { r, j, 97, 0 };
S se8yr[] = { 232, u, n, 0 };
S sgb9i[] = { 32, 185, e, 0 };
S szwi[] = { v, s, e, 0 };
S svXe8[] = { r, 97, 232, 0 };
S sXe8yr[] = { 97, 232, u, n, 0 };
S srikX[] = { n, e, g, 97, 0 };
S sriq[] = { n, e, m, 0 };
S sgxyh[] = { 32, t, u, d, 0 };
S sgxiq[] = { 32, t, e, m, 0 };

N l36n0[] = { { smb9, .133 }, H };
N l36n1[] = { { stX, .199 }, H };
N l36n2[] = { { swig, .477 }, H };
N l36n3[] = { { ssv, .305 }, { svnX, .119 }, H };
N l36n5[] = { { sxm, .491 }, { smr, .384 }, { ssqi, .119 }, H };
N l36n7[] = { { sri, .464 }, { sXlg, .209 }, H };
N l36n8[] = { { swo, .305 }, { sXb9, .172 }, H };
N l36n9[] = { { spmx, .219 }, H };
N l36n10[] = { { soig, .209 }, { sYp, .093 }, { sihX, .119 }, H };
N l36n12[] = { { sgp, .358 }, { sirm, .179 }, { sszs, .119 }, H };
N l36n13[] = { { sXr, .517 }, { spm, .504 }, { swg, .199 }, { ssks, .199 }, H };
N l36n14[] = { { sosr, .119 }, H };
N l36n15[] = { { sghXg, .597 }, H };
N l36n16[] = { { sswx, .298 }, H };
N l36n17[] = { { siz, .345 }, { srsg, .239 }, { se8m, .209 }, { sgrmg, .239 }, H };
N l36n18[] = { { sik, .199 }, H };
N l36n20[] = { { ssw, .398 }, H };
N l36n21[] = { { sgts, 1.163 }, { shm, .292 }, { ssh, .265 }, { sog, .159 }, H };
N l36n22[] = { { sgzg, .507 }, H };
N l36n23[] = { { sgm7a, .388 }, H };
N l36n25[] = { { swp, .212 }, H };
N l36n27[] = { { szrm, .139 }, H };
N l36n28[] = { { svr, .133 }, { sb9i, .199 }, H };
N l36n29[] = { { sgq, .457 }, { sxyh, .119 }, H };
N l36n30[] = { { spn, .331 }, H };
N l36n31[] = { { sme8, .159 }, H };
N l36n32[] = { { sspm, .278 }, { sXxiv, .212 }, H };
N l36n33[] = { { sop, .106 }, H };
N l36n34[] = { { stv, .544 }, H };
N l36n35[] = { { srXg, .537 }, { srmlg, .278 }, H };
N l36n36[] = { { swxm, .239 }, { stswp, .186 }, { smxiz, .159 }, H };
N l36n37[] = { { sg7aX, .895 }, { ssx, .133 }, { spny, .159 }, H };
N l36n38[] = { { sgoX, .328 }, H };
N l36n39[] = { { sgYs, .418 }, { sXe8, .119 }, { sgwp, .239 }, H };
N l36n41[] = { { sgb9, .179 }, { sXng, .268 }, H };
N l36n43[] = { { sspn, .139 }, H };
N l36n44[] = { { sqm, .172 }, { sxg, .219 }, H };
N l36n45[] = { { svs, .225 }, { sivg, .209 }, { swosg, .239 }, H };
N l36n46[] = { { sgr, .955 }, { ssvX, .179 }, { sovit, .186 }, { sXe8y, .119 }, H };
N l36n50[] = { { sgxiq, .239 }, H };
N l36n51[] = { { sxizg, .239 }, H };
N l36n52[] = { { spg, .517 }, H };
N l36n53[] = { { srmqm, .159 }, H };
N l36n54[] = { { sgtv, .925 }, H };
N l36n55[] = { { s7aX, .451 }, { sYmg, .298 }, { svXe8, .119 }, H };
N l36n56[] = { { se8g, .313 }, H };
N l36n58[] = { { sgwig, .517 }, H };
N l36n60[] = { { shg, .119 }, H };
N l36n61[] = { { sYs, .292 }, { sikX, .239 }, H };
N l36n63[] = { { svX, .650 }, { sgs, .676 }, { spXr, .139 }, H };
N l36n64[] = { { swpsz, .212 }, H };
N l36n65[] = { { sgni, .776 }, H };
N l36n67[] = { { szm, .252 }, { smpg, .447 }, H };
N l36n68[] = { { swpX, .119 }, { szwi, .119 }, H };
N l36n69[] = { { sgYmg, .358 }, { sin, .093 }, { sti, .080 }, H };
N l36n71[] = { { ssz, .544 }, { snX, .371 }, { sxme8r, .212 }, H };
N l36n72[] = { { ssk, .186 }, { sgws, .388 }, { sgqX, .239 }, H };
N l36n73[] = { { sghs, .358 }, H };
N l36n74[] = { { skXg, .388 }, { sgtsk, .318 }, H };
N l36n75[] = { { srm, .902 }, { syg, .298 }, { sXpg, .239 }, { szih, .159 }, { sswxm, .186 }, H };
N l36n76[] = { { sws, .278 }, H };
N l36n77[] = { { stvX, .199 }, { szsp, .159 }, H };
N l36n78[] = { { somg, .358 }, H };
N l36n79[] = { { sXzr, .179 }, { sYX, .080 }, H };
N l36n80[] = { { sgt, 1.671 }, H };
N l36n81[] = { { sXv, .239 }, { sgX, .239 }, { svXz, .199 }, H };
N l36n82[] = { { syhm, .139 }, H };
N l36n83[] = { { sqg, .457 }, { svit, .179 }, { sgwt, .179 }, H };
N l36n84[] = { { sos, .517 }, { smqg, .209 }, H };
N l36n86[] = { { sio, .199 }, { smwx, .179 }, { sXxmg, .278 }, { sZmg, .209 }, H };
N l36n88[] = { { sxyhm, .159 }, H };
N l36n89[] = { { sgrX, .597 }, { sgxs, .179 }, H };
N l36n90[] = { { smw, .239 }, { sg7ag, .328 }, H };
N l36n91[] = { { sig, 2.048 }, { sgkp, .179 }, H };
N l36n92[] = { { srn, .239 }, { stsk, .179 }, H };
N l36n93[] = { { swt, .106 }, H };
N l36n95[] = { { swoi, .179 }, H };
N l36n97[] = { { stXg, .358 }, H };
N l36n98[] = { { sgY, .716 }, { spr, .159 }, { soXx, .179 }, { sXw, .106 }, H };
N l36n99[] = { { sXh, .252 }, H };
N l36n101[] = { { smrg, .716 }, { sxmg, .477 }, { sgtvi, .398 }, H };
N l36n102[] = { { soX, .384 }, { se8r, .328 }, H };
N l36n103[] = { { sip, .225 }, { srig, .388 }, H };
N l36n106[] = { { szg, .756 }, { sghv, .477 }, { shr, .146 }, H };
N l36n107[] = { { smx, .278 }, { sxs, .265 }, H };
N l36n108[] = { { svbe, .146 }, { sirmg, .278 }, H };
N l36n109[] = { { spmg, .388 }, H };
N l36n110[] = { { sgtsw, .438 }, { sXpm, .119 }, H };
N l36n111[] = { { ssksz, .186 }, H };
N l36n112[] = { { sYv, .172 }, { sxiq, .159 }, H };
N l36n113[] = { { sgtvm, .438 }, { sizg, .298 }, H };
N l36n114[] = { { srg, .617 }, { sgv, .259 }, { sszX, .159 }, H };
N l36n115[] = { { sXx, .331 }, { sps, .225 }, { sbeX, .219 }, H };
N l36n116[] = { { sgwps, .239 }, { sgqi, .179 }, { srik, .119 }, H };
N l36n117[] = { { shmg, .388 }, { sgsY, .328 }, { ship, .139 }, H };
N l36n118[] = { { szp, .106 }, H };
N l36n119[] = { { smqm, .199 }, H };
N l36n120[] = { { siq, .305 }, { sXe8yr, .159 }, H };
N l36n121[] = { { stvi, .239 }, { syr, .106 }, H };
N l36n123[] = { { shs, .278 }, { sgtX, .418 }, { sgzs, .328 }, { sYmp, .139 }, { ssn, .093 }, H };
N l36n124[] = { { sspmx, .265 }, H };
N l36n125[] = { { sxX, .305 }, H };
N l36n126[] = { { sgom, .209 }, H };
N l36n127[] = { { sgwx, .179 }, H };
N l36n128[] = { { sgb9i, .179 }, H };
N l36n130[] = { { sb9o, .179 }, H };
N l36n131[] = { { sgw, 1.352 }, { svi, .557 }, H };
N l36n132[] = { { sgh, 1.173 }, { swxmg, .278 }, H };
N l36n133[] = { { spX, .438 }, { sg7aXg, .477 }, { sgri, .358 }, { spsz, .179 }, { sbeXz, .268 }, H };
N l36n135[] = { { sov, .146 }, { swxv, .139 }, { sgYsg, .278 }, H };
N l36n136[] = { { szspm, .186 }, H };
N l36n137[] = { { sir, .438 }, H };
N l36n139[] = { { sni, .623 }, { sgsh, .239 }, { svXh, .119 }, H };
N l36n140[] = { { sqmg, .328 }, { sso, .133 }, H };
N l36n141[] = { { shX, .438 }, { smz, .119 }, H };
N l36n142[] = { { srwo, .139 }, H };
N l36n144[] = { { sXrm, .139 }, H };
N l36n145[] = { { ssg, 1.790 }, { soXxi, .212 }, H };
N l36n146[] = { { sqs, .172 }, H };
N l36n147[] = { { sgmr, .626 }, { sYi, .093 }, { svy, .080 }, { stsp, .119 }, H };
N l36n148[] = { { sgx, .815 }, H };
N l36n149[] = { { sXz, .424 }, { sgi, .298 }, H };
N l36n150[] = { { svXe8y, .159 }, H };
N l36n151[] = { { s7aXg, .358 }, { svbeX, .219 }, { se8yr, .268 }, { srikX, .159 }, H };
N l36n152[] = { { szr, .199 }, { sshm, .119 }, H };
N l36n153[] = { { sihr, .119 }, H };
N l36n155[] = { { sny, .186 }, { sXrn, .239 }, { sYvX, .179 }, { sgxy, .179 }, H };
N l36n157[] = { { ssp, .371 }, { sikXg, .438 }, { sYsg, .268 }, { sgvX, .179 }, H };
N l36n158[] = { { sxv, .146 }, { sszi, .179 }, H };
N l36n159[] = { { sml, .239 }, { sgsg, .209 }, H };
N l36n161[] = { { swx, .597 }, { sgnig, 1.034 }, H };
N l36n162[] = { { swi, .477 }, { srsw, .179 }, { sqir, .139 }, H };
N l36n164[] = { { sqX, .212 }, { sghvbe, .358 }, H };
N l36n165[] = { { stvm, .219 }, { skp, .133 }, { sgy, .179 }, { stvih, .186 }, { sXpr, .119 }, H };
N l36n167[] = { { sxiv, .259 }, { sXl, .159 }, { snXg, .328 }, { sgzw, .239 }, { sszg, .179 }, H };
N l36n168[] = { { sgwsg, .278 }, H };
N l36n169[] = { { szs, .345 }, { stsks, .186 }, H };
N l36n170[] = { { soi, .199 }, H };
N l36n171[] = { { srmg, .835 }, { sit, .146 }, H };
N l36n172[] = { { swsg, .268 }, H };
N l36n173[] = { { syY, .106 }, H };
N l36n174[] = { { shv, .265 }, { ssq, .212 }, H };
N l36n175[] = { { sghX, .477 }, { stvXz, .186 }, H };
N l36n177[] = { { srs, .438 }, { sgrm, .268 }, H };
N l36n178[] = { { syhmg, .278 }, { sZi, .093 }, H };
N l36n179[] = { { srni, .139 }, H };
N l36n180[] = { { sosg, .597 }, H };
N l36n182[] = { { sgz, 1.213 }, { sriq, .119 }, H };
N l36n183[] = { { sgk, .199 }, H };
N l36n184[] = { { slg, .517 }, { sswp, .139 }, H };
N l36n185[] = { { szir, .119 }, { sgrXg, .239 }, H };
N l36n186[] = { { soy, .080 }, H };
N l36n187[] = { { szX, .345 }, H };
N l36n189[] = { { siY, .119 }, H };
N l36n191[] = { { shw, .146 }, { ssr, .106 }, { sgzsp, .278 }, H };
N l36n193[] = { { sxi, .583 }, { smn, .172 }, H };
N l36n194[] = { { smxi, .119 }, H };
N l36n195[] = { { srX, .530 }, { srml, .139 }, H };
N l36n198[] = { { soXg, .298 }, H };
N l36n199[] = { { svm, .384 }, { sgxyh, .239 }, H };
N l36n201[] = { { spi, .265 }, { sXn, .265 }, H };
N l36n202[] = { { sXxi, .159 }, H };
N l36n203[] = { { sxsg, .268 }, H };
N l36n204[] = { { swxX, .199 }, H };
N l36n205[] = { { siv, .358 }, { swos, .139 }, H };
N l36n206[] = { { siZ, .080 }, H };
N l36n207[] = { { snm, .159 }, { syh, .146 }, { svih, .219 }, H };
N l36n209[] = { { shi, .225 }, { sm7a, .225 }, { sxy, .106 }, { spXh, .139 }, H };
N l36n210[] = { { smo, .212 }, H };
N l36n211[] = { { sxiz, .179 }, H };
N l36n215[] = { { smg, 2.486 }, { sYm, .292 }, { smqmg, .398 }, H };
N l36n216[] = { { sks, .186 }, { siqg, .358 }, { shvbe, .199 }, { svn, .093 }, H };
N l36n217[] = { { sgm, .776 }, { sme8r, .179 }, H };
N l36n218[] = { { sgwi, .507 }, { sXo, .172 }, H };
N l36n219[] = { { sgtXg, .477 }, { sghi, .268 }, { shsg, .179 }, H };
N l36n220[] = { { szv, .146 }, H };
N l36n221[] = { { se8y, .209 }, { sxXg, .179 }, H };
N l36n222[] = { { swps, .159 }, { sovi, .159 }, { siw, .093 }, { sgomg, .278 }, H };
N l36n223[] = { { sXg, 2.585 }, { sih, .424 }, H };
N l36n224[] = { { stsw, .259 }, { sgb9ig, .239 }, H };
N l36n225[] = { { sYsp, .119 }, H };
N l36n226[] = { { sxz, .106 }, { sgqs, .209 }, H };
N l36n227[] = { { smp, .331 }, { sgwg, .179 }, H };
N l36n228[] = { { srmo, .179 }, H };
N l36n229[] = { { sgYm, .418 }, { spXg, .268 }, { srZ, .080 }, H };
N l36n230[] = { { s7ag, .358 }, { sXhm, .119 }, H };
N l36n231[] = { { szmp, .119 }, H };
N l36n232[] = { { sqi, .278 }, H };
N l36n234[] = { { sgn, .537 }, { skX, .225 }, { sksz, .139 }, H };
N l36n235[] = { { sXp, .464 }, { snig, 1.044 }, { sgxi, .477 }, { snXp, .139 }, H };
N l36n237[] = { { shXg, .626 }, { szw, .172 }, { shrm, .139 }, H };
N l36n238[] = { { som, .239 }, { svg, .278 }, { smxm, .159 }, H };
N l36n239[] = { { sts, .623 }, { six, .172 }, H };
N l36n243[] = { { sgmrg, .835 }, { ssY, .225 }, H };
N l36n244[] = { { smq, .305 }, { sXnX, .119 }, H };
N l36n245[] = { { srw, .106 }, H };
N l36n246[] = { { sng, .318 }, { sZm, .159 }, { sXxm, .199 }, H };
N l36n249[] = { { svbeXz, .239 }, { svXr, .139 }, H };
N l36n250[] = { { sg7a, 1.074 }, { srmq, .159 }, H };
N l36n251[] = { { sgo, .736 }, { shvbeX, .265 }, { snyg, .179 }, H };
N l36n252[] = { { sXq, .106 }, H };
N l36n253[] = { { sxme8, .159 }, H };
N l36n254[] = { { srswx, .212 }, H };
N l36n255[] = { { szi, .411 }, { smlg, .507 }, H };

D l36_d = {
	"slovenian",
	"iso-8859-2",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, 0.210, 0.047, 0.014, 0.082, 0.192, 0.002, 0.027, 0.021, 0.189, 0.071, 0.076, 0.098, 0.055, 0.133, 0.180,
	    0.065, W, 0.107, 0.097, 0.092, 0.038, 0.104, W, W, W, 0.044, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.001, Y, Y, Y, Y, 0.002, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.033, Y, Y, Y, Y, 0.019, Y,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, 0.047, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V },
	{ l36n0, l36n1, l36n2, l36n3, X, l36n5, X, l36n7, l36n8, l36n9, l36n10, X, l36n12, l36n13, l36n14, l36n15,
	    l36n16, l36n17, l36n18, X, l36n20, l36n21, l36n22, l36n23, X, l36n25, X, l36n27, l36n28, l36n29, l36n30, l36n31,
	    l36n32, l36n33, l36n34, l36n35, l36n36, l36n37, l36n38, l36n39, X, l36n41, X, l36n43, l36n44, l36n45, l36n46, X,
	    X, X, l36n50, l36n51, l36n52, l36n53, l36n54, l36n55, l36n56, X, l36n58, X, l36n60, l36n61, X, l36n63,
	    l36n64, l36n65, X, l36n67, l36n68, l36n69, X, l36n71, l36n72, l36n73, l36n74, l36n75, l36n76, l36n77, l36n78, l36n79,
	    l36n80, l36n81, l36n82, l36n83, l36n84, X, l36n86, X, l36n88, l36n89, l36n90, l36n91, l36n92, l36n93, X, l36n95,
	    X, l36n97, l36n98, l36n99, X, l36n101, l36n102, l36n103, X, X, l36n106, l36n107, l36n108, l36n109, l36n110, l36n111,
	    l36n112, l36n113, l36n114, l36n115, l36n116, l36n117, l36n118, l36n119, l36n120, l36n121, X, l36n123, l36n124, l36n125, l36n126, l36n127,
	    l36n128, X, l36n130, l36n131, l36n132, l36n133, X, l36n135, l36n136, l36n137, X, l36n139, l36n140, l36n141, l36n142, X,
	    l36n144, l36n145, l36n146, l36n147, l36n148, l36n149, l36n150, l36n151, l36n152, l36n153, X, l36n155, X, l36n157, l36n158, l36n159,
	    X, l36n161, l36n162, X, l36n164, l36n165, X, l36n167, l36n168, l36n169, l36n170, l36n171, l36n172, l36n173, l36n174, l36n175,
	    X, l36n177, l36n178, l36n179, l36n180, X, l36n182, l36n183, l36n184, l36n185, l36n186, l36n187, X, l36n189, X, l36n191,
	    X, l36n193, l36n194, l36n195, X, X, l36n198, l36n199, X, l36n201, l36n202, l36n203, l36n204, l36n205, l36n206, l36n207,
	    X, l36n209, l36n210, l36n211, X, X, X, l36n215, l36n216, l36n217, l36n218, l36n219, l36n220, l36n221, l36n222, l36n223,
	    l36n224, l36n225, l36n226, l36n227, l36n228, l36n229, l36n230, l36n231, l36n232, X, l36n234, l36n235, X, l36n237, l36n238, l36n239,
	    X, X, X, l36n243, l36n244, l36n245, l36n246, X, X, l36n249, l36n250, l36n251, l36n252, l36n253, l36n254, l36n255 }
};

//
// Lng: spanish
// Enc: iso-8859-15
//

S sf3rg[] = { 243, n, a };
S smf3r[] = { i, 243, n, 0 };
S smf3rg[] = { i, 243, n, a };
S sZmf3r[] = { 99, i, 243, n, 0 };
S spmry[] = { l, i, n, u, 0 };
S smry78[] = { i, n, u, x, 0 };
S sry78[] = { n, u, x, 0 };
S ssri[] = { o, n, e, 0 };
S sgpmr[] = { 32, l, i, n, 0 };
S sry78g[] = { n, u, x, a };
S spsw[] = { l, o, s, 0 };
S spswg[] = { l, o, s, a };
S sriwg[] = { n, e, s, a };
S sgyw[] = { 32, u, s, 0 };
S sZsrg[] = { 99, o, n, a };
S ssriw[] = { o, n, e, s, 0 };
S smsri[] = { i, o, n, e, 0 };
S sgpsw[] = { 32, l, o, s, 0 };
S sqsw[] = { m, o, s, 0 };
S sqswg[] = { m, o, s, a };
S syXp[] = { u, 97, l, 0 };
S sivs[] = { e, r, o, 0 };
S sZp[] = { 99, l, 0 };
S sgmrw[] = { 32, i, n, s, 0 };
S spXZ[] = { l, 97, 99, 0 };
S stsvg[] = { p, o, r, a };
S siqs[] = { e, m, o, 0 };
S sxiqX[] = { t, e, m, 97, 0 };
S sXvxm[] = { 97, r, t, i, 0 };
S srwxX[] = { n, s, t, 97, 0 };
S swmw[] = { s, i, s, 0 };
S swxXp[] = { s, t, 97, l, 0 };
S sivsg[] = { e, r, o, a };
S swmwx[] = { s, i, s, t, 0 };
S sxXpX[] = { t, 97, l, 97, 0 };
S sgwmw[] = { 32, s, i, s, 0 };
S swxiq[] = { s, t, e, m, 0 };
S svqX[] = { r, m, 97, 0 };
S sXqi[] = { 97, m, e, 0 };
S siqXg[] = { e, m, 97, a };
S smrxi[] = { i, n, t, e, 0 };
S s_Xvi[] = { w, 97, r, e, 0 };
S s_Xv[] = { w, 97, r, 0 };
S sgpsg[] = { 32, l, o, a };
S sXvms[] = { 97, r, i, o, 0 };

N l37n1[] = { { stX, .367 }, { smrx, .140 }, H };
N l37n2[] = { { swig, .289 }, H };
N l37n3[] = { { ssv, .449 }, { siqXg, .204 }, H };
N l37n4[] = { { sqXg, .255 }, { syrXg, .294 }, { ssZ, .088 }, H };
N l37n5[] = { { smr, .646 }, { sxm, .342 }, { sZmsr, .294 }, { svxm, .125 }, H };
N l37n6[] = { { srx, .614 }, { sgwm, .481 }, { shmw, .200 }, H };
N l37n7[] = { { sri, .343 }, { sghm, .391 }, H };
N l37n8[] = { { sXvig, .204 }, H };
N l37n9[] = { { slX, .171 }, { sXrx, .143 }, H };
N l37n10[] = { { stXvX, .304 }, { sYp, .097 }, H };
N l37n11[] = { { sZsq, .270 }, { svq, .109 }, { skv, .067 }, H };
N l37n12[] = { { sgp, 1.228 }, { smry, .270 }, H };
N l37n13[] = { { swg, 2.609 }, { sXr, .380 }, { spm, .372 }, { sgzi, .212 }, H };
N l37n16[] = { { swxXp, .151 }, H };
N l37n17[] = { { srsg, .269 }, H };
N l37n20[] = { { ssw, .684 }, { srwxX, .153 }, H };
N l37n21[] = { { shm, .282 }, { sgts, .345 }, { ssh, .145 }, H };
N l37n22[] = { { sms, .365 }, { sZsr, .443 }, { ssri, .247 }, { sXpX, .117 }, H };
N l37n23[] = { { sry, .253 }, H };
N l37n24[] = { { srj, .094 }, H };
N l37n26[] = { { spiwg, .241 }, H };
N l37n27[] = { { sf3rg, 1.146 }, { srhsg, .279 }, H };
N l37n29[] = { { sgq, .574 }, { sZg, .102 }, H };
N l37n31[] = { { ssrg, .374 }, { sghip, .238 }, H };
N l37n33[] = { { sxig, .674 }, { sxXp, .141 }, { sXvms, .133 }, H };
N l37n34[] = { { stv, .221 }, H };
N l37n35[] = { { sy78, .170 }, { srXg, .272 }, H };
N l37n36[] = { { sym, .132 }, H };
N l37n37[] = { { ssx, .093 }, H };
N l37n38[] = { { spmry, .347 }, { smir, .204 }, H };
N l37n40[] = { { smX, .157 }, { sXhs, .196 }, H };
N l37n41[] = { { sZp, .089 }, { spig, .158 }, H };
N l37n42[] = { { sgpsw, .325 }, H };
N l37n43[] = { { suyig, 1.098 }, { stiv, .196 }, { srxsg, .208 }, H };
N l37n44[] = { { sxg, .200 }, { sqm, .112 }, H };
N l37n45[] = { { svs, .348 }, { sivg, .311 }, H };
N l37n46[] = { { sgr, .391 }, H };
N l37n47[] = { { sXt, .112 }, H };
N l37n48[] = { { sgwiv, .272 }, { smrxi, .136 }, H };
N l37n49[] = { { shig, 1.506 }, { srxX, .130 }, { sgpsg, .204 }, H };
N l37n51[] = { { swmwx, .148 }, H };
N l37n52[] = { { spg, .755 }, H };
N l37n53[] = { { stsvg, .249 }, H };
N l37n54[] = { { sgtv, .402 }, { svqX, .106 }, H };
N l37n55[] = { { sgpX, .792 }, H };
N l37n56[] = { { sgZs, 1.118 }, H };
N l37n57[] = { { sgip, .679 }, { smY, .107 }, H };
N l37n58[] = { { sgwig, .264 }, H };
N l37n59[] = { { sghig, 1.736 }, H };
N l37n60[] = { { shg, .194 }, H };
N l37n61[] = { { siqs, .121 }, H };
N l37n62[] = { { siwg, 1.214 }, { sky, .135 }, H };
N l37n63[] = { { svX, .558 }, { sgs, .302 }, { sry78, .255 }, { swxiq, .146 }, H };
N l37n64[] = { { syig, .849 }, { spp, .103 }, { syXp, .140 }, H };
N l37n65[] = { { sXY, .125 }, H };
N l37n66[] = { { sXpi, .102 }, H };
N l37n67[] = { { szm, .108 }, { stXvx, .181 }, H };
N l37n68[] = { { sxXpX, .146 }, H };
N l37n69[] = { { sti, .187 }, H };
N l37n70[] = { { sxmZ, .130 }, H };
N l37n72[] = { { sgws, .215 }, H };
N l37n73[] = { { sg79g, .427 }, { smv, .128 }, { sghs, .181 }, H };
N l37n74[] = { { smZ, .288 }, H };
N l37n75[] = { { srm, .119 }, { sXpg, .266 }, { syg, .121 }, H };
N l37n76[] = { { sws, .219 }, H };
N l37n77[] = { { sXvx, .140 }, H };
N l37n79[] = { { sgir, .863 }, { sYX, .086 }, H };
N l37n80[] = { { sgt, 1.223 }, H };
N l37n81[] = { { sXv, .833 }, { sgX, 1.000 }, H };
N l37n82[] = { { sXZ, .384 }, { smrwx, .153 }, H };
N l37n83[] = { { sjm, .116 }, { sgrsg, .223 }, { sXqi, .104 }, H };
N l37n85[] = { { sty, .099 }, H };
N l37n86[] = { { smwx, .230 }, H };
N l37n87[] = { { sgty, .195 }, H };
N l37n88[] = { { sriwg, .351 }, { sZsqs, .186 }, H };
N l37n89[] = { { sgxs, .175 }, { sXrh, .115 }, H };
N l37n90[] = { { smw, .291 }, H };
N l37n91[] = { { sig, 2.713 }, { smh, .187 }, H };
N l37n92[] = { { sZs, .682 }, H };
N l37n93[] = { { srxi, .474 }, { swt, .111 }, H };
N l37n94[] = { { swX, .148 }, H };
N l37n95[] = { { sgyr, .504 }, { sgwmw, .219 }, H };
N l37n96[] = { { sghmw, .362 }, { svv, .101 }, H };
N l37n97[] = { { sgu, .540 }, { sYpi, .111 }, { shsv, .109 }, H };
N l37n98[] = { { sXw, .493 }, { sgY, .170 }, H };
N l37n99[] = { { sXh, .341 }, { ssvg, .382 }, { sxXv, .117 }, H };
N l37n100[] = { { spsw, .200 }, H };
N l37n103[] = { { sip, .452 }, { sZmf3, .298 }, H };
N l37n104[] = { { sguy, .809 }, { srZm, .102 }, H };
N l37n107[] = { { sxs, .338 }, { smx, .133 }, { sgtsv, .253 }, H };
N l37n108[] = { { smi, .228 }, { shsw, .168 }, H };
N l37n109[] = { { sXrg, .187 }, H };
N l37n110[] = { { sZX, .279 }, H };
N l37n111[] = { { ssriw, .221 }, H };
N l37n112[] = { { sxiq, .132 }, H };
N l37n113[] = { { svw, .074 }, H };
N l37n114[] = { { srg, 1.579 }, { sgv, .292 }, H };
N l37n115[] = { { sgZ, 1.185 }, { sps, .307 }, { sXx, .127 }, { ssqs, .140 }, H };
N l37n116[] = { { sswg, 1.404 }, { suy, .480 }, { smry78, .340 }, { sviw, .162 }, { sgqi, .198 }, H };
N l37n117[] = { { smZX, .149 }, { ship, .121 }, H };
N l37n118[] = { { sZsrg, .336 }, { spXw, .155 }, { smsg, .209 }, H };
N l37n120[] = { { siq, .291 }, H };
N l37n121[] = { { syr, .316 }, { stvi, .106 }, H };
N l37n122[] = { { sgZy, .156 }, H };
N l37n123[] = { { shs, .482 }, { sgtX, .583 }, { sxir, .126 }, H };
N l37n124[] = { { sXvX, .264 }, H };
N l37n125[] = { { sxX, .484 }, H };
N l37n127[] = { { sgZsq, .494 }, H };
N l37n128[] = { { swZ, .073 }, H };
N l37n130[] = { { sgZsr, .823 }, { svx, .160 }, { sgyrX, .279 }, H };
N l37n131[] = { { sgw, 1.130 }, { svi, .587 }, { sy78g, .334 }, { sqsw, .158 }, { sgtvs, .294 }, H };
N l37n132[] = { { sgh, 1.666 }, H };
N l37n133[] = { { spX, .618 }, { sirx, .543 }, { smwxi, .164 }, H };
N l37n134[] = { { sgiw, .821 }, { smhX, .149 }, H };
N l37n135[] = { { swxv, .121 }, H };
N l37n136[] = { { swiv, .153 }, { sXvxm, .156 }, { sXhsg, .215 }, { smXg, .150 }, H };
N l37n137[] = { { sir, 1.038 }, { stm, .070 }, H };
N l37n138[] = { { sgwy, .252 }, H };
N l37n140[] = { { svms, .138 }, H };
N l37n141[] = { { shX, .275 }, { svsg, .308 }, { smz, .089 }, H };
N l37n142[] = { { smk, .092 }, { sXhX, .102 }, H };
N l37n143[] = { { sgpm, .439 }, H };
N l37n144[] = { { sgpXw, .257 }, H };
N l37n145[] = { { ssg, 2.053 }, H };
N l37n146[] = { { sqs, .292 }, { sivs, .138 }, { sgXZ, .167 }, H };
N l37n147[] = { { sgmr, .645 }, { sxiqX, .156 }, H };
N l37n148[] = { { sgx, .562 }, { smf3r, .338 }, H };
N l37n149[] = { { sgi, 1.809 }, H };
N l37n150[] = { { sgyw, .258 }, H };
N l37n151[] = { { sguyi, 1.030 }, { sgpXg, .751 }, H };
N l37n153[] = { { sgipg, .789 }, H };
N l37n156[] = { { syX, .181 }, H };
N l37n157[] = { { ssp, .080 }, H };
N l37n158[] = { { sxv, .263 }, { sgZX, .266 }, H };
N l37n159[] = { { svXg, .467 }, { sry78g, .445 }, H };
N l37n161[] = { { swx, .447 }, H };
N l37n162[] = { { swi, .326 }, { sqir, .313 }, H };
N l37n163[] = { { sqt, .119 }, { siqX, .132 }, H };
N l37n164[] = { { sqX, .308 }, { syrX, .170 }, H };
N l37n165[] = { { sgy, .579 }, H };
N l37n166[] = { { sgj, .270 }, { sXrhs, .148 }, H };
N l37n167[] = { { sgti, .232 }, { sxiv, .149 }, H };
N l37n168[] = { { s78g, .266 }, { sXvi, .155 }, H };
N l37n172[] = { { swsg, .173 }, { siX, .074 }, H };
N l37n174[] = { { ssq, .226 }, { sXZmf3, .254 }, { siwt, .113 }, H };
N l37n175[] = { { sgirg, .913 }, H };
N l37n176[] = { { stg, .136 }, H };
N l37n177[] = { { srs, .234 }, { sZmf3r, .397 }, { sXvg, .439 }, { sgXg, .419 }, { sZx, .161 }, H };
N l37n178[] = { { swy, .171 }, { sZi, .156 }, { ssvq, .108 }, { smhXh, .138 }, H };
N l37n180[] = { { sirxi, .370 }, H };
N l37n181[] = { { sqY, .067 }, H };
N l37n182[] = { { sgz, .253 }, H };
N l37n183[] = { { sgk, .162 }, H };
N l37n185[] = { { sjs, .089 }, H };
N l37n186[] = { { spiw, .134 }, H };
N l37n187[] = { { sf3r, .563 }, { sZms, .266 }, { srhs, .179 }, { szX, .097 }, H };
N l37n188[] = { { sZsg, .204 }, { stp, .084 }, H };
N l37n189[] = { { srxig, .551 }, { syv, .089 }, H };
N l37n190[] = { { syZ, .091 }, H };
N l37n191[] = { { ssr, .596 }, { sgyrg, .309 }, { svR, .078 }, { sgxX, .158 }, H };
N l37n192[] = { { s_Xv, .102 }, H };
N l37n193[] = { { sxi, .696 }, H };
N l37n194[] = { { sXwg, .824 }, { sZy, .145 }, { shiw, .140 }, H };
N l37n195[] = { { srX, .267 }, H };
N l37n196[] = { { spswg, .400 }, { sviZ, .153 }, H };
N l37n198[] = { { spXZ, .126 }, H };
N l37n199[] = { { sipg, .784 }, { svm, .273 }, { s79g, .360 }, { spmr, .272 }, H };
N l37n200[] = { { sgl, .247 }, H };
N l37n201[] = { { spi, .287 }, { sgvi, .359 }, { sxvX, .189 }, H };
N l37n202[] = { { siZx, .136 }, H };
N l37n203[] = { { suyi, .606 }, { sxsg, .331 }, { srxs, .168 }, H };
N l37n204[] = { { swxX, .249 }, { shswg, .313 }, H };
N l37n205[] = { { siv, .694 }, { smZm, .140 }, H };
N l37n206[] = { { siZ, .298 }, { syw, .179 }, H };
N l37n208[] = { { smsr, .291 }, H };
N l37n209[] = { { shi, 1.036 }, { sgtXv, .687 }, { sgps, .444 }, { sxy, .093 }, H };
N l37n211[] = { { spsg, .308 }, { ssqsg, .272 }, H };
N l37n212[] = { { sXvm, .121 }, H };
N l37n213[] = { { sXZm, .325 }, { stsv, .166 }, { shipg, .223 }, H };
N l37n214[] = { { spXwg, .309 }, H };
N l37n215[] = { { sYm, .122 }, { swmw, .113 }, H };
N l37n217[] = { { sgm, .498 }, { sgpmr, .483 }, { syrg, .249 }, { shXh, .111 }, H };
N l37n218[] = { { sgwi, .524 }, { smf3, .226 }, { siwx, .241 }, { s_X, .091 }, H };
N l37n219[] = { { sghi, 1.794 }, { shsg, .495 }, H };
N l37n220[] = { { sXvXg, .423 }, H };
N l37n221[] = { { sxXg, .190 }, H };
N l37n222[] = { { siw, .980 }, H };
N l37n223[] = { { sXg, 2.164 }, { sih, .177 }, H };
N l37n224[] = { { syi, .577 }, { siri, .100 }, H };
N l37n225[] = { { sst, .092 }, H };
N l37n226[] = { { sgiwx, .291 }, { sRw, .158 }, H };
N l37n227[] = { { svig, .294 }, { smp, .109 }, { sqswg, .317 }, H };
N l37n229[] = { { spXg, .642 }, { srZ, .161 }, { sZl, .096 }, H };
N l37n230[] = { { swm, .350 }, { sgiwg, .460 }, H };
N l37n231[] = { { stXv, .383 }, { stvs, .168 }, H };
N l37n232[] = { { sqi, .318 }, H };
N l37n233[] = { { sirg, .840 }, { sg79, .364 }, H };
N l37n235[] = { { sXp, .457 }, { sgxi, .246 }, H };
N l37n236[] = { { sgmrw, .253 }, { srxv, .100 }, H };
N l37n237[] = { { shXg, .235 }, H };
N l37n238[] = { { svg, .857 }, H };
N l37n239[] = { { sts, .247 }, { six, .179 }, { sgmrx, .234 }, { s_Xvi, .136 }, H };
N l37n241[] = { { srwx, .119 }, H };
N l37n242[] = { { sqsg, .255 }, { sivsg, .223 }, H };
N l37n243[] = { { sgrs, .266 }, { sglX, .246 }, H };
N l37n244[] = { { smf3rg, .675 }, { smq, .111 }, H };
N l37n245[] = { { srw, .148 }, { sgXp, .207 }, H };
N l37n246[] = { { sZm, .533 }, { srh, .202 }, { smrw, .134 }, H };
N l37n247[] = { { suym, .102 }, H };
N l37n248[] = { { swxi, .192 }, { sriw, .177 }, { sivX, .108 }, H };
N l37n252[] = { { sXq, .180 }, H };
N l37n253[] = { { sgtiv, .279 }, H };
N l37n254[] = { { sqirx, .325 }, H };
N l37n255[] = { { szi, .184 }, { smsri, .221 }, H };

D l37_d = {
	"spanish",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, 0.000, 0.000, 0.000, W, 0.002, W, W, W, 0.000, W, W, W, 0.007,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, 0.000, 0.001, W,
	    0.001, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, W, 0.000, W,
	    W, 0.207, 0.021, 0.097, 0.095, 0.257, 0.018, 0.019, 0.014, 0.135, 0.005, 0.003, 0.100, 0.058, 0.147, 0.166,
	    0.060, 0.019, 0.130, 0.154, 0.103, 0.085, 0.020, 0.009, 0.011, 0.014, 0.005, W, W, W, 0.000, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.000, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.000, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, 0.001, Y, Y, Y, Y, Y, Y, Y, 0.001,
	    Y, V, V, V, V, V, V, V, V, V, V, V, V, 0.000, V, V,
	    V, V, V, V, V, V, V, V, V, V, V, V, V, V, V, V,
	    V, 0.016, V, V, V, V, V, V, V, 0.007, V, V, V, 0.011, V, V,
	    V, 0.004, V, 0.026, V, V, V, V, V, V, 0.007, V, V, V, V, V },
	{ X, l37n1, l37n2, l37n3, l37n4, l37n5, l37n6, l37n7, l37n8, l37n9, l37n10, l37n11, l37n12, l37n13, X, X,
	    l37n16, l37n17, X, X, l37n20, l37n21, l37n22, l37n23, l37n24, X, l37n26, l37n27, X, l37n29, X, l37n31,
	    X, l37n33, l37n34, l37n35, l37n36, l37n37, l37n38, X, l37n40, l37n41, l37n42, l37n43, l37n44, l37n45, l37n46, l37n47,
	    l37n48, l37n49, X, l37n51, l37n52, l37n53, l37n54, l37n55, l37n56, l37n57, l37n58, l37n59, l37n60, l37n61, l37n62, l37n63,
	    l37n64, l37n65, l37n66, l37n67, l37n68, l37n69, l37n70, X, l37n72, l37n73, l37n74, l37n75, l37n76, l37n77, X, l37n79,
	    l37n80, l37n81, l37n82, l37n83, X, l37n85, l37n86, l37n87, l37n88, l37n89, l37n90, l37n91, l37n92, l37n93, l37n94, l37n95,
	    l37n96, l37n97, l37n98, l37n99, l37n100, X, X, l37n103, l37n104, X, X, l37n107, l37n108, l37n109, l37n110, l37n111,
	    l37n112, l37n113, l37n114, l37n115, l37n116, l37n117, l37n118, X, l37n120, l37n121, l37n122, l37n123, l37n124, l37n125, X, l37n127,
	    l37n128, X, l37n130, l37n131, l37n132, l37n133, l37n134, l37n135, l37n136, l37n137, l37n138, X, l37n140, l37n141, l37n142, l37n143,
	    l37n144, l37n145, l37n146, l37n147, l37n148, l37n149, l37n150, l37n151, X, l37n153, X, X, l37n156, l37n157, l37n158, l37n159,
	    X, l37n161, l37n162, l37n163, l37n164, l37n165, l37n166, l37n167, l37n168, X, X, X, l37n172, X, l37n174, l37n175,
	    l37n176, l37n177, l37n178, X, l37n180, l37n181, l37n182, l37n183, X, l37n185, l37n186, l37n187, l37n188, l37n189, l37n190, l37n191,
	    l37n192, l37n193, l37n194, l37n195, l37n196, X, l37n198, l37n199, l37n200, l37n201, l37n202, l37n203, l37n204, l37n205, l37n206, X,
	    l37n208, l37n209, X, l37n211, l37n212, l37n213, l37n214, l37n215, X, l37n217, l37n218, l37n219, l37n220, l37n221, l37n222, l37n223,
	    l37n224, l37n225, l37n226, l37n227, X, l37n229, l37n230, l37n231, l37n232, l37n233, X, l37n235, l37n236, l37n237, l37n238, l37n239,
	    X, l37n241, l37n242, l37n243, l37n244, l37n245, l37n246, l37n247, l37n248, X, X, X, l37n252, l37n253, l37n254, l37n255 }
};

//
// Lng: swedish
// Enc: iso-8859-15
//

S sXxxg[] = { 97, t, t, a };
S sjf6[] = { f, 246, 0 };
S sgXxx[] = { 32, 97, t, t, 0 };
S sgjf6[] = { 32, f, 246, 0 };
S sjf6v[] = { f, 246, r, 0 };
S sgjf6v[] = { 32, f, 246, r, 0 };
S sf6vg[] = { 246, r, a };
S shmwo[] = { d, i, s, k, 0 };
S sppiv[] = { l, l, e, r, 0 };
S sgsZ[] = { 32, o, 99, 0 };
S sUvg[] = { 228, r, a };
S sgsZl[] = { 32, o, 99, h, 0 };
S ssZlg[] = { o, 99, h, a };
S sjf6vg[] = { f, 246, r, a };
S sxmx[] = { t, i, t, 0 };
S smxms[] = { i, t, i, o, 0 };
S sxmxm[] = { t, i, t, i, 0 };
S svxmx[] = { r, t, i, t, 0 };
S sgUvg[] = { 32, 228, r, a };
S sgUv[] = { 32, 228, r, 0 };
S sUrh[] = { 228, n, d, 0 };
S slV[] = { h, 229, 0 };
S spivg[] = { l, e, r, a };
S swog[] = { s, k, a };
S sxmpp[] = { t, i, l, l, 0 };
S ssriv[] = { o, n, e, r, 0 };
S sxXpp[] = { t, 97, l, l, 0 };
S sw79w[] = { s, y, s, 0 };
S sw79wx[] = { s, y, s, t, 0 };
S s79wxi[] = { y, s, t, e, 0 };
S smwog[] = { i, s, k, a };
S sgwoX[] = { 32, s, k, 97, 0 };
S sg2f[] = { 32, 47, 0 };
S swxXv[] = { s, t, 97, r, 0 };
S szUr[] = { v, 228, n, 0 };
S sxXvx[] = { t, 97, r, t, 0 };
S sglV[] = { 32, h, 229, 0 };
S szUrh[] = { v, 228, n, d, 0 };
S sglVv[] = { 32, h, 229, r, 0 };
S slVv[] = { h, 229, r, 0 };
S sVvh[] = { 229, r, d, 0 };
S slVvh[] = { h, 229, r, d, 0 };
S sXrzU[] = { 97, n, v, 228, 0 };
S srzUr[] = { n, v, 228, n, 0 };
S srzU[] = { n, v, 228, 0 };
S sXrz[] = { 97, n, v, 0 };
S sgXrz[] = { 32, 97, n, v, 0 };
S smwoi[] = { i, s, k, e, 0 };
S sgw79w[] = { 32, s, y, s, 0 };
S sxiqg[] = { t, e, m, a };
S sVr[] = { 229, n, 0 };
S ssqq[] = { o, m, m, 0 };
S sgipp[] = { 32, e, l, l, 0 };
S svrX[] = { r, n, 97, 0 };
S sivmr[] = { e, r, i, n, 0 };
S sosqq[] = { k, o, m, m, 0 };
S sgosq[] = { 32, k, o, m, 0 };
S shhm[] = { d, d, i, 0 };
S svhh[] = { r, d, d, 0 };
S shhmw[] = { d, d, i, s, 0 };
S soixx[] = { k, e, t, t, 0 };
S sVvhh[] = { 229, r, d, d, 0 };
S swoix[] = { s, k, e, t, 0 };
S svhhm[] = { r, d, d, i, 0 };
S svV[] = { r, 229, 0 };

N l38n1[] = { { stX, .321 }, { sxmx, .289 }, { smrx, .146 }, H };
N l38n2[] = { { soixx, .166 }, H };
N l38n3[] = { { ssv, .206 }, { sosq, .143 }, { svV, .082 }, H };
N l38n4[] = { { ssZ, .277 }, { sgU, .330 }, H };
N l38n5[] = { { smr, 1.061 }, { sxm, .738 }, { svxm, .281 }, H };
N l38n6[] = { { shmw, .402 }, { srx, .212 }, H };
N l38n7[] = { { sghm, .714 }, { sri, .269 }, { sxivg, .263 }, { sgosq, .256 }, H };
N l38n8[] = { { swo, .535 }, H };
N l38n9[] = { { slX, .117 }, { sVr, .224 }, H };
N l38n11[] = { { sgXr, .456 }, { sipp, .207 }, { skv, .094 }, H };
N l38n12[] = { { sgp, .642 }, { smry, .356 }, H };
N l38n13[] = { { swg, .864 }, { sXr, .568 }, { spm, .440 }, H };
N l38n14[] = { { ssqg, .778 }, H };
N l38n15[] = { { spivg, .407 }, { sgw79w, .312 }, H };
N l38n16[] = { { swxXp, .260 }, H };
N l38n18[] = { { sik, .080 }, H };
N l38n20[] = { { sxmsr, .598 }, { ssw, .149 }, { srwxX, .260 }, H };
N l38n21[] = { { shm, .500 }, { sog, .287 }, H };
N l38n22[] = { { sms, .335 }, { ssri, .254 }, H };
N l38n23[] = { { sry, .271 }, { sgxm, .357 }, { sxxi, .126 }, H };
N l38n24[] = { { sZo, .106 }, H };
N l38n28[] = { { sgwo, .399 }, { svr, .111 }, H };
N l38n29[] = { { sgq, .783 }, H };
N l38n31[] = { { ssrg, .337 }, { sXrz, .171 }, H };
N l38n32[] = { { sxxg, 1.079 }, { soXr, .177 }, H };
N l38n33[] = { { sxig, .377 }, { sxXp, .251 }, { srhX, .131 }, H };
N l38n34[] = { { swV, .177 }, { swxXv, .243 }, { stv, .118 }, { smwoi, .219 }, H };
N l38n35[] = { { sy78, .235 }, { srXg, .342 }, H };
N l38n37[] = { { stVg, .394 }, { ssx, .132 }, { sghir, .332 }, H };
N l38n38[] = { { spmry, .475 }, { sgoX, .315 }, H };
N l38n39[] = { { sgtV, .392 }, H };
N l38n40[] = { { szUr, .179 }, { srz, .117 }, H };
N l38n41[] = { { srk, .279 }, { sgjm, .234 }, H };
N l38n44[] = { { sxg, 2.021 }, { sqm, .085 }, H };
N l38n45[] = { { sivg, 1.423 }, { svs, .197 }, { shixg, .542 }, H };
N l38n46[] = { { sUv, .655 }, { ski, .187 }, { sgr, .266 }, { sqivg, .250 }, H };
N l38n47[] = { { sXt, .123 }, { shmrg, .230 }, H };
N l38n48[] = { { smsrg, .374 }, { smrxi, .184 }, H };
N l38n49[] = { { shig, .399 }, H };
N l38n51[] = { { swoX, .259 }, H };
N l38n52[] = { { spg, .323 }, { sqih, .130 }, H };
N l38n54[] = { { sUrh, .491 }, { sgtv, .236 }, H };
N l38n55[] = { { sghix, .713 }, { sgvs, .175 }, H };
N l38n56[] = { { sgjf6, .653 }, H };
N l38n57[] = { { sgzm, .360 }, { sgip, .209 }, { sgmg, .207 }, H };
N l38n58[] = { { sippi, .206 }, H };
N l38n59[] = { { smxms, .381 }, H };
N l38n60[] = { { shg, .361 }, { sxmxm, .374 }, H };
N l38n62[] = { { srzUr, .228 }, H };
N l38n63[] = { { svX, .664 }, { sgs, .826 }, { sry78, .350 }, { swxiq, .260 }, { sgwoX, .384 }, { sihg, .209 }, H };
N l38n64[] = { { spp, .616 }, H };
N l38n65[] = { { shyg, .756 }, H };
N l38n67[] = { { stXvx, .372 }, { szm, .177 }, { sw79wx, .260 }, { shhm, .125 }, H };
N l38n69[] = { { sZlg, .502 }, { sti, .100 }, H };
N l38n70[] = { { s79wx, .195 }, H };
N l38n71[] = { { shmwo, .490 }, { svrX, .138 }, H };
N l38n72[] = { { sgws, .308 }, H };
N l38n73[] = { { sghs, .244 }, H };
N l38n74[] = { { sgUvg, .479 }, { s79w, .137 }, { sosqq, .171 }, { skXg, .190 }, H };
N l38n75[] = { { syg, .563 }, { srm, .125 }, { sixxg, .325 }, H };
N l38n76[] = { { sws, .153 }, H };
N l38n77[] = { { sXvx, .468 }, { sgXx, .680 }, { sVv, .315 }, { srhi, .209 }, { srivg, .338 }, { sli, .092 }, H };
N l38n78[] = { { sgsqg, .512 }, H };
N l38n79[] = { { sixg, .815 }, { sgir, .640 }, H };
N l38n80[] = { { sgt, .829 }, { sivm, .144 }, H };
N l38n81[] = { { sXv, .847 }, { sgX, 1.090 }, { sghmr, .282 }, H };
N l38n82[] = { { smrwx, .293 }, H };
N l38n83[] = { { sqg, .845 }, { sjm, .172 }, { smwog, .387 }, H };
N l38n84[] = { { sos, .174 }, { szUrh, .232 }, H };
N l38n85[] = { { srwg, .177 }, H };
N l38n88[] = { { sivXg, .407 }, { ss_, .083 }, H };
N l38n89[] = { { sXrh, .192 }, H };
N l38n90[] = { { smw, .381 }, { sgwV, .347 }, H };
N l38n91[] = { { sig, .972 }, { sgxmp, .397 }, { swsqg, .397 }, H };
N l38n92[] = { { sf6v, .901 }, H };
N l38n93[] = { { srxi, .177 }, { ssqq, .143 }, H };
N l38n94[] = { { swX, .109 }, H };
N l38n95[] = { { swoi, .189 }, H };
N l38n96[] = { { sghmw, .374 }, H };
N l38n97[] = { { svxmx, .374 }, H };
N l38n98[] = { { sgY, .389 }, { sXw, .121 }, H };
N l38n99[] = { { sxXv, .225 }, { sXh, .120 }, { sgXz, .249 }, H };
N l38n101[] = { { sxXpp, .260 }, { smrg, .261 }, H };
N l38n102[] = { { soX, .377 }, H };
N l38n103[] = { { sip, .236 }, H };
N l38n104[] = { { swog, .303 }, H };
N l38n106[] = { { szg, .246 }, H };
N l38n107[] = { { smx, .317 }, { sxs, .144 }, H };
N l38n108[] = { { ssriv, .263 }, { shsw, .131 }, H };
N l38n109[] = { { sXrg, .419 }, { sgXrz, .328 }, H };
N l38n110[] = { { szU, .158 }, H };
N l38n111[] = { { sXxx, .471 }, H };
N l38n112[] = { { sqq, .150 }, { sxiq, .197 }, { sgoXr, .348 }, H };
N l38n113[] = { { svw, .125 }, H };
N l38n114[] = { { srg, 1.839 }, { smrk, .274 }, { sgv, .254 }, { svh, .136 }, H };
N l38n115[] = { { sXx, .531 }, { sps, .115 }, { sgZ, .169 }, H };
N l38n116[] = { { smry78, .466 }, { sgqi, .433 }, { sswg, .224 }, H };
N l38n117[] = { { s79wxi, .260 }, H };
N l38n120[] = { { siq, .197 }, H };
N l38n121[] = { { syr, .164 }, H };
N l38n122[] = { { spmk, .133 }, H };
N l38n123[] = { { sgtX, .478 }, { shs, .151 }, H };
N l38n124[] = { { ssZl, .332 }, { sXvX, .161 }, H };
N l38n125[] = { { sxX, .646 }, { sgzmp, .279 }, { sgipp, .279 }, H };
N l38n127[] = { { sgwx, .507 }, H };
N l38n128[] = { { sgsZ, .534 }, { soXrg, .299 }, H };
N l38n129[] = { { svmr, .156 }, H };
N l38n130[] = { { svx, .382 }, { swVg, .369 }, H };
N l38n131[] = { { sgw, 1.737 }, { svi, .255 }, { sy78g, .495 }, H };
N l38n132[] = { { sgh, 1.983 }, H };
N l38n133[] = { { spX, .183 }, { ssxg, .251 }, H };
N l38n135[] = { { sgtVg, .522 }, { smpp, .251 }, H };
N l38n136[] = { { sXvxm, .374 }, H };
N l38n137[] = { { sir, .885 }, { srkg, .185 }, H };
N l38n139[] = { { sghy, .773 }, { shir, .205 }, H };
N l38n140[] = { { sgjv, .192 }, H };
N l38n141[] = { { shX, .224 }, { smz, .103 }, H };
N l38n142[] = { { sgjf6v, .837 }, { smk, .240 }, { sUvg, 1.186 }, H };
N l38n143[] = { { sgpm, .623 }, { sXpp, .294 }, { sgwsq, .391 }, H };
N l38n144[] = { { sww, .088 }, H };
N l38n145[] = { { ssg, .143 }, { sgix, .187 }, H };
N l38n147[] = { { sgmr, .746 }, { sYi, .105 }, H };
N l38n148[] = { { sgx, .509 }, { sqihg, .246 }, H };
N l38n149[] = { { sgi, .905 }, { sXz, .128 }, H };
N l38n150[] = { { sjf6v, .435 }, H };
N l38n151[] = { { sppi, .433 }, H };
N l38n153[] = { { skg, .378 }, { sVvh, .388 }, H };
N l38n154[] = { { sivmr, .182 }, H };
N l38n156[] = { { shhmw, .166 }, H };
N l38n158[] = { { sxv, .129 }, H };
N l38n159[] = { { svXg, .810 }, { sry78g, .657 }, { sglV, .266 }, H };
N l38n160[] = { { srr, .159 }, { sppg, .323 }, { sgqih, .259 }, H };
N l38n161[] = { { swx, .753 }, { szXv, .154 }, H };
N l38n162[] = { { swi, .135 }, { sgwxX, .397 }, { sqir, .130 }, H };
N l38n164[] = { { sqX, .160 }, H };
N l38n165[] = { { sgy, .282 }, H };
N l38n166[] = { { sgj, 1.054 }, { soix, .199 }, H };
N l38n167[] = { { sxiv, .243 }, H };
N l38n168[] = { { s78g, .414 }, { sXvi, .117 }, H };
N l38n169[] = { { sgXxx, .896 }, { sxmp, .204 }, { sox, .084 }, H };
N l38n170[] = { { soi, .252 }, H };
N l38n174[] = { { ssq, .503 }, { shv, .103 }, H };
N l38n175[] = { { spiv, .433 }, { sgirg, .690 }, H };
N l38n176[] = { { sjf6, .301 }, { stg, .227 }, H };
N l38n177[] = { { sXvg, .566 }, H };
N l38n179[] = { { slVv, .172 }, H };
N l38n182[] = { { sgz, .468 }, { sgw79, .246 }, { svmrk, .197 }, H };
N l38n183[] = { { sgk, .233 }, { shiv, .151 }, H };
N l38n184[] = { { slg, .341 }, { sgsZl, .663 }, H };
N l38n186[] = { { sgwVg, .424 }, H };
N l38n187[] = { { szX, .175 }, { swoix, .166 }, H };
N l38n188[] = { { sf6vg, 1.274 }, H };
N l38n189[] = { { srxig, .250 }, H };
N l38n190[] = { { sXppi, .241 }, { svhh, .125 }, H };
N l38n191[] = { { ssr, .425 }, { sxXvx, .236 }, { smrr, .149 }, H };
N l38n192[] = { { sxx, .681 }, { sgos, .328 }, { shh, .116 }, H };
N l38n193[] = { { sxi, .614 }, H };
N l38n195[] = { { srX, .276 }, { sgXzg, .289 }, H };
N l38n197[] = { { stV, .175 }, { sVvhh, .374 }, H };
N l38n198[] = { { soXg, .231 }, H };
N l38n199[] = { { spmr, .391 }, { svm, .220 }, { sqqi, .154 }, H };
N l38n200[] = { { sgl, .678 }, { sUp, .217 }, H };
N l38n201[] = { { spi, .426 }, H };
N l38n202[] = { { sxms, .450 }, H };
N l38n203[] = { { sXrzU, .228 }, H };
N l38n204[] = { { swxX, .501 }, { shswg, .240 }, H };
N l38n205[] = { { siv, 1.197 }, { shix, .363 }, { slV, .142 }, H };
N l38n206[] = { { sqiv, .131 }, H };
N l38n207[] = { { sXxxg, .910 }, { shmr, .141 }, H };
N l38n208[] = { { smsr, .483 }, { sxiqg, .309 }, H };
N l38n209[] = { { shi, .801 }, { sgtXv, .594 }, H };
N l38n215[] = { { smg, .268 }, H };
N l38n216[] = { { siqg, .337 }, H };
N l38n217[] = { { sgm, .755 }, { sgpmr, .670 }, H };
N l38n218[] = { { sgwi, .182 }, H };
N l38n219[] = { { sghi, 1.108 }, { sVg, 1.319 }, H };
N l38n220[] = { { ssZlg, .663 }, { srhv, .121 }, H };
N l38n221[] = { { sxXg, .478 }, H };
N l38n222[] = { { siw, .149 }, H };
N l38n223[] = { { sXg, 2.041 }, { sih, .179 }, { slVvh, .230 }, { syx, .113 }, H };
N l38n225[] = { { shy, .373 }, H };
N l38n226[] = { { svxg, .219 }, H };
N l38n227[] = { { smp, .335 }, { svig, .224 }, H };
N l38n229[] = { { sZl, .225 }, { sziv, .176 }, H };
N l38n230[] = { { swm, .148 }, H };
N l38n231[] = { { stXv, .341 }, { sw79w, .195 }, { smppg, .335 }, { szmp, .140 }, { stvs, .120 }, H };
N l38n232[] = { { sqi, .403 }, { skir, .140 }, H };
N l38n233[] = { { sirg, 1.507 }, H };
N l38n234[] = { { sUr, .510 }, { sgUv, .360 }, { skX, .153 }, H };
N l38n235[] = { { sghyg, 1.008 }, { sXp, .288 }, { sixx, .322 }, { shirg, .345 }, H };
N l38n236[] = { { sgmrw, .414 }, { sjv, .097 }, H };
N l38n237[] = { { sppiv, .488 }, { sriv, .231 }, { sxmpp, .267 }, { shXg, .288 }, { sgixx, .240 }, H };
N l38n238[] = { { svg, 2.233 }, { smxm, .292 }, { sgsq, .396 }, { smkg, .192 }, H };
N l38n239[] = { { six, .682 }, { sgmrx, .279 }, H };
N l38n241[] = { { srwx, .227 }, H };
N l38n243[] = { { smwo, .430 }, { sglX, .236 }, H };
N l38n244[] = { { srzU, .171 }, H };
N l38n245[] = { { srw, .306 }, { sglVv, .345 }, { sXzg, .241 }, H };
N l38n246[] = { { srh, .425 }, { sjf6vg, .640 }, { smrw, .223 }, { sw79, .136 }, { sXxm, .177 }, H };
N l38n247[] = { { sls, .089 }, H };
N l38n248[] = { { sivX, .389 }, { swxi, .322 }, H };
N l38n249[] = { { svhhm, .166 }, H };
N l38n251[] = { { sgo, .639 }, { swsq, .199 }, H };
N l38n252[] = { { sXq, .109 }, H };
N l38n255[] = { { szi, .173 }, { smsri, .333 }, { sg2f, .182 }, H };

D l38_d = {
	"swedish",
	"iso-8859-15",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, 0.001, 0.000, 0.000, W, 0.001, W, W, W, 0.001, W, W, W, 0.013,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, 0.001, 0.001, W,
	    0.000, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.000, W, W, W,
	    0.001, 0.176, 0.018, 0.025, 0.108, 0.184, 0.037, 0.043, 0.037, 0.132, 0.007, 0.057, 0.101, 0.069, 0.160, 0.091,
	    0.044, 0.001, 0.162, 0.128, 0.187, 0.050, 0.039, 0.007, 0.013, 0.013, 0.000, W, W, W, 0.000, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, 0.000, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, 0.002, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, V, V, V, 0.001, 0.000, V, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, V, V, 0.000, V, V, V, V, V, V, V, V, V,
	    V, V, V, V, 0.071, 0.074, V, V, V, 0.000, V, V, V, V, V, V,
	    V, V, V, V, V, V, 0.049, V, V, V, V, V, V, V, V, V },
	{ X, l38n1, l38n2, l38n3, l38n4, l38n5, l38n6, l38n7, l38n8, l38n9, X, l38n11, l38n12, l38n13, l38n14, l38n15,
	    l38n16, X, l38n18, X, l38n20, l38n21, l38n22, l38n23, l38n24, X, X, X, l38n28, l38n29, X, l38n31,
	    l38n32, l38n33, l38n34, l38n35, X, l38n37, l38n38, l38n39, l38n40, l38n41, X, X, l38n44, l38n45, l38n46, l38n47,
	    l38n48, l38n49, X, l38n51, l38n52, X, l38n54, l38n55, l38n56, l38n57, l38n58, l38n59, l38n60, X, l38n62, l38n63,
	    l38n64, l38n65, X, l38n67, X, l38n69, l38n70, l38n71, l38n72, l38n73, l38n74, l38n75, l38n76, l38n77, l38n78, l38n79,
	    l38n80, l38n81, l38n82, l38n83, l38n84, l38n85, X, X, l38n88, l38n89, l38n90, l38n91, l38n92, l38n93, l38n94, l38n95,
	    l38n96, l38n97, l38n98, l38n99, X, l38n101, l38n102, l38n103, l38n104, X, l38n106, l38n107, l38n108, l38n109, l38n110, l38n111,
	    l38n112, l38n113, l38n114, l38n115, l38n116, l38n117, X, X, l38n120, l38n121, l38n122, l38n123, l38n124, l38n125, X, l38n127,
	    l38n128, l38n129, l38n130, l38n131, l38n132, l38n133, X, l38n135, l38n136, l38n137, X, l38n139, l38n140, l38n141, l38n142, l38n143,
	    l38n144, l38n145, X, l38n147, l38n148, l38n149, l38n150, l38n151, X, l38n153, l38n154, X, l38n156, X, l38n158, l38n159,
	    l38n160, l38n161, l38n162, X, l38n164, l38n165, l38n166, l38n167, l38n168, l38n169, l38n170, X, X, X, l38n174, l38n175,
	    l38n176, l38n177, X, l38n179, X, X, l38n182, l38n183, l38n184, X, l38n186, l38n187, l38n188, l38n189, l38n190, l38n191,
	    l38n192, l38n193, X, l38n195, X, l38n197, l38n198, l38n199, l38n200, l38n201, l38n202, l38n203, l38n204, l38n205, l38n206, l38n207,
	    l38n208, l38n209, X, X, X, X, X, l38n215, l38n216, l38n217, l38n218, l38n219, l38n220, l38n221, l38n222, l38n223,
	    X, l38n225, l38n226, l38n227, X, l38n229, l38n230, l38n231, l38n232, l38n233, l38n234, l38n235, l38n236, l38n237, l38n238, l38n239,
	    X, l38n241, X, l38n243, l38n244, l38n245, l38n246, l38n247, l38n248, l38n249, X, l38n251, l38n252, X, X, l38n255 }
};

//
// Lng: ukrainian
// Enc: koi8-r
//

S sHa6[] = { 215, 166, 0 };
S sa6c4[] = { 166, 196, 0 };
S sa6cc[] = { 166, 204, 0 };
S scea6[] = { 206, 166, 0 };
S sa6H[] = { 166, 215, 0 };
S sNcf[] = { 221, 207, 0 };
S sa6ce[] = { 166, 206, 0 };
S sFc4[] = { 213, 196, 0 };
S scbc9g[] = { 203, 201, a };
S sc4a6[] = { 196, 166, 0 };
S sEc9g[] = { 212, 201, a };
S scfc0g[] = { 207, 192, a };
S sAa6[] = { 208, 166, 0 };
S sc4cfg[] = { 196, 207, a };
S scfc0[] = { 207, 192, 0 };
S sgNcf[] = { 32, 221, 207, 0 };
S sga6g[] = { 32, 166, a };
S sCa6[] = { 210, 166, 0 };
S scfa7[] = { 207, 167, 0 };
S sc2a6[] = { 194, 166, 0 };
S scca6[] = { 204, 166, 0 };
S sNcfg[] = { 221, 207, a };
S sgc4cfg[] = { 32, 196, 207, a };
S scea6g[] = { 206, 166, a };
S scfHa6[] = { 207, 215, 166, 0 };
S sgHa6[] = { 32, 215, 166, 0 };
S sHa6c4[] = { 215, 166, 196, 0 };
S sc8cf[] = { 200, 207, 0 };
S scdF[] = { 205, 213, 0 };
S sc2F[] = { 194, 213, 0 };
S sgNcfg[] = { 32, 221, 207, a };
S sgc2F[] = { 32, 194, 213, 0 };
S sIcb[] = { 216, 203, 0 };
S sc1a4g[] = { 193, 164, a };
S sceF[] = { 206, 213, 0 };
S sgAa6[] = { 32, 208, 166, 0 };
S sc4F[] = { 196, 213, 0 };
S sEa6[] = { 212, 166, 0 };
S sc1G[] = { 193, 214, 0 };
S scdFg[] = { 205, 213, a };
S sOcf[] = { 222, 207, 0 };
S scfcdF[] = { 207, 205, 213, 0 };
S scfcdFg[] = { 207, 205, 213, a };
S sa6Hg[] = { 166, 215, a };
S sDH[] = { 211, 215, 0 };
S sBcb[] = { 209, 203, 0 };
S sa6E[] = { 166, 212, 0 };
S sgBcb[] = { 32, 209, 203, 0 };
S sgDH[] = { 32, 211, 215, 0 };
S sCE[] = { 210, 212, 0 };
S scba6[] = { 203, 166, 0 };
S sgcbc1[] = { 32, 203, 193, 0 };
S scfa7g[] = { 207, 167, a };
S sAc9[] = { 208, 201, 0 };
S sc1Ec9[] = { 193, 212, 201, 0 };
S sgKg[] = { 32, 218, a };
S sc9EIg[] = { 201, 212, 216, a };
S scbF[] = { 203, 213, 0 };
S sa6D[] = { 166, 211, 0 };
S sAa6c4[] = { 208, 166, 196, 0 };
S sa6ccI[] = { 166, 204, 216, 0 };
S sgHc9[] = { 32, 215, 201, 0 };
S sgOcf[] = { 32, 222, 207, 0 };
S sgAa6c4[] = { 32, 208, 166, 196, 0 };
S sc9EI[] = { 201, 212, 216, 0 };
S scfCa6[] = { 207, 210, 166, 0 };
S scbc1G[] = { 203, 193, 214, 0 };
S sDI[] = { 211, 216, 0 };
S sccc5g[] = { 204, 197, a };
S sfaR[] = { 250, 225, 0 };
S sc1ccc9[] = { 193, 204, 201, 0 };
S scfc4a6[] = { 207, 196, 166, 0 };
S sceBg[] = { 206, 209, a };
S sc1Gc5[] = { 193, 214, 197, 0 };
S sa6c4A[] = { 166, 196, 208, 0 };
S sc1Gc5g[] = { 193, 214, 197, a };
S sc2c1[] = { 194, 193, 0 };
S sgc2a6[] = { 32, 194, 166, 0 };
S sgCcf[] = { 32, 210, 207, 0 };
S scdc9g[] = { 205, 201, a };
S sAcfH[] = { 208, 207, 215, 0 };
S sgDEcf[] = { 32, 211, 212, 207, 0 };
S sa6cb[] = { 166, 203, 0 };
S sc1ccc5[] = { 193, 204, 197, 0 };
S scfc4c9[] = { 207, 196, 201, 0 };
S sgHa6c4[] = { 32, 215, 166, 196, 0 };
S sa6c4c1[] = { 166, 196, 193, 0 };
S scccfHa6[] = { 204, 207, 215, 166, 0 };
S sc9Ec9[] = { 201, 212, 201, 0 };
S sa6B[] = { 166, 209, 0 };
S sgHc5[] = { 32, 215, 197, 0 };
S sgOcfcc[] = { 32, 222, 207, 204, 0 };
S sc8cfc4[] = { 200, 207, 196, 0 };
S sDa6[] = { 211, 166, 0 };
S sa4E[] = { 164, 212, 0 };
S sc4a6g[] = { 196, 166, a };
S scfHc9[] = { 207, 215, 201, 0 };
S sc1Ec9g[] = { 193, 212, 201, a };
S sCce[] = { 210, 206, 0 };
S sc9ceg[] = { 201, 206, a };
S sOcfcc[] = { 222, 207, 204, 0 };
S sgc2Fc4[] = { 32, 194, 213, 196, 0 };
S sAcfHa6[] = { 208, 207, 215, 166, 0 };
S sa6C[] = { 166, 210, 0 };
S sHa6cb[] = { 215, 166, 203, 0 };
S sKcec1[] = { 218, 206, 193, 0 };
S sa6cecb[] = { 166, 206, 203, 0 };
S scfcccfH[] = { 207, 204, 207, 215, 0 };
S sgcdc1[] = { 32, 205, 193, 0 };
S sc2Fc4[] = { 194, 213, 196, 0 };
S sgcbc1G[] = { 32, 203, 193, 214, 0 };
S sID[] = { 216, 211, 0 };
S sceceB[] = { 206, 206, 209, 0 };
S sa6ccIcb[] = { 166, 204, 216, 203, 0 };
S sHc9g[] = { 215, 201, a };
S scfHa6cb[] = { 207, 215, 166, 203, 0 };
S scfHa6c4[] = { 207, 215, 166, 196, 0 };
S sgAc9[] = { 32, 208, 201, 0 };
S sOcfcccf[] = { 222, 207, 204, 207, 0 };
S sIcbc9[] = { 216, 203, 201, 0 };
S sDc9[] = { 211, 201, 0 };
S sccIcb[] = { 204, 216, 203, 0 };
S sgEa6[] = { 32, 212, 166, 0 };
S sc4H[] = { 196, 215, 0 };
S sIcbc9g[] = { 216, 203, 201, a };
S scbFg[] = { 203, 213, a };
S sHcfa7[] = { 215, 207, 167, 0 };
S sHa6c4c1[] = { 215, 166, 196, 193, 0 };
S sc4c1a4[] = { 196, 193, 164, 0 };
S sgc2a6cc[] = { 32, 194, 166, 204, 0 };
S seff3[] = { 239, 243, 0 };
S sceFg[] = { 206, 213, a };
S sgDF[] = { 32, 211, 213, 0 };
S sDcfc2[] = { 211, 207, 194, 0 };
S sFc4c5[] = { 213, 196, 197, 0 };
S sc4AcfH[] = { 196, 208, 207, 215, 0 };
S sc9cdg[] = { 201, 205, a };
S sEIDB[] = { 212, 216, 211, 209, 0 };
S sc2a6cc[] = { 194, 166, 204, 0 };
S sEa6g[] = { 212, 166, a };
S sDHa6[] = { 211, 215, 166, 0 };
S sc4Fg[] = { 196, 213, a };
S sFcc[] = { 213, 204, 0 };
S scccfD[] = { 204, 207, 211, 0 };
S sHc9ce[] = { 215, 201, 206, 0 };
S sLc1[] = { 219, 193, 0 };
S sgDcfc2[] = { 32, 211, 207, 194, 0 };
S sEID[] = { 212, 216, 211, 0 };
S sc4cea6[] = { 196, 206, 166, 0 };
S sAc9E[] = { 208, 201, 212, 0 };
S scfHcf[] = { 207, 215, 207, 0 };
S sIDB[] = { 216, 211, 209, 0 };
S sDEcfC[] = { 211, 212, 207, 210, 0 };
S sBce[] = { 209, 206, 0 };
S sgc7cf[] = { 32, 199, 207, 0 };
S sc9ceF[] = { 201, 206, 213, 0 };
S sc5cece[] = { 197, 206, 206, 0 };
S sc5cea6g[] = { 197, 206, 166, a };
S sc5ceceB[] = { 197, 206, 206, 209, 0 };
S scbcfcd[] = { 203, 207, 205, 0 };
S sAcfc4[] = { 208, 207, 196, 0 };
S sHa6E[] = { 215, 166, 212, 0 };
S sIcf[] = { 216, 207, 0 };
S sHc5C[] = { 215, 197, 210, 0 };
S sceceBg[] = { 206, 206, 209, a };
S sc5cea6[] = { 197, 206, 166, 0 };
S sgKc1g[] = { 32, 218, 193, a };
S sCc9g[] = { 210, 201, a };
S sgc4ce[] = { 32, 196, 206, 0 };
S scfc4c1[] = { 207, 196, 193, 0 };
S sEcfCa6[] = { 212, 207, 210, 166, 0 };
S sgcacf[] = { 32, 202, 207, 0 };
S sIDBg[] = { 216, 211, 209, a };
S scacf[] = { 202, 207, 0 };
S sc4cecf[] = { 196, 206, 207, 0 };
S scbc1Gc5[] = { 203, 193, 214, 197, 0 };
S sc4Acf[] = { 196, 208, 207, 0 };
S sc2Fc4c5[] = { 194, 213, 196, 197, 0 };
S sHL[] = { 215, 219, 0 };
S sKc1g[] = { 218, 193, a };

N l39n1[] = { { sAc1, .313 }, H };
N l39n3[] = { { scfC, .940 }, { sgf3, .188 }, { sc3a6g, .423 }, { sc4H, .188 }, H };
N l39n4[] = { { sEI, .815 }, { sgU, .146 }, H };
N l39n5[] = { { sEc9, .815 }, { sc9ce, .752 }, { sgcec5, .407 }, { sgF, .125 }, { sgKc1g, .209 }, H };
N l39n7[] = { { scec5, .533 }, { sACcf, .470 }, { scfcccfH, .376 }, H };
N l39n10[] = { { sGg, .235 }, { sgDF, .157 }, H };
N l39n11[] = { { sc5cea6g, .470 }, H };
N l39n12[] = { { sccI, .313 }, { sHD, .282 }, { sc1Gc5, .329 }, { sa6C, .125 }, H };
N l39n13[] = { { sccc9, .940 }, { sc1ce, .313 }, H };
N l39n14[] = { { scfcdg, .917 }, { sa6c4A, .219 }, { sc9Ec9, .282 }, { sgDcfc2, .209 }, H };
N l39n15[] = { { sHa6, 1.222 }, { sc2Fc4, .282 }, H };
N l39n17[] = { { sgACc9, .251 }, H };
N l39n18[] = { { sceg, .470 }, { sFH, .251 }, { sEa6g, .353 }, H };
N l39n19[] = { { sc9EIg, .752 }, H };
N l39n20[] = { { scfD, .564 }, { sgf4, .188 }, { sKce, .251 }, { seff3, .157 }, H };
N l39n21[] = { { scfc4, .815 }, { sc4c9, .282 }, { sEID, .235 }, H };
N l39n22[] = { { sc1Ec9, .423 }, { sgG, .167 }, { sgEa6, .188 }, H };
N l39n23[] = { { sceF, .376 }, { sgc7, .230 }, H };
N l39n25[] = { { sDcc, .157 }, H };
N l39n26[] = { { scbFg, .423 }, H };
N l39n28[] = { { sCce, .188 }, H };
N l39n29[] = { { sa6D, .167 }, H };
N l39n30[] = { { sa6c4, .564 }, { sHc5, .376 }, { sgAa6c4, .334 }, { sAcfHa6, .376 }, H };
N l39n31[] = { { sc1c0, .157 }, H };
N l39n32[] = { { sgDH, .282 }, { sgcdc9, .157 }, H };
N l39n33[] = { { sc9cag, .705 }, { sEc5g, .353 }, H };
N l39n34[] = { { sAC, .658 }, { sc4a6g, .423 }, { sc5H, .157 }, H };
N l39n35[] = { { scec1g, 1.692 }, { sgACcf, .334 }, { scbcfcd, .235 }, H };
N l39n36[] = { { sHc5C, .235 }, H };
N l39n37[] = { { scfCa6, .329 }, H };
N l39n38[] = { { sIDB, .235 }, H };
N l39n39[] = { { sgH, 1.316 }, { sCc9g, .353 }, H };
N l39n40[] = { { scfa7, .407 }, { sgc8, .230 }, { sgcbc1G, .251 }, H };
N l39n41[] = { { sHg, 1.880 }, { sgc4cfg, .543 }, { sccc5g, .494 }, H };
N l39n43[] = { { sID, .188 }, { sHa6E, .235 }, H };
N l39n44[] = { { scdc9, .251 }, { sAcfH, .329 }, { sc9ceF, .235 }, H };
N l39n45[] = { { sCcf, 1.034 }, { scfc7cf, .658 }, H };
N l39n46[] = { { sa6E, .209 }, H };
N l39n47[] = { { sc1A, .188 }, { sgcacf, .157 }, H };
N l39n49[] = { { scfg, 2.820 }, { scfc0g, 1.058 }, H };
N l39n51[] = { { sceBg, .494 }, H };
N l39n53[] = { { scfcdFg, 1.034 }, { sgc2Fc4, .251 }, { scacf, .157 }, H };
N l39n54[] = { { sAa6, .470 }, H };
N l39n55[] = { { sKc1, .595 }, { sge7, .167 }, { sfaR, .219 }, { scfc4a6, .329 }, H };
N l39n56[] = { { sc7cfg, .776 }, H };
N l39n57[] = { { sgcec1g, .376 }, H };
N l39n58[] = { { sa6g, 1.974 }, { sHc1g, .423 }, H };
N l39n59[] = { { sOc9, .313 }, H };
N l39n60[] = { { sHc9ce, .235 }, H };
N l39n61[] = { { scfHcf, .235 }, H };
N l39n62[] = { { sc7F, .157 }, H };
N l39n63[] = { { sCc1, .721 }, { sgEc1, .157 }, H };
N l39n64[] = { { sgcbcf, .188 }, H };
N l39n65[] = { { sc4Fg, .353 }, H };
N l39n67[] = { { sc1a4, .564 }, H };
N l39n69[] = { { sAc5, .313 }, { sc5ca, .188 }, H };
N l39n70[] = { { sga6g, .439 }, { sIcbc9, .282 }, { sFc4c5, .235 }, H };
N l39n71[] = { { sgf7, .167 }, H };
N l39n72[] = { { sIg, 1.175 }, { scfc7, .627 }, { sgc2a6cc, .209 }, { sc2a6cc, .235 }, H };
N l39n73[] = { { sgHa6, .407 }, H };
N l39n74[] = { { sgca, .125 }, H };
N l39n75[] = { { scec9, .752 }, { sAc5C, .282 }, H };
N l39n76[] = { { sDcf, .219 }, H };
N l39n78[] = { { scbc9g, 1.128 }, H };
N l39n79[] = { { sf1g, .329 }, { sc2c1, .219 }, { sa6ccIcb, .251 }, { sc4cecf, .235 }, H };
N l39n81[] = { { sc1C, .501 }, H };
N l39n83[] = { { sgAc9, .188 }, H };
N l39n84[] = { { scbcf, .689 }, { sc9cdg, .353 }, H };
N l39n86[] = { { sLc1, .157 }, H };
N l39n87[] = { { se9g, .282 }, { sFcc, .157 }, H };
N l39n88[] = { { scfH, 1.128 }, { sc8g, .658 }, { scea6g, .917 }, { scdFg, .776 }, H };
N l39n89[] = { { sa7g, .345 }, H };
N l39n90[] = { { sgK, .836 }, { sc9D, .251 }, H };
N l39n91[] = { { sgcb, .543 }, { sAcfc4, .235 }, H };
N l39n92[] = { { sc1cdg, .353 }, H };
N l39n94[] = { { sc2Fc4c5, .313 }, H };
N l39n95[] = { { sGc5g, .917 }, { sRg, .282 }, { sKcec1, .282 }, H };
N l39n96[] = { { sc0g, 1.081 }, { scfc4c1, .235 }, H };
N l39n97[] = { { sa6H, .355 }, H };
N l39n98[] = { { sHc9, .721 }, { sgcdcf, .282 }, { sc1ccc5, .282 }, { sc1D, .188 }, H };
N l39n99[] = { { sc1c4, .282 }, { sc8cfc4, .282 }, { sc5cece, .235 }, { sEcfCa6, .313 }, H };
N l39n100[] = { { sEIg, 1.340 }, H };
N l39n101[] = { { sEc9g, 1.128 }, { sgcec5g, .334 }, { sc9ceg, .423 }, { sOcfcc, .282 }, H };
N l39n102[] = { { scbc1, .909 }, H };
N l39n103[] = { { scec5g, .705 }, { sc5cc, .251 }, H };
N l39n105[] = { { sa6c4c1, .188 }, H };
N l39n106[] = { { sc4ce, .407 }, H };
N l39n107[] = { { sc9E, .752 }, { sEcf, .721 }, H };
N l39n108[] = { { sgcc, .188 }, { sc1Gc5g, .658 }, { sgDEcf, .292 }, H };
N l39n109[] = { { sccc9g, .917 }, { scecb, .219 }, H };
N l39n110[] = { { sDB, .533 }, H };
N l39n111[] = { { sBg, 1.927 }, H };
N l39n113[] = { { sEcfC, .423 }, { sc4Acf, .235 }, H };
N l39n114[] = { { sgNcf, .470 }, H };
N l39n115[] = { { scccf, .752 }, { sc1E, .501 }, H };
N l39n116[] = { { sCa6, .439 }, { sccc0, .157 }, H };
N l39n118[] = { { sc1Ec9g, .564 }, { seag, .235 }, H };
N l39n119[] = { { sc9g, 3.760 }, { sceFg, .353 }, H };
N l39n120[] = { { sc5cd, .282 }, H };
N l39n122[] = { { scfHa6, .611 }, { sgfa, .251 }, { sgBcb, .282 }, H };
N l39n123[] = { { sc4cf, 1.034 }, { sHa6c4, .611 }, { sgeb, .167 }, H };
N l39n125[] = { { sgcd, .543 }, { sEc1, .721 }, H };
N l39n127[] = { { sc1g, 3.854 }, H };
N l39n129[] = { { sa6cecb, .188 }, H };
N l39n130[] = { { sNcf, .533 }, { scfcccf, .470 }, { sCE, .282 }, H };
N l39n131[] = { { sgOcf, .251 }, { sCc5, .188 }, H };
N l39n132[] = { { sc2a6, .407 }, { sa6ca, .146 }, { scccfD, .235 }, H };
N l39n133[] = { { sccc1, .439 }, H };
N l39n134[] = { { sKg, .611 }, { sDEcf, .376 }, { sIDBg, .470 }, H };
N l39n135[] = { { sgHg, .533 }, H };
N l39n136[] = { { scfa7g, .635 }, { sEIDB, .313 }, H };
N l39n137[] = { { sc5ce, .533 }, { sAc9, .282 }, H };
N l39n139[] = { { scfK, .219 }, H };
N l39n140[] = { { scfcb, .251 }, { sc4A, .219 }, { scdc9g, .494 }, { sc4cea6, .235 }, H };
N l39n141[] = { { sc4c1, .627 }, { sgN, .376 }, { scfc7cfg, 1.034 }, H };
N l39n142[] = { { sgce, .710 }, { sCg, .329 }, { sc1ccc9, .329 }, H };
N l39n146[] = { { scdcf, .439 }, H };
N l39n147[] = { { sCF, .251 }, { sDa6, .188 }, H };
N l39n148[] = { { sHL, .157 }, H };
N l39n149[] = { { sgAcf, .783 }, { sccB, .407 }, { sc1G, .345 }, { sa6cb, .146 }, { sgHa6c4, .251 }, H };
N l39n150[] = { { scag, 1.128 }, H };
N l39n151[] = { { sKc1g, .353 }, H };
N l39n152[] = { { scbc1G, .329 }, H };
N l39n153[] = { { sc4c1a4, .235 }, { sCcfc4, .235 }, H };
N l39n155[] = { { scba6, .282 }, { sceceB, .282 }, H };
N l39n157[] = { { scfcc, .627 }, H };
N l39n158[] = { { sgO, .355 }, { sc9H, .345 }, { sgHc5, .188 }, { sEC, .157 }, H };
N l39n159[] = { { sgcf, .334 }, { sc9c8, .219 }, H };
N l39n160[] = { { scece, .282 }, H };
N l39n161[] = { { sDE, .815 }, { sOcf, .345 }, H };
N l39n162[] = { { sAa6c4, .376 }, { scccfHa6, .376 }, { sDcfc2, .235 }, H };
N l39n163[] = { { sc3a6, .407 }, { sc2F, .407 }, { sIcb, .376 }, { sc1a4g, .846 }, H };
N l39n164[] = { { scdc1, .313 }, H };
N l39n165[] = { { sgKc1, .501 }, { sc5cag, .353 }, { sAc9E, .235 }, H };
N l39n166[] = { { sa6cc, .418 }, { sc1H, .501 }, { sgcbc1, .282 }, { sIcbc9g, .564 }, H };
N l39n167[] = { { sc1c8, .157 }, H };
N l39n171[] = { { sc5cea6, .235 }, H };
N l39n174[] = { { scfcd, .846 }, { sgee, .230 }, H };
N l39n176[] = { { sgA, 1.546 }, { scccfH, .329 }, H };
N l39n177[] = { { scecf, .439 }, { sgc1, .125 }, H };
N l39n178[] = { { sEa6, .345 }, { sDF, .219 }, H };
N l39n179[] = { { sc9EI, .376 }, { sOc1, .188 }, H };
N l39n181[] = { { scbg, .517 }, H };
N l39n182[] = { { sgAC, .564 }, H };
N l39n183[] = { { sgCcf, .219 }, H };
N l39n184[] = { { scfc4c9, .282 }, H };
N l39n186[] = { { scca6, .407 }, { sgKg, .282 }, { scbF, .251 }, H };
N l39n189[] = { { sFC, .188 }, H };
N l39n190[] = { { sHa6c4c1, .313 }, { sgc4ce, .157 }, H };
N l39n191[] = { { scfce, .282 }, H };
N l39n193[] = { { sgB, .292 }, { sEc5, .376 }, { sa6Hg, .517 }, { sc9ca, .313 }, H };
N l39n194[] = { { sgc2, .648 }, { sc4a6, .501 }, { sHc9g, .423 }, H };
N l39n195[] = { { scec1, 1.253 }, H };
N l39n197[] = { { sACc9, .329 }, { sccIcb, .282 }, H };
N l39n198[] = { { scbc1g, .917 }, { scfHa6c4, .376 }, H };
N l39n199[] = { { sCc9, .815 }, H };
N l39n200[] = { { sHcf, .564 }, { sa6ce, .355 }, { sgDcf, .219 }, { sHa6cb, .282 }, { sgcdc1, .188 }, H };
N l39n201[] = { { sgc4cf, .752 }, { sccc5, .376 }, H };
N l39n202[] = { { sBcb, .313 }, { sgHc9, .251 }, H };
N l39n204[] = { { sEg, .282 }, H };
N l39n205[] = { { sc5C, .627 }, H };
N l39n206[] = { { sDBg, 1.128 }, H };
N l39n207[] = { { sFc4, .533 }, { scfO, .219 }, H };
N l39n208[] = { { sgf0, .313 }, H };
N l39n209[] = { { scfc0, .470 }, { sc4c5, .407 }, { sOc5ce, .282 }, H };
N l39n210[] = { { sgC, .334 }, { sgNcfg, .501 }, { sc9cb, .376 }, { sgAa6, .376 }, { sOcfcccf, .376 }, H };
N l39n211[] = { { sgc3, .292 }, { sceB, .282 }, H };
N l39n212[] = { { sDH, .345 }, H };
N l39n213[] = { { scfcdF, .517 }, H };
N l39n214[] = { { sc5ceceB, .313 }, H };
N l39n215[] = { { sc2c9, .282 }, { smg, .104 }, H };
N l39n216[] = { { sc7cf, .658 }, { sNc5, .188 }, H };
N l39n217[] = { { sgcec1, .564 }, { sgEcf, .251 }, { sc1K, .219 }, H };
N l39n218[] = { { sHc1, .564 }, { sc1cb, .282 }, H };
N l39n219[] = { { sc4cfg, 1.058 }, { scfHa6cb, .376 }, H };
N l39n220[] = { { sc4g, .376 }, H };
N l39n225[] = { { sc4F, .376 }, { sgf1, .167 }, H };
N l39n226[] = { { sNcfg, .917 }, { sgS, .125 }, H };
N l39n227[] = { { sgD, .940 }, { sc9cc, .407 }, H };
N l39n228[] = { { sgc4, .982 }, { sgc2a6, .219 }, { sa6cag, .235 }, H };
N l39n229[] = { { sDI, .219 }, { sccc1g, .494 }, H };
N l39n230[] = { { sga6, .334 }, { sDc9, .188 }, H };
N l39n231[] = { { sgOcfcc, .251 }, { sIcf, .157 }, { scbc1Gc5, .313 }, H };
N l39n232[] = { { scfCcf, .517 }, H };
N l39n233[] = { { sgc2F, .376 }, H };
N l39n234[] = { { sc7c1, .345 }, H };
N l39n235[] = { { sFg, 2.115 }, { sc1cc, .752 }, H };
N l39n236[] = { { sDEc1, .282 }, H };
N l39n238[] = { { scbc9, .783 }, { sa6ccI, .251 }, H };
N l39n239[] = { { sAcf, 1.034 }, H };
N l39n240[] = { { sa4E, .125 }, H };
N l39n243[] = { { scdg, 1.457 }, { scfc2, .501 }, H };
N l39n244[] = { { sgE, .668 }, { sc9cd, .219 }, H };
N l39n245[] = { { sccBg, .423 }, { sHcfa7, .235 }, H };
N l39n246[] = { { sc4AcfH, .313 }, { sDHa6, .235 }, H };
N l39n247[] = { { sc8cf, .407 }, { sOc5, .313 }, H };
N l39n248[] = { { scea6, .564 }, { scdF, .407 }, H };
N l39n251[] = { { sc5g, 2.444 }, { sgAc1, .188 }, { sa6B, .125 }, { scfHc9, .282 }, { sceceBg, .470 }, H };
N l39n252[] = { { sa4g, .439 }, { sc1cd, .219 }, { sDEcfC, .313 }, { sgc7cf, .157 }, H };
N l39n253[] = { { sBce, .157 }, H };
N l39n255[] = { { sGc5, .439 }, { sgDE, .376 }, { sc9c8g, .494 }, H };

D l39_d = {
	"ukrainian",
	"koi8-r",
	{ W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, 0.001, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, 0.001, W, 0.001, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, W, W, W, W, W, W, W, W, W, W, W,
	    W, W, W, W, W, 0.001, W, W, 0.001, 0.007, W, W, W, W, W, W,
	    W, W, 0.001, 0.001, W, W, W, W, W, W, 0.001, W, W, W, W, W,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, Y, Y, Y, 0.023, Y, 0.176, 0.017, Y, Y, Y, Y, Y, Y, Y, Y,
	    Y, 0.001, Y, Y, 0.002, Y, Y, 0.001, Y, Y, Y, Y, Y, Y, Y, Y,
	    0.025, 0.335, 0.071, 0.034, 0.188, 0.181, 0.006, 0.060, 0.046, 0.278, 0.044, 0.152, 0.157, 0.110, 0.217, 0.421,
	    0.133, 0.098, 0.184, 0.137, 0.186, 0.140, 0.043, 0.241, 0.063, V, 0.080, 0.036, V, 0.033, 0.058, V,
	    V, 0.031, 0.011, 0.003, 0.016, 0.011, 0.001, 0.013, 0.001, 0.026, 0.006, 0.015, 0.014, 0.005, 0.023, 0.030,
	    0.021, 0.016, 0.020, 0.028, 0.026, 0.009, 0.001, 0.016, V, V, 0.019, 0.004, V, 0.001, 0.008, V },
	{ X, l39n1, X, l39n3, l39n4, l39n5, X, l39n7, X, X, l39n10, l39n11, l39n12, l39n13, l39n14, l39n15,
	    X, l39n17, l39n18, l39n19, l39n20, l39n21, l39n22, l39n23, X, l39n25, l39n26, X, l39n28, l39n29, l39n30, l39n31,
	    l39n32, l39n33, l39n34, l39n35, l39n36, l39n37, l39n38, l39n39, l39n40, l39n41, X, l39n43, l39n44, l39n45, l39n46, l39n47,
	    X, l39n49, X, l39n51, X, l39n53, l39n54, l39n55, l39n56, l39n57, l39n58, l39n59, l39n60, l39n61, l39n62, l39n63,
	    l39n64, l39n65, X, l39n67, X, l39n69, l39n70, l39n71, l39n72, l39n73, l39n74, l39n75, l39n76, X, l39n78, l39n79,
	    X, l39n81, X, l39n83, l39n84, X, l39n86, l39n87, l39n88, l39n89, l39n90, l39n91, l39n92, X, l39n94, l39n95,
	    l39n96, l39n97, l39n98, l39n99, l39n100, l39n101, l39n102, l39n103, X, l39n105, l39n106, l39n107, l39n108, l39n109, l39n110, l39n111,
	    X, l39n113, l39n114, l39n115, l39n116, X, l39n118, l39n119, l39n120, X, l39n122, l39n123, X, l39n125, X, l39n127,
	    X, l39n129, l39n130, l39n131, l39n132, l39n133, l39n134, l39n135, l39n136, l39n137, X, l39n139, l39n140, l39n141, l39n142, X,
	    X, X, l39n146, l39n147, l39n148, l39n149, l39n150, l39n151, l39n152, l39n153, X, l39n155, X, l39n157, l39n158, l39n159,
	    l39n160, l39n161, l39n162, l39n163, l39n164, l39n165, l39n166, l39n167, X, X, X, l39n171, X, X, l39n174, X,
	    l39n176, l39n177, l39n178, l39n179, X, l39n181, l39n182, l39n183, l39n184, X, l39n186, X, X, l39n189, l39n190, l39n191,
	    X, l39n193, l39n194, l39n195, X, l39n197, l39n198, l39n199, l39n200, l39n201, l39n202, X, l39n204, l39n205, l39n206, l39n207,
	    l39n208, l39n209, l39n210, l39n211, l39n212, l39n213, l39n214, l39n215, l39n216, l39n217, l39n218, l39n219, l39n220, X, X, X,
	    X, l39n225, l39n226, l39n227, l39n228, l39n229, l39n230, l39n231, l39n232, l39n233, l39n234, l39n235, l39n236, X, l39n238, l39n239,
	    l39n240, X, X, l39n243, l39n244, l39n245, l39n246, l39n247, l39n248, X, X, l39n251, l39n252, l39n253, X, l39n255 }
};

//
// DETECTING FUNCTIONS
//

static char valid_char_jump_table[256] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};
#undef p
#undef d
#undef g
#undef x
#undef z
#undef r
#undef i
#undef j
#undef k
#undef f

static double score_for_ngram(DetectorDescriptor * d, const unsigned char * ngram)
{
	const unsigned char * p = ngram;
	int xhash = *p * 31;
	p++;
	xhash += *p * 17;
	p++;
	if(*p)
	{
		xhash += *p * 11;
		p++;
		if(*p)
		{
			xhash += *p * 3;
		}
	}
	DetectorNGram * g = d->ngram_hash[xhash % 256];
	while(g->szNGram)
	{
		if(strcmp((const char *)ngram, (const char *)g->szNGram) == 0)
		{
			return g->dScore;
		}
		g++;
	}
	return 0.0;
}

static double compute_descriptor_score(const unsigned char * data, DetectorDescriptor * d)
{
	double dRet = 0.0;

	const unsigned char * p = data;
	while(*p)
	{
		unsigned char z = (unsigned char)tolower((char)*p);
		if(valid_char_jump_table[z])
			dRet += d->single_char_data[z];
		p++;
	}

	// now by hash...this is hard
	p = data;
	unsigned char buffer[1024]; // we handle words up to 1024 chars
	buffer[0] = ' ';            // we always start with a space
	while(*p)
	{
		while(*p && !valid_char_jump_table[*p])
			p++;
		int idx = 1;
		while(valid_char_jump_table[*p] && (idx < 1022))
		{
			buffer[idx] = (unsigned char)tolower((char)*p);
			p++;
			idx++;
		}
		buffer[idx] = ' '; // and we always end with a space
		idx++;
		buffer[idx] = 0; // and we null terminate
		// now run through the buffer checking the ngrams
		unsigned char * r = buffer + 2;
		while(*r)
		{
			unsigned char save = *r;
			*r = 0;
			// 4 letters ngram
			unsigned char * begin = r - 4;
			if(begin >= buffer)
				dRet += score_for_ngram(d, begin);
			// 3 letters ngram
			begin++;
			if(begin >= buffer)
				dRet += score_for_ngram(d, begin);
			// 2 letters ngram
			begin++;
			dRet += score_for_ngram(d, begin);
			*r = save;
			r++;
		}
	}
	return dRet;
}

#define NUM_DESCRIPTORS 40

static DetectorDescriptor * all_descriptors[NUM_DESCRIPTORS] = {
	&l0_d, &l1_d, &l2_d, &l3_d, &l4_d, &l5_d, &l6_d, &l7_d, &l8_d, &l9_d,
	&l10_d, &l11_d, &l12_d, &l13_d, &l14_d, &l15_d, &l16_d, &l17_d, &l18_d, &l19_d,
	&l20_d, &l21_d, &l22_d, &l23_d, &l24_d, &l25_d, &l26_d, &l27_d, &l28_d, &l29_d,
	&l30_d, &l31_d, &l32_d, &l33_d, &l34_d, &l35_d, &l36_d, &l37_d, &l38_d, &l39_d
};

#define NEED_ONE_CHAR             \
	p++;                          \
	if(*p < 0x80)                 \
	{                             \
		score--;                  \
		return score; /* error */ \
	}

static int utf8score(const unsigned char * p)
{
	int score = 0;
	int highchars = 0;
	while(*p)
	{
		if(*p < 0x80)
		{
			p++;
		}
		else if((*p & 0xe0) == 0xc0)
		{
			// 2 bytes encoding
			NEED_ONE_CHAR
			p++;
			highchars++;
		}
		else if((*p & 0xf0) == 0xe0)
		{
			// 3 bytes encoding
			NEED_ONE_CHAR
			NEED_ONE_CHAR
			p++;
			highchars++;
		}
		else if((*p & 0xf8) == 0xf0)
		{
			// 4 bytes encoding
			NEED_ONE_CHAR
			NEED_ONE_CHAR
			NEED_ONE_CHAR
			p++;
			highchars++;
		}
		else
		{
			score--;
			if(score < -50)
				return score;
			p++;
		}
	}
	if(score >= 0)
	{
		score = highchars / 10;
		if(score > 50)
			score = 50;
	}
	return score;
}

static const char * unknown_string = "?";
} // namespace

void detect_language_and_encoding(const char * data, LanguageAndEncodingResult * retBuffer, int iFlags = 0)
{
	int i;
	DetectorDescriptor * match[DLE_NUM_BEST_MATCHES];
	for(i = 0; i < DLE_NUM_BEST_MATCHES; i++)
	{
		retBuffer->match[i].szLanguage = nullptr;
		retBuffer->match[i].szEncoding = nullptr;
		retBuffer->match[i].dScore = -99999999999.9;
		match[i] = nullptr;
	}
	retBuffer->dAccuracy = 0.0;

	int utf8 = utf8score((const unsigned char *)data);
	i = 0;
	while(i < NUM_DESCRIPTORS)
	{
		bool bIsUtf8 = ((strcmp(all_descriptors[i]->szEncoding, "utf8") == 0) || (strcmp(all_descriptors[i]->szEncoding, "utf-8") == 0));
		if((!bIsUtf8) || (!(iFlags & DLE_STRICT_UTF8_CHECKING)))
		{
			double dThis = compute_descriptor_score((const unsigned char *)data, all_descriptors[i]);
			if(bIsUtf8)
			{
				dThis *= 1.0 + (((double)utf8) * 0.01);
			}
			else
			{
				if(utf8 < 0)
					dThis *= 1.1; // probably it is not utf8...
				else if(utf8 > 10)
					dThis *= 0.95; // might be utf8...privilege it
			}
			// update best matches
			for(int j = 0; j < DLE_NUM_BEST_MATCHES; j++)
			{
				if(dThis > retBuffer->match[j].dScore)
				{
					for(int k = DLE_NUM_BEST_MATCHES - 1; k > j; k--)
					{
						retBuffer->match[k].dScore = retBuffer->match[k - 1].dScore;
						match[k] = match[k - 1];
					}
					retBuffer->match[j].dScore = dThis;
					match[j] = all_descriptors[i];
					j = DLE_NUM_BEST_MATCHES; // stop looping
				}
			}
		}
		i++;
	}
	// compute accuracy and adjust language and encoding names
	double dScoreDiff = 0.0;
	double dTheoricMax = 0.0;
	for(i = 0; i < DLE_NUM_BEST_MATCHES; i++)
	{
		if(i > 0)
		{
			dScoreDiff += (retBuffer->match[0].dScore - retBuffer->match[i].dScore) / ((double)i);
			dTheoricMax += retBuffer->match[0].dScore / ((double)i);
		}
		retBuffer->match[i].szLanguage = match[i] ? match[i]->szLanguage : unknown_string;
		retBuffer->match[i].szEncoding = match[i] ? match[i]->szEncoding : unknown_string;
	}
	if(dTheoricMax > 0.0001)
		retBuffer->dAccuracy = 100.0 * dScoreDiff / dTheoricMax;
	else
		retBuffer->dAccuracy = 0.0;
}

/*
 * this file can be compiled also as a standalone app for testing
int main(int argc,char ** argv)
{
	FILE * f = fopen(argv[1],"r");
	if(!f){ printf("Can't open file\n"); return -1; };
	char buffer[4096];
	memset(buffer,0,4096);
	fread(buffer,1,4095,f);
	fclose(f);
	LanguageAndEncodingResult r;
	detect_language_and_encoding(buffer,&r,0);
	for(int i=0;i<DLE_NUM_BEST_MATCHES;i++)
		printf("LANGUAGE %s, ENCODING %s, SCORE: %f\n",r.match[i].szLanguage,r.match[i].szEncoding,r.match[i].dScore);
	printf("Accuracy: %f\n",r.dAccuracy);
	return 0;
}
*/
