% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.r
\name{DateUpdate}
\alias{DateUpdate}
\alias{update.POSIXt}
\title{Changes the components of a date object}
\usage{
\method{update}{POSIXt}(object, ..., simple = FALSE)
}
\arguments{
\item{object}{a date-time object}

\item{...}{named arguments: years, months, ydays, wdays, mdays, days, hours,
minutes, seconds, tzs (time zone compnent)}

\item{simple}{logical, passed to \code{fit_to_timeline}. If TRUE a simple fit
to time line is performed and no NA are produced for invalid dates. Invalid
dates are converted to meaningful dates by extrapolating the timezones.}
}
\value{
a date object with the requested elements updated. The object will
  retain its original class unless an element is updated which the original
  class does not support. In this case, the date returned will be a POSIXlt
  date object.
}
\description{
\code{update.Date} and \code{update.POSIXt} return a date with the specified
elements updated.  Elements not specified will be left unaltered. update.Date
and update.POSIXt do not add the specified values to the existing date, they
substitute them for the appropriate parts of the existing date.
}
\examples{
date <- as.POSIXlt("2009-02-10")
update(date, year = 2010, month = 1, mday = 1)

update(date, year =2010, month = 13, mday = 1)

update(date, minute = 10, second = 3)
}
\keyword{chron}
\keyword{manip}

