% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof-phreg.R
\name{gofZ.phreg}
\alias{gofZ.phreg}
\alias{cumContr}
\title{GOF for Cox covariates in  PH regression}
\usage{
gofZ.phreg(
  formula,
  data,
  vars = NULL,
  offset = NULL,
  weights = NULL,
  breaks = 50,
  equi = FALSE,
  n.sim = 1000,
  silent = 1,
  ...
)
}
\arguments{
\item{formula}{formula for cox regression}

\item{data}{data for model}

\item{vars}{which variables to test for linearity}

\item{offset}{offset}

\item{weights}{weights}

\item{breaks}{number of breaks for cumulatives in covarirate direction}

\item{equi}{equidistant breaks  or not}

\item{n.sim}{number of simulations for score processes}

\item{silent}{to keep it absolutely silent, otherwise timing estimate will be prduced for longer jobs.}

\item{...}{Additional arguments to lower level funtions}
}
\description{
That is, computes 
\deqn{
 U(z,\tau) = \int_0^\tau M(z)^t d \hat M 
}
and resamples its asymptotic distribution.
}
\details{
This will show if the residuals are consistent with the model evaulated in the z covariate. 
M is here chosen based on a grid (z_1, ..., z_m) and the different columns are \eqn{I(Z_i \leq z_l)}.
for \eqn{l=1,...,m}. 
The process in z is resampled to find extreme values.  The time-points of evuluation is by default
50 points, chosen as 2%,4%,..., percentiles of the covariates.

The p-value is valid but depends on the chosen grid. When the number of break points are high
this will give the orginal test of Lin, Wei and Ying for linearity, that is also computed in 
the timereg package.
}
\examples{
library(mets)
data(TRACE)
set.seed(1)
TRACEsam <- blocksample(TRACE,idvar="id",replace=FALSE,100)

## cumulative sums in covariates, via design matrix mm
\donttest{ ## Reduce Ex.Timings
m1 <- gofZ.phreg(Surv(time,status==9)~strata(vf)+chf+wmi+age,data=TRACEsam)
summary(m1) 
plot(m1,type="z")
}
}
\author{
Thomas Scheike and Klaus K. Holst
}
