-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
procedure Find_Actual_Node
  (For_Formal                : in     Dictionary.Symbol;
   Named_Argument_Assoc_Node : in     STree.SyntaxNode;
   Expression_Node           :    out STree.SyntaxNode)
is
   It        : STree.Iterator;
   Next_Node : STree.SyntaxNode;
begin
   Expression_Node := STree.NullNode;

   It := STree.Find_First_Formal_Parameter_Node (From_Root => Named_Argument_Assoc_Node);
   while not STree.IsNull (It) loop
      Next_Node := Get_Node (It => It);
      --# assert Syntax_Node_Type (Next_Node, STree.Table) = SP_Symbols.identifier and
      --#   Next_Node = Get_Node (It) and
      --#   STree.Table = STree.Table~;
      if LexTokenManager.Lex_String_Case_Insensitive_Compare
        (Lex_Str1 => Dictionary.GetSimpleName (For_Formal),
         Lex_Str2 => Node_Lex_String (Node => Next_Node)) =
        LexTokenManager.Str_Eq then
         STree.Set_Node_Lex_String (Sym  => For_Formal,
                                    Node => Next_Node);
         Expression_Node := Next_Sibling (Current_Node => Parent_Node (Current_Node => Next_Node));
         exit;
      end if;
      It := STree.NextNode (It);
   end loop;
   -- ASSUME Expression_Node = expression OR NULL
   SystemErrors.RT_Assert
     (C       => Expression_Node = STree.NullNode or else Syntax_Node_Type (Node => Expression_Node) = SP_Symbols.expression,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Expression_Node = expression OR NULL in Find_Actual_Node");
end Find_Actual_Node;
