/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0xE3, 0xCD, 0xF3, 0x0E, 0x81, 0xA6, 0xDE, 0x0F, 0x38, 0xD4,
        0x06, 0x26, 0x41, 0x71, 0x90, 0xCF, 0xDF, 0x00, 0xB0, 0x1B,
        0xE9, 0x8B, 0x89, 0x8E, 0xB4, 0x9A, 0xCE, 0x4D, 0x7A, 0xBB,
        0x19, 0x9B, 0x22, 0xBC, 0xBF, 0xDC, 0x2F, 0x3B, 0x9D, 0xE3,
        0x96, 0xA8, 0x3F, 0xD4, 0xD0, 0x2F, 0xFA, 0x09, 0xC2, 0x52,
        0x33, 0x5C, 0x22, 0xF0, 0xB3, 0xF9, 0xCF, 0xEA, 0xEF, 0xBF,
        0xDF, 0x11, 0x83, 0x1E, 0xF0, 0x4C, 0x29, 0x96, 0x1B, 0x4C,
        0x8E, 0x8E, 0x63, 0xDA, 0x78, 0x99, 0xC2, 0x40, 0xBB, 0x49,
        0x93, 0x65, 0xF9, 0x1A, 0x13, 0x5D, 0xED, 0x6D, 0xB7, 0xDF,
        0xCE, 0xC4, 0x3B, 0xFC, 0xB6, 0xF4, 0x0D, 0x00, 0x39, 0x38,
        0x02, 0xE4, 0xFC, 0xE0, 0x9B, 0x52, 0x6E, 0xAB, 0xDD, 0x87,
        0xF7, 0x28, 0x4C, 0x0C, 0x34, 0x9E, 0x6B, 0x58, 0x97, 0x9C,
        0x2D, 0x75, 0xE6, 0xD5, 0xCA, 0xAE, 0x09, 0x42, 0x14, 0x38,
        0x7D, 0x5A, 0x1C, 0x77, 0x49, 0x34, 0xB8, 0x71, 0xCA, 0x6C,
        0x78, 0x6D, 0x75, 0x41, 0xC0, 0xA9, 0x88, 0x94, 0x8A, 0x2A,
        0x45, 0xE7, 0x80, 0xBA, 0xD4, 0x00, 0xF5, 0xA3, 0xF4, 0x46,
        0x89, 0xF2, 0xAC, 0xF9, 0x10, 0xB7, 0x5F, 0x8E, 0x0A, 0x4B,
        0xD7, 0xDA, 0xB1, 0x66, 0xCF, 0x42, 0x88, 0x93, 0xB8, 0xA8,
        0x8D, 0xC5, 0x95, 0x91, 0x36, 0x8C, 0x1E, 0x0D, 0x5C, 0xF2,
        0xE1, 0x02, 0xC5, 0x0C, 0x8A, 0x50, 0xF7, 0xF5, 0x3F, 0xDE,
        0x90, 0x75, 0x31, 0x96, 0x0F, 0xD0, 0xF9, 0x41, 0xC0, 0x2F,
        0x3C, 0xF2, 0xB4, 0x17, 0xA2, 0x7C, 0xEA, 0x7C, 0xFF, 0x2F,
        0x72, 0xE6, 0x2D, 0xB6, 0x33, 0x4C, 0x84, 0x66, 0x93, 0xBC,
        0xE3, 0xA9, 0xC0, 0xF7, 0x7B, 0xF0, 0xE6, 0xFC, 0x9D, 0x6B,
        0xDA, 0x68, 0xFB, 0x15, 0x55, 0xBA, 0x5C, 0x85, 0x48, 0x0C,
        0x17, 0xE9, 0x59, 0x00, 0xF4, 0xA3
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.55 */
