#! /usr/bin/ruby -w

# generate Outfile

ScTemplateConfig  = './subcommander/sc.ini'
ScOutfile         = './subcommander/config.cpp'

SmTemplateConfig  = './submerge/sm.ini'
SmOutfile         = './submerge/config.cpp'


def putBin( varName, varFile, out )

  out.print <<END
/*
 * #{varFile}
 *
 */

END
  out.print "static const unsigned char #{varName}[] = {"
  
  src = File.open( varFile, "rb" )

  cnt = 0;
  src.each_byte do
    | b |
    
    if cnt == 0
     out.print "\n"
     out.print "  "
    end
    
    out.printf( "0x%02x,", b )
    
    cnt = cnt+1

    if cnt == 16
      cnt = 0
    end
    
  end

  # undo the last ','
  out.pos = out.pos - 1
  out.print "\n};" 
  
end


def createConfig( template, outfile )

  out = File.open( outfile, "w" )
  
  out.print <<END_OF_HEADER
/* this file is a generated file.
 * 
 * generated at #{Time.now} by gen_conf.rb
 *
 * from  #{template}
 */

#ifndef _SC_CONFIG_CPP
#define _SC_CONFIG_CPP
  
  
END_OF_HEADER
  
  putBin( "defaultConf", template, out )
  
  out.print <<END_OF_FOOTER
  
  
#endif // _SC_CONFIG_CPP
END_OF_FOOTER
  
  out.close

end


createConfig( ScTemplateConfig, ScOutfile )
createConfig( SmTemplateConfig, SmOutfile )



