/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "RunningBookmarkTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/Bookmark.h"


void RunningBookmarkTest::setUp()
{
  _bm = new Bookmark(NULL);
}

void RunningBookmarkTest::tearDown()
{
  delete _bm;
}

void RunningBookmarkTest::runningSingle()
{
  _bm->setRunning(true);
  CPPUNIT_ASSERT_EQUAL( true, _bm->isRunning() );

  _bm->setRunning(false);
  CPPUNIT_ASSERT_EQUAL( false, _bm->isRunning() );
}

void RunningBookmarkTest::runningMultiple()
{
  _bm->setRunning(true);
  CPPUNIT_ASSERT_EQUAL( true, _bm->isRunning() );

  _bm->setRunning(true);
  CPPUNIT_ASSERT_EQUAL( true, _bm->isRunning() );


  _bm->setRunning(false);
  CPPUNIT_ASSERT_EQUAL( true, _bm->isRunning() );

  _bm->setRunning(false);
  CPPUNIT_ASSERT_EQUAL( false, _bm->isRunning() );
}
