/* ====================================================================
 * Copyright (c) 2006-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHCANVASITEMS_H
#define _SC_LOGGRAPHCANVASITEMS_H

// sc
#include "LogGraphNode.h"
namespace svn {
  class Revision;
}

// qt
#include <Qt3Support/Q3Canvas>
#include <QtCore/QString>


/**
 * base class for LogGraph canvas items.
 */
class LogGraphCanvasItem : public Q3CanvasRectangle
{
public:
  LogGraphCanvasItem( Q3Canvas* canvas );
  virtual ~LogGraphCanvasItem();

  virtual QString getPath() const = 0;
  virtual svn::Revision* getRev() const = 0;

  virtual QString getTooltip() const  = 0;
};


/**
 * a canvas item that represents a single revision in the log graph.
 */
class LogGraphCanvasRev : public LogGraphCanvasItem
{
  typedef LogGraphCanvasItem super;

public:
  LogGraphCanvasRev( Q3Canvas* canvas, LogGraphNodePtr node );

  void drawShape( QPainter &p );

  LogGraphNodePtr getNode() const;

  //LogGraphCanvasItem
  QString getPath() const;
  svn::Revision* getRev() const;
  QString getTooltip() const;

private:
  LogGraphNodePtr _node;
};


/**
 * a canvas item that represents a revision path in the log graph.
 */
class LogGraphCanvasPath : public LogGraphCanvasItem
{
  typedef LogGraphCanvasItem super;

public:
  LogGraphCanvasPath( Q3Canvas* canvas, const QString& initialName );

  void drawShape( QPainter &p );

  QString getFitName( QPainter &p );
  QString getFullName() const;
  void addNewName( const QString& name );

  //LogGraphCanvasItem
  QString getPath() const;
  svn::Revision* getRev() const;
  QString getTooltip() const;

private:
  QString _initialName;
  QString _newestName;
};


#endif // _SC_LOGGRAPHCANVASITEMS_H
